/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.pde.internal.ui.editor.text.XMLPartitionScanner;
import org.eclipse.pde.internal.ui.model.IDocumentAttribute;
import org.eclipse.pde.internal.ui.model.IDocumentNode;
import org.eclipse.pde.internal.ui.model.IDocumentTextNode;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MoveSourceEdit;
import org.eclipse.text.edits.MoveTargetEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;

public abstract class XMLInputContext
extends UTF8InputContext {
    protected HashMap fOperationTable = new HashMap();
    protected HashMap fMoveOperations = new HashMap();

    public XMLInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
    }

    protected IDocumentPartitioner createDocumentPartitioner() {
        DefaultPartitioner partitioner = new DefaultPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        return partitioner;
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (objects != null) {
            block5: for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                switch (event.getChangeType()) {
                    case 2: {
                        if (!(object instanceof IDocumentNode)) continue block5;
                        this.removeNode((IDocumentNode)object, ops);
                        continue block5;
                    }
                    case 1: {
                        if (!(object instanceof IDocumentNode)) continue block5;
                        this.insertNode((IDocumentNode)object, ops);
                        continue block5;
                    }
                    case 3: {
                        if (!(object instanceof IDocumentNode)) continue block5;
                        IDocumentNode node = (IDocumentNode)object;
                        IDocumentAttribute attr = node.getDocumentAttribute(event.getChangedProperty());
                        if (attr != null) {
                            this.addAttributeOperation(attr, ops, event);
                            continue block5;
                        }
                        if (event.getOldValue() instanceof IDocumentTextNode) {
                            this.addElementContentOperation((IDocumentTextNode)event.getOldValue(), ops);
                            continue block5;
                        }
                        if (!(event.getOldValue() instanceof IDocumentNode) || !(event.getNewValue() instanceof IDocumentNode)) continue block5;
                        this.modifyNode(node, ops, event);
                    }
                }
            }
        }
    }

    private void removeNode(IDocumentNode node, ArrayList ops) {
        TextEdit oldMove;
        TextEdit old = (TextEdit)this.fOperationTable.get(node);
        if (old != null) {
            ops.remove(old);
            this.fOperationTable.remove(node);
        }
        if ((oldMove = (TextEdit)this.fMoveOperations.get(node)) != null) {
            ops.remove(oldMove);
            this.fMoveOperations.remove(node);
        }
        if (node.getOffset() > -1) {
            DeleteEdit op = this.getDeleteNodeOperation(node);
            ops.add(op);
            this.fOperationTable.put(node, op);
        } else if (old == null && oldMove == null) {
            this.insertNode(node, ops);
        }
    }

    private void insertNode(IDocumentNode node, ArrayList ops) {
        InsertEdit op = null;
        if ((node = this.getHighestNodeToBeWritten(node)).getParentNode() == null) {
            op = new InsertEdit(0, node.write(true));
        } else if (node.getOffset() > -1) {
            op = new ReplaceEdit(node.getOffset(), node.getLength(), node.write(false));
        } else {
            op = this.insertAfterSibling(node);
            if (op == null) {
                op = this.insertAsFirstChild(node);
            }
        }
        TextEdit old = (TextEdit)this.fOperationTable.get(node);
        if (old != null) {
            ops.remove(old);
        }
        ops.add(op);
        this.fOperationTable.put(node, op);
    }

    private InsertEdit insertAfterSibling(IDocumentNode node) {
        for (IDocumentNode sibling = node.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getOffset() <= -1) continue;
            node.setLineIndent(sibling.getLineIndent());
            return new InsertEdit(sibling.getOffset() + sibling.getLength(), System.getProperty("line.separator") + node.write(true));
        }
        return null;
    }

    private InsertEdit insertAsFirstChild(IDocumentNode node) {
        int offset = node.getParentNode().getOffset();
        int length = this.getNextPosition(this.getDocumentProvider().getDocument((Object)this.getInput()), offset, '>');
        node.setLineIndent(node.getParentNode().getLineIndent() + 3);
        return new InsertEdit(offset + length + 1, System.getProperty("line.separator") + node.write(true));
    }

    private void modifyNode(IDocumentNode node, ArrayList ops, IModelChangedEvent event) {
        IDocumentNode node2;
        IDocumentNode oldNode = (IDocumentNode)event.getOldValue();
        IDocumentNode newNode = (IDocumentNode)event.getNewValue();
        IDocumentNode node1 = oldNode.getPreviousSibling() == null || oldNode.equals(newNode.getPreviousSibling()) ? oldNode : newNode;
        IDocumentNode iDocumentNode = node2 = node1.equals(oldNode) ? newNode : oldNode;
        if (node1.getOffset() < 0 && node2.getOffset() < 2) {
            TextEdit op = (TextEdit)this.fOperationTable.get(node1);
            if (op == null) {
                this.insertNode(node, ops);
            } else {
                TextEdit op2 = (TextEdit)this.fOperationTable.get(node2);
                ops.set(ops.indexOf(op), op2);
                ops.set(ops.indexOf(op2), op);
            }
        } else if (node1.getOffset() > -1 && node2.getOffset() > -1) {
            IRegion region = this.getMoveRegion(node1);
            MoveSourceEdit source = new MoveSourceEdit(region.getOffset(), region.getLength());
            region = this.getMoveRegion(node2);
            source.setTargetEdit(new MoveTargetEdit(region.getOffset()));
            MoveSourceEdit op = (MoveSourceEdit)this.fMoveOperations.get(node1);
            if (op != null) {
                ops.set(ops.indexOf(op), source);
            } else {
                op = (MoveSourceEdit)this.fMoveOperations.get(node2);
                if (op != null && op.getTargetEdit().getOffset() == source.getOffset()) {
                    this.fMoveOperations.remove(node2);
                    ops.remove(op);
                    return;
                }
                ops.add(source);
            }
            this.fMoveOperations.put(node1, source);
        } else {
            this.insertNode(node1.getOffset() < 0 ? node1 : node2, ops);
        }
    }

    private IRegion getMoveRegion(IDocumentNode node) {
        int offset = node.getOffset();
        int length = node.getLength();
        int i = 1;
        try {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
            while (true) {
                char ch;
                if (!Character.isWhitespace(ch = doc.get(offset - i, 1).toCharArray()[0])) {
                    --i;
                    break;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return new Region(offset - i, length + i);
    }

    private void addAttributeOperation(IDocumentAttribute attr, ArrayList ops, IModelChangedEvent event) {
        TextEdit oldOp;
        int offset = attr.getValueOffset();
        Object newValue = event.getNewValue();
        Serializable changedObject = attr;
        ReplaceEdit op = null;
        if (offset > -1) {
            if (newValue == null || newValue.toString().length() == 0) {
                int length = attr.getValueOffset() + attr.getValueLength() + 1 - attr.getNameOffset();
                op = this.getAttributeDeleteEditOperation(attr.getNameOffset(), length);
            } else {
                op = new ReplaceEdit(offset, attr.getValueLength(), this.getWritableString(event.getNewValue().toString()));
            }
        }
        if (op == null) {
            IDocumentNode node = attr.getEnclosingElement();
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
            if (node.getOffset() > -1) {
                changedObject = node;
                int len = this.getNextPosition(doc, node.getOffset(), '>');
                op = new ReplaceEdit(node.getOffset(), len + 1, node.writeShallow(this.shouldTerminateElement(doc, node.getOffset() + len)));
            } else {
                this.insertNode(node, ops);
                return;
            }
        }
        if ((oldOp = (TextEdit)this.fOperationTable.get(changedObject)) != null) {
            ops.remove(oldOp);
        }
        ops.add(op);
        this.fOperationTable.put(changedObject, op);
    }

    private void addElementContentOperation(IDocumentTextNode textNode, ArrayList ops) {
        ReplaceEdit op = null;
        Object changedObject = textNode;
        if (textNode.getOffset() > -1) {
            String newText = this.getWritableString(textNode.getText());
            op = new ReplaceEdit(textNode.getOffset(), textNode.getLength(), newText);
        } else {
            IDocumentNode parent = textNode.getEnclosingElement();
            if (parent.getOffset() > -1) {
                IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
                try {
                    String endChars = doc.get(parent.getOffset() + parent.getLength() - 2, 2);
                    if ("/>".equals(endChars)) {
                        this.insertNode(parent, ops);
                        return;
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                changedObject = parent;
                StringBuffer buffer = new StringBuffer(System.getProperty("line.separator"));
                for (int i = 0; i < parent.getLineIndent(); ++i) {
                    buffer.append(" ");
                }
                buffer.append("   " + this.getWritableString(textNode.getText()));
                int offset = parent.getOffset();
                int length = this.getNextPosition(doc, offset, '>');
                op = new InsertEdit(offset + length + 1, buffer.toString());
            } else {
                this.insertNode(parent, ops);
                return;
            }
        }
        TextEdit oldOp = (TextEdit)this.fOperationTable.get(changedObject);
        if (oldOp != null) {
            ops.remove(oldOp);
        }
        ops.add(op);
        this.fOperationTable.put(changedObject, op);
    }

    private boolean shouldTerminateElement(IDocument doc, int offset) {
        try {
            return doc.get(offset - 1, 1).toCharArray()[0] == '/';
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private int getNextPosition(IDocument doc, int offset, char ch) {
        int i = 0;
        try {
            i = 0;
            while (i + offset < doc.getLength() && ch != doc.get(offset + i, 1).toCharArray()[0]) {
                ++i;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return i;
    }

    private DeleteEdit getAttributeDeleteEditOperation(int offset, int length) {
        try {
            char ch;
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
            while (Character.isWhitespace(ch = doc.get(offset + length, 1).toCharArray()[0])) {
                ++length;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return new DeleteEdit(offset, length);
    }

    private DeleteEdit getDeleteNodeOperation(IDocumentNode node) {
        int offset = node.getOffset();
        int length = node.getLength();
        int indent = 0;
        try {
            char ch;
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
            int line = doc.getLineOfOffset(offset + length);
            while (true) {
                ch = doc.get(offset + length, 1).toCharArray()[0];
                if (doc.getLineOfOffset(offset + length) > line || !Character.isWhitespace(ch)) {
                    --length;
                    break;
                }
                ++length;
            }
            for (indent = 1; indent <= node.getLineIndent(); ++indent) {
                ch = doc.get(offset - indent, 1).toCharArray()[0];
                if (Character.isWhitespace(ch)) continue;
                --indent;
                break;
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return new DeleteEdit(offset - indent, length + indent);
    }

    private IDocumentNode getHighestNodeToBeWritten(IDocumentNode node) {
        IDocumentNode parent = node.getParentNode();
        if (parent == null) {
            return node;
        }
        if (parent.getOffset() > -1) {
            IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
            try {
                String endChars = doc.get(parent.getOffset() + parent.getLength() - 2, 2);
                return "/>".equals(endChars) ? parent : node;
            }
            catch (BadLocationException e) {
                return node;
            }
        }
        return this.getHighestNodeToBeWritten(parent);
    }

    protected void flushModel(IDocument doc) {
        Object object;
        this.removeUnnecessaryOperations();
        if (this.fOperationTable.size() == 1 && (object = this.fOperationTable.keySet().iterator().next()) instanceof IDocumentNode && this.fEditOperations.get(0) instanceof InsertEdit && ((IDocumentNode)object).getParentNode() == null) {
            doc.set(((IDocumentNode)object).write(true));
            this.fOperationTable.clear();
            this.fEditOperations.clear();
            return;
        }
        this.reorderInsertEdits(this.fEditOperations);
        this.fOperationTable.clear();
        this.fMoveOperations.clear();
        super.flushModel(doc);
    }

    protected abstract void reorderInsertEdits(ArrayList var1);

    protected void removeUnnecessaryOperations() {
        Iterator iter = this.fOperationTable.values().iterator();
        while (iter.hasNext()) {
            Object op;
            IDocumentNode node;
            Object object = iter.next();
            if (!(object instanceof IDocumentNode) || (node = (IDocumentNode)object).getOffset() <= -1) continue;
            IDocumentAttribute[] attrs = node.getNodeAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                op = this.fOperationTable.remove(attrs[i]);
                if (op == null) continue;
                this.fEditOperations.remove(op);
            }
            IDocumentTextNode textNode = node.getTextNode();
            if (textNode == null || (op = this.fOperationTable.remove(textNode)) == null) continue;
            this.fEditOperations.remove(op);
        }
    }

    public String getWritableString(String source) {
        StringBuffer buf = new StringBuffer();
        block7: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    continue block7;
                }
                case '<': {
                    buf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    buf.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    buf.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    buf.append("&quot;");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    protected HashMap getOperationTable() {
        return this.fOperationTable;
    }
}

