/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.Choice;
import org.eclipse.pde.internal.core.TargetPlatform;
import org.eclipse.pde.internal.core.ifeature.IFeatureEntry;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.FeaturePropertySource;
import org.eclipse.pde.internal.ui.editor.feature.PortabilityChoiceDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class FeatureEntryPropertySource
extends FeaturePropertySource {
    protected Vector descriptors;
    public static final String KEY_ID = "FeatureEditor.ReferenceProp.id";
    public static final String KEY_VERSION = "FeatureEditor.ReferenceProp.version";
    public static final String KEY_DOWNLOAD_SIZE = "FeatureEditor.ReferenceProp.download-size";
    public static final String KEY_INSTALL_SIZE = "FeatureEditor.ReferenceProp.install-size";
    private static final String P_ID = "id";
    private static final String P_OS = "os";
    private static final String P_WS = "ws";
    private static final String P_NL = "nl";
    private static final String P_ARCH = "arch";
    private static final String P_INSTALL_SIZE = "install-size";
    private static final String P_DOWNLOAD_SIZE = "download-size";

    public FeatureEntryPropertySource(IFeatureEntry entry) {
        super((IFeatureObject)entry);
    }

    protected void createPropertyDescriptors() {
        this.descriptors = new Vector();
        PropertyDescriptor desc = new PropertyDescriptor((Object)P_ID, PDEPlugin.getResourceString(KEY_ID));
        this.descriptors.addElement(desc);
        desc = this.createTextPropertyDescriptor(P_INSTALL_SIZE, PDEPlugin.getResourceString(KEY_INSTALL_SIZE));
        this.descriptors.addElement(desc);
        desc = this.createTextPropertyDescriptor(P_DOWNLOAD_SIZE, PDEPlugin.getResourceString(KEY_DOWNLOAD_SIZE));
        this.descriptors.addElement(desc);
        desc = this.createChoicePropertyDescriptor(P_OS, P_OS, FeatureEntryPropertySource.getOSChoices());
        this.descriptors.addElement(desc);
        desc = this.createChoicePropertyDescriptor(P_WS, P_WS, FeatureEntryPropertySource.getWSChoices());
        this.descriptors.addElement(desc);
        desc = this.createChoicePropertyDescriptor(P_NL, P_NL, FeatureEntryPropertySource.getNLChoices());
        this.descriptors.addElement(desc);
        desc = this.createChoicePropertyDescriptor(P_ARCH, P_ARCH, FeatureEntryPropertySource.getArchChoices());
        this.descriptors.addElement(desc);
    }

    public IFeatureEntry getEntry() {
        return (IFeatureEntry)this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.createPropertyDescriptors();
        }
        return this.toDescriptorArray(this.descriptors);
    }

    private PropertyDescriptor createChoicePropertyDescriptor(String name, String displayName, Choice[] choices) {
        return new PortabilityChoiceDescriptor(name, displayName, choices, !this.isEditable());
    }

    public Object getPropertyValue(Object name) {
        if (name.equals(P_ID)) {
            return this.getEntry().getId();
        }
        if (name.equals(P_INSTALL_SIZE)) {
            long installSize = this.getEntry().getInstallSize();
            if (installSize == -1L) {
                return "";
            }
            return "" + installSize;
        }
        if (name.equals(P_DOWNLOAD_SIZE)) {
            long downloadSize = this.getEntry().getDownloadSize();
            if (downloadSize == -1L) {
                return "";
            }
            return "" + downloadSize;
        }
        if (name.equals(P_OS)) {
            return this.getEntry().getOS();
        }
        if (name.equals(P_WS)) {
            return this.getEntry().getWS();
        }
        if (name.equals(P_NL)) {
            return this.getEntry().getNL();
        }
        if (name.equals(P_ARCH)) {
            return this.getEntry().getArch();
        }
        return null;
    }

    public void setElement(IFeatureEntry entry) {
        this.object = entry;
    }

    public void setPropertyValue(Object name, Object value) {
        String svalue = value.toString();
        String realValue = svalue == null | svalue.length() == 0 ? null : svalue;
        try {
            if (name.equals(P_OS)) {
                this.getEntry().setOS(realValue);
            } else if (name.equals(P_WS)) {
                this.getEntry().setWS(realValue);
            } else if (name.equals(P_NL)) {
                this.getEntry().setNL(realValue);
            } else if (name.equals(P_ARCH)) {
                this.getEntry().setArch(realValue);
            } else if (name.equals(P_DOWNLOAD_SIZE)) {
                long lvalue = this.getLong(realValue);
                this.getEntry().setDownloadSize(lvalue);
            } else if (name.equals(P_INSTALL_SIZE)) {
                long lvalue = this.getLong(realValue);
                this.getEntry().setInstallSize(lvalue);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private long getLong(String svalue) {
        if (svalue == null) {
            return -1L;
        }
        try {
            return Long.parseLong(svalue);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public static Choice[] getOSChoices() {
        return TargetPlatform.getOSChoices();
    }

    public static Choice[] getWSChoices() {
        return TargetPlatform.getWSChoices();
    }

    public static Choice[] getArchChoices() {
        return TargetPlatform.getArchChoices();
    }

    public static Choice[] getNLChoices() {
        return TargetPlatform.getNLChoices();
    }
}

