/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.core.resources.IResource;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ModelEntryPropertySource
implements IPropertySource {
    private IPropertyDescriptor[] descriptors;
    private ModelEntry entry;

    public void setEntry(ModelEntry entry) {
        this.entry = entry;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new IPropertyDescriptor[8];
            this.descriptors[0] = new PropertyDescriptor((Object)"kind", "kind");
            this.descriptors[1] = new PropertyDescriptor((Object)"name", "name");
            this.descriptors[2] = new PropertyDescriptor((Object)"fragment", "fragment");
            this.descriptors[3] = new PropertyDescriptor((Object)"path", "path");
            this.descriptors[4] = new PropertyDescriptor((Object)"id", "id");
            this.descriptors[5] = new PropertyDescriptor((Object)"version", "version");
            this.descriptors[6] = new PropertyDescriptor((Object)"provider", "provider");
            this.descriptors[7] = new PropertyDescriptor((Object)"enabled", "enabled");
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object id) {
        String key = id.toString();
        IPluginModelBase model = this.entry.getActiveModel();
        IResource resource = model.getUnderlyingResource();
        if (key.equals("enabled")) {
            return model.isEnabled() ? "true" : "false";
        }
        if (key.equals("kind")) {
            return resource != null ? "workspace" : "external";
        }
        if (key.equals("fragment")) {
            return model.isFragmentModel() ? "yes" : "no";
        }
        if (key.equals("name")) {
            return model.getPluginBase().getTranslatedName();
        }
        if (key.equals("path")) {
            if (resource != null) {
                return resource.getLocation().toOSString();
            }
            return model.getInstallLocation();
        }
        if (key.equals("id")) {
            return model.getPluginBase().getId();
        }
        if (key.equals("version")) {
            return model.getPluginBase().getVersion();
        }
        if (key.equals("provider")) {
            return model.getPluginBase().getProviderName();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

