/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.jdt.internal.ui.actions.NewWizardsActionGroup;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.CollapseAllAction;
import org.eclipse.jdt.internal.ui.packageview.GotoPackageAction;
import org.eclipse.jdt.internal.ui.packageview.GotoRequiredProjectAction;
import org.eclipse.jdt.internal.ui.packageview.GotoResourceAction;
import org.eclipse.jdt.internal.ui.packageview.GotoTypeAction;
import org.eclipse.jdt.internal.ui.packageview.LayoutActionGroup;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.packageview.PackagesFrameSource;
import org.eclipse.jdt.internal.ui.packageview.ToggleLinkingAction;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.BuildActionGroup;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.ImportActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.NavigateActionGroup;
import org.eclipse.jdt.ui.actions.ProjectActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.UpAction;

class PackageExplorerActionGroup
extends CompositeActionGroup {
    private PackageExplorerPart fPart;
    private GoIntoAction fZoomInAction;
    private BackAction fBackAction;
    private ForwardAction fForwardAction;
    private UpAction fUpAction;
    private GotoTypeAction fGotoTypeAction;
    private GotoPackageAction fGotoPackageAction;
    private GotoResourceAction fGotoResourceAction;
    private CollapseAllAction fCollapseAllAction;
    private ToggleLinkingAction fToggleLinkingAction;
    private RefactorActionGroup fRefactorActionGroup;
    private NavigateActionGroup fNavigateActionGroup;
    private WorkingSetFilterActionGroup fWorkingSetFilterActionGroup;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private IAction fGotoRequiredProjectAction;

    public PackageExplorerActionGroup(PackageExplorerPart part) {
        this.fPart = part;
        TreeViewer viewer = part.getViewer();
        IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PackageExplorerActionGroup.this.doWorkingSetChanged(event);
            }
        };
        IWorkbenchPartSite site = this.fPart.getSite();
        Shell shell = site.getShell();
        ActionGroup[] actionGroupArray = new ActionGroup[12];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)site);
        this.fNavigateActionGroup = new NavigateActionGroup(this.fPart);
        actionGroupArray[1] = this.fNavigateActionGroup;
        actionGroupArray[2] = new CCPActionGroup(this.fPart);
        actionGroupArray[3] = new GenerateActionGroup(this.fPart);
        this.fRefactorActionGroup = new RefactorActionGroup(this.fPart);
        actionGroupArray[4] = this.fRefactorActionGroup;
        actionGroupArray[5] = new ImportActionGroup(this.fPart);
        actionGroupArray[6] = new BuildActionGroup(this.fPart);
        actionGroupArray[7] = new JavaSearchActionGroup(this.fPart);
        actionGroupArray[8] = new ProjectActionGroup(this.fPart);
        this.fWorkingSetFilterActionGroup = new WorkingSetFilterActionGroup("org.eclipse.jdt.ui.PackageExplorer", shell, workingSetListener);
        actionGroupArray[9] = this.fWorkingSetFilterActionGroup;
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup(this.fPart, (StructuredViewer)viewer);
        actionGroupArray[10] = this.fCustomFiltersActionGroup;
        actionGroupArray[11] = new LayoutActionGroup(part);
        this.setGroups(actionGroupArray);
        viewer.addFilter(this.fWorkingSetFilterActionGroup.getWorkingSetFilter());
        PackagesFrameSource frameSource = new PackagesFrameSource(this.fPart);
        FrameList frameList = new FrameList((IFrameSource)frameSource);
        frameSource.connectTo(frameList);
        this.fZoomInAction = new GoIntoAction(frameList);
        this.fBackAction = new BackAction(frameList);
        this.fForwardAction = new ForwardAction(frameList);
        this.fUpAction = new UpAction(frameList);
        this.fGotoTypeAction = new GotoTypeAction(this.fPart);
        this.fGotoPackageAction = new GotoPackageAction(this.fPart);
        this.fGotoResourceAction = new GotoResourceAction(this.fPart);
        this.fCollapseAllAction = new CollapseAllAction(this.fPart);
        this.fToggleLinkingAction = new ToggleLinkingAction(this.fPart);
        this.fGotoRequiredProjectAction = new GotoRequiredProjectAction(this.fPart);
    }

    public void dispose() {
        super.dispose();
    }

    void restoreFilterAndSorterState(IMemento memento) {
        this.fWorkingSetFilterActionGroup.restoreState(memento);
        this.fCustomFiltersActionGroup.restoreState(memento);
    }

    void saveFilterAndSorterState(IMemento memento) {
        this.fWorkingSetFilterActionGroup.saveState(memento);
        this.fCustomFiltersActionGroup.saveState(memento);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.setGlobalActionHandlers(actionBars);
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    void updateActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().removeAll();
        actionBars.getMenuManager().removeAll();
        this.fillActionBars(actionBars);
        actionBars.updateActionBars();
        this.fZoomInAction.setEnabled(true);
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("goInto", (IAction)this.fZoomInAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.fBackAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.fForwardAction);
        actionBars.setGlobalActionHandler("up", (IAction)this.fUpAction);
        actionBars.setGlobalActionHandler("goToResource", (IAction)this.fGotoResourceAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GoToType", (IAction)this.fGotoTypeAction);
        actionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.GoToPackage", (IAction)this.fGotoPackageAction);
        this.fRefactorActionGroup.retargetFileMenuActions(actionBars);
    }

    void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IAction)this.fBackAction);
        toolBar.add((IAction)this.fForwardAction);
        toolBar.add((IAction)this.fUpAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fCollapseAllAction);
        toolBar.add((IAction)this.fToggleLinkingAction);
    }

    void fillViewMenu(IMenuManager menu) {
        menu.add((IAction)this.fToggleLinkingAction);
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
    }

    void handleSelectionChanged(SelectionChangedEvent event) {
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        int size = selection.size();
        Object element = selection.getFirstElement();
        if (element instanceof ClassPathContainer.RequiredProjectWrapper) {
            menu.appendToGroup("group.show", this.fGotoRequiredProjectAction);
        }
        this.addGotoMenu(menu, element, size);
        this.addOpenNewWindowAction(menu, element);
        super.fillContextMenu(menu);
    }

    private void addGotoMenu(IMenuManager menu, Object element, int size) {
        boolean enabled = size == 1 && this.fPart.getViewer().isExpandable(element) && (this.isGoIntoTarget(element) || element instanceof IContainer);
        this.fZoomInAction.setEnabled(enabled);
        if (enabled) {
            menu.appendToGroup("group.goto", (IAction)this.fZoomInAction);
        }
    }

    private boolean isGoIntoTarget(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IJavaElement) {
            int type = ((IJavaElement)element).getElementType();
            return type == 2 || type == 3 || type == 4;
        }
        return false;
    }

    private void addOpenNewWindowAction(IMenuManager menu, Object element) {
        if (element instanceof IJavaElement) {
            element = ((IJavaElement)element).getResource();
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return;
        }
        if (!(element instanceof IContainer)) {
            return;
        }
        menu.appendToGroup("group.open", (IAction)new OpenInNewWindowAction(this.fPart.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)element)));
    }

    void handleDoubleClick(DoubleClickEvent event) {
        Object element;
        TreeViewer viewer = this.fPart.getViewer();
        if (viewer.isExpandable(element = ((IStructuredSelection)event.getSelection()).getFirstElement())) {
            if (this.doubleClickGoesInto()) {
                if (element instanceof ICompilationUnit || element instanceof IClassFile) {
                    return;
                }
                if (element instanceof IOpenable || element instanceof IContainer) {
                    this.fZoomInAction.run();
                }
            } else {
                IAction openAction = this.fNavigateActionGroup.getOpenAction();
                if (openAction != null && openAction.isEnabled() && OpenStrategy.getOpenMethod() == 0) {
                    return;
                }
                viewer.setExpandedState(element, !viewer.getExpandedState(element));
            }
        }
    }

    void handleOpen(OpenEvent event) {
        IAction openAction = this.fNavigateActionGroup.getOpenAction();
        if (openAction != null && openAction.isEnabled()) {
            openAction.run();
            return;
        }
    }

    void handleKeyEvent(KeyEvent event) {
        if (event.stateMask != 0) {
            return;
        }
        if (event.keyCode == 8 && this.fUpAction != null && this.fUpAction.isEnabled()) {
            this.fUpAction.run();
            event.doit = false;
        }
    }

    private void doWorkingSetChanged(PropertyChangeEvent event) {
        IWorkingSet workingSet = (IWorkingSet)event.getNewValue();
        String workingSetName = null;
        if (workingSet != null) {
            workingSetName = workingSet.getName();
        }
        this.fPart.setWorkingSetName(workingSetName);
        this.fPart.updateTitle();
        String property = event.getProperty();
        if ("workingSetContentChange".equals(property)) {
            TreeViewer viewer = this.fPart.getViewer();
            viewer.getControl().setRedraw(false);
            viewer.refresh();
            viewer.getControl().setRedraw(true);
        }
    }

    private boolean doubleClickGoesInto() {
        return "packageview.gointo".equals(PreferenceConstants.getPreferenceStore().getString("packageview.doubleclick"));
    }

    public FrameAction getUpAction() {
        return this.fUpAction;
    }

    public FrameAction getBackAction() {
        return this.fBackAction;
    }

    public FrameAction getForwardAction() {
        return this.fForwardAction;
    }

    public WorkingSetFilterActionGroup getWorkingSetActionGroup() {
        return this.fWorkingSetFilterActionGroup;
    }

    public CustomFiltersActionGroup getCustomFilterActionGroup() {
        return this.fCustomFiltersActionGroup;
    }
}

