/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import java.util.List;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.refactoring.nls.NLSUIMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class RenameKeysDialog
extends StatusDialog {
    private StringDialogField fNameField;
    private List fSelectedSubstitutions;
    private int fCommonPrefixLength;

    public RenameKeysDialog(Shell parent, List selectedSubstitutions) {
        super(parent);
        this.setTitle(NLSUIMessages.getString("RenameKeysDialog.title"));
        this.fSelectedSubstitutions = selectedSubstitutions;
        String prefix = this.getInitialPrefix(selectedSubstitutions);
        this.fCommonPrefixLength = prefix.length();
        this.fNameField = new StringDialogField();
        this.fNameField.setText(prefix);
        if (prefix.length() == 0) {
            this.fNameField.setLabelText(NLSUIMessages.getString("RenameKeysDialog.description.noprefix"));
        } else {
            this.fNameField.setLabelText(NLSUIMessages.getString("RenameKeysDialog.description.withprefix") + prefix + ':');
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fNameField.doFillIntoGrid(composite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fNameField.getTextControl(null));
        return composite;
    }

    protected void okPressed() {
        String prefix = this.fNameField.getText();
        for (int i = 0; i < this.fSelectedSubstitutions.size(); ++i) {
            NLSSubstitution sub = (NLSSubstitution)this.fSelectedSubstitutions.get(i);
            String newKey = prefix + sub.getKey().substring(this.fCommonPrefixLength);
            sub.setKey(newKey);
        }
        super.okPressed();
    }

    private String getInitialPrefix(List selectedSubstitutions) {
        String prefix = null;
        for (int i = 0; i < selectedSubstitutions.size(); ++i) {
            NLSSubstitution sub = (NLSSubstitution)selectedSubstitutions.get(i);
            String curr = sub.getKey();
            if (prefix == null) {
                prefix = curr;
                continue;
            }
            if (curr.startsWith(prefix) || (prefix = this.getCommonPrefix(prefix, curr)).length() != 0) continue;
            return prefix;
        }
        return prefix;
    }

    private String getCommonPrefix(String a, String b) {
        String shorter = a.length() <= b.length() ? a : b;
        int len = shorter.length();
        for (int i = 0; i < len; ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return a.substring(0, i);
        }
        return shorter;
    }
}

