/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates;

import org.eclipse.jface.text.Assert;

public class Template {
    private String fName;
    private String fDescription;
    private String fContextTypeId;
    private String fPattern;

    public Template() {
        this("", "", "", "");
    }

    public Template(Template template) {
        this(template.getName(), template.getDescription(), template.getContextTypeId(), template.getPattern());
    }

    public Template(String name, String description, String contextTypeId, String pattern) {
        this.setDescription(description);
        this.setName(name);
        this.setContextTypeId(contextTypeId);
        this.setPattern(pattern);
    }

    public int hashCode() {
        return this.fName.hashCode() ^ this.fPattern.hashCode() ^ this.fContextTypeId.hashCode();
    }

    public void setDescription(String description) {
        Assert.isNotNull(description);
        this.fDescription = description;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setContextTypeId(String contextTypeId) {
        Assert.isNotNull(contextTypeId);
        this.fContextTypeId = contextTypeId;
    }

    public String getContextTypeId() {
        return this.fContextTypeId;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public void setPattern(String pattern) {
        this.fPattern = pattern;
    }

    public String getPattern() {
        return this.fPattern;
    }

    public boolean matches(String prefix, String contextTypeName) {
        return this.fContextTypeId.equals(contextTypeName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Template)) {
            return false;
        }
        Template t = (Template)o;
        if (t == this) {
            return true;
        }
        return t.fName.equals(this.fName) && t.fPattern.equals(this.fPattern) && t.fContextTypeId.equals(this.fContextTypeId) && t.fDescription.equals(this.fDescription);
    }
}

