/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.ProductInfoDialog;

public final class AboutSystemDialog
extends ProductInfoDialog {
    private static final int BROWSE_ERROR_LOG_BUTTON = 1024;

    public AboutSystemDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(68720);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(WorkbenchMessages.getString("SystemSummary.title"));
        WorkbenchHelp.setHelp((Control)newShell, "org.eclipse.ui.system_summary_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1024, WorkbenchMessages.getString("AboutSystemDialog.browseErrorLogName"), false);
        new Label(parent, 0).setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        Text text = new Text(outer, 527114);
        text.setBackground(parent.getDisplay().getSystemColor(25));
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = this.convertVerticalDLUsToPixels(300);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        text.setLayoutData((Object)gridData);
        text.setText(this.getSystemSummary());
        return outer;
    }

    private String getSystemSummary() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println(WorkbenchMessages.format("SystemSummary.timeStamp", new Object[]{new Date()}));
        this.appendExtensions(writer);
        writer.close();
        return out.toString();
    }

    private void appendExtensions(PrintWriter writer) {
        IConfigurationElement[] configElements = this.getSortedExtensions();
        for (int i = 0; i < configElements.length; ++i) {
            IConfigurationElement element = configElements[i];
            Object obj = null;
            try {
                obj = WorkbenchPlugin.createExtension(element, "class");
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("could not create class attribute for extension", e.getStatus());
            }
            writer.println();
            writer.println(WorkbenchMessages.format("SystemSummary.sectionTitle", new Object[]{element.getAttribute("sectionTitle")}));
            if (obj instanceof ISystemSummarySection) {
                ISystemSummarySection logSection = (ISystemSummarySection)obj;
                logSection.write(writer);
                continue;
            }
            writer.println(WorkbenchMessages.getString("SystemSummary.sectionError"));
        }
    }

    private IConfigurationElement[] getSortedExtensions() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "systemSummarySections");
        Arrays.sort(configElements, new Comparator(){
            Collator collator = Collator.getInstance(Locale.getDefault());

            public int compare(Object a, Object b) {
                IConfigurationElement element1 = (IConfigurationElement)a;
                IConfigurationElement element2 = (IConfigurationElement)b;
                String id1 = element1.getAttribute("id");
                String id2 = element2.getAttribute("id");
                if (id1 != null && id2 != null && !id1.equals(id2)) {
                    return this.collator.compare(id1, id2);
                }
                String title1 = element1.getAttribute("sectionTitle");
                String title2 = element2.getAttribute("sectionTitle");
                if (title1 == null) {
                    title1 = "";
                }
                if (title2 == null) {
                    title2 = "";
                }
                return this.collator.compare(title1, title2);
            }
        });
        return configElements;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 12: {
                this.close();
                break;
            }
            case 1024: {
                this.openErrorLogBrowser();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void openErrorLogBrowser() {
        String filename = Platform.getLogFileLocation().toOSString();
        File log = new File(filename);
        if (log.exists()) {
            this.openLink(filename);
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)WorkbenchMessages.getString("AboutSystemDialog.noLogTitle"), (String)WorkbenchMessages.format("AboutSystemDialog.noLogMessage", new String[]{filename}));
    }
}

