/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.standalone;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Options {
    private static boolean debug = false;
    private static boolean useExe = true;
    private static File eclipseHome;
    private static File workspace;
    private static File lockFile;
    private static File hostPortFile;
    private static String vm;
    private static List vmArgs;
    private static List eclipseArgs;
    private static List helpCommand;
    private static String host;
    private static String port;

    public static void init(String appId, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            list.add(args[i]);
        }
        Options.init(appId, list);
    }

    public static void init(String appId, List options) {
        List vms;
        List ports;
        List homes;
        eclipseArgs = new ArrayList();
        eclipseArgs.addAll(options);
        helpCommand = Options.extractOption(eclipseArgs, "-command");
        if (helpCommand == null) {
            helpCommand = new ArrayList(0);
        }
        if (Options.getOption(eclipseArgs, "-debug") != null) {
            debug = true;
            System.out.println("Debugging is on.");
        }
        if (Options.extractOption(eclipseArgs, "-noexec") != null) {
            useExe = false;
        }
        if ((homes = Options.extractOption(eclipseArgs, "-eclipseHome")) == null || homes.isEmpty()) {
            homes = Options.extractOption(eclipseArgs, "-eclipse_Home");
        }
        eclipseHome = homes != null && !homes.isEmpty() ? new File((String)homes.get(0)) : new File(System.getProperty("user.dir"));
        List workspaces = Options.getOption(eclipseArgs, "-data");
        workspace = workspaces != null && !workspaces.isEmpty() ? new File((String)workspaces.get(0)) : new File(eclipseHome, "workspace");
        lockFile = new File(workspace, "/.metadata/.helplock");
        hostPortFile = new File(workspace, "/.metadata/.connection");
        List hosts = Options.extractOption(eclipseArgs, "-host");
        if (hosts != null && hosts.size() > 0) {
            host = (String)hosts.get(0);
        }
        if ((ports = Options.extractOption(eclipseArgs, "-port")) != null && ports.size() > 0) {
            port = (String)ports.get(0);
        }
        if ((vms = Options.extractOption(eclipseArgs, "-vm")) != null && !vms.isEmpty()) {
            vm = (String)vms.get(0);
        } else {
            String executable;
            String vmName = System.getProperty("java.vm.name");
            String string = executable = "J9".equals(vmName) ? "j9" : "java";
            if (System.getProperty("os.name").startsWith("Win")) {
                executable = !debug ? executable + "w.exe" : executable + ".exe";
            }
            vm = System.getProperty("java.home") + File.separator + "bin" + File.separator + executable;
        }
        vmArgs = new ArrayList(0);
        List passedVmArgs = Options.extractOption(eclipseArgs, "-vmargs");
        if (passedVmArgs != null && passedVmArgs.size() > 0) {
            vmArgs = passedVmArgs;
        }
        Options.extractOption(eclipseArgs, "-application");
        eclipseArgs.add(0, "-application");
        eclipseArgs.add(1, appId);
        Options.extractOption(eclipseArgs, "-showsplash");
        Options.extractOption(eclipseArgs, "-endsplash");
        Options.extractOption(eclipseArgs, "-nosplash");
        eclipseArgs.add(0, "-nosplash");
        if (host != null || port != null) {
            if (host != null) {
                vmArgs.add("-Dserver_host=" + host);
            }
            if (port != null) {
                vmArgs.add("-Dserver_port=" + port);
            }
        }
    }

    public static boolean isDebug() {
        return debug;
    }

    public static File getConnectionFile() {
        return hostPortFile;
    }

    public static File getLockFile() {
        return lockFile;
    }

    public static File getEclipseHome() {
        return eclipseHome;
    }

    public static File getWorkspace() {
        return workspace;
    }

    public static List getHelpCommand() {
        return helpCommand;
    }

    public static List getEclipseArgs() {
        return eclipseArgs;
    }

    private static List extractOption(List options, String optionName) {
        ArrayList values = null;
        int i = 0;
        while (i < options.size()) {
            if (optionName.equalsIgnoreCase((String)options.get(i))) {
                if (values == null) {
                    values = new ArrayList(1);
                }
                options.remove(i);
                while (i < options.size() && (!((String)options.get(i)).startsWith("-") || optionName.equals("-vmargs"))) {
                    values.add(options.get(i));
                    options.remove(i);
                }
                continue;
            }
            ++i;
        }
        return values;
    }

    private static List getOption(List options, String optionName) {
        ArrayList values = null;
        block0: for (int i = 0; i < options.size(); ++i) {
            if (!optionName.equalsIgnoreCase((String)options.get(i))) continue;
            if (values == null) {
                values = new ArrayList(1);
            }
            for (int j = i + 1; j < options.size(); ++j) {
                if (((String)options.get(j)).startsWith("-") && !optionName.equals("-vmargs")) {
                    i = j;
                    continue block0;
                }
                values.add(options.get(j));
            }
        }
        return values;
    }

    public static String getVm() {
        return vm;
    }

    public static List getVmArgs() {
        return vmArgs;
    }

    public static boolean useExe() {
        return useExe;
    }
}

