/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.math.BigInteger;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.core.memory.IExtendedMemoryBlock;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryRenderer;
import org.eclipse.debug.internal.ui.views.memory.AbstractTableViewTabLabelProvider;
import org.eclipse.debug.internal.ui.views.memory.IFixedLengthOutputRenderer;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewCellModifier;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ViewTabCursorManager {
    private TableCursor fTableCursor;
    private MemoryViewTab fViewTab;
    private MenuManager fMenuManager;
    protected int fRow;
    protected int fCol;
    private TableEditor editor;
    private boolean fMenuDisposed = false;
    private Table fTable;
    private TableViewer fTableViewer;
    private String fRenderingId;
    private IFixedLengthOutputRenderer fRenderer;
    private TraverseEventListener fTraverseEvtListener;
    private TextFocusListener fTextFocusListener;
    private TextKeyListener fTextKeyListener;
    private MouseEventListener fMouseEventListener;

    public ViewTabCursorManager(MemoryViewTab viewTab, int initialRow, int initialCol, MenuManager menuManager) {
        AbstractMemoryRenderer renderer;
        this.fViewTab = viewTab;
        this.fMenuManager = menuManager;
        this.fRow = initialRow;
        this.fCol = initialCol;
        this.fTableViewer = viewTab.getTableViewer();
        this.fTable = this.fTableViewer.getTable();
        this.editor = new TableEditor(this.fTable);
        this.fRenderingId = this.fViewTab.getRenderingId();
        IBaseLabelProvider labelProvider = this.fTableViewer.getLabelProvider();
        if (labelProvider instanceof AbstractTableViewTabLabelProvider && (renderer = ((AbstractTableViewTabLabelProvider)labelProvider).getRenderer()) instanceof IFixedLengthOutputRenderer) {
            this.fRenderer = (IFixedLengthOutputRenderer)((Object)renderer);
        }
        this.fTraverseEvtListener = new TraverseEventListener();
        this.fTextFocusListener = new TextFocusListener();
        this.fTextKeyListener = new TextKeyListener();
        this.fMouseEventListener = new MouseEventListener();
        this.fTable.addMouseListener((MouseListener)this.fMouseEventListener);
        this.createCursor();
    }

    private void createCursor() {
        this.fTableCursor = new TableCursor(this.fTable, 0);
        Display display = this.fTableCursor.getDisplay();
        this.fTableCursor.setBackground(display.getSystemColor(26));
        this.fTableCursor.setForeground(display.getSystemColor(27));
        this.updateCursorPosition(this.fRow, this.fCol, true);
        this.fTableCursor.setFont(JFaceResources.getFont((String)IInternalDebugUIConstants.FONT_NAME));
        this.fTableCursor.setVisible(true);
        this.fTableCursor.setFocus();
        this.fTableCursor.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ViewTabCursorManager.this.fTableCursor != null) {
                    ViewTabCursorManager.this.fViewTab.updateSyncTopAddress(true);
                    ViewTabCursorManager.this.fRow = ViewTabCursorManager.this.fTable.indexOf(ViewTabCursorManager.this.fTableCursor.getRow());
                    ViewTabCursorManager.this.fCol = ViewTabCursorManager.this.fTableCursor.getColumn();
                    ViewTabCursorManager.this.fViewTab.updateSelectedAddress(ViewTabCursorManager.this.fTableCursor.getRow(), ViewTabCursorManager.this.fTableCursor.getColumn());
                    ViewTabCursorManager.this.fViewTab.updateTableSelection();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fTableCursor.addTraverseListener((TraverseListener)this.fTraverseEvtListener);
        if (this.fMenuManager != null) {
            this.createContextMenu();
        }
        this.fTableCursor.addKeyListener((KeyListener)this.fViewTab);
        this.fTableCursor.addMouseListener((MouseListener)this.fMouseEventListener);
    }

    private Menu createContextMenu() {
        this.fMenuDisposed = false;
        Menu menu = this.fMenuManager.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
        if (this.fTableCursor != null) {
            TableCursor menuControl = this.fTableCursor;
            menuControl.setMenu(menu);
            menu.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ViewTabCursorManager.this.fMenuDisposed = true;
                    Menu disposedMenu = (Menu)e.getSource();
                    disposedMenu.removeDisposeListener((DisposeListener)this);
                }
            });
        }
        return menu;
    }

    public void redrawCursors() {
        if (this.fTableCursor != null && this.fTableCursor.isVisible()) {
            this.fTableCursor.setSelection(this.fRow, this.fCol);
            this.fTableCursor.redraw();
        }
    }

    public void dispose() {
        if (this.fTableCursor != null) {
            this.fTableCursor = null;
        }
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
        if (this.fTable != null) {
            this.fTable.removeMouseListener((MouseListener)this.fMouseEventListener);
        }
    }

    public TableCursor getLeadCursor() {
        return this.fTableCursor;
    }

    public void hideCursor() {
        this.fTableCursor.setVisible(false);
    }

    public void showCursor() {
        if (this.fTableCursor == null) {
            this.createCursor();
        }
        if (this.fMenuDisposed) {
            this.createContextMenu();
        }
        if (!this.fTableCursor.isVisible()) {
            this.fTableCursor.setVisible(true);
        }
    }

    public void setCursorFocus() {
        if (this.fTableCursor != null) {
            this.fTableCursor.setFocus();
        }
    }

    public void updateCursorPosition(int row, int col, boolean showCursor) {
        if (row < 0 || row >= this.fTable.getItemCount() || col < 0 || col >= this.fTable.getColumnCount()) {
            return;
        }
        this.fRow = row;
        this.fCol = col;
        this.fTableCursor.setSelection(row, col);
        if (showCursor) {
            this.showCursor();
        }
    }

    public void activateCellEditor(String initialValue) {
        if (this.fCol == 0 || this.fCol > this.getNumCol()) {
            return;
        }
        ICellModifier cellModifier = null;
        if (this.fTableViewer != null) {
            cellModifier = this.fTableViewer.getCellModifier();
        }
        TableItem tableItem = this.fTable.getItem(this.fRow);
        Object element = tableItem.getData();
        Object property = this.fTableViewer.getColumnProperties()[this.fCol];
        Object value = cellModifier.getValue(element, (String)property);
        ((MemoryViewCellModifier)cellModifier).setEditActionInvoked(true);
        boolean canEdit = cellModifier.canModify(element, (String)property);
        ((MemoryViewCellModifier)cellModifier).setEditActionInvoked(false);
        if (!canEdit) {
            return;
        }
        TextCellEditor selectedEditor = (TextCellEditor)this.fTableViewer.getCellEditors()[this.fCol];
        if (this.fTableViewer != null && cellModifier != null && selectedEditor != null && tableItem != null) {
            Text text = (Text)selectedEditor.getControl();
            String cellValue = null;
            cellValue = initialValue != null ? initialValue : (String)value;
            if (this.fRenderingId.equals("org.eclipse.debug.ui.rendering.raw_memory")) {
                cellValue = cellValue.toUpperCase();
            }
            text.setText(cellValue);
            this.editor.horizontalAlignment = 16384;
            this.editor.grabHorizontal = true;
            this.editor.setEditor((Control)text, tableItem, this.fCol);
            selectedEditor.setFocus();
            if (initialValue != null) {
                text.clearSelection();
            }
            text.setFont(JFaceResources.getFont((String)IInternalDebugUIConstants.FONT_NAME));
            this.addListeners(text);
            this.fTableCursor.moveBelow((Control)text);
        }
    }

    private int getNumCol() {
        int bytesPerLine = this.fViewTab.getBytesPerLine();
        int columnSize = this.fViewTab.getColumnSize();
        return bytesPerLine / columnSize;
    }

    private void modifyValue(int row, int col, String newValue) throws NumberFormatException {
        if (newValue.length() == 0) {
            return;
        }
        TableItem tableItem = this.fTable.getItem(row);
        Object property = this.fTableViewer.getColumnProperties()[col];
        Object element = tableItem.getData();
        ICellModifier cellModifier = this.fTableViewer.getCellModifier();
        String oldValue = (String)cellModifier.getValue(element, (String)property);
        if (this.fRenderingId.equals("org.eclipse.debug.ui.rendering.raw_memory")) {
            oldValue = oldValue.toUpperCase();
            if ((newValue = newValue.toUpperCase()).length() <= oldValue.length()) {
                oldValue = oldValue.substring(0, newValue.length());
            }
            if (!oldValue.equals(newValue)) {
                this.fTableViewer.getCellModifier().modify((Object)tableItem, (String)property, (Object)newValue);
            }
        } else {
            this.fTableViewer.getCellModifier().modify((Object)tableItem, (String)property, (Object)newValue);
        }
    }

    protected void setFont(Font font) {
        if (this.fTableCursor != null) {
            this.fTableCursor.setFont(font);
        }
    }

    private void addListeners(Text text) {
        text.addFocusListener((FocusListener)this.fTextFocusListener);
        text.addTraverseListener((TraverseListener)this.fTraverseEvtListener);
        text.addKeyListener((KeyListener)this.fTextKeyListener);
        text.addKeyListener((KeyListener)this.fViewTab);
    }

    private void removeListeners(Text text) {
        text.removeTraverseListener((TraverseListener)this.fTraverseEvtListener);
        text.removeFocusListener((FocusListener)this.fTextFocusListener);
        text.removeKeyListener((KeyListener)this.fTextKeyListener);
        text.removeKeyListener((KeyListener)this.fViewTab);
    }

    static /* synthetic */ void access$600(ViewTabCursorManager x0, Text x1) {
        x0.removeListeners(x1);
    }

    static /* synthetic */ void access$800(ViewTabCursorManager x0, int x1, int x2, String x3) throws NumberFormatException {
        x0.modifyValue(x1, x2, x3);
    }

    static /* synthetic */ IFixedLengthOutputRenderer access$1000(ViewTabCursorManager x0) {
        return x0.fRenderer;
    }

    class TextKeyListener
    implements KeyListener {
        TextKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent event) {
            if (event.getSource() instanceof Text) {
                this.handleTextKeyEvt(event);
            }
        }

        private void handleTextKeyEvt(KeyEvent event) {
            KeyEvent e = event;
            Display.getDefault().asyncExec(new Runnable(this, e){
                private final /* synthetic */ KeyEvent val$e;
                private final /* synthetic */ TextKeyListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    Text text = (Text)this.val$e.getSource();
                    try {
                        switch (this.val$e.keyCode) {
                            case 0x1000001: {
                                if (TextKeyListener.access$900((TextKeyListener)this.this$1).fRow - 1 < 0) {
                                    return;
                                }
                                ViewTabCursorManager.access$800(TextKeyListener.access$900(this.this$1), TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, text.getText());
                                --TextKeyListener.access$900((TextKeyListener)this.this$1).fRow;
                                TextKeyListener.access$900(this.this$1).updateCursorPosition(TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, true);
                                ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSyncTopAddress(true);
                                ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSelectedAddress(ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getRow(), ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getColumn());
                                ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateTableSelection();
                                ViewTabCursorManager.access$600(TextKeyListener.access$900(this.this$1), text);
                                TextKeyListener.access$900(this.this$1).activateCellEditor(null);
                                break;
                            }
                            case 0x1000002: {
                                if (TextKeyListener.access$900((TextKeyListener)this.this$1).fRow + 1 >= ViewTabCursorManager.access$500(TextKeyListener.access$900(this.this$1)).getItemCount()) {
                                    return;
                                }
                                ViewTabCursorManager.access$800(TextKeyListener.access$900(this.this$1), TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, text.getText());
                                ++TextKeyListener.access$900((TextKeyListener)this.this$1).fRow;
                                TextKeyListener.access$900(this.this$1).updateCursorPosition(TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, true);
                                ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSyncTopAddress(true);
                                ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSelectedAddress(ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getRow(), ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getColumn());
                                ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateTableSelection();
                                ViewTabCursorManager.access$600(TextKeyListener.access$900(this.this$1), text);
                                TextKeyListener.access$900(this.this$1).activateCellEditor(null);
                                break;
                            }
                            case 0: {
                                if (ViewTabCursorManager.access$1000(TextKeyListener.access$900(this.this$1)) != null && text.getText().length() > ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).getColumnSize() * ViewTabCursorManager.access$1000(TextKeyListener.access$900(this.this$1)).getNumCharPerByte()) {
                                    String newValue = text.getText();
                                    text.setText(newValue.substring(0, ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).getColumnSize() * ViewTabCursorManager.access$1000(TextKeyListener.access$900(this.this$1)).getNumCharPerByte()));
                                    ViewTabCursorManager.access$800(TextKeyListener.access$900(this.this$1), TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, text.getText());
                                    if (TextKeyListener.access$900((TextKeyListener)this.this$1).fCol >= ViewTabCursorManager.access$000(TextKeyListener.access$900(this.this$1))) {
                                        TextKeyListener.access$900((TextKeyListener)this.this$1).fCol = 1;
                                        ++TextKeyListener.access$900((TextKeyListener)this.this$1).fRow;
                                    } else {
                                        ++TextKeyListener.access$900((TextKeyListener)this.this$1).fCol;
                                    }
                                    TextKeyListener.access$900(this.this$1).updateCursorPosition(TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, true);
                                    ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSyncTopAddress(true);
                                    ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSelectedAddress(ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getRow(), ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getColumn());
                                    ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateTableSelection();
                                    ViewTabCursorManager.access$600(TextKeyListener.access$900(this.this$1), text);
                                    TextKeyListener.access$900(this.this$1).activateCellEditor(newValue.substring(ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).getColumnSize() * ViewTabCursorManager.access$1000(TextKeyListener.access$900(this.this$1)).getNumCharPerByte()));
                                }
                                break;
                            }
                            case 27: {
                                TextKeyListener.access$900(this.this$1).updateCursorPosition(TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, true);
                                ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSelectedAddress(ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getRow(), ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getColumn());
                                ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateTableSelection();
                                ViewTabCursorManager.access$600(TextKeyListener.access$900(this.this$1), text);
                                TextKeyListener.access$900(this.this$1).setCursorFocus();
                                break;
                            }
                            default: {
                                if (ViewTabCursorManager.access$1000(TextKeyListener.access$900(this.this$1)) != null && text.getText().length() > ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).getColumnSize() * ViewTabCursorManager.access$1000(TextKeyListener.access$900(this.this$1)).getNumCharPerByte()) {
                                    String newValue = text.getText();
                                    text.setText(newValue.substring(0, ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).getColumnSize() * ViewTabCursorManager.access$1000(TextKeyListener.access$900(this.this$1)).getNumCharPerByte()));
                                    ViewTabCursorManager.access$800(TextKeyListener.access$900(this.this$1), TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, text.getText());
                                    if (TextKeyListener.access$900((TextKeyListener)this.this$1).fCol >= ViewTabCursorManager.access$000(TextKeyListener.access$900(this.this$1))) {
                                        TextKeyListener.access$900((TextKeyListener)this.this$1).fCol = 1;
                                        ++TextKeyListener.access$900((TextKeyListener)this.this$1).fRow;
                                    } else {
                                        ++TextKeyListener.access$900((TextKeyListener)this.this$1).fCol;
                                    }
                                    TextKeyListener.access$900(this.this$1).updateCursorPosition(TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, true);
                                    ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSyncTopAddress(true);
                                    ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSelectedAddress(ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getRow(), ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getColumn());
                                    ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateTableSelection();
                                    ViewTabCursorManager.access$600(TextKeyListener.access$900(this.this$1), text);
                                    TextKeyListener.access$900(this.this$1).activateCellEditor(newValue.substring(ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).getColumnSize() * ViewTabCursorManager.access$1000(TextKeyListener.access$900(this.this$1)).getNumCharPerByte()));
                                }
                                break;
                            }
                        }
                    }
                    catch (NumberFormatException e1) {
                        MemoryViewUtil.openError(DebugUIMessages.getString("MemoryViewCellModifier.failure_title"), DebugUIMessages.getString("MemoryViewCellModifier.data_is_invalid"), null);
                        TextKeyListener.access$900(this.this$1).updateCursorPosition(TextKeyListener.access$900((TextKeyListener)this.this$1).fRow, TextKeyListener.access$900((TextKeyListener)this.this$1).fCol, true);
                        ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateSelectedAddress(ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getRow(), ViewTabCursorManager.access$300(TextKeyListener.access$900(this.this$1)).getColumn());
                        ViewTabCursorManager.access$200(TextKeyListener.access$900(this.this$1)).updateTableSelection();
                        ViewTabCursorManager.access$600(TextKeyListener.access$900(this.this$1), text);
                        TextKeyListener.access$900(this.this$1).showCursor();
                    }
                }
            });
        }

        public void keyReleased(KeyEvent e) {
        }

        static /* synthetic */ ViewTabCursorManager access$900(TextKeyListener x0) {
            return x0.ViewTabCursorManager.this;
        }
    }

    class TextFocusListener
    implements FocusListener {
        TextFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent event) {
            FocusEvent e = event;
            Display.getDefault().syncExec(new Runnable(this, e){
                private final /* synthetic */ FocusEvent val$e;
                private final /* synthetic */ TextFocusListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    try {
                        Text text = (Text)this.val$e.getSource();
                        ViewTabCursorManager.access$600(TextFocusListener.access$700(this.this$1), text);
                        String newValue = text.getText();
                        ViewTabCursorManager.access$800(TextFocusListener.access$700(this.this$1), TextFocusListener.access$700((TextFocusListener)this.this$1).fRow, TextFocusListener.access$700((TextFocusListener)this.this$1).fCol, newValue);
                        TextFocusListener.access$700(this.this$1).showCursor();
                    }
                    catch (NumberFormatException e1) {
                        MemoryViewUtil.openError(DebugUIMessages.getString("MemoryViewCellModifier.failure_title"), DebugUIMessages.getString("MemoryViewCellModifier.data_is_invalid"), null);
                    }
                }
            });
        }

        static /* synthetic */ ViewTabCursorManager access$700(TextFocusListener x0) {
            return x0.ViewTabCursorManager.this;
        }
    }

    class TraverseEventListener
    implements TraverseListener {
        TraverseEventListener() {
        }

        public void keyTraversed(TraverseEvent event) {
            if (event.getSource() instanceof Text) {
                this.handleTextTraverseEvt(event);
            } else if (event.getSource() instanceof TableCursor) {
                this.handleCursorTraverseEvt(event);
            }
        }

        private void handleTextTraverseEvt(TraverseEvent event) {
            TraverseEvent e = event;
            Display.getDefault().asyncExec(new Runnable(this, e){
                private final /* synthetic */ TraverseEvent val$e;
                private final /* synthetic */ TraverseEventListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$e = val$e;
                }

                public void run() {
                    try {
                        if (ViewTabCursorManager.access$200(TraverseEventListener.access$400(this.this$1)).getMemoryBlock() instanceof IExtendedMemoryBlock && (TraverseEventListener.access$400((TraverseEventListener)this.this$1).fRow + 1 >= ViewTabCursorManager.access$500(TraverseEventListener.access$400(this.this$1)).getItemCount() || TraverseEventListener.access$400((TraverseEventListener)this.this$1).fRow - 1 <= 0)) {
                            BigInteger topAddress = ViewTabCursorManager.access$200(TraverseEventListener.access$400(this.this$1)).getTopVisibleAddress();
                            ViewTabCursorManager.access$200(TraverseEventListener.access$400(this.this$1)).reloadTable(topAddress, false);
                        }
                    }
                    catch (DebugException e1) {
                        DebugUIPlugin.log(e1);
                        return;
                    }
                    if (this.val$e.detail == 16) {
                        if (!(ViewTabCursorManager.access$200(TraverseEventListener.access$400(this.this$1)).getMemoryBlock() instanceof IExtendedMemoryBlock) && TraverseEventListener.access$400((TraverseEventListener)this.this$1).fRow + 1 >= ViewTabCursorManager.access$500(TraverseEventListener.access$400(this.this$1)).getItemCount() && TraverseEventListener.access$400((TraverseEventListener)this.this$1).fCol == ViewTabCursorManager.access$000(TraverseEventListener.access$400(this.this$1))) {
                            return;
                        }
                        if (TraverseEventListener.access$400((TraverseEventListener)this.this$1).fCol == ViewTabCursorManager.access$000(TraverseEventListener.access$400(this.this$1))) {
                            TraverseEventListener.access$400((TraverseEventListener)this.this$1).fCol = 1;
                            ++TraverseEventListener.access$400((TraverseEventListener)this.this$1).fRow;
                        } else {
                            ++TraverseEventListener.access$400((TraverseEventListener)this.this$1).fCol;
                        }
                    } else if (this.val$e.detail == 8) {
                        if (!(ViewTabCursorManager.access$200(TraverseEventListener.access$400(this.this$1)).getMemoryBlock() instanceof IExtendedMemoryBlock) && TraverseEventListener.access$400((TraverseEventListener)this.this$1).fRow - 1 < 0 && TraverseEventListener.access$400((TraverseEventListener)this.this$1).fCol == 1) {
                            return;
                        }
                        if (TraverseEventListener.access$400((TraverseEventListener)this.this$1).fCol == 1) {
                            TraverseEventListener.access$400((TraverseEventListener)this.this$1).fCol = ViewTabCursorManager.access$000(TraverseEventListener.access$400(this.this$1));
                            --TraverseEventListener.access$400((TraverseEventListener)this.this$1).fRow;
                        } else {
                            --TraverseEventListener.access$400((TraverseEventListener)this.this$1).fCol;
                        }
                    } else {
                        return;
                    }
                    TraverseEventListener.access$400(this.this$1).updateCursorPosition(TraverseEventListener.access$400((TraverseEventListener)this.this$1).fRow, TraverseEventListener.access$400((TraverseEventListener)this.this$1).fCol, true);
                    ViewTabCursorManager.access$200(TraverseEventListener.access$400(this.this$1)).updateSyncTopAddress(true);
                    ViewTabCursorManager.access$200(TraverseEventListener.access$400(this.this$1)).updateSelectedAddress(ViewTabCursorManager.access$300(TraverseEventListener.access$400(this.this$1)).getRow(), ViewTabCursorManager.access$300(TraverseEventListener.access$400(this.this$1)).getColumn());
                    ViewTabCursorManager.access$200(TraverseEventListener.access$400(this.this$1)).updateTableSelection();
                    Text text = (Text)this.val$e.getSource();
                    ViewTabCursorManager.access$600(TraverseEventListener.access$400(this.this$1), text);
                    TraverseEventListener.access$400(this.this$1).activateCellEditor(null);
                }
            });
        }

        private void handleCursorTraverseEvt(TraverseEvent e) {
            if (ViewTabCursorManager.this.fCol == ViewTabCursorManager.this.getNumCol() && e.keyCode == 0x1000004) {
                if (ViewTabCursorManager.this.fRow + 1 >= ViewTabCursorManager.this.fTable.getItemCount()) {
                    return;
                }
                ++ViewTabCursorManager.this.fRow;
                ViewTabCursorManager.this.fCol = 0;
                ViewTabCursorManager.this.updateCursorPosition(ViewTabCursorManager.this.fRow, ViewTabCursorManager.this.fCol, true);
            }
            if (ViewTabCursorManager.this.fCol == 1 && e.keyCode == 0x1000003) {
                if (ViewTabCursorManager.this.fRow - 1 < 0) {
                    return;
                }
                --ViewTabCursorManager.this.fRow;
                ViewTabCursorManager.this.fCol = ViewTabCursorManager.this.getNumCol() + 1;
                ViewTabCursorManager.this.updateCursorPosition(ViewTabCursorManager.this.fRow, ViewTabCursorManager.this.fCol, true);
            }
        }

        static /* synthetic */ ViewTabCursorManager access$400(TraverseEventListener x0) {
            return x0.ViewTabCursorManager.this;
        }
    }

    class MouseEventListener
    implements MouseListener {
        MouseEventListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            if (e.getSource() instanceof Table) {
                this.handleTableMouseEvent(e);
            } else if (e.getSource() instanceof TableCursor) {
                this.handleCursorMouseEvent(e);
            }
        }

        private void handleCursorMouseEvent(MouseEvent e) {
            if (e.button == 1 && ViewTabCursorManager.this.fCol > 0 && ViewTabCursorManager.this.fCol <= ViewTabCursorManager.this.getNumCol()) {
                ViewTabCursorManager.this.activateCellEditor(null);
            }
        }

        private void handleTableMouseEvent(MouseEvent e) {
            TableItem[] selections = ViewTabCursorManager.this.fTableViewer.getTable().getSelection();
            TableItem selectedRow = null;
            int colNum = -1;
            if (selections.length > 0) {
                selectedRow = selections[0];
                int numCol = ViewTabCursorManager.this.fTableViewer.getColumnProperties().length;
                for (int i = 0; i < numCol; ++i) {
                    Rectangle bound = selectedRow.getBounds(i);
                    if (!bound.contains(e.x, e.y)) continue;
                    colNum = i;
                    break;
                }
            }
            if (colNum < 1) {
                return;
            }
            if (selectedRow != null) {
                int row = ViewTabCursorManager.this.fTableViewer.getTable().indexOf(selectedRow);
                ViewTabCursorManager.this.updateCursorPosition(row, colNum, true);
            }
            ViewTabCursorManager.this.fViewTab.updateSyncTopAddress(true);
            ViewTabCursorManager.this.fViewTab.updateSelectedAddress(ViewTabCursorManager.this.fTableCursor.getRow(), ViewTabCursorManager.this.fTableCursor.getColumn());
            ViewTabCursorManager.this.fViewTab.updateTableSelection();
            ViewTabCursorManager.this.setCursorFocus();
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

