/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.StreamsProxy;

public class RuntimeProcess
extends PlatformObject
implements IProcess {
    private static final int MAX_WAIT_FOR_DEATH_ATTEMPTS = 10;
    private static final int TIME_TO_WAIT_FOR_THREAD_DEATH = 500;
    private ILaunch fLaunch;
    private Process fProcess;
    private int fExitValue;
    private ProcessMonitorJob fMonitor;
    private IStreamsProxy fStreamsProxy;
    private String fName;
    private boolean fTerminated;
    private Map fAttributes;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IProcess;
    static /* synthetic */ Class class$org$eclipse$debug$core$model$IDebugTarget;

    public RuntimeProcess(ILaunch launch, Process process, String name, Map attributes) {
        this.setLaunch(launch);
        this.initializeAttributes(attributes);
        this.fProcess = process;
        this.fName = name;
        this.fTerminated = true;
        try {
            process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            this.fTerminated = false;
        }
        this.fStreamsProxy = this.createStreamsProxy();
        this.fMonitor = new ProcessMonitorJob(this);
        launch.addProcess(this);
        this.fireCreationEvent();
    }

    private void initializeAttributes(Map attributes) {
        if (attributes != null) {
            Iterator keys = attributes.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.setAttribute(key, (String)attributes.get(key));
            }
        }
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public String getLabel() {
        return this.fName;
    }

    protected void setLaunch(ILaunch launch) {
        this.fLaunch = launch;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    protected Process getSystemProcess() {
        return this.fProcess;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.isTerminated()) {
            this.fProcess.destroy();
            if (this.fStreamsProxy instanceof StreamsProxy) {
                ((StreamsProxy)this.fStreamsProxy).kill();
            }
            for (int attempts = 0; attempts < 10; ++attempts) {
                try {
                    if (this.fProcess != null) {
                        this.fExitValue = this.fProcess.exitValue();
                    }
                    return;
                }
                catch (IllegalThreadStateException ie) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (this.fMonitor != null) {
                this.fMonitor.killJob();
                this.fMonitor = null;
            }
            Status status = new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.getString("RuntimeProcess.terminate_failed"), null);
            throw new DebugException((IStatus)status);
        }
    }

    protected void terminated() {
        if (this.fStreamsProxy instanceof StreamsProxy) {
            ((StreamsProxy)this.fStreamsProxy).close();
        }
        this.fTerminated = true;
        try {
            this.fExitValue = this.fProcess.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        this.fProcess = null;
        this.fireTerminateEvent();
    }

    public IStreamsProxy getStreamsProxy() {
        return this.fStreamsProxy;
    }

    protected IStreamsProxy createStreamsProxy() {
        return new StreamsProxy(this.getSystemProcess());
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent(this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent(this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent(this, 16));
    }

    public void setAttribute(String key, String value) {
        Object origVal;
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        if ((origVal = this.fAttributes.get(key)) != null && origVal.equals(value)) {
            return;
        }
        this.fAttributes.put(key, value);
        this.fireChangeEvent();
    }

    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return (String)this.fAttributes.get(key);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(class$org$eclipse$debug$core$model$IProcess == null ? (class$org$eclipse$debug$core$model$IProcess = RuntimeProcess.class$("org.eclipse.debug.core.model.IProcess")) : class$org$eclipse$debug$core$model$IProcess)) {
            return this;
        }
        if (adapter.equals(class$org$eclipse$debug$core$model$IDebugTarget == null ? (class$org$eclipse$debug$core$model$IDebugTarget = RuntimeProcess.class$("org.eclipse.debug.core.model.IDebugTarget")) : class$org$eclipse$debug$core$model$IDebugTarget)) {
            ILaunch launch = this.getLaunch();
            IDebugTarget[] targets = launch.getDebugTargets();
            for (int i = 0; i < targets.length; ++i) {
                if (!this.equals(targets[i].getProcess())) continue;
                return targets[i];
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    public int getExitValue() throws DebugException {
        if (this.isTerminated()) {
            return this.fExitValue;
        }
        throw new DebugException((IStatus)new Status(4, DebugPlugin.getUniqueIdentifier(), 5010, DebugCoreMessages.getString("RuntimeProcess.Exit_value_not_available_until_process_terminates._1"), null));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ProcessMonitorJob
    extends Job {
        protected Process fOSProcess;
        protected RuntimeProcess fRuntimeProcess;
        protected Thread fThread;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            this.fThread = Thread.currentThread();
            while (this.fOSProcess != null) {
                try {
                    this.fOSProcess.waitFor();
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                }
                finally {
                    this.fOSProcess = null;
                    this.fRuntimeProcess.terminated();
                }
            }
            this.fThread = null;
            return Status.OK_STATUS;
        }

        public ProcessMonitorJob(RuntimeProcess process) {
            super(DebugCoreMessages.getString("ProcessMonitorJob.0"));
            this.setPriority(10);
            this.setSystem(true);
            this.fRuntimeProcess = process;
            this.fOSProcess = process.getSystemProcess();
            this.schedule();
        }

        protected void killJob() {
            if (this.fThread == null) {
                this.cancel();
            } else {
                this.fThread.interrupt();
            }
        }
    }
}

