/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;

public abstract class InternalSearchPattern {
    IJavaElement focus;
    int kind;
    boolean mustResolve = true;

    void acceptMatch(String documentName, SearchPattern pattern, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope) {
        String documentPath = Index.convertPath(documentName);
        if (scope.encloses(documentPath) && !requestor.acceptIndexMatch(documentPath, pattern, participant)) {
            throw new OperationCanceledException();
        }
    }

    SearchPattern currentPattern() {
        return (SearchPattern)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor monitor) throws IOException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            index.startQuery();
            SearchPattern pattern = this.currentPattern();
            EntryResult[] entries = pattern.queryIn(index);
            if (entries == null) {
                return;
            }
            SearchPattern decodedResult = pattern.getBlankPattern();
            int l = entries.length;
            for (int i = 0; i < l; ++i) {
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                EntryResult entry = entries[i];
                decodedResult.decodeIndexKey(entry.getWord());
                if (!pattern.matchesDecodedKey(decodedResult)) continue;
                String[] names = entry.getDocumentNames(index);
                int n = names.length;
                for (int j = 0; j < n; ++j) {
                    this.acceptMatch(names[j], decodedResult, requestor, participant, scope);
                }
            }
        }
        finally {
            index.stopQuery();
        }
    }

    boolean isPolymorphicSearch() {
        return false;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        SearchPattern pattern = (SearchPattern)this;
        return index.query(pattern.getIndexCategories(), pattern.getIndexKey(), pattern.getMatchRule());
    }
}

