/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.model;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.model.PluginMap;
import org.eclipse.core.internal.model.RegistryResolver;
import org.eclipse.core.internal.plugins.InternalPlatform;
import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;

public class PluginRegistryModel {
    protected PluginMap plugins = new PluginMap(new HashMap(30), false, true);
    protected PluginMap fragments = new PluginMap(new HashMap(30), false, true);
    private boolean readOnly = false;
    private boolean resolved = false;

    public void addFragment(PluginFragmentModel fragment) {
        this.assertIsWriteable();
        this.fragments.add(fragment);
    }

    public void addPlugin(PluginDescriptorModel plugin) {
        this.assertIsWriteable();
        this.plugins.add(plugin);
    }

    protected void assertIsWriteable() {
        Assert.isTrue((!this.isReadOnly() ? 1 : 0) != 0, (String)"Model is read-only");
    }

    public PluginFragmentModel getFragment(String id) {
        return (PluginFragmentModel)this.fragments.getAny(id);
    }

    public PluginFragmentModel getFragment(String id, String version) {
        return (PluginFragmentModel)this.fragments.get(id, version);
    }

    public PluginFragmentModel[] getFragments() {
        Object[] result = new PluginFragmentModel[this.fragments.size()];
        this.fragments.copyToArray(result);
        return result;
    }

    public PluginFragmentModel[] getFragments(String id) {
        List versions = this.fragments.getVersions(id);
        if (versions == null || versions.isEmpty()) {
            return new PluginFragmentModel[0];
        }
        return versions.toArray(new PluginFragmentModel[versions.size()]);
    }

    public PluginDescriptorModel getPlugin(String pluginId) {
        return (PluginDescriptorModel)this.plugins.getAny(pluginId);
    }

    public PluginDescriptorModel getPlugin(String pluginId, String version) {
        PluginDescriptorModel[] list = this.getPlugins(pluginId);
        if (list == null || list.length == 0) {
            return null;
        }
        if (version == null) {
            return list[0];
        }
        for (int i = 0; i < list.length; ++i) {
            PluginDescriptorModel element = list[i];
            if (!element.getVersion().equals(version)) continue;
            return element;
        }
        return null;
    }

    public PluginDescriptorModel[] getPlugins() {
        Object[] result = new PluginDescriptorModel[this.plugins.size()];
        this.plugins.copyToArray(result);
        return result;
    }

    public PluginDescriptorModel[] getPlugins(String pluginId) {
        List versions = this.plugins.getVersions(pluginId);
        if (versions == null || versions.isEmpty()) {
            return new PluginDescriptorModel[0];
        }
        return versions.toArray(new PluginDescriptorModel[versions.size()]);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void markReadOnly() {
        this.readOnly = true;
        this.plugins.markReadOnly();
        this.fragments.markReadOnly();
    }

    public void markResolved() {
        this.resolved = true;
    }

    public void removeFragment(String id, String version) {
        this.assertIsWriteable();
        this.fragments.remove(id, version);
    }

    public void removeFragments(String id) {
        this.assertIsWriteable();
        this.fragments.removeVersions(id);
    }

    public void removePlugin(String pluginId, String version) {
        this.assertIsWriteable();
        this.plugins.remove(pluginId, version);
    }

    public void removePlugins(String pluginId) {
        this.assertIsWriteable();
        this.plugins.removeVersions(pluginId);
    }

    public IStatus resolve(boolean trimDisabledPlugins, boolean doCrossLinking) {
        RegistryResolver resolver = new RegistryResolver();
        resolver.setTrimPlugins(trimDisabledPlugins);
        resolver.setCrossLink(doCrossLinking);
        return resolver.resolve(this);
    }

    public static PluginRegistryModel parsePlugins(URL[] pluginPath, Factory factory) {
        return InternalPlatform.parsePlugins(pluginPath, factory, false);
    }
}

