/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IGenericType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyType;
import org.eclipse.jdt.internal.core.util.ASTNodeFinder;
import org.eclipse.jdt.internal.core.util.ElementInfoConverter;
import org.eclipse.jdt.internal.core.util.HandleFactory;

public class HierarchyResolver
implements ITypeRequestor {
    private ReferenceBinding focusType;
    private boolean superTypesOnly;
    private boolean hasMissingSuperClass;
    LookupEnvironment lookupEnvironment;
    private CompilerOptions options;
    HierarchyBuilder requestor;
    private ReferenceBinding[] typeBindings;
    private int typeIndex;
    private IGenericType[] typeModels;

    public HierarchyResolver(INameEnvironment nameEnvironment, Map settings, HierarchyBuilder requestor, IProblemFactory problemFactory) {
        this.options = new CompilerOptions(settings);
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        ProblemReporter problemReporter = new ProblemReporter(policy, this.options, problemFactory);
        this.setEnvironment(new LookupEnvironment(this, this.options, problemReporter, nameEnvironment), requestor);
    }

    public HierarchyResolver(LookupEnvironment lookupEnvironment, HierarchyBuilder requestor) {
        this.setEnvironment(lookupEnvironment, requestor);
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding) {
        BinaryTypeBinding typeBinding = this.lookupEnvironment.createBinaryTypeFrom(binaryType, packageBinding);
        try {
            this.remember(binaryType, (ReferenceBinding)typeBinding);
        }
        catch (AbortCompilation e) {
            // empty catch block
        }
    }

    public void accept(ICompilationUnit sourceUnit) {
        this.lookupEnvironment.problemReporter.abortDueToInternalError(Util.bind("accept.cannot") + sourceUnit.getFileName());
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        CompilationResult result = new CompilationResult(sourceType.getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(new ISourceType[]{sourceType}, 8, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            try {
                this.lookupEnvironment.buildTypeBindings(unit);
                org.eclipse.jdt.core.ICompilationUnit cu = ((SourceTypeElementInfo)sourceType).getHandle().getCompilationUnit();
                this.rememberAllTypes(unit, cu, false);
                this.lookupEnvironment.completeTypeBindings(unit, true);
            }
            catch (AbortCompilation e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private IGenericType findSuperClass(IGenericType type, ReferenceBinding typeBinding) {
        ReferenceBinding superBinding = typeBinding.superclass();
        if (superBinding != null) {
            if (superBinding.id == 1 && typeBinding.isHierarchyInconsistent()) {
                int separator;
                char[] superclassName;
                if (type instanceof IBinaryType) {
                    superclassName = ((IBinaryType)type).getSuperclassName();
                    separator = 47;
                } else if (type instanceof ISourceType) {
                    superclassName = ((ISourceType)type).getSuperclassName();
                    separator = 46;
                } else if (type instanceof HierarchyType) {
                    superclassName = ((HierarchyType)type).superclassName;
                    separator = 46;
                } else {
                    return null;
                }
                if (superclassName != null) {
                    char[] simpleName;
                    void var5_6;
                    int lastSeparator = CharOperation.lastIndexOf((char)var5_6, superclassName);
                    char[] cArray = simpleName = lastSeparator == -1 ? superclassName : CharOperation.subarray(superclassName, lastSeparator + 1, superclassName.length);
                    if (!CharOperation.equals(simpleName, TypeConstants.OBJECT)) {
                        this.hasMissingSuperClass = true;
                        return new MissingType(new String(simpleName));
                    }
                }
            }
            for (int t = this.typeIndex; t >= 0; --t) {
                if (this.typeBindings[t] != superBinding) continue;
                return this.typeModels[t];
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private IGenericType[] findSuperInterfaces(IGenericType type, ReferenceBinding typeBinding) {
        void var3_3;
        int separator;
        Object superInterfaceNames;
        if (type instanceof IBinaryType) {
            superInterfaceNames = ((IBinaryType)type).getInterfaceNames();
            separator = 47;
        } else if (type instanceof ISourceType) {
            ISourceType sourceType = (ISourceType)type;
            superInterfaceNames = sourceType.getName().length == 0 ? (typeBinding.superInterfaces() != null && typeBinding.superInterfaces().length > 0 ? (Object)new char[][]{sourceType.getSuperclassName()} : sourceType.getInterfaceNames()) : sourceType.getInterfaceNames();
            separator = 46;
        } else if (type instanceof HierarchyType) {
            HierarchyType hierarchyType = (HierarchyType)type;
            superInterfaceNames = hierarchyType.name.length == 0 ? (typeBinding.superInterfaces() != null && typeBinding.superInterfaces().length > 0 ? (Object)new char[][]{hierarchyType.superclassName} : hierarchyType.superInterfaceNames) : hierarchyType.superInterfaceNames;
            separator = 46;
        } else {
            return null;
        }
        ReferenceBinding[] interfaceBindings = typeBinding.superInterfaces();
        int bindingIndex = 0;
        int bindingLength = interfaceBindings == null ? 0 : interfaceBindings.length;
        int length = var3_3 == null ? 0 : ((void)var3_3).length;
        IGenericType[] superinterfaces = new IGenericType[length];
        block0: for (int i = 0; i < length; ++i) {
            void var4_4;
            void superInterfaceName = var3_3[i];
            int lastSeparator = CharOperation.lastIndexOf((char)var4_4, (char[])superInterfaceName);
            char[] simpleName = (char[])(lastSeparator == -1 ? superInterfaceName : CharOperation.subarray((char[])superInterfaceName, lastSeparator + 1, ((void)superInterfaceName).length));
            int start = CharOperation.lastIndexOf('$', simpleName) + 1;
            if (start != 0) {
                int nameLength = simpleName.length - start;
                void v0 = simpleName;
                simpleName = new char[nameLength];
                System.arraycopy(v0, start, simpleName, 0, nameLength);
            }
            if (bindingIndex < bindingLength) {
                ReferenceBinding interfaceBinding = interfaceBindings[bindingIndex];
                if (CharOperation.equals(simpleName, interfaceBinding.sourceName)) {
                    ++bindingIndex;
                    for (int t = this.typeIndex; t >= 0; --t) {
                        if (this.typeBindings[t] != interfaceBinding) continue;
                        superinterfaces[i] = this.typeModels[t];
                        continue block0;
                    }
                }
            }
            superinterfaces[i] = new MissingType(new String(simpleName));
        }
        return superinterfaces;
    }

    private void remember(IGenericType suppliedType, ReferenceBinding typeBinding) {
        if (typeBinding == null) {
            return;
        }
        if (++this.typeIndex == this.typeModels.length) {
            this.typeModels = new IGenericType[this.typeIndex * 2];
            System.arraycopy(this.typeModels, 0, this.typeModels, 0, this.typeIndex);
            this.typeBindings = new ReferenceBinding[this.typeIndex * 2];
            System.arraycopy(this.typeBindings, 0, this.typeBindings, 0, this.typeIndex);
        }
        this.typeModels[this.typeIndex] = suppliedType;
        this.typeBindings[this.typeIndex] = typeBinding;
    }

    private void remember(IType type, ReferenceBinding typeBinding) {
        if (((CompilationUnit)type.getCompilationUnit()).isOpen()) {
            try {
                IGenericType genericType = (IGenericType)((JavaElement)((Object)type)).getElementInfo();
                this.remember(genericType, typeBinding);
            }
            catch (JavaModelException e) {
                return;
            }
        } else {
            if (typeBinding == null) {
                return;
            }
            TypeDeclaration typeDeclaration = ((SourceTypeBinding)typeBinding).scope.referenceType();
            char[] superclassName = null;
            TypeReference superclass = (typeDeclaration.bits & 0x200) != 0 ? typeDeclaration.allocation.type : typeDeclaration.superclass;
            if (superclass != null) {
                char[][] typeName = superclass.getTypeName();
                superclassName = typeName == null ? null : typeName[typeName.length - 1];
            }
            Object superInterfaceNames = null;
            TypeReference[] superInterfaces = typeDeclaration.superInterfaces;
            if (superInterfaces != null) {
                int length = superInterfaces.length;
                superInterfaceNames = new char[length][];
                for (int i = 0; i < length; ++i) {
                    TypeReference superInterface = superInterfaces[i];
                    char[][] typeName = superInterface.getTypeName();
                    superInterfaceNames[i] = typeName[typeName.length - 1];
                }
            }
            HierarchyType hierarchyType = new HierarchyType(type, !typeDeclaration.isInterface(), typeDeclaration.name, typeDeclaration.binding.modifiers, superclassName, (char[][])superInterfaceNames);
            this.remember(hierarchyType, (ReferenceBinding)typeDeclaration.binding);
        }
    }

    private void rememberAllTypes(CompilationUnitDeclaration parsedUnit, org.eclipse.jdt.core.ICompilationUnit cu, boolean includeLocalTypes) {
        TypeDeclaration[] types = parsedUnit.types;
        if (types != null) {
            int length = types.length;
            for (int i = 0; i < length; ++i) {
                TypeDeclaration type = types[i];
                this.rememberWithMemberTypes(type, cu.getType(new String(type.name)));
            }
        }
        if (includeLocalTypes && parsedUnit.localTypes != null) {
            HandleFactory factory = new HandleFactory();
            HashSet existingElements = new HashSet(parsedUnit.localTypeCount);
            HashMap knownScopes = new HashMap(parsedUnit.localTypeCount);
            for (int i = 0; i < parsedUnit.localTypeCount; ++i) {
                LocalTypeBinding localType = parsedUnit.localTypes[i];
                ClassScope classScope = localType.scope;
                TypeDeclaration typeDecl = classScope.referenceType();
                IType typeHandle = (IType)factory.createElement(classScope, cu, existingElements, knownScopes);
                this.rememberWithMemberTypes(typeDecl, typeHandle);
            }
        }
    }

    private void rememberWithMemberTypes(TypeDeclaration typeDecl, IType typeHandle) {
        this.remember(typeHandle, (ReferenceBinding)typeDecl.binding);
        TypeDeclaration[] memberTypes = typeDecl.memberTypes;
        if (memberTypes != null) {
            int length = memberTypes.length;
            for (int i = 0; i < length; ++i) {
                TypeDeclaration memberType = memberTypes[i];
                this.rememberWithMemberTypes(memberType, typeHandle.getType(new String(memberType.name)));
            }
        }
    }

    private void reportHierarchy(IType focus, CompilationUnitDeclaration parsedUnit, ReferenceBinding binaryTypeBinding) {
        if (focus != null) {
            if (binaryTypeBinding != null) {
                this.focusType = binaryTypeBinding;
            } else {
                TypeDeclaration typeDecl;
                Member declaringMember = ((Member)((Object)focus)).getOuterMostLocalContext();
                if (declaringMember == null) {
                    char[] fullyQualifiedName = focus.getFullyQualifiedName().toCharArray();
                    this.setFocusType(CharOperation.splitOn('.', fullyQualifiedName));
                } else if (parsedUnit != null && (typeDecl = new ASTNodeFinder(parsedUnit).findType(focus)) != null) {
                    this.focusType = typeDecl.binding;
                }
            }
        }
        int objectIndex = -1;
        for (int current = this.typeIndex; current >= 0; --current) {
            ReferenceBinding typeBinding = this.typeBindings[current];
            if (typeBinding.id == 1) {
                objectIndex = current;
                continue;
            }
            IGenericType suppliedType = this.typeModels[current];
            if (!this.subOrSuperOfFocus(typeBinding)) continue;
            IGenericType superclass = typeBinding.isInterface() ? null : this.findSuperClass(suppliedType, typeBinding);
            IGenericType[] superinterfaces = this.findSuperInterfaces(suppliedType, typeBinding);
            this.requestor.connect(suppliedType, superclass, superinterfaces);
        }
        if (!this.hasMissingSuperClass && objectIndex > -1) {
            this.requestor.connect(this.typeModels[objectIndex], null, null);
        }
    }

    private void reset() {
        this.lookupEnvironment.reset();
        this.focusType = null;
        this.superTypesOnly = false;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(IGenericType suppliedType) {
        try {
            if (suppliedType.isBinaryType()) {
                int startIndex;
                BinaryTypeBinding binaryTypeBinding = this.lookupEnvironment.cacheBinaryType((IBinaryType)suppliedType);
                this.remember(suppliedType, (ReferenceBinding)binaryTypeBinding);
                for (int i = startIndex = this.typeIndex; i <= this.typeIndex; ++i) {
                    IGenericType igType = this.typeModels[i];
                    if (igType == null || !igType.isBinaryType()) continue;
                    try {
                        ReferenceBinding typeBinding = this.typeBindings[i];
                        typeBinding.superclass();
                        typeBinding.superInterfaces();
                        continue;
                    }
                    catch (AbortCompilation e) {
                        // empty catch block
                    }
                }
                this.superTypesOnly = true;
                this.reportHierarchy(this.requestor.getType(), null, binaryTypeBinding);
            } else {
                org.eclipse.jdt.core.ICompilationUnit cu = ((SourceTypeElementInfo)suppliedType).getHandle().getCompilationUnit();
                HashSet<String> localTypes = new HashSet<String>();
                localTypes.add(cu.getPath().toString());
                this.superTypesOnly = true;
                this.resolve(new Openable[]{(Openable)((Object)cu)}, localTypes, null);
            }
        }
        catch (AbortCompilation abortCompilation) {
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve(Openable[] openables, HashSet localTypes, IProgressMonitor monitor) {
        try {
            char[] fullyQualifiedName;
            CompilationUnitDeclaration parsedUnit;
            int i;
            int openablesLength = openables.length;
            CompilationUnitDeclaration[] parsedUnits = new CompilationUnitDeclaration[openablesLength];
            boolean[] hasLocalType = new boolean[openablesLength];
            org.eclipse.jdt.core.ICompilationUnit[] cus = new org.eclipse.jdt.core.ICompilationUnit[openablesLength];
            int unitsIndex = 0;
            CompilationUnitDeclaration focusUnit = null;
            ReferenceBinding focusBinaryBinding = null;
            IType focus = this.requestor.getType();
            Openable focusOpenable = null;
            if (focus != null) {
                focusOpenable = focus.isBinary() ? (Openable)((Object)focus.getClassFile()) : (Openable)((Object)focus.getCompilationUnit());
            }
            Parser parser = new Parser(this.lookupEnvironment.problemReporter, true);
            for (i = 0; i < openablesLength; ++i) {
                Openable openable = openables[i];
                if (openable instanceof org.eclipse.jdt.core.ICompilationUnit) {
                    org.eclipse.jdt.core.ICompilationUnit cu = (org.eclipse.jdt.core.ICompilationUnit)((Object)openable);
                    boolean containsLocalType = false;
                    if (localTypes == null) {
                        containsLocalType = true;
                    } else {
                        IPath path = cu.getPath();
                        containsLocalType = localTypes.contains(path.toString());
                    }
                    CompilationUnitDeclaration parsedUnit2 = null;
                    if (cu.isOpen()) {
                        CompilationResult result = new CompilationResult(((ICompilationUnit)((Object)cu)).getFileName(), i, openablesLength, this.options.maxProblemsPerUnit);
                        ISourceType[] typeInfos = null;
                        try {
                            IType[] topLevelTypes = cu.getTypes();
                            int topLevelLength = topLevelTypes.length;
                            if (topLevelLength == 0) continue;
                            typeInfos = new SourceTypeElementInfo[topLevelLength];
                            for (int j = 0; j < topLevelLength; ++j) {
                                IType topLevelType = topLevelTypes[j];
                                typeInfos[j] = (SourceTypeElementInfo)((JavaElement)((Object)topLevelType)).getElementInfo();
                            }
                        }
                        catch (JavaModelException e) {
                            // empty catch block
                        }
                        if (!containsLocalType) {
                            parsedUnit2 = SourceTypeConverter.buildCompilationUnit(typeInfos, 8, this.lookupEnvironment.problemReporter, result);
                        } else {
                            parsedUnit2 = ElementInfoConverter.buildCompilationUnit((SourceTypeElementInfo[])typeInfos, true, this.lookupEnvironment.problemReporter, result);
                            parsedUnit2.bits |= 0x10;
                        }
                    } else {
                        IResource file = cu.getResource();
                        String osPath = file.getLocation().toOSString();
                        ICompilationUnit sourceUnit = this.requestor.createCompilationUnitFromPath(openable, osPath);
                        CompilationResult unitResult = new CompilationResult(sourceUnit, i, openablesLength, this.options.maxProblemsPerUnit);
                        parsedUnit2 = parser.dietParse(sourceUnit, unitResult);
                    }
                    if (parsedUnit2 == null) continue;
                    hasLocalType[unitsIndex] = containsLocalType;
                    cus[unitsIndex] = cu;
                    parsedUnits[unitsIndex++] = parsedUnit2;
                    try {
                        this.lookupEnvironment.buildTypeBindings(parsedUnit2);
                        if (!openable.equals(focusOpenable)) continue;
                        focusUnit = parsedUnit2;
                    }
                    catch (AbortCompilation e) {}
                    continue;
                }
                ClassFile classFile = (ClassFile)openable;
                IBinaryType binaryType = null;
                if (classFile.isOpen()) {
                    IType type = classFile.getType();
                    try {
                        binaryType = (IBinaryType)((JavaElement)((Object)type)).getElementInfo();
                    }
                    catch (JavaModelException e) {}
                } else if (classFile.getPackageFragmentRoot().isArchive()) {
                    binaryType = this.requestor.createInfoFromClassFileInJar(classFile);
                } else {
                    IResource file = classFile.getResource();
                    String osPath = file.getLocation().toOSString();
                    binaryType = this.requestor.createInfoFromClassFile(classFile, osPath);
                }
                if (binaryType == null) continue;
                try {
                    BinaryTypeBinding binaryTypeBinding = this.lookupEnvironment.cacheBinaryType(binaryType);
                    this.remember(binaryType, (ReferenceBinding)binaryTypeBinding);
                    if (!openable.equals(focusOpenable)) continue;
                    focusBinaryBinding = binaryTypeBinding;
                    continue;
                }
                catch (AbortCompilation e) {
                    // empty catch block
                }
            }
            for (i = 0; i <= this.typeIndex; ++i) {
                IGenericType suppliedType = this.typeModels[i];
                if (suppliedType == null || !suppliedType.isBinaryType()) continue;
                try {
                    ReferenceBinding typeBinding = this.typeBindings[i];
                    typeBinding.superclass();
                    typeBinding.superInterfaces();
                    continue;
                }
                catch (AbortCompilation e) {
                    // empty catch block
                }
            }
            for (i = 0; i < unitsIndex; ++i) {
                parsedUnit = parsedUnits[i];
                if (parsedUnit != null) {
                    try {
                        boolean containsLocalType = hasLocalType[i];
                        if (containsLocalType) {
                            parser.getMethodBodies(parsedUnit);
                        }
                        this.lookupEnvironment.completeTypeBindings(parsedUnit, true);
                    }
                    catch (AbortCompilation e) {
                        hasLocalType[i] = false;
                    }
                }
                this.worked(monitor, 1);
            }
            for (i = 0; i < unitsIndex; ++i) {
                parsedUnit = parsedUnits[i];
                if (parsedUnit == null) continue;
                boolean containsLocalType = hasLocalType[i];
                if (containsLocalType) {
                    parsedUnit.scope.faultInTypes();
                    parsedUnit.resolve();
                }
                this.rememberAllTypes(parsedUnit, cus[i], containsLocalType);
            }
            if (focusBinaryBinding == null && focus != null && focus.isBinary() && (focusBinaryBinding = this.lookupEnvironment.getCachedType(CharOperation.splitOn('.', fullyQualifiedName = focus.getFullyQualifiedName().toCharArray()))) == null) {
                return;
            }
            this.reportHierarchy(focus, focusUnit, focusBinaryBinding);
        }
        catch (ClassCastException e) {
        }
        catch (AbortCompilation e) {
        }
        finally {
            this.reset();
        }
    }

    private void setEnvironment(LookupEnvironment lookupEnvironment, HierarchyBuilder requestor) {
        this.lookupEnvironment = lookupEnvironment;
        this.requestor = requestor;
        this.typeIndex = -1;
        this.typeModels = new IGenericType[5];
        this.typeBindings = new ReferenceBinding[5];
    }

    public ReferenceBinding setFocusType(char[][] compoundName) {
        if (compoundName == null || this.lookupEnvironment == null) {
            return null;
        }
        this.focusType = this.lookupEnvironment.getCachedType(compoundName);
        if (this.focusType == null) {
            this.focusType = this.lookupEnvironment.askForType(compoundName);
        }
        return this.focusType;
    }

    public boolean subOrSuperOfFocus(ReferenceBinding typeBinding) {
        if (this.focusType == null) {
            return true;
        }
        try {
            if (this.subTypeOfType(this.focusType, typeBinding)) {
                return true;
            }
            if (!this.superTypesOnly && this.subTypeOfType(typeBinding, this.focusType)) {
                return true;
            }
        }
        catch (AbortCompilation abortCompilation) {
            // empty catch block
        }
        return false;
    }

    private boolean subTypeOfType(ReferenceBinding subType, ReferenceBinding typeBinding) {
        if (typeBinding == null || subType == null) {
            return false;
        }
        if (subType == typeBinding) {
            return true;
        }
        ReferenceBinding superclass = subType.superclass();
        if (this.subTypeOfType(superclass, typeBinding)) {
            return true;
        }
        ReferenceBinding[] superInterfaces = subType.superInterfaces();
        if (superInterfaces != null) {
            int length = superInterfaces.length;
            for (int i = 0; i < length; ++i) {
                if (!this.subTypeOfType(superInterfaces[i], typeBinding)) continue;
                return true;
            }
        }
        return false;
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    public class MissingType
    implements IGenericType {
        public String simpleName;

        public MissingType(String simpleName) {
            this.simpleName = simpleName;
        }

        public char[] getFileName() {
            return null;
        }

        public int getModifiers() {
            return 0;
        }

        public boolean isBinaryType() {
            return false;
        }

        public boolean isClass() {
            return false;
        }

        public boolean isInterface() {
            return false;
        }

        public String toString() {
            return "Missing type: " + this.simpleName;
        }
    }
}

