/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.charger.internal;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.sonatype.sisu.charger.internal.AbstractChargeStrategy;
import org.sonatype.sisu.charger.internal.Charge;
import org.sonatype.sisu.charger.internal.ChargeWrapper;

public class FirstArrivedChargeStrategy<E>
extends AbstractChargeStrategy<E> {
    private volatile ChargeWrapper<E> first = null;
    private CountDownLatch firstFound = new CountDownLatch(1);

    @Override
    public synchronized boolean isDone(Charge<E> charge, ChargeWrapper<E> wrapper) {
        if (this.first == null) {
            this.first = wrapper;
            this.firstFound.countDown();
        }
        return true;
    }

    @Override
    public List<E> getResult(Charge<E> charge) throws Exception {
        if (charge.getAmmoFutures().isEmpty()) {
            return Collections.emptyList();
        }
        this.firstFound.await();
        return Collections.singletonList(this.getFutureResult(this.first));
    }
}

