/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import java.io.IOException;
import java.io.InputStream;
import org.sonatype.spice.zapper.Range;
import org.sonatype.spice.zapper.internal.RangeInputStream;

public class RangeEnforcingInputStream
extends RangeInputStream {
    public RangeEnforcingInputStream(InputStream wrappedStream, Range range) throws IOException {
        this(wrappedStream, range, false, false);
    }

    public RangeEnforcingInputStream(InputStream wrappedStream, Range range, boolean doSkip, boolean allowedToClose) throws IOException {
        super(wrappedStream, range, doSkip, allowedToClose);
    }

    public int read() throws IOException {
        int result = super.read();
        if (result == -1) {
            this.checkIsEndExpected();
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (result == -1) {
            this.checkIsEndExpected();
        }
        return result;
    }

    protected void checkIsEndExpected() throws IOException {
        long allowedToRead = this.getAllowedToRead();
        if (allowedToRead > 0L) {
            throw new IOException(String.format("Unexpected end of stream, %s more bytes expected!", allowedToRead));
        }
    }
}

