/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.proxy.jvm.dispatcher;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class JvmMockKWeakMap<K, V>
implements Map<K, V> {
    private final Map<Object, V> target = new ConcurrentHashMap<Object, V>();
    private final ReferenceQueue<K> queue = new ReferenceQueue();

    @Override
    public V get(Object key) {
        return this.target.get(new StrongKey<Object>(key));
    }

    @Override
    public V put(K key, V value) {
        this.expunge();
        return this.target.put(new WeakKey<K>(key, this.queue), value);
    }

    @Override
    public V remove(Object key) {
        this.expunge();
        return this.target.remove(new StrongKey<Object>(key));
    }

    private void expunge() {
        Reference<K> ref;
        while ((ref = this.queue.poll()) != null) {
            this.target.remove(ref);
        }
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.target.containsValue(value);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("putAll");
    }

    @Override
    public void clear() {
        this.target.clear();
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException("keySet");
    }

    @Override
    public Collection<V> values() {
        return this.target.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException("entrySet");
    }

    public Map<Object, V> getTarget() {
        return this.target;
    }

    private static class StrongKey<K> {
        private final int hashCode;
        private final K key;

        public StrongKey(K key) {
            this.key = key;
            this.hashCode = System.identityHashCode(key);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            K key = this.get();
            if (key != null) {
                if (o instanceof WeakKey) {
                    return key == ((WeakKey)o).get();
                }
                if (o instanceof StrongKey) {
                    return key == ((StrongKey)o).get();
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public K get() {
            return this.key;
        }
    }

    private static class WeakKey<K>
    extends WeakReference<K> {
        private final int hashCode;

        public WeakKey(K key, ReferenceQueue<K> queue) {
            super(key, queue);
            this.hashCode = System.identityHashCode(key);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            Object key = this.get();
            if (key != null) {
                if (o instanceof WeakKey) {
                    return key == ((WeakKey)o).get();
                }
                if (o instanceof StrongKey) {
                    return key == ((StrongKey)o).get();
                }
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

