/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.maven.staging;

import com.google.common.base.Stopwatch;
import com.sonatype.nexus.staging.client.StagingWorkflowV3Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressMonitorImpl
implements StagingWorkflowV3Service.ProgressMonitor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Stopwatch stopwatch = new Stopwatch();
    protected boolean needsNewline;

    protected void maybePrintln() {
        if (this.needsNewline) {
            System.out.println();
            this.needsNewline = false;
        }
    }

    @Override
    public void start() {
        this.stopwatch.reset().start();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("START");
        } else {
            System.out.println();
            System.out.println("Waiting for operation to complete...");
        }
    }

    @Override
    public void tick() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("TICK at {}", (Object)this.stopwatch);
        } else {
            this.needsNewline = true;
            System.out.print(".");
        }
    }

    @Override
    public void pause() {
        this.logger.debug("PAUSE at {}", (Object)this.stopwatch);
    }

    @Override
    public void info(String message) {
        this.logger.debug(message);
    }

    @Override
    public void error(String message) {
        this.logger.debug(message);
    }

    @Override
    public void stop() {
        this.stopwatch.stop();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("STOP after {}", (Object)this.stopwatch);
        } else {
            this.maybePrintln();
            System.out.println();
        }
    }

    @Override
    public void timeout() {
        this.maybePrintln();
        this.logger.warn("TIMEOUT after {}", (Object)this.stopwatch);
    }

    @Override
    public void interrupted() {
        this.maybePrintln();
        this.logger.warn("INTERRUPTED after {}", (Object)this.stopwatch);
    }
}

