/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.codehaus.plexus.languages.java.jpms.ModuleNameExtractor;

class ManifestModuleNameExtractor
implements ModuleNameExtractor {
    ManifestModuleNameExtractor() {
    }

    @Override
    public String extract(Path file) throws IOException {
        Manifest manifest = this.extractManifest(file);
        String automaticModuleName = manifest != null ? manifest.getMainAttributes().getValue("Automatic-Module-Name") : null;
        return automaticModuleName;
    }

    private Manifest extractManifest(Path file) throws IOException {
        Manifest manifest;
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try (JarFile jarFile = new JarFile(file.toFile());){
                manifest = jarFile.getManifest();
            }
        } else if (Files.exists(file.resolve("META-INF/MANIFEST.MF"), new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(file.resolve("META-INF/MANIFEST.MF"), new OpenOption[0]);){
                manifest = new Manifest(is);
            }
        } else {
            manifest = null;
        }
        return manifest;
    }
}

