/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.subsystem.security;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.sonatype.nexus.client.core.subsystem.Restlet1xClient;
import org.sonatype.nexus.client.core.subsystem.security.User;
import org.sonatype.nexus.client.core.subsystem.security.Users;
import org.sonatype.nexus.client.internal.subsystem.security.UserImpl;
import org.sonatype.security.rest.model.UserListResourceResponse;
import org.sonatype.security.rest.model.UserResource;
import org.sonatype.security.rest.model.UserResourceRequest;
import org.sonatype.security.rest.model.UserResourceResponse;
import org.sonatype.sisu.siesta.client.ClientBuilder;

public class UsersImpl
implements Users {
    private final UsersClient usersClient;

    @Inject
    public UsersImpl(ClientBuilder.Target.Factory factory) {
        this.usersClient = (UsersClient)((ClientBuilder.Target.Factory)Preconditions.checkNotNull((Object)factory, (Object)"factory")).build(UsersClient.class);
    }

    @Override
    public UserImpl create(String id) {
        return new UserImpl(this.usersClient, id);
    }

    @Override
    public User get(String id) {
        return this.convert(this.usersClient.get(id).getData());
    }

    @Override
    public Collection<User> get() {
        return Collections2.transform((Collection)this.usersClient.get().getData(), (Function)new Function<UserResource, User>(){

            public User apply(@Nullable UserResource input) {
                return UsersImpl.this.convert(input);
            }
        });
    }

    private UserImpl convert(@Nullable UserResource resource) {
        if (resource == null) {
            return null;
        }
        UserImpl role = new UserImpl(this.usersClient, resource);
        role.overwriteWith(resource);
        return role;
    }

    @Path(value="/service/local/users")
    public static interface UsersClient
    extends Restlet1xClient {
        @GET
        @Path(value="/{id}")
        public UserResourceResponse get(@PathParam(value="id") String var1);

        @GET
        public UserListResourceResponse get();

        @POST
        public UserResourceResponse post(UserResourceRequest var1);

        @PUT
        @Path(value="/{id}")
        public UserResourceResponse put(@PathParam(value="id") String var1, UserResourceRequest var2);

        @DELETE
        @Path(value="/{id}")
        public void delete(@PathParam(value="id") String var1);
    }
}

