/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.client.internal.rest.jersey.subsystem.security;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.BeanUtils;
import org.sonatype.nexus.client.core.subsystem.security.Privilege;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.JerseyEntitySupport;
import org.sonatype.nexus.client.internal.rest.jersey.subsystem.security.JerseyPrivileges;
import org.sonatype.nexus.client.rest.jersey.JerseyNexusClient;
import org.sonatype.nexus.rest.model.PrivilegeResource;
import org.sonatype.nexus.rest.model.PrivilegeResourceRequest;
import org.sonatype.security.rest.model.PrivilegeListResourceResponse;
import org.sonatype.security.rest.model.PrivilegeProperty;
import org.sonatype.security.rest.model.PrivilegeStatusResource;
import org.sonatype.security.rest.model.PrivilegeStatusResourceResponse;

public class JerseyPrivilege
extends JerseyEntitySupport<Privilege, PrivilegeStatusResource>
implements Privilege {
    public JerseyPrivilege(JerseyNexusClient nexusClient, String id) {
        super(nexusClient, id);
    }

    public JerseyPrivilege(JerseyNexusClient nexusClient, String id, PrivilegeStatusResource settings) {
        super(nexusClient, id, settings);
    }

    @Override
    protected PrivilegeStatusResource createSettings(String id) {
        PrivilegeStatusResource resource = new PrivilegeStatusResource();
        resource.setId(id);
        resource.setUserManaged(true);
        resource.setType("target");
        return resource;
    }

    @Override
    protected PrivilegeStatusResource doGet() {
        try {
            return ((PrivilegeStatusResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyPrivileges.path(this.id())).get(PrivilegeStatusResourceResponse.class)).getData();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public String id() {
        return ((PrivilegeStatusResource)this.settings()).getId();
    }

    @Override
    public synchronized Privilege save() {
        super.save();
        return null;
    }

    @Override
    public synchronized Collection<Privilege> create() {
        if (this.shouldCreate()) {
            PrivilegeResourceRequest request = new PrivilegeResourceRequest();
            request.setData(this.convert());
            try {
                List resources = ((PrivilegeListResourceResponse)((JerseyNexusClient)this.getNexusClient()).serviceResource("privileges_target").post(PrivilegeListResourceResponse.class, (Object)request)).getData();
                return Collections2.transform((Collection)resources, (Function)new Function<PrivilegeStatusResource, Privilege>(){

                    @Nullable
                    public Privilege apply(@Nullable PrivilegeStatusResource resource) {
                        return new JerseyPrivilege((JerseyNexusClient)JerseyPrivilege.this.getNexusClient(), resource.getId(), resource);
                    }
                });
            }
            catch (UniformInterfaceException e) {
                throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
            }
            catch (ClientHandlerException e) {
                throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
            }
        }
        throw new IllegalStateException("This privilege was already loaded from Nexus.");
    }

    @Override
    protected PrivilegeStatusResource doCreate() {
        PrivilegeResourceRequest request = new PrivilegeResourceRequest();
        request.setData(this.convert());
        try {
            ((JerseyNexusClient)this.getNexusClient()).serviceResource("privileges_target").post(PrivilegeListResourceResponse.class, (Object)request);
            return null;
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    private PrivilegeResource convert() {
        PrivilegeResource resource = new PrivilegeResource();
        try {
            BeanUtils.copyProperties((Object)resource, this.settings());
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
        resource.setMethod(this.methods() != null ? Lists.newArrayList(this.methods()) : null);
        resource.setRepositoryGroupId(this.repositoryGroupId());
        resource.setRepositoryId(this.repositoryId());
        resource.setRepositoryTargetId(this.targetId());
        resource.setType(this.type());
        return resource;
    }

    @Override
    protected PrivilegeStatusResource doUpdate() {
        throw new UnsupportedOperationException("A privilege is immutable.");
    }

    @Override
    protected void doRemove() {
        try {
            ((JerseyNexusClient)this.getNexusClient()).serviceResource(JerseyPrivileges.path(this.id())).delete();
        }
        catch (UniformInterfaceException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
        catch (ClientHandlerException e) {
            throw ((JerseyNexusClient)this.getNexusClient()).convert(e);
        }
    }

    @Override
    public String name() {
        return ((PrivilegeStatusResource)this.settings()).getName();
    }

    @Override
    public String description() {
        return ((PrivilegeStatusResource)this.settings()).getDescription();
    }

    @Override
    public Privilege withDescription(String value) {
        ((PrivilegeStatusResource)this.settings()).setDescription(value);
        return this;
    }

    @Override
    public String type() {
        return ((PrivilegeStatusResource)this.settings()).getType();
    }

    private void setProperty(String key, String value) {
        List properties = ((PrivilegeStatusResource)this.settings()).getProperties();
        for (PrivilegeProperty property : properties) {
            if (!property.getKey().equals(key)) continue;
            property.setValue(value);
            return;
        }
        PrivilegeProperty property = new PrivilegeProperty();
        property.setKey(key);
        property.setValue(value);
        properties.add(property);
    }

    private String getProperty(String key) {
        List properties = ((PrivilegeStatusResource)this.settings()).getProperties();
        for (PrivilegeProperty property : properties) {
            if (!property.getKey().equals(key)) continue;
            return property.getValue();
        }
        return null;
    }

    @Override
    public String repositoryId() {
        return this.getProperty("repositoryId");
    }

    @Override
    public Privilege withRepositoryId(String repositoryId) {
        this.setProperty("repositoryId", repositoryId);
        return this;
    }

    @Override
    public List<String> methods() {
        String methods = this.getProperty("method");
        if (methods == null) {
            return null;
        }
        return Lists.newArrayList((Object[])methods.split(","));
    }

    @Override
    public Privilege withMethods(String ... methods) {
        this.setProperty("method", Joiner.on((String)",").join((Object[])methods));
        return this;
    }

    @Override
    public String targetId() {
        return this.getProperty("repositoryTargetId");
    }

    @Override
    public Privilege withTargetId(String targetId) {
        this.setProperty("repositoryTargetId", targetId);
        return this;
    }

    @Override
    public String repositoryGroupId() {
        return this.getProperty("repositoryGroupId");
    }

    @Override
    public Privilege withRepositoryGroupId(String groupId) {
        this.setProperty("repositoryGroupId", groupId);
        return this;
    }

    @Override
    public Privilege withName(String value) {
        ((PrivilegeStatusResource)this.settings()).setName(value);
        return this;
    }
}

