/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.files;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.enforcer.rule.api.EnforcerRuleError;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.AbstractStandardEnforcerRule;

abstract class AbstractRequireFiles
extends AbstractStandardEnforcerRule {
    private List<File> files = Collections.emptyList();
    private boolean allowNulls = false;
    private boolean satisfyAny;

    AbstractRequireFiles() {
    }

    abstract boolean checkFile(File var1);

    abstract String getErrorMsg();

    public void execute() throws EnforcerRuleException {
        if (!this.allowNulls && this.files.isEmpty()) {
            throw new EnforcerRuleError("The file list is empty and Null files are disabled.");
        }
        ArrayList<File> failures = new ArrayList<File>();
        for (File file : this.files) {
            if (!this.allowNulls && file == null) {
                failures.add(file);
                continue;
            }
            if (this.checkFile(file)) continue;
            failures.add(file);
        }
        if (this.satisfyAny) {
            int passed = this.files.size() - failures.size();
            if (passed == 0) {
                this.fail(failures);
            }
        } else if (!failures.isEmpty()) {
            this.fail(failures);
        }
    }

    private void fail(List<File> failures) throws EnforcerRuleException {
        String message = this.getMessage();
        StringBuilder buf = new StringBuilder();
        if (message != null) {
            buf.append(message + System.lineSeparator());
        }
        buf.append(this.getErrorMsg());
        for (File file : failures) {
            if (file != null) {
                buf.append(file.getAbsolutePath() + System.lineSeparator());
                continue;
            }
            buf.append("(an empty filename was given and allowNulls is false)" + System.lineSeparator());
        }
        throw new EnforcerRuleException(buf.toString());
    }

    public String getCacheId() {
        return Integer.toString(this.files.hashCode());
    }

    void setFilesList(List<File> files) {
        this.files = files;
    }

    List<File> getFiles() {
        return this.files;
    }

    void setAllowNulls(boolean allowNulls) {
        this.allowNulls = allowNulls;
    }

    void setSatisfyAny(boolean satisfyAny) {
        this.satisfyAny = satisfyAny;
    }

    public String toString() {
        return String.format("%s[message=%s, files=%s, allowNulls=%b, satisfyAny=%b]", ((Object)((Object)this)).getClass().getSimpleName(), this.getMessage(), this.files, this.allowNulls, this.satisfyAny);
    }
}

