/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.util.StringUtils;

public final class ArtifactMatcher {
    private final Collection<Pattern> excludePatterns = new HashSet<Pattern>();
    private final Collection<Pattern> includePatterns = new HashSet<Pattern>();

    public ArtifactMatcher(Collection<String> excludeStrings, Collection<String> includeStrings) {
        Optional.ofNullable(excludeStrings).ifPresent(excludes -> excludes.stream().filter(StringUtils::isNotEmpty).map(Pattern::new).forEach(this.excludePatterns::add));
        Optional.ofNullable(includeStrings).ifPresent(includes -> includes.stream().filter(StringUtils::isNotEmpty).map(Pattern::new).forEach(this.includePatterns::add));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean match(Function<Pattern, Boolean> matcher) {
        if (!this.excludePatterns.stream().anyMatch(matcher::apply)) return false;
        if (!this.includePatterns.stream().noneMatch(matcher::apply)) return false;
        return true;
    }

    public boolean match(Artifact artifact) {
        return this.match((Pattern p) -> p.match(artifact));
    }

    public boolean match(Dependency dependency) {
        return this.match((Pattern p) -> p.match(dependency));
    }

    public static boolean containsVersion(VersionRange allowedRange, ArtifactVersion theVersion) {
        ArtifactVersion recommendedVersion = allowedRange.getRecommendedVersion();
        if (recommendedVersion == null) {
            return allowedRange.containsVersion(theVersion);
        }
        int compareTo = recommendedVersion.compareTo((Object)theVersion);
        return compareTo <= 0;
    }

    public static class Pattern {
        private String pattern;
        private String[] parts;

        public Pattern(String pattern) {
            if (pattern == null) {
                throw new NullPointerException("pattern");
            }
            this.pattern = pattern;
            this.parts = pattern.split(":", 7);
            if (this.parts.length == 7) {
                throw new IllegalArgumentException("Pattern contains too many delimiters.");
            }
            for (String part : this.parts) {
                if (!"".equals(part)) continue;
                throw new IllegalArgumentException("Pattern or its part is empty.");
            }
        }

        public boolean match(Artifact artifact) {
            Objects.requireNonNull(artifact, "artifact must not be null");
            try {
                return this.match(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), artifact.getScope(), artifact.getClassifier());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public boolean match(Dependency dependency) {
            Objects.requireNonNull(dependency, "dependency must not be null");
            try {
                return this.match(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), dependency.getScope(), dependency.getClassifier());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private boolean match(String groupId, String artifactId, String version, String type, String scope, String classifier) throws InvalidVersionSpecificationException {
            switch (this.parts.length) {
                case 6: {
                    if (!this.matches(this.parts[5], classifier)) {
                        return false;
                    }
                }
                case 5: {
                    if (scope == null || scope.equals("")) {
                        scope = "compile";
                    }
                    if (!this.matches(this.parts[4], scope)) {
                        return false;
                    }
                }
                case 4: {
                    if (type == null || type.equals("")) {
                        type = "jar";
                    }
                    if (!this.matches(this.parts[3], type)) {
                        return false;
                    }
                }
                case 3: {
                    if (!this.matches(this.parts[2], version) && !ArtifactMatcher.containsVersion(VersionRange.createFromVersionSpec((String)this.parts[2]), (ArtifactVersion)new DefaultArtifactVersion(version))) {
                        return false;
                    }
                }
                case 2: {
                    if (!this.matches(this.parts[1], artifactId)) {
                        return false;
                    }
                }
                case 1: {
                    return this.matches(this.parts[0], groupId);
                }
            }
            throw new AssertionError();
        }

        private boolean matches(String expression, String input) {
            String regex = expression.replace(".", "\\.").replace("*", ".*").replace(":", "\\:").replace('?', '.').replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)");
            if (input == null) {
                input = "";
            }
            return java.util.regex.Pattern.matches(regex, input);
        }

        public String toString() {
            return this.pattern;
        }
    }
}

