/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.core.JavaPsiBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceParser {
    private static final TokenSet WILDCARD_KEYWORD_SET = TokenSet.create(JavaTokenType.EXTENDS_KEYWORD, JavaTokenType.SUPER_KEYWORD);
    private final JavaParser myParser;

    public ReferenceParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            ReferenceParser.$$$reportNull$$$0(0);
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parseType(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags);
        return typeInfo != null ? typeInfo.marker : null;
    }

    @Nullable
    public TypeInfo parseTypeInfo(PsiBuilder builder, int flags) {
        TypeInfo typeInfo = this.parseTypeInfo(builder, flags, false);
        if (typeInfo != null) {
            IElementType operator;
            assert (!BitUtil.isSet(flags, 16) || !BitUtil.isSet(flags, 32)) : "don't set both flags simultaneously";
            IElementType iElementType = BitUtil.isSet(flags, 16) ? JavaTokenType.OR : (operator = BitUtil.isSet(flags, 32) ? JavaTokenType.AND : null);
            if (operator != null && builder.getTokenType() == operator) {
                typeInfo.marker = typeInfo.marker.precede();
                while (builder.getTokenType() == operator) {
                    builder.advanceLexer();
                    IElementType tokenType = builder.getTokenType();
                    if (tokenType != JavaTokenType.IDENTIFIER && tokenType != JavaTokenType.AT) {
                        JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    }
                    this.parseTypeInfo(builder, flags, false);
                }
                typeInfo.marker.done(JavaElementType.TYPE);
            }
        }
        return typeInfo;
    }

    @Nullable
    private TypeInfo parseTypeInfo(PsiBuilder builder, int flags, boolean badWildcard) {
        if (builder.getTokenType() == null) {
            return null;
        }
        TypeInfo typeInfo = new TypeInfo();
        PsiBuilder.Marker type2 = builder.mark();
        PsiBuilder.Marker anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.IDENTIFIER && BitUtil.isSet(flags, 128) && builder.lookAhead(1) != JavaTokenType.DOT && builder.lookAhead(1) != JavaTokenType.COLON && "var".equals(builder.getTokenText()) && JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_10)) {
            tokenType = JavaTokenType.VAR_KEYWORD;
            builder.remapCurrentToken(tokenType);
        } else if (tokenType == JavaTokenType.VAR_KEYWORD && !BitUtil.isSet(flags, 128)) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder.remapCurrentToken(tokenType);
        }
        if (PsiBuilderUtil.expect(builder, ElementType.PRIMITIVE_TYPE_BIT_SET)) {
            typeInfo.isPrimitive = true;
        } else {
            if ((BitUtil.isSet(flags, 4) || badWildcard) && (tokenType == JavaTokenType.QUEST || ReferenceParser.isKeywordAny(builder))) {
                if (tokenType == JavaTokenType.QUEST) {
                    builder.advanceLexer();
                } else {
                    ReferenceParser.dummy(builder);
                }
                this.completeWildcardType(builder, BitUtil.isSet(flags, 4), type2);
                typeInfo.marker = type2;
                return typeInfo;
            }
            if (tokenType == JavaTokenType.IDENTIFIER) {
                this.parseJavaCodeReference(builder, BitUtil.isSet(flags, 1), true, false, false, false, BitUtil.isSet(flags, 8), typeInfo);
            } else {
                if (tokenType == JavaTokenType.VAR_KEYWORD) {
                    builder.advanceLexer();
                    type2.done(JavaElementType.TYPE);
                    typeInfo.marker = type2;
                    return typeInfo;
                }
                if (BitUtil.isSet(flags, 8) && tokenType == JavaTokenType.GT) {
                    if (anno == null) {
                        JavaParserUtil.emptyElement(builder, JavaElementType.DIAMOND_TYPE);
                    } else {
                        JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        typeInfo.hasErrors = true;
                    }
                    type2.done(JavaElementType.TYPE);
                    typeInfo.marker = type2;
                    return typeInfo;
                }
                type2.drop();
                if (anno != null && BitUtil.isSet(flags, 64)) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
                    typeInfo.marker = anno;
                    typeInfo.hasErrors = true;
                    return typeInfo;
                }
                return null;
            }
        }
        type2.done(JavaElementType.TYPE);
        while (true) {
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            PsiBuilder.Marker bracket = builder.mark();
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.LBRACKET)) {
                bracket.drop();
                break;
            }
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RBRACKET)) {
                bracket.rollbackTo();
                break;
            }
            bracket.drop();
            typeInfo.isArray = true;
        }
        if (BitUtil.isSet(flags, 2) && builder.getTokenType() == JavaTokenType.ELLIPSIS) {
            builder.advanceLexer();
            typeInfo.isVarArg = true;
        }
        if (typeInfo.isVarArg || typeInfo.isArray) {
            type2 = type2.precede();
            type2.done(JavaElementType.TYPE);
        }
        typeInfo.marker = type2;
        return typeInfo;
    }

    private void completeWildcardType(PsiBuilder builder, boolean wildcard, PsiBuilder.Marker type2) {
        if (PsiBuilderUtil.expect(builder, WILDCARD_KEYWORD_SET) && this.parseTypeInfo(builder, 1) == null) {
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
        }
        if (wildcard) {
            type2.done(JavaElementType.TYPE);
        } else {
            type2.error(JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList2, boolean isNew, boolean diamonds) {
        return this.parseJavaCodeReference(builder, eatLastDot, parameterList2, false, false, isNew, diamonds, new TypeInfo());
    }

    public boolean parseImportCodeReference(PsiBuilder builder, boolean isStatic) {
        TypeInfo typeInfo = new TypeInfo();
        this.parseJavaCodeReference(builder, true, false, true, isStatic, false, false, typeInfo);
        return !typeInfo.hasErrors;
    }

    @Nullable
    private PsiBuilder.Marker parseJavaCodeReference(PsiBuilder builder, boolean eatLastDot, boolean parameterList2, boolean isImport, boolean isStaticImport, boolean isNew, boolean diamonds, TypeInfo typeInfo) {
        PsiBuilder.Marker refElement = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            refElement.rollbackTo();
            if (isImport) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            }
            typeInfo.hasErrors = true;
            return null;
        }
        if (parameterList2) {
            typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
        } else if (!isStaticImport) {
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        while (builder.getTokenType() == JavaTokenType.DOT) {
            refElement.done(JavaElementType.JAVA_CODE_REFERENCE);
            if (isNew && !diamonds && typeInfo.isParameterized) {
                return refElement;
            }
            PsiBuilder.Marker dotPos = builder.mark();
            builder.advanceLexer();
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (isImport && PsiBuilderUtil.expect(builder, JavaTokenType.ASTERISK)) {
                dotPos.drop();
                return refElement;
            }
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
                if (!eatLastDot) {
                    dotPos.rollbackTo();
                    return refElement;
                }
                typeInfo.hasErrors = true;
                if (isImport) {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("import.statement.identifier.or.asterisk.expected.", new Object[0]));
                } else {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                }
                dotPos.drop();
                return refElement;
            }
            dotPos.drop();
            refElement = refElement.precede();
            if (parameterList2) {
                typeInfo.isParameterized = this.parseReferenceParameterList(builder, true, diamonds);
                continue;
            }
            JavaParserUtil.emptyElement(builder, JavaElementType.REFERENCE_PARAMETER_LIST);
        }
        refElement.done(isStaticImport ? JavaElementType.IMPORT_STATIC_REFERENCE : JavaElementType.JAVA_CODE_REFERENCE);
        return refElement;
    }

    public boolean parseReferenceParameterList(PsiBuilder builder, boolean wildcard, boolean diamonds) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LT)) {
            list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
            return false;
        }
        int flags = BitUtil.set(BitUtil.set(1, 4, wildcard), 8, diamonds);
        boolean isOk = true;
        while (true) {
            if (this.parseTypeInfo(builder, flags, true) == null) {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
            } else {
                IElementType tokenType = builder.getTokenType();
                if (WILDCARD_KEYWORD_SET.contains(tokenType)) {
                    this.parseReferenceList(builder, tokenType, null, JavaTokenType.AND);
                }
            }
            if (PsiBuilderUtil.expect(builder, JavaTokenType.GT)) break;
            if (!JavaParserUtil.expectOrError(builder, JavaTokenType.COMMA, "expected.gt.or.comma")) {
                isOk = false;
                break;
            }
            flags = BitUtil.set(flags, 8, false);
        }
        list.done(JavaElementType.REFERENCE_PARAMETER_LIST);
        return isOk;
    }

    @NotNull
    public PsiBuilder.Marker parseTypeParameters(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.LT)) {
            list.done(JavaElementType.TYPE_PARAMETER_LIST);
            PsiBuilder.Marker marker = list;
            if (marker == null) {
                ReferenceParser.$$$reportNull$$$0(1);
            }
            return marker;
        }
        do {
            PsiBuilder.Marker param;
            if ((param = this.parseTypeParameter(builder)) != null) continue;
            JavaParserUtil.error(builder, JavaPsiBundle.message("expected.type.parameter", new Object[0]));
        } while (PsiBuilderUtil.expect(builder, JavaTokenType.COMMA));
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.GT)) {
            if (builder.getTokenType() == JavaTokenType.IDENTIFIER) {
                if (builder.lookAhead(1) == JavaTokenType.GT) {
                    PsiBuilder.Marker errorElement = builder.mark();
                    builder.advanceLexer();
                    errorElement.error(JavaPsiBundle.message("unexpected.identifier", new Object[0]));
                    builder.advanceLexer();
                } else {
                    JavaParserUtil.error(builder, JavaPsiBundle.message("expected.gt", new Object[0]));
                }
            } else {
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.gt", new Object[0]));
            }
        }
        list.done(JavaElementType.TYPE_PARAMETER_LIST);
        PsiBuilder.Marker marker = list;
        if (marker == null) {
            ReferenceParser.$$$reportNull$$$0(2);
        }
        return marker;
    }

    @Nullable
    public PsiBuilder.Marker parseTypeParameter(PsiBuilder builder) {
        boolean wild;
        PsiBuilder.Marker param = builder.mark();
        this.myParser.getDeclarationParser().parseAnnotations(builder);
        if (ReferenceParser.isKeywordAny(builder)) {
            ReferenceParser.dummy(builder);
        }
        if (!(wild = PsiBuilderUtil.expect(builder, JavaTokenType.QUEST)) && !PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER)) {
            param.rollbackTo();
            return null;
        }
        this.parseReferenceList(builder, JavaTokenType.EXTENDS_KEYWORD, JavaElementType.EXTENDS_BOUND_LIST, JavaTokenType.AND);
        if (!wild) {
            param.done(JavaElementType.TYPE_PARAMETER);
        } else {
            param.error(JavaPsiBundle.message("error.message.wildcard.not.expected", new Object[0]));
        }
        return param;
    }

    public boolean parseReferenceList(PsiBuilder builder, IElementType start, @Nullable IElementType type2, IElementType delimiter) {
        PsiBuilder.Marker element = builder.mark();
        boolean endsWithError = false;
        if (PsiBuilderUtil.expect(builder, start)) {
            do {
                endsWithError = false;
                PsiBuilder.Marker classReference = this.parseJavaCodeReference(builder, false, true, false, false);
                if (classReference != null) continue;
                JavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                endsWithError = true;
            } while (PsiBuilderUtil.expect(builder, delimiter));
        }
        if (type2 != null) {
            element.done(type2);
        } else {
            element.error(JavaPsiBundle.message("bound.not.expected", new Object[0]));
        }
        return endsWithError;
    }

    private static boolean isKeywordAny(PsiBuilder builder) {
        return JavaParserUtil.getLanguageLevel(builder).isAtLeast(LanguageLevel.JDK_X) && "any".equals(builder.getTokenText());
    }

    private static void dummy(PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        mark.done(JavaElementType.DUMMY_ELEMENT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/java/parser/ReferenceParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/java/parser/ReferenceParser";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeInfo {
        public boolean isPrimitive;
        public boolean isParameterized;
        public boolean isArray;
        public boolean isVarArg;
        public boolean hasErrors;
        public PsiBuilder.Marker marker;
    }
}

