/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDeprecationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.ImplicitReceiverUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001:\u0001.B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u001a\u001a\u00020\u0013*\u00020\u00192\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c*\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0002J0\u0010 \u001a\u00020\u0013*\u00020\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00130$H\u0002J\u001c\u0010&\u001a\u00020'*\u00020\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002JA\u0010(\u001a\u00020'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0018\b\u0004\u0010+\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030,\u0012\u0004\u0012\u00020\u00130$H\u0082\bJ \u0010-\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAllUnderFromEnumEntry", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "checkAllUnderFromObject", "checkCanBeImported", "isVisible", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "checkConflictingImports", "imports", "", "checkOperatorRename", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "resolvesToClass", "resolveToClassLike", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveToClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "hasFunction", "name", "Lorg/jetbrains/kotlin/name/Name;", "predicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getImportStatusOfCallableMembers", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "getImportStatus", "scopes", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "isApplicable", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkImportApiStatus", "ImportStatus", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirImportsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n310#1,21:387\n310#1,19:408\n329#1,2:428\n1863#2,2:343\n1755#2,3:347\n827#2:359\n855#2,2:360\n1485#2:362\n1510#2,3:363\n1513#2,3:373\n774#2:376\n865#2,2:377\n1863#2:379\n1863#2,2:380\n1864#2:382\n1755#2,2:383\n1757#2:386\n75#3:345\n26#3:385\n24#3:427\n26#3:431\n37#4:346\n46#4:350\n21#5:351\n45#6,7:352\n381#7,7:366\n1#8:430\n*S KotlinDebug\n*F\n+ 1 FirImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker\n*L\n286#1:387,21\n300#1:408,19\n300#1:428,2\n42#1:343,2\n66#1:347,3\n202#1:359\n202#1:360,2\n204#1:362\n204#1:363,3\n204#1:373,3\n206#1:376\n206#1:377,2\n207#1:379\n208#1:380,2\n207#1:382\n223#1:383,2\n223#1:386\n66#1:345\n224#1:385\n300#1:427\n221#1:431\n66#1:346\n80#1:350\n178#1:351\n197#1:352,7\n204#1:366,7\n*E\n"})
public final class FirImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirImportsChecker INSTANCE = new FirImportsChecker();

    private FirImportsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFile declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable $this$forEach$iv = declaration.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirImport firImport = (FirImport)element$iv;
            boolean bl = false;
            Object object = firImport.getSource();
            if (object != null && (object = ((KtSourceElement)object).getKind()) != null ? ((KtSourceElementKind)object).getShouldSkipErrorTypeReporting() : false) continue;
            if (firImport.isAllUnder()) {
                if (firImport instanceof FirResolvedImport) {
                    INSTANCE.checkAllUnderFromObject(firImport, context2, reporter);
                } else {
                    INSTANCE.checkAllUnderFromEnumEntry(firImport, context2, reporter);
                }
            } else {
                INSTANCE.checkCanBeImported(firImport, context2, reporter);
                if (firImport instanceof FirResolvedImport) {
                    INSTANCE.checkOperatorRename((FirResolvedImport)firImport, context2, reporter);
                }
            }
            INSTANCE.checkImportApiStatus(firImport, context2, reporter);
        }
        this.checkConflictingImports(declaration.getImports(), context2, reporter);
    }

    private final void checkAllUnderFromEnumEntry(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        FqName fqName = firImport.getImportedFqName();
        if (fqName == null) {
            return;
        }
        FqName fqName2 = fqName;
        if (fqName2.isRoot() || fqName2.parent().isRoot()) {
            return;
        }
        FqName fqName3 = fqName2.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"parent(...)");
        ClassId classId = ClassId.Companion.topLevel(fqName3);
        FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(classId, context2);
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol classSymbol = firRegularClassSymbol;
        FirClassSymbol $this$isEnumClass$iv = classSymbol;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        boolean bl = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS;
        if (bl) {
            boolean bl2;
            block8: {
                Iterable $this$any$iv = DeclarationUtilsKt.collectEnumEntries(classSymbol);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirEnumEntrySymbol it = (FirEnumEntrySymbol)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getCallableId().getCallableName(), (Object)fqName2.shortName())) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), (Object)classSymbol.getClassId().getShortClassName(), (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    private final void checkAllUnderFromObject(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        FqName fqName = firImport.getImportedFqName();
        if (fqName == null) {
            return;
        }
        FqName fqName2 = fqName;
        if (fqName2.isRoot()) {
            return;
        }
        PackageResolutionResult resolutionResult = ImportUtilsKt.resolveToPackageOrClass(FirSymbolProviderKt.getSymbolProvider(context2.getSession()), fqName2);
        if (resolutionResult instanceof PackageResolutionResult.PackageOrClass) {
            firClassLikeSymbol = ((PackageResolutionResult.PackageOrClass)resolutionResult).getClassSymbol();
            if (firClassLikeSymbol == null) {
                return;
            }
        } else {
            if (resolutionResult instanceof PackageResolutionResult.Error) {
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        FirClassLikeSymbol<?> classLike = firClassLikeSymbol;
        FirRegularClassSymbol classSymbol = DeclarationUtilsKt.fullyExpandedClass(classLike, context2.getSession());
        if (classSymbol != null) {
            ClassKind $this$isObject$iv = classSymbol.getClassKind();
            boolean $i$f$isObject = false;
            if ($this$isObject$iv == ClassKind.OBJECT) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getCANNOT_ALL_UNDER_IMPORT_FROM_SINGLETON(), (Object)classSymbol.getClassId().getShortClassName(), (DiagnosticContext)context2, null, 16, null);
            }
        }
        if (!this.isVisible((FirBasedSymbol)classLike, context2)) {
            KtSourceElement ktSourceElement = FirSourceUtilsKt.getLastImportedFqNameSegmentSource(firImport);
            if (ktSourceElement == null) {
                throw new IllegalStateException(("" + '`' + firImport.getSource() + "` does not contain `" + fqName2 + '`').toString());
            }
            KtSourceElement source = ktSourceElement;
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)classLike, source), context2);
        }
    }

    private final void checkCanBeImported(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        ClassId parentClassId;
        Name importedName;
        FqName importedFqName;
        block25: {
            block24: {
                FqName fqName = firImport.getImportedFqName();
                if (fqName == null) {
                    return;
                }
                importedFqName = fqName;
                Name name2 = importedFqName.shortName();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
                importedName = name2;
                if (importedName.isSpecial()) break block24;
                String string2 = importedName.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdentifier(...)");
                if (!(((CharSequence)string2).length() == 0)) break block25;
            }
            return;
        }
        FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(context2.getSession());
        FirResolvedImport firResolvedImport = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
        ClassId classId = parentClassId = firResolvedImport != null ? firResolvedImport.getResolvedParentClassId() : null;
        if (parentClassId != null) {
            FirClassLikeSymbol<?> firClassLikeSymbol = this.resolveToClassLike(parentClassId, context2);
            if (firClassLikeSymbol == null) {
                return;
            }
            FirClassLikeSymbol<?> parentClassLikeSymbol = firClassLikeSymbol;
            FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(parentClassLikeSymbol, context2.getSession());
            if (firRegularClassSymbol == null) {
                return;
            }
            FirRegularClassSymbol parentClassSymbol = firRegularClassSymbol;
            FirImportsChecker.checkCanBeImported$reportInvisibleParentClasses(context2, firImport, reporter, parentClassSymbol, 1);
            ImportStatus status2 = this.getImportStatusOfCallableMembers(parentClassSymbol, context2, importedName);
            if (Intrinsics.areEqual((Object)status2, (Object)ImportStatus.OK.INSTANCE)) {
                if (parentClassLikeSymbol instanceof FirTypeAliasSymbol) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirResolvedImport)firImport).getSource(), FirErrors.INSTANCE.getTYPEALIAS_AS_CALLABLE_QUALIFIER_IN_IMPORT(), (Object)((FirTypeAliasSymbol)parentClassLikeSymbol).getName(), (Object)parentClassSymbol.getName(), (DiagnosticContext)context2, null, 32, null);
                }
            } else if (status2 instanceof ImportStatus.Invisible) {
                KtSourceElement ktSourceElement = FirSourceUtilsKt.getSourceForImportSegment(firImport, 0);
                reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)((ImportStatus.Invisible)status2).getSymbol(), ktSourceElement), context2);
            } else {
                ClassId classId2 = parentClassSymbol.getClassId().createNestedClassId(importedName);
                if (symbolProvider.getClassLikeSymbolByClassId(classId2) != null) {
                    return;
                }
                if (Intrinsics.areEqual((Object)status2, (Object)ImportStatus.Unresolved.INSTANCE)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirResolvedImport)firImport).getSource(), FirErrors.INSTANCE.getUNRESOLVED_IMPORT(), (Object)importedName.asString(), (DiagnosticContext)context2, null, 16, null);
                } else {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirResolvedImport)firImport).getSource(), FirErrors.INSTANCE.getCANNOT_BE_IMPORTED(), (Object)importedName, (DiagnosticContext)context2, null, 16, null);
                }
            }
            return;
        }
        FirBasedSymbol resolvedDeclaration = null;
        FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(ClassId.Companion.topLevel(importedFqName), context2);
        if (firRegularClassSymbol != null) {
            FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol;
            boolean bl = false;
            resolvedDeclaration = firRegularClassSymbol2;
            if (INSTANCE.isVisible(firRegularClassSymbol2, context2)) {
                return;
            }
        }
        FqName fqName = importedFqName.parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"parent(...)");
        List<FirCallableSymbol<?>> topLevelCallableSymbol = symbolProvider.getTopLevelCallableSymbols(fqName, importedName);
        for (FirCallableSymbol<?> firCallableSymbol : topLevelCallableSymbol) {
            if (this.isVisible((FirBasedSymbol)firCallableSymbol, context2)) {
                return;
            }
            if (resolvedDeclaration != null) continue;
            resolvedDeclaration = firCallableSymbol;
        }
        FirBasedSymbol firBasedSymbol = resolvedDeclaration;
        if (firBasedSymbol != null) {
            FirBasedSymbol it = firBasedSymbol;
            boolean bl = false;
            KtSourceElement ktSourceElement = FirSourceUtilsKt.getSourceForImportSegment(firImport, 0);
            if (ktSourceElement == null) {
                ktSourceElement = firImport.getSource();
            }
            KtSourceElement source = ktSourceElement;
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(it, source), context2);
            return;
        }
        if (symbolProvider.getPackage(importedFqName) != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getPACKAGE_CANNOT_BE_IMPORTED(), (DiagnosticContext)context2, null, 8, null);
        } else {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firImport.getSource(), FirErrors.INSTANCE.getUNRESOLVED_IMPORT(), (Object)importedName.asString(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isVisible(FirBasedSymbol<?> $this$isVisible, CheckerContext context2) {
        FirMemberDeclaration fir;
        FirFile firFile = context2.getContainingFile();
        if (firFile == null) {
            return false;
        }
        FirFile useSiteFile = firFile;
        FirMemberDeclaration firMemberDeclaration = FirDeclarationUtilKt.asMemberDeclarationResolvedTo($this$isVisible, FirResolvePhase.STATUS);
        if (firMemberDeclaration == null) {
            return false;
        }
        FirMemberDeclaration $this$visibility$iv = fir = firMemberDeclaration;
        boolean $i$f$getVisibility = false;
        Visibility visibility = $this$visibility$iv.getStatus().getVisibility();
        if (!Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Unknown.INSTANCE) && !visibility.mustCheckInImports()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)visibility, (Object)Visibilities.Private.INSTANCE) || Intrinsics.areEqual((Object)visibility, (Object)Visibilities.PrivateToThis.INSTANCE)) {
            return Intrinsics.areEqual((Object)useSiteFile, (Object)FirProviderUtilsKt.getContainingFile(FirProviderKt.getFirProvider(context2.getSession()), $this$isVisible));
        }
        return FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()), fir, context2.getSession(), useSiteFile, CollectionsKt.emptyList(), null, false, null, true, null, 352, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkConflictingImports(List<? extends FirImport> imports, CheckerContext context, DiagnosticReporter reporter) {
        var5_4 = imports;
        $i$f$filterIsInstanceWithChecker = false;
        result$iv = new ArrayList<E>();
        for (T element$iv : $this$filterIsInstanceWithChecker$iv) {
            if (!(element$iv instanceof FirResolvedImport)) continue;
            import = (FirResolvedImport)element$iv;
            $i$a$-filterIsInstanceWithChecker-FirImportsChecker$checkConflictingImports$interestingImports$1 = false;
            if (import.isAllUnder()) ** GOTO lbl-1000
            v0 = import.getSource();
            if (v0 != null && (v0 = v0.getKind()) != null ? v0.getShouldSkipErrorTypeReporting() : false) ** GOTO lbl-1000
            v1 = import.getImportedName();
            v2 = v1 != null && (v1 = v1.getIdentifierOrNullIfSpecial()) != null ? ((CharSequence)v1).length() > 0 : false;
            if (v2 && FirImportsChecker.INSTANCE.resolvesToClass((FirResolvedImport)import, context)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            ((Collection)result$iv).add(element$iv);
        }
        $this$filterIsInstanceWithChecker$iv = result$iv;
        $i$f$filterNot = false;
        result$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (E element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (FirResolvedImport)element$iv$iv;
            $i$a$-filterNot-FirImportsChecker$checkConflictingImports$interestingImports$2 = false;
            var14_22 = it.getSource();
            v4 = var14_22 instanceof KtFakeSourceElement != false ? (KtFakeSourceElement)var14_22 : null;
            if (Intrinsics.areEqual((Object)(v4 != null ? v4.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitImport.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        interestingImports = (List)destination$iv$iv;
        $this$filterNot$iv = interestingImports;
        $i$f$groupBy = false;
        $this$filterNotTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (T element$iv$iv : $this$groupByTo$iv$iv) {
            it = (FirResolvedImport)element$iv$iv;
            $i$a$-groupBy-FirImportsChecker$checkConflictingImports$1 = false;
            v5 = it.getAliasName();
            if (v5 == null) {
                v6 = it.getImportedName();
                v5 = v6;
                Intrinsics.checkNotNull((Object)v6);
            }
            key$iv$iv = v5;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v7 /* !! */  = answer$iv$iv$iv;
            } else {
                v7 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v7 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (List)element$iv$iv;
            $i$a$-filter-FirImportsChecker$checkConflictingImports$2 = false;
            if (!(it.size() > 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            conflicts = (List)element$iv;
            $i$a$-forEach-FirImportsChecker$checkConflictingImports$3 = false;
            $this$forEach$iv = conflicts;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (FirResolvedImport)element$iv;
                $i$a$-forEach-FirImportsChecker$checkConflictingImports$3$1 = false;
                v8 = it.getSource();
                v9 = FirErrors.INSTANCE.getCONFLICTING_IMPORT();
                v10 = it.getImportedName();
                Intrinsics.checkNotNull((Object)v10);
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, v8, v9, (Object)v10, (DiagnosticContext)context, null, 16, null);
            }
        }
    }

    private final void checkOperatorRename(FirResolvedImport firResolvedImport, CheckerContext context2, DiagnosticReporter reporter) {
        boolean illegalRename;
        block10: {
            boolean bl;
            Name name2 = firResolvedImport.getAliasName();
            if (name2 == null) {
                return;
            }
            Name alias = name2;
            Name name3 = firResolvedImport.getImportedName();
            if (name3 == null) {
                return;
            }
            Name importedName = name3;
            if (!OperatorConventions.isConventionName(alias)) {
                return;
            }
            ClassId classId = firResolvedImport.getResolvedParentClassId();
            if (classId != null) {
                FirRegularClassSymbol firRegularClassSymbol = this.resolveToClass(classId, context2);
                if (firRegularClassSymbol == null) {
                    return;
                }
                FirRegularClassSymbol classFir = firRegularClassSymbol;
                bl = classFir.getClassKind().isSingleton() && this.hasFunction(classFir, context2, importedName, (Function1<? super FirNamedFunctionSymbol, Boolean>)((Function1)FirImportsChecker::checkOperatorRename$lambda$11));
            } else {
                Iterable $this$any$iv = FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getTopLevelFunctionSymbols(firResolvedImport.getPackageFqName(), importedName);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirNamedFunctionSymbol it = (FirNamedFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        FirCallableSymbol $this$isOperator$iv = it;
                        boolean $i$f$isOperator = false;
                        if (!$this$isOperator$iv.getResolvedStatus().isOperator()) continue;
                        bl = true;
                        break block10;
                    }
                    bl = illegalRename = false;
                }
            }
        }
        if (illegalRename) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firResolvedImport.getSource(), FirErrors.INSTANCE.getOPERATOR_RENAMED_ON_IMPORT(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean resolvesToClass(FirResolvedImport $this$resolvesToClass, CheckerContext context2) {
        if ($this$resolvesToClass.getResolvedParentClassId() != null) {
            if ($this$resolvesToClass.isAllUnder()) {
                return true;
            }
            ClassId classId = $this$resolvesToClass.getResolvedParentClassId();
            Intrinsics.checkNotNull((Object)classId);
            ClassId parentClass = classId;
            FqName fqName = $this$resolvesToClass.getRelativeParentClassName();
            if (fqName == null) {
                return false;
            }
            FqName relativeClassName = fqName;
            Name name2 = $this$resolvesToClass.getImportedName();
            if (name2 == null) {
                return false;
            }
            Name importedName = name2;
            FqName fqName2 = parentClass.getPackageFqName();
            FqName fqName3 = relativeClassName.child(importedName);
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"child(...)");
            ClassId innerClassId = new ClassId(fqName2, fqName3, false);
            return this.resolveToClass(innerClassId, context2) != null;
        }
        FqName fqName = $this$resolvesToClass.getImportedFqName();
        if (fqName == null) {
            return false;
        }
        FqName importedFqName = fqName;
        if (importedFqName.isRoot()) {
            return false;
        }
        ClassId importedClassId = ClassId.Companion.topLevel(importedFqName);
        return this.resolveToClass(importedClassId, context2) != null;
    }

    private final FirClassLikeSymbol<?> resolveToClassLike(ClassId $this$resolveToClassLike, CheckerContext context2) {
        return FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId($this$resolveToClassLike);
    }

    private final FirRegularClassSymbol resolveToClass(ClassId $this$resolveToClass, CheckerContext context2) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = this.resolveToClassLike($this$resolveToClass, context2);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> classSymbol = firClassLikeSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = classSymbol;
        if (firClassLikeSymbol2 instanceof FirRegularClassSymbol) {
            firRegularClassSymbol = (FirRegularClassSymbol)classSymbol;
        } else if (firClassLikeSymbol2 instanceof FirTypeAliasSymbol) {
            firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(classSymbol, context2.getSession());
        } else if (firClassLikeSymbol2 instanceof FirAnonymousObjectSymbol) {
            firRegularClassSymbol = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return firRegularClassSymbol;
    }

    private final boolean hasFunction(FirRegularClassSymbol $this$hasFunction, CheckerContext context2, Name name2, Function1<? super FirNamedFunctionSymbol, Boolean> predicate) {
        Ref.BooleanRef result2 = new Ref.BooleanRef();
        FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$hasFunction, null).processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirImportsChecker.hasFunction$lambda$13(result2, predicate, arg_0)));
        return result2.element;
    }

    private final ImportStatus getImportStatusOfCallableMembers(FirRegularClassSymbol $this$getImportStatusOfCallableMembers, CheckerContext context2, Name name2) {
        ImportStatus importStatus;
        block16: {
            if ($this$getImportStatusOfCallableMembers.getClassKind().isSingleton()) {
                boolean bl;
                Object[] objectArray = new FirContainingNamesAwareScope[]{FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$getImportStatusOfCallableMembers, null), FirHelpersKt.unsubstitutedScope($this$getImportStatusOfCallableMembers, context2)};
                List scopes = CollectionsKt.listOf((Object[])objectArray);
                FirImportsChecker this_$iv = this;
                boolean $i$f$getImportStatus = false;
                Ref.BooleanRef found$iv = new Ref.BooleanRef();
                Ref.ObjectRef symbol$iv = new Ref.ObjectRef();
                for (FirContainingNamesAwareScope scope$iv : scopes) {
                    scope$iv.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(context2, found$iv, symbol$iv){
                        final /* synthetic */ CheckerContext $context;
                        final /* synthetic */ Ref.BooleanRef $found;
                        final /* synthetic */ Ref.ObjectRef $symbol;
                        {
                            this.$context = $context;
                            this.$found = $found;
                            this.$symbol = $symbol;
                        }

                        public final void invoke(FirNamedFunctionSymbol sym) {
                            Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                            if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context)) {
                                FirCallableSymbol it = sym;
                                boolean bl = false;
                                if (true) {
                                    this.$found.element = true;
                                }
                            }
                            this.$symbol.element = sym;
                        }
                    }));
                    if (found$iv.element) {
                        importStatus = ImportStatus.OK.INSTANCE;
                    } else {
                        scope$iv.processPropertiesByName(name2, (Function1)new Function1<FirVariableSymbol<?>, Unit>(context2, found$iv, symbol$iv){
                            final /* synthetic */ CheckerContext $context;
                            final /* synthetic */ Ref.BooleanRef $found;
                            final /* synthetic */ Ref.ObjectRef $symbol;
                            {
                                this.$context = $context;
                                this.$found = $found;
                                this.$symbol = $symbol;
                            }

                            public final void invoke(FirVariableSymbol<?> sym) {
                                Intrinsics.checkNotNullParameter(sym, (String)"sym");
                                if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context)) {
                                    FirCallableSymbol it = sym;
                                    boolean bl = false;
                                    if (true) {
                                        this.$found.element = true;
                                    }
                                }
                                this.$symbol.element = sym;
                            }
                        });
                        if (!found$iv.element) continue;
                        importStatus = ImportStatus.OK.INSTANCE;
                    }
                    break block16;
                }
                FirCallableSymbol firCallableSymbol = (FirCallableSymbol)symbol$iv.element;
                if (firCallableSymbol != null) {
                    FirCallableSymbol it = firCallableSymbol;
                    boolean bl2 = false;
                    bl = true;
                } else {
                    bl = false;
                }
                if (bl) {
                    Object object = symbol$iv.element;
                    Intrinsics.checkNotNull((Object)object);
                    importStatus = new ImportStatus.Invisible((FirCallableSymbol)object);
                } else {
                    importStatus = symbol$iv.element != null ? (ImportStatus)ImportStatus.CannotBeImported.INSTANCE : (ImportStatus)ImportStatus.Unresolved.INSTANCE;
                }
            } else {
                boolean bl;
                Object this_$iv = new FirContainingNamesAwareScope[]{FirDeclaredMemberScopeProviderKt.declaredMemberScope(context2.getSession(), $this$getImportStatusOfCallableMembers, null), ImplicitReceiverUtilsKt.staticScope($this$getImportStatusOfCallableMembers, context2.getSessionHolder()), FirHelpersKt.unsubstitutedScope($this$getImportStatusOfCallableMembers, context2)};
                List scopes = CollectionsKt.listOfNotNull((Object[])this_$iv);
                this_$iv = this;
                boolean $i$f$getImportStatus = false;
                Ref.BooleanRef found$iv = new Ref.BooleanRef();
                Ref.ObjectRef symbol$iv = new Ref.ObjectRef();
                for (FirContainingNamesAwareScope scope$iv : scopes) {
                    scope$iv.processFunctionsByName(name2, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(context2, found$iv, symbol$iv){
                        final /* synthetic */ CheckerContext $context;
                        final /* synthetic */ Ref.BooleanRef $found;
                        final /* synthetic */ Ref.ObjectRef $symbol;
                        {
                            this.$context = $context;
                            this.$found = $found;
                            this.$symbol = $symbol;
                        }

                        public final void invoke(FirNamedFunctionSymbol sym) {
                            Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
                            if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context)) {
                                FirCallableSymbol it = sym;
                                boolean bl = false;
                                FirCallableSymbol $this$isStatic$iv = it;
                                boolean $i$f$isStatic = false;
                                if ($this$isStatic$iv.getRawStatus().isStatic()) {
                                    this.$found.element = true;
                                }
                            }
                            this.$symbol.element = sym;
                        }
                    }));
                    if (found$iv.element) {
                        importStatus = ImportStatus.OK.INSTANCE;
                    } else {
                        scope$iv.processPropertiesByName(name2, (Function1)new Function1<FirVariableSymbol<?>, Unit>(context2, found$iv, symbol$iv){
                            final /* synthetic */ CheckerContext $context;
                            final /* synthetic */ Ref.BooleanRef $found;
                            final /* synthetic */ Ref.ObjectRef $symbol;
                            {
                                this.$context = $context;
                                this.$found = $found;
                                this.$symbol = $symbol;
                            }

                            public final void invoke(FirVariableSymbol<?> sym) {
                                Intrinsics.checkNotNullParameter(sym, (String)"sym");
                                if (FirImportsChecker.access$isVisible(FirImportsChecker.INSTANCE, sym, this.$context)) {
                                    FirCallableSymbol it = sym;
                                    boolean bl = false;
                                    FirCallableSymbol $this$isStatic$iv = it;
                                    boolean $i$f$isStatic = false;
                                    if ($this$isStatic$iv.getRawStatus().isStatic()) {
                                        this.$found.element = true;
                                    }
                                }
                                this.$symbol.element = sym;
                            }
                        });
                        if (!found$iv.element) continue;
                        importStatus = ImportStatus.OK.INSTANCE;
                    }
                    break block16;
                }
                FirCallableSymbol firCallableSymbol = (FirCallableSymbol)symbol$iv.element;
                if (firCallableSymbol != null) {
                    FirCallableSymbol it = firCallableSymbol;
                    boolean bl3 = false;
                    FirCallableSymbol $this$isStatic$iv = it;
                    boolean $i$f$isStatic = false;
                    bl = $this$isStatic$iv.getRawStatus().isStatic();
                } else {
                    bl = false;
                }
                if (bl) {
                    Object object = symbol$iv.element;
                    Intrinsics.checkNotNull((Object)object);
                    importStatus = new ImportStatus.Invisible((FirCallableSymbol)object);
                } else {
                    importStatus = symbol$iv.element != null ? (ImportStatus)ImportStatus.CannotBeImported.INSTANCE : (ImportStatus)ImportStatus.Unresolved.INSTANCE;
                }
            }
        }
        return importStatus;
    }

    private final void checkImportApiStatus(FirImport firImport, CheckerContext context2, DiagnosticReporter reporter) {
        FqName importedFqName;
        block7: {
            block6: {
                FqName fqName = firImport.getImportedFqName();
                if (fqName == null) {
                    return;
                }
                importedFqName = fqName;
                if (importedFqName.isRoot()) break block6;
                String string2 = importedFqName.shortName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
                if (!(((CharSequence)string2).length() == 0)) break block7;
            }
            return;
        }
        Object object = firImport instanceof FirResolvedImport ? (FirResolvedImport)firImport : null;
        if (object == null || (object = ((FirResolvedImport)object).getResolvedParentClassId()) == null) {
            object = ClassId.Companion.topLevel(importedFqName);
        }
        Object classId = object;
        FirClassifierSymbol<?> firClassifierSymbol = FirSymbolProviderKt.toSymbol((ClassId)classId, context2.getSession());
        if (firClassifierSymbol == null) {
            return;
        }
        FirClassifierSymbol<?> symbol = firClassifierSymbol;
        FirDeprecationChecker.reportApiStatusIfNeeded$checkers$default(FirDeprecationChecker.INSTANCE, firImport.getSource(), symbol, context2, reporter, null, 16, null);
    }

    private static final void checkCanBeImported$reportInvisibleParentClasses(CheckerContext $context, FirImport $import, DiagnosticReporter $reporter, FirRegularClassSymbol classSymbol, int depth) {
        block1: {
            Object object;
            if (!INSTANCE.isVisible(classSymbol, $context)) {
                KtSourceElement source = FirSourceUtilsKt.getSourceForImportSegment($import, depth);
                $reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(classSymbol, source), $context);
            }
            if ((object = classSymbol.getClassId().getOuterClassId()) == null || (object = INSTANCE.resolveToClass((ClassId)object, $context)) == null) break block1;
            Object it = object;
            boolean bl = false;
            FirImportsChecker.checkCanBeImported$reportInvisibleParentClasses($context, $import, $reporter, (FirRegularClassSymbol)it, depth + 1);
        }
    }

    private static final boolean checkOperatorRename$lambda$11(FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FirCallableSymbol $this$isOperator$iv = it;
        boolean $i$f$isOperator = false;
        return $this$isOperator$iv.getResolvedStatus().isOperator();
    }

    private static final Unit hasFunction$lambda$13(Ref.BooleanRef $result, Function1 $predicate, FirNamedFunctionSymbol sym) {
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Intrinsics.checkNotNullParameter((Object)$predicate, (String)"$predicate");
        Intrinsics.checkNotNullParameter((Object)sym, (String)"sym");
        if (!$result.element) {
            $result.element = (Boolean)$predicate.invoke((Object)sym);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isVisible(FirImportsChecker $this, FirBasedSymbol $receiver, CheckerContext context2) {
        return $this.isVisible($receiver, context2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "", "<init>", "()V", "OK", "Invisible", "CannotBeImported", "Unresolved", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$CannotBeImported;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Invisible;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$OK;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Unresolved;", "checkers"})
    private static abstract class ImportStatus {
        private ImportStatus() {
        }

        public /* synthetic */ ImportStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$CannotBeImported;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class CannotBeImported
        extends ImportStatus {
            @NotNull
            public static final CannotBeImported INSTANCE = new CannotBeImported();

            private CannotBeImported() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "CannotBeImported";
            }

            public int hashCode() {
                return 1558473421;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CannotBeImported)) {
                    return false;
                }
                CannotBeImported cfr_ignored_0 = (CannotBeImported)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0017\u0010\t\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Invisible;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "getSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class Invisible
        extends ImportStatus {
            @NotNull
            private final FirCallableSymbol<?> symbol;

            public Invisible(@NotNull FirCallableSymbol<?> symbol) {
                Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                super(null);
                this.symbol = symbol;
            }

            @NotNull
            public final FirCallableSymbol<?> getSymbol() {
                return this.symbol;
            }

            @NotNull
            public final FirCallableSymbol<?> component1() {
                return this.symbol;
            }

            @NotNull
            public final Invisible copy(@NotNull FirCallableSymbol<?> symbol) {
                Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
                return new Invisible(symbol);
            }

            public static /* synthetic */ Invisible copy$default(Invisible invisible, FirCallableSymbol firCallableSymbol, int n, Object object) {
                if ((n & 1) != 0) {
                    firCallableSymbol = invisible.symbol;
                }
                return invisible.copy(firCallableSymbol);
            }

            @NotNull
            public String toString() {
                return "Invisible(symbol=" + this.symbol + ')';
            }

            public int hashCode() {
                return this.symbol.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Invisible)) {
                    return false;
                }
                Invisible invisible = (Invisible)other;
                return Intrinsics.areEqual(this.symbol, invisible.symbol);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$OK;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class OK
        extends ImportStatus {
            @NotNull
            public static final OK INSTANCE = new OK();

            private OK() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "OK";
            }

            public int hashCode() {
                return -1967623169;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof OK)) {
                    return false;
                }
                OK cfr_ignored_0 = (OK)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus$Unresolved;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirImportsChecker$ImportStatus;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "checkers"})
        public static final class Unresolved
        extends ImportStatus {
            @NotNull
            public static final Unresolved INSTANCE = new Unresolved();

            private Unresolved() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Unresolved";
            }

            public int hashCode() {
                return -1417964332;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Unresolved)) {
                    return false;
                }
                Unresolved cfr_ignored_0 = (Unresolved)other;
                return true;
            }
        }
    }
}

