/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.fir;

import com.intellij.lang.LighterASTNode;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0016\u001a\u00020\u0004J\u0006\u0010\u0017\u001a\u00020\u0004J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00c6\u0003JA\u0010\u001d\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/lightTree/fir/WhenEntry;", "", "conditions", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "firBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "node", "Lcom/intellij/lang/LighterASTNode;", "isElse", "", "shouldBindSubject", "<init>", "(Ljava/util/List;Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Lcom/intellij/lang/LighterASTNode;ZZ)V", "getConditions", "()Ljava/util/List;", "getFirBlock", "()Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "getNode", "()Lcom/intellij/lang/LighterASTNode;", "()Z", "getShouldBindSubject", "toFirWhenCondition", "toFirWhenConditionWithoutSubject", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "light-tree2fir"})
public final class WhenEntry {
    @NotNull
    private final List<FirExpression> conditions;
    @NotNull
    private final FirBlock firBlock;
    @NotNull
    private final LighterASTNode node;
    private final boolean isElse;
    private final boolean shouldBindSubject;

    public WhenEntry(@NotNull List<? extends FirExpression> conditions, @NotNull FirBlock firBlock, @NotNull LighterASTNode node, boolean isElse, boolean shouldBindSubject) {
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        Intrinsics.checkNotNullParameter((Object)firBlock, (String)"firBlock");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.conditions = conditions;
        this.firBlock = firBlock;
        this.node = node;
        this.isElse = isElse;
        this.shouldBindSubject = shouldBindSubject;
    }

    public /* synthetic */ WhenEntry(List list, FirBlock firBlock, LighterASTNode lighterASTNode, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(list, firBlock, lighterASTNode, bl, bl2);
    }

    @NotNull
    public final List<FirExpression> getConditions() {
        return this.conditions;
    }

    @NotNull
    public final FirBlock getFirBlock() {
        return this.firBlock;
    }

    @NotNull
    public final LighterASTNode getNode() {
        return this.node;
    }

    public final boolean isElse() {
        return this.isElse;
    }

    public final boolean getShouldBindSubject() {
        return this.shouldBindSubject;
    }

    @NotNull
    public final FirExpression toFirWhenCondition() {
        if (!(!((Collection)this.conditions).isEmpty())) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        return ConversionUtilsKt.buildBalancedOrExpressionTree$default(this.conditions, 0, 0, 6, null);
    }

    @NotNull
    public final FirExpression toFirWhenConditionWithoutSubject() {
        return this.conditions.size() == 0 ? (FirExpression)FirExpressionUtilKt.buildErrorExpression$default(null, new ConeSyntaxDiagnostic("No expression in condition with expression"), null, 4, null) : ConversionUtilsKt.buildBalancedOrExpressionTree$default(this.conditions, 0, 0, 6, null);
    }

    @NotNull
    public final List<FirExpression> component1() {
        return this.conditions;
    }

    @NotNull
    public final FirBlock component2() {
        return this.firBlock;
    }

    @NotNull
    public final LighterASTNode component3() {
        return this.node;
    }

    public final boolean component4() {
        return this.isElse;
    }

    public final boolean component5() {
        return this.shouldBindSubject;
    }

    @NotNull
    public final WhenEntry copy(@NotNull List<? extends FirExpression> conditions, @NotNull FirBlock firBlock, @NotNull LighterASTNode node, boolean isElse, boolean shouldBindSubject) {
        Intrinsics.checkNotNullParameter(conditions, (String)"conditions");
        Intrinsics.checkNotNullParameter((Object)firBlock, (String)"firBlock");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return new WhenEntry(conditions, firBlock, node, isElse, shouldBindSubject);
    }

    public static /* synthetic */ WhenEntry copy$default(WhenEntry whenEntry, List list, FirBlock firBlock, LighterASTNode lighterASTNode, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            list = whenEntry.conditions;
        }
        if ((n & 2) != 0) {
            firBlock = whenEntry.firBlock;
        }
        if ((n & 4) != 0) {
            lighterASTNode = whenEntry.node;
        }
        if ((n & 8) != 0) {
            bl = whenEntry.isElse;
        }
        if ((n & 0x10) != 0) {
            bl2 = whenEntry.shouldBindSubject;
        }
        return whenEntry.copy(list, firBlock, lighterASTNode, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "WhenEntry(conditions=" + this.conditions + ", firBlock=" + this.firBlock + ", node=" + this.node + ", isElse=" + this.isElse + ", shouldBindSubject=" + this.shouldBindSubject + ')';
    }

    public int hashCode() {
        int result2 = ((Object)this.conditions).hashCode();
        result2 = result2 * 31 + this.firBlock.hashCode();
        result2 = result2 * 31 + this.node.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isElse);
        result2 = result2 * 31 + Boolean.hashCode(this.shouldBindSubject);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WhenEntry)) {
            return false;
        }
        WhenEntry whenEntry = (WhenEntry)other;
        if (!Intrinsics.areEqual(this.conditions, whenEntry.conditions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.firBlock, (Object)whenEntry.firBlock)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.node, (Object)whenEntry.node)) {
            return false;
        }
        if (this.isElse != whenEntry.isElse) {
            return false;
        }
        return this.shouldBindSubject == whenEntry.shouldBindSubject;
    }
}

