/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference2;
import kotlin.jvm.internal.PropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6AddBoxParameterLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorBoxParameterOptimizationLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0007*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorBoxParameterOptimizationLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "needsOfBoxParameter", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getNeedsOfBoxParameter", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Boolean;", "needsOfBoxParameter$delegate", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "requiredToHaveBoxParameter", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6ConstructorBoxParameterOptimizationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6ConstructorBoxParameterOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorBoxParameterOptimizationLowering\n+ 2 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n56#2:142\n855#3,2:143\n*S KotlinDebug\n*F\n+ 1 ES6ConstructorBoxParameterOptimizationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6ConstructorBoxParameterOptimizationLowering\n*L\n40#1:142\n40#1:143,2\n*E\n"})
public final class ES6ConstructorBoxParameterOptimizationLowering
implements BodyLoweringPass {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final Mapping.Delegate needsOfBoxParameter$delegate;

    public ES6ConstructorBoxParameterOptimizationLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        this.needsOfBoxParameter$delegate = this.context.getMapping().getEsClassWhichNeedBoxParameters();
    }

    private final Boolean getNeedsOfBoxParameter(IrClass $this$needsOfBoxParameter) {
        return (Boolean)this.needsOfBoxParameter$delegate.getValue((IrDeclaration)$this$needsOfBoxParameter, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        boolean shouldRemoveBoxRelatedDeclarationsAndStatements;
        IrFunction containerFunction;
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!this.context.getEs6mode()) {
            return;
        }
        IrFunction irFunction = containerFunction = container instanceof IrFunction ? (IrFunction)container : null;
        boolean bl = shouldRemoveBoxRelatedDeclarationsAndStatements = (irFunction != null ? ES6ConstructorLoweringKt.isEs6ConstructorReplacement(irFunction) : false) && !this.requiredToHaveBoxParameter(IrUtilsKt.getParentAsClass(containerFunction));
        if (containerFunction != null && shouldRemoveBoxRelatedDeclarationsAndStatements && irBody instanceof IrBlockBody) {
            void $this$filterNotTo$iv$iv;
            void $this$memoryOptimizedFilterNot$iv;
            Collection collection = containerFunction.getValueParameters();
            IrFunction irFunction2 = containerFunction;
            boolean $i$f$memoryOptimizedFilterNot = false;
            Iterable iterable = (Iterable)$this$memoryOptimizedFilterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                IrValueParameter it = (IrValueParameter)element$iv$iv;
                boolean bl2 = false;
                if (ES6AddBoxParameterLoweringKt.isBoxParameter(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            irFunction2.setValueParameters(CollectionsKt.compactIfPossible((List)destination$iv$iv));
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(shouldRemoveBoxRelatedDeclarationsAndStatements, this){
            final /* synthetic */ boolean $shouldRemoveBoxRelatedDeclarationsAndStatements;
            final /* synthetic */ ES6ConstructorBoxParameterOptimizationLowering this$0;
            {
                this.$shouldRemoveBoxRelatedDeclarationsAndStatements = $shouldRemoveBoxRelatedDeclarationsAndStatements;
                this.this$0 = $receiver;
            }

            public IrExpression visitWhen(IrWhen expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                return this.$shouldRemoveBoxRelatedDeclarationsAndStatements && ES6AddBoxParameterLoweringKt.isBoxParameterDefaultResolution(expression2) ? IrJsUtilsKt.irEmpty(ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0)) : super.visitWhen(expression2);
            }

            /*
             * WARNING - void declaration
             */
            public IrExpression visitCall(IrCall expression2) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                if (this.$shouldRemoveBoxRelatedDeclarationsAndStatements && (Intrinsics.areEqual((Object)callee.getSymbol(), (Object)ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateThisSymbol()) || Intrinsics.areEqual((Object)callee.getSymbol(), (Object)ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0).getIntrinsics().getJsCreateExternalThisSymbol()))) {
                    expression2.putValueArgument(expression2.getValueArgumentsCount() - 1, IrJsUtilsKt.getVoid(ES6ConstructorBoxParameterOptimizationLowering.access$getContext$p(this.this$0)));
                    irExpression = super.visitCall(expression2);
                } else if (ES6ConstructorLoweringKt.isEs6ConstructorReplacement(callee) && (!ES6ConstructorBoxParameterOptimizationLowering.access$requiredToHaveBoxParameter(this.this$0, IrUtilsKt.getParentAsClass(callee)) || this.$shouldRemoveBoxRelatedDeclarationsAndStatements)) {
                    void $this$visitCall_u24lambda_u240;
                    IrCallImpl irCallImpl;
                    int newArgumentsSize = expression2.getValueArgumentsCount() - 1;
                    IrCallImpl irCallImpl2 = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), expression2.getSymbol(), expression2.getTypeArgumentsCount(), newArgumentsSize, expression2.getOrigin(), expression2.getSuperQualifierSymbol());
                    lower.2 var8_6 = this;
                    boolean bl = false;
                    IrExpressionsKt.copyTypeArgumentsFrom$default((IrMemberAccessExpression)$this$visitCall_u24lambda_u240, expression2, 0, 2, null);
                    $this$visitCall_u24lambda_u240.setDispatchReceiver(expression2.getDispatchReceiver());
                    $this$visitCall_u24lambda_u240.setExtensionReceiver(expression2.getExtensionReceiver());
                    for (int i = 0; i < newArgumentsSize; ++i) {
                        $this$visitCall_u24lambda_u240.putValueArgument(i, expression2.getValueArgument(i));
                    }
                    irExpression = super.visitCall(irCallImpl);
                } else {
                    irExpression = super.visitCall(expression2);
                }
                return irExpression;
            }
        });
    }

    private final boolean requiredToHaveBoxParameter(IrClass $this$requiredToHaveBoxParameter) {
        return Intrinsics.areEqual((Object)this.getNeedsOfBoxParameter($this$requiredToHaveBoxParameter), (Object)true);
    }

    public static final /* synthetic */ JsIrBackendContext access$getContext$p(ES6ConstructorBoxParameterOptimizationLowering $this) {
        return $this.context;
    }

    public static final /* synthetic */ boolean access$requiredToHaveBoxParameter(ES6ConstructorBoxParameterOptimizationLowering $this, IrClass $receiver) {
        return $this.requiredToHaveBoxParameter($receiver);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property2((PropertyReference2)((PropertyReference2)new PropertyReference2Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ES6ConstructorBoxParameterOptimizationLowering.class), "needsOfBoxParameter", "getNeedsOfBoxParameter(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Ljava/lang/Boolean;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

