/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.checker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003!\"#B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\f\u0010\u001c\u001a\u00020\u0005*\u00020\u001dH\u0004J\u0014\u0010\u001e\u001a\u00020\u0005*\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0004\u0082\u0001\u0003$%&\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "", "<init>", "()V", "canEvaluateFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateEnumValue", "enumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "canEvaluateFunctionExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "canEvaluateCallableReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "canEvaluateClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "canEvaluateBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "canEvaluateComposite", "composite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "canEvaluateExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "mustCheckBodyOf", "isMarkedAsIntrinsicConstEvaluation", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isMarkedWith", "annotation", "Lorg/jetbrains/kotlin/name/FqName;", "Full", "OnlyBuiltins", "OnlyIntrinsicConst", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$Full;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$OnlyBuiltins;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$OnlyIntrinsicConst;", "ir.interpreter"})
public abstract class EvaluationMode {
    private EvaluationMode() {
    }

    public boolean canEvaluateFunction(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return false;
    }

    public boolean canEvaluateEnumValue(@NotNull IrGetEnumValue enumEntry) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        return false;
    }

    public boolean canEvaluateFunctionExpression(@NotNull IrFunctionExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return false;
    }

    public boolean canEvaluateCallableReference(@NotNull IrCallableReference<?> reference2) {
        Intrinsics.checkNotNullParameter(reference2, (String)"reference");
        return false;
    }

    public boolean canEvaluateClassReference(@NotNull IrDeclarationReference reference2) {
        Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
        return false;
    }

    public boolean canEvaluateBlock(@NotNull IrBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return false;
    }

    public boolean canEvaluateComposite(@NotNull IrComposite composite) {
        Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
        return Intrinsics.areEqual((Object)composite.getOrigin(), (Object)IrStatementOrigin.Companion.getDESTRUCTURING_DECLARATION()) || composite.getOrigin() == null;
    }

    public boolean canEvaluateExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return false;
    }

    public boolean mustCheckBodyOf(@NotNull IrFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return UtilsKt.getProperty(function2) != null;
    }

    protected final boolean isMarkedAsIntrinsicConstEvaluation(@NotNull IrDeclaration $this$isMarkedAsIntrinsicConstEvaluation) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedAsIntrinsicConstEvaluation, (String)"<this>");
        return this.isMarkedWith($this$isMarkedAsIntrinsicConstEvaluation, UtilsKt.getIntrinsicConstEvaluationAnnotation());
    }

    protected final boolean isMarkedWith(@NotNull IrDeclaration $this$isMarkedWith, @NotNull FqName annotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isMarkedWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        if ($this$isMarkedWith instanceof IrClass && ((IrClass)$this$isMarkedWith).isCompanion()) {
            return false;
        }
        if (UtilsKt.hasAnnotation($this$isMarkedWith, annotation)) {
            return true;
        }
        IrDeclarationParent irDeclarationParent = $this$isMarkedWith.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        return irClass != null ? this.isMarkedWith(irClass, annotation) : false;
    }

    public /* synthetic */ EvaluationMode(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u00052\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$Full;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "<init>", "()V", "canEvaluateFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateEnumValue", "enumEntry", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "canEvaluateFunctionExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "canEvaluateCallableReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrCallableReference;", "canEvaluateClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "canEvaluateBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "canEvaluateComposite", "composite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "canEvaluateExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "mustCheckBodyOf", "equals", "other", "", "hashCode", "", "toString", "", "ir.interpreter"})
    public static final class Full
    extends EvaluationMode {
        @NotNull
        public static final Full INSTANCE = new Full();

        private Full() {
            super(null);
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            return true;
        }

        @Override
        public boolean canEvaluateEnumValue(@NotNull IrGetEnumValue enumEntry) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            return true;
        }

        @Override
        public boolean canEvaluateFunctionExpression(@NotNull IrFunctionExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            return true;
        }

        @Override
        public boolean canEvaluateCallableReference(@NotNull IrCallableReference<?> reference2) {
            Intrinsics.checkNotNullParameter(reference2, (String)"reference");
            return true;
        }

        @Override
        public boolean canEvaluateClassReference(@NotNull IrDeclarationReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            return true;
        }

        @Override
        public boolean canEvaluateBlock(@NotNull IrBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return true;
        }

        @Override
        public boolean canEvaluateComposite(@NotNull IrComposite composite) {
            Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
            return true;
        }

        @Override
        public boolean canEvaluateExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            return true;
        }

        @Override
        public boolean mustCheckBodyOf(@NotNull IrFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            return true;
        }

        @NotNull
        public String toString() {
            return "Full";
        }

        public int hashCode() {
            return 823867991;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Full)) {
                return false;
            }
            Full cfr_ignored_0 = (Full)other;
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\u000e*\u00020\u0018H\u0002J\u0013\u0010\u0019\u001a\u00020\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$OnlyBuiltins;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "<init>", "()V", "allowedMethodsOnPrimitives", "", "", "allowedMethodsOnStrings", "allowedExtensionFunctions", "allowedBuiltinExtensionFunctions", "Lkotlin/jvm/internal/EnhancedNullability;", "allowedOriginsForWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "canEvaluateFunction", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "canEvaluateBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "canEvaluateExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "hasUnsignedArgs", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "equals", "other", "", "hashCode", "", "toString", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nEvaluationMode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvaluationMode.kt\norg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$OnlyBuiltins\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1#2:153\n1755#3,3:154\n1557#3:157\n1628#3,3:158\n*S KotlinDebug\n*F\n+ 1 EvaluationMode.kt\norg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$OnlyBuiltins\n*L\n121#1:154,3\n84#1:157\n84#1:158,3\n*E\n"})
    public static final class OnlyBuiltins
    extends EvaluationMode {
        @NotNull
        public static final OnlyBuiltins INSTANCE;
        @NotNull
        private static final Set<String> allowedMethodsOnPrimitives;
        @NotNull
        private static final Set<String> allowedMethodsOnStrings;
        @NotNull
        private static final Set<String> allowedExtensionFunctions;
        @NotNull
        private static final Set<String> allowedBuiltinExtensionFunctions;
        @NotNull
        private static final Set<IrStatementOriginImpl> allowedOriginsForWhen;

        private OnlyBuiltins() {
            super(null);
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2) {
            boolean bl;
            IrClass parent2;
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            if (UtilsKt.isConst(UtilsKt.getProperty(function2))) {
                return true;
            }
            IrType returnType = function2.getReturnType();
            if (!(IrTypePredicatesKt.isPrimitiveType$default(returnType, false, 1, null) || IrTypePredicatesKt.isString(returnType) || IrTypePredicatesKt.isUnsignedType$default(returnType, false, 1, null))) {
                return false;
            }
            FqName fqName = IrUtilsKt.getFqNameWhenAvailable(function2);
            String fqName2 = fqName != null ? fqName.asString() : null;
            IrClass irClass = parent2 = IrUtilsKt.getParentClassOrNull(function2);
            IrSimpleType parentType = irClass != null ? IrUtilsKt.getDefaultType(irClass) : null;
            if (parentType == null) {
                bl = CollectionsKt.contains((Iterable)allowedExtensionFunctions, (Object)fqName2) || CollectionsKt.contains((Iterable)allowedBuiltinExtensionFunctions, (Object)fqName2);
            } else if (IrTypePredicatesKt.isPrimitiveType$default(parentType, false, 1, null)) {
                bl = allowedMethodsOnPrimitives.contains(function2.getName().asString());
            } else if (IrTypePredicatesKt.isString(parentType)) {
                bl = allowedMethodsOnStrings.contains(function2.getName().asString());
            } else if (IrUtilsKt.isObject(parent2)) {
                IrAnnotationContainer irAnnotationContainer = IrUtilsKt.getParentClassOrNull(parent2);
                if (irAnnotationContainer != null && (irAnnotationContainer = IrUtilsKt.getDefaultType(irAnnotationContainer)) != null) {
                    IrAnnotationContainer it = irAnnotationContainer;
                    boolean bl2 = false;
                    bl = IrTypePredicatesKt.isPrimitiveType$default((IrType)it, false, 1, null) || IrTypeUtilsKt.isUnsigned((IrType)it);
                } else {
                    bl = false;
                }
            } else {
                bl = IrTypePredicatesKt.isUnsignedType$default(parentType, false, 1, null) && function2 instanceof IrConstructor ? true : CollectionsKt.contains((Iterable)allowedExtensionFunctions, (Object)fqName2) || CollectionsKt.contains((Iterable)allowedBuiltinExtensionFunctions, (Object)fqName2);
            }
            return bl;
        }

        @Override
        public boolean canEvaluateBlock(@NotNull IrBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return block.getStatements().size() == 1;
        }

        @Override
        public boolean canEvaluateExpression(@NotNull IrExpression expression2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (expression2 instanceof IrConst) {
                bl = true;
            } else if (expression2 instanceof IrWhen) {
                bl = CollectionsKt.contains((Iterable)allowedOriginsForWhen, (Object)((IrWhen)expression2).getOrigin());
            } else if (!(expression2 instanceof IrCall)) {
                bl = false;
            } else if (this.hasUnsignedArgs((IrCall)expression2)) {
                FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrCall)expression2).getSymbol().getOwner());
                bl = Intrinsics.areEqual((Object)(fqName != null ? fqName.asString() : null), (Object)"kotlin.String.plus");
            } else {
                bl = true;
            }
            return bl;
        }

        private final boolean hasUnsignedArgs(IrCall $this$hasUnsignedArgs) {
            boolean bl;
            block4: {
                if (OnlyBuiltins.hasUnsignedArgs$hasUnsignedType($this$hasUnsignedArgs.getDispatchReceiver()) || OnlyBuiltins.hasUnsignedArgs$hasUnsignedType($this$hasUnsignedArgs.getExtensionReceiver())) {
                    return true;
                }
                Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)$this$hasUnsignedArgs.getValueArgumentsCount());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    Iterator iterator2 = $this$any$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl2 = false;
                        Object object = $this$hasUnsignedArgs.getValueArgument(it);
                        boolean bl3 = object != null && (object = ((IrExpression)object).getType()) != null ? IrTypeUtilsKt.isUnsigned((IrType)object) : false;
                        if (!bl3) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public String toString() {
            return "OnlyBuiltins";
        }

        public int hashCode() {
            return 865484868;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OnlyBuiltins)) {
                return false;
            }
            OnlyBuiltins cfr_ignored_0 = (OnlyBuiltins)other;
            return true;
        }

        private static final boolean hasUnsignedArgs$hasUnsignedType(IrExpression $this$hasUnsignedArgs_u24hasUnsignedType) {
            return $this$hasUnsignedArgs_u24hasUnsignedType != null && IrTypeUtilsKt.isUnsigned($this$hasUnsignedArgs_u24hasUnsignedType.getType());
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$mapTo$iv$iv;
            INSTANCE = new OnlyBuiltins();
            Object[] objectArray = new String[]{"not", "unaryMinus", "unaryPlus", "inv", "toString", "toChar", "toByte", "toShort", "toInt", "toLong", "toFloat", "toDouble", "equals", "compareTo", "plus", "minus", "times", "div", "rem", "and", "or", "xor", "shl", "shr", "ushr", "less", "lessOrEqual", "greater", "greaterOrEqual"};
            allowedMethodsOnPrimitives = SetsKt.setOf((Object[])objectArray);
            objectArray = new String[]{"<get-length>", "plus", "get", "compareTo", "equals", "toString"};
            allowedMethodsOnStrings = SetsKt.setOf((Object[])objectArray);
            objectArray = new String[]{"kotlin.floorDiv", "kotlin.mod", "kotlin.NumbersKt.floorDiv", "kotlin.NumbersKt.mod", "kotlin.<get-code>"};
            allowedExtensionFunctions = SetsKt.setOf((Object[])objectArray);
            objectArray = new String[]{"less", "lessOrEqual", "greater", "greaterOrEqual", "EQEQ", "ieee754equals", "ANDAND", "OROR"};
            Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN().child(Name.identifier((String)it)).asString());
            }
            allowedBuiltinExtensionFunctions = CollectionsKt.toSet((Iterable)((List)var3_3));
            objectArray = new IrStatementOriginImpl[]{IrStatementOrigin.Companion.getANDAND(), IrStatementOrigin.Companion.getOROR()};
            allowedOriginsForWhen = SetsKt.setOf((Object[])objectArray);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\u0003*\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u0003*\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode$OnlyIntrinsicConst;", "Lorg/jetbrains/kotlin/ir/interpreter/checker/EvaluationMode;", "isFloatingPointOptimizationDisabled", "", "<init>", "(Z)V", "canEvaluateFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isFloatingPointOperation", "isCompileTimePropertyAccessor", "canEvaluateBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "canEvaluateExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ir.interpreter"})
    public static final class OnlyIntrinsicConst
    extends EvaluationMode {
        private final boolean isFloatingPointOptimizationDisabled;

        public OnlyIntrinsicConst(boolean isFloatingPointOptimizationDisabled) {
            super(null);
            this.isFloatingPointOptimizationDisabled = isFloatingPointOptimizationDisabled;
        }

        public /* synthetic */ OnlyIntrinsicConst(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        @Override
        public boolean canEvaluateFunction(@NotNull IrFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            if (this.isFloatingPointOptimizationDisabled && this.isFloatingPointOperation(function2)) {
                return false;
            }
            return this.isCompileTimePropertyAccessor(function2) || this.isMarkedAsIntrinsicConstEvaluation(function2);
        }

        private final boolean isFloatingPointOperation(IrFunction $this$isFloatingPointOperation) {
            IrDeclarationParent irDeclarationParent = $this$isFloatingPointOperation.getParent();
            IrAnnotationContainer irAnnotationContainer = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
            if (irAnnotationContainer == null || (irAnnotationContainer = IrUtilsKt.getDefaultType(irAnnotationContainer)) == null) {
                return false;
            }
            IrAnnotationContainer parentType = irAnnotationContainer;
            return IrTypePredicatesKt.isDoubleOrFloatWithoutNullability((IrType)parentType) || IrTypePredicatesKt.isDoubleOrFloatWithoutNullability($this$isFloatingPointOperation.getReturnType());
        }

        private final boolean isCompileTimePropertyAccessor(IrFunction $this$isCompileTimePropertyAccessor) {
            IrDeclarationBase irDeclarationBase = $this$isCompileTimePropertyAccessor;
            if (irDeclarationBase == null || (irDeclarationBase = UtilsKt.getProperty((IrFunction)irDeclarationBase)) == null) {
                return false;
            }
            IrDeclarationBase property = irDeclarationBase;
            return ((IrProperty)property).isConst() || this.isMarkedAsIntrinsicConstEvaluation(property);
        }

        @Override
        public boolean canEvaluateBlock(@NotNull IrBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            return Intrinsics.areEqual((Object)block.getOrigin(), (Object)IrStatementOrigin.Companion.getWHEN()) || block.getStatements().size() == 1;
        }

        @Override
        public boolean canEvaluateExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (this.isFloatingPointOptimizationDisabled && IrTypePredicatesKt.isDoubleOrFloatWithoutNullability(expression2.getType())) {
                return false;
            }
            return OnlyBuiltins.INSTANCE.canEvaluateExpression(expression2) || expression2 instanceof IrWhen;
        }

        public OnlyIntrinsicConst() {
            this(false, 1, null);
        }
    }
}

