/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.metadata.BoxingKind;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.translate.context.TemporaryConstVariable;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.js.translate.utils.jsAstUtils.AstUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

public final class TranslationUtils {
    private static final Set<FqNameUnsafe> CLASSES_WITH_NON_BOXED_CHARS = new HashSet<FqNameUnsafe>(Arrays.asList(new FqNameUnsafe("kotlin.collections.CharIterator"), new FqNameUnsafe("kotlin.ranges.CharProgression"), new FqNameUnsafe("kotlin.js.internal.CharCompanionObject"), new FqNameUnsafe("kotlin.Char.Companion"), StandardNames.FqNames.charSequence, StandardNames.FqNames.number));

    private TranslationUtils() {
    }

    @NotNull
    public static JsPropertyInitializer translateFunctionAsEcma5PropertyDescriptor(@NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context2) {
        if (function2 == null) {
            TranslationUtils.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(2);
        }
        JsExpression functionExpression = function2;
        if (InlineUtil.isInline(descriptor)) {
            InlineMetadata metadata = InlineMetadata.compose(function2, descriptor, context2);
            PsiElement sourceInfo = PsiSourceElementKt.getPsi(descriptor.getSource());
            functionExpression = metadata.functionWithMetadata(context2, sourceInfo);
        }
        if (DescriptorUtils.isExtension(descriptor) || descriptor instanceof PropertyAccessorDescriptor && TranslationUtils.shouldAccessViaFunctions(((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty())) {
            return TranslationUtils.translateExtensionFunctionAsEcma5DataDescriptor(functionExpression, descriptor, context2);
        }
        JsStringLiteral getOrSet = new JsStringLiteral(TranslationUtils.getAccessorFunctionName(descriptor));
        return new JsPropertyInitializer(getOrSet, functionExpression);
    }

    @NotNull
    private static String getAccessorFunctionName(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(3);
        }
        boolean isGetter = descriptor instanceof PropertyGetterDescriptor || descriptor instanceof LocalVariableAccessorDescriptor.Getter;
        return isGetter ? "get" : "set";
    }

    @NotNull
    public static JsFunction simpleReturnFunction(@NotNull JsScope functionScope, @NotNull JsExpression returnExpression) {
        if (functionScope == null) {
            TranslationUtils.$$$reportNull$$$0(4);
        }
        if (returnExpression == null) {
            TranslationUtils.$$$reportNull$$$0(5);
        }
        JsReturn jsReturn = new JsReturn(returnExpression);
        jsReturn.setSource(returnExpression.getSource());
        return new JsFunction(functionScope, new JsBlock((JsStatement)jsReturn), "<simpleReturnFunction>");
    }

    @NotNull
    private static JsPropertyInitializer translateExtensionFunctionAsEcma5DataDescriptor(@NotNull JsExpression functionExpression, @NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context2) {
        if (functionExpression == null) {
            TranslationUtils.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(8);
        }
        JsObjectLiteral meta = JsAstUtils.createDataDescriptor(functionExpression, ModalityUtilsKt.isOverridable(descriptor), false);
        return new JsPropertyInitializer(context2.getNameForDescriptor(descriptor).makeRef(), meta);
    }

    @NotNull
    public static JsExpression translateExclForBinaryEqualLikeExpr(@NotNull JsBinaryOperation baseBinaryExpression) {
        if (baseBinaryExpression == null) {
            TranslationUtils.$$$reportNull$$$0(9);
        }
        JsBinaryOperator negatedOperator = TranslationUtils.notOperator(baseBinaryExpression.getOperator());
        assert (negatedOperator != null) : "Can't negate operator: " + baseBinaryExpression.getOperator();
        return new JsBinaryOperation(negatedOperator, baseBinaryExpression.getArg1(), baseBinaryExpression.getArg2());
    }

    public static boolean isEqualLikeOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            TranslationUtils.$$$reportNull$$$0(10);
        }
        return TranslationUtils.notOperator(operator) != null;
    }

    @Nullable
    private static JsBinaryOperator notOperator(@NotNull JsBinaryOperator operator) {
        if (operator == null) {
            TranslationUtils.$$$reportNull$$$0(11);
        }
        switch (operator) {
            case REF_EQ: {
                return JsBinaryOperator.REF_NEQ;
            }
            case REF_NEQ: {
                return JsBinaryOperator.REF_EQ;
            }
            case EQ: {
                return JsBinaryOperator.NEQ;
            }
            case NEQ: {
                return JsBinaryOperator.EQ;
            }
        }
        return null;
    }

    @NotNull
    public static JsBinaryOperation isNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            TranslationUtils.$$$reportNull$$$0(12);
        }
        return TranslationUtils.nullCheck(expressionToCheck, false);
    }

    @NotNull
    private static JsBinaryOperation isNotNullCheck(@NotNull JsExpression expressionToCheck) {
        if (expressionToCheck == null) {
            TranslationUtils.$$$reportNull$$$0(13);
        }
        return TranslationUtils.nullCheck(expressionToCheck, true);
    }

    @NotNull
    public static JsBinaryOperation nullCheck(@NotNull JsExpression expressionToCheck, boolean isNegated) {
        if (expressionToCheck == null) {
            TranslationUtils.$$$reportNull$$$0(14);
        }
        JsBinaryOperator operator = isNegated ? JsBinaryOperator.NEQ : JsBinaryOperator.EQ;
        return new JsBinaryOperation(operator, expressionToCheck, new JsNullLiteral());
    }

    @NotNull
    private static JsExpression prepareForNullCheck(@NotNull KtExpression ktSubject, @NotNull JsExpression expression2, @NotNull TranslationContext context2) {
        KotlinType type2;
        if (ktSubject == null) {
            TranslationUtils.$$$reportNull$$$0(15);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(16);
        }
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(17);
        }
        if ((type2 = context2.bindingContext().getType(ktSubject)) == null) {
            type2 = context2.getCurrentModule().getBuiltIns().getAnyType();
        }
        return TranslationUtils.coerce(context2, expression2, TypeUtils.makeNullable(type2));
    }

    @NotNull
    public static JsBinaryOperation nullCheck(@NotNull KtExpression ktSubject, @NotNull JsExpression expressionToCheck, @NotNull TranslationContext context2, boolean isNegated) {
        if (ktSubject == null) {
            TranslationUtils.$$$reportNull$$$0(18);
        }
        if (expressionToCheck == null) {
            TranslationUtils.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(20);
        }
        return TranslationUtils.nullCheck(TranslationUtils.prepareForNullCheck(ktSubject, expressionToCheck, context2), isNegated);
    }

    @NotNull
    public static JsBinaryOperation nullCheck(@NotNull KotlinType expressionType, @NotNull JsExpression expressionToCheck, @NotNull TranslationContext context2, boolean isNegated) {
        if (expressionType == null) {
            TranslationUtils.$$$reportNull$$$0(21);
        }
        if (expressionToCheck == null) {
            TranslationUtils.$$$reportNull$$$0(22);
        }
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(23);
        }
        return TranslationUtils.nullCheck(TranslationUtils.coerce(context2, expressionToCheck, TypeUtils.makeNullable(expressionType)), isNegated);
    }

    @NotNull
    public static JsConditional notNullConditional(@NotNull JsExpression expression2, @NotNull JsExpression elseExpression, @NotNull TranslationContext context2) {
        JsExpression thenExpression;
        JsBinaryOperation testExpression;
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(24);
        }
        if (elseExpression == null) {
            TranslationUtils.$$$reportNull$$$0(25);
        }
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(26);
        }
        if (TranslationUtils.isCacheNeeded(expression2)) {
            TemporaryConstVariable tempVar = context2.getOrDeclareTemporaryConstVariable(expression2);
            testExpression = TranslationUtils.isNotNullCheck(tempVar.value());
            thenExpression = tempVar.value();
        } else {
            testExpression = TranslationUtils.isNotNullCheck(expression2);
            thenExpression = expression2;
        }
        return new JsConditional(testExpression, thenExpression, elseExpression);
    }

    @NotNull
    public static JsName getNameForBackingField(@NotNull TranslationContext context2, @NotNull PropertyDescriptor descriptor) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(27);
        }
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(28);
        }
        if (TranslationUtils.isReferenceToSyntheticBackingField(descriptor)) {
            JsName jsName = context2.getNameForBackingField(descriptor);
            if (jsName == null) {
                TranslationUtils.$$$reportNull$$$0(29);
            }
            return jsName;
        }
        DeclarationDescriptor containingDescriptor = descriptor.getContainingDeclaration();
        JsName jsName = containingDescriptor instanceof PackageFragmentDescriptor ? context2.getInnerNameForDescriptor(descriptor) : context2.getNameForDescriptor(descriptor);
        if (jsName == null) {
            TranslationUtils.$$$reportNull$$$0(30);
        }
        return jsName;
    }

    public static boolean isReferenceToSyntheticBackingField(@NotNull PropertyDescriptor descriptor) {
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(31);
        }
        DeclarationDescriptor containingDescriptor = descriptor.getContainingDeclaration();
        return !JsDescriptorUtils.isSimpleFinalProperty(descriptor) && !(containingDescriptor instanceof PackageFragmentDescriptor);
    }

    @NotNull
    public static JsNameRef backingFieldReference(@NotNull TranslationContext context2, @NotNull PropertyDescriptor descriptor) {
        DeclarationDescriptor containingDescriptor;
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(32);
        }
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(33);
        }
        JsExpression receiver = (containingDescriptor = descriptor.getContainingDeclaration()) instanceof PackageFragmentDescriptor ? null : context2.getDispatchReceiver(JsDescriptorUtils.getReceiverParameterForDeclaration(containingDescriptor));
        JsNameRef result2 = new JsNameRef(TranslationUtils.getNameForBackingField(context2, descriptor), receiver);
        MetadataProperties.setType(result2, TranslationUtils.getReturnTypeForCoercion(descriptor, true));
        JsNameRef jsNameRef = result2;
        if (jsNameRef == null) {
            TranslationUtils.$$$reportNull$$$0(34);
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression assignmentToBackingField(@NotNull TranslationContext context2, @NotNull PropertyDescriptor descriptor, @NotNull JsExpression assignTo) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(35);
        }
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(36);
        }
        if (assignTo == null) {
            TranslationUtils.$$$reportNull$$$0(37);
        }
        JsNameRef backingFieldReference = TranslationUtils.backingFieldReference(context2, descriptor);
        JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(backingFieldReference, assignTo);
        if (jsBinaryOperation == null) {
            TranslationUtils.$$$reportNull$$$0(38);
        }
        return jsBinaryOperation;
    }

    @Nullable
    public static JsExpression translateInitializerForProperty(@NotNull KtProperty declaration, @NotNull TranslationContext context2) {
        if (declaration == null) {
            TranslationUtils.$$$reportNull$$$0(39);
        }
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(40);
        }
        JsExpression jsInitExpression = null;
        KtExpression initializer = declaration.getInitializer();
        if (initializer != null) {
            jsInitExpression = Translation.translateAsExpression(initializer, context2);
            KotlinType propertyType = BindingContextUtils.getNotNull(context2.bindingContext(), BindingContext.VARIABLE, declaration).getType();
            jsInitExpression = TranslationUtils.coerce(context2, jsInitExpression, propertyType);
        }
        return jsInitExpression;
    }

    @NotNull
    public static JsExpression translateBaseExpression(@NotNull TranslationContext context2, @NotNull KtUnaryExpression expression2) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(41);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(42);
        }
        KtExpression baseExpression = PsiUtils.getBaseExpression(expression2);
        JsExpression jsExpression = Translation.translateAsExpression(baseExpression, context2);
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(43);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateRightExpression(@NotNull TranslationContext context2, @NotNull KtBinaryExpression expression2, @NotNull JsBlock block) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(44);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(45);
        }
        if (block == null) {
            TranslationUtils.$$$reportNull$$$0(46);
        }
        KtExpression rightExpression = expression2.getRight();
        assert (rightExpression != null) : "Binary expression should have a right expression";
        JsExpression jsExpression = Translation.translateAsExpression(rightExpression, context2, block);
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(47);
        }
        return jsExpression;
    }

    public static boolean hasCorrespondingFunctionIntrinsic(@NotNull TranslationContext context2, @NotNull KtOperationExpression expression2) {
        CallableDescriptor operationDescriptor;
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(48);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(49);
        }
        if ((operationDescriptor = BindingUtils.getCallableDescriptorForOperationExpression(context2.bindingContext(), expression2)) == null || !(operationDescriptor instanceof FunctionDescriptor)) {
            return true;
        }
        KotlinType returnType = operationDescriptor.getReturnType();
        if (returnType != null && (KotlinBuiltIns.isChar(returnType) || KotlinBuiltIns.isLong(returnType) || KotlinBuiltIns.isInt(returnType))) {
            return false;
        }
        return context2.intrinsics().getFunctionIntrinsic((FunctionDescriptor)operationDescriptor, context2) != null;
    }

    @NotNull
    public static List<JsExpression> generateInvocationArguments(@NotNull JsExpression receiver, @NotNull List<? extends JsExpression> arguments) {
        if (receiver == null) {
            TranslationUtils.$$$reportNull$$$0(50);
        }
        if (arguments == null) {
            TranslationUtils.$$$reportNull$$$0(51);
        }
        ArrayList<JsExpression> argumentList = new ArrayList<JsExpression>(1 + arguments.size());
        argumentList.add(receiver);
        argumentList.addAll(arguments);
        ArrayList<JsExpression> arrayList = argumentList;
        if (arrayList == null) {
            TranslationUtils.$$$reportNull$$$0(52);
        }
        return arrayList;
    }

    public static boolean isCacheNeeded(@NotNull JsExpression expression2) {
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(53);
        }
        if (expression2 instanceof JsLiteral.JsValueLiteral) {
            return false;
        }
        if (expression2 instanceof JsNameRef && ((JsNameRef)expression2).getQualifier() == null) {
            return false;
        }
        if (expression2 instanceof JsBinaryOperation) {
            JsBinaryOperation operation = (JsBinaryOperation)expression2;
            JsBinaryOperator operator = operation.getOperator();
            if (operator.isAssignment() || operator == JsBinaryOperator.COMMA) {
                return true;
            }
            return TranslationUtils.isCacheNeeded(operation.getArg1()) || TranslationUtils.isCacheNeeded(operation.getArg2());
        }
        if (expression2 instanceof JsUnaryOperation) {
            JsUnaryOperation operation = (JsUnaryOperation)expression2;
            JsUnaryOperator operator = operation.getOperator();
            switch (operator) {
                case BIT_NOT: 
                case NEG: 
                case POS: 
                case NOT: 
                case TYPEOF: 
                case VOID: {
                    return TranslationUtils.isCacheNeeded(operation.getArg());
                }
            }
            return true;
        }
        return true;
    }

    @NotNull
    public static JsExpression sure(@NotNull KtExpression ktExpression, @NotNull JsExpression expression2, @NotNull TranslationContext context2) {
        if (ktExpression == null) {
            TranslationUtils.$$$reportNull$$$0(54);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(55);
        }
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(56);
        }
        return new JsInvocation(context2.getReferenceToIntrinsic("ensureNotNull"), TranslationUtils.prepareForNullCheck(ktExpression, expression2, context2));
    }

    public static boolean isSimpleNameExpressionNotDelegatedLocalVar(@Nullable KtExpression expression2, @NotNull TranslationContext context2) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(57);
        }
        if (!(expression2 instanceof KtSimpleNameExpression)) {
            return false;
        }
        DeclarationDescriptor descriptor = context2.bindingContext().get(BindingContext.REFERENCE_TARGET, (KtSimpleNameExpression)expression2);
        return !(descriptor instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor).isDelegated() || descriptor instanceof PropertyDescriptor && TranslationUtils.propertyAccessedByFunctionsInternally((PropertyDescriptor)descriptor, context2));
    }

    private static boolean propertyAccessedByFunctionsInternally(@NotNull PropertyDescriptor p, @NotNull TranslationContext context2) {
        if (p == null) {
            TranslationUtils.$$$reportNull$$$0(58);
        }
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(59);
        }
        return !JsDescriptorUtils.isSimpleFinalProperty(p) && context2.isFromCurrentModule(p) || TranslationUtils.shouldAccessViaFunctions(p);
    }

    public static boolean shouldAccessViaFunctions(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(60);
        }
        if (descriptor instanceof PropertyDescriptor) {
            return TranslationUtils.shouldAccessViaFunctions((PropertyDescriptor)descriptor);
        }
        if (descriptor instanceof PropertyAccessorDescriptor) {
            return TranslationUtils.shouldAccessViaFunctions(((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty());
        }
        return false;
    }

    private static boolean shouldAccessViaFunctions(@NotNull PropertyDescriptor property) {
        if (property == null) {
            TranslationUtils.$$$reportNull$$$0(61);
        }
        if (AnnotationsUtils.hasJsNameInAccessors(property)) {
            return true;
        }
        for (PropertyDescriptor propertyDescriptor : property.getOverriddenDescriptors()) {
            if (!TranslationUtils.shouldAccessViaFunctions(propertyDescriptor)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static JsExpression translateContinuationArgument(@NotNull TranslationContext context2) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(62);
        }
        ValueParameterDescriptor continuationDescriptor = TranslationUtils.getEnclosingContinuationParameter(context2);
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(continuationDescriptor, context2);
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(63);
        }
        return jsExpression;
    }

    @NotNull
    public static ValueParameterDescriptor getEnclosingContinuationParameter(@NotNull TranslationContext context2) {
        ValueParameterDescriptor result2;
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(64);
        }
        if ((result2 = context2.getContinuationParameterDescriptor()) == null) {
            assert (context2.getParent() != null);
            result2 = TranslationUtils.getEnclosingContinuationParameter(context2.getParent());
        }
        ValueParameterDescriptor valueParameterDescriptor = result2;
        if (valueParameterDescriptor == null) {
            TranslationUtils.$$$reportNull$$$0(65);
        }
        return valueParameterDescriptor;
    }

    @NotNull
    public static ClassDescriptor getCoroutineBaseClass(@NotNull TranslationContext context2) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(66);
        }
        FqName className = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("CoroutineImpl"));
        ClassDescriptor descriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(context2.getCurrentModule(), ClassId.topLevel(className));
        assert (descriptor != null);
        ClassDescriptor classDescriptor = descriptor;
        if (classDescriptor == null) {
            TranslationUtils.$$$reportNull$$$0(67);
        }
        return classDescriptor;
    }

    @NotNull
    public static PropertyDescriptor getCoroutineProperty(@NotNull TranslationContext context2, @NotNull String name2) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(68);
        }
        if (name2 == null) {
            TranslationUtils.$$$reportNull$$$0(69);
        }
        PropertyDescriptor propertyDescriptor = TranslationUtils.getCoroutineBaseClass(context2).getUnsubstitutedMemberScope().getContributedVariables(Name.identifier(name2), NoLookupLocation.FROM_DESERIALIZATION).iterator().next();
        if (propertyDescriptor == null) {
            TranslationUtils.$$$reportNull$$$0(70);
        }
        return propertyDescriptor;
    }

    @NotNull
    public static FunctionDescriptor getCoroutineDoResumeFunction(@NotNull TranslationContext context2) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(71);
        }
        FunctionDescriptor functionDescriptor = TranslationUtils.getCoroutineBaseClass(context2).getUnsubstitutedMemberScope().getContributedFunctions(Name.identifier("doResume"), NoLookupLocation.FROM_DESERIALIZATION).iterator().next();
        if (functionDescriptor == null) {
            TranslationUtils.$$$reportNull$$$0(72);
        }
        return functionDescriptor;
    }

    public static boolean isOverridableFunctionWithDefaultParameters(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(73);
        }
        return UtilsKt.hasOrInheritsParametersWithDefaultValue(descriptor) && !(descriptor instanceof ConstructorDescriptor) && descriptor.getContainingDeclaration() instanceof ClassDescriptor && ModalityUtilsKt.isOverridable(descriptor);
    }

    @NotNull
    public static KotlinType getReturnTypeForCoercion(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(74);
        }
        return TranslationUtils.getReturnTypeForCoercion(descriptor, false);
    }

    @NotNull
    public static KotlinType getReturnTypeForCoercion(@NotNull CallableDescriptor descriptor, boolean forcePrivate) {
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(75);
        }
        if (FunctionTypesKt.getFunctionTypeKind(descriptor = descriptor.getOriginal()) != null || descriptor instanceof AnonymousFunctionDescriptor) {
            return TranslationUtils.getAnyTypeFromSameModule(descriptor);
        }
        Collection<? extends CallableDescriptor> overridden = descriptor.getOverriddenDescriptors();
        if (overridden.isEmpty()) {
            ClassDescriptor containingClass;
            FqNameUnsafe containingClassName;
            boolean isPublic;
            KotlinType returnType = descriptor.getReturnType();
            if (returnType == null) {
                return TranslationUtils.getAnyTypeFromSameModule(descriptor);
            }
            DeclarationDescriptor container = descriptor.getContainingDeclaration();
            EffectiveVisibility effectiveVisibility = EffectiveVisibilityUtilsKt.effectiveVisibility(descriptor.getVisibility(), descriptor, true);
            boolean bl = isPublic = effectiveVisibility.getPublicApi() && !forcePrivate;
            if (KotlinBuiltIns.isCharOrNullableChar(returnType) && container instanceof ClassDescriptor && isPublic && !CLASSES_WITH_NON_BOXED_CHARS.contains(containingClassName = DescriptorUtilsKt.getFqNameUnsafe(containingClass = (ClassDescriptor)container)) && !KotlinBuiltIns.isPrimitiveType(containingClass.getDefaultType()) && !StandardNames.isPrimitiveArray(containingClassName)) {
                return TranslationUtils.getAnyTypeFromSameModule(descriptor);
            }
            KotlinType kotlinType = returnType;
            if (kotlinType == null) {
                TranslationUtils.$$$reportNull$$$0(76);
            }
            return kotlinType;
        }
        Set typesFromOverriddenCallables = overridden.stream().map(o -> TranslationUtils.getReturnTypeForCoercion(o, forcePrivate)).collect(Collectors.toSet());
        return typesFromOverriddenCallables.size() == 1 ? (KotlinType)typesFromOverriddenCallables.iterator().next() : TranslationUtils.getAnyTypeFromSameModule(descriptor);
    }

    @NotNull
    private static KotlinType getAnyTypeFromSameModule(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(77);
        }
        SimpleType simpleType = DescriptorUtils.getContainingModule(descriptor).getBuiltIns().getAnyType();
        if (simpleType == null) {
            TranslationUtils.$$$reportNull$$$0(78);
        }
        return simpleType;
    }

    @NotNull
    public static KotlinType getDispatchReceiverTypeForCoercion(@NotNull CallableDescriptor descriptor) {
        if (descriptor == null) {
            TranslationUtils.$$$reportNull$$$0(79);
        }
        if ((descriptor = descriptor.getOriginal()).getDispatchReceiverParameter() == null) {
            throw new IllegalArgumentException("This method can only be used for class members; given descriptor is not a member of a class " + descriptor);
        }
        Collection<? extends CallableDescriptor> overridden = descriptor.getOverriddenDescriptors();
        if (overridden.isEmpty()) {
            KotlinType kotlinType = descriptor.getDispatchReceiverParameter().getType();
            if (kotlinType == null) {
                TranslationUtils.$$$reportNull$$$0(80);
            }
            return kotlinType;
        }
        Set typesFromOverriddenCallables = overridden.stream().map(TranslationUtils::getDispatchReceiverTypeForCoercion).collect(Collectors.toSet());
        return typesFromOverriddenCallables.size() == 1 ? (KotlinType)typesFromOverriddenCallables.iterator().next() : TranslationUtils.getAnyTypeFromSameModule(descriptor);
    }

    @NotNull
    public static JsExpression coerce(@NotNull TranslationContext context2, @NotNull JsExpression value2, @NotNull KotlinType to) {
        ClassifierDescriptor d;
        PrimitiveType signedPrimitiveFromUnsigned;
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(81);
        }
        if (value2 == null) {
            TranslationUtils.$$$reportNull$$$0(82);
        }
        if (to == null) {
            TranslationUtils.$$$reportNull$$$0(83);
        }
        if (DynamicTypesKt.isDynamic(to)) {
            JsExpression jsExpression = value2;
            if (jsExpression == null) {
                TranslationUtils.$$$reportNull$$$0(84);
            }
            return jsExpression;
        }
        KotlinType from2 = MetadataProperties.getType(value2);
        if (from2 == null) {
            from2 = context2.getCurrentModule().getBuiltIns().getAnyType();
        }
        if (from2.equals(to)) {
            JsExpression jsExpression = value2;
            if (jsExpression == null) {
                TranslationUtils.$$$reportNull$$$0(85);
            }
            return jsExpression;
        }
        if (KotlinBuiltIns.isCharOrNullableChar(to)) {
            if (!KotlinBuiltIns.isCharOrNullableChar(from2) && !(value2 instanceof JsNullLiteral)) {
                value2 = TranslationUtils.boxedCharToChar(context2, value2);
            }
        } else if (KotlinBuiltIns.isUnit(to)) {
            if (!KotlinBuiltIns.isUnit(from2)) {
                value2 = TranslationUtils.unitToVoid(value2);
            }
        } else if (KotlinBuiltIns.isCharOrNullableChar(from2)) {
            if (!KotlinBuiltIns.isCharOrNullableChar(to) && !(value2 instanceof JsNullLiteral)) {
                value2 = TranslationUtils.charToBoxedChar(context2, value2);
            }
        } else if (KotlinBuiltIns.isUnit(from2) && !KotlinBuiltIns.isUnit(to) && !MetadataProperties.isUnit(value2)) {
            value2 = TranslationUtils.voidToUnit(context2, value2);
        }
        if ((signedPrimitiveFromUnsigned = ArrayFIF.INSTANCE.unsignedPrimitiveToSigned(to)) != null && KotlinBuiltIns.isInt(from2)) {
            switch (signedPrimitiveFromUnsigned) {
                case BYTE: {
                    value2 = AstUtilsKt.toByte(context2, value2);
                    break;
                }
                case SHORT: {
                    value2 = AstUtilsKt.toShort(context2, value2);
                }
            }
            d = to.getConstructor().getDeclarationDescriptor();
            if (d instanceof ClassDescriptor) {
                value2 = new JsNew(ReferenceTranslator.translateAsTypeReference((ClassDescriptor)d, context2), Collections.singletonList(value2));
            }
        }
        if ((FunctionTypesKt.isFunctionTypeOrSubtype(from2) || FunctionTypesKt.isSuspendFunctionTypeOrSubtype(from2)) && (d = to.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && ((ClassDescriptor)d).isFun()) {
            JsName constructorName = context2.getInlineableInnerNameForDescriptor(d.getOriginal());
            if (to.isMarkedNullable()) {
                JsConditional c = TranslationUtils.notNullConditional(value2, new JsNullLiteral(), context2);
                c.setThenExpression(new JsNew((JsExpression)new JsNameRef(constructorName), Collections.singletonList(c.getThenExpression())));
                value2 = c;
            } else {
                value2 = new JsNew((JsExpression)new JsNameRef(constructorName), Collections.singletonList(value2));
            }
        }
        MetadataProperties.setType(value2, to);
        JsExpression jsExpression = value2;
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(86);
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression voidToUnit(@NotNull TranslationContext context2, @NotNull JsExpression expression2) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(87);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(88);
        }
        ClassDescriptor unit = context2.getCurrentModule().getBuiltIns().getUnit();
        JsExpression unitRef = ReferenceTranslator.translateAsValueReference(unit, context2);
        JsExpression jsExpression = JsAstUtils.newSequence(Arrays.asList(expression2, unitRef));
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(89);
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression unitToVoid(@NotNull JsExpression expression2) {
        JsBinaryOperation binary;
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(90);
        }
        if (expression2 instanceof JsBinaryOperation && (binary = (JsBinaryOperation)expression2).getOperator() == JsBinaryOperator.COMMA && MetadataProperties.isUnit(binary.getArg2())) {
            JsExpression jsExpression = binary.getArg1();
            if (jsExpression == null) {
                TranslationUtils.$$$reportNull$$$0(91);
            }
            return jsExpression;
        }
        JsExpression jsExpression = expression2;
        if (jsExpression == null) {
            TranslationUtils.$$$reportNull$$$0(92);
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression charToBoxedChar(@NotNull TranslationContext context2, @NotNull JsExpression expression2) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(93);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(94);
        }
        if (expression2 instanceof JsInvocation) {
            JsInvocation invocation = (JsInvocation)expression2;
            BoxingKind existingKind = MetadataProperties.getBoxing(invocation);
            switch (existingKind) {
                case UNBOXING: {
                    JsExpression jsExpression = invocation.getArguments().get(0);
                    if (jsExpression == null) {
                        TranslationUtils.$$$reportNull$$$0(95);
                    }
                    return jsExpression;
                }
                case BOXING: {
                    JsExpression jsExpression = expression2;
                    if (jsExpression == null) {
                        TranslationUtils.$$$reportNull$$$0(96);
                    }
                    return jsExpression;
                }
            }
        }
        JsInvocation result2 = TranslationUtils.invokeSpecialFunction(context2, SpecialFunction.TO_BOXED_CHAR, expression2);
        result2.setSource(expression2.getSource());
        MetadataProperties.setBoxing(result2, BoxingKind.BOXING);
        JsInvocation jsInvocation = result2;
        if (jsInvocation == null) {
            TranslationUtils.$$$reportNull$$$0(97);
        }
        return jsInvocation;
    }

    @NotNull
    private static JsExpression boxedCharToChar(@NotNull TranslationContext context2, @NotNull JsExpression expression2) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(98);
        }
        if (expression2 == null) {
            TranslationUtils.$$$reportNull$$$0(99);
        }
        if (expression2 instanceof JsInvocation) {
            JsInvocation invocation = (JsInvocation)expression2;
            BoxingKind existingKind = MetadataProperties.getBoxing(invocation);
            switch (existingKind) {
                case BOXING: {
                    JsExpression jsExpression = invocation.getArguments().get(0);
                    if (jsExpression == null) {
                        TranslationUtils.$$$reportNull$$$0(100);
                    }
                    return jsExpression;
                }
                case UNBOXING: {
                    JsExpression jsExpression = expression2;
                    if (jsExpression == null) {
                        TranslationUtils.$$$reportNull$$$0(101);
                    }
                    return jsExpression;
                }
            }
        }
        JsInvocation result2 = TranslationUtils.invokeSpecialFunction(context2, SpecialFunction.UNBOX_CHAR, expression2);
        result2.setSource(expression2.getSource());
        MetadataProperties.setBoxing(result2, BoxingKind.UNBOXING);
        JsInvocation jsInvocation = result2;
        if (jsInvocation == null) {
            TranslationUtils.$$$reportNull$$$0(102);
        }
        return jsInvocation;
    }

    @NotNull
    public static JsInvocation invokeSpecialFunction(@NotNull TranslationContext context2, @NotNull SpecialFunction function2, JsExpression ... arguments) {
        if (context2 == null) {
            TranslationUtils.$$$reportNull$$$0(103);
        }
        if (function2 == null) {
            TranslationUtils.$$$reportNull$$$0(104);
        }
        if (arguments == null) {
            TranslationUtils.$$$reportNull$$$0(105);
        }
        JsName name2 = context2.getNameForSpecialFunction(function2);
        return new JsInvocation((JsExpression)JsAstUtils.pureFqn(name2, null), arguments);
    }

    @NotNull
    public static String getTagForSpecialFunction(@NotNull SpecialFunction specialFunction) {
        if (specialFunction == null) {
            TranslationUtils.$$$reportNull$$$0(106);
        }
        String string2 = "special:" + specialFunction.name();
        if (string2 == null) {
            TranslationUtils.$$$reportNull$$$0(107);
        }
        return string2;
    }

    @NotNull
    public static JsExpression getIntrinsicFqn(@NotNull String name2) {
        if (name2 == null) {
            TranslationUtils.$$$reportNull$$$0(108);
        }
        JsNameRef fqn = JsAstUtils.pureFqn("Kotlin", null);
        for (String part : StringUtil.split(name2, ".")) {
            fqn = JsAstUtils.pureFqn(part, (JsExpression)fqn);
        }
        JsNameRef jsNameRef = fqn;
        if (jsNameRef == null) {
            TranslationUtils.$$$reportNull$$$0(109);
        }
        return jsNameRef;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 29: 
            case 30: 
            case 34: 
            case 38: 
            case 43: 
            case 47: 
            case 52: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 109: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 29: 
            case 30: 
            case 34: 
            case 38: 
            case 43: 
            case 47: 
            case 52: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 109: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 60: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 8: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 27: 
            case 32: 
            case 35: 
            case 40: 
            case 41: 
            case 44: 
            case 48: 
            case 56: 
            case 57: 
            case 59: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 71: 
            case 81: 
            case 87: 
            case 93: 
            case 98: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBinaryExpression";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToCheck";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktSubject";
                break;
            }
            case 16: 
            case 24: 
            case 42: 
            case 45: 
            case 49: 
            case 53: 
            case 55: 
            case 88: 
            case 90: 
            case 94: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elseExpression";
                break;
            }
            case 29: 
            case 30: 
            case 34: 
            case 38: 
            case 43: 
            case 47: 
            case 52: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/TranslationUtils";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignTo";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 51: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktExpression";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 69: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/TranslationUtils";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForBackingField";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "backingFieldReference";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "assignmentToBackingField";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "translateBaseExpression";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "translateRightExpression";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "generateInvocationArguments";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "translateContinuationArgument";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnclosingContinuationParameter";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineBaseClass";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineProperty";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoroutineDoResumeFunction";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnTypeForCoercion";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnyTypeFromSameModule";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatchReceiverTypeForCoercion";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "coerce";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "voidToUnit";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "unitToVoid";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "charToBoxedChar";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "boxedCharToChar";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagForSpecialFunction";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntrinsicFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "translateFunctionAsEcma5PropertyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorFunctionName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "simpleReturnFunction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "translateExtensionFunctionAsEcma5DataDescriptor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "translateExclForBinaryEqualLikeExpr";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEqualLikeOperator";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "notOperator";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isNullCheck";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullCheck";
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "nullCheck";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareForNullCheck";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "notNullConditional";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getNameForBackingField";
                break;
            }
            case 29: 
            case 30: 
            case 34: 
            case 38: 
            case 43: 
            case 47: 
            case 52: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 109: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceToSyntheticBackingField";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "backingFieldReference";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "assignmentToBackingField";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "translateInitializerForProperty";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "translateBaseExpression";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "translateRightExpression";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "hasCorrespondingFunctionIntrinsic";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "generateInvocationArguments";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isCacheNeeded";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "sure";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleNameExpressionNotDelegatedLocalVar";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "propertyAccessedByFunctionsInternally";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "shouldAccessViaFunctions";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "translateContinuationArgument";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingContinuationParameter";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineBaseClass";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineProperty";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getCoroutineDoResumeFunction";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isOverridableFunctionWithDefaultParameters";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeForCoercion";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getAnyTypeFromSameModule";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverTypeForCoercion";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "coerce";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "voidToUnit";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "unitToVoid";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "charToBoxedChar";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "boxedCharToChar";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "invokeSpecialFunction";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "getTagForSpecialFunction";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "getIntrinsicFqn";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 29: 
            case 30: 
            case 34: 
            case 38: 
            case 43: 
            case 47: 
            case 52: 
            case 63: 
            case 65: 
            case 67: 
            case 70: 
            case 72: 
            case 76: 
            case 78: 
            case 80: 
            case 84: 
            case 85: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 107: 
            case 109: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

