/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.konan.UtilsKt;
import org.jetbrains.kotlin.name.NativeForwardDeclarationKind;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ClassLiteralChecker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeForwardDeclarationRttiChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/RttiExpressionChecker;", "Lorg/jetbrains/kotlin/types/expressions/ClassLiteralChecker;", "<init>", "()V", "check", "", "rttiInformation", "Lorg/jetbrains/kotlin/resolve/calls/checkers/RttiExpressionInformation;", "reportOn", "Lcom/intellij/psi/PsiElement;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "expression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "frontend.native"})
@SourceDebugExtension(value={"SMAP\nNativeForwardDeclarationRttiChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeForwardDeclarationRttiChecker.kt\norg/jetbrains/kotlin/resolve/konan/diagnostics/NativeForwardDeclarationRttiChecker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,57:1\n1251#2,2:58\n*S KotlinDebug\n*F\n+ 1 NativeForwardDeclarationRttiChecker.kt\norg/jetbrains/kotlin/resolve/konan/diagnostics/NativeForwardDeclarationRttiChecker\n*L\n41#1:58,2\n*E\n"})
public final class NativeForwardDeclarationRttiChecker
implements RttiExpressionChecker,
ClassLiteralChecker {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull RttiExpressionInformation rttiInformation, @NotNull PsiElement reportOn, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)rttiInformation, (String)"rttiInformation");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        KotlinType sourceType = rttiInformation.getSourceType();
        KotlinType targetType = rttiInformation.getTargetType();
        Object object = targetType;
        ClassifierDescriptor targetDescriptor = object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null;
        if (sourceType == null) return;
        if (!(targetDescriptor instanceof ClassDescriptor)) return;
        NativeForwardDeclarationKind nativeForwardDeclarationKind = UtilsKt.getForwardDeclarationKindOrNull((ClassDescriptor)targetDescriptor);
        if (nativeForwardDeclarationKind == null) {
            return;
        }
        NativeForwardDeclarationKind kind = nativeForwardDeclarationKind;
        switch (WhenMappings.$EnumSwitchMapping$0[rttiInformation.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                trace.report(ErrorsNative.CANNOT_CHECK_FOR_FORWARD_DECLARATION.on(reportOn, targetType));
                return;
            }
            case 3: 
            case 4: {
                ClassDescriptor sourceDescriptor;
                ClassifierDescriptor classifierDescriptor = sourceType.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor = sourceDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
                if (sourceDescriptor != null && Intrinsics.areEqual((Object)sourceDescriptor.getName(), (Object)((ClassDescriptor)targetDescriptor).getName()) && sourceDescriptor.getKind() == kind.getClassKind()) {
                    Sequence<ClassifierDescriptor> $this$any$iv = DescriptorUtilsKt.getAllSuperClassifiers(sourceDescriptor);
                    boolean $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        ClassifierDescriptor it = (ClassifierDescriptor)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(it), (Object)kind.getMatchSuperClassFqName())) continue;
                        return;
                    }
                    boolean bl = false;
                    if (bl) {
                        return;
                    }
                }
                boolean bl = false;
                boolean isAllowedCast = bl;
                if (isAllowedCast) return;
                trace.report(ErrorsNative.UNCHECKED_CAST_TO_FORWARD_DECLARATION.on(reportOn, sourceType, targetType));
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @Override
    public void check(@NotNull KtClassLiteralExpression expression2, @NotNull KotlinType type2, @NotNull ResolutionContext<?> context2) {
        ClassDescriptor descriptor;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = descriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if ((classDescriptor != null ? UtilsKt.getForwardDeclarationKindOrNull(classDescriptor) : null) != null) {
            context2.trace.report(ErrorsNative.FORWARD_DECLARATION_AS_CLASS_LITERAL.on(expression2, type2));
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RttiOperation.values().length];
            try {
                nArray[RttiOperation.IS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RttiOperation.NOT_IS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RttiOperation.AS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RttiOperation.SAFE_AS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

