/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.analyze;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.utils.StringUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.StrictPatternExcludesArtifactFilter;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzer;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalyzerException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;

public abstract class AbstractAnalyzeMojo
extends AbstractMojo {
    @Component
    private PlexusContainer plexusContainer;
    @Component
    private MavenProject project;
    @Parameter(property="analyzer", defaultValue="default")
    private String analyzer;
    @Parameter(property="failOnWarning", defaultValue="false")
    private boolean failOnWarning;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="ignoreNonCompile", defaultValue="false")
    private boolean ignoreNonCompile;
    @Parameter(property="ignoreUnusedRuntime", defaultValue="false")
    private boolean ignoreUnusedRuntime;
    @Parameter(property="ignoreAllNonTestScoped", defaultValue="false")
    private boolean ignoreAllNonTestScoped;
    @Parameter(property="outputXML", defaultValue="false")
    private boolean outputXML;
    @Parameter(property="scriptableOutput", defaultValue="false")
    private boolean scriptableOutput;
    @Parameter(property="scriptableFlag", defaultValue="$$$%%%")
    private String scriptableFlag;
    @Parameter(defaultValue="${basedir}", readonly=true)
    private File baseDir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File outputDirectory;
    @Parameter
    private String[] usedDependencies;
    @Parameter(property="mdep.analyze.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String[] ignoredDependencies = new String[0];
    @Parameter
    private String[] ignoredUsedUndeclaredDependencies = new String[0];
    @Parameter
    private String[] ignoredUnusedDeclaredDependencies = new String[0];
    @Parameter
    private String[] ignoredNonTestScopedDependencies = new String[0];
    @Parameter
    private List<String> ignoredPackagings = Arrays.asList("pom", "ear");
    @Parameter(property="mdep.analyze.excludedClasses")
    private Set<String> excludedClasses;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        if (this.ignoredPackagings.contains(this.project.getPackaging())) {
            this.getLog().info((CharSequence)("Skipping " + this.project.getPackaging() + " project"));
            return;
        }
        if (this.outputDirectory == null || !this.outputDirectory.exists()) {
            this.getLog().info((CharSequence)"Skipping project with no build directory");
            return;
        }
        boolean warning = this.checkDependencies();
        if (warning && this.failOnWarning) {
            throw new MojoExecutionException("Dependency problems found");
        }
    }

    protected ProjectDependencyAnalyzer createProjectDependencyAnalyzer() throws MojoExecutionException {
        try {
            return (ProjectDependencyAnalyzer)this.plexusContainer.lookup(ProjectDependencyAnalyzer.class, this.analyzer);
        }
        catch (ComponentLookupException exception) {
            throw new MojoExecutionException("Failed to instantiate ProjectDependencyAnalyser / role-hint " + this.analyzer, (Exception)((Object)exception));
        }
    }

    protected final boolean isSkip() {
        return this.skip;
    }

    private boolean checkDependencies() throws MojoExecutionException {
        ProjectDependencyAnalysis analysis;
        try {
            analysis = this.createProjectDependencyAnalyzer().analyze(this.project, this.excludedClasses);
            if (this.usedDependencies != null) {
                analysis = analysis.forceDeclaredDependenciesUsage(this.usedDependencies);
            }
        }
        catch (ProjectDependencyAnalyzerException exception) {
            throw new MojoExecutionException("Cannot analyze dependencies", (Exception)((Object)exception));
        }
        if (this.ignoreNonCompile) {
            analysis = analysis.ignoreNonCompile();
        }
        LinkedHashSet usedDeclared = new LinkedHashSet(analysis.getUsedDeclaredArtifacts());
        LinkedHashMap<Artifact, Set<String>> usedUndeclaredWithClasses = new LinkedHashMap<Artifact, Set<String>>(analysis.getUsedUndeclaredArtifactsWithClasses());
        LinkedHashSet<Artifact> unusedDeclared = new LinkedHashSet<Artifact>(analysis.getUnusedDeclaredArtifacts());
        LinkedHashSet<Artifact> nonTestScope = new LinkedHashSet<Artifact>(analysis.getTestArtifactsWithNonTestScope());
        LinkedHashSet<Artifact> ignoredUsedUndeclared = new LinkedHashSet<Artifact>();
        LinkedHashSet<Artifact> ignoredUnusedDeclared = new LinkedHashSet<Artifact>();
        LinkedHashSet<Artifact> ignoredNonTestScope = new LinkedHashSet<Artifact>();
        if (this.ignoreUnusedRuntime) {
            this.filterArtifactsByScope(unusedDeclared, "runtime");
        }
        ignoredUsedUndeclared.addAll(this.filterDependencies(usedUndeclaredWithClasses.keySet(), this.ignoredDependencies));
        ignoredUsedUndeclared.addAll(this.filterDependencies(usedUndeclaredWithClasses.keySet(), this.ignoredUsedUndeclaredDependencies));
        ignoredUnusedDeclared.addAll(this.filterDependencies(unusedDeclared, this.ignoredDependencies));
        ignoredUnusedDeclared.addAll(this.filterDependencies(unusedDeclared, this.ignoredUnusedDeclaredDependencies));
        if (this.ignoreAllNonTestScoped) {
            ignoredNonTestScope.addAll(this.filterDependencies(nonTestScope, new String[]{"*"}));
        } else {
            ignoredNonTestScope.addAll(this.filterDependencies(nonTestScope, this.ignoredDependencies));
            ignoredNonTestScope.addAll(this.filterDependencies(nonTestScope, this.ignoredNonTestScopedDependencies));
        }
        boolean reported = false;
        boolean warning = false;
        if (this.verbose && !usedDeclared.isEmpty()) {
            this.getLog().info((CharSequence)"Used declared dependencies found:");
            this.logArtifacts(analysis.getUsedDeclaredArtifacts(), false);
            reported = true;
        }
        if (!usedUndeclaredWithClasses.isEmpty()) {
            this.logDependencyWarning("Used undeclared dependencies found:");
            if (this.verbose) {
                this.logArtifacts(usedUndeclaredWithClasses, true);
            } else {
                this.logArtifacts(usedUndeclaredWithClasses.keySet(), true);
            }
            reported = true;
            warning = true;
        }
        if (!unusedDeclared.isEmpty()) {
            this.logDependencyWarning("Unused declared dependencies found:");
            this.logArtifacts(unusedDeclared, true);
            reported = true;
            warning = true;
        }
        if (!nonTestScope.isEmpty()) {
            this.logDependencyWarning("Non-test scoped test only dependencies found:");
            this.logArtifacts(nonTestScope, true);
            reported = true;
            warning = true;
        }
        if (this.verbose && !ignoredUsedUndeclared.isEmpty()) {
            this.getLog().info((CharSequence)"Ignored used undeclared dependencies:");
            this.logArtifacts(ignoredUsedUndeclared, false);
            reported = true;
        }
        if (this.verbose && !ignoredUnusedDeclared.isEmpty()) {
            this.getLog().info((CharSequence)"Ignored unused declared dependencies:");
            this.logArtifacts(ignoredUnusedDeclared, false);
            reported = true;
        }
        if (this.verbose && !ignoredNonTestScope.isEmpty()) {
            this.getLog().info((CharSequence)"Ignored non-test scoped test only dependencies:");
            this.logArtifacts(ignoredNonTestScope, false);
            reported = true;
        }
        if (this.outputXML) {
            this.writeDependencyXML(usedUndeclaredWithClasses.keySet());
        }
        if (this.scriptableOutput) {
            this.writeScriptableOutput(usedUndeclaredWithClasses.keySet());
        }
        if (!reported) {
            this.getLog().info((CharSequence)"No dependency problems found");
        }
        return warning;
    }

    private void filterArtifactsByScope(Set<Artifact> artifacts, String scope) {
        artifacts.removeIf(artifact -> artifact.getScope().equals(scope));
    }

    private void logArtifacts(Set<Artifact> artifacts, boolean warn) {
        if (artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"   None");
        } else {
            for (Artifact artifact : artifacts) {
                artifact.isSnapshot();
                if (warn) {
                    this.logDependencyWarning("   " + artifact);
                    continue;
                }
                this.getLog().info((CharSequence)("   " + artifact));
            }
        }
    }

    private void logArtifacts(Map<Artifact, Set<String>> artifacts, boolean warn) {
        if (artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"   None");
        } else {
            for (Map.Entry<Artifact, Set<String>> entry : artifacts.entrySet()) {
                entry.getKey().isSnapshot();
                if (warn) {
                    this.logDependencyWarning("   " + entry.getKey());
                    for (String clazz : entry.getValue()) {
                        this.logDependencyWarning("      class " + clazz);
                    }
                    continue;
                }
                this.getLog().info((CharSequence)("   " + entry.getKey()));
                for (String clazz : entry.getValue()) {
                    this.getLog().info((CharSequence)("      class " + clazz));
                }
            }
        }
    }

    private void logDependencyWarning(CharSequence content) {
        if (this.failOnWarning) {
            this.getLog().error(content);
        } else {
            this.getLog().warn(content);
        }
    }

    private void writeDependencyXML(Set<Artifact> artifacts) {
        if (!artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Add the following to your pom to correct the missing dependencies: ");
            StringWriter out = new StringWriter();
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)out);
            for (Artifact artifact : artifacts) {
                artifact.isSnapshot();
                writer.startElement("dependency");
                writer.startElement("groupId");
                writer.writeText(artifact.getGroupId());
                writer.endElement();
                writer.startElement("artifactId");
                writer.writeText(artifact.getArtifactId());
                writer.endElement();
                writer.startElement("version");
                writer.writeText(artifact.getBaseVersion());
                String classifier = artifact.getClassifier();
                if (!StringUtils.isEmpty(classifier)) {
                    writer.startElement("classifier");
                    writer.writeText(classifier);
                    writer.endElement();
                }
                writer.endElement();
                if (!"compile".equals(artifact.getScope())) {
                    writer.startElement("scope");
                    writer.writeText(artifact.getScope());
                    writer.endElement();
                }
                writer.endElement();
            }
            this.getLog().info((CharSequence)(System.lineSeparator() + out.getBuffer()));
        }
    }

    private void writeScriptableOutput(Set<Artifact> artifacts) {
        if (!artifacts.isEmpty()) {
            this.getLog().info((CharSequence)"Missing dependencies: ");
            String pomFile = this.baseDir.getAbsolutePath() + File.separatorChar + "pom.xml";
            StringBuilder buf = new StringBuilder();
            for (Artifact artifact : artifacts) {
                artifact.isSnapshot();
                buf.append(this.scriptableFlag).append(":").append(pomFile).append(":").append(artifact.getDependencyConflictId()).append(":").append(artifact.getClassifier()).append(":").append(artifact.getBaseVersion()).append(":").append(artifact.getScope()).append(System.lineSeparator());
            }
            this.getLog().info((CharSequence)(System.lineSeparator() + buf));
        }
    }

    private List<Artifact> filterDependencies(Set<Artifact> artifacts, String[] excludes) {
        StrictPatternExcludesArtifactFilter filter = new StrictPatternExcludesArtifactFilter(Arrays.asList(excludes));
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        Iterator<Artifact> it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = it.next();
            if (filter.include(artifact)) continue;
            it.remove();
            result.add(artifact);
        }
        return result;
    }
}

