/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.exclusion;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.maven.plugins.dependency.exclusion.Coordinates;

class ExclusionChecker {
    private final Map<Coordinates, List<Coordinates>> violations = new TreeMap<Coordinates, List<Coordinates>>();

    ExclusionChecker() {
    }

    Map<Coordinates, List<Coordinates>> getViolations() {
        return this.violations;
    }

    void check(Coordinates artifact, Set<Coordinates> excludes, Set<Coordinates> actualDependencies) {
        List invalidExclusions = excludes.stream().filter(exclude -> actualDependencies.stream().noneMatch(exclude.getExclusionPattern())).sorted().collect(Collectors.toList());
        if (!invalidExclusions.isEmpty()) {
            this.violations.put(artifact, invalidExclusions);
        }
    }
}

