/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.resolve.AbstractFilter;
import org.apache.maven.shared.artifact.filter.resolve.Node;

public class ExcludeReactorProjectsDependencyFilter
extends AbstractFilter {
    private final Log log;
    private final Set<String> reactorArtifactKeys;

    public ExcludeReactorProjectsDependencyFilter(List<MavenProject> reactorProjects, Log log) {
        this.log = log;
        this.reactorArtifactKeys = reactorProjects.stream().map(project -> ArtifactUtils.key((Artifact)project.getArtifact())).collect(Collectors.toSet());
    }

    public boolean accept(Node node, List<Node> parents) {
        Dependency dependency = node.getDependency();
        if (dependency != null) {
            String dependencyArtifactKey = ArtifactUtils.key((String)dependency.getGroupId(), (String)dependency.getArtifactId(), (String)dependency.getVersion());
            boolean result = this.isDependencyArtifactInReactor(dependencyArtifactKey);
            if (this.log.isDebugEnabled() && result) {
                this.log.debug((CharSequence)("Skipped dependency " + dependencyArtifactKey + " because it is present in the reactor"));
            }
            return !result;
        }
        return true;
    }

    private boolean isDependencyArtifactInReactor(String dependencyArtifactKey) {
        for (String reactorArtifactKey : this.reactorArtifactKeys) {
            if (!reactorArtifactKey.equals(dependencyArtifactKey)) continue;
            return true;
        }
        return false;
    }
}

