/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.tree;

import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.dependency.tree.AbstractSerializingVisitor;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;

public class JsonDependencyNodeVisitor
extends AbstractSerializingVisitor
implements DependencyNodeVisitor {
    private String indentChar = " ";

    public JsonDependencyNodeVisitor(Writer writer) {
        super(writer);
    }

    public boolean visit(DependencyNode node) {
        if (node.getParent() == null || node.getParent() == node) {
            this.writeRootNode(node);
        }
        return true;
    }

    private void writeRootNode(DependencyNode node) {
        HashSet<DependencyNode> visited = new HashSet<DependencyNode>();
        int indent = 2;
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("\n");
        this.writeNode(indent, node, sb, visited);
        sb.append("}").append("\n");
        this.writer.write(sb.toString());
    }

    private void writeNode(int indent, DependencyNode node, StringBuilder sb, Set<DependencyNode> visited) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        this.appendNodeValues(sb, indent, node.getArtifact(), !node.getChildren().isEmpty());
        if (!node.getChildren().isEmpty()) {
            this.writeChildren(indent, node, sb, visited);
        }
    }

    private void writeChildren(int indent, DependencyNode node, StringBuilder sb, Set<DependencyNode> visited) {
        sb.append(this.indent(indent)).append("\"children\": [").append("\n");
        indent += 2;
        for (int i = 0; i < node.getChildren().size(); ++i) {
            DependencyNode child = (DependencyNode)node.getChildren().get(i);
            sb.append(this.indent(indent));
            sb.append("{").append("\n");
            this.writeNode(indent + 2, child, sb, visited);
            sb.append(this.indent(indent)).append("}");
            if (i != node.getChildren().size() - 1) {
                sb.append(",");
            }
            sb.append("\n");
        }
        sb.append(this.indent(indent)).append("]").append("\n");
    }

    public boolean endVisit(DependencyNode node) {
        return true;
    }

    private void appendNodeValues(StringBuilder sb, int indent, Artifact artifact, boolean hasChildren) {
        this.appendKeyValue(sb, indent, "groupId", artifact.getGroupId());
        this.appendKeyValue(sb, indent, "artifactId", artifact.getArtifactId());
        this.appendKeyValue(sb, indent, "version", artifact.getVersion());
        this.appendKeyValue(sb, indent, "type", artifact.getType());
        this.appendKeyValue(sb, indent, "scope", artifact.getScope());
        this.appendKeyValue(sb, indent, "classifier", artifact.getClassifier());
        if (hasChildren) {
            this.appendKeyValue(sb, indent, "optional", String.valueOf(artifact.isOptional()));
        } else {
            this.appendKeyWithoutComma(sb, indent, "optional", String.valueOf(artifact.isOptional()));
        }
    }

    private void appendKeyValue(StringBuilder sb, int indent, String key, String value) {
        if (value == null) {
            value = "";
        }
        sb.append(this.indent(indent)).append("\"").append(key).append("\"").append(":").append(this.indentChar).append("\"").append(value).append("\"").append(",").append("\n");
    }

    private void appendKeyWithoutComma(StringBuilder sb, int indent, String key, String value) {
        if (value == null) {
            value = "";
        }
        sb.append(this.indent(indent)).append("\"").append(key).append("\"").append(":").append(this.indentChar).append("\"").append(value).append("\"").append("\n");
    }

    private String indent(int indent) {
        if (indent < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(this.indentChar);
        }
        return sb.toString();
    }
}

