/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.SipURI;
import io.pkts.packet.sip.address.TelURI;
import java.io.IOException;

public interface URI {
    public Buffer getScheme();

    default public boolean isSipURI() {
        return false;
    }

    default public boolean isTelURI() {
        return false;
    }

    public void getBytes(Buffer var1);

    default public SipURI toSipURI() {
        throw new ClassCastException("Unable to cast " + this.getClass().getName() + " into a " + SipURI.class.getName());
    }

    default public TelURI toTelURI() {
        throw new ClassCastException("Unable to cast " + this.getClass().getName() + " into a " + TelURI.class.getName());
    }

    public static URI frame(Buffer buffer) throws SipParseException, IndexOutOfBoundsException, IOException {
        buffer.markReaderIndex();
        Buffer b = buffer.readBytes(3);
        buffer.resetReaderIndex();
        if (b.getByte(0) == 115 && b.getByte(1) == 105 && b.getByte(2) == 112) {
            return SipURI.frame(buffer);
        }
        if (b.getByte(0) == 116 && b.getByte(1) == 101 && b.getByte(2) == 108) {
            return TelURI.frame(buffer);
        }
        throw new RuntimeException("Have only implemented SIP and TEL uri parsing right now. Sorry");
    }

    public Buffer toBuffer();

    public URI clone();

    public Builder<? extends URI> copy();

    public static class Builder<T extends URI> {
        T build() {
            return null;
        }
    }
}

