/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.framer;

import io.pkts.buffer.Buffer;
import io.pkts.framer.Framer;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.rtcp.RtcpPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public final class RTCPFramer
implements Framer<TransportPacket, RtcpPacket> {
    @Override
    public Protocol getProtocol() {
        return Protocol.RTCP;
    }

    @Override
    public boolean accept(Buffer data) throws IOException {
        byte b;
        if (data.getReadableBytes() < 12) {
            data.markReaderIndex();
            try {
                Buffer b2 = data.readBytes(12);
                if (b2.capacity() < 12) {
                    return false;
                }
            }
            catch (IndexOutOfBoundsException b2) {
                // empty catch block
            }
            data.resetReaderIndex();
        }
        if (((b = data.getByte(0)) & 0xC0) >> 6 != 2) {
            return false;
        }
        byte b2 = data.getByte(1);
        return b2 != -56 && b2 != -55 && b2 != -54 && b2 != -53 && b2 != -52;
    }

    @Override
    public RtcpPacket frame(TransportPacket parent, Buffer buffer) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("The parent frame cannot be null");
        }
        return null;
    }
}

