/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sctp.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.IPPacket;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.impl.TransportPacketImpl;
import io.pkts.packet.sctp.SctpChunk;
import io.pkts.packet.sctp.SctpPacket;
import io.pkts.packet.sctp.SctpParseException;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class SctpPacketImpl
extends TransportPacketImpl
implements SctpPacket {
    private final List<SctpChunk> chunks;

    public static SctpPacket frame(IPPacket ipPacket, Buffer buffer) {
        try {
            PreConditions.assertNotNull((Object)ipPacket, (String)"The IP Packet cannot be null");
            PreConditions.assertNotEmpty((Buffer)buffer, (String)"The Buffer cannot be null or empty");
            PreConditions.assertArgument((buffer.getReadableBytes() >= 12 ? 1 : 0) != 0, (String)"There must be at least 12 bytes to read");
            Buffer header = buffer.readBytes(12);
            int startChunks = buffer.getReaderIndex();
            ArrayList<SctpChunk> chunks = new ArrayList<SctpChunk>();
            while (buffer.hasReadableBytes()) {
                chunks.add(SctpChunk.frame(buffer));
            }
            Buffer chunksBuffer = buffer.slice(startChunks, buffer.getReaderIndex());
            return new SctpPacketImpl(ipPacket, header, chunks, chunksBuffer);
        }
        catch (IOException e) {
            throw new SctpParseException(buffer.getReaderIndex(), "Unable to read from buffer. Message (if any) " + e.getMessage());
        }
    }

    private SctpPacketImpl(IPPacket parent, Buffer headers, List<SctpChunk> chunks, Buffer payload) {
        super(parent, Protocol.SCTP, headers, payload);
        this.chunks = chunks;
    }

    @Override
    public List<SctpChunk> getChunks() {
        return this.chunks;
    }

    @Override
    public int getHeaderLength() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void write(OutputStream out, Buffer payload) throws IOException {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public TransportPacket clone() {
        throw new RuntimeException("Not yet implemented");
    }
}

