$NetBSD$
--- wcfxo/wcfxo_lkm.c.orig	2008-10-29 20:18:13.000000000 +0000
+++ wcfxo/wcfxo_lkm.c	2008-10-29 20:18:13.000000000 +0000
@@ -0,0 +1,245 @@
+/*
+ * $Id: wcfxo_lkm.c 67 2005-01-19 19:32:01Z riz $
+ *
+ * 
+ * Copyright (c) 2004, 2005 Red Crow Group LLC
+ * All rights reserved.
+ *
+ * Author: Jeff Rizzo <riz@redcrowgroup.com>
+ *
+ * Redistribution and use in source and binary forms, with or without
+ * modification, are permitted provided that the following conditions
+ * are met:
+ * 1. Redistributions of source code must retain the above copyright
+ *    notice, this list of conditions and the following disclaimer.
+ * 2. Redistributions in binary form must reproduce the above copyright
+ *    notice, this list of conditions and the following disclaimer in the
+ *    documentation and/or other materials provided with the distribution.
+ * 3. The name of the author may not be used to endorse or promote products
+ *    derived from this software without specific prior written permission.
+ *
+ * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
+ * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
+ * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
+ * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
+ * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
+ * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
+ * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
+ * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
+ * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
+ * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
+ * SUCH DAMAGE.
+ */
+
+#include <sys/param.h>
+#include <sys/systm.h>
+#include <sys/kernel.h>
+#include <sys/device.h>
+#include <sys/lkm.h>
+#include <sys/sysctl.h>
+
+#include "../zaptel/zaptel-compat.h"
+
+/* if we don't have MOD_DRV, we have more work to do */
+#ifndef MOD_DRV
+#include <dev/pci/pcivar.h>
+#include <dev/pci/pcidevs.h>
+#endif
+
+CFDRIVER_DECL(wcfxo,DV_DULL,NULL);
+extern struct cfattach wcfxo_ca;
+
+static int pciloc[] = { -1, -1 }; /* device, function */
+static struct cfparent pciparent = {
+	"pci", "pci", DVUNIT_ANY
+};
+static struct cfdata wcfxo_cfdata[] = {
+	{"wcfxo", "wcfxo", 0, FSTATE_STAR, pciloc, 0, &pciparent,
+#if __NetBSD_Version__ < 399000900
+	0
+#endif
+},
+	{ 0 }
+};
+
+#ifndef MOD_DRV
+static struct cftable wcfxo_cftable;
+#else
+static struct cfdriver *wcfxo_cfdrivers[] = {
+	&wcfxo_cd,
+	NULL
+};
+static struct cfattach *wcfxo_cfattachs[] = {
+	&wcfxo_ca,
+	NULL
+};
+static const struct cfattachlkminit wcfxo_cfattachinit[] = {
+	{ "wcfxo", wcfxo_cfattachs },
+	{ NULL }
+};
+#endif
+
+static int wcfxo_lkmload(struct lkm_table *, int);
+static int wcfxo_lkmunload(struct lkm_table *, int);
+#ifndef MOD_DRV
+static int wcfxo_probe(struct pci_attach_args *);
+static int wcfxo_submatch(struct device *, struct cfdata *, void *);
+static int wcfxo_print(void *, const char *);
+#endif
+
+/* sysctl node stuff */
+static int wcfxo_node;
+static int wcfxo_debug_node;
+static struct sysctllog *wcfxo_log;
+static int wcfxo_sysctl_setup(void);
+static int wcfxo_sysctl_handler(SYSCTLFN_PROTO);
+extern int wcfxodebug;
+
+int mod_wcfxo_lkmentry(struct lkm_table *, int, int);
+#ifdef MOD_DRV
+MOD_DRV("wcfxo", wcfxo_cfdrivers, wcfxo_cfattachinit, wcfxo_cfdata);
+#else
+MOD_MISC("wcfxo");
+#endif
+
+int
+mod_wcfxo_lkmentry(struct lkm_table *lkmtp, int cmd, int ver) {
+	DISPATCH(lkmtp, cmd, ver, wcfxo_lkmload, wcfxo_lkmunload, lkm_nofunc);
+}
+
+static int
+wcfxo_lkmload(struct lkm_table *lkmtp, int cmd)
+{
+	int error = 0;
+
+#ifndef MOD_DRV
+	if ((error = config_cfdriver_attach(&wcfxo_cd)) != 0)
+		return error;
+	if ((error = config_cfattach_attach("wcfxo", &wcfxo_ca)) != 0)
+		return error;
+
+	wcfxo_cftable.ct_cfdata = wcfxo_cfdata;
+	TAILQ_INSERT_TAIL(&allcftables, &wcfxo_cftable, ct_list);
+
+	(void)pci_find_device(NULL, wcfxo_probe);
+
+	if (wcfxo_cd.cd_ndevs == 0) {
+		TAILQ_REMOVE(&allcftables, &wcfxo_cftable, ct_list);
+		return ENXIO;
+	}
+#endif
+
+	error = wcfxo_sysctl_setup();
+	return error;
+}
+
+static int
+wcfxo_lkmunload(struct lkm_table *lkmtp, int cmd)
+{
+#ifndef MOD_DRV
+	int error, i;
+
+	for (i = 0; i < wcfxo_cd.cd_ndevs; i++)
+		if ((error = config_detach(wcfxo_cd.cd_devs[i], 0)) != 0)
+			return error;
+
+	if ((error = config_cfattach_detach("wcfxo", &wcfxo_ca)) !=0)
+		return error;
+	if ((error = config_cfdriver_detach(&wcfxo_cd)) != 0)
+		return error;
+	TAILQ_REMOVE(&allcftables, &wcfxo_cftable, ct_list);
+#endif
+
+	sysctl_teardown(&wcfxo_log);
+	return 0;
+}
+
+static int
+wcfxo_sysctl_setup(void)
+{
+	__SYSCTL_CONST struct sysctlnode *node;
+	int error = 0;
+
+	if ((error = sysctl_createv(&wcfxo_log, 0, NULL, NULL, 0,
+	    CTLTYPE_NODE, "hw", NULL,
+	    NULL, 0, NULL, 0, CTL_HW, CTL_EOL)) != 0)
+		return error;
+
+	if ((error = sysctl_createv(&wcfxo_log, 0, NULL, &node, 0,
+	    CTLTYPE_NODE, "wcfxo", SYSCTL_DESCR("wcfxo controls"),
+	    NULL, 0, NULL, 0, CTL_HW, CTL_CREATE, CTL_EOL)) != 0)
+		return error;
+	wcfxo_node = node->sysctl_num;
+
+	/* wcfxo debug level */
+	if ((error = sysctl_createv(&wcfxo_log, 0, NULL, &node,
+	    CTLFLAG_READWRITE, CTLTYPE_INT, "debug",
+	    SYSCTL_DESCR("wcfxo debug level"),
+	    wcfxo_sysctl_handler, 0, &wcfxodebug,
+	    0, CTL_HW, wcfxo_node, CTL_CREATE, CTL_EOL)) != 0)
+		return error;
+	wcfxo_debug_node = node->sysctl_num;
+	
+	return 0;
+}
+
+static int
+wcfxo_sysctl_handler(SYSCTLFN_ARGS)
+{
+	struct sysctlnode node;
+	int t, error;
+
+	node = *rnode;
+	t = *(int *)rnode->sysctl_data;
+	node.sysctl_data = &t;
+	error = sysctl_lookup(SYSCTLFN_CALL(&node));
+	if (error || newp == NULL)
+		return error;
+
+	if (t < 0)
+	    return EINVAL;
+
+	*(int *)rnode->sysctl_data = t;
+	return 0;
+}
+
+#ifndef MOD_DRV
+/* PCI bus probe call-back */
+
+static int
+wcfxo_submatch(struct device *parent, struct cfdata *cf, void *aux)
+{
+	if (cf != wcfxo_cfdata)
+		return 0;
+
+	return (pcisubmatch(parent, cf, aux));
+}
+
+static int
+wcfxo_print(void *aux, const char *pnp)
+{
+	if (pnp == NULL)
+		return pciprint(aux, pnp);
+
+	return QUIET;
+}
+
+static int
+wcfxo_probe(struct pci_attach_args *paa)
+{
+	struct device *parent = device_lookup(&pci_cd, paa->pa_bus);
+
+	if (parent)
+		(void)config_found_sm(parent, (void *)paa, wcfxo_print,
+			wcfxo_submatch);
+
+	/*
+	 * The way pci_find_device() is designed doesn't
+	 * allow us to report a success to the caller,
+	 * unfortunately, since returning non-zero makes
+	 * the probe stop, although there may be more
+	 * cards.
+	 */
+        return 0;
+}
+#endif
