$NetBSD$
--- wcfxo/wcfxoreg.h.orig	2005-08-26 18:25:35.000000000 +0100
+++ wcfxo/wcfxoreg.h	2008-10-29 20:18:13.000000000 +0000
@@ -1,5 +1,5 @@
 /*
- * Wilcard X100P FXO Interface Driver for Zapata Telephony interface
+ * Wildcard X100P FXO Interface Driver for Zapata Telephony interface
  *
  * Ported on FreeBSD by
  *      Alexander Timoshenko <gonzo@portaone.com>, PortaOne software
@@ -30,6 +30,15 @@
 
 
 /* $Id: wcfxoreg.h 841 2004-06-16 15:48:58Z gonzo $ */
+#ifdef __FreeBSD__
 #define READ1(off)      bus_space_read_1(sc->wc_base_addr_tag, sc->wc_base_addr_handle, off)
 #define WRITE1(off,v)   bus_space_write_1(sc->wc_base_addr_tag, sc->wc_base_addr_handle, off, v)
 #define WRITE4(off,v)   bus_space_write_4(sc->wc_base_addr_tag, sc->wc_base_addr_handle, off, v)
+#elif defined(__NetBSD__)
+#define READ1(off)	bus_space_read_1(sc->sc_iot, sc->sc_ioh, (off))
+#define WRITE1(off,v)	bus_space_write_1(sc->sc_iot, sc->sc_ioh, \
+				(off), (v))
+#define WRITE4(off,v)	bus_space_write_4(sc->sc_iot, sc->sc_ioh, \
+				(off), (v))
+#define WCFXO_SIZE   (ZT_MAX_CHUNKSIZE * 2 * 2 * 2 * 4)
+#endif
