$NetBSD$
--- wcfxs/wcfxsreg.h.orig	2005-08-26 18:25:35.000000000 +0100
+++ wcfxs/wcfxsreg.h	2008-10-29 20:18:13.000000000 +0000
@@ -1,4 +1,13 @@
 /* $Id$ */
+#ifdef __FreeBSD__
 #define READ1(off)      bus_space_read_1(sc->wc_base_addr_tag, sc->wc_base_addr_handle, (off))
 #define WRITE1(off,v)   bus_space_write_1(sc->wc_base_addr_tag, sc->wc_base_addr_handle, (off), (v))
 #define WRITE4(off,v)   bus_space_write_4(sc->wc_base_addr_tag, sc->wc_base_addr_handle, (off), (v))
+#elif defined(__NetBSD__)
+#define READ1(off)	bus_space_read_1(sc->sc_iot, sc->sc_ioh, (off))
+#define WRITE1(off,v)	bus_space_write_1(sc->sc_iot, sc->sc_ioh, \
+				(off), (v))
+#define WRITE4(off,v)	bus_space_write_4(sc->sc_iot, sc->sc_ioh, \
+				(off), (v))
+#define WCFXS_SIZE   (ZT_MAX_CHUNKSIZE * 2 * 2 * 2 * 4)
+#endif
