$NetBSD$
--- zaptel/zaptel.h.orig	2008-06-11 12:34:47.000000000 +0100
+++ zaptel/zaptel.h	2008-10-29 20:18:13.000000000 +0000
@@ -1101,7 +1101,14 @@
 	
 	/* Specified by driver, readable by zaptel */
 	void *pvt;			/* Private channel data */
-	struct cdev * dev;	/* File structure */
+#ifdef __FreeBSD__
+	struct cdev *dev;	/* File structure */
+#elif defined __NetBSD__
+	/* giving this the same name lets us leave huge swathes of code
+	 * alone, as "dev" or "file" arguments are passed around the code.
+	 */
+	struct file *dev;	/* File structure */
+#endif
 	
 	
 	struct zt_span *span;		/* Span we're a member of */
@@ -1527,6 +1534,60 @@
 	unsigned char txgain[256];      /* Transmit gain table */
 };
 
+/*
+* Transcoder operations
+*/
+#define ZT_TRANSCODE_OP		_IOWR(ZT_CODE, 93, int)
+
+#define ZT_TRANSCODE_MAGIC 0x74a9c0de
+
+/* Operations */
+#define ZT_TCOP_ALLOCATE	1			/* Allocate/reset DTE channel */
+#define ZT_TCOP_TRANSCODE	2			/* Begin transcoding a block */
+#define ZT_TCOP_GETINFO		3			/* Get information (use zt_transcode_info) */
+#define ZT_TCOP_RELEASE         4                       /* Release DTE channel */
+#define ZT_TCOP_TEST            5                       /* test DTE device */
+typedef struct zt_transcode_info {
+	unsigned int op;
+	unsigned int tcnum;
+	char name[80];
+	int numchannels;
+	unsigned int srcfmts;
+	unsigned int dstfmts;
+} ZT_TRANSCODE_INFO;
+
+#define ZT_TCCONF_USETS		(1 << 0)		/* Use/update timestamp field */
+#define ZT_TCCONF_USESEQ	(1 << 1)		/* Use/update seqno field */
+
+#define ZT_TCSTAT_DSTRDY	(1 << 0)		/* Destination data is ready */
+#define ZT_TCSTAT_DSTBUSY	(1 << 1)		/* Destination data is outstanding */
+
+#define __ZT_TRANSCODE_BUFSIZ	16384
+#define ZT_TRANSCODE_HDRLEN	256
+#define ZT_TRANSCODE_BUFSIZ	((__ZT_TRANSCODE_BUFSIZ) - (ZT_TRANSCODE_HDRLEN))
+
+typedef struct zt_transcode_header {
+	unsigned int srcfmt;		/* See formats.h -- use TCOP_RESET when you change */
+	unsigned int srcoffset; 	/* In bytes -- written by user */
+	unsigned int srclen;		/* In bytes -- written by user */
+	unsigned int srctimestamp;	/* In samples -- written by user (only used if ZT_TCCONF_USETS is set) */
+	unsigned int srcseqno;		/* In units -- written by user (only used if ZT_TCCONF_USESEQ is set) */
+
+	unsigned int dstfmt;		/* See formats.h -- use TCOP_RESET when you change */
+	unsigned int dstoffset;  	/* In bytes -- written by user */
+	unsigned int dsttimestamp;	/* In samples -- read by user */
+	unsigned int dstseqno;		/* In units -- read by user (only used if ZT_TCCONF_USESEQ is set) */
+	unsigned int dstlen;  		/* In bytes -- read by user */
+	unsigned int dstsamples;	/* In timestamp units -- read by user */
+
+	unsigned int magic;		/* Magic value -- ZT_TRANSCODE_MAGIC, read by user */
+	unsigned int config;		/* Read/write by user */
+	unsigned int status;		/* Read/write by user */
+	unsigned char userhdr[ZT_TRANSCODE_HDRLEN - (sizeof(unsigned int) * 14)];	/* Storage for user parameters */
+	unsigned char srcdata[ZT_TRANSCODE_BUFSIZ / 2];	/* Storage of source data */
+	unsigned char dstdata[ZT_TRANSCODE_BUFSIZ / 2];	/* Storage of destination data */
+} ZT_TRANSCODE_HEADER;
+
 struct zt_ring_cadence {
     int ringcadence [ZT_MAX_CADENCE];
 };
