$NetBSD$
--- zaptel/zt_chan.h.orig	2007-01-16 16:11:54.000000000 +0000
+++ zaptel/zt_chan.h	2008-10-29 20:18:13.000000000 +0000
@@ -77,19 +77,34 @@
 
 struct zt_chan	*zt_alloc_pseudo(void);
 void		zt_free_pseudo(struct zt_chan *pseudo);
-int		zt_chanandpseudo_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, int unit);
 
+#ifdef __FreeBSD__
 int		zt_specchan_open(struct cdev * dev, int unit, int inc);
 int		zt_specchan_close(struct cdev * dev, int unit);
+int		zt_chanandpseudo_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, int unit);
+#elif defined(__NetBSD__)
+int		zt_specchan_open(struct file *, int unit, int inc);
+int		zt_specchan_close(struct file *, int unit);
+int		zt_chanandpseudo_ioctl(struct file *, u_long cmd, caddr_t arg, int unit);
+#endif
 
-int	zt_chan_open(struct cdev * dev, int flag, struct thread * threadp);
+ssize_t	zt_chan_read(struct uio * uio, int unit);
+int	zt_chan_write(struct uio * uio, int unit);
+#ifdef __FreeBSD__
+int	zt_chan_open(struct cdev * dev, int flag, zt_proc_t * threadp);
 int	zt_chan_close(struct cdev * dev);
 int	zt_prechan_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, int unit);
 int	zt_chan_ioctl(struct cdev * dev, u_long cmd, caddr_t arg, int unit);
-ssize_t	zt_chan_read(struct uio * uio, int unit);
-int	zt_chan_write(struct uio * uio, int unit);
-int	zt_chan_poll(struct cdev * dev, int events, struct thread * t, int unit);
+int	zt_chan_poll(struct cdev * dev, int events, zt_proc_t * t, int unit);
 int	zt_common_ioctl(struct cdev *, u_long, caddr_t, int );
+#elif defined(__NetBSD__)
+int	zt_chan_open(dev_t dev, int flag, zt_proc_t * threadp);
+int	zt_chan_close(struct file *);
+int	zt_prechan_ioctl(struct file *, u_long cmd, caddr_t arg, int unit);
+int	zt_chan_ioctl(struct file *, u_long cmd, caddr_t arg, int unit);
+int	zt_chan_poll(struct file *, int events, zt_proc_t * t, int unit);
+int	zt_common_ioctl(struct file *, u_long, caddr_t, int );
+#endif
 
 
 void __zt_getbuf_chunk(struct zt_chan *, unsigned char *);
@@ -107,8 +122,13 @@
 void		zt_set_law(struct zt_chan *, int);
 void		zt_conv_init(void);
 int		zt_hangup(struct zt_chan *);
-void		zt_set_flags(struct cdev * , int);
-int		zt_get_flags(struct cdev * dev);
+#ifdef __FreeBSD__
+void		zt_set_flags(struct cdev *, int);
+int		zt_get_flags(struct cdev *);
+#elif defined(__NetBSD__)
+void		zt_set_flags(struct file *, int);
+int		zt_get_flags(struct file *);
+#endif
 void		__qevent(struct zt_chan *chan, int event);
 void		set_txtone(struct zt_chan *ss,int fac, int init_v2, int init_v3);
 int		zt_q_sig(struct zt_chan *);
