# $Id: meta.sys.mk,v 1.13 2011/03/03 18:39:05 sjg Exp $

#
#	@(#) Copyright (c) 2010, Simon J. Gerraty
#
#	This file is provided in the hope that it will
#	be of use.  There is absolutely NO WARRANTY.
#	Permission to copy, redistribute or otherwise
#	use this file is hereby granted provided that 
#	the above copyright notice and this notice are
#	left intact. 
#      
#	Please send copies of changes and bug-fixes to:
#	sjg@crufty.net
#

# include this if you want to enable meta mode
# for maximum benefit, requires DTrace or the filemon(9) driver.

.if ${MAKE_VERSION:U0} > 20100901
.if !target(.ERROR)

META_MODE += meta verbose
.MAKE.MODE ?= ${META_MODE}

.if !defined(NO_SILENT) && ${.MAKE.MODE:Mmeta*} != "" && ${.MAKE.MODE:M*verb*} != "" 
.SILENT:
.endif

# make defaults .MAKE.DEPENDFILE to .depend
# that won't work for us.
.if ${.MAKE.DEPENDFILE} == ".depend"
.undef .MAKE.DEPENDFILE
.endif

# if you don't cross build for multiple MACHINEs concurrently, then
# .MAKE.DEPENDFILE = Makefile.depend
# probably makes sense - you can set that in local.sys.mk 
.MAKE.DEPENDFILE ?= Makefile.depend.${MACHINE}

# we use the pseudo machine "host" for the build host.
# this should be taken care of before we get here
.if ${OBJTOP:Ua} == ${HOST_OBJTOP:Ub}
MACHINE = host
.endif

MAKE_PRINT_VAR_ON_ERROR += \
	.ERROR_TARGET \
	.ERROR_META_FILE \
	.MAKE.LEVEL \
	MAKEFILE \
	.MAKE.MODE

.if !defined(SB) && defined(SRCTOP)
SB = ${SRCTOP:H}
.endif
ERROR_LOGDIR ?= ${SB}/error
meta_error_log = ${ERROR_LOGDIR}/meta-${.MAKE.PID}.log

# we are not interested in make telling us a failure happened elsewhere
.ERROR:
	-@[ "${.ERROR_META_FILE}" ] && { \
	grep -q 'failure has been detected in another branch' ${.ERROR_META_FILE} && exit 0; \
	mkdir -p ${meta_error_log:H}; \
	cp ${.ERROR_META_FILE} ${meta_error_log}; \
	echo "ERROR: log ${meta_error_log}" >&2; }; :

.endif

# Are we, after all, in meta mode?
.if ${.MAKE.MODE:Mmeta*} != ""
MKDEP = meta.autodep

.if ${.MAKE.LEVEL} == 0
# make sure dirdeps target exists and do it first
all: dirdeps .WAIT
dirdeps:

.if ${.MAKE.DEPENDFILE:E} != "depend"
# it works best if we do everything via sub-makes
BUILD_AT_LEVEL0 ?= no
.endif
BUILD_AT_LEVEL0 ?= yes
.if ${.MAKE.MODE:M*nofilemon*} != "" || ${.MAKE.MODE:M*read*} != ""
UPDATE_DEPENDFILE = NO
.export UPDATE_DEPENDFILE
.endif
.endif

# if we think we are updating dependencies, 
# then filemon had better be present
.if ${UPDATE_DEPENDFILE:Uyes:tl} != "no" && !exists(/dev/filemon)
.error ${.newline}ERROR: The filemon module (/dev/filemon) is not loaded.
.endif

.endif
.endif
