/* **********************************************************
 * Copyright (C) 1998-2000 VMware, Inc.
 * All Rights Reserved
 * **********************************************************/

#ifndef __VMMONINT_H__
#define __VMMONINT_H__

#define INCLUDE_ALLOW_MODULE
#include "includeCheck.h"


/*
 * Hide all kernel compatibility stuff in those macros
 */


#ifdef KERNEL_2_1
#   define compat_fop_set_poll(_pFop, _pFunc) do { \
   (_pFop)->poll = (_pFunc);                       \
} while (0)
#else
#   define compat_fop_set_poll(_pFop, _pFunc) do { \
   (_pFop)->select = (_pFunc);                     \
} while (0)
#endif


#ifdef KERNEL_2_4_0
#   define compat_fop_set_owner(_pFop) do { \
   (_pFop)->owner = THIS_MODULE;            \
} while (0)
#   define compat_mod_inc_refcount
#   define compat_mod_dec_refcount
#else
#   define compat_fop_set_owner(_pFop)
#   define compat_mod_inc_refcount do { \
   MOD_INC_USE_COUNT;                   \
} while (0)
#   define compat_mod_dec_refcount do { \
   MOD_DEC_USE_COUNT;                   \
} while (0)
#endif


/*
 * The get_order() API appeared at some point in 2.3.x, and was then backported
 * in 2.2.17-21mdk and in the stock 2.2.18. Because we can only detect its
 * definition through makefile tricks, we provide our own for now --hpreg
 */
static INLINE int
compat_get_order(unsigned long size) // IN
{
   int order;

   size = (size - 1) >> (PAGE_SHIFT - 1);
   order = -1;
   do {
      size >>= 1;
      order++;
   } while (size);

   return order;
}


#endif /* __VMMONINT_H__ */
