#include <unistd.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <termios.h>
#include <fcntl.h>
#include <sys/types.h>


int main(int argc, char *argv[]) {
  struct termios t_saved, t_raw;
  char c;
#define LEVELUP -1
  char s[80];
    
  tcgetattr(STDIN_FILENO, &t_saved);
  t_raw = t_saved;
  cfmakeraw(&t_raw);
  tcsetattr(STDIN_FILENO, TCSANOW, &t_raw);

#define BS 127
#define CR 13

#define EEOL "\e[K"

#define LEVELBEGIN(...) \
  {\
    int l = strlen(s);\
    __VA_ARGS__ \
    do {\
      c = getchar();\
      switch (c) {\

#define CASENUM \
	case '0':\
	case '1':\
	case '2':\
	case '3':\
	case '4':\
	case '5':\
	case '6':\
	case '7':\
	case '8':\
	case '9':

#define CASEALPHA \
	case 'a': case 'A':\
	case 'b': case 'B':\
	case 'c': case 'C':\
	case 'd': case 'D':\
	case 'e': case 'E':\
	case 'f': case 'F':\
	case 'g': case 'G':\
	case 'h': case 'H':\
	case 'i': case 'I':\
	case 'j': case 'J':\
	case 'k': case 'K':\
	case 'l': case 'L':\
	case 'm': case 'M':\
	case 'n': case 'N':\
	case 'o': case 'O':\
	case 'p': case 'P':\
	case 'q': case 'Q':\
	case 'r': case 'R':\
	case 's': case 'S':\
	case 't': case 'T':\
	case 'u': case 'U':\
	case 'v': case 'V':\
	case 'w': case 'W':\
	case 'x': case 'X':\
	case 'y': case 'Y':\
	case 'z': case 'Z':

#define CASEFN \
	CASEALPHA \
	CASENUM \
	case '_':\
	case '.':\
	case '/':\
	case '-':

#define DONUM(i, x)\
	CASENUM\
	  i++; x = 10*x + (c - '0');\
	  APPENDC\
	  break;\
	case BS:\
	  if (i) {\
	    i--; x /= 10;\
	    BACKSPACE\
	    c = 0;\
	  }\
	  break;

#define BACKUP do {\
	s[l] = '\0';\
	printf("\r%s" EEOL, s);\
} while (0);

#define LEVELEND(help) \
	case '!':\
	  printf("\r\n%d \"%s\"\r\n%s", l, s, s);\
	  fflush(stdout);\
	  break;\
	case 12:\
	  printf("\r" EEOL "%s", s);\
	  fflush(stdout);\
	  break;\
	case 27:\
	  goto out;\
        case 24:\
	  printf("\r" EEOL);\
	  fflush(stdout);\
	  goto again;\
        case '?':\
	  printf("\r\n" help "\r\n%s", s);\
	  fflush(stdout);\
	  break;\
        default:\
	  putchar('\007');\
  	  fflush(stdout);\
	  break;\
      }\
      if (c == LEVELUP) {\
	BACKUP\
      }\
    } while (c != BS);\
    c =  LEVELUP;\
  }

#define APPEND(x) do {\
  strcat(s, x);\
  fputs(x, stdout); fflush(stdout);\
} while (0);

#define APPENDC do {\
  strncat(s, &c, 1);\
  putchar(c); fflush(stdout);\
} while (0);

#define BACKSPACE do {\
  if (strlen(s)) s[strlen(s) - 1] = '\0';\
  fputs("\b \b", stdout); fflush(stdout);\
} while (0);

again:
  s[0] = '\0';
  LEVELBEGIN()
    case 'c':
      APPEND("close(")
      LEVELBEGIN(int i = 0, fd = 0;)
	DONUM(i, fd)
	case ' ':
	case ')':
	  APPEND(")")
	  LEVELBEGIN(int ret;)
	    case CR:
	      putchar('='); fflush(stdout);
	      ret = close(fd);
	      printf("%d\r\n", ret);
	      goto again;
	  LEVELEND("<cr>")
	  break;
      LEVELEND("<fd>")
      break;
    case 'o':
      APPEND("open(")
      LEVELBEGIN(int i = 0;)
	CASEFN
	  i++;
	  APPENDC
	  break;
	case BS:
	  if (i) {
	    i--;
	    BACKSPACE
	    c = 0;
	  }
	  break;
	case ' ':
	case ')':
	  APPEND(")")
	  LEVELBEGIN(int ret; char fn[80];)
	    case 13:
	      strncpy(fn, s + l - 1 - i, i); fn[i] = '\0';
	      putchar('='); fflush(stdout);
	      ret = open(fn, O_RDWR | O_CREAT, 0777);
	      if (ret >= 0)
	        printf("%d\r\n", ret);
	      else
	        printf("%s\r\n", strerror(errno));
	      goto again;
	  LEVELEND("<cr>")
	  break;
      LEVELEND("<filename>")
      break;
    case 'p':
    case 'n':
      APPEND("fcntl(")
      LEVELBEGIN(int i = 0, fd = 0;)
	DONUM(i, fd)
	case ' ':
	case ',':
	  APPEND(",")
          LEVELBEGIN(int cmd = 0;)
	    case BS:
	      if (cmd) {
		cmd = 0;
		BACKUP
		c = 0;
	      }
	      break;
	    case 'g':
	      if (cmd) BACKUP
	      cmd = F_GETLK;
	      APPEND("F_GETLK");
	      break;
	    case 's':
	      if (cmd) BACKUP
	      cmd = F_SETLK;
	      APPEND("F_SETLK");
	      break;
	    case 'w':
	      if (cmd) BACKUP
	      cmd = F_SETLKW;
	      APPEND("F_SETLKW");
	      break;
	    case ' ':
	    case ',':
	      APPEND(",")
	      LEVELBEGIN(int type = 0;)
		case BS:
		  if (type) {
		    type = 0;
		    BACKUP
		    c = 0;
		  }
		  break;
		case 'r':
		  if (type) BACKUP
		  type = F_RDLCK;
		  APPEND("F_RDLCK");
		  break;
		case 'w':
		  if (type) BACKUP
		  type = F_WRLCK;
		  APPEND("F_WRLCK");
		  break;
		case 'u':
		  if (type) BACKUP
		  type = F_UNLCK;
		  APPEND("F_UNLCK");
		  break;
		case ' ':
		case ',':
		  APPEND(",")
		  LEVELBEGIN(int i = 0, start = 0;)
		    DONUM(i, start)
		    case ' ':
		    case ',':
		      APPEND(",")
		      LEVELBEGIN(int i = 0, len = 0;)
			DONUM(i, len)
			case ' ':
			case ')':
			  APPEND(")")
			  LEVELBEGIN(int ret; struct flock flock; char *t;)
			    case 13:
			      flock.l_start = start;
			      flock.l_len = len;
			      flock.l_pid = getpid();
			      flock.l_type = type;
			      flock.l_whence = SEEK_SET;
			      putchar('='); fflush(stdout);
			      ret = fcntl(fd, cmd, &flock);
			      if (ret >= 0) {
				switch (flock.l_type) {
				  case F_RDLCK: t = "RD"; break;
				  case F_WRLCK: t = "WR"; break;
				  case F_UNLCK: t = "UN"; break;
				  default: t = "XX";
				}
				printf("(%ld, %ld, %d, F_%sLK)\r\n", (long)flock.l_start, (long)flock.l_len, (int)flock.l_pid, t);
			      } else {
				printf("%s\r\n", strerror(errno));
			      }
			      goto again;
			  LEVELEND("<cr>")
			  break;
		      LEVELEND("<len>");
		      break;
		  LEVELEND("<start>");
		  break;
	      LEVELEND("Readlock Writelock Unlock");
	      break;
          LEVELEND("Get Set setW");
	  break;
      LEVELEND("<fd>");
      break;
    case 'f':
    case 'l':
      APPEND("flock(")
      LEVELBEGIN(int i = 0, fd = 0;)
	DONUM(i, fd)
	case ' ':
	case ',':
	  APPEND(",")
          LEVELBEGIN(int op = 0;)
	    case 0: /* dummy */
flock_op:     {
		int b;
		
		BACKUP
		b = 0;
		if (op & LOCK_SH) {
		  if (b) APPEND(" | ")
		  b = 1;
		  APPEND("LOCK_SH");
		}
		if (op & LOCK_EX) {
		  if (b) APPEND(" | ")
		  b = 1;
		  APPEND("LOCK_EX");
		}
		if (op & LOCK_NB) {
		  if (b) APPEND(" | ")
		  b = 1;
		  APPEND("LOCK_NB");
		}
		if (op & LOCK_UN) {
		  if (b) APPEND(" | ")
		  b = 1;
		  APPEND("LOCK_UN");
		}
	      }
	      break;
	    case BS:
	      if (op) {
		op = 0;
		BACKUP
		c = 0;
	      }
	      break;
	    case 's':
	      op ^= LOCK_SH;
	      goto flock_op;
	    case 'e':
	      op ^= LOCK_EX;
	      goto flock_op;
	    case 'n':
	      op ^= LOCK_NB;
	      goto flock_op;
	    case 'u':
	      op ^= LOCK_UN;
	      goto flock_op;
	    case ' ':
	    case ')':
	      APPEND(")")
	      LEVELBEGIN(int ret;)
		case 13:
	          putchar('='); fflush(stdout);
		  ret = flock(fd, op);
		  if (ret >= 0) {
		    printf("%d\r\n", ret);
		  } else {
		    printf("%s\r\n", strerror(errno));
		  }
		  goto again;
	      LEVELEND("<cr>")
	      break;
          LEVELEND("Shared Exclusive Nonblock Unlock");
	  break;
      LEVELEND("<fd>");
      break;
    case BS:
      break;
  LEVELEND("Open Close Posix=fcNtl FLock")
out:
  tcsetattr(STDIN_FILENO, TCSANOW, &t_saved);
  putchar('\n');
  return 0;
}
