/*
 * Copyright (c) 2004, 2005, id Quantique SA, Switzerland
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of id Quantique nor the names of its contributors may be
 * used to endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "quantis.h"

static void usage(void) {
  fprintf(stderr, "Usage: qrngctl [-c card] [-r] [-e 1-4] [-d 1-4] [-v]\n");
  fprintf(stderr, "-c card: use card (default 0)\n");
  fprintf(stderr, "-r: reset board\n");
  fprintf(stderr, "-e 1-4: enable module (1-4)\n");
  fprintf(stderr, "-d 1-4: disable module (1-4)\n");
  fprintf(stderr, "-v: print information\n");
}

int main(int argc, char *argv[]) {
  int card = 0;
  int reset = 0;
  int enable = 0;
  int disable = 0;
  int version = 0;
  
  int c;
  while ((c = getopt(argc, argv, "re:d:c:v")) >= 0) {
    switch (c) {
    case 'c':
      card = atoi(optarg);
      break;
      
    case 'r':
      reset = 1;
      break;

    case 'e':
      enable = atoi(optarg);
      if ((enable < 1) || (enable > 4)) {
	usage();
	return 1;
      }
      printf("Enabling module %d\n", enable);
      quantisModulesEnable(card, 1 << (enable - 1));
      break;

    case 'd':
      disable = atoi(optarg);
      if ((disable < 1) || (disable > 4)) {
	usage();
	return 1;
      }
      printf("Disabling module %d\n", disable);
      quantisModulesDisable(card, 1 << (disable - 1));
      break;

    case 'v':
      version = 1;
      break;

    default:
      usage();
      return 1;
    }
  }

  if (reset) {
    printf("Resetting quantis board %d\n", card);
    quantisBoardReset(card);
  }

  if (version) {
    int modules, status, i;
    
    printf("Showing information about quantis card %d\n", card);
    printf("Board version:   %x\n", quantisBoardVersion(card));
    printf("Lib version:     %x\n", quantisLibVersion());
    printf("Driver version:  %x\n", quantisDriverVersion());

    modules = quantisGetModules(card);
    status = quantisModulesStatus(card);

    printf("Modules present: ");
    for (i = 0; i < 4; i++) {
      if (modules & (1 << i)) {
	printf("%d ", i+1);
      }
    }
    printf("\n");

    printf("Modules status:  ");
    for (i = 0; i < 4; i++) {
      if (modules & (1 << i)) {
	printf("%d ", i+1);
      }
    }
    printf("\n");
    return 0;
  }

  return 0;
}
