/*
 * Decompiled with CFR 0.152.
 */
package cycinf.cvars.usedtype;

import cycinf.cvars.usedtype.UsedType;
import cycinf.cvars.usedtype.UsedTypeLayer;
import cycinf.util.ParseException;
import cycinf.util.ParsingUtils;
import general.util.Validator;
import java.text.MessageFormat;

public class FunctionReturnType
extends UsedType {
    private final UsedTypeLayer function;
    private static final String l1 = "_FR";
    private static final MessageFormat prettyFormat = new MessageFormat("return type of function {0}");

    public final UsedTypeLayer getFunction() {
        return this.function;
    }

    public FunctionReturnType(UsedTypeLayer function) {
        this.function = (UsedTypeLayer)Validator.nonnull((Object)function, (String)"function");
    }

    public final String toString() {
        return String.valueOf(this.getFunction().toString()) + l1;
    }

    public final String prettyString() {
        return prettyFormat.format(new Object[]{this.getFunction().prettyString()});
    }

    public static FunctionReturnType parse1(String x) throws ParseException {
        String functionStr = ParsingUtils.chopSuffix((String)x, (String)l1);
        if (functionStr == null) {
            return null;
        }
        UsedTypeLayer function = UsedTypeLayer.parse((String)functionStr);
        return new FunctionReturnType(function);
    }
}

