/*
 * Decompiled with CFR 0.152.
 */
package cycinf.infstats;

import cycinf.infstats.DirInfstats;
import cycinf.infstats.DirTracker;
import cycinf.infstats.InfstatsManager;
import general.util.Validator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;

final class LoadInfstatsJob
extends Job {
    final DirTracker dir;
    final DirInfstats is;
    final boolean automatic;
    Process compilerProcess;
    BufferedReader decisionsIn;
    BufferedReader constraintsIn;
    private static final String expectedGreeting = "Looking for constraint variables...";
    private static final Pattern amountLinePattern = Pattern.compile("Found (\\d+) of them.");

    LoadInfstatsJob(DirInfstats is, boolean automatic) {
        super("[Load inference data]");
        this.is = is;
        this.dir = is.getDir();
        this.automatic = automatic;
        this.setUser(!automatic);
        this.setName("Load inference data in " + this.dir.getPath());
    }

    private void setUpInfstatsProcess() throws IOException {
        ProcessBuilder pb = new ProcessBuilder(InfstatsManager.getManager().getCompilerArgs());
        pb.redirectErrorStream(true);
        pb.directory(this.dir.getDir().getLocation().toFile());
        this.compilerProcess = pb.start();
        InputStream in1 = this.compilerProcess.getInputStream();
        this.decisionsIn = new BufferedReader(new InputStreamReader(in1));
    }

    private void setUpCvarsFile() throws CoreException {
        this.constraintsIn = new BufferedReader(new InputStreamReader(this.dir.cvarsFile.getContents()));
    }

    IStatus makeStatus(int code, String message, Throwable e) {
        if (e != null) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            message = String.valueOf(message) + "\n\n" + sw.toString();
        }
        return new Status(code, "cycinf", code, message, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor pm) {
        int errors;
        block100: {
            SubProgressMonitor pm2;
            int numDecisions;
            block99: {
                pm.beginTask("Load inference data in " + this.dir.getPath(), 100);
                if (this.dir.infstatsPresent()) break block99;
                IStatus iStatus = this.makeStatus(4, String.valueOf(this.dir.getPath()) + " does not seem to contain inference information: " + "it has no \".cych/cvars\" file.  Make sure the project is built; if you " + "still get this error, refresh the folder to make sure Eclipse notices " + "that the cvars file exists.", null);
                try {
                    this.decisionsIn.close();
                }
                catch (Exception exception) {}
                try {
                    this.constraintsIn.close();
                }
                catch (Exception exception) {}
                DirTracker dirTracker = this.dir;
                synchronized (dirTracker) {
                    this.dir.loadInProgress = false;
                }
                return iStatus;
            }
            try {
                if (this.automatic) {
                    pm.subTask("Waiting for inference data to stabilize");
                    do {
                        this.is.stamp = this.dir.infstatsStamp();
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    } while (this.is.stamp != this.dir.infstatsStamp());
                } else {
                    this.is.stamp = this.dir.infstatsStamp();
                }
                try {
                    pm.subTask("Launching Cyclone compiler");
                    this.setUpInfstatsProcess();
                    pm.worked(2);
                }
                catch (Exception e) {
                    IStatus iStatus = this.makeStatus(4, "An exception occurred while launching the Cyclone compiler.  No changes have been made to the workspace.", (Throwable)e);
                    try {
                        this.decisionsIn.close();
                    }
                    catch (Exception exception) {}
                    try {
                        this.constraintsIn.close();
                    }
                    catch (Exception exception) {}
                    DirTracker dirTracker = this.dir;
                    synchronized (dirTracker) {
                        this.dir.loadInProgress = false;
                    }
                    return iStatus;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.decisionsIn.close();
                }
                catch (Exception exception) {}
                try {
                    this.constraintsIn.close();
                }
                catch (Exception exception) {}
                DirTracker dirTracker = this.dir;
                synchronized (dirTracker) {
                    this.dir.loadInProgress = false;
                }
                throw throwable;
            }
            try {
                pm.subTask("Waiting for Cyclone compiler to start up");
                String greeting = (String)Validator.nonnull((Object)this.decisionsIn.readLine(), (String)"greeting");
                if (!greeting.equals(expectedGreeting)) {
                    throw new RuntimeException("Bad greeting from the compiler: " + greeting);
                }
                pm.worked(2);
                pm.subTask("Waiting for Cyclone compiler to collect decisions");
                String amountLine = (String)Validator.nonnull((Object)this.decisionsIn.readLine(), (String)"amount line");
                Matcher m = amountLinePattern.matcher(amountLine);
                if (!m.matches()) {
                    throw new RuntimeException("Bad amount line from the compiler: " + amountLine);
                }
                numDecisions = Integer.parseInt(m.group(1));
                pm.worked(2);
                pm.subTask("Waiting for Cyclone compiler to prepare " + numDecisions + " decisions");
                Validator.nonnull((Object)this.decisionsIn.readLine(), (String)"heading line 1");
                Validator.nonnull((Object)this.decisionsIn.readLine(), (String)"heading line 2");
                pm.worked(2);
            }
            catch (Exception e) {
                IStatus iStatus = this.makeStatus(4, "An exception occurred while the Cyclone compiler collected and prepared inference decisions.  No changes have been made to the workspace.", (Throwable)e);
                try {
                    this.decisionsIn.close();
                }
                catch (Exception exception) {}
                try {
                    this.constraintsIn.close();
                }
                catch (Exception exception) {}
                DirTracker dirTracker = this.dir;
                synchronized (dirTracker) {
                    this.dir.loadInProgress = false;
                }
                return iStatus;
            }
            try {
                pm.subTask("Beginning to read decisions from Cyclone compiler");
                pm2 = new SubProgressMonitor(pm, 35);
                this.is.loadDecisions(this.decisionsIn, numDecisions, (IProgressMonitor)pm2);
                pm.subTask("Waiting for Cyclone compiler to quit");
                this.compilerProcess.waitFor();
                this.decisionsIn.close();
                pm.worked(2);
            }
            catch (Exception e) {
                IStatus iStatus = this.makeStatus(4, "An exception occurred while reading inference decisions from the Cyclone compiler.  No changes have been made to the workspace.", (Throwable)e);
                try {
                    this.decisionsIn.close();
                }
                catch (Exception exception) {}
                try {
                    this.constraintsIn.close();
                }
                catch (Exception exception) {}
                DirTracker dirTracker = this.dir;
                synchronized (dirTracker) {
                    this.dir.loadInProgress = false;
                }
                return iStatus;
            }
            try {
                pm.subTask("Opening the \"cvars\" file to load constraints");
                this.setUpCvarsFile();
                pm.worked(2);
                Validator.nonnull((Object)this.constraintsIn.readLine(), (String)"fileDirective");
                pm.worked(2);
            }
            catch (Exception e) {
                IStatus iStatus = this.makeStatus(4, "An exception occurred while opening the \"cvars\" file.  No changes have been made to the workspace.", (Throwable)e);
                try {
                    this.decisionsIn.close();
                }
                catch (Exception exception) {}
                try {
                    this.constraintsIn.close();
                }
                catch (Exception exception) {}
                DirTracker dirTracker = this.dir;
                synchronized (dirTracker) {
                    this.dir.loadInProgress = false;
                }
                return iStatus;
            }
            try {
                pm.subTask("Beginning to read constraints from the \"cvars\" file");
                pm2 = new SubProgressMonitor(pm, 39);
                this.is.loadConstraints(this.constraintsIn, numDecisions, (IProgressMonitor)pm2);
                pm.subTask("Closing the \"cvars\" file");
                this.constraintsIn.close();
                pm.worked(2);
            }
            catch (Exception e) {
                IStatus iStatus = this.makeStatus(4, "An exception occurred while reading constraints from the \"cvars\" file.  No changes have been made to the workspace.", (Throwable)e);
                try {
                    this.decisionsIn.close();
                }
                catch (Exception exception) {}
                try {
                    this.constraintsIn.close();
                }
                catch (Exception exception) {}
                DirTracker dirTracker = this.dir;
                synchronized (dirTracker) {
                    this.dir.loadInProgress = false;
                }
                return iStatus;
            }
            this.is.markLoaded();
            try {
                pm.subTask("Applying inference data to the workspace");
                ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new /* Unavailable Anonymous Inner Class!! */, pm);
            }
            catch (Exception e) {
                IStatus iStatus = this.makeStatus(4, "An exception occurred while applying the inference data to the workspace.  Some markers might appear strangely until you reload successfully.", (Throwable)e);
                try {
                    this.decisionsIn.close();
                }
                catch (Exception exception) {}
                try {
                    this.constraintsIn.close();
                }
                catch (Exception exception) {}
                DirTracker dirTracker = this.dir;
                synchronized (dirTracker) {
                    this.dir.loadInProgress = false;
                }
                return iStatus;
            }
            errors = this.is.getNumParseErrors();
            if (errors != 0) break block100;
            IStatus iStatus = this.makeStatus(1, String.valueOf(this.is.getDecisions().size()) + " inference decision(s) were loaded and marked for source files in " + this.dir.getPath() + ".", null);
            try {
                this.decisionsIn.close();
            }
            catch (Exception exception) {}
            try {
                this.constraintsIn.close();
            }
            catch (Exception exception) {}
            DirTracker dirTracker = this.dir;
            synchronized (dirTracker) {
                this.dir.loadInProgress = false;
            }
            return iStatus;
        }
        IStatus iStatus = this.makeStatus(4, String.valueOf(this.is.getDecisions().size()) + " inference decision(s) were loaded and marked for source files in " + this.dir.getPath() + ".  However, " + errors + " parse errors occurred; offending parts of the compiler's output were ignored.", null);
        try {
            this.decisionsIn.close();
        }
        catch (Exception exception) {}
        try {
            this.constraintsIn.close();
        }
        catch (Exception exception) {}
        DirTracker dirTracker = this.dir;
        synchronized (dirTracker) {
            this.dir.loadInProgress = false;
        }
        return iStatus;
    }
}

