/*
 * Decompiled with CFR 0.152.
 */
package cycinf.ui;

import cycinf.cvars.Decision;
import cycinf.ui.InfstatsPartView;
import cycinf.ui.UIUtils;
import cycinf.util.Interchange;
import java.util.Collection;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionsView
extends InfstatsPartView<Decision> {
    public static final String PART_ID = "cycinf.DecisionsView";
    private static final int DECISION_NAME_COLUMN = 0;
    private static final int CVAR_PRETTY_COLUMN = 1;
    private static final int CVAR_NAME_COLUMN = 2;
    private static final int LOCATION_COLUMN = 3;

    public String getColumnText(Decision id, int index) {
        switch (index) {
            case 0: {
                return id.decisionName();
            }
            case 1: {
                return id.getCvar().prettyString();
            }
            case 2: {
                return id.getCvar().toString();
            }
            case 3: {
                return id.getLocation().toString();
            }
        }
        throw new IllegalArgumentException();
    }

    void doRevealElement(Decision id) {
        UIUtils.notifyReasoningView((Decision)id);
        UIUtils.revealDecision((Decision)id);
    }

    public DecisionsView() {
        super(Decision.class);
    }

    void setUpTableColumns(Table decisionsTable) {
        TableColumn dNameCol = new TableColumn(decisionsTable, 16384, 0);
        dNameCol.setText("Value");
        dNameCol.setWidth(50);
        TableColumn tPrettyCol = new TableColumn(decisionsTable, 16384, 1);
        tPrettyCol.setText("Cvar description");
        tPrettyCol.setWidth(400);
        TableColumn tNameCol = new TableColumn(decisionsTable, 16384, 2);
        tNameCol.setText("Cvar name");
        tNameCol.setWidth(200);
        TableColumn locationCol = new TableColumn(decisionsTable, 16384, 3);
        locationCol.setText("Location");
        locationCol.setWidth(200);
    }

    Collection<Decision> getElements() {
        return this.is.getDecisions();
    }

    Decision marshallElementFrom(Object o) {
        return Interchange.toDecision((Object)o);
    }

    String getInfstatsPartName() {
        return "decisions";
    }
}

