/*** Finite automaton for parsing a SIP-message ***/
class Dfa {
static public function act2symb(a:Int) {
  switch (a) {
  case 262: return "INVITEm";
  case 263: return "ACKm";
  case 264: return "OPTIONSm";
  case 265: return "BYEm";
  case 266: return "CANCELm";
  case 267: return "REGISTERm";
  case 268: return "alphanum";
  case 269: return "token";
  case 270: return "extension-method";
  case 271: return "Method";
  case 272: return "SIP-Version";
  case 273: return "Request-Line";
  case 274: return "Request";
  case 275: return "Status-Line";
  case 276: return "Response";
  case 277: return "SIP-message";
  case 278: return "SP";
  case 279: return "CRLF";
  case 280: return "message-header";
  case 281: return "Request-URI";
  case 282: return "Status-Code";
  case 283: return "CR";
  case 284: return "Accept";
  case 285: return "Accept-Encoding";
  case 286: return "Accept-Language";
  case 287: return "Alert-Info";
  case 288: return "Allow";
  case 289: return "Authentication-Info";
  case 290: return "Authorization";
  case 291: return "Call-ID";
  case 292: return "Call-Info";
  case 293: return "Contact";
  case 294: return "Content-Disposition";
  case 295: return "Content-Encoding";
  case 296: return "Content-Language";
  case 297: return "Content-Length";
  case 298: return "Content-Type";
  case 299: return "CSeq";
  case 300: return "Date";
  case 301: return "Error-Info";
  case 302: return "Expires";
  case 303: return "From";
  case 304: return "In-Reply-To";
  case 305: return "Max-Forwards";
  case 306: return "MIME-Version";
  case 307: return "Min-Expires";
  case 308: return "Organization";
  case 309: return "Priority";
  case 310: return "Proxy-Authenticate";
  case 311: return "Proxy-Authorization";
  case 312: return "Proxy-Require";
  case 313: return "Record-Route";
  case 314: return "Reply-To";
  case 315: return "Require";
  case 316: return "Retry-After";
  case 317: return "Route";
  case 318: return "Server";
  case 319: return "Subject";
  case 320: return "Supported";
  case 321: return "Timestamp";
  case 322: return "To";
  case 323: return "Unsupported";
  case 324: return "User-Agent";
  case 325: return "Via";
  case 326: return "Warning";
  case 327: return "WWW-Authenticate";
  case 328: return "header-name";
  case 329: return "extension-header";
  case 330: return "message-body";
  case 331: return "ALPHA";
  case 332: return "SIP-URI";
  case 333: return "SIPS-URI";
  case 334: return "scheme";
  case 335: return "absoluteURI";
  case 336: return "DIGIT";
  case 337: return "Informational";
  case 338: return "Redirection";
  case 339: return "Success";
  case 340: return "Client-Error";
  case 341: return "Server-Error";
  case 342: return "Global-Failure";
  case 343: return "extension-code";
  case 344: return "HCOLON";
  case 345: return "LF";
  case 346: return "OCTET";
  case 347: return "Reason-Phrase";
  case 348: return "HTAB";
  case 349: return "media-type";
  case 350: return "content-coding";
  case 351: return "from-spec";
  case 352: return "callid";
  case 353: return "option-tag";
  case 354: return "STAR";
  case 355: return "contact-param";
  case 356: return "TEXT-UTF8-TRIM";
  case 357: return "addr-spec";
  case 358: return "name-addr";
  case 359: return "via-parm";
  case 360: return "header-value";
  case 361: return "hier-part";
  case 362: return "opaque-part";
  case 363: return "unreserved";
  case 364: return "escaped";
  case 365: return "reserved";
  case 366: return "UTF8-CONT";
  case 367: return "UTF8-NONASCII";
  case 368: return "SWS";
  case 369: return "ietf-token";
  case 370: return "x-token";
  case 371: return "extension-token";
  case 372: return "discrete-type";
  case 373: return "composite-type";
  case 374: return "m-type";
  case 375: return "COMMA";
  case 376: return "WSP";
  case 377: return "LWS";
  case 378: return "quoted-string";
  case 379: return "LAQUOT";
  case 380: return "display-name";
  case 381: return "DQUOTE";
  case 382: return "word";
  case 383: return "TEXT-UTF8char";
  case 384: return "SEMI";
  case 385: return "protocol-name";
  case 386: return "sent-protocol";
  case 387: return "abs-path";
  case 388: return "net-path";
  case 389: return "uric-no-slash";
  case 390: return "HEXDIG";
  case 391: return "SLASH";
  case 392: return "to-param";
  case 393: return "userinfo";
  case 394: return "hostport";
  case 395: return "path-segments";
  case 396: return "uric";
  case 397: return "m-subtype";
  case 398: return "SIP-date";
  case 399: return "qdtext";
  case 400: return "quoted-pair";
  case 401: return "RAQUOT";
  case 402: return "from-param";
  case 403: return "contact-params";
  case 404: return "generic-param";
  case 405: return "tag-param";
  case 406: return "protocol-version";
  case 407: return "sent-by";
  case 408: return "user-unreserved";
  case 409: return "user";
  case 410: return "domainlabel";
  case 411: return "toplabel";
  case 412: return "hostname";
  case 413: return "IPv4address";
  case 414: return "IPv6reference";
  case 415: return "host";
  case 416: return "uri-parameters";
  case 417: return "authority";
  case 418: return "pchar";
  case 419: return "segment";
  case 420: return "query";
  case 421: return "iana-token";
  case 422: return "wkday";
  case 423: return "rfc1123-date";
  case 424: return "c-p-q";
  case 425: return "c-p-expires";
  case 426: return "contact-extension";
  case 427: return "route-param";
  case 428: return "EQUAL";
  case 429: return "IPv6address";
  case 430: return "headers";
  case 431: return "srvr";
  case 432: return "reg-name";
  case 433: return "param";
  case 434: return "accept-range";
  case 435: return "m-parameter";
  case 436: return "server-val";
  case 437: return "gen-value";
  case 438: return "transport";
  case 439: return "COLON";
  case 440: return "via-params";
  case 441: return "hex4";
  case 442: return "hexseq";
  case 443: return "hexpart";
  case 444: return "EPS2";
  case 445: return "password";
  case 446: return "port";
  case 447: return "uri-parameter";
  case 448: return "EPS1";
  case 449: return "media-range";
  case 450: return "m-attribute";
  case 451: return "delta-seconds";
  case 452: return "qvalue";
  case 453: return "LPAREN";
  case 454: return "comment";
  case 455: return "product";
  case 456: return "other-transport";
  case 457: return "via-ttl";
  case 458: return "via-maddr";
  case 459: return "via-received";
  case 460: return "via-branch";
  case 461: return "via-extension";
  case 462: return "warning-value";
  case 463: return "transport-param";
  case 464: return "user-param";
  case 465: return "method-param";
  case 466: return "ttl-param";
  case 467: return "maddr-param";
  case 468: return "lr-param";
  case 469: return "param-unreserved";
  case 470: return "paramchar";
  case 471: return "pname";
  case 472: return "other-param";
  case 473: return "header";
  case 474: return "date1";
  case 475: return "priority-value";
  case 476: return "rplyto-spec";
  case 477: return "rr-param";
  case 478: return "ctext";
  case 479: return "RPAREN";
  case 480: return "warn-code";
  case 481: return "hnv-unreserved";
  case 482: return "hname";
  case 483: return "accept-param";
  case 484: return "info";
  case 485: return "m-value";
  case 486: return "other-priority";
  case 487: return "product-version";
  case 488: return "pvalue";
  case 489: return "alert-param";
  case 490: return "time";
  case 491: return "error-uri";
  case 492: return "warn-agent";
  case 493: return "hvalue";
  case 494: return "rplyto-param";
  case 495: return "delay";
  case 496: return "ttl";
  case 497: return "pseudonym";
  case 498: return "month";
  case 499: return "rec-route";
  case 500: return "warn-text";
  case 501: return "other-user";
  case 502: return "credentials";
  case 503: return "retry-param";
  case 504: return "auth-scheme";
  case 505: return "other-response";
  case 506: return "info-param";
  case 507: return "encoding";
  case 508: return "language";
  case 509: return "codings";
  case 510: return "language-range";
  case 511: return "auth-param";
  case 512: return "language-tag";
  case 513: return "challenge";
  case 514: return "auth-param-name";
  case 515: return "primary-tag";
  case 516: return "other-challenge";
  case 517: return "ainfo";
  case 518: return "disp-type";
  case 519: return "subtag";
  case 520: return "nextnonce";
  case 521: return "message-qop";
  case 522: return "response-auth";
  case 523: return "cnonce";
  case 524: return "nonce-count";
  case 525: return "disp-extension-token";
  case 526: return "digest-response";
  case 527: return "disp-param";
  case 528: return "username";
  case 529: return "realm";
  case 530: return "nonce";
  case 531: return "digest-uri";
  case 532: return "dresponse";
  case 533: return "algorithm";
  case 534: return "opaque";
  case 535: return "dig-resp";
  case 536: return "handling-param";
  case 537: return "nc-value";
  case 538: return "LHEX";
  case 539: return "qop-value";
  case 540: return "digest-cln";
  case 541: return "domain";
  case 542: return "stale";
  case 543: return "qop-options";
  case 544: return "LDQUOT";
  case 545: return "cnonce-value";
  case 546: return "digest-uri-value";
  case 547: return "nonce-value";
  case 548: return "response-digest";
  case 549: return "realm-value";
  case 550: return "RDQUOT";
  case 551: return "request-digest";
  case 552: return "username-value";
  case 553: return "other-handling";
  case 554: return "URI";
  default: return "?unknown?";
  }
}
static public function attributes(state:Int) {
switch (state) {
case 2: return [269];
case 3: return [269];
case 4: return [269];
case 5: return [269];
case 6: return [269];
case 7: return [269];
case 8: return [269];
case 9: return [268];
case 10: return [268];
case 11: return [268];
case 12: return [268];
case 13: return [268];
case 14: return [268];
case 15: return [268];
case 16: return [268];
case 17: return [268];
case 18: return [269];
case 19: return [269];
case 20: return [268];
case 21: return [268];
case 22: return [269];
case 23: return [271];
case 24: return [271];
case 25: return [271];
case 26: return [271];
case 27: return [271];
case 28: return [271];
case 29: return [269];
case 30: return [270];
case 31: return [271];
case 35: return [277];
case 37: return [277];
case 38: return [];
case 39: return [269];
case 40: return [269];
case 41: return [269];
case 42: return [269];
case 43: return [269];
case 44: return [269];
case 45: return [269];
case 46: return [269];
case 47: return [269];
case 48: return [269];
case 50: return [];
case 51: return [269];
case 52: return [];
case 60: return [];
case 61: return [];
case 66: return [274];
case 68: return [];
case 69: return [276];
case 71: return [263];
case 72: return [265];
case 78: return [278];
case 83: return [283];
case 84: return [268];
case 85: return [268];
case 86: return [268];
case 87: return [268];
case 88: return [268];
case 89: return [268];
case 90: return [268];
case 91: return [268];
case 92: return [268];
case 93: return [268];
case 94: return [268];
case 95: return [268];
case 96: return [268];
case 97: return [268];
case 98: return [268];
case 99: return [268];
case 100: return [268];
case 101: return [268];
case 102: return [268];
case 103: return [268];
case 104: return [268];
case 105: return [268];
case 106: return [268];
case 107: return [268];
case 108: return [268];
case 109: return [268];
case 110: return [268];
case 111: return [268];
case 112: return [268];
case 113: return [268];
case 114: return [268];
case 115: return [268];
case 116: return [268];
case 117: return [268];
case 118: return [328];
case 166: return [330];
case 167: return [];
case 168: return [274];
case 169: return [];
case 170: return [276];
case 171: return [];
case 172: return [];
case 178: return [];
case 179: return [331];
case 180: return [331];
case 181: return [331];
case 182: return [331];
case 183: return [334];
case 184: return [281];
case 185: return [281];
case 187: return [281];
case 189: return [336];
case 190: return [336];
case 191: return [336];
case 192: return [336];
case 193: return [336];
case 194: return [336];
case 195: return [336];
case 197: return [282];
case 198: return [282];
case 199: return [282];
case 200: return [282];
case 201: return [282];
case 202: return [282];
case 203: return [282];
case 205: return [];
case 222: return [320];
case 233: return [319];
case 243: return [];
case 245: return [279];
case 247: return [280];
case 249: return [346];
case 250: return [];
case 251: return [330];
case 258: return [];
case 260: return [334];
case 261: return [334];
case 262: return [334];
case 264: return [];
case 265: return [334];
case 266: return [334];
case 267: return [];
case 271: return [];
case 286: return [];
case 287: return [347];
case 296: return [348];
case 301: return [298];
case 306: return [295];
case 308: return [368,380];
case 309: return [303];
case 312: return [291];
case 314: return [];
case 315: return [320];
case 316: return [297];
case 320: return [368,380];
case 321: return [293];
case 322: return [293];
case 335: return [];
case 336: return [319];
case 338: return [368,380];
case 339: return [322];
case 340: return [322];
case 345: return [325];
case 348: return [345];
case 349: return [];
case 350: return [];
case 351: return [360];
case 352: return [329];
case 353: return [];
case 355: return [];
case 356: return [330];
case 357: return [266];
case 358: return [262];
case 365: return [335];
case 366: return [335];
case 368: return [273];
case 369: return [337];
case 370: return [337];
case 371: return [337];
case 372: return [337];
case 373: return [337];
case 374: return [339];
case 375: return [338];
case 376: return [338];
case 377: return [338];
case 378: return [338];
case 379: return [338];
case 380: return [340];
case 381: return [340];
case 382: return [340];
case 383: return [340];
case 384: return [340];
case 385: return [340];
case 386: return [340];
case 387: return [340];
case 388: return [340];
case 389: return [340];
case 390: return [340];
case 391: return [340];
case 392: return [340];
case 393: return [340];
case 394: return [340];
case 395: return [340];
case 396: return [340];
case 397: return [340];
case 398: return [340];
case 399: return [340];
case 400: return [340];
case 401: return [340];
case 402: return [340];
case 403: return [340];
case 404: return [340];
case 405: return [340];
case 406: return [340];
case 407: return [340];
case 408: return [341];
case 409: return [341];
case 410: return [341];
case 411: return [341];
case 412: return [341];
case 413: return [341];
case 414: return [341];
case 415: return [342];
case 416: return [342];
case 417: return [342];
case 418: return [342];
case 419: return [343];
case 420: return [363];
case 421: return [365];
case 423: return [365];
case 424: return [363];
case 425: return [365];
case 426: return [363];
case 427: return [365];
case 428: return [363];
case 429: return [365];
case 430: return [365];
case 431: return [365];
case 432: return [363];
case 433: return [363];
case 434: return [363];
case 435: return [363];
case 436: return [366];
case 442: return [];
case 443: return [347];
case 444: return [347];
case 445: return [347];
case 446: return [347];
case 447: return [347];
case 448: return [347];
case 449: return [347];
case 450: return [275];
case 458: return [];
case 459: return [368];
case 460: return [344];
case 465: return [268];
case 466: return [268];
case 467: return [268];
case 468: return [268];
case 469: return [268];
case 470: return [268];
case 471: return [268];
case 472: return [268];
case 473: return [268];
case 474: return [268];
case 475: return [268];
case 476: return [268];
case 477: return [369];
case 478: return [371];
case 479: return [371];
case 480: return [372,373];
case 481: return [374];
case 482: return [374];
case 484: return [];
case 488: return [350];
case 489: return [368];
case 490: return [];
case 493: return [376];
case 494: return [376];
case 495: return [268,331];
case 496: return [268,331];
case 497: return [268,331];
case 498: return [268,331];
case 499: return [];
case 501: return [357];
case 502: return [357];
case 503: return [357];
case 505: return [377];
case 506: return [368];
case 508: return [380];
case 511: return [351];
case 512: return [351];
case 513: return [];
case 515: return [382];
case 516: return [381];
case 517: return [382];
case 518: return [382];
case 519: return [382];
case 520: return [382];
case 521: return [382];
case 522: return [382];
case 523: return [382];
case 524: return [382];
case 525: return [382];
case 526: return [382];
case 527: return [382];
case 528: return [382];
case 529: return [382];
case 530: return [382];
case 531: return [382];
case 532: return [382];
case 533: return [382];
case 534: return [382];
case 535: return [382];
case 536: return [382];
case 537: return [382];
case 538: return [382];
case 539: return [382];
case 540: return [352];
case 541: return [];
case 542: return [353];
case 544: return [];
case 545: return [297];
case 549: return [];
case 551: return [355];
case 552: return [355];
case 553: return [];
case 566: return [383];
case 567: return [383];
case 568: return [356];
case 570: return [368];
case 571: return [];
case 575: return [268];
case 576: return [268];
case 577: return [385];
case 580: return [];
case 584: return [];
case 585: return [];
case 586: return [360];
case 587: return [360];
case 588: return [360];
case 589: return [];
case 590: return [];
case 591: return [];
case 592: return [264];
case 594: return [272];
case 597: return [389];
case 598: return [389];
case 599: return [389];
case 600: return [389];
case 602: return [389];
case 603: return [389];
case 604: return [389];
case 605: return [389];
case 606: return [389];
case 607: return [389];
case 608: return [389];
case 609: return [361];
case 610: return [361];
case 611: return [362];
case 612: return [];
case 613: return [];
case 614: return [];
case 615: return [];
case 616: return [];
case 617: return [];
case 618: return [];
case 619: return [];
case 620: return [];
case 621: return [];
case 622: return [];
case 625: return [];
case 627: return [367];
case 633: return [];
case 634: return [347];
case 635: return [347];
case 636: return [347];
case 637: return [347];
case 638: return [347];
case 639: return [347];
case 640: return [347];
case 641: return [];
case 651: return [];
case 652: return [];
case 661: return [];
case 662: return [];
case 663: return [];
case 664: return [];
case 665: return [368];
case 670: return [];
case 672: return [295];
case 673: return [];
case 674: return [];
case 675: return [];
case 677: return [380];
case 678: return [];
case 680: return [377];
case 682: return [];
case 684: return [377];
case 685: return [];
case 686: return [379];
case 689: return [];
case 692: return [368];
case 694: return [];
case 697: return [382];
case 698: return [382];
case 699: return [382];
case 700: return [382];
case 701: return [382];
case 702: return [382];
case 703: return [382];
case 704: return [382];
case 705: return [382];
case 706: return [382];
case 707: return [382];
case 708: return [382];
case 709: return [382];
case 710: return [382];
case 711: return [382];
case 712: return [382];
case 713: return [382];
case 714: return [382];
case 715: return [382];
case 716: return [382];
case 717: return [382];
case 718: return [382];
case 720: return [];
case 721: return [382];
case 722: return [382];
case 723: return [];
case 725: return [];
case 726: return [];
case 727: return [320];
case 732: return [];
case 734: return [368,380];
case 735: return [293];
case 747: return [];
case 749: return [];
case 751: return [356];
case 755: return [322];
case 759: return [];
case 762: return [325];
case 766: return [];
case 767: return [360];
case 768: return [360];
case 769: return [360];
case 770: return [];
case 771: return [267];
case 772: return [];
case 773: return [272];
case 778: return [];
case 780: return [419];
case 781: return [387];
case 783: return [];
case 785: return [];
case 786: return [362];
case 787: return [390];
case 788: return [390];
case 789: return [390];
case 790: return [364];
case 791: return [];
case 792: return [367];
case 798: return [288];
case 813: return [370];
case 814: return [];
case 815: return [];
case 818: return [349];
case 820: return [300];
case 825: return [377];
case 826: return [];
case 828: return [378];
case 832: return [358];
case 835: return [351];
case 838: return [352];
case 842: return [354];
case 844: return [355];
case 857: return [356];
case 860: return [268];
case 861: return [268];
case 862: return [404];
case 863: return [392];
case 864: return [392];
case 867: return [385];
case 871: return [359];
case 874: return [];
case 875: return [408];
case 876: return [408];
case 877: return [408];
case 878: return [408];
case 879: return [268,336,363];
case 880: return [408];
case 881: return [408];
case 882: return [408];
case 883: return [268,331,363];
case 885: return [268,331,363];
case 886: return [410];
case 887: return [409];
case 888: return [409];
case 889: return [409];
case 892: return [411];
case 893: return [412];
case 894: return [415];
case 896: return [415];
case 897: return [415];
case 898: return [394];
case 900: return [416];
case 901: return [332];
case 904: return [431];
case 905: return [388];
case 906: return [418];
case 907: return [418];
case 908: return [418];
case 909: return [418];
case 910: return [418];
case 912: return [418];
case 913: return [418];
case 914: return [];
case 915: return [418];
case 916: return [418];
case 917: return [419];
case 918: return [395];
case 919: return [];
case 920: return [420];
case 921: return [361];
case 922: return [396];
case 923: return [396];
case 924: return [396];
case 925: return [];
case 926: return [];
case 927: return [367];
case 931: return [284];
case 934: return [];
case 935: return [288];
case 950: return [372];
case 952: return [];
case 954: return [268];
case 955: return [268];
case 956: return [369,421];
case 957: return [397];
case 958: return [397];
case 959: return [];
case 967: return [398];
case 968: return [];
case 971: return [375];
case 972: return [380];
case 973: return [399];
case 974: return [399];
case 976: return [399];
case 977: return [399];
case 978: return [399];
case 979: return [];
case 981: return [];
case 982: return [402];
case 983: return [402];
case 988: return [];
case 989: return [268];
case 990: return [268];
case 991: return [268];
case 992: return [268];
case 993: return [426];
case 994: return [403];
case 995: return [403];
case 996: return [403];
case 1005: return [368,380];
case 1006: return [317];
case 1011: return [384];
case 1013: return [368];
case 1014: return [];
case 1016: return [];
case 1019: return [406];
case 1021: return [268,336];
case 1022: return [268,331];
case 1023: return [268,331];
case 1024: return [407];
case 1025: return [];
case 1029: return [];
case 1030: return [];
case 1031: return [];
case 1035: return [];
case 1036: return [410];
case 1038: return [];
case 1039: return [409];
case 1040: return [409];
case 1041: return [409];
case 1043: return [393];
case 1046: return [];
case 1047: return [411];
case 1048: return [412];
case 1049: return [];
case 1050: return [];
case 1054: return [];
case 1056: return [];
case 1058: return [];
case 1059: return [332];
case 1060: return [333];
case 1061: return [408];
case 1062: return [408];
case 1063: return [408];
case 1064: return [408];
case 1065: return [268,336,363];
case 1067: return [408];
case 1068: return [408];
case 1070: return [268,331,363];
case 1071: return [268,331,363];
case 1072: return [];
case 1073: return [409];
case 1074: return [409];
case 1076: return [431];
case 1077: return [417];
case 1078: return [417];
case 1080: return [];
case 1081: return [388];
case 1082: return [];
case 1083: return [433];
case 1084: return [419];
case 1087: return [];
case 1088: return [419];
case 1090: return [];
case 1091: return [];
case 1092: return [420];
case 1093: return [];
case 1094: return [367];
case 1099: return [];
case 1100: return [284];
case 1107: return [299];
case 1109: return [372];
case 1110: return [372];
case 1113: return [372];
case 1114: return [391];
case 1115: return [];
case 1116: return [];
case 1118: return [349];
case 1127: return [];
case 1130: return [];
case 1131: return [];
case 1132: return [400];
case 1133: return [400];
case 1134: return [400];
case 1135: return [401];
case 1136: return [];
case 1143: return [];
case 1144: return [];
case 1153: return [427];
case 1154: return [];
case 1156: return [368];
case 1157: return [318];
case 1160: return [];
case 1163: return [368];
case 1164: return [404];
case 1167: return [];
case 1169: return [386];
case 1170: return [];
case 1171: return [];
case 1172: return [368];
case 1173: return [];
case 1176: return [359];
case 1180: return [441];
case 1181: return [442];
case 1182: return [443];
case 1183: return [429];
case 1184: return [414];
case 1185: return [444];
case 1187: return [445];
case 1189: return [];
case 1192: return [412];
case 1196: return [394];
case 1198: return [416];
case 1200: return [];
case 1201: return [333];
case 1202: return [448];
case 1203: return [432];
case 1204: return [];
case 1205: return [];
case 1206: return [448];
case 1208: return [];
case 1209: return [];
case 1211: return [];
case 1212: return [433];
case 1214: return [419];
case 1215: return [419];
case 1216: return [395];
case 1217: return [];
case 1218: return [420];
case 1219: return [367];
case 1222: return [269];
case 1224: return [434];
case 1227: return [288];
case 1235: return [];
case 1239: return [];
case 1240: return [];
case 1241: return [450];
case 1243: return [422];
case 1244: return [422];
case 1245: return [422];
case 1246: return [422];
case 1247: return [422];
case 1248: return [422];
case 1249: return [422];
case 1253: return [302];
case 1254: return [];
case 1255: return [];
case 1262: return [424];
case 1269: return [315];
case 1271: return [];
case 1273: return [317];
case 1274: return [455];
case 1277: return [436];
case 1278: return [436];
case 1279: return [];
case 1285: return [268,336];
case 1286: return [268,331];
case 1287: return [268,331];
case 1288: return [269,410];
case 1289: return [437];
case 1290: return [437];
case 1292: return [437];
case 1295: return [268];
case 1296: return [268];
case 1297: return [268];
case 1298: return [268];
case 1299: return [268];
case 1300: return [268];
case 1301: return [456];
case 1302: return [438];
case 1303: return [];
case 1305: return [407];
case 1306: return [268];
case 1307: return [268];
case 1308: return [268];
case 1309: return [268];
case 1310: return [268];
case 1311: return [268];
case 1312: return [268];
case 1313: return [268];
case 1314: return [461];
case 1315: return [440];
case 1316: return [440];
case 1317: return [440];
case 1318: return [440];
case 1319: return [440];
case 1321: return [326];
case 1323: return [443];
case 1324: return [];
case 1325: return [441];
case 1327: return [];
case 1329: return [];
case 1331: return [];
case 1332: return [];
case 1333: return [];
case 1334: return [445];
case 1335: return [445];
case 1336: return [445];
case 1337: return [445];
case 1338: return [445];
case 1339: return [];
case 1340: return [445];
case 1341: return [445];
case 1345: return [446];
case 1346: return [469];
case 1347: return [469];
case 1348: return [469];
case 1349: return [469];
case 1350: return [469];
case 1351: return [363];
case 1352: return [363];
case 1353: return [363];
case 1354: return [363];
case 1355: return [469];
case 1356: return [469];
case 1357: return [363];
case 1358: return [363];
case 1359: return [363];
case 1360: return [363];
case 1361: return [470];
case 1362: return [470];
case 1363: return [447];
case 1364: return [447];
case 1365: return [447];
case 1366: return [447];
case 1367: return [447];
case 1368: return [447];
case 1369: return [470];
case 1370: return [471];
case 1371: return [472];
case 1372: return [447];
case 1374: return [];
case 1376: return [430];
case 1377: return [];
case 1387: return [];
case 1390: return [431];
case 1391: return [];
case 1392: return [433];
case 1393: return [419];
case 1398: return [];
case 1400: return [284];
case 1411: return [373];
case 1413: return [];
case 1415: return [];
case 1419: return [451];
case 1420: return [];
case 1426: return [452];
case 1427: return [452];
case 1428: return [];
case 1431: return [309];
case 1435: return [368,380];
case 1436: return [314];
case 1437: return [];
case 1441: return [427];
case 1442: return [];
case 1445: return [368];
case 1449: return [454];
case 1450: return [];
case 1451: return [318];
case 1453: return [405];
case 1454: return [428];
case 1455: return [];
case 1456: return [];
case 1457: return [269];
case 1458: return [];
case 1459: return [269,410];
case 1460: return [];
case 1467: return [];
case 1468: return [];
case 1474: return [];
case 1475: return [];
case 1478: return [];
case 1482: return [443];
case 1483: return [441];
case 1485: return [442];
case 1486: return [443];
case 1488: return [429];
case 1489: return [445];
case 1490: return [445];
case 1491: return [445];
case 1492: return [445];
case 1493: return [445];
case 1494: return [];
case 1495: return [445];
case 1496: return [445];
case 1499: return [];
case 1500: return [446];
case 1501: return [];
case 1502: return [468];
case 1508: return [];
case 1509: return [];
case 1511: return [];
case 1512: return [471];
case 1514: return [];
case 1515: return [416];
case 1516: return [481];
case 1517: return [481];
case 1518: return [481];
case 1519: return [481];
case 1520: return [481];
case 1521: return [481];
case 1522: return [481];
case 1523: return [482];
case 1524: return [482];
case 1525: return [482];
case 1528: return [];
case 1529: return [432];
case 1532: return [449];
case 1533: return [449];
case 1534: return [449];
case 1536: return [434];
case 1540: return [368];
case 1541: return [292];
case 1549: return [368];
case 1550: return [435];
case 1554: return [];
case 1555: return [451];
case 1561: return [452];
case 1562: return [];
case 1563: return [452];
case 1565: return [268];
case 1566: return [268];
case 1567: return [268];
case 1568: return [268];
case 1569: return [268];
case 1570: return [268];
case 1571: return [486];
case 1572: return [475];
case 1573: return [];
case 1578: return [476];
case 1579: return [476];
case 1580: return [];
case 1581: return [315];
case 1583: return [477];
case 1585: return [455];
case 1586: return [453];
case 1587: return [478];
case 1588: return [478];
case 1589: return [478];
case 1590: return [368,478];
case 1592: return [478];
case 1593: return [];
case 1594: return [321];
case 1595: return [];
case 1596: return [];
case 1597: return [444];
case 1598: return [];
case 1602: return [438];
case 1603: return [438];
case 1604: return [438];
case 1605: return [439];
case 1612: return [326];
case 1614: return [441];
case 1615: return [443];
case 1618: return [];
case 1625: return [472];
case 1626: return [];
case 1628: return [];
case 1629: return [482];
case 1630: return [482];
case 1631: return [482];
case 1633: return [430];
case 1636: return [];
case 1638: return [268];
case 1639: return [268];
case 1640: return [483];
case 1641: return [368];
case 1642: return [287];
case 1646: return [];
case 1654: return [373];
case 1655: return [485];
case 1656: return [485];
case 1657: return [];
case 1661: return [368];
case 1662: return [301];
case 1668: return [452];
case 1669: return [452];
case 1674: return [];
case 1675: return [];
case 1680: return [];
case 1683: return [];
case 1684: return [487];
case 1685: return [];
case 1686: return [];
case 1687: return [];
case 1689: return [321];
case 1691: return [];
case 1692: return [321];
case 1695: return [324];
case 1696: return [438];
case 1697: return [];
case 1702: return [480];
case 1706: return [413];
case 1713: return [488];
case 1714: return [493];
case 1715: return [473];
case 1718: return [449];
case 1720: return [];
case 1722: return [];
case 1728: return [292];
case 1734: return [];
case 1739: return [];
case 1741: return [304];
case 1744: return [307];
case 1746: return [452];
case 1747: return [452];
case 1748: return [308];
case 1758: return [476];
case 1759: return [316];
case 1760: return [];
case 1761: return [479];
case 1763: return [321];
case 1764: return [495];
case 1765: return [321];
case 1766: return [323];
case 1767: return [];
case 1773: return [457];
case 1774: return [];
case 1775: return [497];
case 1776: return [492];
case 1777: return [492];
case 1780: return [];
case 1781: return [413];
case 1785: return [466];
case 1787: return [];
case 1788: return [488];
case 1789: return [];
case 1790: return [493];
case 1791: return [493];
case 1792: return [493];
case 1793: return [];
case 1796: return [483];
case 1798: return [287];
case 1801: return [484];
case 1806: return [372];
case 1812: return [301];
case 1813: return [];
case 1815: return [305];
case 1817: return [];
case 1819: return [452];
case 1820: return [452];
case 1821: return [];
case 1822: return [308];
case 1830: return [368,380];
case 1831: return [313];
case 1832: return [494];
case 1833: return [368];
case 1834: return [];
case 1836: return [316];
case 1837: return [];
case 1838: return [495];
case 1839: return [];
case 1840: return [495];
case 1841: return [];
case 1843: return [324];
case 1847: return [496];
case 1848: return [];
case 1849: return [];
case 1850: return [];
case 1851: return [368];
case 1852: return [462];
case 1854: return [413];
case 1858: return [];
case 1862: return [464];
case 1863: return [];
case 1864: return [493];
case 1865: return [493];
case 1866: return [493];
case 1869: return [489];
case 1872: return [290];
case 1873: return [];
case 1889: return [491];
case 1890: return [304];
case 1891: return [];
case 1892: return [305];
case 1895: return [425];
case 1902: return [312];
case 1903: return [499];
case 1904: return [];
case 1906: return [];
case 1909: return [316];
case 1910: return [];
case 1911: return [495];
case 1912: return [495];
case 1913: return [495];
case 1914: return [323];
case 1917: return [458];
case 1919: return [];
case 1920: return [496];
case 1921: return [500];
case 1922: return [];
case 1924: return [467];
case 1927: return [464];
case 1929: return [501];
case 1930: return [];
case 1931: return [285];
case 1932: return [286];
case 1933: return [];
case 1936: return [268];
case 1937: return [268];
case 1938: return [504];
case 1940: return [502];
case 1941: return [];
case 1943: return [484];
case 1959: return [423];
case 1960: return [];
case 1962: return [306];
case 1963: return [];
case 1966: return [475];
case 1967: return [475];
case 1970: return [];
case 1972: return [];
case 1974: return [313];
case 1975: return [268];
case 1976: return [268];
case 1977: return [503];
case 1978: return [495];
case 1979: return [460];
case 1980: return [];
case 1982: return [496];
case 1983: return [];
case 1985: return [];
case 1986: return [465];
case 1989: return [];
case 1991: return [];
case 1992: return [285];
case 1994: return [];
case 1995: return [286];
case 1997: return [489];
case 2000: return [];
case 2002: return [];
case 2003: return [268];
case 2004: return [268];
case 2005: return [506];
case 2008: return [498];
case 2009: return [498];
case 2010: return [498];
case 2011: return [498];
case 2012: return [498];
case 2013: return [498];
case 2014: return [498];
case 2015: return [498];
case 2016: return [498];
case 2017: return [498];
case 2018: return [498];
case 2019: return [498];
case 2022: return [];
case 2023: return [491];
case 2024: return [];
case 2025: return [306];
case 2030: return [312];
case 2031: return [499];
case 2033: return [];
case 2034: return [];
case 2037: return [];
case 2040: return [269,509];
case 2041: return [509];
case 2042: return [507];
case 2044: return [510];
case 2045: return [510];
case 2046: return [508];
case 2051: return [505];
case 2053: return [];
case 2056: return [296];
case 2057: return [];
case 2066: return [459];
case 2067: return [459];
case 2069: return [327];
case 2071: return [464];
case 2072: return [];
case 2073: return [];
case 2074: return [];
case 2076: return [285];
case 2077: return [];
case 2080: return [510];
case 2081: return [];
case 2083: return [286];
case 2086: return [514];
case 2088: return [];
case 2092: return [515];
case 2093: return [512];
case 2094: return [];
case 2096: return [474];
case 2098: return [475];
case 2103: return [336,390];
case 2104: return [];
case 2105: return [268];
case 2106: return [268];
case 2108: return [513];
case 2109: return [];
case 2114: return [463];
case 2115: return [507];
case 2116: return [510];
case 2117: return [510];
case 2118: return [508];
case 2121: return [];
case 2123: return [505];
case 2126: return [];
case 2127: return [515];
case 2129: return [];
case 2130: return [296];
case 2131: return [];
case 2132: return [490];
case 2133: return [475];
case 2134: return [310];
case 2137: return [];
case 2140: return [];
case 2145: return [];
case 2146: return [510];
case 2147: return [510];
case 2149: return [289];
case 2151: return [368];
case 2152: return [511];
case 2153: return [511];
case 2156: return [294];
case 2157: return [515];
case 2159: return [512];
case 2160: return [];
case 2161: return [];
case 2162: return [311];
case 2165: return [516];
case 2167: return [463];
case 2168: return [463];
case 2169: return [463];
case 2170: return [510];
case 2171: return [510];
case 2176: return [517];
case 2177: return [517];
case 2178: return [517];
case 2179: return [517];
case 2180: return [517];
case 2181: return [];
case 2184: return [];
case 2186: return [268];
case 2187: return [268];
case 2188: return [268];
case 2189: return [268];
case 2190: return [268];
case 2191: return [268];
case 2192: return [268];
case 2193: return [268];
case 2194: return [525];
case 2195: return [518];
case 2196: return [];
case 2198: return [515];
case 2199: return [519];
case 2200: return [];
case 2203: return [];
case 2205: return [463];
case 2206: return [510];
case 2207: return [510];
case 2213: return [];
case 2214: return [289];
case 2216: return [502];
case 2222: return [];
case 2223: return [];
case 2225: return [294];
case 2226: return [515];
case 2227: return [];
case 2228: return [519];
case 2231: return [516];
case 2232: return [510];
case 2233: return [510];
case 2239: return [268];
case 2240: return [268];
case 2241: return [268];
case 2242: return [268];
case 2243: return [268];
case 2244: return [268];
case 2245: return [268];
case 2246: return [268];
case 2247: return [268];
case 2248: return [268];
case 2249: return [268];
case 2250: return [268];
case 2251: return [268];
case 2252: return [268];
case 2253: return [535];
case 2254: return [535];
case 2255: return [535];
case 2256: return [535];
case 2257: return [535];
case 2258: return [535];
case 2259: return [535];
case 2260: return [535];
case 2261: return [535];
case 2262: return [535];
case 2263: return [535];
case 2264: return [526];
case 2270: return [268];
case 2271: return [268];
case 2272: return [527];
case 2273: return [527];
case 2274: return [515];
case 2275: return [519];
case 2278: return [510];
case 2279: return [510];
case 2282: return [524];
case 2292: return [];
case 2293: return [];
case 2297: return [506];
case 2299: return [518];
case 2303: return [];
case 2304: return [515];
case 2305: return [519];
case 2306: return [503];
case 2308: return [510];
case 2310: return [538];
case 2311: return [538];
case 2313: return [];
case 2316: return [521];
case 2326: return [526];
case 2330: return [518];
case 2334: return [515];
case 2335: return [519];
case 2337: return [513];
case 2338: return [510];
case 2340: return [];
case 2344: return [268];
case 2345: return [268];
case 2346: return [539];
case 2347: return [];
case 2359: return [518];
case 2362: return [519];
case 2363: return [268];
case 2364: return [268];
case 2365: return [268];
case 2366: return [268];
case 2367: return [268];
case 2368: return [268];
case 2369: return [268];
case 2370: return [268];
case 2371: return [268];
case 2372: return [268];
case 2373: return [540];
case 2374: return [540];
case 2375: return [540];
case 2376: return [540];
case 2377: return [540];
case 2378: return [540];
case 2379: return [540];
case 2380: return [540];
case 2386: return [];
case 2393: return [368];
case 2396: return [506];
case 2397: return [506];
case 2398: return [506];
case 2399: return [518];
case 2401: return [519];
case 2406: return [];
case 2407: return [513];
case 2408: return [368];
case 2409: return [523];
case 2424: return [519];
case 2428: return [547];
case 2429: return [545];
case 2430: return [];
case 2433: return [539];
case 2434: return [368];
case 2435: return [522];
case 2437: return [368];
case 2438: return [530];
case 2440: return [368];
case 2441: return [529];
case 2443: return [544];
case 2444: return [546];
case 2446: return [531];
case 2452: return [];
case 2453: return [];
case 2458: return [];
case 2460: return [];
case 2461: return [368];
case 2462: return [534];
case 2463: return [549];
case 2464: return [];
case 2466: return [];
case 2467: return [];
case 2469: return [];
case 2476: return [520];
case 2480: return [548];
case 2482: return [];
case 2483: return [];
case 2485: return [550];
case 2491: return [537];
case 2492: return [];
case 2494: return [];
case 2496: return [368];
case 2497: return [532];
case 2498: return [];
case 2499: return [368];
case 2500: return [528];
case 2504: return [536];
case 2507: return [543];
case 2510: return [];
case 2511: return [539];
case 2513: return [533];
case 2515: return [];
case 2516: return [552];
case 2517: return [];
case 2520: return [553];
case 2521: return [];
case 2524: return [];
case 2528: return [];
case 2530: return [];
case 2533: return [];
case 2538: return [533];
case 2542: return [554];
case 2543: return [554];
case 2546: return [541];
case 2548: return [542];
case 2553: return [];
case 2557: return [];
case 2558: return [542];
case 2559: return [];
case 2570: return [536];
case 2571: return [536];
case 2572: return [533];
case 2599: return [551];
case 2600: return [];
default: return null;
}
}
static public function transitions(state:Int) {
switch (state) {
case 1: return function (act:Int) {switch (act) { case 33: return {t:2,w:5.036952}; case 37: return {t:3,w:5.036952}; case 39: return {t:4,w:5.036952}; case 42: return {t:5,w:5.036952}; case 43: return {t:6,w:5.036952}; case 45: return {t:7,w:5.036952}; case 46: return {t:8,w:5.036952}; case 48: return {t:9,w:8.438149}; case 49: return {t:9,w:8.438149}; case 50: return {t:9,w:8.438149}; case 51: return {t:9,w:8.438149}; case 52: return {t:9,w:8.438149}; case 53: return {t:9,w:8.438149}; case 54: return {t:9,w:8.438149}; case 55: return {t:9,w:8.438149}; case 56: return {t:9,w:8.438149}; case 57: return {t:9,w:8.438149}; case 65: return {t:10,w:2.639057}; case 66: return {t:11,w:2.639057}; case 67: return {t:12,w:2.639057}; case 68: return {t:13,w:9.393661}; case 69: return {t:13,w:9.393661}; case 70: return {t:13,w:9.393661}; case 71: return {t:13,w:9.393661}; case 72: return {t:13,w:9.393661}; case 73: return {t:14,w:2.639057}; case 74: return {t:13,w:9.393661}; case 75: return {t:13,w:9.393661}; case 76: return {t:13,w:9.393661}; case 77: return {t:13,w:9.393661}; case 78: return {t:13,w:9.393661}; case 79: return {t:15,w:2.639057}; case 80: return {t:13,w:9.393661}; case 81: return {t:13,w:9.393661}; case 82: return {t:16,w:2.639057}; case 83: return {t:17,w:1.386294}; case 84: return {t:13,w:9.393661}; case 85: return {t:13,w:9.393661}; case 86: return {t:13,w:9.393661}; case 87: return {t:13,w:9.393661}; case 88: return {t:13,w:9.393661}; case 89: return {t:13,w:9.393661}; case 90: return {t:13,w:9.393661}; case 95: return {t:18,w:5.036952}; case 96: return {t:19,w:5.036952}; case 97: return {t:20,w:9.393661}; case 98: return {t:20,w:9.393661}; case 99: return {t:20,w:9.393661}; case 100: return {t:20,w:9.393661}; case 101: return {t:20,w:9.393661}; case 102: return {t:20,w:9.393661}; case 103: return {t:20,w:9.393661}; case 104: return {t:20,w:9.393661}; case 105: return {t:20,w:9.393661}; case 106: return {t:20,w:9.393661}; case 107: return {t:20,w:9.393661}; case 108: return {t:20,w:9.393661}; case 109: return {t:20,w:9.393661}; case 110: return {t:20,w:9.393661}; case 111: return {t:20,w:9.393661}; case 112: return {t:20,w:9.393661}; case 113: return {t:20,w:9.393661}; case 114: return {t:20,w:9.393661}; case 115: return {t:21,w:1.386294}; case 116: return {t:20,w:9.393661}; case 117: return {t:20,w:9.393661}; case 118: return {t:20,w:9.393661}; case 119: return {t:20,w:9.393661}; case 120: return {t:20,w:9.393661}; case 121: return {t:20,w:9.393661}; case 122: return {t:20,w:9.393661}; case 126: return {t:22,w:5.036952}; case 262: return {t:23,w:2.639057}; case 263: return {t:24,w:2.639057}; case 264: return {t:25,w:2.639057}; case 265: return {t:26,w:2.639057}; case 266: return {t:27,w:2.639057}; case 267: return {t:28,w:2.639057}; case 268: return {t:29,w:5.036952}; case 269: return {t:30,w:2.639057}; case 270: return {t:31,w:2.639057}; case 271: return {t:32,w:0.693147}; case 272: return {t:33,w:0.693147}; case 273: return {t:34,w:0.693147}; case 274: return {t:35,w:0.693147}; case 275: return {t:36,w:0.693147}; case 276: return {t:37,w:0.693147}; case 277: return {t:38,w:0.000000};default: return {t:0,w:0.0};}};
case 2: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 3: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 4: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 5: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 6: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 7: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 8: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 9: return function (act:Int) {switch (act) { case 258: return {t:52,w:0.000000};default: return {t:0,w:0.0};}};
case 10: return function (act:Int) {switch (act) { case 67: return {t:53,w:0.000000}; case 258: return {t:52,w:6.754603};default: return {t:0,w:0.0};}};
case 11: return function (act:Int) {switch (act) { case 89: return {t:54,w:0.000000}; case 258: return {t:52,w:6.754603};default: return {t:0,w:0.0};}};
case 12: return function (act:Int) {switch (act) { case 65: return {t:55,w:0.000000}; case 258: return {t:52,w:6.754603};default: return {t:0,w:0.0};}};
case 13: return function (act:Int) {switch (act) { case 258: return {t:52,w:0.000000};default: return {t:0,w:0.0};}};
case 14: return function (act:Int) {switch (act) { case 78: return {t:56,w:0.000000}; case 258: return {t:52,w:6.754603};default: return {t:0,w:0.0};}};
case 15: return function (act:Int) {switch (act) { case 80: return {t:57,w:0.000000}; case 258: return {t:52,w:6.754603};default: return {t:0,w:0.0};}};
case 16: return function (act:Int) {switch (act) { case 69: return {t:58,w:0.000000}; case 258: return {t:52,w:6.754603};default: return {t:0,w:0.0};}};
case 17: return function (act:Int) {switch (act) { case 73: return {t:59,w:0.693147}; case 105: return {t:59,w:0.693147}; case 258: return {t:52,w:8.007366};default: return {t:0,w:0.0};}};
case 18: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 19: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 20: return function (act:Int) {switch (act) { case 258: return {t:52,w:0.000000};default: return {t:0,w:0.0};}};
case 21: return function (act:Int) {switch (act) { case 73: return {t:59,w:0.693147}; case 105: return {t:59,w:0.693147}; case 258: return {t:52,w:8.007366};default: return {t:0,w:0.0};}};
case 22: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 23: return function (act:Int) {switch (act) { case 258: return {t:60,w:0.000000};default: return {t:0,w:0.0};}};
case 24: return function (act:Int) {switch (act) { case 258: return {t:60,w:0.000000};default: return {t:0,w:0.0};}};
case 25: return function (act:Int) {switch (act) { case 258: return {t:60,w:0.000000};default: return {t:0,w:0.0};}};
case 26: return function (act:Int) {switch (act) { case 258: return {t:60,w:0.000000};default: return {t:0,w:0.0};}};
case 27: return function (act:Int) {switch (act) { case 258: return {t:60,w:0.000000};default: return {t:0,w:0.0};}};
case 28: return function (act:Int) {switch (act) { case 258: return {t:60,w:0.000000};default: return {t:0,w:0.0};}};
case 29: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 30: return function (act:Int) {switch (act) { case 258: return {t:61,w:0.000000};default: return {t:0,w:0.0};}};
case 31: return function (act:Int) {switch (act) { case 258: return {t:60,w:0.000000};default: return {t:0,w:0.0};}};
case 32: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:63,w:0.000000};default: return {t:0,w:0.0};}};
case 33: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:64,w:0.000000};default: return {t:0,w:0.0};}};
case 34: return function (act:Int) {switch (act) { case 256: return {t:65,w:4000000.750000}; case 279: return {t:66,w:0.693147}; case 280: return {t:67,w:0.693147};default: return {t:0,w:0.0};}};
case 35: return function (act:Int) {switch (act) { case 258: return {t:68,w:0.000000};default: return {t:0,w:0.0};}};
case 36: return function (act:Int) {switch (act) { case 256: return {t:65,w:4000000.750000}; case 279: return {t:69,w:0.693147}; case 280: return {t:70,w:0.693147};default: return {t:0,w:0.0};}};
case 37: return function (act:Int) {switch (act) { case 258: return {t:68,w:0.000000};default: return {t:0,w:0.0};}};
case 39: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 40: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 41: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 42: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 43: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 44: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 45: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 46: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 47: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 48: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 49: return function (act:Int) {switch (act) { case 48: return {t:9,w:3.401197}; case 49: return {t:9,w:3.401197}; case 50: return {t:9,w:3.401197}; case 51: return {t:9,w:3.401197}; case 52: return {t:9,w:3.401197}; case 53: return {t:9,w:3.401197}; case 54: return {t:9,w:3.401197}; case 55: return {t:9,w:3.401197}; case 56: return {t:9,w:3.401197}; case 57: return {t:9,w:3.401197}; case 65: return {t:13,w:4.356709}; case 66: return {t:13,w:4.356709}; case 67: return {t:13,w:4.356709}; case 68: return {t:13,w:4.356709}; case 69: return {t:13,w:4.356709}; case 70: return {t:13,w:4.356709}; case 71: return {t:13,w:4.356709}; case 72: return {t:13,w:4.356709}; case 73: return {t:13,w:4.356709}; case 74: return {t:13,w:4.356709}; case 75: return {t:13,w:4.356709}; case 76: return {t:13,w:4.356709}; case 77: return {t:13,w:4.356709}; case 78: return {t:13,w:4.356709}; case 79: return {t:13,w:4.356709}; case 80: return {t:13,w:4.356709}; case 81: return {t:13,w:4.356709}; case 82: return {t:13,w:4.356709}; case 83: return {t:13,w:4.356709}; case 84: return {t:13,w:4.356709}; case 85: return {t:13,w:4.356709}; case 86: return {t:13,w:4.356709}; case 87: return {t:13,w:4.356709}; case 88: return {t:13,w:4.356709}; case 89: return {t:13,w:4.356709}; case 90: return {t:13,w:4.356709}; case 97: return {t:20,w:4.356709}; case 98: return {t:20,w:4.356709}; case 99: return {t:20,w:4.356709}; case 100: return {t:20,w:4.356709}; case 101: return {t:20,w:4.356709}; case 102: return {t:20,w:4.356709}; case 103: return {t:20,w:4.356709}; case 104: return {t:20,w:4.356709}; case 105: return {t:20,w:4.356709}; case 106: return {t:20,w:4.356709}; case 107: return {t:20,w:4.356709}; case 108: return {t:20,w:4.356709}; case 109: return {t:20,w:4.356709}; case 110: return {t:20,w:4.356709}; case 111: return {t:20,w:4.356709}; case 112: return {t:20,w:4.356709}; case 113: return {t:20,w:4.356709}; case 114: return {t:20,w:4.356709}; case 115: return {t:20,w:4.356709}; case 116: return {t:20,w:4.356709}; case 117: return {t:20,w:4.356709}; case 118: return {t:20,w:4.356709}; case 119: return {t:20,w:4.356709}; case 120: return {t:20,w:4.356709}; case 121: return {t:20,w:4.356709}; case 122: return {t:20,w:4.356709};default: return {t:0,w:0.0};}};
case 50: return function (act:Int) {switch (act) { case 269: return {t:50,w:0.000000};default: return {t:0,w:0.0};}};
case 51: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:44,w:3.091042}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000003.250000}; case 258: return {t:50,w:0.693147}; case 268: return {t:51,w:3.091042};default: return {t:0,w:0.0};}};
case 52: return function (act:Int) {switch (act) { case 268: return {t:52,w:0.000000};default: return {t:0,w:0.0};}};
case 53: return function (act:Int) {switch (act) { case 75: return {t:71,w:0.000000};default: return {t:0,w:0.0};}};
case 54: return function (act:Int) {switch (act) { case 69: return {t:72,w:0.000000};default: return {t:0,w:0.0};}};
case 55: return function (act:Int) {switch (act) { case 78: return {t:73,w:0.000000};default: return {t:0,w:0.0};}};
case 56: return function (act:Int) {switch (act) { case 86: return {t:74,w:0.000000};default: return {t:0,w:0.0};}};
case 57: return function (act:Int) {switch (act) { case 84: return {t:75,w:0.000000};default: return {t:0,w:0.0};}};
case 58: return function (act:Int) {switch (act) { case 71: return {t:76,w:0.000000};default: return {t:0,w:0.0};}};
case 59: return function (act:Int) {switch (act) { case 80: return {t:77,w:0.693147}; case 112: return {t:77,w:0.693147};default: return {t:0,w:0.0};}};
case 60: return function (act:Int) {switch (act) { case 271: return {t:60,w:0.000000};default: return {t:0,w:0.0};}};
case 61: return function (act:Int) {switch (act) { case 270: return {t:61,w:0.000000};default: return {t:0,w:0.0};}};
case 62: return function (act:Int) {switch (act) { case 32: return {t:78,w:0.000000};default: return {t:0,w:0.0};}};
case 63: return function (act:Int) {switch (act) { case 256: return {t:79,w:4000000.000000}; case 281: return {t:80,w:0.000000};default: return {t:0,w:0.0};}};
case 64: return function (act:Int) {switch (act) { case 256: return {t:81,w:4000000.000000}; case 282: return {t:82,w:0.000000};default: return {t:0,w:0.0};}};
case 65: return function (act:Int) {switch (act) { case 13: return {t:83,w:0.000000}; case 33: return {t:2,w:6.204557}; case 37: return {t:3,w:6.204557}; case 39: return {t:4,w:6.204557}; case 42: return {t:5,w:6.204557}; case 43: return {t:6,w:6.204557}; case 45: return {t:7,w:6.204557}; case 46: return {t:8,w:6.204557}; case 48: return {t:9,w:9.605755}; case 49: return {t:9,w:9.605755}; case 50: return {t:9,w:9.605755}; case 51: return {t:9,w:9.605755}; case 52: return {t:9,w:9.605755}; case 53: return {t:9,w:9.605755}; case 54: return {t:9,w:9.605755}; case 55: return {t:9,w:9.605755}; case 56: return {t:9,w:9.605755}; case 57: return {t:9,w:9.605755}; case 65: return {t:84,w:4.499809}; case 66: return {t:13,w:10.561266}; case 67: return {t:85,w:4.499809}; case 68: return {t:86,w:4.499809}; case 69: return {t:87,w:4.499809}; case 70: return {t:88,w:5.192956}; case 71: return {t:13,w:10.561266}; case 72: return {t:13,w:10.561266}; case 73: return {t:89,w:4.499809}; case 74: return {t:13,w:10.561266}; case 75: return {t:90,w:5.192956}; case 76: return {t:91,w:5.192956}; case 77: return {t:92,w:4.499809}; case 78: return {t:13,w:10.561266}; case 79: return {t:93,w:4.499809}; case 80: return {t:94,w:4.499809}; case 81: return {t:13,w:10.561266}; case 82: return {t:95,w:4.499809}; case 83: return {t:96,w:4.499809}; case 84: return {t:97,w:4.499809}; case 85: return {t:98,w:4.499809}; case 86: return {t:99,w:5.192956}; case 87: return {t:100,w:4.499809}; case 88: return {t:13,w:10.561266}; case 89: return {t:13,w:10.561266}; case 90: return {t:13,w:10.561266}; case 95: return {t:18,w:6.204557}; case 96: return {t:19,w:6.204557}; case 97: return {t:101,w:4.499809}; case 98: return {t:20,w:10.561266}; case 99: return {t:102,w:4.499809}; case 100: return {t:103,w:4.499809}; case 101: return {t:104,w:4.499809}; case 102: return {t:105,w:5.192956}; case 103: return {t:20,w:10.561266}; case 104: return {t:20,w:10.561266}; case 105: return {t:106,w:4.499809}; case 106: return {t:20,w:10.561266}; case 107: return {t:107,w:5.192956}; case 108: return {t:108,w:5.192956}; case 109: return {t:109,w:4.499809}; case 110: return {t:20,w:10.561266}; case 111: return {t:110,w:4.499809}; case 112: return {t:111,w:4.499809}; case 113: return {t:20,w:10.561266}; case 114: return {t:112,w:4.499809}; case 115: return {t:113,w:4.499809}; case 116: return {t:114,w:4.499809}; case 117: return {t:115,w:4.499809}; case 118: return {t:116,w:5.192956}; case 119: return {t:117,w:4.499809}; case 120: return {t:20,w:10.561266}; case 121: return {t:20,w:10.561266}; case 122: return {t:20,w:10.561266}; case 126: return {t:22,w:6.204557}; case 268: return {t:29,w:6.204557}; case 269: return {t:118,w:3.806662}; case 283: return {t:119,w:0.000000}; case 284: return {t:120,w:3.806662}; case 285: return {t:121,w:3.806662}; case 286: return {t:122,w:3.806662}; case 287: return {t:123,w:3.806662}; case 288: return {t:124,w:3.806662}; case 289: return {t:125,w:3.806662}; case 290: return {t:126,w:3.806662}; case 291: return {t:127,w:3.806662}; case 292: return {t:128,w:3.806662}; case 293: return {t:129,w:3.806662}; case 294: return {t:130,w:3.806662}; case 295: return {t:131,w:3.806662}; case 296: return {t:132,w:3.806662}; case 297: return {t:133,w:3.806662}; case 298: return {t:134,w:3.806662}; case 299: return {t:135,w:3.806662}; case 300: return {t:136,w:3.806662}; case 301: return {t:137,w:3.806662}; case 302: return {t:138,w:3.806662}; case 303: return {t:139,w:3.806662}; case 304: return {t:140,w:3.806662}; case 305: return {t:141,w:3.806662}; case 306: return {t:142,w:3.806662}; case 307: return {t:143,w:3.806662}; case 308: return {t:144,w:3.806662}; case 309: return {t:145,w:3.806662}; case 310: return {t:146,w:3.806662}; case 311: return {t:147,w:3.806662}; case 312: return {t:148,w:3.806662}; case 313: return {t:149,w:3.806662}; case 314: return {t:150,w:3.806662}; case 315: return {t:151,w:3.806662}; case 316: return {t:152,w:3.806662}; case 317: return {t:153,w:3.806662}; case 318: return {t:154,w:3.806662}; case 319: return {t:155,w:3.806662}; case 320: return {t:156,w:3.806662}; case 321: return {t:157,w:3.806662}; case 322: return {t:158,w:3.806662}; case 323: return {t:159,w:3.806662}; case 324: return {t:160,w:3.806662}; case 325: return {t:161,w:3.806662}; case 326: return {t:162,w:3.806662}; case 327: return {t:163,w:3.806662}; case 328: return {t:164,w:3.806662}; case 329: return {t:165,w:3.806662};default: return {t:0,w:0.0};}};
case 66: return function (act:Int) {switch (act) { case 256: return {t:166,w:4000000.750000}; case 258: return {t:167,w:0.693147}; case 330: return {t:168,w:0.693147};default: return {t:0,w:0.0};}};
case 67: return function (act:Int) {switch (act) { case 256: return {t:65,w:4000000.750000}; case 279: return {t:66,w:0.693147}; case 280: return {t:67,w:0.693147};default: return {t:0,w:0.0};}};
case 68: return function (act:Int) {switch (act) { case 277: return {t:68,w:0.000000};default: return {t:0,w:0.0};}};
case 69: return function (act:Int) {switch (act) { case 256: return {t:166,w:4000000.750000}; case 258: return {t:169,w:0.693147}; case 330: return {t:170,w:0.693147};default: return {t:0,w:0.0};}};
case 70: return function (act:Int) {switch (act) { case 256: return {t:65,w:4000000.750000}; case 279: return {t:69,w:0.693147}; case 280: return {t:70,w:0.693147};default: return {t:0,w:0.0};}};
case 71: return function (act:Int) {switch (act) { case 258: return {t:171,w:0.000000};default: return {t:0,w:0.0};}};
case 72: return function (act:Int) {switch (act) { case 258: return {t:172,w:0.000000};default: return {t:0,w:0.0};}};
case 73: return function (act:Int) {switch (act) { case 67: return {t:173,w:0.000000};default: return {t:0,w:0.0};}};
case 74: return function (act:Int) {switch (act) { case 73: return {t:174,w:0.000000};default: return {t:0,w:0.0};}};
case 75: return function (act:Int) {switch (act) { case 73: return {t:175,w:0.000000};default: return {t:0,w:0.0};}};
case 76: return function (act:Int) {switch (act) { case 73: return {t:176,w:0.000000};default: return {t:0,w:0.0};}};
case 77: return function (act:Int) {switch (act) { case 47: return {t:177,w:0.000000};default: return {t:0,w:0.0};}};
case 78: return function (act:Int) {switch (act) { case 258: return {t:178,w:0.000000};default: return {t:0,w:0.0};}};
case 79: return function (act:Int) {switch (act) { case 65: return {t:179,w:5.049856}; case 66: return {t:179,w:5.049856}; case 67: return {t:179,w:5.049856}; case 68: return {t:179,w:5.049856}; case 69: return {t:179,w:5.049856}; case 70: return {t:179,w:5.049856}; case 71: return {t:179,w:5.049856}; case 72: return {t:179,w:5.049856}; case 73: return {t:179,w:5.049856}; case 74: return {t:179,w:5.049856}; case 75: return {t:179,w:5.049856}; case 76: return {t:179,w:5.049856}; case 77: return {t:179,w:5.049856}; case 78: return {t:179,w:5.049856}; case 79: return {t:179,w:5.049856}; case 80: return {t:179,w:5.049856}; case 81: return {t:179,w:5.049856}; case 82: return {t:179,w:5.049856}; case 83: return {t:180,w:1.791759}; case 84: return {t:179,w:5.049856}; case 85: return {t:179,w:5.049856}; case 86: return {t:179,w:5.049856}; case 87: return {t:179,w:5.049856}; case 88: return {t:179,w:5.049856}; case 89: return {t:179,w:5.049856}; case 90: return {t:179,w:5.049856}; case 97: return {t:181,w:5.049856}; case 98: return {t:181,w:5.049856}; case 99: return {t:181,w:5.049856}; case 100: return {t:181,w:5.049856}; case 101: return {t:181,w:5.049856}; case 102: return {t:181,w:5.049856}; case 103: return {t:181,w:5.049856}; case 104: return {t:181,w:5.049856}; case 105: return {t:181,w:5.049856}; case 106: return {t:181,w:5.049856}; case 107: return {t:181,w:5.049856}; case 108: return {t:181,w:5.049856}; case 109: return {t:181,w:5.049856}; case 110: return {t:181,w:5.049856}; case 111: return {t:181,w:5.049856}; case 112: return {t:181,w:5.049856}; case 113: return {t:181,w:5.049856}; case 114: return {t:181,w:5.049856}; case 115: return {t:182,w:1.791759}; case 116: return {t:181,w:5.049856}; case 117: return {t:181,w:5.049856}; case 118: return {t:181,w:5.049856}; case 119: return {t:181,w:5.049856}; case 120: return {t:181,w:5.049856}; case 121: return {t:181,w:5.049856}; case 122: return {t:181,w:5.049856}; case 331: return {t:183,w:1.098612}; case 332: return {t:184,w:1.098612}; case 333: return {t:185,w:1.098612}; case 334: return {t:186,w:1.098612}; case 335: return {t:187,w:1.098612};default: return {t:0,w:0.0};}};
case 80: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:188,w:0.000000};default: return {t:0,w:0.0};}};
case 81: return function (act:Int) {switch (act) { case 48: return {t:189,w:4.248495}; case 49: return {t:190,w:3.555348}; case 50: return {t:191,w:1.945910}; case 51: return {t:192,w:3.555348}; case 52: return {t:193,w:4.248495}; case 53: return {t:194,w:3.891820}; case 54: return {t:195,w:3.332204}; case 55: return {t:189,w:4.248495}; case 56: return {t:189,w:4.248495}; case 57: return {t:189,w:4.248495}; case 336: return {t:196,w:1.945910}; case 337: return {t:197,w:1.945910}; case 338: return {t:198,w:1.945910}; case 339: return {t:199,w:1.945910}; case 340: return {t:200,w:1.945910}; case 341: return {t:201,w:1.945910}; case 342: return {t:202,w:1.945910}; case 343: return {t:203,w:1.945910};default: return {t:0,w:0.0};}};
case 82: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:204,w:0.000000};default: return {t:0,w:0.0};}};
case 83: return function (act:Int) {switch (act) { case 258: return {t:205,w:0.000000};default: return {t:0,w:0.0};}};
case 84: return function (act:Int) {switch (act) { case 67: return {t:206,w:0.693147}; case 76: return {t:207,w:0.693147}; case 85: return {t:208,w:0.693147}; case 99: return {t:206,w:0.693147}; case 108: return {t:207,w:0.693147}; case 117: return {t:208,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 85: return function (act:Int) {switch (act) { case 65: return {t:209,w:0.693147}; case 79: return {t:210,w:0.693147}; case 83: return {t:211,w:0.693147}; case 97: return {t:209,w:0.693147}; case 111: return {t:210,w:0.693147}; case 115: return {t:211,w:0.693147}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:213,w:0.693147};default: return {t:0,w:0.0};}};
case 86: return function (act:Int) {switch (act) { case 65: return {t:214,w:0.693147}; case 97: return {t:214,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 87: return function (act:Int) {switch (act) { case 82: return {t:215,w:0.693147}; case 88: return {t:216,w:0.693147}; case 114: return {t:215,w:0.693147}; case 120: return {t:216,w:0.693147}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:217,w:0.693147};default: return {t:0,w:0.0};}};
case 88: return function (act:Int) {switch (act) { case 82: return {t:218,w:0.693147}; case 114: return {t:218,w:0.693147}; case 256: return {t:212,w:4000000.000000}; case 258: return {t:52,w:5.368310}; case 344: return {t:219,w:0.000000};default: return {t:0,w:0.0};}};
case 89: return function (act:Int) {switch (act) { case 78: return {t:220,w:0.693147}; case 110: return {t:220,w:0.693147}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:221,w:0.693147};default: return {t:0,w:0.0};}};
case 90: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 258: return {t:52,w:5.368310}; case 344: return {t:222,w:0.000000};default: return {t:0,w:0.0};}};
case 91: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 258: return {t:52,w:5.368310}; case 344: return {t:223,w:0.000000};default: return {t:0,w:0.0};}};
case 92: return function (act:Int) {switch (act) { case 65: return {t:224,w:0.693147}; case 73: return {t:225,w:0.693147}; case 97: return {t:224,w:0.693147}; case 105: return {t:225,w:0.693147}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:226,w:0.693147};default: return {t:0,w:0.0};}};
case 93: return function (act:Int) {switch (act) { case 82: return {t:227,w:0.693147}; case 114: return {t:227,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 94: return function (act:Int) {switch (act) { case 82: return {t:228,w:0.693147}; case 114: return {t:228,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 95: return function (act:Int) {switch (act) { case 69: return {t:229,w:0.693147}; case 79: return {t:230,w:0.693147}; case 101: return {t:229,w:0.693147}; case 111: return {t:230,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 96: return function (act:Int) {switch (act) { case 69: return {t:231,w:0.693147}; case 85: return {t:232,w:1.386294}; case 101: return {t:231,w:0.693147}; case 117: return {t:232,w:1.386294}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:233,w:0.693147};default: return {t:0,w:0.0};}};
case 97: return function (act:Int) {switch (act) { case 73: return {t:234,w:0.693147}; case 79: return {t:235,w:1.386294}; case 105: return {t:234,w:0.693147}; case 111: return {t:235,w:1.386294}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:236,w:0.693147};default: return {t:0,w:0.0};}};
case 98: return function (act:Int) {switch (act) { case 78: return {t:237,w:0.693147}; case 83: return {t:238,w:0.693147}; case 110: return {t:237,w:0.693147}; case 115: return {t:238,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 99: return function (act:Int) {switch (act) { case 73: return {t:239,w:0.693147}; case 105: return {t:239,w:0.693147}; case 256: return {t:212,w:4000000.000000}; case 258: return {t:52,w:5.368310}; case 344: return {t:240,w:0.000000};default: return {t:0,w:0.0};}};
case 100: return function (act:Int) {switch (act) { case 65: return {t:241,w:0.693147}; case 87: return {t:242,w:0.693147}; case 97: return {t:241,w:0.693147}; case 119: return {t:242,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 101: return function (act:Int) {switch (act) { case 67: return {t:206,w:0.693147}; case 76: return {t:207,w:0.693147}; case 85: return {t:208,w:0.693147}; case 99: return {t:206,w:0.693147}; case 108: return {t:207,w:0.693147}; case 117: return {t:208,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 102: return function (act:Int) {switch (act) { case 65: return {t:209,w:0.693147}; case 79: return {t:210,w:0.693147}; case 83: return {t:211,w:0.693147}; case 97: return {t:209,w:0.693147}; case 111: return {t:210,w:0.693147}; case 115: return {t:211,w:0.693147}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:213,w:0.693147};default: return {t:0,w:0.0};}};
case 103: return function (act:Int) {switch (act) { case 65: return {t:214,w:0.693147}; case 97: return {t:214,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 104: return function (act:Int) {switch (act) { case 82: return {t:215,w:0.693147}; case 88: return {t:216,w:0.693147}; case 114: return {t:215,w:0.693147}; case 120: return {t:216,w:0.693147}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:217,w:0.693147};default: return {t:0,w:0.0};}};
case 105: return function (act:Int) {switch (act) { case 82: return {t:218,w:0.693147}; case 114: return {t:218,w:0.693147}; case 256: return {t:212,w:4000000.000000}; case 258: return {t:52,w:5.368310}; case 344: return {t:219,w:0.000000};default: return {t:0,w:0.0};}};
case 106: return function (act:Int) {switch (act) { case 78: return {t:220,w:0.693147}; case 110: return {t:220,w:0.693147}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:221,w:0.693147};default: return {t:0,w:0.0};}};
case 107: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 258: return {t:52,w:5.368310}; case 344: return {t:222,w:0.000000};default: return {t:0,w:0.0};}};
case 108: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 258: return {t:52,w:5.368310}; case 344: return {t:223,w:0.000000};default: return {t:0,w:0.0};}};
case 109: return function (act:Int) {switch (act) { case 65: return {t:224,w:0.693147}; case 73: return {t:225,w:0.693147}; case 97: return {t:224,w:0.693147}; case 105: return {t:225,w:0.693147}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:226,w:0.693147};default: return {t:0,w:0.0};}};
case 110: return function (act:Int) {switch (act) { case 82: return {t:227,w:0.693147}; case 114: return {t:227,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 111: return function (act:Int) {switch (act) { case 82: return {t:228,w:0.693147}; case 114: return {t:228,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 112: return function (act:Int) {switch (act) { case 69: return {t:229,w:0.693147}; case 79: return {t:230,w:0.693147}; case 101: return {t:229,w:0.693147}; case 111: return {t:230,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 113: return function (act:Int) {switch (act) { case 69: return {t:231,w:0.693147}; case 85: return {t:232,w:1.386294}; case 101: return {t:231,w:0.693147}; case 117: return {t:232,w:1.386294}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:233,w:0.693147};default: return {t:0,w:0.0};}};
case 114: return function (act:Int) {switch (act) { case 73: return {t:234,w:0.693147}; case 79: return {t:235,w:1.386294}; case 105: return {t:234,w:0.693147}; case 111: return {t:235,w:1.386294}; case 256: return {t:212,w:4000000.750000}; case 258: return {t:52,w:6.061457}; case 344: return {t:236,w:0.693147};default: return {t:0,w:0.0};}};
case 115: return function (act:Int) {switch (act) { case 78: return {t:237,w:0.693147}; case 83: return {t:238,w:0.693147}; case 110: return {t:237,w:0.693147}; case 115: return {t:238,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 116: return function (act:Int) {switch (act) { case 73: return {t:239,w:0.693147}; case 105: return {t:239,w:0.693147}; case 256: return {t:212,w:4000000.000000}; case 258: return {t:52,w:5.368310}; case 344: return {t:240,w:0.000000};default: return {t:0,w:0.0};}};
case 117: return function (act:Int) {switch (act) { case 65: return {t:241,w:0.693147}; case 87: return {t:242,w:0.693147}; case 97: return {t:241,w:0.693147}; case 119: return {t:242,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 118: return function (act:Int) {switch (act) { case 258: return {t:243,w:0.000000};default: return {t:0,w:0.0};}};
case 119: return function (act:Int) {switch (act) { case 256: return {t:244,w:4000000.000000}; case 345: return {t:245,w:0.000000};default: return {t:0,w:0.0};}};
case 120: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 121: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 122: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 123: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 124: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 125: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 126: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 127: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 128: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 129: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 130: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 131: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 132: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 133: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 134: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 135: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 136: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 137: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 138: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 139: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 140: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 141: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 142: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 143: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 144: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 145: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 146: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 147: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 148: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 149: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 150: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 151: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 152: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 153: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 154: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 155: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 156: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 157: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 158: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 159: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 160: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 161: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 162: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 163: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 164: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:248,w:0.000000};default: return {t:0,w:0.0};}};
case 165: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:247,w:0.000000};default: return {t:0,w:0.0};}};
case 166: return function (act:Int) {switch (act) { case 0: return {t:249,w:6.238324}; case 1: return {t:249,w:6.238324}; case 2: return {t:249,w:6.238324}; case 3: return {t:249,w:6.238324}; case 4: return {t:249,w:6.238324}; case 5: return {t:249,w:6.238324}; case 6: return {t:249,w:6.238324}; case 7: return {t:249,w:6.238324}; case 8: return {t:249,w:6.238324}; case 9: return {t:249,w:6.238324}; case 10: return {t:249,w:6.238324}; case 11: return {t:249,w:6.238324}; case 12: return {t:249,w:6.238324}; case 13: return {t:249,w:6.238324}; case 14: return {t:249,w:6.238324}; case 15: return {t:249,w:6.238324}; case 16: return {t:249,w:6.238324}; case 17: return {t:249,w:6.238324}; case 18: return {t:249,w:6.238324}; case 19: return {t:249,w:6.238324}; case 20: return {t:249,w:6.238324}; case 21: return {t:249,w:6.238324}; case 22: return {t:249,w:6.238324}; case 23: return {t:249,w:6.238324}; case 24: return {t:249,w:6.238324}; case 25: return {t:249,w:6.238324}; case 26: return {t:249,w:6.238324}; case 27: return {t:249,w:6.238324}; case 28: return {t:249,w:6.238324}; case 29: return {t:249,w:6.238324}; case 30: return {t:249,w:6.238324}; case 31: return {t:249,w:6.238324}; case 32: return {t:249,w:6.238324}; case 33: return {t:249,w:6.238324}; case 34: return {t:249,w:6.238324}; case 35: return {t:249,w:6.238324}; case 36: return {t:249,w:6.238324}; case 37: return {t:249,w:6.238324}; case 38: return {t:249,w:6.238324}; case 39: return {t:249,w:6.238324}; case 40: return {t:249,w:6.238324}; case 41: return {t:249,w:6.238324}; case 42: return {t:249,w:6.238324}; case 43: return {t:249,w:6.238324}; case 44: return {t:249,w:6.238324}; case 45: return {t:249,w:6.238324}; case 46: return {t:249,w:6.238324}; case 47: return {t:249,w:6.238324}; case 48: return {t:249,w:6.238324}; case 49: return {t:249,w:6.238324}; case 50: return {t:249,w:6.238324}; case 51: return {t:249,w:6.238324}; case 52: return {t:249,w:6.238324}; case 53: return {t:249,w:6.238324}; case 54: return {t:249,w:6.238324}; case 55: return {t:249,w:6.238324}; case 56: return {t:249,w:6.238324}; case 57: return {t:249,w:6.238324}; case 58: return {t:249,w:6.238324}; case 59: return {t:249,w:6.238324}; case 60: return {t:249,w:6.238324}; case 61: return {t:249,w:6.238324}; case 62: return {t:249,w:6.238324}; case 63: return {t:249,w:6.238324}; case 64: return {t:249,w:6.238324}; case 65: return {t:249,w:6.238324}; case 66: return {t:249,w:6.238324}; case 67: return {t:249,w:6.238324}; case 68: return {t:249,w:6.238324}; case 69: return {t:249,w:6.238324}; case 70: return {t:249,w:6.238324}; case 71: return {t:249,w:6.238324}; case 72: return {t:249,w:6.238324}; case 73: return {t:249,w:6.238324}; case 74: return {t:249,w:6.238324}; case 75: return {t:249,w:6.238324}; case 76: return {t:249,w:6.238324}; case 77: return {t:249,w:6.238324}; case 78: return {t:249,w:6.238324}; case 79: return {t:249,w:6.238324}; case 80: return {t:249,w:6.238324}; case 81: return {t:249,w:6.238324}; case 82: return {t:249,w:6.238324}; case 83: return {t:249,w:6.238324}; case 84: return {t:249,w:6.238324}; case 85: return {t:249,w:6.238324}; case 86: return {t:249,w:6.238324}; case 87: return {t:249,w:6.238324}; case 88: return {t:249,w:6.238324}; case 89: return {t:249,w:6.238324}; case 90: return {t:249,w:6.238324}; case 91: return {t:249,w:6.238324}; case 92: return {t:249,w:6.238324}; case 93: return {t:249,w:6.238324}; case 94: return {t:249,w:6.238324}; case 95: return {t:249,w:6.238324}; case 96: return {t:249,w:6.238324}; case 97: return {t:249,w:6.238324}; case 98: return {t:249,w:6.238324}; case 99: return {t:249,w:6.238324}; case 100: return {t:249,w:6.238324}; case 101: return {t:249,w:6.238324}; case 102: return {t:249,w:6.238324}; case 103: return {t:249,w:6.238324}; case 104: return {t:249,w:6.238324}; case 105: return {t:249,w:6.238324}; case 106: return {t:249,w:6.238324}; case 107: return {t:249,w:6.238324}; case 108: return {t:249,w:6.238324}; case 109: return {t:249,w:6.238324}; case 110: return {t:249,w:6.238324}; case 111: return {t:249,w:6.238324}; case 112: return {t:249,w:6.238324}; case 113: return {t:249,w:6.238324}; case 114: return {t:249,w:6.238324}; case 115: return {t:249,w:6.238324}; case 116: return {t:249,w:6.238324}; case 117: return {t:249,w:6.238324}; case 118: return {t:249,w:6.238324}; case 119: return {t:249,w:6.238324}; case 120: return {t:249,w:6.238324}; case 121: return {t:249,w:6.238324}; case 122: return {t:249,w:6.238324}; case 123: return {t:249,w:6.238324}; case 124: return {t:249,w:6.238324}; case 125: return {t:249,w:6.238324}; case 126: return {t:249,w:6.238324}; case 127: return {t:249,w:6.238324}; case 128: return {t:249,w:6.238324}; case 129: return {t:249,w:6.238324}; case 130: return {t:249,w:6.238324}; case 131: return {t:249,w:6.238324}; case 132: return {t:249,w:6.238324}; case 133: return {t:249,w:6.238324}; case 134: return {t:249,w:6.238324}; case 135: return {t:249,w:6.238324}; case 136: return {t:249,w:6.238324}; case 137: return {t:249,w:6.238324}; case 138: return {t:249,w:6.238324}; case 139: return {t:249,w:6.238324}; case 140: return {t:249,w:6.238324}; case 141: return {t:249,w:6.238324}; case 142: return {t:249,w:6.238324}; case 143: return {t:249,w:6.238324}; case 144: return {t:249,w:6.238324}; case 145: return {t:249,w:6.238324}; case 146: return {t:249,w:6.238324}; case 147: return {t:249,w:6.238324}; case 148: return {t:249,w:6.238324}; case 149: return {t:249,w:6.238324}; case 150: return {t:249,w:6.238324}; case 151: return {t:249,w:6.238324}; case 152: return {t:249,w:6.238324}; case 153: return {t:249,w:6.238324}; case 154: return {t:249,w:6.238324}; case 155: return {t:249,w:6.238324}; case 156: return {t:249,w:6.238324}; case 157: return {t:249,w:6.238324}; case 158: return {t:249,w:6.238324}; case 159: return {t:249,w:6.238324}; case 160: return {t:249,w:6.238324}; case 161: return {t:249,w:6.238324}; case 162: return {t:249,w:6.238324}; case 163: return {t:249,w:6.238324}; case 164: return {t:249,w:6.238324}; case 165: return {t:249,w:6.238324}; case 166: return {t:249,w:6.238324}; case 167: return {t:249,w:6.238324}; case 168: return {t:249,w:6.238324}; case 169: return {t:249,w:6.238324}; case 170: return {t:249,w:6.238324}; case 171: return {t:249,w:6.238324}; case 172: return {t:249,w:6.238324}; case 173: return {t:249,w:6.238324}; case 174: return {t:249,w:6.238324}; case 175: return {t:249,w:6.238324}; case 176: return {t:249,w:6.238324}; case 177: return {t:249,w:6.238324}; case 178: return {t:249,w:6.238324}; case 179: return {t:249,w:6.238324}; case 180: return {t:249,w:6.238324}; case 181: return {t:249,w:6.238324}; case 182: return {t:249,w:6.238324}; case 183: return {t:249,w:6.238324}; case 184: return {t:249,w:6.238324}; case 185: return {t:249,w:6.238324}; case 186: return {t:249,w:6.238324}; case 187: return {t:249,w:6.238324}; case 188: return {t:249,w:6.238324}; case 189: return {t:249,w:6.238324}; case 190: return {t:249,w:6.238324}; case 191: return {t:249,w:6.238324}; case 192: return {t:249,w:6.238324}; case 193: return {t:249,w:6.238324}; case 194: return {t:249,w:6.238324}; case 195: return {t:249,w:6.238324}; case 196: return {t:249,w:6.238324}; case 197: return {t:249,w:6.238324}; case 198: return {t:249,w:6.238324}; case 199: return {t:249,w:6.238324}; case 200: return {t:249,w:6.238324}; case 201: return {t:249,w:6.238324}; case 202: return {t:249,w:6.238324}; case 203: return {t:249,w:6.238324}; case 204: return {t:249,w:6.238324}; case 205: return {t:249,w:6.238324}; case 206: return {t:249,w:6.238324}; case 207: return {t:249,w:6.238324}; case 208: return {t:249,w:6.238324}; case 209: return {t:249,w:6.238324}; case 210: return {t:249,w:6.238324}; case 211: return {t:249,w:6.238324}; case 212: return {t:249,w:6.238324}; case 213: return {t:249,w:6.238324}; case 214: return {t:249,w:6.238324}; case 215: return {t:249,w:6.238324}; case 216: return {t:249,w:6.238324}; case 217: return {t:249,w:6.238324}; case 218: return {t:249,w:6.238324}; case 219: return {t:249,w:6.238324}; case 220: return {t:249,w:6.238324}; case 221: return {t:249,w:6.238324}; case 222: return {t:249,w:6.238324}; case 223: return {t:249,w:6.238324}; case 224: return {t:249,w:6.238324}; case 225: return {t:249,w:6.238324}; case 226: return {t:249,w:6.238324}; case 227: return {t:249,w:6.238324}; case 228: return {t:249,w:6.238324}; case 229: return {t:249,w:6.238324}; case 230: return {t:249,w:6.238324}; case 231: return {t:249,w:6.238324}; case 232: return {t:249,w:6.238324}; case 233: return {t:249,w:6.238324}; case 234: return {t:249,w:6.238324}; case 235: return {t:249,w:6.238324}; case 236: return {t:249,w:6.238324}; case 237: return {t:249,w:6.238324}; case 238: return {t:249,w:6.238324}; case 239: return {t:249,w:6.238324}; case 240: return {t:249,w:6.238324}; case 241: return {t:249,w:6.238324}; case 242: return {t:249,w:6.238324}; case 243: return {t:249,w:6.238324}; case 244: return {t:249,w:6.238324}; case 245: return {t:249,w:6.238324}; case 246: return {t:249,w:6.238324}; case 247: return {t:249,w:6.238324}; case 248: return {t:249,w:6.238324}; case 249: return {t:249,w:6.238324}; case 250: return {t:249,w:6.238324}; case 251: return {t:249,w:6.238324}; case 252: return {t:249,w:6.238324}; case 253: return {t:249,w:6.238324}; case 254: return {t:249,w:6.238324}; case 255: return {t:249,w:6.238324}; case 258: return {t:250,w:0.693147}; case 346: return {t:251,w:0.693147};default: return {t:0,w:0.0};}};
case 167: return function (act:Int) {switch (act) { case 274: return {t:167,w:0.000000};default: return {t:0,w:0.0};}};
case 168: return function (act:Int) {switch (act) { case 258: return {t:167,w:0.000000};default: return {t:0,w:0.0};}};
case 169: return function (act:Int) {switch (act) { case 276: return {t:169,w:0.000000};default: return {t:0,w:0.0};}};
case 170: return function (act:Int) {switch (act) { case 258: return {t:169,w:0.000000};default: return {t:0,w:0.0};}};
case 171: return function (act:Int) {switch (act) { case 263: return {t:171,w:0.000000};default: return {t:0,w:0.0};}};
case 172: return function (act:Int) {switch (act) { case 265: return {t:172,w:0.000000};default: return {t:0,w:0.0};}};
case 173: return function (act:Int) {switch (act) { case 69: return {t:252,w:0.000000};default: return {t:0,w:0.0};}};
case 174: return function (act:Int) {switch (act) { case 84: return {t:253,w:0.000000};default: return {t:0,w:0.0};}};
case 175: return function (act:Int) {switch (act) { case 79: return {t:254,w:0.000000};default: return {t:0,w:0.0};}};
case 176: return function (act:Int) {switch (act) { case 83: return {t:255,w:0.000000};default: return {t:0,w:0.0};}};
case 177: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:257,w:0.000000};default: return {t:0,w:0.0};}};
case 178: return function (act:Int) {switch (act) { case 278: return {t:178,w:0.000000};default: return {t:0,w:0.0};}};
case 179: return function (act:Int) {switch (act) { case 258: return {t:258,w:0.000000};default: return {t:0,w:0.0};}};
case 180: return function (act:Int) {switch (act) { case 73: return {t:259,w:0.693147}; case 105: return {t:259,w:0.693147}; case 258: return {t:258,w:3.258097};default: return {t:0,w:0.0};}};
case 181: return function (act:Int) {switch (act) { case 258: return {t:258,w:0.000000};default: return {t:0,w:0.0};}};
case 182: return function (act:Int) {switch (act) { case 73: return {t:259,w:0.693147}; case 105: return {t:259,w:0.693147}; case 258: return {t:258,w:3.258097};default: return {t:0,w:0.0};}};
case 183: return function (act:Int) {switch (act) { case 43: return {t:260,w:2.302585}; case 45: return {t:261,w:2.302585}; case 46: return {t:262,w:2.302585}; case 256: return {t:263,w:4000002.250000}; case 258: return {t:264,w:0.693147}; case 331: return {t:265,w:2.302585}; case 336: return {t:266,w:2.302585};default: return {t:0,w:0.0};}};
case 184: return function (act:Int) {switch (act) { case 258: return {t:267,w:0.000000};default: return {t:0,w:0.0};}};
case 185: return function (act:Int) {switch (act) { case 258: return {t:267,w:0.000000};default: return {t:0,w:0.0};}};
case 186: return function (act:Int) {switch (act) { case 58: return {t:268,w:0.000000};default: return {t:0,w:0.0};}};
case 187: return function (act:Int) {switch (act) { case 258: return {t:267,w:0.000000};default: return {t:0,w:0.0};}};
case 188: return function (act:Int) {switch (act) { case 256: return {t:269,w:4000000.000000}; case 272: return {t:270,w:0.000000};default: return {t:0,w:0.0};}};
case 189: return function (act:Int) {switch (act) { case 258: return {t:271,w:0.000000};default: return {t:0,w:0.0};}};
case 190: return function (act:Int) {switch (act) { case 48: return {t:272,w:0.000000}; case 56: return {t:273,w:0.000000}; case 258: return {t:271,w:0.693147};default: return {t:0,w:0.0};}};
case 191: return function (act:Int) {switch (act) { case 48: return {t:274,w:0.000000}; case 258: return {t:271,w:2.302585};default: return {t:0,w:0.0};}};
case 192: return function (act:Int) {switch (act) { case 48: return {t:275,w:0.000000}; case 56: return {t:276,w:0.000000}; case 258: return {t:271,w:0.693147};default: return {t:0,w:0.0};}};
case 193: return function (act:Int) {switch (act) { case 48: return {t:277,w:1.029620}; case 49: return {t:278,w:1.029620}; case 50: return {t:279,w:1.029620}; case 56: return {t:280,w:1.029620}; case 57: return {t:281,w:1.029620}; case 258: return {t:271,w:0.000000};default: return {t:0,w:0.0};}};
case 194: return function (act:Int) {switch (act) { case 48: return {t:282,w:0.000000}; case 49: return {t:283,w:0.000000}; case 258: return {t:271,w:0.356675};default: return {t:0,w:0.0};}};
case 195: return function (act:Int) {switch (act) { case 48: return {t:284,w:0.000000}; case 258: return {t:271,w:0.916291};default: return {t:0,w:0.0};}};
case 196: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:285,w:0.000000};default: return {t:0,w:0.0};}};
case 197: return function (act:Int) {switch (act) { case 258: return {t:286,w:0.000000};default: return {t:0,w:0.0};}};
case 198: return function (act:Int) {switch (act) { case 258: return {t:286,w:0.000000};default: return {t:0,w:0.0};}};
case 199: return function (act:Int) {switch (act) { case 258: return {t:286,w:0.000000};default: return {t:0,w:0.0};}};
case 200: return function (act:Int) {switch (act) { case 258: return {t:286,w:0.000000};default: return {t:0,w:0.0};}};
case 201: return function (act:Int) {switch (act) { case 258: return {t:286,w:0.000000};default: return {t:0,w:0.0};}};
case 202: return function (act:Int) {switch (act) { case 258: return {t:286,w:0.000000};default: return {t:0,w:0.0};}};
case 203: return function (act:Int) {switch (act) { case 258: return {t:286,w:0.000000};default: return {t:0,w:0.0};}};
case 204: return function (act:Int) {switch (act) { case 256: return {t:287,w:4000000.000000}; case 347: return {t:288,w:0.000000};default: return {t:0,w:0.0};}};
case 205: return function (act:Int) {switch (act) { case 283: return {t:205,w:0.000000};default: return {t:0,w:0.0};}};
case 206: return function (act:Int) {switch (act) { case 67: return {t:289,w:0.693147}; case 99: return {t:289,w:0.693147};default: return {t:0,w:0.0};}};
case 207: return function (act:Int) {switch (act) { case 69: return {t:290,w:0.693147}; case 76: return {t:291,w:0.693147}; case 101: return {t:290,w:0.693147}; case 108: return {t:291,w:0.693147};default: return {t:0,w:0.0};}};
case 208: return function (act:Int) {switch (act) { case 84: return {t:292,w:0.693147}; case 116: return {t:292,w:0.693147};default: return {t:0,w:0.0};}};
case 209: return function (act:Int) {switch (act) { case 76: return {t:293,w:0.693147}; case 108: return {t:293,w:0.693147};default: return {t:0,w:0.0};}};
case 210: return function (act:Int) {switch (act) { case 78: return {t:294,w:0.693147}; case 110: return {t:294,w:0.693147};default: return {t:0,w:0.0};}};
case 211: return function (act:Int) {switch (act) { case 69: return {t:295,w:0.693147}; case 101: return {t:295,w:0.693147};default: return {t:0,w:0.0};}};
case 212: return function (act:Int) {switch (act) { case 9: return {t:296,w:1.386294}; case 32: return {t:78,w:1.386294}; case 58: return {t:297,w:0.693147}; case 278: return {t:298,w:1.386294}; case 348: return {t:299,w:1.386294};default: return {t:0,w:0.0};}};
case 213: return function (act:Int) {switch (act) { case 256: return {t:300,w:4000000.000000}; case 349: return {t:301,w:0.000000};default: return {t:0,w:0.0};}};
case 214: return function (act:Int) {switch (act) { case 84: return {t:302,w:0.693147}; case 116: return {t:302,w:0.693147};default: return {t:0,w:0.0};}};
case 215: return function (act:Int) {switch (act) { case 82: return {t:303,w:0.693147}; case 114: return {t:303,w:0.693147};default: return {t:0,w:0.0};}};
case 216: return function (act:Int) {switch (act) { case 80: return {t:304,w:0.693147}; case 112: return {t:304,w:0.693147};default: return {t:0,w:0.0};}};
case 217: return function (act:Int) {switch (act) { case 256: return {t:305,w:4000000.000000}; case 350: return {t:306,w:0.000000};default: return {t:0,w:0.0};}};
case 218: return function (act:Int) {switch (act) { case 79: return {t:307,w:0.693147}; case 111: return {t:307,w:0.693147};default: return {t:0,w:0.0};}};
case 219: return function (act:Int) {switch (act) { case 256: return {t:308,w:4000000.000000}; case 351: return {t:309,w:0.000000};default: return {t:0,w:0.0};}};
case 220: return function (act:Int) {switch (act) { case 45: return {t:310,w:0.000000};default: return {t:0,w:0.0};}};
case 221: return function (act:Int) {switch (act) { case 256: return {t:311,w:4000000.000000}; case 352: return {t:312,w:0.000000};default: return {t:0,w:0.0};}};
case 222: return function (act:Int) {switch (act) { case 256: return {t:313,w:4000000.750000}; case 258: return {t:314,w:0.693147}; case 353: return {t:315,w:0.693147};default: return {t:0,w:0.0};}};
case 223: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:316,w:0.000000};default: return {t:0,w:0.0};}};
case 224: return function (act:Int) {switch (act) { case 88: return {t:317,w:0.693147}; case 120: return {t:317,w:0.693147};default: return {t:0,w:0.0};}};
case 225: return function (act:Int) {switch (act) { case 77: return {t:318,w:0.693147}; case 78: return {t:319,w:0.693147}; case 109: return {t:318,w:0.693147}; case 110: return {t:319,w:0.693147};default: return {t:0,w:0.0};}};
case 226: return function (act:Int) {switch (act) { case 256: return {t:320,w:4000000.750000}; case 354: return {t:321,w:0.693147}; case 355: return {t:322,w:0.693147};default: return {t:0,w:0.0};}};
case 227: return function (act:Int) {switch (act) { case 71: return {t:323,w:0.693147}; case 103: return {t:323,w:0.693147};default: return {t:0,w:0.0};}};
case 228: return function (act:Int) {switch (act) { case 73: return {t:324,w:0.693147}; case 79: return {t:325,w:0.693147}; case 105: return {t:324,w:0.693147}; case 111: return {t:325,w:0.693147};default: return {t:0,w:0.0};}};
case 229: return function (act:Int) {switch (act) { case 67: return {t:326,w:0.693147}; case 80: return {t:327,w:0.693147}; case 81: return {t:328,w:0.693147}; case 84: return {t:329,w:0.693147}; case 99: return {t:326,w:0.693147}; case 112: return {t:327,w:0.693147}; case 113: return {t:328,w:0.693147}; case 116: return {t:329,w:0.693147};default: return {t:0,w:0.0};}};
case 230: return function (act:Int) {switch (act) { case 85: return {t:330,w:0.693147}; case 117: return {t:330,w:0.693147};default: return {t:0,w:0.0};}};
case 231: return function (act:Int) {switch (act) { case 82: return {t:331,w:0.693147}; case 114: return {t:331,w:0.693147};default: return {t:0,w:0.0};}};
case 232: return function (act:Int) {switch (act) { case 66: return {t:332,w:0.693147}; case 80: return {t:333,w:0.693147}; case 98: return {t:332,w:0.693147}; case 112: return {t:333,w:0.693147};default: return {t:0,w:0.0};}};
case 233: return function (act:Int) {switch (act) { case 256: return {t:334,w:4000000.750000}; case 258: return {t:335,w:0.693147}; case 356: return {t:336,w:0.693147};default: return {t:0,w:0.0};}};
case 234: return function (act:Int) {switch (act) { case 77: return {t:337,w:0.693147}; case 109: return {t:337,w:0.693147};default: return {t:0,w:0.0};}};
case 235: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:236,w:0.000000};default: return {t:0,w:0.0};}};
case 236: return function (act:Int) {switch (act) { case 256: return {t:338,w:4000000.750000}; case 357: return {t:339,w:0.693147}; case 358: return {t:340,w:0.693147};default: return {t:0,w:0.0};}};
case 237: return function (act:Int) {switch (act) { case 83: return {t:341,w:0.693147}; case 115: return {t:341,w:0.693147};default: return {t:0,w:0.0};}};
case 238: return function (act:Int) {switch (act) { case 69: return {t:342,w:0.693147}; case 101: return {t:342,w:0.693147};default: return {t:0,w:0.0};}};
case 239: return function (act:Int) {switch (act) { case 65: return {t:343,w:0.693147}; case 97: return {t:343,w:0.693147};default: return {t:0,w:0.0};}};
case 240: return function (act:Int) {switch (act) { case 256: return {t:344,w:4000000.000000}; case 359: return {t:345,w:0.000000};default: return {t:0,w:0.0};}};
case 241: return function (act:Int) {switch (act) { case 82: return {t:346,w:0.693147}; case 114: return {t:346,w:0.693147};default: return {t:0,w:0.0};}};
case 242: return function (act:Int) {switch (act) { case 87: return {t:347,w:0.693147}; case 119: return {t:347,w:0.693147};default: return {t:0,w:0.0};}};
case 243: return function (act:Int) {switch (act) { case 328: return {t:243,w:0.000000};default: return {t:0,w:0.0};}};
case 244: return function (act:Int) {switch (act) { case 10: return {t:348,w:0.000000};default: return {t:0,w:0.0};}};
case 245: return function (act:Int) {switch (act) { case 258: return {t:349,w:0.000000};default: return {t:0,w:0.0};}};
case 246: return function (act:Int) {switch (act) { case 13: return {t:83,w:0.000000}; case 283: return {t:119,w:0.000000};default: return {t:0,w:0.0};}};
case 247: return function (act:Int) {switch (act) { case 258: return {t:350,w:0.000000};default: return {t:0,w:0.0};}};
case 248: return function (act:Int) {switch (act) { case 256: return {t:351,w:4000000.000000}; case 360: return {t:352,w:0.000000};default: return {t:0,w:0.0};}};
case 249: return function (act:Int) {switch (act) { case 258: return {t:353,w:0.000000};default: return {t:0,w:0.0};}};
case 250: return function (act:Int) {switch (act) { case 330: return {t:250,w:0.000000};default: return {t:0,w:0.0};}};
case 251: return function (act:Int) {switch (act) { case 256: return {t:354,w:4000000.750000}; case 258: return {t:355,w:0.693147}; case 346: return {t:356,w:0.693147};default: return {t:0,w:0.0};}};
case 252: return function (act:Int) {switch (act) { case 76: return {t:357,w:0.000000};default: return {t:0,w:0.0};}};
case 253: return function (act:Int) {switch (act) { case 69: return {t:358,w:0.000000};default: return {t:0,w:0.0};}};
case 254: return function (act:Int) {switch (act) { case 78: return {t:359,w:0.000000};default: return {t:0,w:0.0};}};
case 255: return function (act:Int) {switch (act) { case 84: return {t:360,w:0.000000};default: return {t:0,w:0.0};}};
case 256: return function (act:Int) {switch (act) { case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585};default: return {t:0,w:0.0};}};
case 257: return function (act:Int) {switch (act) { case 46: return {t:361,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:362,w:0.693147};default: return {t:0,w:0.0};}};
case 258: return function (act:Int) {switch (act) { case 331: return {t:258,w:0.000000};default: return {t:0,w:0.0};}};
case 259: return function (act:Int) {switch (act) { case 80: return {t:363,w:0.693147}; case 112: return {t:363,w:0.693147};default: return {t:0,w:0.0};}};
case 260: return function (act:Int) {switch (act) { case 43: return {t:260,w:2.302585}; case 45: return {t:261,w:2.302585}; case 46: return {t:262,w:2.302585}; case 256: return {t:263,w:4000002.250000}; case 258: return {t:264,w:0.693147}; case 331: return {t:265,w:2.302585}; case 336: return {t:266,w:2.302585};default: return {t:0,w:0.0};}};
case 261: return function (act:Int) {switch (act) { case 43: return {t:260,w:2.302585}; case 45: return {t:261,w:2.302585}; case 46: return {t:262,w:2.302585}; case 256: return {t:263,w:4000002.250000}; case 258: return {t:264,w:0.693147}; case 331: return {t:265,w:2.302585}; case 336: return {t:266,w:2.302585};default: return {t:0,w:0.0};}};
case 262: return function (act:Int) {switch (act) { case 43: return {t:260,w:2.302585}; case 45: return {t:261,w:2.302585}; case 46: return {t:262,w:2.302585}; case 256: return {t:263,w:4000002.250000}; case 258: return {t:264,w:0.693147}; case 331: return {t:265,w:2.302585}; case 336: return {t:266,w:2.302585};default: return {t:0,w:0.0};}};
case 263: return function (act:Int) {switch (act) { case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 65: return {t:179,w:3.951244}; case 66: return {t:179,w:3.951244}; case 67: return {t:179,w:3.951244}; case 68: return {t:179,w:3.951244}; case 69: return {t:179,w:3.951244}; case 70: return {t:179,w:3.951244}; case 71: return {t:179,w:3.951244}; case 72: return {t:179,w:3.951244}; case 73: return {t:179,w:3.951244}; case 74: return {t:179,w:3.951244}; case 75: return {t:179,w:3.951244}; case 76: return {t:179,w:3.951244}; case 77: return {t:179,w:3.951244}; case 78: return {t:179,w:3.951244}; case 79: return {t:179,w:3.951244}; case 80: return {t:179,w:3.951244}; case 81: return {t:179,w:3.951244}; case 82: return {t:179,w:3.951244}; case 83: return {t:179,w:3.951244}; case 84: return {t:179,w:3.951244}; case 85: return {t:179,w:3.951244}; case 86: return {t:179,w:3.951244}; case 87: return {t:179,w:3.951244}; case 88: return {t:179,w:3.951244}; case 89: return {t:179,w:3.951244}; case 90: return {t:179,w:3.951244}; case 97: return {t:181,w:3.951244}; case 98: return {t:181,w:3.951244}; case 99: return {t:181,w:3.951244}; case 100: return {t:181,w:3.951244}; case 101: return {t:181,w:3.951244}; case 102: return {t:181,w:3.951244}; case 103: return {t:181,w:3.951244}; case 104: return {t:181,w:3.951244}; case 105: return {t:181,w:3.951244}; case 106: return {t:181,w:3.951244}; case 107: return {t:181,w:3.951244}; case 108: return {t:181,w:3.951244}; case 109: return {t:181,w:3.951244}; case 110: return {t:181,w:3.951244}; case 111: return {t:181,w:3.951244}; case 112: return {t:181,w:3.951244}; case 113: return {t:181,w:3.951244}; case 114: return {t:181,w:3.951244}; case 115: return {t:181,w:3.951244}; case 116: return {t:181,w:3.951244}; case 117: return {t:181,w:3.951244}; case 118: return {t:181,w:3.951244}; case 119: return {t:181,w:3.951244}; case 120: return {t:181,w:3.951244}; case 121: return {t:181,w:3.951244}; case 122: return {t:181,w:3.951244};default: return {t:0,w:0.0};}};
case 264: return function (act:Int) {switch (act) { case 334: return {t:264,w:0.000000};default: return {t:0,w:0.0};}};
case 265: return function (act:Int) {switch (act) { case 43: return {t:260,w:2.302585}; case 45: return {t:261,w:2.302585}; case 46: return {t:262,w:2.302585}; case 256: return {t:263,w:4000002.250000}; case 258: return {t:264,w:0.693147}; case 331: return {t:265,w:2.302585}; case 336: return {t:266,w:2.302585};default: return {t:0,w:0.0};}};
case 266: return function (act:Int) {switch (act) { case 43: return {t:260,w:2.302585}; case 45: return {t:261,w:2.302585}; case 46: return {t:262,w:2.302585}; case 256: return {t:263,w:4000002.250000}; case 258: return {t:264,w:0.693147}; case 331: return {t:265,w:2.302585}; case 336: return {t:266,w:2.302585};default: return {t:0,w:0.0};}};
case 267: return function (act:Int) {switch (act) { case 281: return {t:267,w:0.000000};default: return {t:0,w:0.0};}};
case 268: return function (act:Int) {switch (act) { case 256: return {t:364,w:4000000.750000}; case 361: return {t:365,w:0.693147}; case 362: return {t:366,w:0.693147};default: return {t:0,w:0.0};}};
case 269: return function (act:Int) {switch (act) { case 83: return {t:367,w:0.693147}; case 115: return {t:367,w:0.693147};default: return {t:0,w:0.0};}};
case 270: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:368,w:0.000000};default: return {t:0,w:0.0};}};
case 271: return function (act:Int) {switch (act) { case 336: return {t:271,w:0.000000};default: return {t:0,w:0.0};}};
case 272: return function (act:Int) {switch (act) { case 48: return {t:369,w:0.000000};default: return {t:0,w:0.0};}};
case 273: return function (act:Int) {switch (act) { case 48: return {t:370,w:0.000000}; case 49: return {t:371,w:0.000000}; case 50: return {t:372,w:0.000000}; case 51: return {t:373,w:0.000000};default: return {t:0,w:0.0};}};
case 274: return function (act:Int) {switch (act) { case 48: return {t:374,w:0.000000};default: return {t:0,w:0.0};}};
case 275: return function (act:Int) {switch (act) { case 48: return {t:375,w:0.000000}; case 49: return {t:376,w:0.000000}; case 50: return {t:377,w:0.000000}; case 53: return {t:378,w:0.000000};default: return {t:0,w:0.0};}};
case 276: return function (act:Int) {switch (act) { case 48: return {t:379,w:0.000000};default: return {t:0,w:0.0};}};
case 277: return function (act:Int) {switch (act) { case 48: return {t:380,w:0.000000}; case 49: return {t:381,w:0.000000}; case 50: return {t:382,w:0.000000}; case 51: return {t:383,w:0.000000}; case 52: return {t:384,w:0.000000}; case 53: return {t:385,w:0.000000}; case 54: return {t:386,w:0.000000}; case 55: return {t:387,w:0.000000}; case 56: return {t:388,w:0.000000};default: return {t:0,w:0.0};}};
case 278: return function (act:Int) {switch (act) { case 48: return {t:389,w:0.000000}; case 51: return {t:390,w:0.000000}; case 52: return {t:391,w:0.000000}; case 53: return {t:392,w:0.000000}; case 54: return {t:393,w:0.000000};default: return {t:0,w:0.0};}};
case 279: return function (act:Int) {switch (act) { case 48: return {t:394,w:0.000000}; case 49: return {t:395,w:0.000000}; case 51: return {t:396,w:0.000000};default: return {t:0,w:0.0};}};
case 280: return function (act:Int) {switch (act) { case 48: return {t:397,w:0.000000}; case 49: return {t:398,w:0.000000}; case 50: return {t:399,w:0.000000}; case 51: return {t:400,w:0.000000}; case 52: return {t:401,w:0.000000}; case 53: return {t:402,w:0.000000}; case 54: return {t:403,w:0.000000}; case 55: return {t:404,w:0.000000}; case 56: return {t:405,w:0.000000};default: return {t:0,w:0.0};}};
case 281: return function (act:Int) {switch (act) { case 49: return {t:406,w:0.000000}; case 51: return {t:407,w:0.000000};default: return {t:0,w:0.0};}};
case 282: return function (act:Int) {switch (act) { case 48: return {t:408,w:0.000000}; case 49: return {t:409,w:0.000000}; case 50: return {t:410,w:0.000000}; case 51: return {t:411,w:0.000000}; case 52: return {t:412,w:0.000000}; case 53: return {t:413,w:0.000000};default: return {t:0,w:0.0};}};
case 283: return function (act:Int) {switch (act) { case 51: return {t:414,w:0.000000};default: return {t:0,w:0.0};}};
case 284: return function (act:Int) {switch (act) { case 48: return {t:415,w:0.000000}; case 51: return {t:416,w:0.000000}; case 52: return {t:417,w:0.000000}; case 54: return {t:418,w:0.000000};default: return {t:0,w:0.0};}};
case 285: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:419,w:0.000000};default: return {t:0,w:0.0};}};
case 286: return function (act:Int) {switch (act) { case 282: return {t:286,w:0.000000};default: return {t:0,w:0.0};}};
case 287: return function (act:Int) {switch (act) { case 9: return {t:296,w:2.639057}; case 32: return {t:78,w:2.639057}; case 33: return {t:420,w:4.718499}; case 36: return {t:421,w:4.584967}; case 37: return {t:422,w:2.639057}; case 38: return {t:423,w:4.584967}; case 39: return {t:424,w:6.104793}; case 40: return {t:424,w:6.104793}; case 41: return {t:424,w:6.104793}; case 42: return {t:424,w:6.104793}; case 43: return {t:425,w:5.278114}; case 44: return {t:425,w:5.278114}; case 45: return {t:426,w:5.411646}; case 46: return {t:426,w:5.411646}; case 47: return {t:427,w:4.584967}; case 48: return {t:428,w:7.021084}; case 49: return {t:428,w:7.021084}; case 50: return {t:428,w:7.021084}; case 51: return {t:428,w:7.021084}; case 52: return {t:428,w:7.021084}; case 53: return {t:428,w:7.021084}; case 54: return {t:428,w:7.021084}; case 55: return {t:428,w:7.021084}; case 56: return {t:428,w:7.021084}; case 57: return {t:428,w:7.021084}; case 58: return {t:429,w:5.278114}; case 59: return {t:429,w:5.278114}; case 61: return {t:430,w:4.584967}; case 63: return {t:431,w:5.278114}; case 64: return {t:431,w:5.278114}; case 65: return {t:432,w:7.976596}; case 66: return {t:432,w:7.976596}; case 67: return {t:432,w:7.976596}; case 68: return {t:432,w:7.976596}; case 69: return {t:432,w:7.976596}; case 70: return {t:432,w:7.976596}; case 71: return {t:432,w:7.976596}; case 72: return {t:432,w:7.976596}; case 73: return {t:432,w:7.976596}; case 74: return {t:432,w:7.976596}; case 75: return {t:432,w:7.976596}; case 76: return {t:432,w:7.976596}; case 77: return {t:432,w:7.976596}; case 78: return {t:432,w:7.976596}; case 79: return {t:432,w:7.976596}; case 80: return {t:432,w:7.976596}; case 81: return {t:432,w:7.976596}; case 82: return {t:432,w:7.976596}; case 83: return {t:432,w:7.976596}; case 84: return {t:432,w:7.976596}; case 85: return {t:432,w:7.976596}; case 86: return {t:432,w:7.976596}; case 87: return {t:432,w:7.976596}; case 88: return {t:432,w:7.976596}; case 89: return {t:432,w:7.976596}; case 90: return {t:432,w:7.976596}; case 95: return {t:433,w:4.718499}; case 97: return {t:434,w:7.976596}; case 98: return {t:434,w:7.976596}; case 99: return {t:434,w:7.976596}; case 100: return {t:434,w:7.976596}; case 101: return {t:434,w:7.976596}; case 102: return {t:434,w:7.976596}; case 103: return {t:434,w:7.976596}; case 104: return {t:434,w:7.976596}; case 105: return {t:434,w:7.976596}; case 106: return {t:434,w:7.976596}; case 107: return {t:434,w:7.976596}; case 108: return {t:434,w:7.976596}; case 109: return {t:434,w:7.976596}; case 110: return {t:434,w:7.976596}; case 111: return {t:434,w:7.976596}; case 112: return {t:434,w:7.976596}; case 113: return {t:434,w:7.976596}; case 114: return {t:434,w:7.976596}; case 115: return {t:434,w:7.976596}; case 116: return {t:434,w:7.976596}; case 117: return {t:434,w:7.976596}; case 118: return {t:434,w:7.976596}; case 119: return {t:434,w:7.976596}; case 120: return {t:434,w:7.976596}; case 121: return {t:434,w:7.976596}; case 122: return {t:434,w:7.976596}; case 126: return {t:435,w:4.718499}; case 128: return {t:436,w:6.797940}; case 129: return {t:436,w:6.797940}; case 130: return {t:436,w:6.797940}; case 131: return {t:436,w:6.797940}; case 132: return {t:436,w:6.797940}; case 133: return {t:436,w:6.797940}; case 134: return {t:436,w:6.797940}; case 135: return {t:436,w:6.797940}; case 136: return {t:436,w:6.797940}; case 137: return {t:436,w:6.797940}; case 138: return {t:436,w:6.797940}; case 139: return {t:436,w:6.797940}; case 140: return {t:436,w:6.797940}; case 141: return {t:436,w:6.797940}; case 142: return {t:436,w:6.797940}; case 143: return {t:436,w:6.797940}; case 144: return {t:436,w:6.797940}; case 145: return {t:436,w:6.797940}; case 146: return {t:436,w:6.797940}; case 147: return {t:436,w:6.797940}; case 148: return {t:436,w:6.797940}; case 149: return {t:436,w:6.797940}; case 150: return {t:436,w:6.797940}; case 151: return {t:436,w:6.797940}; case 152: return {t:436,w:6.797940}; case 153: return {t:436,w:6.797940}; case 154: return {t:436,w:6.797940}; case 155: return {t:436,w:6.797940}; case 156: return {t:436,w:6.797940}; case 157: return {t:436,w:6.797940}; case 158: return {t:436,w:6.797940}; case 159: return {t:436,w:6.797940}; case 160: return {t:436,w:6.797940}; case 161: return {t:436,w:6.797940}; case 162: return {t:436,w:6.797940}; case 163: return {t:436,w:6.797940}; case 164: return {t:436,w:6.797940}; case 165: return {t:436,w:6.797940}; case 166: return {t:436,w:6.797940}; case 167: return {t:436,w:6.797940}; case 168: return {t:436,w:6.797940}; case 169: return {t:436,w:6.797940}; case 170: return {t:436,w:6.797940}; case 171: return {t:436,w:6.797940}; case 172: return {t:436,w:6.797940}; case 173: return {t:436,w:6.797940}; case 174: return {t:436,w:6.797940}; case 175: return {t:436,w:6.797940}; case 176: return {t:436,w:6.797940}; case 177: return {t:436,w:6.797940}; case 178: return {t:436,w:6.797940}; case 179: return {t:436,w:6.797940}; case 180: return {t:436,w:6.797940}; case 181: return {t:436,w:6.797940}; case 182: return {t:436,w:6.797940}; case 183: return {t:436,w:6.797940}; case 184: return {t:436,w:6.797940}; case 185: return {t:436,w:6.797940}; case 186: return {t:436,w:6.797940}; case 187: return {t:436,w:6.797940}; case 188: return {t:436,w:6.797940}; case 189: return {t:436,w:6.797940}; case 190: return {t:436,w:6.797940}; case 191: return {t:436,w:6.797940}; case 192: return {t:437,w:7.714231}; case 193: return {t:437,w:7.714231}; case 194: return {t:437,w:7.714231}; case 195: return {t:437,w:7.714231}; case 196: return {t:437,w:7.714231}; case 197: return {t:437,w:7.714231}; case 198: return {t:437,w:7.714231}; case 199: return {t:437,w:7.714231}; case 200: return {t:437,w:7.714231}; case 201: return {t:437,w:7.714231}; case 202: return {t:437,w:7.714231}; case 203: return {t:437,w:7.714231}; case 204: return {t:437,w:7.714231}; case 205: return {t:437,w:7.714231}; case 206: return {t:437,w:7.714231}; case 207: return {t:437,w:7.714231}; case 208: return {t:437,w:7.714231}; case 209: return {t:437,w:7.714231}; case 210: return {t:437,w:7.714231}; case 211: return {t:437,w:7.714231}; case 212: return {t:437,w:7.714231}; case 213: return {t:437,w:7.714231}; case 214: return {t:437,w:7.714231}; case 215: return {t:437,w:7.714231}; case 216: return {t:437,w:7.714231}; case 217: return {t:437,w:7.714231}; case 218: return {t:437,w:7.714231}; case 219: return {t:437,w:7.714231}; case 220: return {t:437,w:7.714231}; case 221: return {t:437,w:7.714231}; case 222: return {t:437,w:7.714231}; case 223: return {t:437,w:7.714231}; case 224: return {t:438,w:7.021084}; case 225: return {t:438,w:7.021084}; case 226: return {t:438,w:7.021084}; case 227: return {t:438,w:7.021084}; case 228: return {t:438,w:7.021084}; case 229: return {t:438,w:7.021084}; case 230: return {t:438,w:7.021084}; case 231: return {t:438,w:7.021084}; case 232: return {t:438,w:7.021084}; case 233: return {t:438,w:7.021084}; case 234: return {t:438,w:7.021084}; case 235: return {t:438,w:7.021084}; case 236: return {t:438,w:7.021084}; case 237: return {t:438,w:7.021084}; case 238: return {t:438,w:7.021084}; case 239: return {t:438,w:7.021084}; case 240: return {t:439,w:6.327937}; case 241: return {t:439,w:6.327937}; case 242: return {t:439,w:6.327937}; case 243: return {t:439,w:6.327937}; case 244: return {t:439,w:6.327937}; case 245: return {t:439,w:6.327937}; case 246: return {t:439,w:6.327937}; case 247: return {t:439,w:6.327937}; case 248: return {t:440,w:5.634789}; case 249: return {t:440,w:5.634789}; case 250: return {t:440,w:5.634789}; case 251: return {t:440,w:5.634789}; case 252: return {t:441,w:4.941642}; case 253: return {t:441,w:4.941642}; case 258: return {t:442,w:0.693147}; case 278: return {t:443,w:2.639057}; case 348: return {t:447,w:2.639057}; case 363: return {t:444,w:2.639057}; case 364: return {t:445,w:2.639057}; case 365: return {t:446,w:2.639057}; case 366: return {t:448,w:2.639057}; case 367: return {t:449,w:2.639057};default: return {t:0,w:0.0};}};
case 288: return function (act:Int) {switch (act) { case 256: return {t:246,w:4000000.000000}; case 279: return {t:450,w:0.000000};default: return {t:0,w:0.0};}};
case 289: return function (act:Int) {switch (act) { case 69: return {t:451,w:0.693147}; case 101: return {t:451,w:0.693147};default: return {t:0,w:0.0};}};
case 290: return function (act:Int) {switch (act) { case 82: return {t:452,w:0.693147}; case 114: return {t:452,w:0.693147};default: return {t:0,w:0.0};}};
case 291: return function (act:Int) {switch (act) { case 79: return {t:453,w:0.693147}; case 111: return {t:453,w:0.693147};default: return {t:0,w:0.0};}};
case 292: return function (act:Int) {switch (act) { case 72: return {t:454,w:0.693147}; case 104: return {t:454,w:0.693147};default: return {t:0,w:0.0};}};
case 293: return function (act:Int) {switch (act) { case 76: return {t:455,w:0.693147}; case 108: return {t:455,w:0.693147};default: return {t:0,w:0.0};}};
case 294: return function (act:Int) {switch (act) { case 84: return {t:456,w:0.693147}; case 116: return {t:456,w:0.693147};default: return {t:0,w:0.0};}};
case 295: return function (act:Int) {switch (act) { case 81: return {t:457,w:0.693147}; case 113: return {t:457,w:0.693147};default: return {t:0,w:0.0};}};
case 296: return function (act:Int) {switch (act) { case 258: return {t:458,w:0.000000};default: return {t:0,w:0.0};}};
case 297: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:460,w:0.000000};default: return {t:0,w:0.0};}};
case 298: return function (act:Int) {switch (act) { case 58: return {t:461,w:0.693147}; case 256: return {t:462,w:4000001.500000}; case 278: return {t:463,w:1.386294}; case 348: return {t:464,w:1.386294};default: return {t:0,w:0.0};}};
case 299: return function (act:Int) {switch (act) { case 58: return {t:461,w:0.693147}; case 256: return {t:462,w:4000001.500000}; case 278: return {t:463,w:1.386294}; case 348: return {t:464,w:1.386294};default: return {t:0,w:0.0};}};
case 300: return function (act:Int) {switch (act) { case 33: return {t:2,w:4.882801}; case 37: return {t:3,w:4.882801}; case 39: return {t:4,w:4.882801}; case 42: return {t:5,w:4.882801}; case 43: return {t:6,w:4.882801}; case 45: return {t:7,w:4.882801}; case 46: return {t:8,w:4.882801}; case 48: return {t:9,w:8.283998}; case 49: return {t:9,w:8.283998}; case 50: return {t:9,w:8.283998}; case 51: return {t:9,w:8.283998}; case 52: return {t:9,w:8.283998}; case 53: return {t:9,w:8.283998}; case 54: return {t:9,w:8.283998}; case 55: return {t:9,w:8.283998}; case 56: return {t:9,w:8.283998}; case 57: return {t:9,w:8.283998}; case 65: return {t:465,w:3.178053}; case 66: return {t:13,w:9.239511}; case 67: return {t:13,w:9.239511}; case 68: return {t:13,w:9.239511}; case 69: return {t:13,w:9.239511}; case 70: return {t:13,w:9.239511}; case 71: return {t:13,w:9.239511}; case 72: return {t:13,w:9.239511}; case 73: return {t:466,w:3.178053}; case 74: return {t:13,w:9.239511}; case 75: return {t:13,w:9.239511}; case 76: return {t:13,w:9.239511}; case 77: return {t:467,w:2.484906}; case 78: return {t:13,w:9.239511}; case 79: return {t:13,w:9.239511}; case 80: return {t:13,w:9.239511}; case 81: return {t:13,w:9.239511}; case 82: return {t:13,w:9.239511}; case 83: return {t:13,w:9.239511}; case 84: return {t:468,w:3.178053}; case 85: return {t:13,w:9.239511}; case 86: return {t:469,w:3.178053}; case 87: return {t:13,w:9.239511}; case 88: return {t:470,w:3.178053}; case 89: return {t:13,w:9.239511}; case 90: return {t:13,w:9.239511}; case 95: return {t:18,w:4.882801}; case 96: return {t:19,w:4.882801}; case 97: return {t:471,w:3.178053}; case 98: return {t:20,w:9.239511}; case 99: return {t:20,w:9.239511}; case 100: return {t:20,w:9.239511}; case 101: return {t:20,w:9.239511}; case 102: return {t:20,w:9.239511}; case 103: return {t:20,w:9.239511}; case 104: return {t:20,w:9.239511}; case 105: return {t:472,w:3.178053}; case 106: return {t:20,w:9.239511}; case 107: return {t:20,w:9.239511}; case 108: return {t:20,w:9.239511}; case 109: return {t:473,w:2.484906}; case 110: return {t:20,w:9.239511}; case 111: return {t:20,w:9.239511}; case 112: return {t:20,w:9.239511}; case 113: return {t:20,w:9.239511}; case 114: return {t:20,w:9.239511}; case 115: return {t:20,w:9.239511}; case 116: return {t:474,w:3.178053}; case 117: return {t:20,w:9.239511}; case 118: return {t:475,w:3.178053}; case 119: return {t:20,w:9.239511}; case 120: return {t:476,w:3.178053}; case 121: return {t:20,w:9.239511}; case 122: return {t:20,w:9.239511}; case 126: return {t:22,w:4.882801}; case 268: return {t:29,w:4.882801}; case 269: return {t:477,w:2.484906}; case 369: return {t:478,w:2.484906}; case 370: return {t:479,w:2.484906}; case 371: return {t:480,w:1.791759}; case 372: return {t:481,w:0.693147}; case 373: return {t:482,w:0.693147}; case 374: return {t:483,w:0.000000};default: return {t:0,w:0.0};}};
case 301: return function (act:Int) {switch (act) { case 258: return {t:484,w:0.000000};default: return {t:0,w:0.0};}};
case 302: return function (act:Int) {switch (act) { case 69: return {t:485,w:0.693147}; case 101: return {t:485,w:0.693147};default: return {t:0,w:0.0};}};
case 303: return function (act:Int) {switch (act) { case 79: return {t:486,w:0.693147}; case 111: return {t:486,w:0.693147};default: return {t:0,w:0.0};}};
case 304: return function (act:Int) {switch (act) { case 73: return {t:487,w:0.693147}; case 105: return {t:487,w:0.693147};default: return {t:0,w:0.0};}};
case 305: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:488,w:0.000000};default: return {t:0,w:0.0};}};
case 306: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:490,w:0.693147}; case 375: return {t:491,w:0.693147};default: return {t:0,w:0.0};}};
case 307: return function (act:Int) {switch (act) { case 77: return {t:492,w:0.693147}; case 109: return {t:492,w:0.693147};default: return {t:0,w:0.0};}};
case 308: return function (act:Int) {switch (act) { case 9: return {t:493,w:3.465735}; case 13: return {t:83,w:3.465735}; case 32: return {t:494,w:3.465735}; case 33: return {t:2,w:5.170483}; case 37: return {t:3,w:5.170483}; case 39: return {t:4,w:5.170483}; case 42: return {t:5,w:5.170483}; case 43: return {t:6,w:5.170483}; case 45: return {t:7,w:5.170483}; case 46: return {t:8,w:5.170483}; case 48: return {t:9,w:8.571681}; case 49: return {t:9,w:8.571681}; case 50: return {t:9,w:8.571681}; case 51: return {t:9,w:8.571681}; case 52: return {t:9,w:8.571681}; case 53: return {t:9,w:8.571681}; case 54: return {t:9,w:8.571681}; case 55: return {t:9,w:8.571681}; case 56: return {t:9,w:8.571681}; case 57: return {t:9,w:8.571681}; case 65: return {t:495,w:5.743003}; case 66: return {t:495,w:5.743003}; case 67: return {t:495,w:5.743003}; case 68: return {t:495,w:5.743003}; case 69: return {t:495,w:5.743003}; case 70: return {t:495,w:5.743003}; case 71: return {t:495,w:5.743003}; case 72: return {t:495,w:5.743003}; case 73: return {t:495,w:5.743003}; case 74: return {t:495,w:5.743003}; case 75: return {t:495,w:5.743003}; case 76: return {t:495,w:5.743003}; case 77: return {t:495,w:5.743003}; case 78: return {t:495,w:5.743003}; case 79: return {t:495,w:5.743003}; case 80: return {t:495,w:5.743003}; case 81: return {t:495,w:5.743003}; case 82: return {t:495,w:5.743003}; case 83: return {t:496,w:2.484906}; case 84: return {t:495,w:5.743003}; case 85: return {t:495,w:5.743003}; case 86: return {t:495,w:5.743003}; case 87: return {t:495,w:5.743003}; case 88: return {t:495,w:5.743003}; case 89: return {t:495,w:5.743003}; case 90: return {t:495,w:5.743003}; case 95: return {t:18,w:5.170483}; case 96: return {t:19,w:5.170483}; case 97: return {t:497,w:5.743003}; case 98: return {t:497,w:5.743003}; case 99: return {t:497,w:5.743003}; case 100: return {t:497,w:5.743003}; case 101: return {t:497,w:5.743003}; case 102: return {t:497,w:5.743003}; case 103: return {t:497,w:5.743003}; case 104: return {t:497,w:5.743003}; case 105: return {t:497,w:5.743003}; case 106: return {t:497,w:5.743003}; case 107: return {t:497,w:5.743003}; case 108: return {t:497,w:5.743003}; case 109: return {t:497,w:5.743003}; case 110: return {t:497,w:5.743003}; case 111: return {t:497,w:5.743003}; case 112: return {t:497,w:5.743003}; case 113: return {t:497,w:5.743003}; case 114: return {t:497,w:5.743003}; case 115: return {t:498,w:2.484906}; case 116: return {t:497,w:5.743003}; case 117: return {t:497,w:5.743003}; case 118: return {t:497,w:5.743003}; case 119: return {t:497,w:5.743003}; case 120: return {t:497,w:5.743003}; case 121: return {t:497,w:5.743003}; case 122: return {t:497,w:5.743003}; case 126: return {t:22,w:5.170483}; case 258: return {t:499,w:2.079441}; case 268: return {t:29,w:5.170483}; case 269: return {t:500,w:2.772588}; case 279: return {t:504,w:3.465735}; case 283: return {t:119,w:3.465735}; case 331: return {t:183,w:1.791759}; case 332: return {t:501,w:1.791759}; case 333: return {t:502,w:1.791759}; case 334: return {t:186,w:1.791759}; case 335: return {t:503,w:1.791759}; case 357: return {t:511,w:0.693147}; case 358: return {t:512,w:0.693147}; case 368: return {t:507,w:1.386294}; case 376: return {t:505,w:2.772588}; case 377: return {t:506,w:2.079441}; case 378: return {t:508,w:2.079441}; case 379: return {t:509,w:1.386294}; case 380: return {t:510,w:1.386294};default: return {t:0,w:0.0};}};
case 309: return function (act:Int) {switch (act) { case 258: return {t:513,w:0.000000};default: return {t:0,w:0.0};}};
case 310: return function (act:Int) {switch (act) { case 82: return {t:514,w:0.693147}; case 114: return {t:514,w:0.693147};default: return {t:0,w:0.0};}};
case 311: return function (act:Int) {switch (act) { case 33: return {t:515,w:3.178054}; case 34: return {t:516,w:3.178054}; case 37: return {t:517,w:3.178054}; case 39: return {t:518,w:3.178054}; case 40: return {t:519,w:3.178054}; case 41: return {t:520,w:3.178054}; case 42: return {t:521,w:3.178054}; case 43: return {t:522,w:3.178054}; case 45: return {t:523,w:3.178054}; case 46: return {t:524,w:3.178054}; case 47: return {t:525,w:3.178054}; case 48: return {t:9,w:6.579251}; case 49: return {t:9,w:6.579251}; case 50: return {t:9,w:6.579251}; case 51: return {t:9,w:6.579251}; case 52: return {t:9,w:6.579251}; case 53: return {t:9,w:6.579251}; case 54: return {t:9,w:6.579251}; case 55: return {t:9,w:6.579251}; case 56: return {t:9,w:6.579251}; case 57: return {t:9,w:6.579251}; case 58: return {t:526,w:3.178054}; case 60: return {t:527,w:3.178054}; case 62: return {t:528,w:3.178054}; case 63: return {t:529,w:3.178054}; case 65: return {t:13,w:7.534763}; case 66: return {t:13,w:7.534763}; case 67: return {t:13,w:7.534763}; case 68: return {t:13,w:7.534763}; case 69: return {t:13,w:7.534763}; case 70: return {t:13,w:7.534763}; case 71: return {t:13,w:7.534763}; case 72: return {t:13,w:7.534763}; case 73: return {t:13,w:7.534763}; case 74: return {t:13,w:7.534763}; case 75: return {t:13,w:7.534763}; case 76: return {t:13,w:7.534763}; case 77: return {t:13,w:7.534763}; case 78: return {t:13,w:7.534763}; case 79: return {t:13,w:7.534763}; case 80: return {t:13,w:7.534763}; case 81: return {t:13,w:7.534763}; case 82: return {t:13,w:7.534763}; case 83: return {t:13,w:7.534763}; case 84: return {t:13,w:7.534763}; case 85: return {t:13,w:7.534763}; case 86: return {t:13,w:7.534763}; case 87: return {t:13,w:7.534763}; case 88: return {t:13,w:7.534763}; case 89: return {t:13,w:7.534763}; case 90: return {t:13,w:7.534763}; case 91: return {t:530,w:3.178054}; case 92: return {t:531,w:3.178054}; case 93: return {t:532,w:3.178054}; case 95: return {t:533,w:3.178054}; case 96: return {t:534,w:3.178054}; case 97: return {t:20,w:7.534763}; case 98: return {t:20,w:7.534763}; case 99: return {t:20,w:7.534763}; case 100: return {t:20,w:7.534763}; case 101: return {t:20,w:7.534763}; case 102: return {t:20,w:7.534763}; case 103: return {t:20,w:7.534763}; case 104: return {t:20,w:7.534763}; case 105: return {t:20,w:7.534763}; case 106: return {t:20,w:7.534763}; case 107: return {t:20,w:7.534763}; case 108: return {t:20,w:7.534763}; case 109: return {t:20,w:7.534763}; case 110: return {t:20,w:7.534763}; case 111: return {t:20,w:7.534763}; case 112: return {t:20,w:7.534763}; case 113: return {t:20,w:7.534763}; case 114: return {t:20,w:7.534763}; case 115: return {t:20,w:7.534763}; case 116: return {t:20,w:7.534763}; case 117: return {t:20,w:7.534763}; case 118: return {t:20,w:7.534763}; case 119: return {t:20,w:7.534763}; case 120: return {t:20,w:7.534763}; case 121: return {t:20,w:7.534763}; case 122: return {t:20,w:7.534763}; case 123: return {t:535,w:3.178054}; case 125: return {t:536,w:3.178054}; case 126: return {t:537,w:3.178054}; case 268: return {t:538,w:3.178054}; case 381: return {t:539,w:3.178054}; case 382: return {t:540,w:0.000000};default: return {t:0,w:0.0};}};
case 312: return function (act:Int) {switch (act) { case 258: return {t:541,w:0.000000};default: return {t:0,w:0.0};}};
case 313: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:542,w:0.000000};default: return {t:0,w:0.0};}};
case 314: return function (act:Int) {switch (act) { case 320: return {t:314,w:0.000000};default: return {t:0,w:0.0};}};
case 315: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:314,w:0.693147}; case 375: return {t:543,w:0.693147};default: return {t:0,w:0.0};}};
case 316: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:544,w:0.693147}; case 336: return {t:545,w:0.693147};default: return {t:0,w:0.0};}};
case 317: return function (act:Int) {switch (act) { case 45: return {t:546,w:0.000000};default: return {t:0,w:0.0};}};
case 318: return function (act:Int) {switch (act) { case 69: return {t:547,w:0.693147}; case 101: return {t:547,w:0.693147};default: return {t:0,w:0.0};}};
case 319: return function (act:Int) {switch (act) { case 45: return {t:548,w:0.000000};default: return {t:0,w:0.0};}};
case 320: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 33: return {t:2,w:5.170483}; case 37: return {t:3,w:5.170483}; case 39: return {t:4,w:5.170483}; case 42: return {t:5,w:5.170483}; case 43: return {t:6,w:5.170483}; case 45: return {t:7,w:5.170483}; case 46: return {t:8,w:5.170483}; case 48: return {t:9,w:8.571681}; case 49: return {t:9,w:8.571681}; case 50: return {t:9,w:8.571681}; case 51: return {t:9,w:8.571681}; case 52: return {t:9,w:8.571681}; case 53: return {t:9,w:8.571681}; case 54: return {t:9,w:8.571681}; case 55: return {t:9,w:8.571681}; case 56: return {t:9,w:8.571681}; case 57: return {t:9,w:8.571681}; case 65: return {t:495,w:5.743003}; case 66: return {t:495,w:5.743003}; case 67: return {t:495,w:5.743003}; case 68: return {t:495,w:5.743003}; case 69: return {t:495,w:5.743003}; case 70: return {t:495,w:5.743003}; case 71: return {t:495,w:5.743003}; case 72: return {t:495,w:5.743003}; case 73: return {t:495,w:5.743003}; case 74: return {t:495,w:5.743003}; case 75: return {t:495,w:5.743003}; case 76: return {t:495,w:5.743003}; case 77: return {t:495,w:5.743003}; case 78: return {t:495,w:5.743003}; case 79: return {t:495,w:5.743003}; case 80: return {t:495,w:5.743003}; case 81: return {t:495,w:5.743003}; case 82: return {t:495,w:5.743003}; case 83: return {t:496,w:2.484906}; case 84: return {t:495,w:5.743003}; case 85: return {t:495,w:5.743003}; case 86: return {t:495,w:5.743003}; case 87: return {t:495,w:5.743003}; case 88: return {t:495,w:5.743003}; case 89: return {t:495,w:5.743003}; case 90: return {t:495,w:5.743003}; case 95: return {t:18,w:5.170483}; case 96: return {t:19,w:5.170483}; case 97: return {t:497,w:5.743003}; case 98: return {t:497,w:5.743003}; case 99: return {t:497,w:5.743003}; case 100: return {t:497,w:5.743003}; case 101: return {t:497,w:5.743003}; case 102: return {t:497,w:5.743003}; case 103: return {t:497,w:5.743003}; case 104: return {t:497,w:5.743003}; case 105: return {t:497,w:5.743003}; case 106: return {t:497,w:5.743003}; case 107: return {t:497,w:5.743003}; case 108: return {t:497,w:5.743003}; case 109: return {t:497,w:5.743003}; case 110: return {t:497,w:5.743003}; case 111: return {t:497,w:5.743003}; case 112: return {t:497,w:5.743003}; case 113: return {t:497,w:5.743003}; case 114: return {t:497,w:5.743003}; case 115: return {t:498,w:2.484906}; case 116: return {t:497,w:5.743003}; case 117: return {t:497,w:5.743003}; case 118: return {t:497,w:5.743003}; case 119: return {t:497,w:5.743003}; case 120: return {t:497,w:5.743003}; case 121: return {t:497,w:5.743003}; case 122: return {t:497,w:5.743003}; case 126: return {t:22,w:5.170483}; case 258: return {t:549,w:0.693147}; case 268: return {t:29,w:5.170483}; case 269: return {t:500,w:2.772588}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 331: return {t:183,w:1.791759}; case 332: return {t:501,w:1.791759}; case 333: return {t:502,w:1.791759}; case 334: return {t:186,w:1.791759}; case 335: return {t:503,w:1.791759}; case 357: return {t:551,w:0.693147}; case 358: return {t:552,w:0.693147}; case 368: return {t:550,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 378: return {t:508,w:2.079441}; case 379: return {t:509,w:1.386294}; case 380: return {t:510,w:1.386294};default: return {t:0,w:0.0};}};
case 321: return function (act:Int) {switch (act) { case 258: return {t:553,w:0.000000};default: return {t:0,w:0.0};}};
case 322: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:553,w:0.693147}; case 375: return {t:554,w:0.693147};default: return {t:0,w:0.0};}};
case 323: return function (act:Int) {switch (act) { case 65: return {t:555,w:0.693147}; case 97: return {t:555,w:0.693147};default: return {t:0,w:0.0};}};
case 324: return function (act:Int) {switch (act) { case 79: return {t:556,w:0.693147}; case 111: return {t:556,w:0.693147};default: return {t:0,w:0.0};}};
case 325: return function (act:Int) {switch (act) { case 88: return {t:557,w:0.693147}; case 120: return {t:557,w:0.693147};default: return {t:0,w:0.0};}};
case 326: return function (act:Int) {switch (act) { case 79: return {t:558,w:0.693147}; case 111: return {t:558,w:0.693147};default: return {t:0,w:0.0};}};
case 327: return function (act:Int) {switch (act) { case 76: return {t:559,w:0.693147}; case 108: return {t:559,w:0.693147};default: return {t:0,w:0.0};}};
case 328: return function (act:Int) {switch (act) { case 85: return {t:560,w:0.693147}; case 117: return {t:560,w:0.693147};default: return {t:0,w:0.0};}};
case 329: return function (act:Int) {switch (act) { case 82: return {t:561,w:0.693147}; case 114: return {t:561,w:0.693147};default: return {t:0,w:0.0};}};
case 330: return function (act:Int) {switch (act) { case 84: return {t:562,w:0.693147}; case 116: return {t:562,w:0.693147};default: return {t:0,w:0.0};}};
case 331: return function (act:Int) {switch (act) { case 86: return {t:563,w:0.693147}; case 118: return {t:563,w:0.693147};default: return {t:0,w:0.0};}};
case 332: return function (act:Int) {switch (act) { case 74: return {t:564,w:0.693147}; case 106: return {t:564,w:0.693147};default: return {t:0,w:0.0};}};
case 333: return function (act:Int) {switch (act) { case 80: return {t:565,w:0.693147}; case 112: return {t:565,w:0.693147};default: return {t:0,w:0.0};}};
case 334: return function (act:Int) {switch (act) { case 33: return {t:566,w:5.236442}; case 34: return {t:566,w:5.236442}; case 35: return {t:566,w:5.236442}; case 36: return {t:566,w:5.236442}; case 37: return {t:566,w:5.236442}; case 38: return {t:566,w:5.236442}; case 39: return {t:566,w:5.236442}; case 40: return {t:566,w:5.236442}; case 41: return {t:566,w:5.236442}; case 42: return {t:566,w:5.236442}; case 43: return {t:566,w:5.236442}; case 44: return {t:566,w:5.236442}; case 45: return {t:566,w:5.236442}; case 46: return {t:566,w:5.236442}; case 47: return {t:566,w:5.236442}; case 48: return {t:566,w:5.236442}; case 49: return {t:566,w:5.236442}; case 50: return {t:566,w:5.236442}; case 51: return {t:566,w:5.236442}; case 52: return {t:566,w:5.236442}; case 53: return {t:566,w:5.236442}; case 54: return {t:566,w:5.236442}; case 55: return {t:566,w:5.236442}; case 56: return {t:566,w:5.236442}; case 57: return {t:566,w:5.236442}; case 58: return {t:566,w:5.236442}; case 59: return {t:566,w:5.236442}; case 60: return {t:566,w:5.236442}; case 61: return {t:566,w:5.236442}; case 62: return {t:566,w:5.236442}; case 63: return {t:566,w:5.236442}; case 64: return {t:566,w:5.236442}; case 65: return {t:566,w:5.236442}; case 66: return {t:566,w:5.236442}; case 67: return {t:566,w:5.236442}; case 68: return {t:566,w:5.236442}; case 69: return {t:566,w:5.236442}; case 70: return {t:566,w:5.236442}; case 71: return {t:566,w:5.236442}; case 72: return {t:566,w:5.236442}; case 73: return {t:566,w:5.236442}; case 74: return {t:566,w:5.236442}; case 75: return {t:566,w:5.236442}; case 76: return {t:566,w:5.236442}; case 77: return {t:566,w:5.236442}; case 78: return {t:566,w:5.236442}; case 79: return {t:566,w:5.236442}; case 80: return {t:566,w:5.236442}; case 81: return {t:566,w:5.236442}; case 82: return {t:566,w:5.236442}; case 83: return {t:566,w:5.236442}; case 84: return {t:566,w:5.236442}; case 85: return {t:566,w:5.236442}; case 86: return {t:566,w:5.236442}; case 87: return {t:566,w:5.236442}; case 88: return {t:566,w:5.236442}; case 89: return {t:566,w:5.236442}; case 90: return {t:566,w:5.236442}; case 91: return {t:566,w:5.236442}; case 92: return {t:566,w:5.236442}; case 93: return {t:566,w:5.236442}; case 94: return {t:566,w:5.236442}; case 95: return {t:566,w:5.236442}; case 96: return {t:566,w:5.236442}; case 97: return {t:566,w:5.236442}; case 98: return {t:566,w:5.236442}; case 99: return {t:566,w:5.236442}; case 100: return {t:566,w:5.236442}; case 101: return {t:566,w:5.236442}; case 102: return {t:566,w:5.236442}; case 103: return {t:566,w:5.236442}; case 104: return {t:566,w:5.236442}; case 105: return {t:566,w:5.236442}; case 106: return {t:566,w:5.236442}; case 107: return {t:566,w:5.236442}; case 108: return {t:566,w:5.236442}; case 109: return {t:566,w:5.236442}; case 110: return {t:566,w:5.236442}; case 111: return {t:566,w:5.236442}; case 112: return {t:566,w:5.236442}; case 113: return {t:566,w:5.236442}; case 114: return {t:566,w:5.236442}; case 115: return {t:566,w:5.236442}; case 116: return {t:566,w:5.236442}; case 117: return {t:566,w:5.236442}; case 118: return {t:566,w:5.236442}; case 119: return {t:566,w:5.236442}; case 120: return {t:566,w:5.236442}; case 121: return {t:566,w:5.236442}; case 122: return {t:566,w:5.236442}; case 123: return {t:566,w:5.236442}; case 124: return {t:566,w:5.236442}; case 125: return {t:566,w:5.236442}; case 126: return {t:566,w:5.236442}; case 192: return {t:437,w:5.768321}; case 193: return {t:437,w:5.768321}; case 194: return {t:437,w:5.768321}; case 195: return {t:437,w:5.768321}; case 196: return {t:437,w:5.768321}; case 197: return {t:437,w:5.768321}; case 198: return {t:437,w:5.768321}; case 199: return {t:437,w:5.768321}; case 200: return {t:437,w:5.768321}; case 201: return {t:437,w:5.768321}; case 202: return {t:437,w:5.768321}; case 203: return {t:437,w:5.768321}; case 204: return {t:437,w:5.768321}; case 205: return {t:437,w:5.768321}; case 206: return {t:437,w:5.768321}; case 207: return {t:437,w:5.768321}; case 208: return {t:437,w:5.768321}; case 209: return {t:437,w:5.768321}; case 210: return {t:437,w:5.768321}; case 211: return {t:437,w:5.768321}; case 212: return {t:437,w:5.768321}; case 213: return {t:437,w:5.768321}; case 214: return {t:437,w:5.768321}; case 215: return {t:437,w:5.768321}; case 216: return {t:437,w:5.768321}; case 217: return {t:437,w:5.768321}; case 218: return {t:437,w:5.768321}; case 219: return {t:437,w:5.768321}; case 220: return {t:437,w:5.768321}; case 221: return {t:437,w:5.768321}; case 222: return {t:437,w:5.768321}; case 223: return {t:437,w:5.768321}; case 224: return {t:438,w:5.075174}; case 225: return {t:438,w:5.075174}; case 226: return {t:438,w:5.075174}; case 227: return {t:438,w:5.075174}; case 228: return {t:438,w:5.075174}; case 229: return {t:438,w:5.075174}; case 230: return {t:438,w:5.075174}; case 231: return {t:438,w:5.075174}; case 232: return {t:438,w:5.075174}; case 233: return {t:438,w:5.075174}; case 234: return {t:438,w:5.075174}; case 235: return {t:438,w:5.075174}; case 236: return {t:438,w:5.075174}; case 237: return {t:438,w:5.075174}; case 238: return {t:438,w:5.075174}; case 239: return {t:438,w:5.075174}; case 240: return {t:439,w:4.382027}; case 241: return {t:439,w:4.382027}; case 242: return {t:439,w:4.382027}; case 243: return {t:439,w:4.382027}; case 244: return {t:439,w:4.382027}; case 245: return {t:439,w:4.382027}; case 246: return {t:439,w:4.382027}; case 247: return {t:439,w:4.382027}; case 248: return {t:440,w:3.688879}; case 249: return {t:440,w:3.688879}; case 250: return {t:440,w:3.688879}; case 251: return {t:440,w:3.688879}; case 252: return {t:441,w:2.995732}; case 253: return {t:441,w:2.995732}; case 367: return {t:567,w:0.693147}; case 383: return {t:568,w:0.000000};default: return {t:0,w:0.0};}};
case 335: return function (act:Int) {switch (act) { case 319: return {t:335,w:0.000000};default: return {t:0,w:0.0};}};
case 336: return function (act:Int) {switch (act) { case 258: return {t:335,w:0.000000};default: return {t:0,w:0.0};}};
case 337: return function (act:Int) {switch (act) { case 69: return {t:569,w:0.693147}; case 101: return {t:569,w:0.693147};default: return {t:0,w:0.0};}};
case 338: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.772588}; case 13: return {t:83,w:2.772588}; case 32: return {t:494,w:2.772588}; case 33: return {t:2,w:4.477336}; case 37: return {t:3,w:4.477336}; case 39: return {t:4,w:4.477336}; case 42: return {t:5,w:4.477336}; case 43: return {t:6,w:4.477336}; case 45: return {t:7,w:4.477336}; case 46: return {t:8,w:4.477336}; case 48: return {t:9,w:7.878534}; case 49: return {t:9,w:7.878534}; case 50: return {t:9,w:7.878534}; case 51: return {t:9,w:7.878534}; case 52: return {t:9,w:7.878534}; case 53: return {t:9,w:7.878534}; case 54: return {t:9,w:7.878534}; case 55: return {t:9,w:7.878534}; case 56: return {t:9,w:7.878534}; case 57: return {t:9,w:7.878534}; case 65: return {t:495,w:5.049856}; case 66: return {t:495,w:5.049856}; case 67: return {t:495,w:5.049856}; case 68: return {t:495,w:5.049856}; case 69: return {t:495,w:5.049856}; case 70: return {t:495,w:5.049856}; case 71: return {t:495,w:5.049856}; case 72: return {t:495,w:5.049856}; case 73: return {t:495,w:5.049856}; case 74: return {t:495,w:5.049856}; case 75: return {t:495,w:5.049856}; case 76: return {t:495,w:5.049856}; case 77: return {t:495,w:5.049856}; case 78: return {t:495,w:5.049856}; case 79: return {t:495,w:5.049856}; case 80: return {t:495,w:5.049856}; case 81: return {t:495,w:5.049856}; case 82: return {t:495,w:5.049856}; case 83: return {t:496,w:1.791759}; case 84: return {t:495,w:5.049856}; case 85: return {t:495,w:5.049856}; case 86: return {t:495,w:5.049856}; case 87: return {t:495,w:5.049856}; case 88: return {t:495,w:5.049856}; case 89: return {t:495,w:5.049856}; case 90: return {t:495,w:5.049856}; case 95: return {t:18,w:4.477336}; case 96: return {t:19,w:4.477336}; case 97: return {t:497,w:5.049856}; case 98: return {t:497,w:5.049856}; case 99: return {t:497,w:5.049856}; case 100: return {t:497,w:5.049856}; case 101: return {t:497,w:5.049856}; case 102: return {t:497,w:5.049856}; case 103: return {t:497,w:5.049856}; case 104: return {t:497,w:5.049856}; case 105: return {t:497,w:5.049856}; case 106: return {t:497,w:5.049856}; case 107: return {t:497,w:5.049856}; case 108: return {t:497,w:5.049856}; case 109: return {t:497,w:5.049856}; case 110: return {t:497,w:5.049856}; case 111: return {t:497,w:5.049856}; case 112: return {t:497,w:5.049856}; case 113: return {t:497,w:5.049856}; case 114: return {t:497,w:5.049856}; case 115: return {t:498,w:1.791759}; case 116: return {t:497,w:5.049856}; case 117: return {t:497,w:5.049856}; case 118: return {t:497,w:5.049856}; case 119: return {t:497,w:5.049856}; case 120: return {t:497,w:5.049856}; case 121: return {t:497,w:5.049856}; case 122: return {t:497,w:5.049856}; case 126: return {t:22,w:4.477336}; case 258: return {t:499,w:1.386294}; case 268: return {t:29,w:4.477336}; case 269: return {t:500,w:2.079441}; case 279: return {t:504,w:2.772588}; case 283: return {t:119,w:2.772588}; case 331: return {t:183,w:1.098612}; case 332: return {t:501,w:1.098612}; case 333: return {t:502,w:1.098612}; case 334: return {t:186,w:1.098612}; case 335: return {t:503,w:1.098612}; case 368: return {t:507,w:0.693147}; case 376: return {t:505,w:2.079441}; case 377: return {t:506,w:1.386294}; case 378: return {t:508,w:1.386294}; case 379: return {t:509,w:0.693147}; case 380: return {t:510,w:0.693147};default: return {t:0,w:0.0};}};
case 339: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:571,w:0.693147}; case 384: return {t:572,w:0.693147};default: return {t:0,w:0.0};}};
case 340: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:571,w:0.693147}; case 384: return {t:572,w:0.693147};default: return {t:0,w:0.0};}};
case 341: return function (act:Int) {switch (act) { case 85: return {t:573,w:0.693147}; case 117: return {t:573,w:0.693147};default: return {t:0,w:0.0};}};
case 342: return function (act:Int) {switch (act) { case 82: return {t:574,w:0.693147}; case 114: return {t:574,w:0.693147};default: return {t:0,w:0.0};}};
case 343: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:240,w:0.000000};default: return {t:0,w:0.0};}};
case 344: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:575,w:1.386294}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:576,w:1.386294}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:577,w:0.693147}; case 385: return {t:578,w:0.000000}; case 386: return {t:579,w:0.000000};default: return {t:0,w:0.0};}};
case 345: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:580,w:0.693147}; case 375: return {t:581,w:0.693147};default: return {t:0,w:0.0};}};
case 346: return function (act:Int) {switch (act) { case 78: return {t:582,w:0.693147}; case 110: return {t:582,w:0.693147};default: return {t:0,w:0.0};}};
case 347: return function (act:Int) {switch (act) { case 45: return {t:583,w:0.000000};default: return {t:0,w:0.0};}};
case 348: return function (act:Int) {switch (act) { case 258: return {t:584,w:0.000000};default: return {t:0,w:0.0};}};
case 349: return function (act:Int) {switch (act) { case 279: return {t:349,w:0.000000};default: return {t:0,w:0.0};}};
case 350: return function (act:Int) {switch (act) { case 280: return {t:350,w:0.000000};default: return {t:0,w:0.0};}};
case 351: return function (act:Int) {switch (act) { case 9: return {t:493,w:3.178053}; case 13: return {t:83,w:3.178053}; case 32: return {t:494,w:3.178053}; case 33: return {t:566,w:7.028201}; case 34: return {t:566,w:7.028201}; case 35: return {t:566,w:7.028201}; case 36: return {t:566,w:7.028201}; case 37: return {t:566,w:7.028201}; case 38: return {t:566,w:7.028201}; case 39: return {t:566,w:7.028201}; case 40: return {t:566,w:7.028201}; case 41: return {t:566,w:7.028201}; case 42: return {t:566,w:7.028201}; case 43: return {t:566,w:7.028201}; case 44: return {t:566,w:7.028201}; case 45: return {t:566,w:7.028201}; case 46: return {t:566,w:7.028201}; case 47: return {t:566,w:7.028201}; case 48: return {t:566,w:7.028201}; case 49: return {t:566,w:7.028201}; case 50: return {t:566,w:7.028201}; case 51: return {t:566,w:7.028201}; case 52: return {t:566,w:7.028201}; case 53: return {t:566,w:7.028201}; case 54: return {t:566,w:7.028201}; case 55: return {t:566,w:7.028201}; case 56: return {t:566,w:7.028201}; case 57: return {t:566,w:7.028201}; case 58: return {t:566,w:7.028201}; case 59: return {t:566,w:7.028201}; case 60: return {t:566,w:7.028201}; case 61: return {t:566,w:7.028201}; case 62: return {t:566,w:7.028201}; case 63: return {t:566,w:7.028201}; case 64: return {t:566,w:7.028201}; case 65: return {t:566,w:7.028201}; case 66: return {t:566,w:7.028201}; case 67: return {t:566,w:7.028201}; case 68: return {t:566,w:7.028201}; case 69: return {t:566,w:7.028201}; case 70: return {t:566,w:7.028201}; case 71: return {t:566,w:7.028201}; case 72: return {t:566,w:7.028201}; case 73: return {t:566,w:7.028201}; case 74: return {t:566,w:7.028201}; case 75: return {t:566,w:7.028201}; case 76: return {t:566,w:7.028201}; case 77: return {t:566,w:7.028201}; case 78: return {t:566,w:7.028201}; case 79: return {t:566,w:7.028201}; case 80: return {t:566,w:7.028201}; case 81: return {t:566,w:7.028201}; case 82: return {t:566,w:7.028201}; case 83: return {t:566,w:7.028201}; case 84: return {t:566,w:7.028201}; case 85: return {t:566,w:7.028201}; case 86: return {t:566,w:7.028201}; case 87: return {t:566,w:7.028201}; case 88: return {t:566,w:7.028201}; case 89: return {t:566,w:7.028201}; case 90: return {t:566,w:7.028201}; case 91: return {t:566,w:7.028201}; case 92: return {t:566,w:7.028201}; case 93: return {t:566,w:7.028201}; case 94: return {t:566,w:7.028201}; case 95: return {t:566,w:7.028201}; case 96: return {t:566,w:7.028201}; case 97: return {t:566,w:7.028201}; case 98: return {t:566,w:7.028201}; case 99: return {t:566,w:7.028201}; case 100: return {t:566,w:7.028201}; case 101: return {t:566,w:7.028201}; case 102: return {t:566,w:7.028201}; case 103: return {t:566,w:7.028201}; case 104: return {t:566,w:7.028201}; case 105: return {t:566,w:7.028201}; case 106: return {t:566,w:7.028201}; case 107: return {t:566,w:7.028201}; case 108: return {t:566,w:7.028201}; case 109: return {t:566,w:7.028201}; case 110: return {t:566,w:7.028201}; case 111: return {t:566,w:7.028201}; case 112: return {t:566,w:7.028201}; case 113: return {t:566,w:7.028201}; case 114: return {t:566,w:7.028201}; case 115: return {t:566,w:7.028201}; case 116: return {t:566,w:7.028201}; case 117: return {t:566,w:7.028201}; case 118: return {t:566,w:7.028201}; case 119: return {t:566,w:7.028201}; case 120: return {t:566,w:7.028201}; case 121: return {t:566,w:7.028201}; case 122: return {t:566,w:7.028201}; case 123: return {t:566,w:7.028201}; case 124: return {t:566,w:7.028201}; case 125: return {t:566,w:7.028201}; case 126: return {t:566,w:7.028201}; case 128: return {t:436,w:5.950642}; case 129: return {t:436,w:5.950642}; case 130: return {t:436,w:5.950642}; case 131: return {t:436,w:5.950642}; case 132: return {t:436,w:5.950642}; case 133: return {t:436,w:5.950642}; case 134: return {t:436,w:5.950642}; case 135: return {t:436,w:5.950642}; case 136: return {t:436,w:5.950642}; case 137: return {t:436,w:5.950642}; case 138: return {t:436,w:5.950642}; case 139: return {t:436,w:5.950642}; case 140: return {t:436,w:5.950642}; case 141: return {t:436,w:5.950642}; case 142: return {t:436,w:5.950642}; case 143: return {t:436,w:5.950642}; case 144: return {t:436,w:5.950642}; case 145: return {t:436,w:5.950642}; case 146: return {t:436,w:5.950642}; case 147: return {t:436,w:5.950642}; case 148: return {t:436,w:5.950642}; case 149: return {t:436,w:5.950642}; case 150: return {t:436,w:5.950642}; case 151: return {t:436,w:5.950642}; case 152: return {t:436,w:5.950642}; case 153: return {t:436,w:5.950642}; case 154: return {t:436,w:5.950642}; case 155: return {t:436,w:5.950642}; case 156: return {t:436,w:5.950642}; case 157: return {t:436,w:5.950642}; case 158: return {t:436,w:5.950642}; case 159: return {t:436,w:5.950642}; case 160: return {t:436,w:5.950642}; case 161: return {t:436,w:5.950642}; case 162: return {t:436,w:5.950642}; case 163: return {t:436,w:5.950642}; case 164: return {t:436,w:5.950642}; case 165: return {t:436,w:5.950642}; case 166: return {t:436,w:5.950642}; case 167: return {t:436,w:5.950642}; case 168: return {t:436,w:5.950642}; case 169: return {t:436,w:5.950642}; case 170: return {t:436,w:5.950642}; case 171: return {t:436,w:5.950642}; case 172: return {t:436,w:5.950642}; case 173: return {t:436,w:5.950642}; case 174: return {t:436,w:5.950642}; case 175: return {t:436,w:5.950642}; case 176: return {t:436,w:5.950642}; case 177: return {t:436,w:5.950642}; case 178: return {t:436,w:5.950642}; case 179: return {t:436,w:5.950642}; case 180: return {t:436,w:5.950642}; case 181: return {t:436,w:5.950642}; case 182: return {t:436,w:5.950642}; case 183: return {t:436,w:5.950642}; case 184: return {t:436,w:5.950642}; case 185: return {t:436,w:5.950642}; case 186: return {t:436,w:5.950642}; case 187: return {t:436,w:5.950642}; case 188: return {t:436,w:5.950642}; case 189: return {t:436,w:5.950642}; case 190: return {t:436,w:5.950642}; case 191: return {t:436,w:5.950642}; case 192: return {t:437,w:7.560080}; case 193: return {t:437,w:7.560080}; case 194: return {t:437,w:7.560080}; case 195: return {t:437,w:7.560080}; case 196: return {t:437,w:7.560080}; case 197: return {t:437,w:7.560080}; case 198: return {t:437,w:7.560080}; case 199: return {t:437,w:7.560080}; case 200: return {t:437,w:7.560080}; case 201: return {t:437,w:7.560080}; case 202: return {t:437,w:7.560080}; case 203: return {t:437,w:7.560080}; case 204: return {t:437,w:7.560080}; case 205: return {t:437,w:7.560080}; case 206: return {t:437,w:7.560080}; case 207: return {t:437,w:7.560080}; case 208: return {t:437,w:7.560080}; case 209: return {t:437,w:7.560080}; case 210: return {t:437,w:7.560080}; case 211: return {t:437,w:7.560080}; case 212: return {t:437,w:7.560080}; case 213: return {t:437,w:7.560080}; case 214: return {t:437,w:7.560080}; case 215: return {t:437,w:7.560080}; case 216: return {t:437,w:7.560080}; case 217: return {t:437,w:7.560080}; case 218: return {t:437,w:7.560080}; case 219: return {t:437,w:7.560080}; case 220: return {t:437,w:7.560080}; case 221: return {t:437,w:7.560080}; case 222: return {t:437,w:7.560080}; case 223: return {t:437,w:7.560080}; case 224: return {t:438,w:6.866933}; case 225: return {t:438,w:6.866933}; case 226: return {t:438,w:6.866933}; case 227: return {t:438,w:6.866933}; case 228: return {t:438,w:6.866933}; case 229: return {t:438,w:6.866933}; case 230: return {t:438,w:6.866933}; case 231: return {t:438,w:6.866933}; case 232: return {t:438,w:6.866933}; case 233: return {t:438,w:6.866933}; case 234: return {t:438,w:6.866933}; case 235: return {t:438,w:6.866933}; case 236: return {t:438,w:6.866933}; case 237: return {t:438,w:6.866933}; case 238: return {t:438,w:6.866933}; case 239: return {t:438,w:6.866933}; case 240: return {t:439,w:6.173786}; case 241: return {t:439,w:6.173786}; case 242: return {t:439,w:6.173786}; case 243: return {t:439,w:6.173786}; case 244: return {t:439,w:6.173786}; case 245: return {t:439,w:6.173786}; case 246: return {t:439,w:6.173786}; case 247: return {t:439,w:6.173786}; case 248: return {t:440,w:5.480638}; case 249: return {t:440,w:5.480638}; case 250: return {t:440,w:5.480638}; case 251: return {t:440,w:5.480638}; case 252: return {t:441,w:4.787491}; case 253: return {t:441,w:4.787491}; case 258: return {t:585,w:0.693147}; case 279: return {t:504,w:3.178053}; case 283: return {t:119,w:3.178053}; case 366: return {t:587,w:1.791759}; case 367: return {t:567,w:2.484906}; case 376: return {t:505,w:2.484906}; case 377: return {t:586,w:1.791759}; case 383: return {t:588,w:1.791759};default: return {t:0,w:0.0};}};
case 352: return function (act:Int) {switch (act) { case 258: return {t:589,w:0.000000};default: return {t:0,w:0.0};}};
case 353: return function (act:Int) {switch (act) { case 346: return {t:353,w:0.000000};default: return {t:0,w:0.0};}};
case 354: return function (act:Int) {switch (act) { case 0: return {t:249,w:5.545177}; case 1: return {t:249,w:5.545177}; case 2: return {t:249,w:5.545177}; case 3: return {t:249,w:5.545177}; case 4: return {t:249,w:5.545177}; case 5: return {t:249,w:5.545177}; case 6: return {t:249,w:5.545177}; case 7: return {t:249,w:5.545177}; case 8: return {t:249,w:5.545177}; case 9: return {t:249,w:5.545177}; case 10: return {t:249,w:5.545177}; case 11: return {t:249,w:5.545177}; case 12: return {t:249,w:5.545177}; case 13: return {t:249,w:5.545177}; case 14: return {t:249,w:5.545177}; case 15: return {t:249,w:5.545177}; case 16: return {t:249,w:5.545177}; case 17: return {t:249,w:5.545177}; case 18: return {t:249,w:5.545177}; case 19: return {t:249,w:5.545177}; case 20: return {t:249,w:5.545177}; case 21: return {t:249,w:5.545177}; case 22: return {t:249,w:5.545177}; case 23: return {t:249,w:5.545177}; case 24: return {t:249,w:5.545177}; case 25: return {t:249,w:5.545177}; case 26: return {t:249,w:5.545177}; case 27: return {t:249,w:5.545177}; case 28: return {t:249,w:5.545177}; case 29: return {t:249,w:5.545177}; case 30: return {t:249,w:5.545177}; case 31: return {t:249,w:5.545177}; case 32: return {t:249,w:5.545177}; case 33: return {t:249,w:5.545177}; case 34: return {t:249,w:5.545177}; case 35: return {t:249,w:5.545177}; case 36: return {t:249,w:5.545177}; case 37: return {t:249,w:5.545177}; case 38: return {t:249,w:5.545177}; case 39: return {t:249,w:5.545177}; case 40: return {t:249,w:5.545177}; case 41: return {t:249,w:5.545177}; case 42: return {t:249,w:5.545177}; case 43: return {t:249,w:5.545177}; case 44: return {t:249,w:5.545177}; case 45: return {t:249,w:5.545177}; case 46: return {t:249,w:5.545177}; case 47: return {t:249,w:5.545177}; case 48: return {t:249,w:5.545177}; case 49: return {t:249,w:5.545177}; case 50: return {t:249,w:5.545177}; case 51: return {t:249,w:5.545177}; case 52: return {t:249,w:5.545177}; case 53: return {t:249,w:5.545177}; case 54: return {t:249,w:5.545177}; case 55: return {t:249,w:5.545177}; case 56: return {t:249,w:5.545177}; case 57: return {t:249,w:5.545177}; case 58: return {t:249,w:5.545177}; case 59: return {t:249,w:5.545177}; case 60: return {t:249,w:5.545177}; case 61: return {t:249,w:5.545177}; case 62: return {t:249,w:5.545177}; case 63: return {t:249,w:5.545177}; case 64: return {t:249,w:5.545177}; case 65: return {t:249,w:5.545177}; case 66: return {t:249,w:5.545177}; case 67: return {t:249,w:5.545177}; case 68: return {t:249,w:5.545177}; case 69: return {t:249,w:5.545177}; case 70: return {t:249,w:5.545177}; case 71: return {t:249,w:5.545177}; case 72: return {t:249,w:5.545177}; case 73: return {t:249,w:5.545177}; case 74: return {t:249,w:5.545177}; case 75: return {t:249,w:5.545177}; case 76: return {t:249,w:5.545177}; case 77: return {t:249,w:5.545177}; case 78: return {t:249,w:5.545177}; case 79: return {t:249,w:5.545177}; case 80: return {t:249,w:5.545177}; case 81: return {t:249,w:5.545177}; case 82: return {t:249,w:5.545177}; case 83: return {t:249,w:5.545177}; case 84: return {t:249,w:5.545177}; case 85: return {t:249,w:5.545177}; case 86: return {t:249,w:5.545177}; case 87: return {t:249,w:5.545177}; case 88: return {t:249,w:5.545177}; case 89: return {t:249,w:5.545177}; case 90: return {t:249,w:5.545177}; case 91: return {t:249,w:5.545177}; case 92: return {t:249,w:5.545177}; case 93: return {t:249,w:5.545177}; case 94: return {t:249,w:5.545177}; case 95: return {t:249,w:5.545177}; case 96: return {t:249,w:5.545177}; case 97: return {t:249,w:5.545177}; case 98: return {t:249,w:5.545177}; case 99: return {t:249,w:5.545177}; case 100: return {t:249,w:5.545177}; case 101: return {t:249,w:5.545177}; case 102: return {t:249,w:5.545177}; case 103: return {t:249,w:5.545177}; case 104: return {t:249,w:5.545177}; case 105: return {t:249,w:5.545177}; case 106: return {t:249,w:5.545177}; case 107: return {t:249,w:5.545177}; case 108: return {t:249,w:5.545177}; case 109: return {t:249,w:5.545177}; case 110: return {t:249,w:5.545177}; case 111: return {t:249,w:5.545177}; case 112: return {t:249,w:5.545177}; case 113: return {t:249,w:5.545177}; case 114: return {t:249,w:5.545177}; case 115: return {t:249,w:5.545177}; case 116: return {t:249,w:5.545177}; case 117: return {t:249,w:5.545177}; case 118: return {t:249,w:5.545177}; case 119: return {t:249,w:5.545177}; case 120: return {t:249,w:5.545177}; case 121: return {t:249,w:5.545177}; case 122: return {t:249,w:5.545177}; case 123: return {t:249,w:5.545177}; case 124: return {t:249,w:5.545177}; case 125: return {t:249,w:5.545177}; case 126: return {t:249,w:5.545177}; case 127: return {t:249,w:5.545177}; case 128: return {t:249,w:5.545177}; case 129: return {t:249,w:5.545177}; case 130: return {t:249,w:5.545177}; case 131: return {t:249,w:5.545177}; case 132: return {t:249,w:5.545177}; case 133: return {t:249,w:5.545177}; case 134: return {t:249,w:5.545177}; case 135: return {t:249,w:5.545177}; case 136: return {t:249,w:5.545177}; case 137: return {t:249,w:5.545177}; case 138: return {t:249,w:5.545177}; case 139: return {t:249,w:5.545177}; case 140: return {t:249,w:5.545177}; case 141: return {t:249,w:5.545177}; case 142: return {t:249,w:5.545177}; case 143: return {t:249,w:5.545177}; case 144: return {t:249,w:5.545177}; case 145: return {t:249,w:5.545177}; case 146: return {t:249,w:5.545177}; case 147: return {t:249,w:5.545177}; case 148: return {t:249,w:5.545177}; case 149: return {t:249,w:5.545177}; case 150: return {t:249,w:5.545177}; case 151: return {t:249,w:5.545177}; case 152: return {t:249,w:5.545177}; case 153: return {t:249,w:5.545177}; case 154: return {t:249,w:5.545177}; case 155: return {t:249,w:5.545177}; case 156: return {t:249,w:5.545177}; case 157: return {t:249,w:5.545177}; case 158: return {t:249,w:5.545177}; case 159: return {t:249,w:5.545177}; case 160: return {t:249,w:5.545177}; case 161: return {t:249,w:5.545177}; case 162: return {t:249,w:5.545177}; case 163: return {t:249,w:5.545177}; case 164: return {t:249,w:5.545177}; case 165: return {t:249,w:5.545177}; case 166: return {t:249,w:5.545177}; case 167: return {t:249,w:5.545177}; case 168: return {t:249,w:5.545177}; case 169: return {t:249,w:5.545177}; case 170: return {t:249,w:5.545177}; case 171: return {t:249,w:5.545177}; case 172: return {t:249,w:5.545177}; case 173: return {t:249,w:5.545177}; case 174: return {t:249,w:5.545177}; case 175: return {t:249,w:5.545177}; case 176: return {t:249,w:5.545177}; case 177: return {t:249,w:5.545177}; case 178: return {t:249,w:5.545177}; case 179: return {t:249,w:5.545177}; case 180: return {t:249,w:5.545177}; case 181: return {t:249,w:5.545177}; case 182: return {t:249,w:5.545177}; case 183: return {t:249,w:5.545177}; case 184: return {t:249,w:5.545177}; case 185: return {t:249,w:5.545177}; case 186: return {t:249,w:5.545177}; case 187: return {t:249,w:5.545177}; case 188: return {t:249,w:5.545177}; case 189: return {t:249,w:5.545177}; case 190: return {t:249,w:5.545177}; case 191: return {t:249,w:5.545177}; case 192: return {t:249,w:5.545177}; case 193: return {t:249,w:5.545177}; case 194: return {t:249,w:5.545177}; case 195: return {t:249,w:5.545177}; case 196: return {t:249,w:5.545177}; case 197: return {t:249,w:5.545177}; case 198: return {t:249,w:5.545177}; case 199: return {t:249,w:5.545177}; case 200: return {t:249,w:5.545177}; case 201: return {t:249,w:5.545177}; case 202: return {t:249,w:5.545177}; case 203: return {t:249,w:5.545177}; case 204: return {t:249,w:5.545177}; case 205: return {t:249,w:5.545177}; case 206: return {t:249,w:5.545177}; case 207: return {t:249,w:5.545177}; case 208: return {t:249,w:5.545177}; case 209: return {t:249,w:5.545177}; case 210: return {t:249,w:5.545177}; case 211: return {t:249,w:5.545177}; case 212: return {t:249,w:5.545177}; case 213: return {t:249,w:5.545177}; case 214: return {t:249,w:5.545177}; case 215: return {t:249,w:5.545177}; case 216: return {t:249,w:5.545177}; case 217: return {t:249,w:5.545177}; case 218: return {t:249,w:5.545177}; case 219: return {t:249,w:5.545177}; case 220: return {t:249,w:5.545177}; case 221: return {t:249,w:5.545177}; case 222: return {t:249,w:5.545177}; case 223: return {t:249,w:5.545177}; case 224: return {t:249,w:5.545177}; case 225: return {t:249,w:5.545177}; case 226: return {t:249,w:5.545177}; case 227: return {t:249,w:5.545177}; case 228: return {t:249,w:5.545177}; case 229: return {t:249,w:5.545177}; case 230: return {t:249,w:5.545177}; case 231: return {t:249,w:5.545177}; case 232: return {t:249,w:5.545177}; case 233: return {t:249,w:5.545177}; case 234: return {t:249,w:5.545177}; case 235: return {t:249,w:5.545177}; case 236: return {t:249,w:5.545177}; case 237: return {t:249,w:5.545177}; case 238: return {t:249,w:5.545177}; case 239: return {t:249,w:5.545177}; case 240: return {t:249,w:5.545177}; case 241: return {t:249,w:5.545177}; case 242: return {t:249,w:5.545177}; case 243: return {t:249,w:5.545177}; case 244: return {t:249,w:5.545177}; case 245: return {t:249,w:5.545177}; case 246: return {t:249,w:5.545177}; case 247: return {t:249,w:5.545177}; case 248: return {t:249,w:5.545177}; case 249: return {t:249,w:5.545177}; case 250: return {t:249,w:5.545177}; case 251: return {t:249,w:5.545177}; case 252: return {t:249,w:5.545177}; case 253: return {t:249,w:5.545177}; case 254: return {t:249,w:5.545177}; case 255: return {t:249,w:5.545177};default: return {t:0,w:0.0};}};
case 355: return function (act:Int) {switch (act) { case 330: return {t:355,w:0.000000};default: return {t:0,w:0.0};}};
case 356: return function (act:Int) {switch (act) { case 256: return {t:354,w:4000000.750000}; case 258: return {t:355,w:0.693147}; case 346: return {t:356,w:0.693147};default: return {t:0,w:0.0};}};
case 357: return function (act:Int) {switch (act) { case 258: return {t:590,w:0.000000};default: return {t:0,w:0.0};}};
case 358: return function (act:Int) {switch (act) { case 258: return {t:591,w:0.000000};default: return {t:0,w:0.0};}};
case 359: return function (act:Int) {switch (act) { case 83: return {t:592,w:0.000000};default: return {t:0,w:0.0};}};
case 360: return function (act:Int) {switch (act) { case 69: return {t:593,w:0.000000};default: return {t:0,w:0.0};}};
case 361: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:594,w:0.000000};default: return {t:0,w:0.0};}};
case 362: return function (act:Int) {switch (act) { case 46: return {t:361,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:362,w:0.693147};default: return {t:0,w:0.0};}};
case 363: return function (act:Int) {switch (act) { case 58: return {t:595,w:0.000000}; case 83: return {t:596,w:0.693147}; case 115: return {t:596,w:0.693147};default: return {t:0,w:0.0};}};
case 364: return function (act:Int) {switch (act) { case 33: return {t:420,w:4.477337}; case 36: return {t:597,w:2.397895}; case 37: return {t:422,w:2.397895}; case 38: return {t:598,w:2.397895}; case 39: return {t:424,w:5.863631}; case 40: return {t:424,w:5.863631}; case 41: return {t:424,w:5.863631}; case 42: return {t:424,w:5.863631}; case 43: return {t:599,w:2.397895}; case 44: return {t:600,w:2.397895}; case 45: return {t:426,w:5.170484}; case 46: return {t:426,w:5.170484}; case 47: return {t:601,w:0.693147}; case 48: return {t:428,w:6.779922}; case 49: return {t:428,w:6.779922}; case 50: return {t:428,w:6.779922}; case 51: return {t:428,w:6.779922}; case 52: return {t:428,w:6.779922}; case 53: return {t:428,w:6.779922}; case 54: return {t:428,w:6.779922}; case 55: return {t:428,w:6.779922}; case 56: return {t:428,w:6.779922}; case 57: return {t:428,w:6.779922}; case 58: return {t:602,w:2.397895}; case 59: return {t:603,w:2.397895}; case 61: return {t:604,w:2.397895}; case 63: return {t:605,w:2.397895}; case 64: return {t:606,w:2.397895}; case 65: return {t:432,w:7.735434}; case 66: return {t:432,w:7.735434}; case 67: return {t:432,w:7.735434}; case 68: return {t:432,w:7.735434}; case 69: return {t:432,w:7.735434}; case 70: return {t:432,w:7.735434}; case 71: return {t:432,w:7.735434}; case 72: return {t:432,w:7.735434}; case 73: return {t:432,w:7.735434}; case 74: return {t:432,w:7.735434}; case 75: return {t:432,w:7.735434}; case 76: return {t:432,w:7.735434}; case 77: return {t:432,w:7.735434}; case 78: return {t:432,w:7.735434}; case 79: return {t:432,w:7.735434}; case 80: return {t:432,w:7.735434}; case 81: return {t:432,w:7.735434}; case 82: return {t:432,w:7.735434}; case 83: return {t:432,w:7.735434}; case 84: return {t:432,w:7.735434}; case 85: return {t:432,w:7.735434}; case 86: return {t:432,w:7.735434}; case 87: return {t:432,w:7.735434}; case 88: return {t:432,w:7.735434}; case 89: return {t:432,w:7.735434}; case 90: return {t:432,w:7.735434}; case 95: return {t:433,w:4.477337}; case 97: return {t:434,w:7.735434}; case 98: return {t:434,w:7.735434}; case 99: return {t:434,w:7.735434}; case 100: return {t:434,w:7.735434}; case 101: return {t:434,w:7.735434}; case 102: return {t:434,w:7.735434}; case 103: return {t:434,w:7.735434}; case 104: return {t:434,w:7.735434}; case 105: return {t:434,w:7.735434}; case 106: return {t:434,w:7.735434}; case 107: return {t:434,w:7.735434}; case 108: return {t:434,w:7.735434}; case 109: return {t:434,w:7.735434}; case 110: return {t:434,w:7.735434}; case 111: return {t:434,w:7.735434}; case 112: return {t:434,w:7.735434}; case 113: return {t:434,w:7.735434}; case 114: return {t:434,w:7.735434}; case 115: return {t:434,w:7.735434}; case 116: return {t:434,w:7.735434}; case 117: return {t:434,w:7.735434}; case 118: return {t:434,w:7.735434}; case 119: return {t:434,w:7.735434}; case 120: return {t:434,w:7.735434}; case 121: return {t:434,w:7.735434}; case 122: return {t:434,w:7.735434}; case 126: return {t:435,w:4.477337}; case 363: return {t:607,w:2.397895}; case 364: return {t:608,w:2.397895}; case 387: return {t:609,w:0.693147}; case 388: return {t:610,w:0.693147}; case 389: return {t:611,w:0.000000};default: return {t:0,w:0.0};}};
case 365: return function (act:Int) {switch (act) { case 258: return {t:612,w:0.000000};default: return {t:0,w:0.0};}};
case 366: return function (act:Int) {switch (act) { case 258: return {t:612,w:0.000000};default: return {t:0,w:0.0};}};
case 367: return function (act:Int) {switch (act) { case 73: return {t:59,w:0.693147}; case 105: return {t:59,w:0.693147};default: return {t:0,w:0.0};}};
case 368: return function (act:Int) {switch (act) { case 258: return {t:613,w:0.000000};default: return {t:0,w:0.0};}};
case 369: return function (act:Int) {switch (act) { case 258: return {t:614,w:0.000000};default: return {t:0,w:0.0};}};
case 370: return function (act:Int) {switch (act) { case 258: return {t:614,w:0.000000};default: return {t:0,w:0.0};}};
case 371: return function (act:Int) {switch (act) { case 258: return {t:614,w:0.000000};default: return {t:0,w:0.0};}};
case 372: return function (act:Int) {switch (act) { case 258: return {t:614,w:0.000000};default: return {t:0,w:0.0};}};
case 373: return function (act:Int) {switch (act) { case 258: return {t:614,w:0.000000};default: return {t:0,w:0.0};}};
case 374: return function (act:Int) {switch (act) { case 258: return {t:615,w:0.000000};default: return {t:0,w:0.0};}};
case 375: return function (act:Int) {switch (act) { case 258: return {t:616,w:0.000000};default: return {t:0,w:0.0};}};
case 376: return function (act:Int) {switch (act) { case 258: return {t:616,w:0.000000};default: return {t:0,w:0.0};}};
case 377: return function (act:Int) {switch (act) { case 258: return {t:616,w:0.000000};default: return {t:0,w:0.0};}};
case 378: return function (act:Int) {switch (act) { case 258: return {t:616,w:0.000000};default: return {t:0,w:0.0};}};
case 379: return function (act:Int) {switch (act) { case 258: return {t:616,w:0.000000};default: return {t:0,w:0.0};}};
case 380: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 381: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 382: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 383: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 384: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 385: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 386: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 387: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 388: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 389: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 390: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 391: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 392: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 393: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 394: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 395: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 396: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 397: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 398: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 399: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 400: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 401: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 402: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 403: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 404: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 405: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 406: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 407: return function (act:Int) {switch (act) { case 258: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 408: return function (act:Int) {switch (act) { case 258: return {t:618,w:0.000000};default: return {t:0,w:0.0};}};
case 409: return function (act:Int) {switch (act) { case 258: return {t:618,w:0.000000};default: return {t:0,w:0.0};}};
case 410: return function (act:Int) {switch (act) { case 258: return {t:618,w:0.000000};default: return {t:0,w:0.0};}};
case 411: return function (act:Int) {switch (act) { case 258: return {t:618,w:0.000000};default: return {t:0,w:0.0};}};
case 412: return function (act:Int) {switch (act) { case 258: return {t:618,w:0.000000};default: return {t:0,w:0.0};}};
case 413: return function (act:Int) {switch (act) { case 258: return {t:618,w:0.000000};default: return {t:0,w:0.0};}};
case 414: return function (act:Int) {switch (act) { case 258: return {t:618,w:0.000000};default: return {t:0,w:0.0};}};
case 415: return function (act:Int) {switch (act) { case 258: return {t:619,w:0.000000};default: return {t:0,w:0.0};}};
case 416: return function (act:Int) {switch (act) { case 258: return {t:619,w:0.000000};default: return {t:0,w:0.0};}};
case 417: return function (act:Int) {switch (act) { case 258: return {t:619,w:0.000000};default: return {t:0,w:0.0};}};
case 418: return function (act:Int) {switch (act) { case 258: return {t:619,w:0.000000};default: return {t:0,w:0.0};}};
case 419: return function (act:Int) {switch (act) { case 258: return {t:620,w:0.000000};default: return {t:0,w:0.0};}};
case 420: return function (act:Int) {switch (act) { case 258: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 421: return function (act:Int) {switch (act) { case 258: return {t:622,w:0.000000};default: return {t:0,w:0.0};}};
case 422: return function (act:Int) {switch (act) { case 256: return {t:623,w:4000000.000000}; case 390: return {t:624,w:0.000000};default: return {t:0,w:0.0};}};
case 423: return function (act:Int) {switch (act) { case 258: return {t:622,w:0.000000};default: return {t:0,w:0.0};}};
case 424: return function (act:Int) {switch (act) { case 258: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 425: return function (act:Int) {switch (act) { case 258: return {t:622,w:0.000000};default: return {t:0,w:0.0};}};
case 426: return function (act:Int) {switch (act) { case 258: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 427: return function (act:Int) {switch (act) { case 258: return {t:622,w:0.000000};default: return {t:0,w:0.0};}};
case 428: return function (act:Int) {switch (act) { case 258: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 429: return function (act:Int) {switch (act) { case 258: return {t:622,w:0.000000};default: return {t:0,w:0.0};}};
case 430: return function (act:Int) {switch (act) { case 258: return {t:622,w:0.000000};default: return {t:0,w:0.0};}};
case 431: return function (act:Int) {switch (act) { case 258: return {t:622,w:0.000000};default: return {t:0,w:0.0};}};
case 432: return function (act:Int) {switch (act) { case 258: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 433: return function (act:Int) {switch (act) { case 258: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 434: return function (act:Int) {switch (act) { case 258: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 435: return function (act:Int) {switch (act) { case 258: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 436: return function (act:Int) {switch (act) { case 258: return {t:625,w:0.000000};default: return {t:0,w:0.0};}};
case 437: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:627,w:0.000000};default: return {t:0,w:0.0};}};
case 438: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:628,w:0.000000};default: return {t:0,w:0.0};}};
case 439: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:629,w:0.000000};default: return {t:0,w:0.0};}};
case 440: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:630,w:0.000000};default: return {t:0,w:0.0};}};
case 441: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:631,w:0.000000};default: return {t:0,w:0.0};}};
case 442: return function (act:Int) {switch (act) { case 347: return {t:442,w:0.000000};default: return {t:0,w:0.0};}};
case 443: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 444: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 445: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 446: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 447: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 448: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 449: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 450: return function (act:Int) {switch (act) { case 258: return {t:641,w:0.000000};default: return {t:0,w:0.0};}};
case 451: return function (act:Int) {switch (act) { case 80: return {t:642,w:0.693147}; case 112: return {t:642,w:0.693147};default: return {t:0,w:0.0};}};
case 452: return function (act:Int) {switch (act) { case 84: return {t:643,w:0.693147}; case 116: return {t:643,w:0.693147};default: return {t:0,w:0.0};}};
case 453: return function (act:Int) {switch (act) { case 87: return {t:644,w:0.693147}; case 119: return {t:644,w:0.693147};default: return {t:0,w:0.0};}};
case 454: return function (act:Int) {switch (act) { case 69: return {t:645,w:0.693147}; case 79: return {t:646,w:0.693147}; case 101: return {t:645,w:0.693147}; case 111: return {t:646,w:0.693147};default: return {t:0,w:0.0};}};
case 455: return function (act:Int) {switch (act) { case 45: return {t:647,w:0.000000};default: return {t:0,w:0.0};}};
case 456: return function (act:Int) {switch (act) { case 65: return {t:648,w:1.386294}; case 69: return {t:649,w:0.693147}; case 97: return {t:648,w:1.386294}; case 101: return {t:649,w:0.693147};default: return {t:0,w:0.0};}};
case 457: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:650,w:0.000000};default: return {t:0,w:0.0};}};
case 458: return function (act:Int) {switch (act) { case 348: return {t:458,w:0.000000};default: return {t:0,w:0.0};}};
case 459: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 460: return function (act:Int) {switch (act) { case 258: return {t:652,w:0.000000};default: return {t:0,w:0.0};}};
case 461: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:460,w:0.000000};default: return {t:0,w:0.0};}};
case 462: return function (act:Int) {switch (act) { case 9: return {t:296,w:0.000000}; case 32: return {t:78,w:0.000000};default: return {t:0,w:0.0};}};
case 463: return function (act:Int) {switch (act) { case 58: return {t:461,w:0.693147}; case 256: return {t:462,w:4000001.500000}; case 278: return {t:463,w:1.386294}; case 348: return {t:464,w:1.386294};default: return {t:0,w:0.0};}};
case 464: return function (act:Int) {switch (act) { case 58: return {t:461,w:0.693147}; case 256: return {t:462,w:4000001.500000}; case 278: return {t:463,w:1.386294}; case 348: return {t:464,w:1.386294};default: return {t:0,w:0.0};}};
case 465: return function (act:Int) {switch (act) { case 80: return {t:653,w:0.693147}; case 85: return {t:654,w:0.693147}; case 112: return {t:653,w:0.693147}; case 117: return {t:654,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 466: return function (act:Int) {switch (act) { case 77: return {t:655,w:0.693147}; case 109: return {t:655,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 467: return function (act:Int) {switch (act) { case 69: return {t:656,w:0.693147}; case 85: return {t:657,w:0.693147}; case 101: return {t:656,w:0.693147}; case 117: return {t:657,w:0.693147}; case 258: return {t:52,w:6.754604};default: return {t:0,w:0.0};}};
case 468: return function (act:Int) {switch (act) { case 69: return {t:658,w:0.693147}; case 101: return {t:658,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 469: return function (act:Int) {switch (act) { case 73: return {t:659,w:0.693147}; case 105: return {t:659,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 470: return function (act:Int) {switch (act) { case 45: return {t:660,w:0.000000}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 471: return function (act:Int) {switch (act) { case 80: return {t:653,w:0.693147}; case 85: return {t:654,w:0.693147}; case 112: return {t:653,w:0.693147}; case 117: return {t:654,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 472: return function (act:Int) {switch (act) { case 77: return {t:655,w:0.693147}; case 109: return {t:655,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 473: return function (act:Int) {switch (act) { case 69: return {t:656,w:0.693147}; case 85: return {t:657,w:0.693147}; case 101: return {t:656,w:0.693147}; case 117: return {t:657,w:0.693147}; case 258: return {t:52,w:6.754604};default: return {t:0,w:0.0};}};
case 474: return function (act:Int) {switch (act) { case 69: return {t:658,w:0.693147}; case 101: return {t:658,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 475: return function (act:Int) {switch (act) { case 73: return {t:659,w:0.693147}; case 105: return {t:659,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 476: return function (act:Int) {switch (act) { case 45: return {t:660,w:0.000000}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 477: return function (act:Int) {switch (act) { case 258: return {t:661,w:0.000000};default: return {t:0,w:0.0};}};
case 478: return function (act:Int) {switch (act) { case 258: return {t:662,w:0.000000};default: return {t:0,w:0.0};}};
case 479: return function (act:Int) {switch (act) { case 258: return {t:662,w:0.000000};default: return {t:0,w:0.0};}};
case 480: return function (act:Int) {switch (act) { case 258: return {t:663,w:0.000000};default: return {t:0,w:0.0};}};
case 481: return function (act:Int) {switch (act) { case 258: return {t:664,w:0.000000};default: return {t:0,w:0.0};}};
case 482: return function (act:Int) {switch (act) { case 258: return {t:664,w:0.000000};default: return {t:0,w:0.0};}};
case 483: return function (act:Int) {switch (act) { case 256: return {t:665,w:4000000.000000}; case 391: return {t:666,w:0.000000};default: return {t:0,w:0.0};}};
case 484: return function (act:Int) {switch (act) { case 298: return {t:484,w:0.000000};default: return {t:0,w:0.0};}};
case 485: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:667,w:0.000000};default: return {t:0,w:0.0};}};
case 486: return function (act:Int) {switch (act) { case 82: return {t:668,w:0.693147}; case 114: return {t:668,w:0.693147};default: return {t:0,w:0.0};}};
case 487: return function (act:Int) {switch (act) { case 82: return {t:669,w:0.693147}; case 114: return {t:669,w:0.693147};default: return {t:0,w:0.0};}};
case 488: return function (act:Int) {switch (act) { case 258: return {t:670,w:0.000000};default: return {t:0,w:0.0};}};
case 489: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:671,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 490: return function (act:Int) {switch (act) { case 295: return {t:490,w:0.000000};default: return {t:0,w:0.0};}};
case 491: return function (act:Int) {switch (act) { case 256: return {t:305,w:4000000.000000}; case 350: return {t:672,w:0.000000};default: return {t:0,w:0.0};}};
case 492: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:219,w:0.000000};default: return {t:0,w:0.0};}};
case 493: return function (act:Int) {switch (act) { case 258: return {t:673,w:0.000000};default: return {t:0,w:0.0};}};
case 494: return function (act:Int) {switch (act) { case 258: return {t:673,w:0.000000};default: return {t:0,w:0.0};}};
case 495: return function (act:Int) {switch (act) { case 258: return {t:674,w:0.000000};default: return {t:0,w:0.0};}};
case 496: return function (act:Int) {switch (act) { case 73: return {t:259,w:0.693147}; case 105: return {t:259,w:0.693147}; case 258: return {t:674,w:3.258097};default: return {t:0,w:0.0};}};
case 497: return function (act:Int) {switch (act) { case 258: return {t:674,w:0.000000};default: return {t:0,w:0.0};}};
case 498: return function (act:Int) {switch (act) { case 73: return {t:259,w:0.693147}; case 105: return {t:259,w:0.693147}; case 258: return {t:674,w:3.258097};default: return {t:0,w:0.0};}};
case 499: return function (act:Int) {switch (act) { case 368: return {t:651,w:0.000000}; case 380: return {t:675,w:0.693147};default: return {t:0,w:0.0};}};
case 500: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.000000}; case 377: return {t:677,w:0.000000};default: return {t:0,w:0.0};}};
case 501: return function (act:Int) {switch (act) { case 258: return {t:678,w:0.000000};default: return {t:0,w:0.0};}};
case 502: return function (act:Int) {switch (act) { case 258: return {t:678,w:0.000000};default: return {t:0,w:0.0};}};
case 503: return function (act:Int) {switch (act) { case 258: return {t:678,w:0.000000};default: return {t:0,w:0.0};}};
case 504: return function (act:Int) {switch (act) { case 256: return {t:679,w:4000000.000000}; case 376: return {t:680,w:0.000000};default: return {t:0,w:0.0};}};
case 505: return function (act:Int) {switch (act) { case 256: return {t:681,w:4000000.750000}; case 258: return {t:682,w:0.693147}; case 279: return {t:683,w:1.386294}; case 376: return {t:684,w:0.693147};default: return {t:0,w:0.0};}};
case 506: return function (act:Int) {switch (act) { case 258: return {t:685,w:0.000000};default: return {t:0,w:0.0};}};
case 507: return function (act:Int) {switch (act) { case 60: return {t:686,w:0.000000}; case 256: return {t:687,w:4000000.750000}; case 381: return {t:688,w:0.693147};default: return {t:0,w:0.0};}};
case 508: return function (act:Int) {switch (act) { case 258: return {t:689,w:0.000000};default: return {t:0,w:0.0};}};
case 509: return function (act:Int) {switch (act) { case 256: return {t:690,w:4000000.000000}; case 357: return {t:691,w:0.000000};default: return {t:0,w:0.0};}};
case 510: return function (act:Int) {switch (act) { case 256: return {t:692,w:4000000.000000}; case 379: return {t:693,w:0.000000};default: return {t:0,w:0.0};}};
case 511: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:694,w:0.693147}; case 384: return {t:695,w:0.693147};default: return {t:0,w:0.0};}};
case 512: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:694,w:0.693147}; case 384: return {t:695,w:0.693147};default: return {t:0,w:0.0};}};
case 513: return function (act:Int) {switch (act) { case 303: return {t:513,w:0.000000};default: return {t:0,w:0.0};}};
case 514: return function (act:Int) {switch (act) { case 69: return {t:696,w:0.693147}; case 101: return {t:696,w:0.693147};default: return {t:0,w:0.0};}};
case 515: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 516: return function (act:Int) {switch (act) { case 258: return {t:723,w:0.000000};default: return {t:0,w:0.0};}};
case 517: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 518: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 519: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 520: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 521: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 522: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 523: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 524: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 525: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 526: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 527: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 528: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 529: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 530: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 531: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 532: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 533: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 534: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 535: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 536: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 537: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 538: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 539: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 540: return function (act:Int) {switch (act) { case 64: return {t:724,w:0.693147}; case 258: return {t:725,w:0.693147};default: return {t:0,w:0.0};}};
case 541: return function (act:Int) {switch (act) { case 291: return {t:541,w:0.000000};default: return {t:0,w:0.0};}};
case 542: return function (act:Int) {switch (act) { case 258: return {t:726,w:0.000000};default: return {t:0,w:0.0};}};
case 543: return function (act:Int) {switch (act) { case 256: return {t:313,w:4000000.000000}; case 353: return {t:727,w:0.000000};default: return {t:0,w:0.0};}};
case 544: return function (act:Int) {switch (act) { case 297: return {t:544,w:0.000000};default: return {t:0,w:0.0};}};
case 545: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:544,w:0.693147}; case 336: return {t:545,w:0.693147};default: return {t:0,w:0.0};}};
case 546: return function (act:Int) {switch (act) { case 70: return {t:728,w:0.693147}; case 102: return {t:728,w:0.693147};default: return {t:0,w:0.0};}};
case 547: return function (act:Int) {switch (act) { case 45: return {t:729,w:0.000000};default: return {t:0,w:0.0};}};
case 548: return function (act:Int) {switch (act) { case 69: return {t:730,w:0.693147}; case 101: return {t:730,w:0.693147};default: return {t:0,w:0.0};}};
case 549: return function (act:Int) {switch (act) { case 368: return {t:651,w:0.000000}; case 380: return {t:675,w:2.079441};default: return {t:0,w:0.0};}};
case 550: return function (act:Int) {switch (act) { case 42: return {t:731,w:0.000000}; case 60: return {t:686,w:1.386294}; case 256: return {t:687,w:4000002.000000}; case 381: return {t:688,w:2.079441};default: return {t:0,w:0.0};}};
case 551: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:732,w:0.693147}; case 384: return {t:733,w:0.693147};default: return {t:0,w:0.0};}};
case 552: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:732,w:0.693147}; case 384: return {t:733,w:0.693147};default: return {t:0,w:0.0};}};
case 553: return function (act:Int) {switch (act) { case 293: return {t:553,w:0.000000};default: return {t:0,w:0.0};}};
case 554: return function (act:Int) {switch (act) { case 256: return {t:734,w:4000000.000000}; case 355: return {t:735,w:0.000000};default: return {t:0,w:0.0};}};
case 555: return function (act:Int) {switch (act) { case 78: return {t:736,w:0.693147}; case 110: return {t:736,w:0.693147};default: return {t:0,w:0.0};}};
case 556: return function (act:Int) {switch (act) { case 82: return {t:737,w:0.693147}; case 114: return {t:737,w:0.693147};default: return {t:0,w:0.0};}};
case 557: return function (act:Int) {switch (act) { case 89: return {t:738,w:0.693147}; case 121: return {t:738,w:0.693147};default: return {t:0,w:0.0};}};
case 558: return function (act:Int) {switch (act) { case 82: return {t:739,w:0.693147}; case 114: return {t:739,w:0.693147};default: return {t:0,w:0.0};}};
case 559: return function (act:Int) {switch (act) { case 89: return {t:740,w:0.693147}; case 121: return {t:740,w:0.693147};default: return {t:0,w:0.0};}};
case 560: return function (act:Int) {switch (act) { case 73: return {t:741,w:0.693147}; case 105: return {t:741,w:0.693147};default: return {t:0,w:0.0};}};
case 561: return function (act:Int) {switch (act) { case 89: return {t:742,w:0.693147}; case 121: return {t:742,w:0.693147};default: return {t:0,w:0.0};}};
case 562: return function (act:Int) {switch (act) { case 69: return {t:743,w:0.693147}; case 101: return {t:743,w:0.693147};default: return {t:0,w:0.0};}};
case 563: return function (act:Int) {switch (act) { case 69: return {t:744,w:0.693147}; case 101: return {t:744,w:0.693147};default: return {t:0,w:0.0};}};
case 564: return function (act:Int) {switch (act) { case 69: return {t:745,w:0.693147}; case 101: return {t:745,w:0.693147};default: return {t:0,w:0.0};}};
case 565: return function (act:Int) {switch (act) { case 79: return {t:746,w:0.693147}; case 111: return {t:746,w:0.693147};default: return {t:0,w:0.0};}};
case 566: return function (act:Int) {switch (act) { case 258: return {t:747,w:0.000000};default: return {t:0,w:0.0};}};
case 567: return function (act:Int) {switch (act) { case 258: return {t:747,w:0.000000};default: return {t:0,w:0.0};}};
case 568: return function (act:Int) {switch (act) { case 256: return {t:748,w:4000000.750000}; case 258: return {t:749,w:1.386294}; case 377: return {t:750,w:2.079441}; case 383: return {t:751,w:0.693147};default: return {t:0,w:0.0};}};
case 569: return function (act:Int) {switch (act) { case 83: return {t:752,w:0.693147}; case 115: return {t:752,w:0.693147};default: return {t:0,w:0.0};}};
case 570: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:753,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 571: return function (act:Int) {switch (act) { case 322: return {t:571,w:0.000000};default: return {t:0,w:0.0};}};
case 572: return function (act:Int) {switch (act) { case 256: return {t:754,w:4000000.000000}; case 392: return {t:755,w:0.000000};default: return {t:0,w:0.0};}};
case 573: return function (act:Int) {switch (act) { case 80: return {t:756,w:0.693147}; case 112: return {t:756,w:0.693147};default: return {t:0,w:0.0};}};
case 574: return function (act:Int) {switch (act) { case 45: return {t:757,w:0.000000};default: return {t:0,w:0.0};}};
case 575: return function (act:Int) {switch (act) { case 73: return {t:758,w:0.693147}; case 105: return {t:758,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 576: return function (act:Int) {switch (act) { case 73: return {t:758,w:0.693147}; case 105: return {t:758,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 577: return function (act:Int) {switch (act) { case 258: return {t:759,w:0.000000};default: return {t:0,w:0.0};}};
case 578: return function (act:Int) {switch (act) { case 256: return {t:665,w:4000000.000000}; case 391: return {t:760,w:0.000000};default: return {t:0,w:0.0};}};
case 579: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.000000}; case 377: return {t:761,w:0.000000};default: return {t:0,w:0.0};}};
case 580: return function (act:Int) {switch (act) { case 325: return {t:580,w:0.000000};default: return {t:0,w:0.0};}};
case 581: return function (act:Int) {switch (act) { case 256: return {t:344,w:4000000.000000}; case 359: return {t:762,w:0.000000};default: return {t:0,w:0.0};}};
case 582: return function (act:Int) {switch (act) { case 73: return {t:763,w:0.693147}; case 105: return {t:763,w:0.693147};default: return {t:0,w:0.0};}};
case 583: return function (act:Int) {switch (act) { case 65: return {t:764,w:0.693147}; case 97: return {t:764,w:0.693147};default: return {t:0,w:0.0};}};
case 584: return function (act:Int) {switch (act) { case 345: return {t:584,w:0.000000};default: return {t:0,w:0.0};}};
case 585: return function (act:Int) {switch (act) { case 360: return {t:585,w:0.000000};default: return {t:0,w:0.0};}};
case 586: return function (act:Int) {switch (act) { case 256: return {t:765,w:4000001.750000}; case 258: return {t:766,w:0.693147}; case 366: return {t:768,w:1.791759}; case 377: return {t:767,w:1.791759}; case 383: return {t:769,w:1.791759};default: return {t:0,w:0.0};}};
case 587: return function (act:Int) {switch (act) { case 256: return {t:765,w:4000001.750000}; case 258: return {t:766,w:0.693147}; case 366: return {t:768,w:1.791759}; case 377: return {t:767,w:1.791759}; case 383: return {t:769,w:1.791759};default: return {t:0,w:0.0};}};
case 588: return function (act:Int) {switch (act) { case 256: return {t:765,w:4000001.750000}; case 258: return {t:766,w:0.693147}; case 366: return {t:768,w:1.791759}; case 377: return {t:767,w:1.791759}; case 383: return {t:769,w:1.791759};default: return {t:0,w:0.0};}};
case 589: return function (act:Int) {switch (act) { case 329: return {t:589,w:0.000000};default: return {t:0,w:0.0};}};
case 590: return function (act:Int) {switch (act) { case 266: return {t:590,w:0.000000};default: return {t:0,w:0.0};}};
case 591: return function (act:Int) {switch (act) { case 262: return {t:591,w:0.000000};default: return {t:0,w:0.0};}};
case 592: return function (act:Int) {switch (act) { case 258: return {t:770,w:0.000000};default: return {t:0,w:0.0};}};
case 593: return function (act:Int) {switch (act) { case 82: return {t:771,w:0.000000};default: return {t:0,w:0.0};}};
case 594: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:772,w:0.693147}; case 336: return {t:773,w:0.693147};default: return {t:0,w:0.0};}};
case 595: return function (act:Int) {switch (act) { case 256: return {t:774,w:4000000.750000}; case 393: return {t:775,w:0.693147}; case 394: return {t:776,w:0.693147};default: return {t:0,w:0.0};}};
case 596: return function (act:Int) {switch (act) { case 58: return {t:777,w:0.000000};default: return {t:0,w:0.0};}};
case 597: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 598: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 599: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 600: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 601: return function (act:Int) {switch (act) { case 47: return {t:779,w:0.000000}; case 256: return {t:780,w:4000000.000000}; case 395: return {t:781,w:0.000000};default: return {t:0,w:0.0};}};
case 602: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 603: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 604: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 605: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 606: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 607: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 608: return function (act:Int) {switch (act) { case 258: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 609: return function (act:Int) {switch (act) { case 63: return {t:782,w:0.693147}; case 258: return {t:783,w:0.693147};default: return {t:0,w:0.0};}};
case 610: return function (act:Int) {switch (act) { case 63: return {t:782,w:0.693147}; case 258: return {t:783,w:0.693147};default: return {t:0,w:0.0};}};
case 611: return function (act:Int) {switch (act) { case 256: return {t:784,w:4000000.750000}; case 258: return {t:785,w:0.693147}; case 396: return {t:786,w:0.693147};default: return {t:0,w:0.0};}};
case 612: return function (act:Int) {switch (act) { case 335: return {t:612,w:0.000000};default: return {t:0,w:0.0};}};
case 613: return function (act:Int) {switch (act) { case 273: return {t:613,w:0.000000};default: return {t:0,w:0.0};}};
case 614: return function (act:Int) {switch (act) { case 337: return {t:614,w:0.000000};default: return {t:0,w:0.0};}};
case 615: return function (act:Int) {switch (act) { case 339: return {t:615,w:0.000000};default: return {t:0,w:0.0};}};
case 616: return function (act:Int) {switch (act) { case 338: return {t:616,w:0.000000};default: return {t:0,w:0.0};}};
case 617: return function (act:Int) {switch (act) { case 340: return {t:617,w:0.000000};default: return {t:0,w:0.0};}};
case 618: return function (act:Int) {switch (act) { case 341: return {t:618,w:0.000000};default: return {t:0,w:0.0};}};
case 619: return function (act:Int) {switch (act) { case 342: return {t:619,w:0.000000};default: return {t:0,w:0.0};}};
case 620: return function (act:Int) {switch (act) { case 343: return {t:620,w:0.000000};default: return {t:0,w:0.0};}};
case 621: return function (act:Int) {switch (act) { case 363: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 622: return function (act:Int) {switch (act) { case 365: return {t:622,w:0.000000};default: return {t:0,w:0.0};}};
case 623: return function (act:Int) {switch (act) { case 48: return {t:787,w:3.401197}; case 49: return {t:787,w:3.401197}; case 50: return {t:787,w:3.401197}; case 51: return {t:787,w:3.401197}; case 52: return {t:787,w:3.401197}; case 53: return {t:787,w:3.401197}; case 54: return {t:787,w:3.401197}; case 55: return {t:787,w:3.401197}; case 56: return {t:787,w:3.401197}; case 57: return {t:787,w:3.401197}; case 65: return {t:788,w:2.890371}; case 66: return {t:788,w:2.890371}; case 67: return {t:788,w:2.890371}; case 68: return {t:788,w:2.890371}; case 69: return {t:788,w:2.890371}; case 70: return {t:788,w:2.890371}; case 97: return {t:789,w:2.890371}; case 98: return {t:789,w:2.890371}; case 99: return {t:789,w:2.890371}; case 100: return {t:789,w:2.890371}; case 101: return {t:789,w:2.890371}; case 102: return {t:789,w:2.890371};default: return {t:0,w:0.0};}};
case 624: return function (act:Int) {switch (act) { case 256: return {t:623,w:4000000.000000}; case 390: return {t:790,w:0.000000};default: return {t:0,w:0.0};}};
case 625: return function (act:Int) {switch (act) { case 366: return {t:625,w:0.000000};default: return {t:0,w:0.0};}};
case 626: return function (act:Int) {switch (act) { case 128: return {t:436,w:4.158883}; case 129: return {t:436,w:4.158883}; case 130: return {t:436,w:4.158883}; case 131: return {t:436,w:4.158883}; case 132: return {t:436,w:4.158883}; case 133: return {t:436,w:4.158883}; case 134: return {t:436,w:4.158883}; case 135: return {t:436,w:4.158883}; case 136: return {t:436,w:4.158883}; case 137: return {t:436,w:4.158883}; case 138: return {t:436,w:4.158883}; case 139: return {t:436,w:4.158883}; case 140: return {t:436,w:4.158883}; case 141: return {t:436,w:4.158883}; case 142: return {t:436,w:4.158883}; case 143: return {t:436,w:4.158883}; case 144: return {t:436,w:4.158883}; case 145: return {t:436,w:4.158883}; case 146: return {t:436,w:4.158883}; case 147: return {t:436,w:4.158883}; case 148: return {t:436,w:4.158883}; case 149: return {t:436,w:4.158883}; case 150: return {t:436,w:4.158883}; case 151: return {t:436,w:4.158883}; case 152: return {t:436,w:4.158883}; case 153: return {t:436,w:4.158883}; case 154: return {t:436,w:4.158883}; case 155: return {t:436,w:4.158883}; case 156: return {t:436,w:4.158883}; case 157: return {t:436,w:4.158883}; case 158: return {t:436,w:4.158883}; case 159: return {t:436,w:4.158883}; case 160: return {t:436,w:4.158883}; case 161: return {t:436,w:4.158883}; case 162: return {t:436,w:4.158883}; case 163: return {t:436,w:4.158883}; case 164: return {t:436,w:4.158883}; case 165: return {t:436,w:4.158883}; case 166: return {t:436,w:4.158883}; case 167: return {t:436,w:4.158883}; case 168: return {t:436,w:4.158883}; case 169: return {t:436,w:4.158883}; case 170: return {t:436,w:4.158883}; case 171: return {t:436,w:4.158883}; case 172: return {t:436,w:4.158883}; case 173: return {t:436,w:4.158883}; case 174: return {t:436,w:4.158883}; case 175: return {t:436,w:4.158883}; case 176: return {t:436,w:4.158883}; case 177: return {t:436,w:4.158883}; case 178: return {t:436,w:4.158883}; case 179: return {t:436,w:4.158883}; case 180: return {t:436,w:4.158883}; case 181: return {t:436,w:4.158883}; case 182: return {t:436,w:4.158883}; case 183: return {t:436,w:4.158883}; case 184: return {t:436,w:4.158883}; case 185: return {t:436,w:4.158883}; case 186: return {t:436,w:4.158883}; case 187: return {t:436,w:4.158883}; case 188: return {t:436,w:4.158883}; case 189: return {t:436,w:4.158883}; case 190: return {t:436,w:4.158883}; case 191: return {t:436,w:4.158883};default: return {t:0,w:0.0};}};
case 627: return function (act:Int) {switch (act) { case 258: return {t:791,w:0.000000};default: return {t:0,w:0.0};}};
case 628: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:792,w:0.000000};default: return {t:0,w:0.0};}};
case 629: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:793,w:0.000000};default: return {t:0,w:0.0};}};
case 630: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:794,w:0.000000};default: return {t:0,w:0.0};}};
case 631: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:795,w:0.000000};default: return {t:0,w:0.0};}};
case 632: return function (act:Int) {switch (act) { case 9: return {t:296,w:0.000000}; case 32: return {t:78,w:0.000000}; case 33: return {t:420,w:2.079442}; case 36: return {t:421,w:1.945910}; case 37: return {t:422,w:0.000000}; case 38: return {t:423,w:1.945910}; case 39: return {t:424,w:3.465736}; case 40: return {t:424,w:3.465736}; case 41: return {t:424,w:3.465736}; case 42: return {t:424,w:3.465736}; case 43: return {t:425,w:2.639057}; case 44: return {t:425,w:2.639057}; case 45: return {t:426,w:2.772589}; case 46: return {t:426,w:2.772589}; case 47: return {t:427,w:1.945910}; case 48: return {t:428,w:4.382027}; case 49: return {t:428,w:4.382027}; case 50: return {t:428,w:4.382027}; case 51: return {t:428,w:4.382027}; case 52: return {t:428,w:4.382027}; case 53: return {t:428,w:4.382027}; case 54: return {t:428,w:4.382027}; case 55: return {t:428,w:4.382027}; case 56: return {t:428,w:4.382027}; case 57: return {t:428,w:4.382027}; case 58: return {t:429,w:2.639057}; case 59: return {t:429,w:2.639057}; case 61: return {t:430,w:1.945910}; case 63: return {t:431,w:2.639057}; case 64: return {t:431,w:2.639057}; case 65: return {t:432,w:5.337539}; case 66: return {t:432,w:5.337539}; case 67: return {t:432,w:5.337539}; case 68: return {t:432,w:5.337539}; case 69: return {t:432,w:5.337539}; case 70: return {t:432,w:5.337539}; case 71: return {t:432,w:5.337539}; case 72: return {t:432,w:5.337539}; case 73: return {t:432,w:5.337539}; case 74: return {t:432,w:5.337539}; case 75: return {t:432,w:5.337539}; case 76: return {t:432,w:5.337539}; case 77: return {t:432,w:5.337539}; case 78: return {t:432,w:5.337539}; case 79: return {t:432,w:5.337539}; case 80: return {t:432,w:5.337539}; case 81: return {t:432,w:5.337539}; case 82: return {t:432,w:5.337539}; case 83: return {t:432,w:5.337539}; case 84: return {t:432,w:5.337539}; case 85: return {t:432,w:5.337539}; case 86: return {t:432,w:5.337539}; case 87: return {t:432,w:5.337539}; case 88: return {t:432,w:5.337539}; case 89: return {t:432,w:5.337539}; case 90: return {t:432,w:5.337539}; case 95: return {t:433,w:2.079442}; case 97: return {t:434,w:5.337539}; case 98: return {t:434,w:5.337539}; case 99: return {t:434,w:5.337539}; case 100: return {t:434,w:5.337539}; case 101: return {t:434,w:5.337539}; case 102: return {t:434,w:5.337539}; case 103: return {t:434,w:5.337539}; case 104: return {t:434,w:5.337539}; case 105: return {t:434,w:5.337539}; case 106: return {t:434,w:5.337539}; case 107: return {t:434,w:5.337539}; case 108: return {t:434,w:5.337539}; case 109: return {t:434,w:5.337539}; case 110: return {t:434,w:5.337539}; case 111: return {t:434,w:5.337539}; case 112: return {t:434,w:5.337539}; case 113: return {t:434,w:5.337539}; case 114: return {t:434,w:5.337539}; case 115: return {t:434,w:5.337539}; case 116: return {t:434,w:5.337539}; case 117: return {t:434,w:5.337539}; case 118: return {t:434,w:5.337539}; case 119: return {t:434,w:5.337539}; case 120: return {t:434,w:5.337539}; case 121: return {t:434,w:5.337539}; case 122: return {t:434,w:5.337539}; case 126: return {t:435,w:2.079442}; case 128: return {t:436,w:4.158883}; case 129: return {t:436,w:4.158883}; case 130: return {t:436,w:4.158883}; case 131: return {t:436,w:4.158883}; case 132: return {t:436,w:4.158883}; case 133: return {t:436,w:4.158883}; case 134: return {t:436,w:4.158883}; case 135: return {t:436,w:4.158883}; case 136: return {t:436,w:4.158883}; case 137: return {t:436,w:4.158883}; case 138: return {t:436,w:4.158883}; case 139: return {t:436,w:4.158883}; case 140: return {t:436,w:4.158883}; case 141: return {t:436,w:4.158883}; case 142: return {t:436,w:4.158883}; case 143: return {t:436,w:4.158883}; case 144: return {t:436,w:4.158883}; case 145: return {t:436,w:4.158883}; case 146: return {t:436,w:4.158883}; case 147: return {t:436,w:4.158883}; case 148: return {t:436,w:4.158883}; case 149: return {t:436,w:4.158883}; case 150: return {t:436,w:4.158883}; case 151: return {t:436,w:4.158883}; case 152: return {t:436,w:4.158883}; case 153: return {t:436,w:4.158883}; case 154: return {t:436,w:4.158883}; case 155: return {t:436,w:4.158883}; case 156: return {t:436,w:4.158883}; case 157: return {t:436,w:4.158883}; case 158: return {t:436,w:4.158883}; case 159: return {t:436,w:4.158883}; case 160: return {t:436,w:4.158883}; case 161: return {t:436,w:4.158883}; case 162: return {t:436,w:4.158883}; case 163: return {t:436,w:4.158883}; case 164: return {t:436,w:4.158883}; case 165: return {t:436,w:4.158883}; case 166: return {t:436,w:4.158883}; case 167: return {t:436,w:4.158883}; case 168: return {t:436,w:4.158883}; case 169: return {t:436,w:4.158883}; case 170: return {t:436,w:4.158883}; case 171: return {t:436,w:4.158883}; case 172: return {t:436,w:4.158883}; case 173: return {t:436,w:4.158883}; case 174: return {t:436,w:4.158883}; case 175: return {t:436,w:4.158883}; case 176: return {t:436,w:4.158883}; case 177: return {t:436,w:4.158883}; case 178: return {t:436,w:4.158883}; case 179: return {t:436,w:4.158883}; case 180: return {t:436,w:4.158883}; case 181: return {t:436,w:4.158883}; case 182: return {t:436,w:4.158883}; case 183: return {t:436,w:4.158883}; case 184: return {t:436,w:4.158883}; case 185: return {t:436,w:4.158883}; case 186: return {t:436,w:4.158883}; case 187: return {t:436,w:4.158883}; case 188: return {t:436,w:4.158883}; case 189: return {t:436,w:4.158883}; case 190: return {t:436,w:4.158883}; case 191: return {t:436,w:4.158883}; case 192: return {t:437,w:5.075174}; case 193: return {t:437,w:5.075174}; case 194: return {t:437,w:5.075174}; case 195: return {t:437,w:5.075174}; case 196: return {t:437,w:5.075174}; case 197: return {t:437,w:5.075174}; case 198: return {t:437,w:5.075174}; case 199: return {t:437,w:5.075174}; case 200: return {t:437,w:5.075174}; case 201: return {t:437,w:5.075174}; case 202: return {t:437,w:5.075174}; case 203: return {t:437,w:5.075174}; case 204: return {t:437,w:5.075174}; case 205: return {t:437,w:5.075174}; case 206: return {t:437,w:5.075174}; case 207: return {t:437,w:5.075174}; case 208: return {t:437,w:5.075174}; case 209: return {t:437,w:5.075174}; case 210: return {t:437,w:5.075174}; case 211: return {t:437,w:5.075174}; case 212: return {t:437,w:5.075174}; case 213: return {t:437,w:5.075174}; case 214: return {t:437,w:5.075174}; case 215: return {t:437,w:5.075174}; case 216: return {t:437,w:5.075174}; case 217: return {t:437,w:5.075174}; case 218: return {t:437,w:5.075174}; case 219: return {t:437,w:5.075174}; case 220: return {t:437,w:5.075174}; case 221: return {t:437,w:5.075174}; case 222: return {t:437,w:5.075174}; case 223: return {t:437,w:5.075174}; case 224: return {t:438,w:4.382027}; case 225: return {t:438,w:4.382027}; case 226: return {t:438,w:4.382027}; case 227: return {t:438,w:4.382027}; case 228: return {t:438,w:4.382027}; case 229: return {t:438,w:4.382027}; case 230: return {t:438,w:4.382027}; case 231: return {t:438,w:4.382027}; case 232: return {t:438,w:4.382027}; case 233: return {t:438,w:4.382027}; case 234: return {t:438,w:4.382027}; case 235: return {t:438,w:4.382027}; case 236: return {t:438,w:4.382027}; case 237: return {t:438,w:4.382027}; case 238: return {t:438,w:4.382027}; case 239: return {t:438,w:4.382027}; case 240: return {t:439,w:3.688880}; case 241: return {t:439,w:3.688880}; case 242: return {t:439,w:3.688880}; case 243: return {t:439,w:3.688880}; case 244: return {t:439,w:3.688880}; case 245: return {t:439,w:3.688880}; case 246: return {t:439,w:3.688880}; case 247: return {t:439,w:3.688880}; case 248: return {t:440,w:2.995732}; case 249: return {t:440,w:2.995732}; case 250: return {t:440,w:2.995732}; case 251: return {t:440,w:2.995732}; case 252: return {t:441,w:2.302585}; case 253: return {t:441,w:2.302585};default: return {t:0,w:0.0};}};
case 633: return function (act:Int) {switch (act) { case 347: return {t:633,w:0.000000};default: return {t:0,w:0.0};}};
case 634: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 635: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 636: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 637: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 638: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 639: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 640: return function (act:Int) {switch (act) { case 256: return {t:632,w:4000002.750000}; case 258: return {t:633,w:0.693147}; case 278: return {t:634,w:2.639057}; case 348: return {t:638,w:2.639057}; case 363: return {t:635,w:2.639057}; case 364: return {t:636,w:2.639057}; case 365: return {t:637,w:2.639057}; case 366: return {t:639,w:2.639057}; case 367: return {t:640,w:2.639057};default: return {t:0,w:0.0};}};
case 641: return function (act:Int) {switch (act) { case 275: return {t:641,w:0.000000};default: return {t:0,w:0.0};}};
case 642: return function (act:Int) {switch (act) { case 84: return {t:796,w:0.693147}; case 116: return {t:796,w:0.693147};default: return {t:0,w:0.0};}};
case 643: return function (act:Int) {switch (act) { case 45: return {t:797,w:0.000000};default: return {t:0,w:0.0};}};
case 644: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:798,w:0.000000};default: return {t:0,w:0.0};}};
case 645: return function (act:Int) {switch (act) { case 78: return {t:799,w:0.693147}; case 110: return {t:799,w:0.693147};default: return {t:0,w:0.0};}};
case 646: return function (act:Int) {switch (act) { case 82: return {t:800,w:0.693147}; case 114: return {t:800,w:0.693147};default: return {t:0,w:0.0};}};
case 647: return function (act:Int) {switch (act) { case 73: return {t:801,w:0.693147}; case 105: return {t:801,w:0.693147};default: return {t:0,w:0.0};}};
case 648: return function (act:Int) {switch (act) { case 67: return {t:802,w:0.693147}; case 99: return {t:802,w:0.693147};default: return {t:0,w:0.0};}};
case 649: return function (act:Int) {switch (act) { case 78: return {t:803,w:0.693147}; case 110: return {t:803,w:0.693147};default: return {t:0,w:0.0};}};
case 650: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:804,w:0.000000};default: return {t:0,w:0.0};}};
case 651: return function (act:Int) {switch (act) { case 368: return {t:651,w:0.000000};default: return {t:0,w:0.0};}};
case 652: return function (act:Int) {switch (act) { case 344: return {t:652,w:0.000000};default: return {t:0,w:0.0};}};
case 653: return function (act:Int) {switch (act) { case 80: return {t:805,w:0.693147}; case 112: return {t:805,w:0.693147};default: return {t:0,w:0.0};}};
case 654: return function (act:Int) {switch (act) { case 68: return {t:806,w:0.693147}; case 100: return {t:806,w:0.693147};default: return {t:0,w:0.0};}};
case 655: return function (act:Int) {switch (act) { case 65: return {t:807,w:0.693147}; case 97: return {t:807,w:0.693147};default: return {t:0,w:0.0};}};
case 656: return function (act:Int) {switch (act) { case 83: return {t:808,w:0.693147}; case 115: return {t:808,w:0.693147};default: return {t:0,w:0.0};}};
case 657: return function (act:Int) {switch (act) { case 76: return {t:809,w:0.693147}; case 108: return {t:809,w:0.693147};default: return {t:0,w:0.0};}};
case 658: return function (act:Int) {switch (act) { case 88: return {t:810,w:0.693147}; case 120: return {t:810,w:0.693147};default: return {t:0,w:0.0};}};
case 659: return function (act:Int) {switch (act) { case 68: return {t:811,w:0.693147}; case 100: return {t:811,w:0.693147};default: return {t:0,w:0.0};}};
case 660: return function (act:Int) {switch (act) { case 256: return {t:812,w:4000000.000000}; case 269: return {t:813,w:0.000000};default: return {t:0,w:0.0};}};
case 661: return function (act:Int) {switch (act) { case 369: return {t:661,w:0.000000};default: return {t:0,w:0.0};}};
case 662: return function (act:Int) {switch (act) { case 371: return {t:662,w:0.000000};default: return {t:0,w:0.0};}};
case 663: return function (act:Int) {switch (act) { case 372: return {t:814,w:0.693147}; case 373: return {t:815,w:0.000000};default: return {t:0,w:0.0};}};
case 664: return function (act:Int) {switch (act) { case 374: return {t:664,w:0.000000};default: return {t:0,w:0.0};}};
case 665: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:816,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 666: return function (act:Int) {switch (act) { case 256: return {t:817,w:4000000.000000}; case 397: return {t:818,w:0.000000};default: return {t:0,w:0.0};}};
case 667: return function (act:Int) {switch (act) { case 256: return {t:819,w:4000000.000000}; case 398: return {t:820,w:0.000000};default: return {t:0,w:0.0};}};
case 668: return function (act:Int) {switch (act) { case 45: return {t:821,w:0.000000};default: return {t:0,w:0.0};}};
case 669: return function (act:Int) {switch (act) { case 69: return {t:822,w:0.693147}; case 101: return {t:822,w:0.693147};default: return {t:0,w:0.0};}};
case 670: return function (act:Int) {switch (act) { case 350: return {t:670,w:0.000000};default: return {t:0,w:0.0};}};
case 671: return function (act:Int) {switch (act) { case 44: return {t:823,w:0.000000};default: return {t:0,w:0.0};}};
case 672: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:490,w:0.693147}; case 375: return {t:491,w:0.693147};default: return {t:0,w:0.0};}};
case 673: return function (act:Int) {switch (act) { case 376: return {t:673,w:0.000000};default: return {t:0,w:0.0};}};
case 674: return function (act:Int) {switch (act) { case 268: return {t:52,w:3.784189}; case 331: return {t:258,w:0.000000};default: return {t:0,w:0.0};}};
case 675: return function (act:Int) {switch (act) { case 380: return {t:675,w:0.000000};default: return {t:0,w:0.0};}};
case 676: return function (act:Int) {switch (act) { case 9: return {t:493,w:1.386294}; case 13: return {t:83,w:1.386294}; case 32: return {t:494,w:1.386294}; case 279: return {t:504,w:1.386294}; case 283: return {t:119,w:1.386294}; case 376: return {t:505,w:0.693147};default: return {t:0,w:0.0};}};
case 677: return function (act:Int) {switch (act) { case 256: return {t:812,w:4000000.750000}; case 258: return {t:689,w:0.693147}; case 269: return {t:824,w:0.693147};default: return {t:0,w:0.0};}};
case 678: return function (act:Int) {switch (act) { case 357: return {t:678,w:0.000000};default: return {t:0,w:0.0};}};
case 679: return function (act:Int) {switch (act) { case 9: return {t:493,w:0.693147}; case 32: return {t:494,w:0.693147};default: return {t:0,w:0.0};}};
case 680: return function (act:Int) {switch (act) { case 256: return {t:679,w:4000000.750000}; case 258: return {t:682,w:0.693147}; case 376: return {t:825,w:0.693147};default: return {t:0,w:0.0};}};
case 681: return function (act:Int) {switch (act) { case 9: return {t:493,w:0.693147}; case 13: return {t:83,w:0.750000}; case 32: return {t:494,w:0.693147}; case 283: return {t:119,w:0.750000};default: return {t:0,w:0.0};}};
case 682: return function (act:Int) {switch (act) { case 377: return {t:682,w:0.000000};default: return {t:0,w:0.0};}};
case 683: return function (act:Int) {switch (act) { case 256: return {t:679,w:4000000.000000}; case 376: return {t:680,w:0.000000};default: return {t:0,w:0.0};}};
case 684: return function (act:Int) {switch (act) { case 256: return {t:681,w:4000000.750000}; case 258: return {t:682,w:0.693147}; case 279: return {t:683,w:1.386294}; case 376: return {t:684,w:0.693147};default: return {t:0,w:0.0};}};
case 685: return function (act:Int) {switch (act) { case 368: return {t:685,w:0.000000};default: return {t:0,w:0.0};}};
case 686: return function (act:Int) {switch (act) { case 258: return {t:826,w:0.000000};default: return {t:0,w:0.0};}};
case 687: return function (act:Int) {switch (act) { case 34: return {t:516,w:0.000000};default: return {t:0,w:0.0};}};
case 688: return function (act:Int) {switch (act) { case 256: return {t:827,w:4000000.750000}; case 381: return {t:828,w:0.693147}; case 399: return {t:829,w:1.386294}; case 400: return {t:830,w:1.386294};default: return {t:0,w:0.0};}};
case 689: return function (act:Int) {switch (act) { case 380: return {t:689,w:0.000000};default: return {t:0,w:0.0};}};
case 690: return function (act:Int) {switch (act) { case 65: return {t:179,w:5.049856}; case 66: return {t:179,w:5.049856}; case 67: return {t:179,w:5.049856}; case 68: return {t:179,w:5.049856}; case 69: return {t:179,w:5.049856}; case 70: return {t:179,w:5.049856}; case 71: return {t:179,w:5.049856}; case 72: return {t:179,w:5.049856}; case 73: return {t:179,w:5.049856}; case 74: return {t:179,w:5.049856}; case 75: return {t:179,w:5.049856}; case 76: return {t:179,w:5.049856}; case 77: return {t:179,w:5.049856}; case 78: return {t:179,w:5.049856}; case 79: return {t:179,w:5.049856}; case 80: return {t:179,w:5.049856}; case 81: return {t:179,w:5.049856}; case 82: return {t:179,w:5.049856}; case 83: return {t:180,w:1.791759}; case 84: return {t:179,w:5.049856}; case 85: return {t:179,w:5.049856}; case 86: return {t:179,w:5.049856}; case 87: return {t:179,w:5.049856}; case 88: return {t:179,w:5.049856}; case 89: return {t:179,w:5.049856}; case 90: return {t:179,w:5.049856}; case 97: return {t:181,w:5.049856}; case 98: return {t:181,w:5.049856}; case 99: return {t:181,w:5.049856}; case 100: return {t:181,w:5.049856}; case 101: return {t:181,w:5.049856}; case 102: return {t:181,w:5.049856}; case 103: return {t:181,w:5.049856}; case 104: return {t:181,w:5.049856}; case 105: return {t:181,w:5.049856}; case 106: return {t:181,w:5.049856}; case 107: return {t:181,w:5.049856}; case 108: return {t:181,w:5.049856}; case 109: return {t:181,w:5.049856}; case 110: return {t:181,w:5.049856}; case 111: return {t:181,w:5.049856}; case 112: return {t:181,w:5.049856}; case 113: return {t:181,w:5.049856}; case 114: return {t:181,w:5.049856}; case 115: return {t:182,w:1.791759}; case 116: return {t:181,w:5.049856}; case 117: return {t:181,w:5.049856}; case 118: return {t:181,w:5.049856}; case 119: return {t:181,w:5.049856}; case 120: return {t:181,w:5.049856}; case 121: return {t:181,w:5.049856}; case 122: return {t:181,w:5.049856}; case 331: return {t:183,w:1.098612}; case 332: return {t:501,w:1.098612}; case 333: return {t:502,w:1.098612}; case 334: return {t:186,w:1.098612}; case 335: return {t:503,w:1.098612};default: return {t:0,w:0.0};}};
case 691: return function (act:Int) {switch (act) { case 256: return {t:831,w:4000000.000000}; case 401: return {t:832,w:0.000000};default: return {t:0,w:0.0};}};
case 692: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:833,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 693: return function (act:Int) {switch (act) { case 256: return {t:690,w:4000000.000000}; case 357: return {t:691,w:0.000000};default: return {t:0,w:0.0};}};
case 694: return function (act:Int) {switch (act) { case 351: return {t:694,w:0.000000};default: return {t:0,w:0.0};}};
case 695: return function (act:Int) {switch (act) { case 256: return {t:834,w:4000000.000000}; case 402: return {t:835,w:0.000000};default: return {t:0,w:0.0};}};
case 696: return function (act:Int) {switch (act) { case 80: return {t:836,w:0.693147}; case 112: return {t:836,w:0.693147};default: return {t:0,w:0.0};}};
case 697: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 698: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 699: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 700: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 701: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 702: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 703: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 704: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 705: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 706: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 707: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 708: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 709: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 710: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 711: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 712: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 713: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 714: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 715: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 716: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 717: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 718: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 719: return function (act:Int) {switch (act) { case 34: return {t:516,w:0.000000}; case 48: return {t:9,w:3.401197}; case 49: return {t:9,w:3.401197}; case 50: return {t:9,w:3.401197}; case 51: return {t:9,w:3.401197}; case 52: return {t:9,w:3.401197}; case 53: return {t:9,w:3.401197}; case 54: return {t:9,w:3.401197}; case 55: return {t:9,w:3.401197}; case 56: return {t:9,w:3.401197}; case 57: return {t:9,w:3.401197}; case 65: return {t:13,w:4.356709}; case 66: return {t:13,w:4.356709}; case 67: return {t:13,w:4.356709}; case 68: return {t:13,w:4.356709}; case 69: return {t:13,w:4.356709}; case 70: return {t:13,w:4.356709}; case 71: return {t:13,w:4.356709}; case 72: return {t:13,w:4.356709}; case 73: return {t:13,w:4.356709}; case 74: return {t:13,w:4.356709}; case 75: return {t:13,w:4.356709}; case 76: return {t:13,w:4.356709}; case 77: return {t:13,w:4.356709}; case 78: return {t:13,w:4.356709}; case 79: return {t:13,w:4.356709}; case 80: return {t:13,w:4.356709}; case 81: return {t:13,w:4.356709}; case 82: return {t:13,w:4.356709}; case 83: return {t:13,w:4.356709}; case 84: return {t:13,w:4.356709}; case 85: return {t:13,w:4.356709}; case 86: return {t:13,w:4.356709}; case 87: return {t:13,w:4.356709}; case 88: return {t:13,w:4.356709}; case 89: return {t:13,w:4.356709}; case 90: return {t:13,w:4.356709}; case 97: return {t:20,w:4.356709}; case 98: return {t:20,w:4.356709}; case 99: return {t:20,w:4.356709}; case 100: return {t:20,w:4.356709}; case 101: return {t:20,w:4.356709}; case 102: return {t:20,w:4.356709}; case 103: return {t:20,w:4.356709}; case 104: return {t:20,w:4.356709}; case 105: return {t:20,w:4.356709}; case 106: return {t:20,w:4.356709}; case 107: return {t:20,w:4.356709}; case 108: return {t:20,w:4.356709}; case 109: return {t:20,w:4.356709}; case 110: return {t:20,w:4.356709}; case 111: return {t:20,w:4.356709}; case 112: return {t:20,w:4.356709}; case 113: return {t:20,w:4.356709}; case 114: return {t:20,w:4.356709}; case 115: return {t:20,w:4.356709}; case 116: return {t:20,w:4.356709}; case 117: return {t:20,w:4.356709}; case 118: return {t:20,w:4.356709}; case 119: return {t:20,w:4.356709}; case 120: return {t:20,w:4.356709}; case 121: return {t:20,w:4.356709}; case 122: return {t:20,w:4.356709};default: return {t:0,w:0.0};}};
case 720: return function (act:Int) {switch (act) { case 382: return {t:720,w:0.000000};default: return {t:0,w:0.0};}};
case 721: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 722: return function (act:Int) {switch (act) { case 33: return {t:697,w:3.871201}; case 37: return {t:698,w:3.871201}; case 39: return {t:699,w:3.871201}; case 40: return {t:700,w:3.871201}; case 41: return {t:701,w:3.871201}; case 42: return {t:702,w:3.871201}; case 43: return {t:703,w:3.871201}; case 45: return {t:704,w:3.871201}; case 46: return {t:705,w:3.871201}; case 47: return {t:706,w:3.871201}; case 58: return {t:707,w:3.871201}; case 60: return {t:708,w:3.871201}; case 62: return {t:709,w:3.871201}; case 63: return {t:710,w:3.871201}; case 91: return {t:711,w:3.871201}; case 92: return {t:712,w:3.871201}; case 93: return {t:713,w:3.871201}; case 95: return {t:714,w:3.871201}; case 96: return {t:715,w:3.871201}; case 123: return {t:716,w:3.871201}; case 125: return {t:717,w:3.871201}; case 126: return {t:718,w:3.871201}; case 256: return {t:719,w:4000004.000000}; case 258: return {t:720,w:0.693147}; case 268: return {t:721,w:3.871201}; case 381: return {t:722,w:3.871201};default: return {t:0,w:0.0};}};
case 723: return function (act:Int) {switch (act) { case 381: return {t:723,w:0.000000};default: return {t:0,w:0.0};}};
case 724: return function (act:Int) {switch (act) { case 256: return {t:837,w:4000000.000000}; case 382: return {t:838,w:0.000000};default: return {t:0,w:0.0};}};
case 725: return function (act:Int) {switch (act) { case 352: return {t:725,w:0.000000};default: return {t:0,w:0.0};}};
case 726: return function (act:Int) {switch (act) { case 353: return {t:726,w:0.000000};default: return {t:0,w:0.0};}};
case 727: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:314,w:0.693147}; case 375: return {t:543,w:0.693147};default: return {t:0,w:0.0};}};
case 728: return function (act:Int) {switch (act) { case 79: return {t:839,w:0.693147}; case 111: return {t:839,w:0.693147};default: return {t:0,w:0.0};}};
case 729: return function (act:Int) {switch (act) { case 86: return {t:840,w:0.693147}; case 118: return {t:840,w:0.693147};default: return {t:0,w:0.0};}};
case 730: return function (act:Int) {switch (act) { case 88: return {t:841,w:0.693147}; case 120: return {t:841,w:0.693147};default: return {t:0,w:0.0};}};
case 731: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:842,w:0.000000};default: return {t:0,w:0.0};}};
case 732: return function (act:Int) {switch (act) { case 355: return {t:732,w:0.000000};default: return {t:0,w:0.0};}};
case 733: return function (act:Int) {switch (act) { case 256: return {t:843,w:4000000.000000}; case 403: return {t:844,w:0.000000};default: return {t:0,w:0.0};}};
case 734: return function (act:Int) {switch (act) { case 9: return {t:493,w:3.465735}; case 13: return {t:83,w:3.465735}; case 32: return {t:494,w:3.465735}; case 33: return {t:2,w:5.170483}; case 37: return {t:3,w:5.170483}; case 39: return {t:4,w:5.170483}; case 42: return {t:5,w:5.170483}; case 43: return {t:6,w:5.170483}; case 45: return {t:7,w:5.170483}; case 46: return {t:8,w:5.170483}; case 48: return {t:9,w:8.571681}; case 49: return {t:9,w:8.571681}; case 50: return {t:9,w:8.571681}; case 51: return {t:9,w:8.571681}; case 52: return {t:9,w:8.571681}; case 53: return {t:9,w:8.571681}; case 54: return {t:9,w:8.571681}; case 55: return {t:9,w:8.571681}; case 56: return {t:9,w:8.571681}; case 57: return {t:9,w:8.571681}; case 65: return {t:495,w:5.743003}; case 66: return {t:495,w:5.743003}; case 67: return {t:495,w:5.743003}; case 68: return {t:495,w:5.743003}; case 69: return {t:495,w:5.743003}; case 70: return {t:495,w:5.743003}; case 71: return {t:495,w:5.743003}; case 72: return {t:495,w:5.743003}; case 73: return {t:495,w:5.743003}; case 74: return {t:495,w:5.743003}; case 75: return {t:495,w:5.743003}; case 76: return {t:495,w:5.743003}; case 77: return {t:495,w:5.743003}; case 78: return {t:495,w:5.743003}; case 79: return {t:495,w:5.743003}; case 80: return {t:495,w:5.743003}; case 81: return {t:495,w:5.743003}; case 82: return {t:495,w:5.743003}; case 83: return {t:496,w:2.484906}; case 84: return {t:495,w:5.743003}; case 85: return {t:495,w:5.743003}; case 86: return {t:495,w:5.743003}; case 87: return {t:495,w:5.743003}; case 88: return {t:495,w:5.743003}; case 89: return {t:495,w:5.743003}; case 90: return {t:495,w:5.743003}; case 95: return {t:18,w:5.170483}; case 96: return {t:19,w:5.170483}; case 97: return {t:497,w:5.743003}; case 98: return {t:497,w:5.743003}; case 99: return {t:497,w:5.743003}; case 100: return {t:497,w:5.743003}; case 101: return {t:497,w:5.743003}; case 102: return {t:497,w:5.743003}; case 103: return {t:497,w:5.743003}; case 104: return {t:497,w:5.743003}; case 105: return {t:497,w:5.743003}; case 106: return {t:497,w:5.743003}; case 107: return {t:497,w:5.743003}; case 108: return {t:497,w:5.743003}; case 109: return {t:497,w:5.743003}; case 110: return {t:497,w:5.743003}; case 111: return {t:497,w:5.743003}; case 112: return {t:497,w:5.743003}; case 113: return {t:497,w:5.743003}; case 114: return {t:497,w:5.743003}; case 115: return {t:498,w:2.484906}; case 116: return {t:497,w:5.743003}; case 117: return {t:497,w:5.743003}; case 118: return {t:497,w:5.743003}; case 119: return {t:497,w:5.743003}; case 120: return {t:497,w:5.743003}; case 121: return {t:497,w:5.743003}; case 122: return {t:497,w:5.743003}; case 126: return {t:22,w:5.170483}; case 258: return {t:499,w:2.079441}; case 268: return {t:29,w:5.170483}; case 269: return {t:500,w:2.772588}; case 279: return {t:504,w:3.465735}; case 283: return {t:119,w:3.465735}; case 331: return {t:183,w:1.791759}; case 332: return {t:501,w:1.791759}; case 333: return {t:502,w:1.791759}; case 334: return {t:186,w:1.791759}; case 335: return {t:503,w:1.791759}; case 357: return {t:551,w:0.693147}; case 358: return {t:552,w:0.693147}; case 368: return {t:507,w:1.386294}; case 376: return {t:505,w:2.772588}; case 377: return {t:506,w:2.079441}; case 378: return {t:508,w:2.079441}; case 379: return {t:509,w:1.386294}; case 380: return {t:510,w:1.386294};default: return {t:0,w:0.0};}};
case 735: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:553,w:0.693147}; case 375: return {t:554,w:0.693147};default: return {t:0,w:0.0};}};
case 736: return function (act:Int) {switch (act) { case 73: return {t:845,w:0.693147}; case 105: return {t:845,w:0.693147};default: return {t:0,w:0.0};}};
case 737: return function (act:Int) {switch (act) { case 73: return {t:846,w:0.693147}; case 105: return {t:846,w:0.693147};default: return {t:0,w:0.0};}};
case 738: return function (act:Int) {switch (act) { case 45: return {t:847,w:0.000000};default: return {t:0,w:0.0};}};
case 739: return function (act:Int) {switch (act) { case 68: return {t:848,w:0.693147}; case 100: return {t:848,w:0.693147};default: return {t:0,w:0.0};}};
case 740: return function (act:Int) {switch (act) { case 45: return {t:849,w:0.000000};default: return {t:0,w:0.0};}};
case 741: return function (act:Int) {switch (act) { case 82: return {t:850,w:0.693147}; case 114: return {t:850,w:0.693147};default: return {t:0,w:0.0};}};
case 742: return function (act:Int) {switch (act) { case 45: return {t:851,w:0.000000};default: return {t:0,w:0.0};}};
case 743: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:852,w:0.000000};default: return {t:0,w:0.0};}};
case 744: return function (act:Int) {switch (act) { case 82: return {t:853,w:0.693147}; case 114: return {t:853,w:0.693147};default: return {t:0,w:0.0};}};
case 745: return function (act:Int) {switch (act) { case 67: return {t:854,w:0.693147}; case 99: return {t:854,w:0.693147};default: return {t:0,w:0.0};}};
case 746: return function (act:Int) {switch (act) { case 82: return {t:855,w:0.693147}; case 114: return {t:855,w:0.693147};default: return {t:0,w:0.0};}};
case 747: return function (act:Int) {switch (act) { case 383: return {t:747,w:0.000000};default: return {t:0,w:0.0};}};
case 748: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.886294}; case 13: return {t:83,w:2.886294}; case 32: return {t:494,w:2.886294}; case 33: return {t:566,w:5.236442}; case 34: return {t:566,w:5.236442}; case 35: return {t:566,w:5.236442}; case 36: return {t:566,w:5.236442}; case 37: return {t:566,w:5.236442}; case 38: return {t:566,w:5.236442}; case 39: return {t:566,w:5.236442}; case 40: return {t:566,w:5.236442}; case 41: return {t:566,w:5.236442}; case 42: return {t:566,w:5.236442}; case 43: return {t:566,w:5.236442}; case 44: return {t:566,w:5.236442}; case 45: return {t:566,w:5.236442}; case 46: return {t:566,w:5.236442}; case 47: return {t:566,w:5.236442}; case 48: return {t:566,w:5.236442}; case 49: return {t:566,w:5.236442}; case 50: return {t:566,w:5.236442}; case 51: return {t:566,w:5.236442}; case 52: return {t:566,w:5.236442}; case 53: return {t:566,w:5.236442}; case 54: return {t:566,w:5.236442}; case 55: return {t:566,w:5.236442}; case 56: return {t:566,w:5.236442}; case 57: return {t:566,w:5.236442}; case 58: return {t:566,w:5.236442}; case 59: return {t:566,w:5.236442}; case 60: return {t:566,w:5.236442}; case 61: return {t:566,w:5.236442}; case 62: return {t:566,w:5.236442}; case 63: return {t:566,w:5.236442}; case 64: return {t:566,w:5.236442}; case 65: return {t:566,w:5.236442}; case 66: return {t:566,w:5.236442}; case 67: return {t:566,w:5.236442}; case 68: return {t:566,w:5.236442}; case 69: return {t:566,w:5.236442}; case 70: return {t:566,w:5.236442}; case 71: return {t:566,w:5.236442}; case 72: return {t:566,w:5.236442}; case 73: return {t:566,w:5.236442}; case 74: return {t:566,w:5.236442}; case 75: return {t:566,w:5.236442}; case 76: return {t:566,w:5.236442}; case 77: return {t:566,w:5.236442}; case 78: return {t:566,w:5.236442}; case 79: return {t:566,w:5.236442}; case 80: return {t:566,w:5.236442}; case 81: return {t:566,w:5.236442}; case 82: return {t:566,w:5.236442}; case 83: return {t:566,w:5.236442}; case 84: return {t:566,w:5.236442}; case 85: return {t:566,w:5.236442}; case 86: return {t:566,w:5.236442}; case 87: return {t:566,w:5.236442}; case 88: return {t:566,w:5.236442}; case 89: return {t:566,w:5.236442}; case 90: return {t:566,w:5.236442}; case 91: return {t:566,w:5.236442}; case 92: return {t:566,w:5.236442}; case 93: return {t:566,w:5.236442}; case 94: return {t:566,w:5.236442}; case 95: return {t:566,w:5.236442}; case 96: return {t:566,w:5.236442}; case 97: return {t:566,w:5.236442}; case 98: return {t:566,w:5.236442}; case 99: return {t:566,w:5.236442}; case 100: return {t:566,w:5.236442}; case 101: return {t:566,w:5.236442}; case 102: return {t:566,w:5.236442}; case 103: return {t:566,w:5.236442}; case 104: return {t:566,w:5.236442}; case 105: return {t:566,w:5.236442}; case 106: return {t:566,w:5.236442}; case 107: return {t:566,w:5.236442}; case 108: return {t:566,w:5.236442}; case 109: return {t:566,w:5.236442}; case 110: return {t:566,w:5.236442}; case 111: return {t:566,w:5.236442}; case 112: return {t:566,w:5.236442}; case 113: return {t:566,w:5.236442}; case 114: return {t:566,w:5.236442}; case 115: return {t:566,w:5.236442}; case 116: return {t:566,w:5.236442}; case 117: return {t:566,w:5.236442}; case 118: return {t:566,w:5.236442}; case 119: return {t:566,w:5.236442}; case 120: return {t:566,w:5.236442}; case 121: return {t:566,w:5.236442}; case 122: return {t:566,w:5.236442}; case 123: return {t:566,w:5.236442}; case 124: return {t:566,w:5.236442}; case 125: return {t:566,w:5.236442}; case 126: return {t:566,w:5.236442}; case 192: return {t:437,w:5.768321}; case 193: return {t:437,w:5.768321}; case 194: return {t:437,w:5.768321}; case 195: return {t:437,w:5.768321}; case 196: return {t:437,w:5.768321}; case 197: return {t:437,w:5.768321}; case 198: return {t:437,w:5.768321}; case 199: return {t:437,w:5.768321}; case 200: return {t:437,w:5.768321}; case 201: return {t:437,w:5.768321}; case 202: return {t:437,w:5.768321}; case 203: return {t:437,w:5.768321}; case 204: return {t:437,w:5.768321}; case 205: return {t:437,w:5.768321}; case 206: return {t:437,w:5.768321}; case 207: return {t:437,w:5.768321}; case 208: return {t:437,w:5.768321}; case 209: return {t:437,w:5.768321}; case 210: return {t:437,w:5.768321}; case 211: return {t:437,w:5.768321}; case 212: return {t:437,w:5.768321}; case 213: return {t:437,w:5.768321}; case 214: return {t:437,w:5.768321}; case 215: return {t:437,w:5.768321}; case 216: return {t:437,w:5.768321}; case 217: return {t:437,w:5.768321}; case 218: return {t:437,w:5.768321}; case 219: return {t:437,w:5.768321}; case 220: return {t:437,w:5.768321}; case 221: return {t:437,w:5.768321}; case 222: return {t:437,w:5.768321}; case 223: return {t:437,w:5.768321}; case 224: return {t:438,w:5.075174}; case 225: return {t:438,w:5.075174}; case 226: return {t:438,w:5.075174}; case 227: return {t:438,w:5.075174}; case 228: return {t:438,w:5.075174}; case 229: return {t:438,w:5.075174}; case 230: return {t:438,w:5.075174}; case 231: return {t:438,w:5.075174}; case 232: return {t:438,w:5.075174}; case 233: return {t:438,w:5.075174}; case 234: return {t:438,w:5.075174}; case 235: return {t:438,w:5.075174}; case 236: return {t:438,w:5.075174}; case 237: return {t:438,w:5.075174}; case 238: return {t:438,w:5.075174}; case 239: return {t:438,w:5.075174}; case 240: return {t:439,w:4.382027}; case 241: return {t:439,w:4.382027}; case 242: return {t:439,w:4.382027}; case 243: return {t:439,w:4.382027}; case 244: return {t:439,w:4.382027}; case 245: return {t:439,w:4.382027}; case 246: return {t:439,w:4.382027}; case 247: return {t:439,w:4.382027}; case 248: return {t:440,w:3.688879}; case 249: return {t:440,w:3.688879}; case 250: return {t:440,w:3.688879}; case 251: return {t:440,w:3.688879}; case 252: return {t:441,w:2.995732}; case 253: return {t:441,w:2.995732}; case 279: return {t:504,w:2.886294}; case 283: return {t:119,w:2.886294}; case 367: return {t:567,w:0.693147}; case 376: return {t:505,w:2.193147};default: return {t:0,w:0.0};}};
case 749: return function (act:Int) {switch (act) { case 356: return {t:749,w:0.000000};default: return {t:0,w:0.0};}};
case 750: return function (act:Int) {switch (act) { case 256: return {t:856,w:4000000.750000}; case 377: return {t:750,w:0.693147}; case 383: return {t:857,w:0.693147};default: return {t:0,w:0.0};}};
case 751: return function (act:Int) {switch (act) { case 256: return {t:748,w:4000000.750000}; case 258: return {t:749,w:1.386294}; case 377: return {t:750,w:2.079441}; case 383: return {t:751,w:0.693147};default: return {t:0,w:0.0};}};
case 752: return function (act:Int) {switch (act) { case 84: return {t:858,w:0.693147}; case 116: return {t:858,w:0.693147};default: return {t:0,w:0.0};}};
case 753: return function (act:Int) {switch (act) { case 59: return {t:859,w:0.000000};default: return {t:0,w:0.0};}};
case 754: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:860,w:1.386294}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:861,w:1.386294}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:862,w:0.693147}; case 404: return {t:863,w:0.693147}; case 405: return {t:864,w:0.693147};default: return {t:0,w:0.0};}};
case 755: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:571,w:0.693147}; case 384: return {t:572,w:0.693147};default: return {t:0,w:0.0};}};
case 756: return function (act:Int) {switch (act) { case 80: return {t:865,w:0.693147}; case 112: return {t:865,w:0.693147};default: return {t:0,w:0.0};}};
case 757: return function (act:Int) {switch (act) { case 65: return {t:866,w:0.693147}; case 97: return {t:866,w:0.693147};default: return {t:0,w:0.0};}};
case 758: return function (act:Int) {switch (act) { case 80: return {t:867,w:0.693147}; case 112: return {t:867,w:0.693147};default: return {t:0,w:0.0};}};
case 759: return function (act:Int) {switch (act) { case 385: return {t:759,w:0.000000};default: return {t:0,w:0.0};}};
case 760: return function (act:Int) {switch (act) { case 256: return {t:868,w:4000000.000000}; case 406: return {t:869,w:0.000000};default: return {t:0,w:0.0};}};
case 761: return function (act:Int) {switch (act) { case 256: return {t:870,w:4000000.000000}; case 407: return {t:871,w:0.000000};default: return {t:0,w:0.0};}};
case 762: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:580,w:0.693147}; case 375: return {t:581,w:0.693147};default: return {t:0,w:0.0};}};
case 763: return function (act:Int) {switch (act) { case 78: return {t:872,w:0.693147}; case 110: return {t:872,w:0.693147};default: return {t:0,w:0.0};}};
case 764: return function (act:Int) {switch (act) { case 85: return {t:873,w:0.693147}; case 117: return {t:873,w:0.693147};default: return {t:0,w:0.0};}};
case 765: return function (act:Int) {switch (act) { case 9: return {t:493,w:1.386294}; case 13: return {t:83,w:1.386294}; case 32: return {t:494,w:1.386294}; case 33: return {t:566,w:5.236442}; case 34: return {t:566,w:5.236442}; case 35: return {t:566,w:5.236442}; case 36: return {t:566,w:5.236442}; case 37: return {t:566,w:5.236442}; case 38: return {t:566,w:5.236442}; case 39: return {t:566,w:5.236442}; case 40: return {t:566,w:5.236442}; case 41: return {t:566,w:5.236442}; case 42: return {t:566,w:5.236442}; case 43: return {t:566,w:5.236442}; case 44: return {t:566,w:5.236442}; case 45: return {t:566,w:5.236442}; case 46: return {t:566,w:5.236442}; case 47: return {t:566,w:5.236442}; case 48: return {t:566,w:5.236442}; case 49: return {t:566,w:5.236442}; case 50: return {t:566,w:5.236442}; case 51: return {t:566,w:5.236442}; case 52: return {t:566,w:5.236442}; case 53: return {t:566,w:5.236442}; case 54: return {t:566,w:5.236442}; case 55: return {t:566,w:5.236442}; case 56: return {t:566,w:5.236442}; case 57: return {t:566,w:5.236442}; case 58: return {t:566,w:5.236442}; case 59: return {t:566,w:5.236442}; case 60: return {t:566,w:5.236442}; case 61: return {t:566,w:5.236442}; case 62: return {t:566,w:5.236442}; case 63: return {t:566,w:5.236442}; case 64: return {t:566,w:5.236442}; case 65: return {t:566,w:5.236442}; case 66: return {t:566,w:5.236442}; case 67: return {t:566,w:5.236442}; case 68: return {t:566,w:5.236442}; case 69: return {t:566,w:5.236442}; case 70: return {t:566,w:5.236442}; case 71: return {t:566,w:5.236442}; case 72: return {t:566,w:5.236442}; case 73: return {t:566,w:5.236442}; case 74: return {t:566,w:5.236442}; case 75: return {t:566,w:5.236442}; case 76: return {t:566,w:5.236442}; case 77: return {t:566,w:5.236442}; case 78: return {t:566,w:5.236442}; case 79: return {t:566,w:5.236442}; case 80: return {t:566,w:5.236442}; case 81: return {t:566,w:5.236442}; case 82: return {t:566,w:5.236442}; case 83: return {t:566,w:5.236442}; case 84: return {t:566,w:5.236442}; case 85: return {t:566,w:5.236442}; case 86: return {t:566,w:5.236442}; case 87: return {t:566,w:5.236442}; case 88: return {t:566,w:5.236442}; case 89: return {t:566,w:5.236442}; case 90: return {t:566,w:5.236442}; case 91: return {t:566,w:5.236442}; case 92: return {t:566,w:5.236442}; case 93: return {t:566,w:5.236442}; case 94: return {t:566,w:5.236442}; case 95: return {t:566,w:5.236442}; case 96: return {t:566,w:5.236442}; case 97: return {t:566,w:5.236442}; case 98: return {t:566,w:5.236442}; case 99: return {t:566,w:5.236442}; case 100: return {t:566,w:5.236442}; case 101: return {t:566,w:5.236442}; case 102: return {t:566,w:5.236442}; case 103: return {t:566,w:5.236442}; case 104: return {t:566,w:5.236442}; case 105: return {t:566,w:5.236442}; case 106: return {t:566,w:5.236442}; case 107: return {t:566,w:5.236442}; case 108: return {t:566,w:5.236442}; case 109: return {t:566,w:5.236442}; case 110: return {t:566,w:5.236442}; case 111: return {t:566,w:5.236442}; case 112: return {t:566,w:5.236442}; case 113: return {t:566,w:5.236442}; case 114: return {t:566,w:5.236442}; case 115: return {t:566,w:5.236442}; case 116: return {t:566,w:5.236442}; case 117: return {t:566,w:5.236442}; case 118: return {t:566,w:5.236442}; case 119: return {t:566,w:5.236442}; case 120: return {t:566,w:5.236442}; case 121: return {t:566,w:5.236442}; case 122: return {t:566,w:5.236442}; case 123: return {t:566,w:5.236442}; case 124: return {t:566,w:5.236442}; case 125: return {t:566,w:5.236442}; case 126: return {t:566,w:5.236442}; case 128: return {t:436,w:4.158883}; case 129: return {t:436,w:4.158883}; case 130: return {t:436,w:4.158883}; case 131: return {t:436,w:4.158883}; case 132: return {t:436,w:4.158883}; case 133: return {t:436,w:4.158883}; case 134: return {t:436,w:4.158883}; case 135: return {t:436,w:4.158883}; case 136: return {t:436,w:4.158883}; case 137: return {t:436,w:4.158883}; case 138: return {t:436,w:4.158883}; case 139: return {t:436,w:4.158883}; case 140: return {t:436,w:4.158883}; case 141: return {t:436,w:4.158883}; case 142: return {t:436,w:4.158883}; case 143: return {t:436,w:4.158883}; case 144: return {t:436,w:4.158883}; case 145: return {t:436,w:4.158883}; case 146: return {t:436,w:4.158883}; case 147: return {t:436,w:4.158883}; case 148: return {t:436,w:4.158883}; case 149: return {t:436,w:4.158883}; case 150: return {t:436,w:4.158883}; case 151: return {t:436,w:4.158883}; case 152: return {t:436,w:4.158883}; case 153: return {t:436,w:4.158883}; case 154: return {t:436,w:4.158883}; case 155: return {t:436,w:4.158883}; case 156: return {t:436,w:4.158883}; case 157: return {t:436,w:4.158883}; case 158: return {t:436,w:4.158883}; case 159: return {t:436,w:4.158883}; case 160: return {t:436,w:4.158883}; case 161: return {t:436,w:4.158883}; case 162: return {t:436,w:4.158883}; case 163: return {t:436,w:4.158883}; case 164: return {t:436,w:4.158883}; case 165: return {t:436,w:4.158883}; case 166: return {t:436,w:4.158883}; case 167: return {t:436,w:4.158883}; case 168: return {t:436,w:4.158883}; case 169: return {t:436,w:4.158883}; case 170: return {t:436,w:4.158883}; case 171: return {t:436,w:4.158883}; case 172: return {t:436,w:4.158883}; case 173: return {t:436,w:4.158883}; case 174: return {t:436,w:4.158883}; case 175: return {t:436,w:4.158883}; case 176: return {t:436,w:4.158883}; case 177: return {t:436,w:4.158883}; case 178: return {t:436,w:4.158883}; case 179: return {t:436,w:4.158883}; case 180: return {t:436,w:4.158883}; case 181: return {t:436,w:4.158883}; case 182: return {t:436,w:4.158883}; case 183: return {t:436,w:4.158883}; case 184: return {t:436,w:4.158883}; case 185: return {t:436,w:4.158883}; case 186: return {t:436,w:4.158883}; case 187: return {t:436,w:4.158883}; case 188: return {t:436,w:4.158883}; case 189: return {t:436,w:4.158883}; case 190: return {t:436,w:4.158883}; case 191: return {t:436,w:4.158883}; case 192: return {t:437,w:5.768321}; case 193: return {t:437,w:5.768321}; case 194: return {t:437,w:5.768321}; case 195: return {t:437,w:5.768321}; case 196: return {t:437,w:5.768321}; case 197: return {t:437,w:5.768321}; case 198: return {t:437,w:5.768321}; case 199: return {t:437,w:5.768321}; case 200: return {t:437,w:5.768321}; case 201: return {t:437,w:5.768321}; case 202: return {t:437,w:5.768321}; case 203: return {t:437,w:5.768321}; case 204: return {t:437,w:5.768321}; case 205: return {t:437,w:5.768321}; case 206: return {t:437,w:5.768321}; case 207: return {t:437,w:5.768321}; case 208: return {t:437,w:5.768321}; case 209: return {t:437,w:5.768321}; case 210: return {t:437,w:5.768321}; case 211: return {t:437,w:5.768321}; case 212: return {t:437,w:5.768321}; case 213: return {t:437,w:5.768321}; case 214: return {t:437,w:5.768321}; case 215: return {t:437,w:5.768321}; case 216: return {t:437,w:5.768321}; case 217: return {t:437,w:5.768321}; case 218: return {t:437,w:5.768321}; case 219: return {t:437,w:5.768321}; case 220: return {t:437,w:5.768321}; case 221: return {t:437,w:5.768321}; case 222: return {t:437,w:5.768321}; case 223: return {t:437,w:5.768321}; case 224: return {t:438,w:5.075174}; case 225: return {t:438,w:5.075174}; case 226: return {t:438,w:5.075174}; case 227: return {t:438,w:5.075174}; case 228: return {t:438,w:5.075174}; case 229: return {t:438,w:5.075174}; case 230: return {t:438,w:5.075174}; case 231: return {t:438,w:5.075174}; case 232: return {t:438,w:5.075174}; case 233: return {t:438,w:5.075174}; case 234: return {t:438,w:5.075174}; case 235: return {t:438,w:5.075174}; case 236: return {t:438,w:5.075174}; case 237: return {t:438,w:5.075174}; case 238: return {t:438,w:5.075174}; case 239: return {t:438,w:5.075174}; case 240: return {t:439,w:4.382027}; case 241: return {t:439,w:4.382027}; case 242: return {t:439,w:4.382027}; case 243: return {t:439,w:4.382027}; case 244: return {t:439,w:4.382027}; case 245: return {t:439,w:4.382027}; case 246: return {t:439,w:4.382027}; case 247: return {t:439,w:4.382027}; case 248: return {t:440,w:3.688879}; case 249: return {t:440,w:3.688879}; case 250: return {t:440,w:3.688879}; case 251: return {t:440,w:3.688879}; case 252: return {t:441,w:2.995732}; case 253: return {t:441,w:2.995732}; case 279: return {t:504,w:1.386294}; case 283: return {t:119,w:1.386294}; case 367: return {t:567,w:0.693147}; case 376: return {t:505,w:0.693147};default: return {t:0,w:0.0};}};
case 766: return function (act:Int) {switch (act) { case 360: return {t:766,w:0.000000};default: return {t:0,w:0.0};}};
case 767: return function (act:Int) {switch (act) { case 256: return {t:765,w:4000001.750000}; case 258: return {t:766,w:0.693147}; case 366: return {t:768,w:1.791759}; case 377: return {t:767,w:1.791759}; case 383: return {t:769,w:1.791759};default: return {t:0,w:0.0};}};
case 768: return function (act:Int) {switch (act) { case 256: return {t:765,w:4000001.750000}; case 258: return {t:766,w:0.693147}; case 366: return {t:768,w:1.791759}; case 377: return {t:767,w:1.791759}; case 383: return {t:769,w:1.791759};default: return {t:0,w:0.0};}};
case 769: return function (act:Int) {switch (act) { case 256: return {t:765,w:4000001.750000}; case 258: return {t:766,w:0.693147}; case 366: return {t:768,w:1.791759}; case 377: return {t:767,w:1.791759}; case 383: return {t:769,w:1.791759};default: return {t:0,w:0.0};}};
case 770: return function (act:Int) {switch (act) { case 264: return {t:770,w:0.000000};default: return {t:0,w:0.0};}};
case 771: return function (act:Int) {switch (act) { case 258: return {t:874,w:0.000000};default: return {t:0,w:0.0};}};
case 772: return function (act:Int) {switch (act) { case 272: return {t:772,w:0.000000};default: return {t:0,w:0.0};}};
case 773: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:772,w:0.693147}; case 336: return {t:773,w:0.693147};default: return {t:0,w:0.0};}};
case 774: return function (act:Int) {switch (act) { case 33: return {t:420,w:3.178054}; case 36: return {t:875,w:3.044522}; case 37: return {t:422,w:1.098612}; case 38: return {t:876,w:3.044522}; case 39: return {t:424,w:4.564348}; case 40: return {t:424,w:4.564348}; case 41: return {t:424,w:4.564348}; case 42: return {t:424,w:4.564348}; case 43: return {t:877,w:3.737669}; case 44: return {t:877,w:3.737669}; case 45: return {t:426,w:3.871201}; case 46: return {t:426,w:3.871201}; case 47: return {t:878,w:3.044522}; case 48: return {t:879,w:3.401197}; case 49: return {t:879,w:3.401197}; case 50: return {t:879,w:3.401197}; case 51: return {t:879,w:3.401197}; case 52: return {t:879,w:3.401197}; case 53: return {t:879,w:3.401197}; case 54: return {t:879,w:3.401197}; case 55: return {t:879,w:3.401197}; case 56: return {t:879,w:3.401197}; case 57: return {t:879,w:3.401197}; case 59: return {t:880,w:3.044522}; case 61: return {t:881,w:3.044522}; case 63: return {t:882,w:3.044522}; case 65: return {t:883,w:6.436150}; case 66: return {t:883,w:6.436150}; case 67: return {t:883,w:6.436150}; case 68: return {t:883,w:6.436150}; case 69: return {t:883,w:6.436150}; case 70: return {t:883,w:6.436150}; case 71: return {t:883,w:6.436150}; case 72: return {t:883,w:6.436150}; case 73: return {t:883,w:6.436150}; case 74: return {t:883,w:6.436150}; case 75: return {t:883,w:6.436150}; case 76: return {t:883,w:6.436150}; case 77: return {t:883,w:6.436150}; case 78: return {t:883,w:6.436150}; case 79: return {t:883,w:6.436150}; case 80: return {t:883,w:6.436150}; case 81: return {t:883,w:6.436150}; case 82: return {t:883,w:6.436150}; case 83: return {t:883,w:6.436150}; case 84: return {t:883,w:6.436150}; case 85: return {t:883,w:6.436150}; case 86: return {t:883,w:6.436150}; case 87: return {t:883,w:6.436150}; case 88: return {t:883,w:6.436150}; case 89: return {t:883,w:6.436150}; case 90: return {t:883,w:6.436150}; case 91: return {t:884,w:1.098612}; case 95: return {t:433,w:3.178054}; case 97: return {t:885,w:6.436150}; case 98: return {t:885,w:6.436150}; case 99: return {t:885,w:6.436150}; case 100: return {t:885,w:6.436150}; case 101: return {t:885,w:6.436150}; case 102: return {t:885,w:6.436150}; case 103: return {t:885,w:6.436150}; case 104: return {t:885,w:6.436150}; case 105: return {t:885,w:6.436150}; case 106: return {t:885,w:6.436150}; case 107: return {t:885,w:6.436150}; case 108: return {t:885,w:6.436150}; case 109: return {t:885,w:6.436150}; case 110: return {t:885,w:6.436150}; case 111: return {t:885,w:6.436150}; case 112: return {t:885,w:6.436150}; case 113: return {t:885,w:6.436150}; case 114: return {t:885,w:6.436150}; case 115: return {t:885,w:6.436150}; case 116: return {t:885,w:6.436150}; case 117: return {t:885,w:6.436150}; case 118: return {t:885,w:6.436150}; case 119: return {t:885,w:6.436150}; case 120: return {t:885,w:6.436150}; case 121: return {t:885,w:6.436150}; case 122: return {t:885,w:6.436150}; case 126: return {t:435,w:3.178054}; case 268: return {t:886,w:2.484906}; case 331: return {t:892,w:2.484906}; case 336: return {t:895,w:1.098612}; case 363: return {t:887,w:1.098612}; case 364: return {t:888,w:1.098612}; case 408: return {t:889,w:1.098612}; case 409: return {t:890,w:0.000000}; case 410: return {t:891,w:1.791759}; case 411: return {t:893,w:1.791759}; case 412: return {t:894,w:1.098612}; case 413: return {t:896,w:1.098612}; case 414: return {t:897,w:1.098612}; case 415: return {t:898,w:0.000000};default: return {t:0,w:0.0};}};
case 775: return function (act:Int) {switch (act) { case 256: return {t:899,w:4000000.000000}; case 394: return {t:776,w:0.000000};default: return {t:0,w:0.0};}};
case 776: return function (act:Int) {switch (act) { case 256: return {t:900,w:4000000.000000}; case 416: return {t:901,w:0.000000};default: return {t:0,w:0.0};}};
case 777: return function (act:Int) {switch (act) { case 256: return {t:774,w:4000000.750000}; case 393: return {t:902,w:0.693147}; case 394: return {t:903,w:0.693147};default: return {t:0,w:0.0};}};
case 778: return function (act:Int) {switch (act) { case 389: return {t:778,w:0.000000};default: return {t:0,w:0.0};}};
case 779: return function (act:Int) {switch (act) { case 256: return {t:904,w:4000000.000000}; case 417: return {t:905,w:0.000000};default: return {t:0,w:0.0};}};
case 780: return function (act:Int) {switch (act) { case 33: return {t:420,w:4.969814}; case 36: return {t:906,w:2.890372}; case 37: return {t:422,w:2.890372}; case 38: return {t:907,w:2.890372}; case 39: return {t:424,w:6.356108}; case 40: return {t:424,w:6.356108}; case 41: return {t:424,w:6.356108}; case 42: return {t:424,w:6.356108}; case 43: return {t:908,w:2.890372}; case 44: return {t:909,w:2.890372}; case 45: return {t:426,w:5.662961}; case 46: return {t:426,w:5.662961}; case 48: return {t:428,w:7.272399}; case 49: return {t:428,w:7.272399}; case 50: return {t:428,w:7.272399}; case 51: return {t:428,w:7.272399}; case 52: return {t:428,w:7.272399}; case 53: return {t:428,w:7.272399}; case 54: return {t:428,w:7.272399}; case 55: return {t:428,w:7.272399}; case 56: return {t:428,w:7.272399}; case 57: return {t:428,w:7.272399}; case 58: return {t:910,w:2.890372}; case 59: return {t:911,w:1.386294}; case 61: return {t:912,w:2.890372}; case 64: return {t:913,w:2.890372}; case 65: return {t:432,w:8.227911}; case 66: return {t:432,w:8.227911}; case 67: return {t:432,w:8.227911}; case 68: return {t:432,w:8.227911}; case 69: return {t:432,w:8.227911}; case 70: return {t:432,w:8.227911}; case 71: return {t:432,w:8.227911}; case 72: return {t:432,w:8.227911}; case 73: return {t:432,w:8.227911}; case 74: return {t:432,w:8.227911}; case 75: return {t:432,w:8.227911}; case 76: return {t:432,w:8.227911}; case 77: return {t:432,w:8.227911}; case 78: return {t:432,w:8.227911}; case 79: return {t:432,w:8.227911}; case 80: return {t:432,w:8.227911}; case 81: return {t:432,w:8.227911}; case 82: return {t:432,w:8.227911}; case 83: return {t:432,w:8.227911}; case 84: return {t:432,w:8.227911}; case 85: return {t:432,w:8.227911}; case 86: return {t:432,w:8.227911}; case 87: return {t:432,w:8.227911}; case 88: return {t:432,w:8.227911}; case 89: return {t:432,w:8.227911}; case 90: return {t:432,w:8.227911}; case 95: return {t:433,w:4.969814}; case 97: return {t:434,w:8.227911}; case 98: return {t:434,w:8.227911}; case 99: return {t:434,w:8.227911}; case 100: return {t:434,w:8.227911}; case 101: return {t:434,w:8.227911}; case 102: return {t:434,w:8.227911}; case 103: return {t:434,w:8.227911}; case 104: return {t:434,w:8.227911}; case 105: return {t:434,w:8.227911}; case 106: return {t:434,w:8.227911}; case 107: return {t:434,w:8.227911}; case 108: return {t:434,w:8.227911}; case 109: return {t:434,w:8.227911}; case 110: return {t:434,w:8.227911}; case 111: return {t:434,w:8.227911}; case 112: return {t:434,w:8.227911}; case 113: return {t:434,w:8.227911}; case 114: return {t:434,w:8.227911}; case 115: return {t:434,w:8.227911}; case 116: return {t:434,w:8.227911}; case 117: return {t:434,w:8.227911}; case 118: return {t:434,w:8.227911}; case 119: return {t:434,w:8.227911}; case 120: return {t:434,w:8.227911}; case 121: return {t:434,w:8.227911}; case 122: return {t:434,w:8.227911}; case 126: return {t:435,w:4.969814}; case 258: return {t:914,w:1.386294}; case 363: return {t:915,w:2.890372}; case 364: return {t:916,w:2.890372}; case 418: return {t:917,w:0.693147}; case 419: return {t:918,w:0.000000};default: return {t:0,w:0.0};}};
case 781: return function (act:Int) {switch (act) { case 258: return {t:919,w:0.000000};default: return {t:0,w:0.0};}};
case 782: return function (act:Int) {switch (act) { case 256: return {t:920,w:4000000.000000}; case 420: return {t:921,w:0.000000};default: return {t:0,w:0.0};}};
case 783: return function (act:Int) {switch (act) { case 361: return {t:783,w:0.000000};default: return {t:0,w:0.0};}};
case 784: return function (act:Int) {switch (act) { case 33: return {t:420,w:3.178054}; case 36: return {t:421,w:3.044522}; case 37: return {t:422,w:1.098612}; case 38: return {t:423,w:3.044522}; case 39: return {t:424,w:4.564348}; case 40: return {t:424,w:4.564348}; case 41: return {t:424,w:4.564348}; case 42: return {t:424,w:4.564348}; case 43: return {t:425,w:3.737669}; case 44: return {t:425,w:3.737669}; case 45: return {t:426,w:3.871201}; case 46: return {t:426,w:3.871201}; case 47: return {t:427,w:3.044522}; case 48: return {t:428,w:5.480639}; case 49: return {t:428,w:5.480639}; case 50: return {t:428,w:5.480639}; case 51: return {t:428,w:5.480639}; case 52: return {t:428,w:5.480639}; case 53: return {t:428,w:5.480639}; case 54: return {t:428,w:5.480639}; case 55: return {t:428,w:5.480639}; case 56: return {t:428,w:5.480639}; case 57: return {t:428,w:5.480639}; case 58: return {t:429,w:3.737669}; case 59: return {t:429,w:3.737669}; case 61: return {t:430,w:3.044522}; case 63: return {t:431,w:3.737669}; case 64: return {t:431,w:3.737669}; case 65: return {t:432,w:6.436151}; case 66: return {t:432,w:6.436151}; case 67: return {t:432,w:6.436151}; case 68: return {t:432,w:6.436151}; case 69: return {t:432,w:6.436151}; case 70: return {t:432,w:6.436151}; case 71: return {t:432,w:6.436151}; case 72: return {t:432,w:6.436151}; case 73: return {t:432,w:6.436151}; case 74: return {t:432,w:6.436151}; case 75: return {t:432,w:6.436151}; case 76: return {t:432,w:6.436151}; case 77: return {t:432,w:6.436151}; case 78: return {t:432,w:6.436151}; case 79: return {t:432,w:6.436151}; case 80: return {t:432,w:6.436151}; case 81: return {t:432,w:6.436151}; case 82: return {t:432,w:6.436151}; case 83: return {t:432,w:6.436151}; case 84: return {t:432,w:6.436151}; case 85: return {t:432,w:6.436151}; case 86: return {t:432,w:6.436151}; case 87: return {t:432,w:6.436151}; case 88: return {t:432,w:6.436151}; case 89: return {t:432,w:6.436151}; case 90: return {t:432,w:6.436151}; case 95: return {t:433,w:3.178054}; case 97: return {t:434,w:6.436151}; case 98: return {t:434,w:6.436151}; case 99: return {t:434,w:6.436151}; case 100: return {t:434,w:6.436151}; case 101: return {t:434,w:6.436151}; case 102: return {t:434,w:6.436151}; case 103: return {t:434,w:6.436151}; case 104: return {t:434,w:6.436151}; case 105: return {t:434,w:6.436151}; case 106: return {t:434,w:6.436151}; case 107: return {t:434,w:6.436151}; case 108: return {t:434,w:6.436151}; case 109: return {t:434,w:6.436151}; case 110: return {t:434,w:6.436151}; case 111: return {t:434,w:6.436151}; case 112: return {t:434,w:6.436151}; case 113: return {t:434,w:6.436151}; case 114: return {t:434,w:6.436151}; case 115: return {t:434,w:6.436151}; case 116: return {t:434,w:6.436151}; case 117: return {t:434,w:6.436151}; case 118: return {t:434,w:6.436151}; case 119: return {t:434,w:6.436151}; case 120: return {t:434,w:6.436151}; case 121: return {t:434,w:6.436151}; case 122: return {t:434,w:6.436151}; case 126: return {t:435,w:3.178054}; case 363: return {t:922,w:1.098612}; case 364: return {t:923,w:1.098612}; case 365: return {t:924,w:1.098612};default: return {t:0,w:0.0};}};
case 785: return function (act:Int) {switch (act) { case 362: return {t:785,w:0.000000};default: return {t:0,w:0.0};}};
case 786: return function (act:Int) {switch (act) { case 256: return {t:784,w:4000000.750000}; case 258: return {t:785,w:0.693147}; case 396: return {t:786,w:0.693147};default: return {t:0,w:0.0};}};
case 787: return function (act:Int) {switch (act) { case 258: return {t:925,w:0.000000};default: return {t:0,w:0.0};}};
case 788: return function (act:Int) {switch (act) { case 258: return {t:925,w:0.000000};default: return {t:0,w:0.0};}};
case 789: return function (act:Int) {switch (act) { case 258: return {t:925,w:0.000000};default: return {t:0,w:0.0};}};
case 790: return function (act:Int) {switch (act) { case 258: return {t:926,w:0.000000};default: return {t:0,w:0.0};}};
case 791: return function (act:Int) {switch (act) { case 367: return {t:791,w:0.000000};default: return {t:0,w:0.0};}};
case 792: return function (act:Int) {switch (act) { case 258: return {t:791,w:0.000000};default: return {t:0,w:0.0};}};
case 793: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:927,w:0.000000};default: return {t:0,w:0.0};}};
case 794: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:928,w:0.000000};default: return {t:0,w:0.0};}};
case 795: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:929,w:0.000000};default: return {t:0,w:0.0};}};
case 796: return function (act:Int) {switch (act) { case 45: return {t:930,w:0.000000}; case 256: return {t:212,w:4000000.000000}; case 344: return {t:931,w:0.000000};default: return {t:0,w:0.0};}};
case 797: return function (act:Int) {switch (act) { case 73: return {t:932,w:0.693147}; case 105: return {t:932,w:0.693147};default: return {t:0,w:0.0};}};
case 798: return function (act:Int) {switch (act) { case 256: return {t:933,w:4000000.750000}; case 258: return {t:934,w:0.693147}; case 271: return {t:935,w:0.693147};default: return {t:0,w:0.0};}};
case 799: return function (act:Int) {switch (act) { case 84: return {t:936,w:0.693147}; case 116: return {t:936,w:0.693147};default: return {t:0,w:0.0};}};
case 800: return function (act:Int) {switch (act) { case 73: return {t:937,w:0.693147}; case 105: return {t:937,w:0.693147};default: return {t:0,w:0.0};}};
case 801: return function (act:Int) {switch (act) { case 68: return {t:938,w:1.386294}; case 78: return {t:939,w:0.693147}; case 100: return {t:938,w:1.386294}; case 110: return {t:939,w:0.693147};default: return {t:0,w:0.0};}};
case 802: return function (act:Int) {switch (act) { case 84: return {t:940,w:0.693147}; case 116: return {t:940,w:0.693147};default: return {t:0,w:0.0};}};
case 803: return function (act:Int) {switch (act) { case 84: return {t:941,w:0.693147}; case 116: return {t:941,w:0.693147};default: return {t:0,w:0.0};}};
case 804: return function (act:Int) {switch (act) { case 256: return {t:942,w:4000000.750000}; case 336: return {t:943,w:0.693147}; case 377: return {t:944,w:0.693147};default: return {t:0,w:0.0};}};
case 805: return function (act:Int) {switch (act) { case 76: return {t:945,w:0.693147}; case 108: return {t:945,w:0.693147};default: return {t:0,w:0.0};}};
case 806: return function (act:Int) {switch (act) { case 73: return {t:946,w:0.693147}; case 105: return {t:946,w:0.693147};default: return {t:0,w:0.0};}};
case 807: return function (act:Int) {switch (act) { case 71: return {t:947,w:0.693147}; case 103: return {t:947,w:0.693147};default: return {t:0,w:0.0};}};
case 808: return function (act:Int) {switch (act) { case 83: return {t:948,w:0.693147}; case 115: return {t:948,w:0.693147};default: return {t:0,w:0.0};}};
case 809: return function (act:Int) {switch (act) { case 84: return {t:949,w:0.693147}; case 116: return {t:949,w:0.693147};default: return {t:0,w:0.0};}};
case 810: return function (act:Int) {switch (act) { case 84: return {t:950,w:0.693147}; case 116: return {t:950,w:0.693147};default: return {t:0,w:0.0};}};
case 811: return function (act:Int) {switch (act) { case 69: return {t:951,w:0.693147}; case 101: return {t:951,w:0.693147};default: return {t:0,w:0.0};}};
case 812: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895};default: return {t:0,w:0.0};}};
case 813: return function (act:Int) {switch (act) { case 258: return {t:952,w:0.000000};default: return {t:0,w:0.0};}};
case 814: return function (act:Int) {switch (act) { case 372: return {t:814,w:0.000000};default: return {t:0,w:0.0};}};
case 815: return function (act:Int) {switch (act) { case 373: return {t:815,w:0.000000};default: return {t:0,w:0.0};}};
case 816: return function (act:Int) {switch (act) { case 47: return {t:953,w:0.000000};default: return {t:0,w:0.0};}};
case 817: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:954,w:2.079441}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:955,w:2.079441}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:956,w:0.693147}; case 369: return {t:478,w:1.386294}; case 370: return {t:479,w:1.386294}; case 371: return {t:957,w:0.693147}; case 421: return {t:958,w:0.693147};default: return {t:0,w:0.0};}};
case 818: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:959,w:0.693147}; case 384: return {t:960,w:0.693147};default: return {t:0,w:0.0};}};
case 819: return function (act:Int) {switch (act) { case 70: return {t:961,w:2.639057}; case 77: return {t:962,w:2.639057}; case 83: return {t:963,w:2.639057}; case 84: return {t:964,w:2.639057}; case 87: return {t:965,w:2.639057}; case 102: return {t:961,w:2.639057}; case 109: return {t:962,w:2.639057}; case 115: return {t:963,w:2.639057}; case 116: return {t:964,w:2.639057}; case 119: return {t:965,w:2.639057}; case 422: return {t:966,w:0.000000}; case 423: return {t:967,w:0.000000};default: return {t:0,w:0.0};}};
case 820: return function (act:Int) {switch (act) { case 258: return {t:968,w:0.000000};default: return {t:0,w:0.0};}};
case 821: return function (act:Int) {switch (act) { case 73: return {t:969,w:0.693147}; case 105: return {t:969,w:0.693147};default: return {t:0,w:0.0};}};
case 822: return function (act:Int) {switch (act) { case 83: return {t:970,w:0.693147}; case 115: return {t:970,w:0.693147};default: return {t:0,w:0.0};}};
case 823: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:971,w:0.000000};default: return {t:0,w:0.0};}};
case 824: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.000000}; case 377: return {t:972,w:0.000000};default: return {t:0,w:0.0};}};
case 825: return function (act:Int) {switch (act) { case 256: return {t:679,w:4000000.750000}; case 258: return {t:682,w:0.693147}; case 376: return {t:825,w:0.693147};default: return {t:0,w:0.0};}};
case 826: return function (act:Int) {switch (act) { case 379: return {t:826,w:0.000000};default: return {t:0,w:0.0};}};
case 827: return function (act:Int) {switch (act) { case 9: return {t:493,w:3.745732}; case 13: return {t:83,w:3.745732}; case 32: return {t:494,w:3.745732}; case 33: return {t:973,w:2.359438}; case 34: return {t:516,w:0.000000}; case 35: return {t:974,w:6.402489}; case 36: return {t:974,w:6.402489}; case 37: return {t:974,w:6.402489}; case 38: return {t:974,w:6.402489}; case 39: return {t:974,w:6.402489}; case 40: return {t:974,w:6.402489}; case 41: return {t:974,w:6.402489}; case 42: return {t:974,w:6.402489}; case 43: return {t:974,w:6.402489}; case 44: return {t:974,w:6.402489}; case 45: return {t:974,w:6.402489}; case 46: return {t:974,w:6.402489}; case 47: return {t:974,w:6.402489}; case 48: return {t:974,w:6.402489}; case 49: return {t:974,w:6.402489}; case 50: return {t:974,w:6.402489}; case 51: return {t:974,w:6.402489}; case 52: return {t:974,w:6.402489}; case 53: return {t:974,w:6.402489}; case 54: return {t:974,w:6.402489}; case 55: return {t:974,w:6.402489}; case 56: return {t:974,w:6.402489}; case 57: return {t:974,w:6.402489}; case 58: return {t:974,w:6.402489}; case 59: return {t:974,w:6.402489}; case 60: return {t:974,w:6.402489}; case 61: return {t:974,w:6.402489}; case 62: return {t:974,w:6.402489}; case 63: return {t:974,w:6.402489}; case 64: return {t:974,w:6.402489}; case 65: return {t:974,w:6.402489}; case 66: return {t:974,w:6.402489}; case 67: return {t:974,w:6.402489}; case 68: return {t:974,w:6.402489}; case 69: return {t:974,w:6.402489}; case 70: return {t:974,w:6.402489}; case 71: return {t:974,w:6.402489}; case 72: return {t:974,w:6.402489}; case 73: return {t:974,w:6.402489}; case 74: return {t:974,w:6.402489}; case 75: return {t:974,w:6.402489}; case 76: return {t:974,w:6.402489}; case 77: return {t:974,w:6.402489}; case 78: return {t:974,w:6.402489}; case 79: return {t:974,w:6.402489}; case 80: return {t:974,w:6.402489}; case 81: return {t:974,w:6.402489}; case 82: return {t:974,w:6.402489}; case 83: return {t:974,w:6.402489}; case 84: return {t:974,w:6.402489}; case 85: return {t:974,w:6.402489}; case 86: return {t:974,w:6.402489}; case 87: return {t:974,w:6.402489}; case 88: return {t:974,w:6.402489}; case 89: return {t:974,w:6.402489}; case 90: return {t:974,w:6.402489}; case 91: return {t:974,w:6.402489}; case 92: return {t:975,w:0.750000}; case 93: return {t:976,w:5.885799}; case 94: return {t:976,w:5.885799}; case 95: return {t:976,w:5.885799}; case 96: return {t:976,w:5.885799}; case 97: return {t:976,w:5.885799}; case 98: return {t:976,w:5.885799}; case 99: return {t:976,w:5.885799}; case 100: return {t:976,w:5.885799}; case 101: return {t:976,w:5.885799}; case 102: return {t:976,w:5.885799}; case 103: return {t:976,w:5.885799}; case 104: return {t:976,w:5.885799}; case 105: return {t:976,w:5.885799}; case 106: return {t:976,w:5.885799}; case 107: return {t:976,w:5.885799}; case 108: return {t:976,w:5.885799}; case 109: return {t:976,w:5.885799}; case 110: return {t:976,w:5.885799}; case 111: return {t:976,w:5.885799}; case 112: return {t:976,w:5.885799}; case 113: return {t:976,w:5.885799}; case 114: return {t:976,w:5.885799}; case 115: return {t:976,w:5.885799}; case 116: return {t:976,w:5.885799}; case 117: return {t:976,w:5.885799}; case 118: return {t:976,w:5.885799}; case 119: return {t:976,w:5.885799}; case 120: return {t:976,w:5.885799}; case 121: return {t:976,w:5.885799}; case 122: return {t:976,w:5.885799}; case 123: return {t:976,w:5.885799}; case 124: return {t:976,w:5.885799}; case 125: return {t:976,w:5.885799}; case 126: return {t:976,w:5.885799}; case 192: return {t:437,w:7.434612}; case 193: return {t:437,w:7.434612}; case 194: return {t:437,w:7.434612}; case 195: return {t:437,w:7.434612}; case 196: return {t:437,w:7.434612}; case 197: return {t:437,w:7.434612}; case 198: return {t:437,w:7.434612}; case 199: return {t:437,w:7.434612}; case 200: return {t:437,w:7.434612}; case 201: return {t:437,w:7.434612}; case 202: return {t:437,w:7.434612}; case 203: return {t:437,w:7.434612}; case 204: return {t:437,w:7.434612}; case 205: return {t:437,w:7.434612}; case 206: return {t:437,w:7.434612}; case 207: return {t:437,w:7.434612}; case 208: return {t:437,w:7.434612}; case 209: return {t:437,w:7.434612}; case 210: return {t:437,w:7.434612}; case 211: return {t:437,w:7.434612}; case 212: return {t:437,w:7.434612}; case 213: return {t:437,w:7.434612}; case 214: return {t:437,w:7.434612}; case 215: return {t:437,w:7.434612}; case 216: return {t:437,w:7.434612}; case 217: return {t:437,w:7.434612}; case 218: return {t:437,w:7.434612}; case 219: return {t:437,w:7.434612}; case 220: return {t:437,w:7.434612}; case 221: return {t:437,w:7.434612}; case 222: return {t:437,w:7.434612}; case 223: return {t:437,w:7.434612}; case 224: return {t:438,w:6.741465}; case 225: return {t:438,w:6.741465}; case 226: return {t:438,w:6.741465}; case 227: return {t:438,w:6.741465}; case 228: return {t:438,w:6.741465}; case 229: return {t:438,w:6.741465}; case 230: return {t:438,w:6.741465}; case 231: return {t:438,w:6.741465}; case 232: return {t:438,w:6.741465}; case 233: return {t:438,w:6.741465}; case 234: return {t:438,w:6.741465}; case 235: return {t:438,w:6.741465}; case 236: return {t:438,w:6.741465}; case 237: return {t:438,w:6.741465}; case 238: return {t:438,w:6.741465}; case 239: return {t:438,w:6.741465}; case 240: return {t:439,w:6.048318}; case 241: return {t:439,w:6.048318}; case 242: return {t:439,w:6.048318}; case 243: return {t:439,w:6.048318}; case 244: return {t:439,w:6.048318}; case 245: return {t:439,w:6.048318}; case 246: return {t:439,w:6.048318}; case 247: return {t:439,w:6.048318}; case 248: return {t:440,w:5.355170}; case 249: return {t:440,w:5.355170}; case 250: return {t:440,w:5.355170}; case 251: return {t:440,w:5.355170}; case 252: return {t:441,w:4.662023}; case 253: return {t:441,w:4.662023}; case 279: return {t:504,w:3.745732}; case 283: return {t:119,w:3.745732}; case 367: return {t:978,w:2.359438}; case 376: return {t:505,w:3.052585}; case 377: return {t:977,w:2.359438};default: return {t:0,w:0.0};}};
case 828: return function (act:Int) {switch (act) { case 258: return {t:979,w:0.000000};default: return {t:0,w:0.0};}};
case 829: return function (act:Int) {switch (act) { case 256: return {t:827,w:4000000.750000}; case 381: return {t:828,w:0.693147}; case 399: return {t:829,w:1.386294}; case 400: return {t:830,w:1.386294};default: return {t:0,w:0.0};}};
case 830: return function (act:Int) {switch (act) { case 256: return {t:827,w:4000000.750000}; case 381: return {t:828,w:0.693147}; case 399: return {t:829,w:1.386294}; case 400: return {t:830,w:1.386294};default: return {t:0,w:0.0};}};
case 831: return function (act:Int) {switch (act) { case 62: return {t:980,w:0.000000};default: return {t:0,w:0.0};}};
case 832: return function (act:Int) {switch (act) { case 258: return {t:981,w:0.000000};default: return {t:0,w:0.0};}};
case 833: return function (act:Int) {switch (act) { case 60: return {t:686,w:0.000000};default: return {t:0,w:0.0};}};
case 834: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:860,w:1.386294}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:861,w:1.386294}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:862,w:0.693147}; case 404: return {t:982,w:0.693147}; case 405: return {t:983,w:0.693147};default: return {t:0,w:0.0};}};
case 835: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:694,w:0.693147}; case 384: return {t:695,w:0.693147};default: return {t:0,w:0.0};}};
case 836: return function (act:Int) {switch (act) { case 76: return {t:984,w:0.693147}; case 108: return {t:984,w:0.693147};default: return {t:0,w:0.0};}};
case 837: return function (act:Int) {switch (act) { case 33: return {t:515,w:3.178054}; case 34: return {t:516,w:3.178054}; case 37: return {t:517,w:3.178054}; case 39: return {t:518,w:3.178054}; case 40: return {t:519,w:3.178054}; case 41: return {t:520,w:3.178054}; case 42: return {t:521,w:3.178054}; case 43: return {t:522,w:3.178054}; case 45: return {t:523,w:3.178054}; case 46: return {t:524,w:3.178054}; case 47: return {t:525,w:3.178054}; case 48: return {t:9,w:6.579251}; case 49: return {t:9,w:6.579251}; case 50: return {t:9,w:6.579251}; case 51: return {t:9,w:6.579251}; case 52: return {t:9,w:6.579251}; case 53: return {t:9,w:6.579251}; case 54: return {t:9,w:6.579251}; case 55: return {t:9,w:6.579251}; case 56: return {t:9,w:6.579251}; case 57: return {t:9,w:6.579251}; case 58: return {t:526,w:3.178054}; case 60: return {t:527,w:3.178054}; case 62: return {t:528,w:3.178054}; case 63: return {t:529,w:3.178054}; case 65: return {t:13,w:7.534763}; case 66: return {t:13,w:7.534763}; case 67: return {t:13,w:7.534763}; case 68: return {t:13,w:7.534763}; case 69: return {t:13,w:7.534763}; case 70: return {t:13,w:7.534763}; case 71: return {t:13,w:7.534763}; case 72: return {t:13,w:7.534763}; case 73: return {t:13,w:7.534763}; case 74: return {t:13,w:7.534763}; case 75: return {t:13,w:7.534763}; case 76: return {t:13,w:7.534763}; case 77: return {t:13,w:7.534763}; case 78: return {t:13,w:7.534763}; case 79: return {t:13,w:7.534763}; case 80: return {t:13,w:7.534763}; case 81: return {t:13,w:7.534763}; case 82: return {t:13,w:7.534763}; case 83: return {t:13,w:7.534763}; case 84: return {t:13,w:7.534763}; case 85: return {t:13,w:7.534763}; case 86: return {t:13,w:7.534763}; case 87: return {t:13,w:7.534763}; case 88: return {t:13,w:7.534763}; case 89: return {t:13,w:7.534763}; case 90: return {t:13,w:7.534763}; case 91: return {t:530,w:3.178054}; case 92: return {t:531,w:3.178054}; case 93: return {t:532,w:3.178054}; case 95: return {t:533,w:3.178054}; case 96: return {t:534,w:3.178054}; case 97: return {t:20,w:7.534763}; case 98: return {t:20,w:7.534763}; case 99: return {t:20,w:7.534763}; case 100: return {t:20,w:7.534763}; case 101: return {t:20,w:7.534763}; case 102: return {t:20,w:7.534763}; case 103: return {t:20,w:7.534763}; case 104: return {t:20,w:7.534763}; case 105: return {t:20,w:7.534763}; case 106: return {t:20,w:7.534763}; case 107: return {t:20,w:7.534763}; case 108: return {t:20,w:7.534763}; case 109: return {t:20,w:7.534763}; case 110: return {t:20,w:7.534763}; case 111: return {t:20,w:7.534763}; case 112: return {t:20,w:7.534763}; case 113: return {t:20,w:7.534763}; case 114: return {t:20,w:7.534763}; case 115: return {t:20,w:7.534763}; case 116: return {t:20,w:7.534763}; case 117: return {t:20,w:7.534763}; case 118: return {t:20,w:7.534763}; case 119: return {t:20,w:7.534763}; case 120: return {t:20,w:7.534763}; case 121: return {t:20,w:7.534763}; case 122: return {t:20,w:7.534763}; case 123: return {t:535,w:3.178054}; case 125: return {t:536,w:3.178054}; case 126: return {t:537,w:3.178054}; case 268: return {t:538,w:3.178054}; case 381: return {t:539,w:3.178054};default: return {t:0,w:0.0};}};
case 838: return function (act:Int) {switch (act) { case 258: return {t:725,w:0.000000};default: return {t:0,w:0.0};}};
case 839: return function (act:Int) {switch (act) { case 82: return {t:985,w:0.693147}; case 114: return {t:985,w:0.693147};default: return {t:0,w:0.0};}};
case 840: return function (act:Int) {switch (act) { case 69: return {t:986,w:0.693147}; case 101: return {t:986,w:0.693147};default: return {t:0,w:0.0};}};
case 841: return function (act:Int) {switch (act) { case 80: return {t:987,w:0.693147}; case 112: return {t:987,w:0.693147};default: return {t:0,w:0.0};}};
case 842: return function (act:Int) {switch (act) { case 258: return {t:988,w:0.000000};default: return {t:0,w:0.0};}};
case 843: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.496507}; case 37: return {t:3,w:3.496507}; case 39: return {t:4,w:3.496507}; case 42: return {t:5,w:3.496507}; case 43: return {t:6,w:3.496507}; case 45: return {t:7,w:3.496507}; case 46: return {t:8,w:3.496507}; case 48: return {t:9,w:6.897704}; case 49: return {t:9,w:6.897704}; case 50: return {t:9,w:6.897704}; case 51: return {t:9,w:6.897704}; case 52: return {t:9,w:6.897704}; case 53: return {t:9,w:6.897704}; case 54: return {t:9,w:6.897704}; case 55: return {t:9,w:6.897704}; case 56: return {t:9,w:6.897704}; case 57: return {t:9,w:6.897704}; case 65: return {t:13,w:7.853216}; case 66: return {t:13,w:7.853216}; case 67: return {t:13,w:7.853216}; case 68: return {t:13,w:7.853216}; case 69: return {t:989,w:1.791759}; case 70: return {t:13,w:7.853216}; case 71: return {t:13,w:7.853216}; case 72: return {t:13,w:7.853216}; case 73: return {t:13,w:7.853216}; case 74: return {t:13,w:7.853216}; case 75: return {t:13,w:7.853216}; case 76: return {t:13,w:7.853216}; case 77: return {t:13,w:7.853216}; case 78: return {t:13,w:7.853216}; case 79: return {t:13,w:7.853216}; case 80: return {t:13,w:7.853216}; case 81: return {t:990,w:1.791759}; case 82: return {t:13,w:7.853216}; case 83: return {t:13,w:7.853216}; case 84: return {t:13,w:7.853216}; case 85: return {t:13,w:7.853216}; case 86: return {t:13,w:7.853216}; case 87: return {t:13,w:7.853216}; case 88: return {t:13,w:7.853216}; case 89: return {t:13,w:7.853216}; case 90: return {t:13,w:7.853216}; case 95: return {t:18,w:3.496507}; case 96: return {t:19,w:3.496507}; case 97: return {t:20,w:7.853216}; case 98: return {t:20,w:7.853216}; case 99: return {t:20,w:7.853216}; case 100: return {t:20,w:7.853216}; case 101: return {t:991,w:1.791759}; case 102: return {t:20,w:7.853216}; case 103: return {t:20,w:7.853216}; case 104: return {t:20,w:7.853216}; case 105: return {t:20,w:7.853216}; case 106: return {t:20,w:7.853216}; case 107: return {t:20,w:7.853216}; case 108: return {t:20,w:7.853216}; case 109: return {t:20,w:7.853216}; case 110: return {t:20,w:7.853216}; case 111: return {t:20,w:7.853216}; case 112: return {t:20,w:7.853216}; case 113: return {t:992,w:1.791759}; case 114: return {t:20,w:7.853216}; case 115: return {t:20,w:7.853216}; case 116: return {t:20,w:7.853216}; case 117: return {t:20,w:7.853216}; case 118: return {t:20,w:7.853216}; case 119: return {t:20,w:7.853216}; case 120: return {t:20,w:7.853216}; case 121: return {t:20,w:7.853216}; case 122: return {t:20,w:7.853216}; case 126: return {t:22,w:3.496507}; case 268: return {t:29,w:3.496507}; case 269: return {t:862,w:1.098612}; case 404: return {t:993,w:1.098612}; case 424: return {t:994,w:1.098612}; case 425: return {t:995,w:1.098612}; case 426: return {t:996,w:1.098612};default: return {t:0,w:0.0};}};
case 844: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:732,w:0.693147}; case 384: return {t:733,w:0.693147};default: return {t:0,w:0.0};}};
case 845: return function (act:Int) {switch (act) { case 90: return {t:997,w:0.693147}; case 122: return {t:997,w:0.693147};default: return {t:0,w:0.0};}};
case 846: return function (act:Int) {switch (act) { case 84: return {t:998,w:0.693147}; case 116: return {t:998,w:0.693147};default: return {t:0,w:0.0};}};
case 847: return function (act:Int) {switch (act) { case 65: return {t:999,w:0.693147}; case 82: return {t:1000,w:0.693147}; case 97: return {t:999,w:0.693147}; case 114: return {t:1000,w:0.693147};default: return {t:0,w:0.0};}};
case 848: return function (act:Int) {switch (act) { case 45: return {t:1001,w:0.000000};default: return {t:0,w:0.0};}};
case 849: return function (act:Int) {switch (act) { case 84: return {t:1002,w:0.693147}; case 116: return {t:1002,w:0.693147};default: return {t:0,w:0.0};}};
case 850: return function (act:Int) {switch (act) { case 69: return {t:1003,w:0.693147}; case 101: return {t:1003,w:0.693147};default: return {t:0,w:0.0};}};
case 851: return function (act:Int) {switch (act) { case 65: return {t:1004,w:0.693147}; case 97: return {t:1004,w:0.693147};default: return {t:0,w:0.0};}};
case 852: return function (act:Int) {switch (act) { case 256: return {t:1005,w:4000000.000000}; case 427: return {t:1006,w:0.000000};default: return {t:0,w:0.0};}};
case 853: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1007,w:0.000000};default: return {t:0,w:0.0};}};
case 854: return function (act:Int) {switch (act) { case 84: return {t:1008,w:0.693147}; case 116: return {t:1008,w:0.693147};default: return {t:0,w:0.0};}};
case 855: return function (act:Int) {switch (act) { case 84: return {t:1009,w:0.693147}; case 116: return {t:1009,w:0.693147};default: return {t:0,w:0.0};}};
case 856: return function (act:Int) {switch (act) { case 9: return {t:493,w:1.386294}; case 13: return {t:83,w:1.386294}; case 32: return {t:494,w:1.386294}; case 33: return {t:566,w:5.236442}; case 34: return {t:566,w:5.236442}; case 35: return {t:566,w:5.236442}; case 36: return {t:566,w:5.236442}; case 37: return {t:566,w:5.236442}; case 38: return {t:566,w:5.236442}; case 39: return {t:566,w:5.236442}; case 40: return {t:566,w:5.236442}; case 41: return {t:566,w:5.236442}; case 42: return {t:566,w:5.236442}; case 43: return {t:566,w:5.236442}; case 44: return {t:566,w:5.236442}; case 45: return {t:566,w:5.236442}; case 46: return {t:566,w:5.236442}; case 47: return {t:566,w:5.236442}; case 48: return {t:566,w:5.236442}; case 49: return {t:566,w:5.236442}; case 50: return {t:566,w:5.236442}; case 51: return {t:566,w:5.236442}; case 52: return {t:566,w:5.236442}; case 53: return {t:566,w:5.236442}; case 54: return {t:566,w:5.236442}; case 55: return {t:566,w:5.236442}; case 56: return {t:566,w:5.236442}; case 57: return {t:566,w:5.236442}; case 58: return {t:566,w:5.236442}; case 59: return {t:566,w:5.236442}; case 60: return {t:566,w:5.236442}; case 61: return {t:566,w:5.236442}; case 62: return {t:566,w:5.236442}; case 63: return {t:566,w:5.236442}; case 64: return {t:566,w:5.236442}; case 65: return {t:566,w:5.236442}; case 66: return {t:566,w:5.236442}; case 67: return {t:566,w:5.236442}; case 68: return {t:566,w:5.236442}; case 69: return {t:566,w:5.236442}; case 70: return {t:566,w:5.236442}; case 71: return {t:566,w:5.236442}; case 72: return {t:566,w:5.236442}; case 73: return {t:566,w:5.236442}; case 74: return {t:566,w:5.236442}; case 75: return {t:566,w:5.236442}; case 76: return {t:566,w:5.236442}; case 77: return {t:566,w:5.236442}; case 78: return {t:566,w:5.236442}; case 79: return {t:566,w:5.236442}; case 80: return {t:566,w:5.236442}; case 81: return {t:566,w:5.236442}; case 82: return {t:566,w:5.236442}; case 83: return {t:566,w:5.236442}; case 84: return {t:566,w:5.236442}; case 85: return {t:566,w:5.236442}; case 86: return {t:566,w:5.236442}; case 87: return {t:566,w:5.236442}; case 88: return {t:566,w:5.236442}; case 89: return {t:566,w:5.236442}; case 90: return {t:566,w:5.236442}; case 91: return {t:566,w:5.236442}; case 92: return {t:566,w:5.236442}; case 93: return {t:566,w:5.236442}; case 94: return {t:566,w:5.236442}; case 95: return {t:566,w:5.236442}; case 96: return {t:566,w:5.236442}; case 97: return {t:566,w:5.236442}; case 98: return {t:566,w:5.236442}; case 99: return {t:566,w:5.236442}; case 100: return {t:566,w:5.236442}; case 101: return {t:566,w:5.236442}; case 102: return {t:566,w:5.236442}; case 103: return {t:566,w:5.236442}; case 104: return {t:566,w:5.236442}; case 105: return {t:566,w:5.236442}; case 106: return {t:566,w:5.236442}; case 107: return {t:566,w:5.236442}; case 108: return {t:566,w:5.236442}; case 109: return {t:566,w:5.236442}; case 110: return {t:566,w:5.236442}; case 111: return {t:566,w:5.236442}; case 112: return {t:566,w:5.236442}; case 113: return {t:566,w:5.236442}; case 114: return {t:566,w:5.236442}; case 115: return {t:566,w:5.236442}; case 116: return {t:566,w:5.236442}; case 117: return {t:566,w:5.236442}; case 118: return {t:566,w:5.236442}; case 119: return {t:566,w:5.236442}; case 120: return {t:566,w:5.236442}; case 121: return {t:566,w:5.236442}; case 122: return {t:566,w:5.236442}; case 123: return {t:566,w:5.236442}; case 124: return {t:566,w:5.236442}; case 125: return {t:566,w:5.236442}; case 126: return {t:566,w:5.236442}; case 192: return {t:437,w:5.768321}; case 193: return {t:437,w:5.768321}; case 194: return {t:437,w:5.768321}; case 195: return {t:437,w:5.768321}; case 196: return {t:437,w:5.768321}; case 197: return {t:437,w:5.768321}; case 198: return {t:437,w:5.768321}; case 199: return {t:437,w:5.768321}; case 200: return {t:437,w:5.768321}; case 201: return {t:437,w:5.768321}; case 202: return {t:437,w:5.768321}; case 203: return {t:437,w:5.768321}; case 204: return {t:437,w:5.768321}; case 205: return {t:437,w:5.768321}; case 206: return {t:437,w:5.768321}; case 207: return {t:437,w:5.768321}; case 208: return {t:437,w:5.768321}; case 209: return {t:437,w:5.768321}; case 210: return {t:437,w:5.768321}; case 211: return {t:437,w:5.768321}; case 212: return {t:437,w:5.768321}; case 213: return {t:437,w:5.768321}; case 214: return {t:437,w:5.768321}; case 215: return {t:437,w:5.768321}; case 216: return {t:437,w:5.768321}; case 217: return {t:437,w:5.768321}; case 218: return {t:437,w:5.768321}; case 219: return {t:437,w:5.768321}; case 220: return {t:437,w:5.768321}; case 221: return {t:437,w:5.768321}; case 222: return {t:437,w:5.768321}; case 223: return {t:437,w:5.768321}; case 224: return {t:438,w:5.075174}; case 225: return {t:438,w:5.075174}; case 226: return {t:438,w:5.075174}; case 227: return {t:438,w:5.075174}; case 228: return {t:438,w:5.075174}; case 229: return {t:438,w:5.075174}; case 230: return {t:438,w:5.075174}; case 231: return {t:438,w:5.075174}; case 232: return {t:438,w:5.075174}; case 233: return {t:438,w:5.075174}; case 234: return {t:438,w:5.075174}; case 235: return {t:438,w:5.075174}; case 236: return {t:438,w:5.075174}; case 237: return {t:438,w:5.075174}; case 238: return {t:438,w:5.075174}; case 239: return {t:438,w:5.075174}; case 240: return {t:439,w:4.382027}; case 241: return {t:439,w:4.382027}; case 242: return {t:439,w:4.382027}; case 243: return {t:439,w:4.382027}; case 244: return {t:439,w:4.382027}; case 245: return {t:439,w:4.382027}; case 246: return {t:439,w:4.382027}; case 247: return {t:439,w:4.382027}; case 248: return {t:440,w:3.688879}; case 249: return {t:440,w:3.688879}; case 250: return {t:440,w:3.688879}; case 251: return {t:440,w:3.688879}; case 252: return {t:441,w:2.995732}; case 253: return {t:441,w:2.995732}; case 279: return {t:504,w:1.386294}; case 283: return {t:119,w:1.386294}; case 367: return {t:567,w:0.693147}; case 376: return {t:505,w:0.693147};default: return {t:0,w:0.0};}};
case 857: return function (act:Int) {switch (act) { case 256: return {t:856,w:4000001.500000}; case 258: return {t:749,w:0.693147}; case 377: return {t:750,w:1.386294}; case 383: return {t:857,w:1.386294};default: return {t:0,w:0.0};}};
case 858: return function (act:Int) {switch (act) { case 65: return {t:1010,w:0.693147}; case 97: return {t:1010,w:0.693147};default: return {t:0,w:0.0};}};
case 859: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:1011,w:0.000000};default: return {t:0,w:0.0};}};
case 860: return function (act:Int) {switch (act) { case 65: return {t:1012,w:0.693147}; case 97: return {t:1012,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 861: return function (act:Int) {switch (act) { case 65: return {t:1012,w:0.693147}; case 97: return {t:1012,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 862: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.750000}; case 258: return {t:1014,w:0.693147}; case 428: return {t:1015,w:0.693147};default: return {t:0,w:0.0};}};
case 863: return function (act:Int) {switch (act) { case 258: return {t:1016,w:0.000000};default: return {t:0,w:0.0};}};
case 864: return function (act:Int) {switch (act) { case 258: return {t:1016,w:0.000000};default: return {t:0,w:0.0};}};
case 865: return function (act:Int) {switch (act) { case 79: return {t:1017,w:0.693147}; case 111: return {t:1017,w:0.693147};default: return {t:0,w:0.0};}};
case 866: return function (act:Int) {switch (act) { case 71: return {t:1018,w:0.693147}; case 103: return {t:1018,w:0.693147};default: return {t:0,w:0.0};}};
case 867: return function (act:Int) {switch (act) { case 258: return {t:759,w:0.000000};default: return {t:0,w:0.0};}};
case 868: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:1019,w:0.000000};default: return {t:0,w:0.0};}};
case 869: return function (act:Int) {switch (act) { case 256: return {t:665,w:4000000.000000}; case 391: return {t:1020,w:0.000000};default: return {t:0,w:0.0};}};
case 870: return function (act:Int) {switch (act) { case 48: return {t:1021,w:3.401197}; case 49: return {t:1021,w:3.401197}; case 50: return {t:1021,w:3.401197}; case 51: return {t:1021,w:3.401197}; case 52: return {t:1021,w:3.401197}; case 53: return {t:1021,w:3.401197}; case 54: return {t:1021,w:3.401197}; case 55: return {t:1021,w:3.401197}; case 56: return {t:1021,w:3.401197}; case 57: return {t:1021,w:3.401197}; case 65: return {t:1022,w:6.436150}; case 66: return {t:1022,w:6.436150}; case 67: return {t:1022,w:6.436150}; case 68: return {t:1022,w:6.436150}; case 69: return {t:1022,w:6.436150}; case 70: return {t:1022,w:6.436150}; case 71: return {t:1022,w:6.436150}; case 72: return {t:1022,w:6.436150}; case 73: return {t:1022,w:6.436150}; case 74: return {t:1022,w:6.436150}; case 75: return {t:1022,w:6.436150}; case 76: return {t:1022,w:6.436150}; case 77: return {t:1022,w:6.436150}; case 78: return {t:1022,w:6.436150}; case 79: return {t:1022,w:6.436150}; case 80: return {t:1022,w:6.436150}; case 81: return {t:1022,w:6.436150}; case 82: return {t:1022,w:6.436150}; case 83: return {t:1022,w:6.436150}; case 84: return {t:1022,w:6.436150}; case 85: return {t:1022,w:6.436150}; case 86: return {t:1022,w:6.436150}; case 87: return {t:1022,w:6.436150}; case 88: return {t:1022,w:6.436150}; case 89: return {t:1022,w:6.436150}; case 90: return {t:1022,w:6.436150}; case 91: return {t:884,w:1.098612}; case 97: return {t:1023,w:6.436150}; case 98: return {t:1023,w:6.436150}; case 99: return {t:1023,w:6.436150}; case 100: return {t:1023,w:6.436150}; case 101: return {t:1023,w:6.436150}; case 102: return {t:1023,w:6.436150}; case 103: return {t:1023,w:6.436150}; case 104: return {t:1023,w:6.436150}; case 105: return {t:1023,w:6.436150}; case 106: return {t:1023,w:6.436150}; case 107: return {t:1023,w:6.436150}; case 108: return {t:1023,w:6.436150}; case 109: return {t:1023,w:6.436150}; case 110: return {t:1023,w:6.436150}; case 111: return {t:1023,w:6.436150}; case 112: return {t:1023,w:6.436150}; case 113: return {t:1023,w:6.436150}; case 114: return {t:1023,w:6.436150}; case 115: return {t:1023,w:6.436150}; case 116: return {t:1023,w:6.436150}; case 117: return {t:1023,w:6.436150}; case 118: return {t:1023,w:6.436150}; case 119: return {t:1023,w:6.436150}; case 120: return {t:1023,w:6.436150}; case 121: return {t:1023,w:6.436150}; case 122: return {t:1023,w:6.436150}; case 268: return {t:886,w:2.484906}; case 331: return {t:892,w:2.484906}; case 336: return {t:895,w:1.098612}; case 410: return {t:891,w:1.791759}; case 411: return {t:893,w:1.791759}; case 412: return {t:894,w:1.098612}; case 413: return {t:896,w:1.098612}; case 414: return {t:897,w:1.098612}; case 415: return {t:1024,w:0.000000};default: return {t:0,w:0.0};}};
case 871: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1025,w:0.693147}; case 384: return {t:1026,w:0.693147};default: return {t:0,w:0.0};}};
case 872: return function (act:Int) {switch (act) { case 71: return {t:1027,w:0.693147}; case 103: return {t:1027,w:0.693147};default: return {t:0,w:0.0};}};
case 873: return function (act:Int) {switch (act) { case 84: return {t:1028,w:0.693147}; case 116: return {t:1028,w:0.693147};default: return {t:0,w:0.0};}};
case 874: return function (act:Int) {switch (act) { case 267: return {t:874,w:0.000000};default: return {t:0,w:0.0};}};
case 875: return function (act:Int) {switch (act) { case 258: return {t:1029,w:0.000000};default: return {t:0,w:0.0};}};
case 876: return function (act:Int) {switch (act) { case 258: return {t:1029,w:0.000000};default: return {t:0,w:0.0};}};
case 877: return function (act:Int) {switch (act) { case 258: return {t:1029,w:0.000000};default: return {t:0,w:0.0};}};
case 878: return function (act:Int) {switch (act) { case 258: return {t:1029,w:0.000000};default: return {t:0,w:0.0};}};
case 879: return function (act:Int) {switch (act) { case 258: return {t:1030,w:0.000000};default: return {t:0,w:0.0};}};
case 880: return function (act:Int) {switch (act) { case 258: return {t:1029,w:0.000000};default: return {t:0,w:0.0};}};
case 881: return function (act:Int) {switch (act) { case 258: return {t:1029,w:0.000000};default: return {t:0,w:0.0};}};
case 882: return function (act:Int) {switch (act) { case 258: return {t:1029,w:0.000000};default: return {t:0,w:0.0};}};
case 883: return function (act:Int) {switch (act) { case 258: return {t:1031,w:0.000000};default: return {t:0,w:0.0};}};
case 884: return function (act:Int) {switch (act) { case 256: return {t:1032,w:4000000.000000}; case 429: return {t:1033,w:0.000000};default: return {t:0,w:0.0};}};
case 885: return function (act:Int) {switch (act) { case 258: return {t:1031,w:0.000000};default: return {t:0,w:0.0};}};
case 886: return function (act:Int) {switch (act) { case 45: return {t:1034,w:1.386294}; case 256: return {t:49,w:4000000.750000}; case 258: return {t:1035,w:0.000000}; case 268: return {t:1036,w:0.693147};default: return {t:0,w:0.0};}};
case 887: return function (act:Int) {switch (act) { case 256: return {t:1037,w:4000001.750000}; case 258: return {t:1038,w:0.693147}; case 363: return {t:1039,w:1.791759}; case 364: return {t:1040,w:1.791759}; case 408: return {t:1041,w:1.791759};default: return {t:0,w:0.0};}};
case 888: return function (act:Int) {switch (act) { case 256: return {t:1037,w:4000001.750000}; case 258: return {t:1038,w:0.693147}; case 363: return {t:1039,w:1.791759}; case 364: return {t:1040,w:1.791759}; case 408: return {t:1041,w:1.791759};default: return {t:0,w:0.0};}};
case 889: return function (act:Int) {switch (act) { case 256: return {t:1037,w:4000001.750000}; case 258: return {t:1038,w:0.693147}; case 363: return {t:1039,w:1.791759}; case 364: return {t:1040,w:1.791759}; case 408: return {t:1041,w:1.791759};default: return {t:0,w:0.0};}};
case 890: return function (act:Int) {switch (act) { case 58: return {t:1042,w:0.693147}; case 64: return {t:1043,w:0.693147};default: return {t:0,w:0.0};}};
case 891: return function (act:Int) {switch (act) { case 46: return {t:1044,w:0.000000};default: return {t:0,w:0.0};}};
case 892: return function (act:Int) {switch (act) { case 45: return {t:1045,w:1.386294}; case 256: return {t:49,w:4000000.750000}; case 258: return {t:1046,w:0.000000}; case 268: return {t:1047,w:0.693147};default: return {t:0,w:0.0};}};
case 893: return function (act:Int) {switch (act) { case 46: return {t:1048,w:0.693147}; case 258: return {t:1049,w:0.693147};default: return {t:0,w:0.0};}};
case 894: return function (act:Int) {switch (act) { case 258: return {t:1050,w:0.000000};default: return {t:0,w:0.0};}};
case 895: return function (act:Int) {switch (act) { case 46: return {t:1051,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:1052,w:0.693147};default: return {t:0,w:0.0};}};
case 896: return function (act:Int) {switch (act) { case 258: return {t:1050,w:0.000000};default: return {t:0,w:0.0};}};
case 897: return function (act:Int) {switch (act) { case 258: return {t:1050,w:0.000000};default: return {t:0,w:0.0};}};
case 898: return function (act:Int) {switch (act) { case 58: return {t:1053,w:0.693147}; case 258: return {t:1054,w:0.693147};default: return {t:0,w:0.0};}};
case 899: return function (act:Int) {switch (act) { case 48: return {t:1021,w:3.401197}; case 49: return {t:1021,w:3.401197}; case 50: return {t:1021,w:3.401197}; case 51: return {t:1021,w:3.401197}; case 52: return {t:1021,w:3.401197}; case 53: return {t:1021,w:3.401197}; case 54: return {t:1021,w:3.401197}; case 55: return {t:1021,w:3.401197}; case 56: return {t:1021,w:3.401197}; case 57: return {t:1021,w:3.401197}; case 65: return {t:1022,w:6.436150}; case 66: return {t:1022,w:6.436150}; case 67: return {t:1022,w:6.436150}; case 68: return {t:1022,w:6.436150}; case 69: return {t:1022,w:6.436150}; case 70: return {t:1022,w:6.436150}; case 71: return {t:1022,w:6.436150}; case 72: return {t:1022,w:6.436150}; case 73: return {t:1022,w:6.436150}; case 74: return {t:1022,w:6.436150}; case 75: return {t:1022,w:6.436150}; case 76: return {t:1022,w:6.436150}; case 77: return {t:1022,w:6.436150}; case 78: return {t:1022,w:6.436150}; case 79: return {t:1022,w:6.436150}; case 80: return {t:1022,w:6.436150}; case 81: return {t:1022,w:6.436150}; case 82: return {t:1022,w:6.436150}; case 83: return {t:1022,w:6.436150}; case 84: return {t:1022,w:6.436150}; case 85: return {t:1022,w:6.436150}; case 86: return {t:1022,w:6.436150}; case 87: return {t:1022,w:6.436150}; case 88: return {t:1022,w:6.436150}; case 89: return {t:1022,w:6.436150}; case 90: return {t:1022,w:6.436150}; case 91: return {t:884,w:1.098612}; case 97: return {t:1023,w:6.436150}; case 98: return {t:1023,w:6.436150}; case 99: return {t:1023,w:6.436150}; case 100: return {t:1023,w:6.436150}; case 101: return {t:1023,w:6.436150}; case 102: return {t:1023,w:6.436150}; case 103: return {t:1023,w:6.436150}; case 104: return {t:1023,w:6.436150}; case 105: return {t:1023,w:6.436150}; case 106: return {t:1023,w:6.436150}; case 107: return {t:1023,w:6.436150}; case 108: return {t:1023,w:6.436150}; case 109: return {t:1023,w:6.436150}; case 110: return {t:1023,w:6.436150}; case 111: return {t:1023,w:6.436150}; case 112: return {t:1023,w:6.436150}; case 113: return {t:1023,w:6.436150}; case 114: return {t:1023,w:6.436150}; case 115: return {t:1023,w:6.436150}; case 116: return {t:1023,w:6.436150}; case 117: return {t:1023,w:6.436150}; case 118: return {t:1023,w:6.436150}; case 119: return {t:1023,w:6.436150}; case 120: return {t:1023,w:6.436150}; case 121: return {t:1023,w:6.436150}; case 122: return {t:1023,w:6.436150}; case 268: return {t:886,w:2.484906}; case 331: return {t:892,w:2.484906}; case 336: return {t:895,w:1.098612}; case 410: return {t:891,w:1.791759}; case 411: return {t:893,w:1.791759}; case 412: return {t:894,w:1.098612}; case 413: return {t:896,w:1.098612}; case 414: return {t:897,w:1.098612}; case 415: return {t:898,w:0.000000};default: return {t:0,w:0.0};}};
case 900: return function (act:Int) {switch (act) { case 59: return {t:1055,w:0.693147}; case 258: return {t:1056,w:0.693147};default: return {t:0,w:0.0};}};
case 901: return function (act:Int) {switch (act) { case 256: return {t:1057,w:4000000.750000}; case 258: return {t:1058,w:0.693147}; case 430: return {t:1059,w:0.693147};default: return {t:0,w:0.0};}};
case 902: return function (act:Int) {switch (act) { case 256: return {t:899,w:4000000.000000}; case 394: return {t:903,w:0.000000};default: return {t:0,w:0.0};}};
case 903: return function (act:Int) {switch (act) { case 256: return {t:900,w:4000000.000000}; case 416: return {t:1060,w:0.000000};default: return {t:0,w:0.0};}};
case 904: return function (act:Int) {switch (act) { case 33: return {t:420,w:5.075174}; case 36: return {t:1061,w:2.995732}; case 37: return {t:422,w:2.995732}; case 38: return {t:1062,w:2.995732}; case 39: return {t:424,w:6.461468}; case 40: return {t:424,w:6.461468}; case 41: return {t:424,w:6.461468}; case 42: return {t:424,w:6.461468}; case 43: return {t:1063,w:2.995732}; case 44: return {t:1064,w:2.995732}; case 45: return {t:426,w:5.768321}; case 46: return {t:426,w:5.768321}; case 47: return {t:878,w:5.123963}; case 48: return {t:1065,w:5.480639}; case 49: return {t:1065,w:5.480639}; case 50: return {t:1065,w:5.480639}; case 51: return {t:1065,w:5.480639}; case 52: return {t:1065,w:5.480639}; case 53: return {t:1065,w:5.480639}; case 54: return {t:1065,w:5.480639}; case 55: return {t:1065,w:5.480639}; case 56: return {t:1065,w:5.480639}; case 57: return {t:1065,w:5.480639}; case 58: return {t:1066,w:2.995732}; case 59: return {t:1067,w:2.995732}; case 61: return {t:1068,w:2.995732}; case 63: return {t:882,w:5.123963}; case 64: return {t:1069,w:2.995732}; case 65: return {t:1070,w:8.333270}; case 66: return {t:1070,w:8.333270}; case 67: return {t:1070,w:8.333270}; case 68: return {t:1070,w:8.333270}; case 69: return {t:1070,w:8.333270}; case 70: return {t:1070,w:8.333270}; case 71: return {t:1070,w:8.333270}; case 72: return {t:1070,w:8.333270}; case 73: return {t:1070,w:8.333270}; case 74: return {t:1070,w:8.333270}; case 75: return {t:1070,w:8.333270}; case 76: return {t:1070,w:8.333270}; case 77: return {t:1070,w:8.333270}; case 78: return {t:1070,w:8.333270}; case 79: return {t:1070,w:8.333270}; case 80: return {t:1070,w:8.333270}; case 81: return {t:1070,w:8.333270}; case 82: return {t:1070,w:8.333270}; case 83: return {t:1070,w:8.333270}; case 84: return {t:1070,w:8.333270}; case 85: return {t:1070,w:8.333270}; case 86: return {t:1070,w:8.333270}; case 87: return {t:1070,w:8.333270}; case 88: return {t:1070,w:8.333270}; case 89: return {t:1070,w:8.333270}; case 90: return {t:1070,w:8.333270}; case 91: return {t:884,w:3.178053}; case 95: return {t:433,w:5.075174}; case 97: return {t:1071,w:8.333270}; case 98: return {t:1071,w:8.333270}; case 99: return {t:1071,w:8.333270}; case 100: return {t:1071,w:8.333270}; case 101: return {t:1071,w:8.333270}; case 102: return {t:1071,w:8.333270}; case 103: return {t:1071,w:8.333270}; case 104: return {t:1071,w:8.333270}; case 105: return {t:1071,w:8.333270}; case 106: return {t:1071,w:8.333270}; case 107: return {t:1071,w:8.333270}; case 108: return {t:1071,w:8.333270}; case 109: return {t:1071,w:8.333270}; case 110: return {t:1071,w:8.333270}; case 111: return {t:1071,w:8.333270}; case 112: return {t:1071,w:8.333270}; case 113: return {t:1071,w:8.333270}; case 114: return {t:1071,w:8.333270}; case 115: return {t:1071,w:8.333270}; case 116: return {t:1071,w:8.333270}; case 117: return {t:1071,w:8.333270}; case 118: return {t:1071,w:8.333270}; case 119: return {t:1071,w:8.333270}; case 120: return {t:1071,w:8.333270}; case 121: return {t:1071,w:8.333270}; case 122: return {t:1071,w:8.333270}; case 126: return {t:435,w:5.075174}; case 258: return {t:1072,w:1.386294}; case 268: return {t:886,w:4.564347}; case 331: return {t:892,w:4.564347}; case 336: return {t:895,w:3.178053}; case 363: return {t:1073,w:2.995732}; case 364: return {t:1074,w:2.995732}; case 393: return {t:1075,w:2.079441}; case 394: return {t:1076,w:2.079441}; case 408: return {t:889,w:3.178053}; case 409: return {t:890,w:2.079441}; case 410: return {t:891,w:3.871200}; case 411: return {t:893,w:3.871200}; case 412: return {t:894,w:3.178053}; case 413: return {t:896,w:3.178053}; case 414: return {t:897,w:3.178053}; case 415: return {t:898,w:2.079441}; case 431: return {t:1077,w:0.693147}; case 432: return {t:1078,w:0.693147};default: return {t:0,w:0.0};}};
case 905: return function (act:Int) {switch (act) { case 256: return {t:1079,w:4000000.750000}; case 258: return {t:1080,w:0.693147}; case 387: return {t:1081,w:0.693147};default: return {t:0,w:0.0};}};
case 906: return function (act:Int) {switch (act) { case 258: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 907: return function (act:Int) {switch (act) { case 258: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 908: return function (act:Int) {switch (act) { case 258: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 909: return function (act:Int) {switch (act) { case 258: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 910: return function (act:Int) {switch (act) { case 258: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 911: return function (act:Int) {switch (act) { case 256: return {t:1083,w:4000000.000000}; case 433: return {t:1084,w:0.000000};default: return {t:0,w:0.0};}};
case 912: return function (act:Int) {switch (act) { case 258: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 913: return function (act:Int) {switch (act) { case 258: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 914: return function (act:Int) {switch (act) { case 419: return {t:914,w:0.000000};default: return {t:0,w:0.0};}};
case 915: return function (act:Int) {switch (act) { case 258: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 916: return function (act:Int) {switch (act) { case 258: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 917: return function (act:Int) {switch (act) { case 59: return {t:1085,w:1.386294}; case 256: return {t:1086,w:4000000.750000}; case 258: return {t:1087,w:1.386294}; case 418: return {t:1088,w:0.693147};default: return {t:0,w:0.0};}};
case 918: return function (act:Int) {switch (act) { case 47: return {t:1089,w:0.693147}; case 258: return {t:1090,w:0.693147};default: return {t:0,w:0.0};}};
case 919: return function (act:Int) {switch (act) { case 387: return {t:919,w:0.000000};default: return {t:0,w:0.0};}};
case 920: return function (act:Int) {switch (act) { case 33: return {t:420,w:3.871201}; case 36: return {t:421,w:3.737669}; case 37: return {t:422,w:1.791759}; case 38: return {t:423,w:3.737669}; case 39: return {t:424,w:5.257495}; case 40: return {t:424,w:5.257495}; case 41: return {t:424,w:5.257495}; case 42: return {t:424,w:5.257495}; case 43: return {t:425,w:4.430816}; case 44: return {t:425,w:4.430816}; case 45: return {t:426,w:4.564348}; case 46: return {t:426,w:4.564348}; case 47: return {t:427,w:3.737669}; case 48: return {t:428,w:6.173786}; case 49: return {t:428,w:6.173786}; case 50: return {t:428,w:6.173786}; case 51: return {t:428,w:6.173786}; case 52: return {t:428,w:6.173786}; case 53: return {t:428,w:6.173786}; case 54: return {t:428,w:6.173786}; case 55: return {t:428,w:6.173786}; case 56: return {t:428,w:6.173786}; case 57: return {t:428,w:6.173786}; case 58: return {t:429,w:4.430816}; case 59: return {t:429,w:4.430816}; case 61: return {t:430,w:3.737669}; case 63: return {t:431,w:4.430816}; case 64: return {t:431,w:4.430816}; case 65: return {t:432,w:7.129298}; case 66: return {t:432,w:7.129298}; case 67: return {t:432,w:7.129298}; case 68: return {t:432,w:7.129298}; case 69: return {t:432,w:7.129298}; case 70: return {t:432,w:7.129298}; case 71: return {t:432,w:7.129298}; case 72: return {t:432,w:7.129298}; case 73: return {t:432,w:7.129298}; case 74: return {t:432,w:7.129298}; case 75: return {t:432,w:7.129298}; case 76: return {t:432,w:7.129298}; case 77: return {t:432,w:7.129298}; case 78: return {t:432,w:7.129298}; case 79: return {t:432,w:7.129298}; case 80: return {t:432,w:7.129298}; case 81: return {t:432,w:7.129298}; case 82: return {t:432,w:7.129298}; case 83: return {t:432,w:7.129298}; case 84: return {t:432,w:7.129298}; case 85: return {t:432,w:7.129298}; case 86: return {t:432,w:7.129298}; case 87: return {t:432,w:7.129298}; case 88: return {t:432,w:7.129298}; case 89: return {t:432,w:7.129298}; case 90: return {t:432,w:7.129298}; case 95: return {t:433,w:3.871201}; case 97: return {t:434,w:7.129298}; case 98: return {t:434,w:7.129298}; case 99: return {t:434,w:7.129298}; case 100: return {t:434,w:7.129298}; case 101: return {t:434,w:7.129298}; case 102: return {t:434,w:7.129298}; case 103: return {t:434,w:7.129298}; case 104: return {t:434,w:7.129298}; case 105: return {t:434,w:7.129298}; case 106: return {t:434,w:7.129298}; case 107: return {t:434,w:7.129298}; case 108: return {t:434,w:7.129298}; case 109: return {t:434,w:7.129298}; case 110: return {t:434,w:7.129298}; case 111: return {t:434,w:7.129298}; case 112: return {t:434,w:7.129298}; case 113: return {t:434,w:7.129298}; case 114: return {t:434,w:7.129298}; case 115: return {t:434,w:7.129298}; case 116: return {t:434,w:7.129298}; case 117: return {t:434,w:7.129298}; case 118: return {t:434,w:7.129298}; case 119: return {t:434,w:7.129298}; case 120: return {t:434,w:7.129298}; case 121: return {t:434,w:7.129298}; case 122: return {t:434,w:7.129298}; case 126: return {t:435,w:3.871201}; case 258: return {t:1091,w:0.693147}; case 363: return {t:922,w:1.791759}; case 364: return {t:923,w:1.791759}; case 365: return {t:924,w:1.791759}; case 396: return {t:1092,w:0.693147};default: return {t:0,w:0.0};}};
case 921: return function (act:Int) {switch (act) { case 258: return {t:783,w:0.000000};default: return {t:0,w:0.0};}};
case 922: return function (act:Int) {switch (act) { case 258: return {t:1093,w:0.000000};default: return {t:0,w:0.0};}};
case 923: return function (act:Int) {switch (act) { case 258: return {t:1093,w:0.000000};default: return {t:0,w:0.0};}};
case 924: return function (act:Int) {switch (act) { case 258: return {t:1093,w:0.000000};default: return {t:0,w:0.0};}};
case 925: return function (act:Int) {switch (act) { case 390: return {t:925,w:0.000000};default: return {t:0,w:0.0};}};
case 926: return function (act:Int) {switch (act) { case 364: return {t:926,w:0.000000};default: return {t:0,w:0.0};}};
case 927: return function (act:Int) {switch (act) { case 258: return {t:791,w:0.000000};default: return {t:0,w:0.0};}};
case 928: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:1094,w:0.000000};default: return {t:0,w:0.0};}};
case 929: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:1095,w:0.000000};default: return {t:0,w:0.0};}};
case 930: return function (act:Int) {switch (act) { case 69: return {t:1096,w:0.693147}; case 76: return {t:1097,w:0.693147}; case 101: return {t:1096,w:0.693147}; case 108: return {t:1097,w:0.693147};default: return {t:0,w:0.0};}};
case 931: return function (act:Int) {switch (act) { case 256: return {t:1098,w:4000000.750000}; case 258: return {t:1099,w:0.693147}; case 434: return {t:1100,w:0.693147};default: return {t:0,w:0.0};}};
case 932: return function (act:Int) {switch (act) { case 78: return {t:1101,w:0.693147}; case 110: return {t:1101,w:0.693147};default: return {t:0,w:0.0};}};
case 933: return function (act:Int) {switch (act) { case 33: return {t:2,w:4.343805}; case 37: return {t:3,w:4.343805}; case 39: return {t:4,w:4.343805}; case 42: return {t:5,w:4.343805}; case 43: return {t:6,w:4.343805}; case 45: return {t:7,w:4.343805}; case 46: return {t:8,w:4.343805}; case 48: return {t:9,w:7.745002}; case 49: return {t:9,w:7.745002}; case 50: return {t:9,w:7.745002}; case 51: return {t:9,w:7.745002}; case 52: return {t:9,w:7.745002}; case 53: return {t:9,w:7.745002}; case 54: return {t:9,w:7.745002}; case 55: return {t:9,w:7.745002}; case 56: return {t:9,w:7.745002}; case 57: return {t:9,w:7.745002}; case 65: return {t:10,w:1.945910}; case 66: return {t:11,w:1.945910}; case 67: return {t:12,w:1.945910}; case 68: return {t:13,w:8.700514}; case 69: return {t:13,w:8.700514}; case 70: return {t:13,w:8.700514}; case 71: return {t:13,w:8.700514}; case 72: return {t:13,w:8.700514}; case 73: return {t:14,w:1.945910}; case 74: return {t:13,w:8.700514}; case 75: return {t:13,w:8.700514}; case 76: return {t:13,w:8.700514}; case 77: return {t:13,w:8.700514}; case 78: return {t:13,w:8.700514}; case 79: return {t:15,w:1.945910}; case 80: return {t:13,w:8.700514}; case 81: return {t:13,w:8.700514}; case 82: return {t:16,w:1.945910}; case 83: return {t:13,w:8.700514}; case 84: return {t:13,w:8.700514}; case 85: return {t:13,w:8.700514}; case 86: return {t:13,w:8.700514}; case 87: return {t:13,w:8.700514}; case 88: return {t:13,w:8.700514}; case 89: return {t:13,w:8.700514}; case 90: return {t:13,w:8.700514}; case 95: return {t:18,w:4.343805}; case 96: return {t:19,w:4.343805}; case 97: return {t:20,w:8.700514}; case 98: return {t:20,w:8.700514}; case 99: return {t:20,w:8.700514}; case 100: return {t:20,w:8.700514}; case 101: return {t:20,w:8.700514}; case 102: return {t:20,w:8.700514}; case 103: return {t:20,w:8.700514}; case 104: return {t:20,w:8.700514}; case 105: return {t:20,w:8.700514}; case 106: return {t:20,w:8.700514}; case 107: return {t:20,w:8.700514}; case 108: return {t:20,w:8.700514}; case 109: return {t:20,w:8.700514}; case 110: return {t:20,w:8.700514}; case 111: return {t:20,w:8.700514}; case 112: return {t:20,w:8.700514}; case 113: return {t:20,w:8.700514}; case 114: return {t:20,w:8.700514}; case 115: return {t:20,w:8.700514}; case 116: return {t:20,w:8.700514}; case 117: return {t:20,w:8.700514}; case 118: return {t:20,w:8.700514}; case 119: return {t:20,w:8.700514}; case 120: return {t:20,w:8.700514}; case 121: return {t:20,w:8.700514}; case 122: return {t:20,w:8.700514}; case 126: return {t:22,w:4.343805}; case 262: return {t:23,w:1.945910}; case 263: return {t:24,w:1.945910}; case 264: return {t:25,w:1.945910}; case 265: return {t:26,w:1.945910}; case 266: return {t:27,w:1.945910}; case 267: return {t:28,w:1.945910}; case 268: return {t:29,w:4.343805}; case 269: return {t:30,w:1.945910}; case 270: return {t:31,w:1.945910};default: return {t:0,w:0.0};}};
case 934: return function (act:Int) {switch (act) { case 288: return {t:934,w:0.000000};default: return {t:0,w:0.0};}};
case 935: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:934,w:0.693147}; case 375: return {t:1102,w:0.693147};default: return {t:0,w:0.0};}};
case 936: return function (act:Int) {switch (act) { case 73: return {t:1103,w:0.693147}; case 105: return {t:1103,w:0.693147};default: return {t:0,w:0.0};}};
case 937: return function (act:Int) {switch (act) { case 90: return {t:1104,w:0.693147}; case 122: return {t:1104,w:0.693147};default: return {t:0,w:0.0};}};
case 938: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:221,w:0.000000};default: return {t:0,w:0.0};}};
case 939: return function (act:Int) {switch (act) { case 70: return {t:1105,w:0.693147}; case 102: return {t:1105,w:0.693147};default: return {t:0,w:0.0};}};
case 940: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:226,w:0.000000};default: return {t:0,w:0.0};}};
case 941: return function (act:Int) {switch (act) { case 45: return {t:1106,w:0.000000};default: return {t:0,w:0.0};}};
case 942: return function (act:Int) {switch (act) { case 9: return {t:493,w:1.386294}; case 13: return {t:83,w:1.386294}; case 32: return {t:494,w:1.386294}; case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 279: return {t:504,w:1.386294}; case 283: return {t:119,w:1.386294}; case 376: return {t:505,w:0.693147};default: return {t:0,w:0.0};}};
case 943: return function (act:Int) {switch (act) { case 256: return {t:942,w:4000000.750000}; case 336: return {t:943,w:0.693147}; case 377: return {t:944,w:0.693147};default: return {t:0,w:0.0};}};
case 944: return function (act:Int) {switch (act) { case 256: return {t:933,w:4000000.000000}; case 271: return {t:1107,w:0.000000};default: return {t:0,w:0.0};}};
case 945: return function (act:Int) {switch (act) { case 73: return {t:1108,w:0.693147}; case 105: return {t:1108,w:0.693147};default: return {t:0,w:0.0};}};
case 946: return function (act:Int) {switch (act) { case 79: return {t:1109,w:0.693147}; case 111: return {t:1109,w:0.693147};default: return {t:0,w:0.0};}};
case 947: return function (act:Int) {switch (act) { case 69: return {t:1110,w:0.693147}; case 101: return {t:1110,w:0.693147};default: return {t:0,w:0.0};}};
case 948: return function (act:Int) {switch (act) { case 65: return {t:1111,w:0.693147}; case 97: return {t:1111,w:0.693147};default: return {t:0,w:0.0};}};
case 949: return function (act:Int) {switch (act) { case 73: return {t:1112,w:0.693147}; case 105: return {t:1112,w:0.693147};default: return {t:0,w:0.0};}};
case 950: return function (act:Int) {switch (act) { case 258: return {t:814,w:0.000000};default: return {t:0,w:0.0};}};
case 951: return function (act:Int) {switch (act) { case 79: return {t:1113,w:0.693147}; case 111: return {t:1113,w:0.693147};default: return {t:0,w:0.0};}};
case 952: return function (act:Int) {switch (act) { case 370: return {t:952,w:0.000000};default: return {t:0,w:0.0};}};
case 953: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:1114,w:0.000000};default: return {t:0,w:0.0};}};
case 954: return function (act:Int) {switch (act) { case 45: return {t:660,w:0.000000}; case 258: return {t:52,w:5.368310};default: return {t:0,w:0.0};}};
case 955: return function (act:Int) {switch (act) { case 45: return {t:660,w:0.000000}; case 258: return {t:52,w:5.368310};default: return {t:0,w:0.0};}};
case 956: return function (act:Int) {switch (act) { case 258: return {t:1115,w:0.000000};default: return {t:0,w:0.0};}};
case 957: return function (act:Int) {switch (act) { case 258: return {t:1116,w:0.000000};default: return {t:0,w:0.0};}};
case 958: return function (act:Int) {switch (act) { case 258: return {t:1116,w:0.000000};default: return {t:0,w:0.0};}};
case 959: return function (act:Int) {switch (act) { case 349: return {t:959,w:0.000000};default: return {t:0,w:0.0};}};
case 960: return function (act:Int) {switch (act) { case 256: return {t:1117,w:4000000.000000}; case 435: return {t:1118,w:0.000000};default: return {t:0,w:0.0};}};
case 961: return function (act:Int) {switch (act) { case 82: return {t:1119,w:0.693147}; case 114: return {t:1119,w:0.693147};default: return {t:0,w:0.0};}};
case 962: return function (act:Int) {switch (act) { case 79: return {t:1120,w:0.693147}; case 111: return {t:1120,w:0.693147};default: return {t:0,w:0.0};}};
case 963: return function (act:Int) {switch (act) { case 65: return {t:1121,w:0.693147}; case 85: return {t:1122,w:0.693147}; case 97: return {t:1121,w:0.693147}; case 117: return {t:1122,w:0.693147};default: return {t:0,w:0.0};}};
case 964: return function (act:Int) {switch (act) { case 72: return {t:1123,w:0.693147}; case 85: return {t:1124,w:0.693147}; case 104: return {t:1123,w:0.693147}; case 117: return {t:1124,w:0.693147};default: return {t:0,w:0.0};}};
case 965: return function (act:Int) {switch (act) { case 69: return {t:1125,w:0.693147}; case 101: return {t:1125,w:0.693147};default: return {t:0,w:0.0};}};
case 966: return function (act:Int) {switch (act) { case 44: return {t:1126,w:0.000000};default: return {t:0,w:0.0};}};
case 967: return function (act:Int) {switch (act) { case 258: return {t:1127,w:0.000000};default: return {t:0,w:0.0};}};
case 968: return function (act:Int) {switch (act) { case 300: return {t:968,w:0.000000};default: return {t:0,w:0.0};}};
case 969: return function (act:Int) {switch (act) { case 78: return {t:1128,w:0.693147}; case 110: return {t:1128,w:0.693147};default: return {t:0,w:0.0};}};
case 970: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1129,w:0.000000};default: return {t:0,w:0.0};}};
case 971: return function (act:Int) {switch (act) { case 258: return {t:1130,w:0.000000};default: return {t:0,w:0.0};}};
case 972: return function (act:Int) {switch (act) { case 256: return {t:812,w:4000000.750000}; case 258: return {t:689,w:0.693147}; case 269: return {t:824,w:0.693147};default: return {t:0,w:0.0};}};
case 973: return function (act:Int) {switch (act) { case 258: return {t:1131,w:0.000000};default: return {t:0,w:0.0};}};
case 974: return function (act:Int) {switch (act) { case 258: return {t:1131,w:0.000000};default: return {t:0,w:0.0};}};
case 975: return function (act:Int) {switch (act) { case 0: return {t:1132,w:3.401197}; case 1: return {t:1132,w:3.401197}; case 2: return {t:1132,w:3.401197}; case 3: return {t:1132,w:3.401197}; case 4: return {t:1132,w:3.401197}; case 5: return {t:1132,w:3.401197}; case 6: return {t:1132,w:3.401197}; case 7: return {t:1132,w:3.401197}; case 8: return {t:1132,w:3.401197}; case 9: return {t:1132,w:3.401197}; case 11: return {t:1133,w:1.791759}; case 12: return {t:1133,w:1.791759}; case 14: return {t:1134,w:5.834810}; case 15: return {t:1134,w:5.834810}; case 16: return {t:1134,w:5.834810}; case 17: return {t:1134,w:5.834810}; case 18: return {t:1134,w:5.834810}; case 19: return {t:1134,w:5.834810}; case 20: return {t:1134,w:5.834810}; case 21: return {t:1134,w:5.834810}; case 22: return {t:1134,w:5.834810}; case 23: return {t:1134,w:5.834810}; case 24: return {t:1134,w:5.834810}; case 25: return {t:1134,w:5.834810}; case 26: return {t:1134,w:5.834810}; case 27: return {t:1134,w:5.834810}; case 28: return {t:1134,w:5.834810}; case 29: return {t:1134,w:5.834810}; case 30: return {t:1134,w:5.834810}; case 31: return {t:1134,w:5.834810}; case 32: return {t:1134,w:5.834810}; case 33: return {t:1134,w:5.834810}; case 34: return {t:1134,w:5.834810}; case 35: return {t:1134,w:5.834810}; case 36: return {t:1134,w:5.834810}; case 37: return {t:1134,w:5.834810}; case 38: return {t:1134,w:5.834810}; case 39: return {t:1134,w:5.834810}; case 40: return {t:1134,w:5.834810}; case 41: return {t:1134,w:5.834810}; case 42: return {t:1134,w:5.834810}; case 43: return {t:1134,w:5.834810}; case 44: return {t:1134,w:5.834810}; case 45: return {t:1134,w:5.834810}; case 46: return {t:1134,w:5.834810}; case 47: return {t:1134,w:5.834810}; case 48: return {t:1134,w:5.834810}; case 49: return {t:1134,w:5.834810}; case 50: return {t:1134,w:5.834810}; case 51: return {t:1134,w:5.834810}; case 52: return {t:1134,w:5.834810}; case 53: return {t:1134,w:5.834810}; case 54: return {t:1134,w:5.834810}; case 55: return {t:1134,w:5.834810}; case 56: return {t:1134,w:5.834810}; case 57: return {t:1134,w:5.834810}; case 58: return {t:1134,w:5.834810}; case 59: return {t:1134,w:5.834810}; case 60: return {t:1134,w:5.834810}; case 61: return {t:1134,w:5.834810}; case 62: return {t:1134,w:5.834810}; case 63: return {t:1134,w:5.834810}; case 64: return {t:1134,w:5.834810}; case 65: return {t:1134,w:5.834810}; case 66: return {t:1134,w:5.834810}; case 67: return {t:1134,w:5.834810}; case 68: return {t:1134,w:5.834810}; case 69: return {t:1134,w:5.834810}; case 70: return {t:1134,w:5.834810}; case 71: return {t:1134,w:5.834810}; case 72: return {t:1134,w:5.834810}; case 73: return {t:1134,w:5.834810}; case 74: return {t:1134,w:5.834810}; case 75: return {t:1134,w:5.834810}; case 76: return {t:1134,w:5.834810}; case 77: return {t:1134,w:5.834810}; case 78: return {t:1134,w:5.834810}; case 79: return {t:1134,w:5.834810}; case 80: return {t:1134,w:5.834810}; case 81: return {t:1134,w:5.834810}; case 82: return {t:1134,w:5.834810}; case 83: return {t:1134,w:5.834810}; case 84: return {t:1134,w:5.834810}; case 85: return {t:1134,w:5.834810}; case 86: return {t:1134,w:5.834810}; case 87: return {t:1134,w:5.834810}; case 88: return {t:1134,w:5.834810}; case 89: return {t:1134,w:5.834810}; case 90: return {t:1134,w:5.834810}; case 91: return {t:1134,w:5.834810}; case 92: return {t:1134,w:5.834810}; case 93: return {t:1134,w:5.834810}; case 94: return {t:1134,w:5.834810}; case 95: return {t:1134,w:5.834810}; case 96: return {t:1134,w:5.834810}; case 97: return {t:1134,w:5.834810}; case 98: return {t:1134,w:5.834810}; case 99: return {t:1134,w:5.834810}; case 100: return {t:1134,w:5.834810}; case 101: return {t:1134,w:5.834810}; case 102: return {t:1134,w:5.834810}; case 103: return {t:1134,w:5.834810}; case 104: return {t:1134,w:5.834810}; case 105: return {t:1134,w:5.834810}; case 106: return {t:1134,w:5.834810}; case 107: return {t:1134,w:5.834810}; case 108: return {t:1134,w:5.834810}; case 109: return {t:1134,w:5.834810}; case 110: return {t:1134,w:5.834810}; case 111: return {t:1134,w:5.834810}; case 112: return {t:1134,w:5.834810}; case 113: return {t:1134,w:5.834810}; case 114: return {t:1134,w:5.834810}; case 115: return {t:1134,w:5.834810}; case 116: return {t:1134,w:5.834810}; case 117: return {t:1134,w:5.834810}; case 118: return {t:1134,w:5.834810}; case 119: return {t:1134,w:5.834810}; case 120: return {t:1134,w:5.834810}; case 121: return {t:1134,w:5.834810}; case 122: return {t:1134,w:5.834810}; case 123: return {t:1134,w:5.834810}; case 124: return {t:1134,w:5.834810}; case 125: return {t:1134,w:5.834810}; case 126: return {t:1134,w:5.834810}; case 127: return {t:1134,w:5.834810};default: return {t:0,w:0.0};}};
case 976: return function (act:Int) {switch (act) { case 258: return {t:1131,w:0.000000};default: return {t:0,w:0.0};}};
case 977: return function (act:Int) {switch (act) { case 258: return {t:1131,w:0.000000};default: return {t:0,w:0.0};}};
case 978: return function (act:Int) {switch (act) { case 258: return {t:1131,w:0.000000};default: return {t:0,w:0.0};}};
case 979: return function (act:Int) {switch (act) { case 378: return {t:979,w:0.000000};default: return {t:0,w:0.0};}};
case 980: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:1135,w:0.000000};default: return {t:0,w:0.0};}};
case 981: return function (act:Int) {switch (act) { case 358: return {t:981,w:0.000000};default: return {t:0,w:0.0};}};
case 982: return function (act:Int) {switch (act) { case 258: return {t:1136,w:0.000000};default: return {t:0,w:0.0};}};
case 983: return function (act:Int) {switch (act) { case 258: return {t:1136,w:0.000000};default: return {t:0,w:0.0};}};
case 984: return function (act:Int) {switch (act) { case 89: return {t:1137,w:0.693147}; case 121: return {t:1137,w:0.693147};default: return {t:0,w:0.0};}};
case 985: return function (act:Int) {switch (act) { case 87: return {t:1138,w:0.693147}; case 119: return {t:1138,w:0.693147};default: return {t:0,w:0.0};}};
case 986: return function (act:Int) {switch (act) { case 82: return {t:1139,w:0.693147}; case 114: return {t:1139,w:0.693147};default: return {t:0,w:0.0};}};
case 987: return function (act:Int) {switch (act) { case 73: return {t:1140,w:0.693147}; case 105: return {t:1140,w:0.693147};default: return {t:0,w:0.0};}};
case 988: return function (act:Int) {switch (act) { case 354: return {t:988,w:0.000000};default: return {t:0,w:0.0};}};
case 989: return function (act:Int) {switch (act) { case 88: return {t:1141,w:0.693147}; case 120: return {t:1141,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 990: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 258: return {t:52,w:6.061457}; case 428: return {t:1142,w:0.000000};default: return {t:0,w:0.0};}};
case 991: return function (act:Int) {switch (act) { case 88: return {t:1141,w:0.693147}; case 120: return {t:1141,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 992: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 258: return {t:52,w:6.061457}; case 428: return {t:1142,w:0.000000};default: return {t:0,w:0.0};}};
case 993: return function (act:Int) {switch (act) { case 258: return {t:1143,w:0.000000};default: return {t:0,w:0.0};}};
case 994: return function (act:Int) {switch (act) { case 258: return {t:1144,w:0.000000};default: return {t:0,w:0.0};}};
case 995: return function (act:Int) {switch (act) { case 258: return {t:1144,w:0.000000};default: return {t:0,w:0.0};}};
case 996: return function (act:Int) {switch (act) { case 258: return {t:1144,w:0.000000};default: return {t:0,w:0.0};}};
case 997: return function (act:Int) {switch (act) { case 65: return {t:1145,w:0.693147}; case 97: return {t:1145,w:0.693147};default: return {t:0,w:0.0};}};
case 998: return function (act:Int) {switch (act) { case 89: return {t:1146,w:0.693147}; case 121: return {t:1146,w:0.693147};default: return {t:0,w:0.0};}};
case 999: return function (act:Int) {switch (act) { case 85: return {t:1147,w:0.693147}; case 117: return {t:1147,w:0.693147};default: return {t:0,w:0.0};}};
case 1000: return function (act:Int) {switch (act) { case 69: return {t:1148,w:0.693147}; case 101: return {t:1148,w:0.693147};default: return {t:0,w:0.0};}};
case 1001: return function (act:Int) {switch (act) { case 82: return {t:1149,w:0.693147}; case 114: return {t:1149,w:0.693147};default: return {t:0,w:0.0};}};
case 1002: return function (act:Int) {switch (act) { case 79: return {t:1150,w:0.693147}; case 111: return {t:1150,w:0.693147};default: return {t:0,w:0.0};}};
case 1003: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1151,w:0.000000};default: return {t:0,w:0.0};}};
case 1004: return function (act:Int) {switch (act) { case 70: return {t:1152,w:0.693147}; case 102: return {t:1152,w:0.693147};default: return {t:0,w:0.0};}};
case 1005: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.772588}; case 13: return {t:83,w:2.772588}; case 32: return {t:494,w:2.772588}; case 33: return {t:2,w:4.477336}; case 37: return {t:3,w:4.477336}; case 39: return {t:4,w:4.477336}; case 42: return {t:5,w:4.477336}; case 43: return {t:6,w:4.477336}; case 45: return {t:7,w:4.477336}; case 46: return {t:8,w:4.477336}; case 48: return {t:9,w:7.878534}; case 49: return {t:9,w:7.878534}; case 50: return {t:9,w:7.878534}; case 51: return {t:9,w:7.878534}; case 52: return {t:9,w:7.878534}; case 53: return {t:9,w:7.878534}; case 54: return {t:9,w:7.878534}; case 55: return {t:9,w:7.878534}; case 56: return {t:9,w:7.878534}; case 57: return {t:9,w:7.878534}; case 65: return {t:13,w:8.834045}; case 66: return {t:13,w:8.834045}; case 67: return {t:13,w:8.834045}; case 68: return {t:13,w:8.834045}; case 69: return {t:13,w:8.834045}; case 70: return {t:13,w:8.834045}; case 71: return {t:13,w:8.834045}; case 72: return {t:13,w:8.834045}; case 73: return {t:13,w:8.834045}; case 74: return {t:13,w:8.834045}; case 75: return {t:13,w:8.834045}; case 76: return {t:13,w:8.834045}; case 77: return {t:13,w:8.834045}; case 78: return {t:13,w:8.834045}; case 79: return {t:13,w:8.834045}; case 80: return {t:13,w:8.834045}; case 81: return {t:13,w:8.834045}; case 82: return {t:13,w:8.834045}; case 83: return {t:13,w:8.834045}; case 84: return {t:13,w:8.834045}; case 85: return {t:13,w:8.834045}; case 86: return {t:13,w:8.834045}; case 87: return {t:13,w:8.834045}; case 88: return {t:13,w:8.834045}; case 89: return {t:13,w:8.834045}; case 90: return {t:13,w:8.834045}; case 95: return {t:18,w:4.477336}; case 96: return {t:19,w:4.477336}; case 97: return {t:20,w:8.834045}; case 98: return {t:20,w:8.834045}; case 99: return {t:20,w:8.834045}; case 100: return {t:20,w:8.834045}; case 101: return {t:20,w:8.834045}; case 102: return {t:20,w:8.834045}; case 103: return {t:20,w:8.834045}; case 104: return {t:20,w:8.834045}; case 105: return {t:20,w:8.834045}; case 106: return {t:20,w:8.834045}; case 107: return {t:20,w:8.834045}; case 108: return {t:20,w:8.834045}; case 109: return {t:20,w:8.834045}; case 110: return {t:20,w:8.834045}; case 111: return {t:20,w:8.834045}; case 112: return {t:20,w:8.834045}; case 113: return {t:20,w:8.834045}; case 114: return {t:20,w:8.834045}; case 115: return {t:20,w:8.834045}; case 116: return {t:20,w:8.834045}; case 117: return {t:20,w:8.834045}; case 118: return {t:20,w:8.834045}; case 119: return {t:20,w:8.834045}; case 120: return {t:20,w:8.834045}; case 121: return {t:20,w:8.834045}; case 122: return {t:20,w:8.834045}; case 126: return {t:22,w:4.477336}; case 258: return {t:499,w:1.386294}; case 268: return {t:29,w:4.477336}; case 269: return {t:500,w:2.079441}; case 279: return {t:504,w:2.772588}; case 283: return {t:119,w:2.772588}; case 358: return {t:1153,w:0.000000}; case 368: return {t:507,w:0.693147}; case 376: return {t:505,w:2.079441}; case 377: return {t:506,w:1.386294}; case 378: return {t:508,w:1.386294}; case 379: return {t:509,w:0.693147}; case 380: return {t:510,w:0.693147};default: return {t:0,w:0.0};}};
case 1006: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1154,w:0.693147}; case 375: return {t:1155,w:0.693147};default: return {t:0,w:0.0};}};
case 1007: return function (act:Int) {switch (act) { case 256: return {t:1156,w:4000000.000000}; case 436: return {t:1157,w:0.000000};default: return {t:0,w:0.0};}};
case 1008: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:233,w:0.000000};default: return {t:0,w:0.0};}};
case 1009: return function (act:Int) {switch (act) { case 69: return {t:1158,w:0.693147}; case 101: return {t:1158,w:0.693147};default: return {t:0,w:0.0};}};
case 1010: return function (act:Int) {switch (act) { case 77: return {t:1159,w:0.693147}; case 109: return {t:1159,w:0.693147};default: return {t:0,w:0.0};}};
case 1011: return function (act:Int) {switch (act) { case 258: return {t:1160,w:0.000000};default: return {t:0,w:0.0};}};
case 1012: return function (act:Int) {switch (act) { case 71: return {t:1161,w:0.693147}; case 103: return {t:1161,w:0.693147};default: return {t:0,w:0.0};}};
case 1013: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1162,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 1014: return function (act:Int) {switch (act) { case 404: return {t:1014,w:0.000000};default: return {t:0,w:0.0};}};
case 1015: return function (act:Int) {switch (act) { case 256: return {t:1163,w:4000000.000000}; case 437: return {t:1164,w:0.000000};default: return {t:0,w:0.0};}};
case 1016: return function (act:Int) {switch (act) { case 392: return {t:1016,w:0.000000};default: return {t:0,w:0.0};}};
case 1017: return function (act:Int) {switch (act) { case 82: return {t:1165,w:0.693147}; case 114: return {t:1165,w:0.693147};default: return {t:0,w:0.0};}};
case 1018: return function (act:Int) {switch (act) { case 69: return {t:1166,w:0.693147}; case 101: return {t:1166,w:0.693147};default: return {t:0,w:0.0};}};
case 1019: return function (act:Int) {switch (act) { case 258: return {t:1167,w:0.000000};default: return {t:0,w:0.0};}};
case 1020: return function (act:Int) {switch (act) { case 256: return {t:1168,w:4000000.000000}; case 438: return {t:1169,w:0.000000};default: return {t:0,w:0.0};}};
case 1021: return function (act:Int) {switch (act) { case 258: return {t:1170,w:0.000000};default: return {t:0,w:0.0};}};
case 1022: return function (act:Int) {switch (act) { case 258: return {t:1171,w:0.000000};default: return {t:0,w:0.0};}};
case 1023: return function (act:Int) {switch (act) { case 258: return {t:1171,w:0.000000};default: return {t:0,w:0.0};}};
case 1024: return function (act:Int) {switch (act) { case 256: return {t:1172,w:4000000.750000}; case 258: return {t:1173,w:0.693147}; case 439: return {t:1174,w:0.693147};default: return {t:0,w:0.0};}};
case 1025: return function (act:Int) {switch (act) { case 359: return {t:1025,w:0.000000};default: return {t:0,w:0.0};}};
case 1026: return function (act:Int) {switch (act) { case 256: return {t:1175,w:4000000.000000}; case 440: return {t:1176,w:0.000000};default: return {t:0,w:0.0};}};
case 1027: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1177,w:0.000000};default: return {t:0,w:0.0};}};
case 1028: return function (act:Int) {switch (act) { case 72: return {t:1178,w:0.693147}; case 104: return {t:1178,w:0.693147};default: return {t:0,w:0.0};}};
case 1029: return function (act:Int) {switch (act) { case 408: return {t:1029,w:0.000000};default: return {t:0,w:0.0};}};
case 1030: return function (act:Int) {switch (act) { case 268: return {t:52,w:2.484906}; case 336: return {t:271,w:0.000000}; case 363: return {t:621,w:2.079442};default: return {t:0,w:0.0};}};
case 1031: return function (act:Int) {switch (act) { case 268: return {t:52,w:0.405465}; case 331: return {t:258,w:0.000000}; case 363: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 1032: return function (act:Int) {switch (act) { case 48: return {t:787,w:4.499809}; case 49: return {t:787,w:4.499809}; case 50: return {t:787,w:4.499809}; case 51: return {t:787,w:4.499809}; case 52: return {t:787,w:4.499809}; case 53: return {t:787,w:4.499809}; case 54: return {t:787,w:4.499809}; case 55: return {t:787,w:4.499809}; case 56: return {t:787,w:4.499809}; case 57: return {t:787,w:4.499809}; case 58: return {t:1179,w:1.098612}; case 65: return {t:788,w:3.988983}; case 66: return {t:788,w:3.988983}; case 67: return {t:788,w:3.988983}; case 68: return {t:788,w:3.988983}; case 69: return {t:788,w:3.988983}; case 70: return {t:788,w:3.988983}; case 97: return {t:789,w:3.988983}; case 98: return {t:789,w:3.988983}; case 99: return {t:789,w:3.988983}; case 100: return {t:789,w:3.988983}; case 101: return {t:789,w:3.988983}; case 102: return {t:789,w:3.988983}; case 390: return {t:1180,w:1.098612}; case 441: return {t:1181,w:1.098612}; case 442: return {t:1182,w:1.098612}; case 443: return {t:1183,w:0.000000};default: return {t:0,w:0.0};}};
case 1033: return function (act:Int) {switch (act) { case 93: return {t:1184,w:0.000000};default: return {t:0,w:0.0};}};
case 1034: return function (act:Int) {switch (act) { case 256: return {t:1185,w:4000000.000000}; case 444: return {t:1186,w:0.000000};default: return {t:0,w:0.0};}};
case 1035: return function (act:Int) {switch (act) { case 410: return {t:1035,w:0.000000};default: return {t:0,w:0.0};}};
case 1036: return function (act:Int) {switch (act) { case 256: return {t:1185,w:4000000.750000}; case 258: return {t:1035,w:0.000000}; case 444: return {t:1186,w:0.693147};default: return {t:0,w:0.0};}};
case 1037: return function (act:Int) {switch (act) { case 33: return {t:420,w:2.079442}; case 36: return {t:875,w:1.945910}; case 37: return {t:422,w:0.000000}; case 38: return {t:876,w:1.945910}; case 39: return {t:424,w:3.465736}; case 40: return {t:424,w:3.465736}; case 41: return {t:424,w:3.465736}; case 42: return {t:424,w:3.465736}; case 43: return {t:877,w:2.639057}; case 44: return {t:877,w:2.639057}; case 45: return {t:426,w:2.772589}; case 46: return {t:426,w:2.772589}; case 47: return {t:878,w:1.945910}; case 48: return {t:428,w:4.382027}; case 49: return {t:428,w:4.382027}; case 50: return {t:428,w:4.382027}; case 51: return {t:428,w:4.382027}; case 52: return {t:428,w:4.382027}; case 53: return {t:428,w:4.382027}; case 54: return {t:428,w:4.382027}; case 55: return {t:428,w:4.382027}; case 56: return {t:428,w:4.382027}; case 57: return {t:428,w:4.382027}; case 59: return {t:880,w:1.945910}; case 61: return {t:881,w:1.945910}; case 63: return {t:882,w:1.945910}; case 65: return {t:432,w:5.337539}; case 66: return {t:432,w:5.337539}; case 67: return {t:432,w:5.337539}; case 68: return {t:432,w:5.337539}; case 69: return {t:432,w:5.337539}; case 70: return {t:432,w:5.337539}; case 71: return {t:432,w:5.337539}; case 72: return {t:432,w:5.337539}; case 73: return {t:432,w:5.337539}; case 74: return {t:432,w:5.337539}; case 75: return {t:432,w:5.337539}; case 76: return {t:432,w:5.337539}; case 77: return {t:432,w:5.337539}; case 78: return {t:432,w:5.337539}; case 79: return {t:432,w:5.337539}; case 80: return {t:432,w:5.337539}; case 81: return {t:432,w:5.337539}; case 82: return {t:432,w:5.337539}; case 83: return {t:432,w:5.337539}; case 84: return {t:432,w:5.337539}; case 85: return {t:432,w:5.337539}; case 86: return {t:432,w:5.337539}; case 87: return {t:432,w:5.337539}; case 88: return {t:432,w:5.337539}; case 89: return {t:432,w:5.337539}; case 90: return {t:432,w:5.337539}; case 95: return {t:433,w:2.079442}; case 97: return {t:434,w:5.337539}; case 98: return {t:434,w:5.337539}; case 99: return {t:434,w:5.337539}; case 100: return {t:434,w:5.337539}; case 101: return {t:434,w:5.337539}; case 102: return {t:434,w:5.337539}; case 103: return {t:434,w:5.337539}; case 104: return {t:434,w:5.337539}; case 105: return {t:434,w:5.337539}; case 106: return {t:434,w:5.337539}; case 107: return {t:434,w:5.337539}; case 108: return {t:434,w:5.337539}; case 109: return {t:434,w:5.337539}; case 110: return {t:434,w:5.337539}; case 111: return {t:434,w:5.337539}; case 112: return {t:434,w:5.337539}; case 113: return {t:434,w:5.337539}; case 114: return {t:434,w:5.337539}; case 115: return {t:434,w:5.337539}; case 116: return {t:434,w:5.337539}; case 117: return {t:434,w:5.337539}; case 118: return {t:434,w:5.337539}; case 119: return {t:434,w:5.337539}; case 120: return {t:434,w:5.337539}; case 121: return {t:434,w:5.337539}; case 122: return {t:434,w:5.337539}; case 126: return {t:435,w:2.079442};default: return {t:0,w:0.0};}};
case 1038: return function (act:Int) {switch (act) { case 409: return {t:1038,w:0.000000};default: return {t:0,w:0.0};}};
case 1039: return function (act:Int) {switch (act) { case 256: return {t:1037,w:4000001.750000}; case 258: return {t:1038,w:0.693147}; case 363: return {t:1039,w:1.791759}; case 364: return {t:1040,w:1.791759}; case 408: return {t:1041,w:1.791759};default: return {t:0,w:0.0};}};
case 1040: return function (act:Int) {switch (act) { case 256: return {t:1037,w:4000001.750000}; case 258: return {t:1038,w:0.693147}; case 363: return {t:1039,w:1.791759}; case 364: return {t:1040,w:1.791759}; case 408: return {t:1041,w:1.791759};default: return {t:0,w:0.0};}};
case 1041: return function (act:Int) {switch (act) { case 256: return {t:1037,w:4000001.750000}; case 258: return {t:1038,w:0.693147}; case 363: return {t:1039,w:1.791759}; case 364: return {t:1040,w:1.791759}; case 408: return {t:1041,w:1.791759};default: return {t:0,w:0.0};}};
case 1042: return function (act:Int) {switch (act) { case 256: return {t:1187,w:4000000.000000}; case 445: return {t:1188,w:0.000000};default: return {t:0,w:0.0};}};
case 1043: return function (act:Int) {switch (act) { case 258: return {t:1189,w:0.000000};default: return {t:0,w:0.0};}};
case 1044: return function (act:Int) {switch (act) { case 256: return {t:1190,w:4000000.750000}; case 410: return {t:1191,w:0.693147}; case 411: return {t:1192,w:0.693147};default: return {t:0,w:0.0};}};
case 1045: return function (act:Int) {switch (act) { case 45: return {t:1045,w:1.386294}; case 256: return {t:49,w:4000000.750000}; case 268: return {t:1047,w:0.693147};default: return {t:0,w:0.0};}};
case 1046: return function (act:Int) {switch (act) { case 411: return {t:1046,w:0.000000};default: return {t:0,w:0.0};}};
case 1047: return function (act:Int) {switch (act) { case 45: return {t:1045,w:2.079441}; case 256: return {t:49,w:4000001.500000}; case 258: return {t:1046,w:0.000000}; case 268: return {t:1047,w:1.386294};default: return {t:0,w:0.0};}};
case 1048: return function (act:Int) {switch (act) { case 258: return {t:1049,w:0.000000};default: return {t:0,w:0.0};}};
case 1049: return function (act:Int) {switch (act) { case 412: return {t:1049,w:0.000000};default: return {t:0,w:0.0};}};
case 1050: return function (act:Int) {switch (act) { case 415: return {t:1050,w:0.000000};default: return {t:0,w:0.0};}};
case 1051: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1193,w:0.000000};default: return {t:0,w:0.0};}};
case 1052: return function (act:Int) {switch (act) { case 46: return {t:1051,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:1194,w:0.693147};default: return {t:0,w:0.0};}};
case 1053: return function (act:Int) {switch (act) { case 256: return {t:1195,w:4000000.000000}; case 446: return {t:1196,w:0.000000};default: return {t:0,w:0.0};}};
case 1054: return function (act:Int) {switch (act) { case 394: return {t:1054,w:0.000000};default: return {t:0,w:0.0};}};
case 1055: return function (act:Int) {switch (act) { case 256: return {t:1197,w:4000000.000000}; case 447: return {t:1198,w:0.000000};default: return {t:0,w:0.0};}};
case 1056: return function (act:Int) {switch (act) { case 416: return {t:1056,w:0.000000};default: return {t:0,w:0.0};}};
case 1057: return function (act:Int) {switch (act) { case 63: return {t:1199,w:0.000000};default: return {t:0,w:0.0};}};
case 1058: return function (act:Int) {switch (act) { case 332: return {t:1058,w:0.000000};default: return {t:0,w:0.0};}};
case 1059: return function (act:Int) {switch (act) { case 258: return {t:1058,w:0.000000};default: return {t:0,w:0.0};}};
case 1060: return function (act:Int) {switch (act) { case 256: return {t:1057,w:4000000.750000}; case 258: return {t:1200,w:0.693147}; case 430: return {t:1201,w:0.693147};default: return {t:0,w:0.0};}};
case 1061: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 258: return {t:1029,w:2.128231}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1062: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 258: return {t:1029,w:2.128231}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1063: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 258: return {t:1029,w:2.821379}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1064: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 258: return {t:1029,w:2.821379}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1065: return function (act:Int) {switch (act) { case 258: return {t:1204,w:0.000000};default: return {t:0,w:0.0};}};
case 1066: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1067: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 258: return {t:1029,w:2.128231}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1068: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 258: return {t:1029,w:2.128231}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1069: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1070: return function (act:Int) {switch (act) { case 258: return {t:1205,w:0.000000};default: return {t:0,w:0.0};}};
case 1071: return function (act:Int) {switch (act) { case 258: return {t:1205,w:0.000000};default: return {t:0,w:0.0};}};
case 1072: return function (act:Int) {switch (act) { case 431: return {t:1072,w:0.000000};default: return {t:0,w:0.0};}};
case 1073: return function (act:Int) {switch (act) { case 256: return {t:1206,w:4000000.000000}; case 258: return {t:1038,w:0.875468}; case 363: return {t:1039,w:1.974080}; case 364: return {t:1040,w:1.974080}; case 408: return {t:1041,w:1.974080}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1074: return function (act:Int) {switch (act) { case 256: return {t:1206,w:4000000.000000}; case 258: return {t:1038,w:0.875468}; case 363: return {t:1039,w:1.974080}; case 364: return {t:1040,w:1.974080}; case 408: return {t:1041,w:1.974080}; case 448: return {t:1203,w:0.000000};default: return {t:0,w:0.0};}};
case 1075: return function (act:Int) {switch (act) { case 64: return {t:1207,w:0.000000};default: return {t:0,w:0.0};}};
case 1076: return function (act:Int) {switch (act) { case 258: return {t:1208,w:0.000000};default: return {t:0,w:0.0};}};
case 1077: return function (act:Int) {switch (act) { case 258: return {t:1209,w:0.000000};default: return {t:0,w:0.0};}};
case 1078: return function (act:Int) {switch (act) { case 258: return {t:1209,w:0.000000};default: return {t:0,w:0.0};}};
case 1079: return function (act:Int) {switch (act) { case 47: return {t:1210,w:0.000000};default: return {t:0,w:0.0};}};
case 1080: return function (act:Int) {switch (act) { case 388: return {t:1080,w:0.000000};default: return {t:0,w:0.0};}};
case 1081: return function (act:Int) {switch (act) { case 258: return {t:1080,w:0.000000};default: return {t:0,w:0.0};}};
case 1082: return function (act:Int) {switch (act) { case 418: return {t:1082,w:0.000000};default: return {t:0,w:0.0};}};
case 1083: return function (act:Int) {switch (act) { case 33: return {t:420,w:4.969814}; case 36: return {t:906,w:2.890372}; case 37: return {t:422,w:2.890372}; case 38: return {t:907,w:2.890372}; case 39: return {t:424,w:6.356108}; case 40: return {t:424,w:6.356108}; case 41: return {t:424,w:6.356108}; case 42: return {t:424,w:6.356108}; case 43: return {t:908,w:2.890372}; case 44: return {t:909,w:2.890372}; case 45: return {t:426,w:5.662961}; case 46: return {t:426,w:5.662961}; case 48: return {t:428,w:7.272399}; case 49: return {t:428,w:7.272399}; case 50: return {t:428,w:7.272399}; case 51: return {t:428,w:7.272399}; case 52: return {t:428,w:7.272399}; case 53: return {t:428,w:7.272399}; case 54: return {t:428,w:7.272399}; case 55: return {t:428,w:7.272399}; case 56: return {t:428,w:7.272399}; case 57: return {t:428,w:7.272399}; case 58: return {t:910,w:2.890372}; case 61: return {t:912,w:2.890372}; case 64: return {t:913,w:2.890372}; case 65: return {t:432,w:8.227911}; case 66: return {t:432,w:8.227911}; case 67: return {t:432,w:8.227911}; case 68: return {t:432,w:8.227911}; case 69: return {t:432,w:8.227911}; case 70: return {t:432,w:8.227911}; case 71: return {t:432,w:8.227911}; case 72: return {t:432,w:8.227911}; case 73: return {t:432,w:8.227911}; case 74: return {t:432,w:8.227911}; case 75: return {t:432,w:8.227911}; case 76: return {t:432,w:8.227911}; case 77: return {t:432,w:8.227911}; case 78: return {t:432,w:8.227911}; case 79: return {t:432,w:8.227911}; case 80: return {t:432,w:8.227911}; case 81: return {t:432,w:8.227911}; case 82: return {t:432,w:8.227911}; case 83: return {t:432,w:8.227911}; case 84: return {t:432,w:8.227911}; case 85: return {t:432,w:8.227911}; case 86: return {t:432,w:8.227911}; case 87: return {t:432,w:8.227911}; case 88: return {t:432,w:8.227911}; case 89: return {t:432,w:8.227911}; case 90: return {t:432,w:8.227911}; case 95: return {t:433,w:4.969814}; case 97: return {t:434,w:8.227911}; case 98: return {t:434,w:8.227911}; case 99: return {t:434,w:8.227911}; case 100: return {t:434,w:8.227911}; case 101: return {t:434,w:8.227911}; case 102: return {t:434,w:8.227911}; case 103: return {t:434,w:8.227911}; case 104: return {t:434,w:8.227911}; case 105: return {t:434,w:8.227911}; case 106: return {t:434,w:8.227911}; case 107: return {t:434,w:8.227911}; case 108: return {t:434,w:8.227911}; case 109: return {t:434,w:8.227911}; case 110: return {t:434,w:8.227911}; case 111: return {t:434,w:8.227911}; case 112: return {t:434,w:8.227911}; case 113: return {t:434,w:8.227911}; case 114: return {t:434,w:8.227911}; case 115: return {t:434,w:8.227911}; case 116: return {t:434,w:8.227911}; case 117: return {t:434,w:8.227911}; case 118: return {t:434,w:8.227911}; case 119: return {t:434,w:8.227911}; case 120: return {t:434,w:8.227911}; case 121: return {t:434,w:8.227911}; case 122: return {t:434,w:8.227911}; case 126: return {t:435,w:4.969814}; case 258: return {t:1211,w:0.693147}; case 363: return {t:915,w:2.890372}; case 364: return {t:916,w:2.890372}; case 418: return {t:1212,w:0.693147};default: return {t:0,w:0.0};}};
case 1084: return function (act:Int) {switch (act) { case 59: return {t:1213,w:0.693147}; case 258: return {t:1087,w:0.693147};default: return {t:0,w:0.0};}};
case 1085: return function (act:Int) {switch (act) { case 256: return {t:1083,w:4000000.000000}; case 433: return {t:1214,w:0.000000};default: return {t:0,w:0.0};}};
case 1086: return function (act:Int) {switch (act) { case 33: return {t:420,w:4.276667}; case 36: return {t:906,w:2.197225}; case 37: return {t:422,w:2.197225}; case 38: return {t:907,w:2.197225}; case 39: return {t:424,w:5.662961}; case 40: return {t:424,w:5.662961}; case 41: return {t:424,w:5.662961}; case 42: return {t:424,w:5.662961}; case 43: return {t:908,w:2.197225}; case 44: return {t:909,w:2.197225}; case 45: return {t:426,w:4.969814}; case 46: return {t:426,w:4.969814}; case 48: return {t:428,w:6.579252}; case 49: return {t:428,w:6.579252}; case 50: return {t:428,w:6.579252}; case 51: return {t:428,w:6.579252}; case 52: return {t:428,w:6.579252}; case 53: return {t:428,w:6.579252}; case 54: return {t:428,w:6.579252}; case 55: return {t:428,w:6.579252}; case 56: return {t:428,w:6.579252}; case 57: return {t:428,w:6.579252}; case 58: return {t:910,w:2.197225}; case 61: return {t:912,w:2.197225}; case 64: return {t:913,w:2.197225}; case 65: return {t:432,w:7.534764}; case 66: return {t:432,w:7.534764}; case 67: return {t:432,w:7.534764}; case 68: return {t:432,w:7.534764}; case 69: return {t:432,w:7.534764}; case 70: return {t:432,w:7.534764}; case 71: return {t:432,w:7.534764}; case 72: return {t:432,w:7.534764}; case 73: return {t:432,w:7.534764}; case 74: return {t:432,w:7.534764}; case 75: return {t:432,w:7.534764}; case 76: return {t:432,w:7.534764}; case 77: return {t:432,w:7.534764}; case 78: return {t:432,w:7.534764}; case 79: return {t:432,w:7.534764}; case 80: return {t:432,w:7.534764}; case 81: return {t:432,w:7.534764}; case 82: return {t:432,w:7.534764}; case 83: return {t:432,w:7.534764}; case 84: return {t:432,w:7.534764}; case 85: return {t:432,w:7.534764}; case 86: return {t:432,w:7.534764}; case 87: return {t:432,w:7.534764}; case 88: return {t:432,w:7.534764}; case 89: return {t:432,w:7.534764}; case 90: return {t:432,w:7.534764}; case 95: return {t:433,w:4.276667}; case 97: return {t:434,w:7.534764}; case 98: return {t:434,w:7.534764}; case 99: return {t:434,w:7.534764}; case 100: return {t:434,w:7.534764}; case 101: return {t:434,w:7.534764}; case 102: return {t:434,w:7.534764}; case 103: return {t:434,w:7.534764}; case 104: return {t:434,w:7.534764}; case 105: return {t:434,w:7.534764}; case 106: return {t:434,w:7.534764}; case 107: return {t:434,w:7.534764}; case 108: return {t:434,w:7.534764}; case 109: return {t:434,w:7.534764}; case 110: return {t:434,w:7.534764}; case 111: return {t:434,w:7.534764}; case 112: return {t:434,w:7.534764}; case 113: return {t:434,w:7.534764}; case 114: return {t:434,w:7.534764}; case 115: return {t:434,w:7.534764}; case 116: return {t:434,w:7.534764}; case 117: return {t:434,w:7.534764}; case 118: return {t:434,w:7.534764}; case 119: return {t:434,w:7.534764}; case 120: return {t:434,w:7.534764}; case 121: return {t:434,w:7.534764}; case 122: return {t:434,w:7.534764}; case 126: return {t:435,w:4.276667}; case 363: return {t:915,w:2.197225}; case 364: return {t:916,w:2.197225};default: return {t:0,w:0.0};}};
case 1087: return function (act:Int) {switch (act) { case 419: return {t:1087,w:0.000000};default: return {t:0,w:0.0};}};
case 1088: return function (act:Int) {switch (act) { case 59: return {t:1085,w:1.386294}; case 256: return {t:1086,w:4000000.750000}; case 258: return {t:1087,w:1.386294}; case 418: return {t:1088,w:0.693147};default: return {t:0,w:0.0};}};
case 1089: return function (act:Int) {switch (act) { case 256: return {t:1215,w:4000000.000000}; case 419: return {t:1216,w:0.000000};default: return {t:0,w:0.0};}};
case 1090: return function (act:Int) {switch (act) { case 395: return {t:1090,w:0.000000};default: return {t:0,w:0.0};}};
case 1091: return function (act:Int) {switch (act) { case 420: return {t:1091,w:0.000000};default: return {t:0,w:0.0};}};
case 1092: return function (act:Int) {switch (act) { case 256: return {t:784,w:4000000.750000}; case 258: return {t:1217,w:0.693147}; case 396: return {t:1218,w:0.693147};default: return {t:0,w:0.0};}};
case 1093: return function (act:Int) {switch (act) { case 396: return {t:1093,w:0.000000};default: return {t:0,w:0.0};}};
case 1094: return function (act:Int) {switch (act) { case 258: return {t:791,w:0.000000};default: return {t:0,w:0.0};}};
case 1095: return function (act:Int) {switch (act) { case 256: return {t:626,w:4000000.000000}; case 366: return {t:1219,w:0.000000};default: return {t:0,w:0.0};}};
case 1096: return function (act:Int) {switch (act) { case 78: return {t:1220,w:0.693147}; case 110: return {t:1220,w:0.693147};default: return {t:0,w:0.0};}};
case 1097: return function (act:Int) {switch (act) { case 65: return {t:1221,w:0.693147}; case 97: return {t:1221,w:0.693147};default: return {t:0,w:0.0};}};
case 1098: return function (act:Int) {switch (act) { case 33: return {t:2,w:5.981413}; case 37: return {t:3,w:5.981413}; case 39: return {t:4,w:5.981413}; case 42: return {t:1222,w:1.098612}; case 43: return {t:6,w:5.981413}; case 45: return {t:7,w:5.981413}; case 46: return {t:8,w:5.981413}; case 48: return {t:9,w:9.382610}; case 49: return {t:9,w:9.382610}; case 50: return {t:9,w:9.382610}; case 51: return {t:9,w:9.382610}; case 52: return {t:9,w:9.382610}; case 53: return {t:9,w:9.382610}; case 54: return {t:9,w:9.382610}; case 55: return {t:9,w:9.382610}; case 56: return {t:9,w:9.382610}; case 57: return {t:9,w:9.382610}; case 65: return {t:465,w:4.276665}; case 66: return {t:13,w:10.338122}; case 67: return {t:13,w:10.338122}; case 68: return {t:13,w:10.338122}; case 69: return {t:13,w:10.338122}; case 70: return {t:13,w:10.338122}; case 71: return {t:13,w:10.338122}; case 72: return {t:13,w:10.338122}; case 73: return {t:466,w:4.276665}; case 74: return {t:13,w:10.338122}; case 75: return {t:13,w:10.338122}; case 76: return {t:13,w:10.338122}; case 77: return {t:467,w:3.583518}; case 78: return {t:13,w:10.338122}; case 79: return {t:13,w:10.338122}; case 80: return {t:13,w:10.338122}; case 81: return {t:13,w:10.338122}; case 82: return {t:13,w:10.338122}; case 83: return {t:13,w:10.338122}; case 84: return {t:468,w:4.276665}; case 85: return {t:13,w:10.338122}; case 86: return {t:469,w:4.276665}; case 87: return {t:13,w:10.338122}; case 88: return {t:470,w:4.276665}; case 89: return {t:13,w:10.338122}; case 90: return {t:13,w:10.338122}; case 95: return {t:18,w:5.981413}; case 96: return {t:19,w:5.981413}; case 97: return {t:471,w:4.276665}; case 98: return {t:20,w:10.338122}; case 99: return {t:20,w:10.338122}; case 100: return {t:20,w:10.338122}; case 101: return {t:20,w:10.338122}; case 102: return {t:20,w:10.338122}; case 103: return {t:20,w:10.338122}; case 104: return {t:20,w:10.338122}; case 105: return {t:472,w:4.276665}; case 106: return {t:20,w:10.338122}; case 107: return {t:20,w:10.338122}; case 108: return {t:20,w:10.338122}; case 109: return {t:473,w:3.583518}; case 110: return {t:20,w:10.338122}; case 111: return {t:20,w:10.338122}; case 112: return {t:20,w:10.338122}; case 113: return {t:20,w:10.338122}; case 114: return {t:20,w:10.338122}; case 115: return {t:20,w:10.338122}; case 116: return {t:474,w:4.276665}; case 117: return {t:20,w:10.338122}; case 118: return {t:475,w:4.276665}; case 119: return {t:20,w:10.338122}; case 120: return {t:476,w:4.276665}; case 121: return {t:20,w:10.338122}; case 122: return {t:20,w:10.338122}; case 126: return {t:22,w:5.981413}; case 268: return {t:29,w:5.981413}; case 269: return {t:477,w:3.583518}; case 369: return {t:478,w:3.583518}; case 370: return {t:479,w:3.583518}; case 371: return {t:480,w:2.890371}; case 372: return {t:481,w:1.791759}; case 373: return {t:482,w:1.791759}; case 374: return {t:1223,w:1.098612}; case 449: return {t:1224,w:0.000000};default: return {t:0,w:0.0};}};
case 1099: return function (act:Int) {switch (act) { case 284: return {t:1099,w:0.000000};default: return {t:0,w:0.0};}};
case 1100: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1099,w:0.693147}; case 375: return {t:1225,w:0.693147};default: return {t:0,w:0.0};}};
case 1101: return function (act:Int) {switch (act) { case 70: return {t:1226,w:0.693147}; case 102: return {t:1226,w:0.693147};default: return {t:0,w:0.0};}};
case 1102: return function (act:Int) {switch (act) { case 256: return {t:933,w:4000000.000000}; case 271: return {t:1227,w:0.000000};default: return {t:0,w:0.0};}};
case 1103: return function (act:Int) {switch (act) { case 67: return {t:1228,w:0.693147}; case 99: return {t:1228,w:0.693147};default: return {t:0,w:0.0};}};
case 1104: return function (act:Int) {switch (act) { case 65: return {t:1229,w:0.693147}; case 97: return {t:1229,w:0.693147};default: return {t:0,w:0.0};}};
case 1105: return function (act:Int) {switch (act) { case 79: return {t:1230,w:0.693147}; case 111: return {t:1230,w:0.693147};default: return {t:0,w:0.0};}};
case 1106: return function (act:Int) {switch (act) { case 68: return {t:1231,w:0.693147}; case 69: return {t:1232,w:1.386294}; case 76: return {t:1233,w:0.693147}; case 84: return {t:1234,w:1.386294}; case 100: return {t:1231,w:0.693147}; case 101: return {t:1232,w:1.386294}; case 108: return {t:1233,w:0.693147}; case 116: return {t:1234,w:1.386294};default: return {t:0,w:0.0};}};
case 1107: return function (act:Int) {switch (act) { case 258: return {t:1235,w:0.000000};default: return {t:0,w:0.0};}};
case 1108: return function (act:Int) {switch (act) { case 67: return {t:1236,w:0.693147}; case 99: return {t:1236,w:0.693147};default: return {t:0,w:0.0};}};
case 1109: return function (act:Int) {switch (act) { case 258: return {t:814,w:0.000000};default: return {t:0,w:0.0};}};
case 1110: return function (act:Int) {switch (act) { case 258: return {t:814,w:0.000000};default: return {t:0,w:0.0};}};
case 1111: return function (act:Int) {switch (act) { case 71: return {t:1237,w:0.693147}; case 103: return {t:1237,w:0.693147};default: return {t:0,w:0.0};}};
case 1112: return function (act:Int) {switch (act) { case 80: return {t:1238,w:0.693147}; case 112: return {t:1238,w:0.693147};default: return {t:0,w:0.0};}};
case 1113: return function (act:Int) {switch (act) { case 258: return {t:814,w:0.000000};default: return {t:0,w:0.0};}};
case 1114: return function (act:Int) {switch (act) { case 258: return {t:1239,w:0.000000};default: return {t:0,w:0.0};}};
case 1115: return function (act:Int) {switch (act) { case 369: return {t:661,w:0.693147}; case 421: return {t:1240,w:0.000000};default: return {t:0,w:0.0};}};
case 1116: return function (act:Int) {switch (act) { case 397: return {t:1116,w:0.000000};default: return {t:0,w:0.0};}};
case 1117: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:1241,w:0.000000}; case 450: return {t:1242,w:0.000000};default: return {t:0,w:0.0};}};
case 1118: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:959,w:0.693147}; case 384: return {t:960,w:0.693147};default: return {t:0,w:0.0};}};
case 1119: return function (act:Int) {switch (act) { case 73: return {t:1243,w:0.693147}; case 105: return {t:1243,w:0.693147};default: return {t:0,w:0.0};}};
case 1120: return function (act:Int) {switch (act) { case 78: return {t:1244,w:0.693147}; case 110: return {t:1244,w:0.693147};default: return {t:0,w:0.0};}};
case 1121: return function (act:Int) {switch (act) { case 84: return {t:1245,w:0.693147}; case 116: return {t:1245,w:0.693147};default: return {t:0,w:0.0};}};
case 1122: return function (act:Int) {switch (act) { case 78: return {t:1246,w:0.693147}; case 110: return {t:1246,w:0.693147};default: return {t:0,w:0.0};}};
case 1123: return function (act:Int) {switch (act) { case 85: return {t:1247,w:0.693147}; case 117: return {t:1247,w:0.693147};default: return {t:0,w:0.0};}};
case 1124: return function (act:Int) {switch (act) { case 69: return {t:1248,w:0.693147}; case 101: return {t:1248,w:0.693147};default: return {t:0,w:0.0};}};
case 1125: return function (act:Int) {switch (act) { case 68: return {t:1249,w:0.693147}; case 100: return {t:1249,w:0.693147};default: return {t:0,w:0.0};}};
case 1126: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:1250,w:0.000000};default: return {t:0,w:0.0};}};
case 1127: return function (act:Int) {switch (act) { case 398: return {t:1127,w:0.000000};default: return {t:0,w:0.0};}};
case 1128: return function (act:Int) {switch (act) { case 70: return {t:1251,w:0.693147}; case 102: return {t:1251,w:0.693147};default: return {t:0,w:0.0};}};
case 1129: return function (act:Int) {switch (act) { case 256: return {t:1252,w:4000000.000000}; case 451: return {t:1253,w:0.000000};default: return {t:0,w:0.0};}};
case 1130: return function (act:Int) {switch (act) { case 375: return {t:1130,w:0.000000};default: return {t:0,w:0.0};}};
case 1131: return function (act:Int) {switch (act) { case 399: return {t:1131,w:0.000000};default: return {t:0,w:0.0};}};
case 1132: return function (act:Int) {switch (act) { case 258: return {t:1254,w:0.000000};default: return {t:0,w:0.0};}};
case 1133: return function (act:Int) {switch (act) { case 258: return {t:1254,w:0.000000};default: return {t:0,w:0.0};}};
case 1134: return function (act:Int) {switch (act) { case 258: return {t:1254,w:0.000000};default: return {t:0,w:0.0};}};
case 1135: return function (act:Int) {switch (act) { case 258: return {t:1255,w:0.000000};default: return {t:0,w:0.0};}};
case 1136: return function (act:Int) {switch (act) { case 402: return {t:1136,w:0.000000};default: return {t:0,w:0.0};}};
case 1137: return function (act:Int) {switch (act) { case 45: return {t:1256,w:0.000000};default: return {t:0,w:0.0};}};
case 1138: return function (act:Int) {switch (act) { case 65: return {t:1257,w:0.693147}; case 97: return {t:1257,w:0.693147};default: return {t:0,w:0.0};}};
case 1139: return function (act:Int) {switch (act) { case 83: return {t:1258,w:0.693147}; case 115: return {t:1258,w:0.693147};default: return {t:0,w:0.0};}};
case 1140: return function (act:Int) {switch (act) { case 82: return {t:1259,w:0.693147}; case 114: return {t:1259,w:0.693147};default: return {t:0,w:0.0};}};
case 1141: return function (act:Int) {switch (act) { case 80: return {t:1260,w:0.693147}; case 112: return {t:1260,w:0.693147};default: return {t:0,w:0.0};}};
case 1142: return function (act:Int) {switch (act) { case 256: return {t:1261,w:4000000.000000}; case 452: return {t:1262,w:0.000000};default: return {t:0,w:0.0};}};
case 1143: return function (act:Int) {switch (act) { case 426: return {t:1143,w:0.000000};default: return {t:0,w:0.0};}};
case 1144: return function (act:Int) {switch (act) { case 403: return {t:1144,w:0.000000};default: return {t:0,w:0.0};}};
case 1145: return function (act:Int) {switch (act) { case 84: return {t:1263,w:0.693147}; case 116: return {t:1263,w:0.693147};default: return {t:0,w:0.0};}};
case 1146: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1264,w:0.000000};default: return {t:0,w:0.0};}};
case 1147: return function (act:Int) {switch (act) { case 84: return {t:1265,w:0.693147}; case 116: return {t:1265,w:0.693147};default: return {t:0,w:0.0};}};
case 1148: return function (act:Int) {switch (act) { case 81: return {t:1266,w:0.693147}; case 113: return {t:1266,w:0.693147};default: return {t:0,w:0.0};}};
case 1149: return function (act:Int) {switch (act) { case 79: return {t:1267,w:0.693147}; case 111: return {t:1267,w:0.693147};default: return {t:0,w:0.0};}};
case 1150: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1268,w:0.000000};default: return {t:0,w:0.0};}};
case 1151: return function (act:Int) {switch (act) { case 256: return {t:313,w:4000000.000000}; case 353: return {t:1269,w:0.000000};default: return {t:0,w:0.0};}};
case 1152: return function (act:Int) {switch (act) { case 84: return {t:1270,w:0.693147}; case 116: return {t:1270,w:0.693147};default: return {t:0,w:0.0};}};
case 1153: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1271,w:0.693147}; case 384: return {t:1272,w:0.693147};default: return {t:0,w:0.0};}};
case 1154: return function (act:Int) {switch (act) { case 317: return {t:1154,w:0.000000};default: return {t:0,w:0.0};}};
case 1155: return function (act:Int) {switch (act) { case 256: return {t:1005,w:4000000.000000}; case 427: return {t:1273,w:0.000000};default: return {t:0,w:0.0};}};
case 1156: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.772588}; case 13: return {t:83,w:2.772588}; case 32: return {t:494,w:2.772588}; case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 258: return {t:651,w:1.386294}; case 268: return {t:29,w:3.091042}; case 269: return {t:1274,w:0.693147}; case 279: return {t:504,w:2.772588}; case 283: return {t:119,w:2.772588}; case 368: return {t:1275,w:0.693147}; case 376: return {t:505,w:2.079441}; case 377: return {t:506,w:1.386294}; case 453: return {t:1276,w:0.693147}; case 454: return {t:1277,w:0.693147}; case 455: return {t:1278,w:0.693147};default: return {t:0,w:0.0};}};
case 1157: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.750000}; case 258: return {t:1279,w:0.693147}; case 377: return {t:1280,w:0.693147};default: return {t:0,w:0.0};}};
case 1158: return function (act:Int) {switch (act) { case 68: return {t:1281,w:0.693147}; case 100: return {t:1281,w:0.693147};default: return {t:0,w:0.0};}};
case 1159: return function (act:Int) {switch (act) { case 80: return {t:1282,w:0.693147}; case 112: return {t:1282,w:0.693147};default: return {t:0,w:0.0};}};
case 1160: return function (act:Int) {switch (act) { case 384: return {t:1160,w:0.000000};default: return {t:0,w:0.0};}};
case 1161: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:1283,w:0.000000};default: return {t:0,w:0.0};}};
case 1162: return function (act:Int) {switch (act) { case 61: return {t:1284,w:0.000000};default: return {t:0,w:0.0};}};
case 1163: return function (act:Int) {switch (act) { case 9: return {t:493,w:3.178053}; case 13: return {t:83,w:3.178053}; case 32: return {t:494,w:3.178053}; case 33: return {t:2,w:3.496507}; case 37: return {t:3,w:3.496507}; case 39: return {t:4,w:3.496507}; case 42: return {t:5,w:3.496507}; case 43: return {t:6,w:3.496507}; case 45: return {t:7,w:3.496507}; case 46: return {t:8,w:3.496507}; case 48: return {t:1285,w:4.499809}; case 49: return {t:1285,w:4.499809}; case 50: return {t:1285,w:4.499809}; case 51: return {t:1285,w:4.499809}; case 52: return {t:1285,w:4.499809}; case 53: return {t:1285,w:4.499809}; case 54: return {t:1285,w:4.499809}; case 55: return {t:1285,w:4.499809}; case 56: return {t:1285,w:4.499809}; case 57: return {t:1285,w:4.499809}; case 65: return {t:1286,w:7.534762}; case 66: return {t:1286,w:7.534762}; case 67: return {t:1286,w:7.534762}; case 68: return {t:1286,w:7.534762}; case 69: return {t:1286,w:7.534762}; case 70: return {t:1286,w:7.534762}; case 71: return {t:1286,w:7.534762}; case 72: return {t:1286,w:7.534762}; case 73: return {t:1286,w:7.534762}; case 74: return {t:1286,w:7.534762}; case 75: return {t:1286,w:7.534762}; case 76: return {t:1286,w:7.534762}; case 77: return {t:1286,w:7.534762}; case 78: return {t:1286,w:7.534762}; case 79: return {t:1286,w:7.534762}; case 80: return {t:1286,w:7.534762}; case 81: return {t:1286,w:7.534762}; case 82: return {t:1286,w:7.534762}; case 83: return {t:1286,w:7.534762}; case 84: return {t:1286,w:7.534762}; case 85: return {t:1286,w:7.534762}; case 86: return {t:1286,w:7.534762}; case 87: return {t:1286,w:7.534762}; case 88: return {t:1286,w:7.534762}; case 89: return {t:1286,w:7.534762}; case 90: return {t:1286,w:7.534762}; case 91: return {t:884,w:2.197224}; case 95: return {t:18,w:3.496507}; case 96: return {t:19,w:3.496507}; case 97: return {t:1287,w:7.534762}; case 98: return {t:1287,w:7.534762}; case 99: return {t:1287,w:7.534762}; case 100: return {t:1287,w:7.534762}; case 101: return {t:1287,w:7.534762}; case 102: return {t:1287,w:7.534762}; case 103: return {t:1287,w:7.534762}; case 104: return {t:1287,w:7.534762}; case 105: return {t:1287,w:7.534762}; case 106: return {t:1287,w:7.534762}; case 107: return {t:1287,w:7.534762}; case 108: return {t:1287,w:7.534762}; case 109: return {t:1287,w:7.534762}; case 110: return {t:1287,w:7.534762}; case 111: return {t:1287,w:7.534762}; case 112: return {t:1287,w:7.534762}; case 113: return {t:1287,w:7.534762}; case 114: return {t:1287,w:7.534762}; case 115: return {t:1287,w:7.534762}; case 116: return {t:1287,w:7.534762}; case 117: return {t:1287,w:7.534762}; case 118: return {t:1287,w:7.534762}; case 119: return {t:1287,w:7.534762}; case 120: return {t:1287,w:7.534762}; case 121: return {t:1287,w:7.534762}; case 122: return {t:1287,w:7.534762}; case 126: return {t:22,w:3.496507}; case 258: return {t:651,w:1.791759}; case 268: return {t:1288,w:3.496507}; case 269: return {t:1289,w:1.098612}; case 279: return {t:504,w:3.178053}; case 283: return {t:119,w:3.178053}; case 331: return {t:892,w:3.583518}; case 336: return {t:895,w:2.197224}; case 368: return {t:1291,w:1.098612}; case 376: return {t:505,w:2.484906}; case 377: return {t:506,w:1.791759}; case 378: return {t:1292,w:1.098612}; case 410: return {t:891,w:2.890371}; case 411: return {t:893,w:2.890371}; case 412: return {t:894,w:2.197224}; case 413: return {t:896,w:2.197224}; case 414: return {t:897,w:2.197224}; case 415: return {t:1290,w:1.098612};default: return {t:0,w:0.0};}};
case 1164: return function (act:Int) {switch (act) { case 258: return {t:1014,w:0.000000};default: return {t:0,w:0.0};}};
case 1165: return function (act:Int) {switch (act) { case 84: return {t:1293,w:0.693147}; case 116: return {t:1293,w:0.693147};default: return {t:0,w:0.0};}};
case 1166: return function (act:Int) {switch (act) { case 78: return {t:1294,w:0.693147}; case 110: return {t:1294,w:0.693147};default: return {t:0,w:0.0};}};
case 1167: return function (act:Int) {switch (act) { case 406: return {t:1167,w:0.000000};default: return {t:0,w:0.0};}};
case 1168: return function (act:Int) {switch (act) { case 33: return {t:2,w:4.007333}; case 37: return {t:3,w:4.007333}; case 39: return {t:4,w:4.007333}; case 42: return {t:5,w:4.007333}; case 43: return {t:6,w:4.007333}; case 45: return {t:7,w:4.007333}; case 46: return {t:8,w:4.007333}; case 48: return {t:9,w:7.408530}; case 49: return {t:9,w:7.408530}; case 50: return {t:9,w:7.408530}; case 51: return {t:9,w:7.408530}; case 52: return {t:9,w:7.408530}; case 53: return {t:9,w:7.408530}; case 54: return {t:9,w:7.408530}; case 55: return {t:9,w:7.408530}; case 56: return {t:9,w:7.408530}; case 57: return {t:9,w:7.408530}; case 65: return {t:13,w:8.364042}; case 66: return {t:13,w:8.364042}; case 67: return {t:13,w:8.364042}; case 68: return {t:13,w:8.364042}; case 69: return {t:13,w:8.364042}; case 70: return {t:13,w:8.364042}; case 71: return {t:13,w:8.364042}; case 72: return {t:13,w:8.364042}; case 73: return {t:13,w:8.364042}; case 74: return {t:13,w:8.364042}; case 75: return {t:13,w:8.364042}; case 76: return {t:13,w:8.364042}; case 77: return {t:13,w:8.364042}; case 78: return {t:13,w:8.364042}; case 79: return {t:13,w:8.364042}; case 80: return {t:13,w:8.364042}; case 81: return {t:13,w:8.364042}; case 82: return {t:13,w:8.364042}; case 83: return {t:1295,w:2.302585}; case 84: return {t:1296,w:2.302585}; case 85: return {t:1297,w:2.302585}; case 86: return {t:13,w:8.364042}; case 87: return {t:13,w:8.364042}; case 88: return {t:13,w:8.364042}; case 89: return {t:13,w:8.364042}; case 90: return {t:13,w:8.364042}; case 95: return {t:18,w:4.007333}; case 96: return {t:19,w:4.007333}; case 97: return {t:20,w:8.364042}; case 98: return {t:20,w:8.364042}; case 99: return {t:20,w:8.364042}; case 100: return {t:20,w:8.364042}; case 101: return {t:20,w:8.364042}; case 102: return {t:20,w:8.364042}; case 103: return {t:20,w:8.364042}; case 104: return {t:20,w:8.364042}; case 105: return {t:20,w:8.364042}; case 106: return {t:20,w:8.364042}; case 107: return {t:20,w:8.364042}; case 108: return {t:20,w:8.364042}; case 109: return {t:20,w:8.364042}; case 110: return {t:20,w:8.364042}; case 111: return {t:20,w:8.364042}; case 112: return {t:20,w:8.364042}; case 113: return {t:20,w:8.364042}; case 114: return {t:20,w:8.364042}; case 115: return {t:1298,w:2.302585}; case 116: return {t:1299,w:2.302585}; case 117: return {t:1300,w:2.302585}; case 118: return {t:20,w:8.364042}; case 119: return {t:20,w:8.364042}; case 120: return {t:20,w:8.364042}; case 121: return {t:20,w:8.364042}; case 122: return {t:20,w:8.364042}; case 126: return {t:22,w:4.007333}; case 268: return {t:29,w:4.007333}; case 269: return {t:1301,w:1.609438}; case 456: return {t:1302,w:1.609438};default: return {t:0,w:0.0};}};
case 1169: return function (act:Int) {switch (act) { case 258: return {t:1303,w:0.000000};default: return {t:0,w:0.0};}};
case 1170: return function (act:Int) {switch (act) { case 268: return {t:52,w:2.484906}; case 336: return {t:271,w:0.000000};default: return {t:0,w:0.0};}};
case 1171: return function (act:Int) {switch (act) { case 268: return {t:52,w:0.405465}; case 331: return {t:258,w:0.000000};default: return {t:0,w:0.0};}};
case 1172: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1304,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 1173: return function (act:Int) {switch (act) { case 407: return {t:1173,w:0.000000};default: return {t:0,w:0.0};}};
case 1174: return function (act:Int) {switch (act) { case 256: return {t:1195,w:4000000.000000}; case 446: return {t:1305,w:0.000000};default: return {t:0,w:0.0};}};
case 1175: return function (act:Int) {switch (act) { case 33: return {t:2,w:4.007333}; case 37: return {t:3,w:4.007333}; case 39: return {t:4,w:4.007333}; case 42: return {t:5,w:4.007333}; case 43: return {t:6,w:4.007333}; case 45: return {t:7,w:4.007333}; case 46: return {t:8,w:4.007333}; case 48: return {t:9,w:7.408530}; case 49: return {t:9,w:7.408530}; case 50: return {t:9,w:7.408530}; case 51: return {t:9,w:7.408530}; case 52: return {t:9,w:7.408530}; case 53: return {t:9,w:7.408530}; case 54: return {t:9,w:7.408530}; case 55: return {t:9,w:7.408530}; case 56: return {t:9,w:7.408530}; case 57: return {t:9,w:7.408530}; case 65: return {t:13,w:8.364042}; case 66: return {t:1306,w:2.302585}; case 67: return {t:13,w:8.364042}; case 68: return {t:13,w:8.364042}; case 69: return {t:13,w:8.364042}; case 70: return {t:13,w:8.364042}; case 71: return {t:13,w:8.364042}; case 72: return {t:13,w:8.364042}; case 73: return {t:13,w:8.364042}; case 74: return {t:13,w:8.364042}; case 75: return {t:13,w:8.364042}; case 76: return {t:13,w:8.364042}; case 77: return {t:1307,w:2.302585}; case 78: return {t:13,w:8.364042}; case 79: return {t:13,w:8.364042}; case 80: return {t:13,w:8.364042}; case 81: return {t:13,w:8.364042}; case 82: return {t:1308,w:2.302585}; case 83: return {t:13,w:8.364042}; case 84: return {t:1309,w:2.302585}; case 85: return {t:13,w:8.364042}; case 86: return {t:13,w:8.364042}; case 87: return {t:13,w:8.364042}; case 88: return {t:13,w:8.364042}; case 89: return {t:13,w:8.364042}; case 90: return {t:13,w:8.364042}; case 95: return {t:18,w:4.007333}; case 96: return {t:19,w:4.007333}; case 97: return {t:20,w:8.364042}; case 98: return {t:1310,w:2.302585}; case 99: return {t:20,w:8.364042}; case 100: return {t:20,w:8.364042}; case 101: return {t:20,w:8.364042}; case 102: return {t:20,w:8.364042}; case 103: return {t:20,w:8.364042}; case 104: return {t:20,w:8.364042}; case 105: return {t:20,w:8.364042}; case 106: return {t:20,w:8.364042}; case 107: return {t:20,w:8.364042}; case 108: return {t:20,w:8.364042}; case 109: return {t:1311,w:2.302585}; case 110: return {t:20,w:8.364042}; case 111: return {t:20,w:8.364042}; case 112: return {t:20,w:8.364042}; case 113: return {t:20,w:8.364042}; case 114: return {t:1312,w:2.302585}; case 115: return {t:20,w:8.364042}; case 116: return {t:1313,w:2.302585}; case 117: return {t:20,w:8.364042}; case 118: return {t:20,w:8.364042}; case 119: return {t:20,w:8.364042}; case 120: return {t:20,w:8.364042}; case 121: return {t:20,w:8.364042}; case 122: return {t:20,w:8.364042}; case 126: return {t:22,w:4.007333}; case 268: return {t:29,w:4.007333}; case 269: return {t:862,w:1.609438}; case 404: return {t:1314,w:1.609438}; case 457: return {t:1315,w:1.609438}; case 458: return {t:1316,w:1.609438}; case 459: return {t:1317,w:1.609438}; case 460: return {t:1318,w:1.609438}; case 461: return {t:1319,w:1.609438};default: return {t:0,w:0.0};}};
case 1176: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1025,w:0.693147}; case 384: return {t:1026,w:0.693147};default: return {t:0,w:0.0};}};
case 1177: return function (act:Int) {switch (act) { case 256: return {t:1320,w:4000000.000000}; case 462: return {t:1321,w:0.000000};default: return {t:0,w:0.0};}};
case 1178: return function (act:Int) {switch (act) { case 69: return {t:1322,w:0.693147}; case 101: return {t:1322,w:0.693147};default: return {t:0,w:0.0};}};
case 1179: return function (act:Int) {switch (act) { case 58: return {t:1323,w:0.000000};default: return {t:0,w:0.0};}};
case 1180: return function (act:Int) {switch (act) { case 256: return {t:623,w:4000000.750000}; case 258: return {t:1324,w:0.693147}; case 390: return {t:1325,w:0.693147};default: return {t:0,w:0.0};}};
case 1181: return function (act:Int) {switch (act) { case 58: return {t:1326,w:0.693147}; case 258: return {t:1327,w:0.693147};default: return {t:0,w:0.0};}};
case 1182: return function (act:Int) {switch (act) { case 58: return {t:1328,w:0.000000}; case 258: return {t:1329,w:0.000000};default: return {t:0,w:0.0};}};
case 1183: return function (act:Int) {switch (act) { case 58: return {t:1330,w:0.693147}; case 258: return {t:1331,w:0.693147};default: return {t:0,w:0.0};}};
case 1184: return function (act:Int) {switch (act) { case 258: return {t:1332,w:0.000000};default: return {t:0,w:0.0};}};
case 1185: return function (act:Int) {switch (act) { case 258: return {t:1333,w:0.000000};default: return {t:0,w:0.0};}};
case 1186: return function (act:Int) {switch (act) { case 45: return {t:1034,w:1.386294}; case 256: return {t:49,w:4000000.750000}; case 268: return {t:1036,w:0.693147};default: return {t:0,w:0.0};}};
case 1187: return function (act:Int) {switch (act) { case 33: return {t:420,w:4.718499}; case 36: return {t:1334,w:2.639057}; case 37: return {t:422,w:2.639057}; case 38: return {t:1335,w:2.639057}; case 39: return {t:424,w:6.104793}; case 40: return {t:424,w:6.104793}; case 41: return {t:424,w:6.104793}; case 42: return {t:424,w:6.104793}; case 43: return {t:1336,w:2.639057}; case 44: return {t:1337,w:2.639057}; case 45: return {t:426,w:5.411646}; case 46: return {t:426,w:5.411646}; case 48: return {t:428,w:7.021084}; case 49: return {t:428,w:7.021084}; case 50: return {t:428,w:7.021084}; case 51: return {t:428,w:7.021084}; case 52: return {t:428,w:7.021084}; case 53: return {t:428,w:7.021084}; case 54: return {t:428,w:7.021084}; case 55: return {t:428,w:7.021084}; case 56: return {t:428,w:7.021084}; case 57: return {t:428,w:7.021084}; case 61: return {t:1338,w:2.639057}; case 65: return {t:432,w:7.976596}; case 66: return {t:432,w:7.976596}; case 67: return {t:432,w:7.976596}; case 68: return {t:432,w:7.976596}; case 69: return {t:432,w:7.976596}; case 70: return {t:432,w:7.976596}; case 71: return {t:432,w:7.976596}; case 72: return {t:432,w:7.976596}; case 73: return {t:432,w:7.976596}; case 74: return {t:432,w:7.976596}; case 75: return {t:432,w:7.976596}; case 76: return {t:432,w:7.976596}; case 77: return {t:432,w:7.976596}; case 78: return {t:432,w:7.976596}; case 79: return {t:432,w:7.976596}; case 80: return {t:432,w:7.976596}; case 81: return {t:432,w:7.976596}; case 82: return {t:432,w:7.976596}; case 83: return {t:432,w:7.976596}; case 84: return {t:432,w:7.976596}; case 85: return {t:432,w:7.976596}; case 86: return {t:432,w:7.976596}; case 87: return {t:432,w:7.976596}; case 88: return {t:432,w:7.976596}; case 89: return {t:432,w:7.976596}; case 90: return {t:432,w:7.976596}; case 95: return {t:433,w:4.718499}; case 97: return {t:434,w:7.976596}; case 98: return {t:434,w:7.976596}; case 99: return {t:434,w:7.976596}; case 100: return {t:434,w:7.976596}; case 101: return {t:434,w:7.976596}; case 102: return {t:434,w:7.976596}; case 103: return {t:434,w:7.976596}; case 104: return {t:434,w:7.976596}; case 105: return {t:434,w:7.976596}; case 106: return {t:434,w:7.976596}; case 107: return {t:434,w:7.976596}; case 108: return {t:434,w:7.976596}; case 109: return {t:434,w:7.976596}; case 110: return {t:434,w:7.976596}; case 111: return {t:434,w:7.976596}; case 112: return {t:434,w:7.976596}; case 113: return {t:434,w:7.976596}; case 114: return {t:434,w:7.976596}; case 115: return {t:434,w:7.976596}; case 116: return {t:434,w:7.976596}; case 117: return {t:434,w:7.976596}; case 118: return {t:434,w:7.976596}; case 119: return {t:434,w:7.976596}; case 120: return {t:434,w:7.976596}; case 121: return {t:434,w:7.976596}; case 122: return {t:434,w:7.976596}; case 126: return {t:435,w:4.718499}; case 258: return {t:1339,w:0.693147}; case 363: return {t:1340,w:2.639057}; case 364: return {t:1341,w:2.639057};default: return {t:0,w:0.0};}};
case 1188: return function (act:Int) {switch (act) { case 64: return {t:1043,w:0.000000};default: return {t:0,w:0.0};}};
case 1189: return function (act:Int) {switch (act) { case 393: return {t:1189,w:0.000000};default: return {t:0,w:0.0};}};
case 1190: return function (act:Int) {switch (act) { case 48: return {t:9,w:4.094344}; case 49: return {t:9,w:4.094344}; case 50: return {t:9,w:4.094344}; case 51: return {t:9,w:4.094344}; case 52: return {t:9,w:4.094344}; case 53: return {t:9,w:4.094344}; case 54: return {t:9,w:4.094344}; case 55: return {t:9,w:4.094344}; case 56: return {t:9,w:4.094344}; case 57: return {t:9,w:4.094344}; case 65: return {t:1022,w:4.644391}; case 66: return {t:1022,w:4.644391}; case 67: return {t:1022,w:4.644391}; case 68: return {t:1022,w:4.644391}; case 69: return {t:1022,w:4.644391}; case 70: return {t:1022,w:4.644391}; case 71: return {t:1022,w:4.644391}; case 72: return {t:1022,w:4.644391}; case 73: return {t:1022,w:4.644391}; case 74: return {t:1022,w:4.644391}; case 75: return {t:1022,w:4.644391}; case 76: return {t:1022,w:4.644391}; case 77: return {t:1022,w:4.644391}; case 78: return {t:1022,w:4.644391}; case 79: return {t:1022,w:4.644391}; case 80: return {t:1022,w:4.644391}; case 81: return {t:1022,w:4.644391}; case 82: return {t:1022,w:4.644391}; case 83: return {t:1022,w:4.644391}; case 84: return {t:1022,w:4.644391}; case 85: return {t:1022,w:4.644391}; case 86: return {t:1022,w:4.644391}; case 87: return {t:1022,w:4.644391}; case 88: return {t:1022,w:4.644391}; case 89: return {t:1022,w:4.644391}; case 90: return {t:1022,w:4.644391}; case 97: return {t:1023,w:4.644391}; case 98: return {t:1023,w:4.644391}; case 99: return {t:1023,w:4.644391}; case 100: return {t:1023,w:4.644391}; case 101: return {t:1023,w:4.644391}; case 102: return {t:1023,w:4.644391}; case 103: return {t:1023,w:4.644391}; case 104: return {t:1023,w:4.644391}; case 105: return {t:1023,w:4.644391}; case 106: return {t:1023,w:4.644391}; case 107: return {t:1023,w:4.644391}; case 108: return {t:1023,w:4.644391}; case 109: return {t:1023,w:4.644391}; case 110: return {t:1023,w:4.644391}; case 111: return {t:1023,w:4.644391}; case 112: return {t:1023,w:4.644391}; case 113: return {t:1023,w:4.644391}; case 114: return {t:1023,w:4.644391}; case 115: return {t:1023,w:4.644391}; case 116: return {t:1023,w:4.644391}; case 117: return {t:1023,w:4.644391}; case 118: return {t:1023,w:4.644391}; case 119: return {t:1023,w:4.644391}; case 120: return {t:1023,w:4.644391}; case 121: return {t:1023,w:4.644391}; case 122: return {t:1023,w:4.644391}; case 268: return {t:886,w:0.693147}; case 331: return {t:892,w:0.693147};default: return {t:0,w:0.0};}};
case 1191: return function (act:Int) {switch (act) { case 46: return {t:1342,w:0.000000};default: return {t:0,w:0.0};}};
case 1192: return function (act:Int) {switch (act) { case 46: return {t:1048,w:0.693147}; case 258: return {t:1049,w:0.693147};default: return {t:0,w:0.0};}};
case 1193: return function (act:Int) {switch (act) { case 46: return {t:1343,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:1344,w:0.693147};default: return {t:0,w:0.0};}};
case 1194: return function (act:Int) {switch (act) { case 46: return {t:1051,w:0.000000};default: return {t:0,w:0.0};}};
case 1195: return function (act:Int) {switch (act) { case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 336: return {t:1345,w:0.000000};default: return {t:0,w:0.0};}};
case 1196: return function (act:Int) {switch (act) { case 258: return {t:1054,w:0.000000};default: return {t:0,w:0.0};}};
case 1197: return function (act:Int) {switch (act) { case 33: return {t:420,w:5.123964}; case 36: return {t:1346,w:4.990432}; case 37: return {t:422,w:3.044522}; case 38: return {t:1347,w:4.990432}; case 39: return {t:424,w:6.510258}; case 40: return {t:424,w:6.510258}; case 41: return {t:424,w:6.510258}; case 42: return {t:424,w:6.510258}; case 43: return {t:1348,w:4.990432}; case 45: return {t:426,w:5.817111}; case 46: return {t:426,w:5.817111}; case 47: return {t:1349,w:4.990432}; case 48: return {t:428,w:7.426548}; case 49: return {t:428,w:7.426548}; case 50: return {t:428,w:7.426548}; case 51: return {t:428,w:7.426548}; case 52: return {t:428,w:7.426548}; case 53: return {t:428,w:7.426548}; case 54: return {t:428,w:7.426548}; case 55: return {t:428,w:7.426548}; case 56: return {t:428,w:7.426548}; case 57: return {t:428,w:7.426548}; case 58: return {t:1350,w:4.990432}; case 65: return {t:432,w:8.382061}; case 66: return {t:432,w:8.382061}; case 67: return {t:432,w:8.382061}; case 68: return {t:432,w:8.382061}; case 69: return {t:432,w:8.382061}; case 70: return {t:432,w:8.382061}; case 71: return {t:432,w:8.382061}; case 72: return {t:432,w:8.382061}; case 73: return {t:432,w:8.382061}; case 74: return {t:432,w:8.382061}; case 75: return {t:432,w:8.382061}; case 76: return {t:1351,w:2.639057}; case 77: return {t:1352,w:2.639057}; case 78: return {t:432,w:8.382061}; case 79: return {t:432,w:8.382061}; case 80: return {t:432,w:8.382061}; case 81: return {t:432,w:8.382061}; case 82: return {t:432,w:8.382061}; case 83: return {t:432,w:8.382061}; case 84: return {t:1353,w:2.639057}; case 85: return {t:1354,w:2.639057}; case 86: return {t:432,w:8.382061}; case 87: return {t:432,w:8.382061}; case 88: return {t:432,w:8.382061}; case 89: return {t:432,w:8.382061}; case 90: return {t:432,w:8.382061}; case 91: return {t:1355,w:4.990432}; case 93: return {t:1356,w:4.990432}; case 95: return {t:433,w:5.123964}; case 97: return {t:434,w:8.382061}; case 98: return {t:434,w:8.382061}; case 99: return {t:434,w:8.382061}; case 100: return {t:434,w:8.382061}; case 101: return {t:434,w:8.382061}; case 102: return {t:434,w:8.382061}; case 103: return {t:434,w:8.382061}; case 104: return {t:434,w:8.382061}; case 105: return {t:434,w:8.382061}; case 106: return {t:434,w:8.382061}; case 107: return {t:434,w:8.382061}; case 108: return {t:1357,w:2.639057}; case 109: return {t:1358,w:2.639057}; case 110: return {t:434,w:8.382061}; case 111: return {t:434,w:8.382061}; case 112: return {t:434,w:8.382061}; case 113: return {t:434,w:8.382061}; case 114: return {t:434,w:8.382061}; case 115: return {t:434,w:8.382061}; case 116: return {t:1359,w:2.639057}; case 117: return {t:1360,w:2.639057}; case 118: return {t:434,w:8.382061}; case 119: return {t:434,w:8.382061}; case 120: return {t:434,w:8.382061}; case 121: return {t:434,w:8.382061}; case 122: return {t:434,w:8.382061}; case 126: return {t:435,w:5.123964}; case 363: return {t:1361,w:3.044522}; case 364: return {t:1362,w:3.044522}; case 463: return {t:1363,w:1.945910}; case 464: return {t:1364,w:1.945910}; case 465: return {t:1365,w:1.945910}; case 466: return {t:1366,w:1.945910}; case 467: return {t:1367,w:1.945910}; case 468: return {t:1368,w:1.945910}; case 469: return {t:1369,w:3.044522}; case 470: return {t:1370,w:1.945910}; case 471: return {t:1371,w:1.945910}; case 472: return {t:1372,w:1.945910};default: return {t:0,w:0.0};}};
case 1198: return function (act:Int) {switch (act) { case 59: return {t:1373,w:0.693147}; case 258: return {t:1374,w:0.693147};default: return {t:0,w:0.0};}};
case 1199: return function (act:Int) {switch (act) { case 256: return {t:1375,w:4000000.000000}; case 473: return {t:1376,w:0.000000};default: return {t:0,w:0.0};}};
case 1200: return function (act:Int) {switch (act) { case 333: return {t:1200,w:0.000000};default: return {t:0,w:0.0};}};
case 1201: return function (act:Int) {switch (act) { case 258: return {t:1200,w:0.000000};default: return {t:0,w:0.0};}};
case 1202: return function (act:Int) {switch (act) { case 258: return {t:1377,w:0.000000};default: return {t:0,w:0.0};}};
case 1203: return function (act:Int) {switch (act) { case 36: return {t:1378,w:2.995732}; case 38: return {t:1379,w:2.995732}; case 43: return {t:1380,w:2.995732}; case 44: return {t:1381,w:2.995732}; case 58: return {t:1382,w:2.995732}; case 59: return {t:1383,w:2.995732}; case 61: return {t:1384,w:2.995732}; case 64: return {t:1385,w:2.995732}; case 256: return {t:1386,w:4000003.000000}; case 258: return {t:1387,w:0.693147}; case 363: return {t:1388,w:2.995732}; case 364: return {t:1389,w:2.995732};default: return {t:0,w:0.0};}};
case 1204: return function (act:Int) {switch (act) { case 268: return {t:52,w:2.484906}; case 336: return {t:271,w:0.000000}; case 363: return {t:621,w:1.897120};default: return {t:0,w:0.0};}};
case 1205: return function (act:Int) {switch (act) { case 268: return {t:52,w:0.587786}; case 331: return {t:258,w:0.182322}; case 363: return {t:621,w:0.000000};default: return {t:0,w:0.0};}};
case 1206: return function (act:Int) {switch (act) { case 33: return {t:420,w:4.079442}; case 36: return {t:875,w:3.945910}; case 37: return {t:422,w:2.000000}; case 38: return {t:876,w:3.945910}; case 39: return {t:424,w:5.465736}; case 40: return {t:424,w:5.465736}; case 41: return {t:424,w:5.465736}; case 42: return {t:424,w:5.465736}; case 43: return {t:877,w:4.639057}; case 44: return {t:877,w:4.639057}; case 45: return {t:426,w:4.772589}; case 46: return {t:426,w:4.772589}; case 47: return {t:878,w:3.945910}; case 48: return {t:428,w:6.382027}; case 49: return {t:428,w:6.382027}; case 50: return {t:428,w:6.382027}; case 51: return {t:428,w:6.382027}; case 52: return {t:428,w:6.382027}; case 53: return {t:428,w:6.382027}; case 54: return {t:428,w:6.382027}; case 55: return {t:428,w:6.382027}; case 56: return {t:428,w:6.382027}; case 57: return {t:428,w:6.382027}; case 59: return {t:880,w:3.945910}; case 61: return {t:881,w:3.945910}; case 63: return {t:882,w:3.945910}; case 65: return {t:432,w:7.337539}; case 66: return {t:432,w:7.337539}; case 67: return {t:432,w:7.337539}; case 68: return {t:432,w:7.337539}; case 69: return {t:432,w:7.337539}; case 70: return {t:432,w:7.337539}; case 71: return {t:432,w:7.337539}; case 72: return {t:432,w:7.337539}; case 73: return {t:432,w:7.337539}; case 74: return {t:432,w:7.337539}; case 75: return {t:432,w:7.337539}; case 76: return {t:432,w:7.337539}; case 77: return {t:432,w:7.337539}; case 78: return {t:432,w:7.337539}; case 79: return {t:432,w:7.337539}; case 80: return {t:432,w:7.337539}; case 81: return {t:432,w:7.337539}; case 82: return {t:432,w:7.337539}; case 83: return {t:432,w:7.337539}; case 84: return {t:432,w:7.337539}; case 85: return {t:432,w:7.337539}; case 86: return {t:432,w:7.337539}; case 87: return {t:432,w:7.337539}; case 88: return {t:432,w:7.337539}; case 89: return {t:432,w:7.337539}; case 90: return {t:432,w:7.337539}; case 95: return {t:433,w:4.079442}; case 97: return {t:434,w:7.337539}; case 98: return {t:434,w:7.337539}; case 99: return {t:434,w:7.337539}; case 100: return {t:434,w:7.337539}; case 101: return {t:434,w:7.337539}; case 102: return {t:434,w:7.337539}; case 103: return {t:434,w:7.337539}; case 104: return {t:434,w:7.337539}; case 105: return {t:434,w:7.337539}; case 106: return {t:434,w:7.337539}; case 107: return {t:434,w:7.337539}; case 108: return {t:434,w:7.337539}; case 109: return {t:434,w:7.337539}; case 110: return {t:434,w:7.337539}; case 111: return {t:434,w:7.337539}; case 112: return {t:434,w:7.337539}; case 113: return {t:434,w:7.337539}; case 114: return {t:434,w:7.337539}; case 115: return {t:434,w:7.337539}; case 116: return {t:434,w:7.337539}; case 117: return {t:434,w:7.337539}; case 118: return {t:434,w:7.337539}; case 119: return {t:434,w:7.337539}; case 120: return {t:434,w:7.337539}; case 121: return {t:434,w:7.337539}; case 122: return {t:434,w:7.337539}; case 126: return {t:435,w:4.079442}; case 258: return {t:1377,w:0.000000};default: return {t:0,w:0.0};}};
case 1207: return function (act:Int) {switch (act) { case 256: return {t:899,w:4000000.000000}; case 394: return {t:1390,w:0.000000};default: return {t:0,w:0.0};}};
case 1208: return function (act:Int) {switch (act) { case 431: return {t:1208,w:0.000000};default: return {t:0,w:0.0};}};
case 1209: return function (act:Int) {switch (act) { case 417: return {t:1209,w:0.000000};default: return {t:0,w:0.0};}};
case 1210: return function (act:Int) {switch (act) { case 256: return {t:780,w:4000000.000000}; case 395: return {t:781,w:0.000000};default: return {t:0,w:0.0};}};
case 1211: return function (act:Int) {switch (act) { case 433: return {t:1211,w:0.000000};default: return {t:0,w:0.0};}};
case 1212: return function (act:Int) {switch (act) { case 256: return {t:1086,w:4000000.750000}; case 258: return {t:1391,w:0.693147}; case 418: return {t:1392,w:0.693147};default: return {t:0,w:0.0};}};
case 1213: return function (act:Int) {switch (act) { case 256: return {t:1083,w:4000000.000000}; case 433: return {t:1393,w:0.000000};default: return {t:0,w:0.0};}};
case 1214: return function (act:Int) {switch (act) { case 59: return {t:1085,w:0.693147}; case 258: return {t:1087,w:0.693147};default: return {t:0,w:0.0};}};
case 1215: return function (act:Int) {switch (act) { case 33: return {t:420,w:4.969814}; case 36: return {t:906,w:2.890372}; case 37: return {t:422,w:2.890372}; case 38: return {t:907,w:2.890372}; case 39: return {t:424,w:6.356108}; case 40: return {t:424,w:6.356108}; case 41: return {t:424,w:6.356108}; case 42: return {t:424,w:6.356108}; case 43: return {t:908,w:2.890372}; case 44: return {t:909,w:2.890372}; case 45: return {t:426,w:5.662961}; case 46: return {t:426,w:5.662961}; case 48: return {t:428,w:7.272399}; case 49: return {t:428,w:7.272399}; case 50: return {t:428,w:7.272399}; case 51: return {t:428,w:7.272399}; case 52: return {t:428,w:7.272399}; case 53: return {t:428,w:7.272399}; case 54: return {t:428,w:7.272399}; case 55: return {t:428,w:7.272399}; case 56: return {t:428,w:7.272399}; case 57: return {t:428,w:7.272399}; case 58: return {t:910,w:2.890372}; case 59: return {t:911,w:1.386294}; case 61: return {t:912,w:2.890372}; case 64: return {t:913,w:2.890372}; case 65: return {t:432,w:8.227911}; case 66: return {t:432,w:8.227911}; case 67: return {t:432,w:8.227911}; case 68: return {t:432,w:8.227911}; case 69: return {t:432,w:8.227911}; case 70: return {t:432,w:8.227911}; case 71: return {t:432,w:8.227911}; case 72: return {t:432,w:8.227911}; case 73: return {t:432,w:8.227911}; case 74: return {t:432,w:8.227911}; case 75: return {t:432,w:8.227911}; case 76: return {t:432,w:8.227911}; case 77: return {t:432,w:8.227911}; case 78: return {t:432,w:8.227911}; case 79: return {t:432,w:8.227911}; case 80: return {t:432,w:8.227911}; case 81: return {t:432,w:8.227911}; case 82: return {t:432,w:8.227911}; case 83: return {t:432,w:8.227911}; case 84: return {t:432,w:8.227911}; case 85: return {t:432,w:8.227911}; case 86: return {t:432,w:8.227911}; case 87: return {t:432,w:8.227911}; case 88: return {t:432,w:8.227911}; case 89: return {t:432,w:8.227911}; case 90: return {t:432,w:8.227911}; case 95: return {t:433,w:4.969814}; case 97: return {t:434,w:8.227911}; case 98: return {t:434,w:8.227911}; case 99: return {t:434,w:8.227911}; case 100: return {t:434,w:8.227911}; case 101: return {t:434,w:8.227911}; case 102: return {t:434,w:8.227911}; case 103: return {t:434,w:8.227911}; case 104: return {t:434,w:8.227911}; case 105: return {t:434,w:8.227911}; case 106: return {t:434,w:8.227911}; case 107: return {t:434,w:8.227911}; case 108: return {t:434,w:8.227911}; case 109: return {t:434,w:8.227911}; case 110: return {t:434,w:8.227911}; case 111: return {t:434,w:8.227911}; case 112: return {t:434,w:8.227911}; case 113: return {t:434,w:8.227911}; case 114: return {t:434,w:8.227911}; case 115: return {t:434,w:8.227911}; case 116: return {t:434,w:8.227911}; case 117: return {t:434,w:8.227911}; case 118: return {t:434,w:8.227911}; case 119: return {t:434,w:8.227911}; case 120: return {t:434,w:8.227911}; case 121: return {t:434,w:8.227911}; case 122: return {t:434,w:8.227911}; case 126: return {t:435,w:4.969814}; case 258: return {t:914,w:1.386294}; case 363: return {t:915,w:2.890372}; case 364: return {t:916,w:2.890372}; case 418: return {t:917,w:0.693147};default: return {t:0,w:0.0};}};
case 1216: return function (act:Int) {switch (act) { case 47: return {t:1089,w:0.693147}; case 258: return {t:1090,w:0.693147};default: return {t:0,w:0.0};}};
case 1217: return function (act:Int) {switch (act) { case 420: return {t:1217,w:0.000000};default: return {t:0,w:0.0};}};
case 1218: return function (act:Int) {switch (act) { case 256: return {t:784,w:4000000.750000}; case 258: return {t:1217,w:0.693147}; case 396: return {t:1218,w:0.693147};default: return {t:0,w:0.0};}};
case 1219: return function (act:Int) {switch (act) { case 258: return {t:791,w:0.000000};default: return {t:0,w:0.0};}};
case 1220: return function (act:Int) {switch (act) { case 67: return {t:1394,w:0.693147}; case 99: return {t:1394,w:0.693147};default: return {t:0,w:0.0};}};
case 1221: return function (act:Int) {switch (act) { case 78: return {t:1395,w:0.693147}; case 110: return {t:1395,w:0.693147};default: return {t:0,w:0.0};}};
case 1222: return function (act:Int) {switch (act) { case 33: return {t:39,w:7.973843}; case 37: return {t:40,w:7.973843}; case 39: return {t:41,w:7.973843}; case 42: return {t:42,w:7.973843}; case 43: return {t:43,w:7.973843}; case 45: return {t:44,w:7.973843}; case 46: return {t:45,w:7.973843}; case 47: return {t:1396,w:0.000000}; case 95: return {t:46,w:7.973843}; case 96: return {t:47,w:7.973843}; case 126: return {t:48,w:7.973843}; case 256: return {t:49,w:4000008.250000}; case 258: return {t:50,w:5.575948}; case 268: return {t:51,w:7.973843};default: return {t:0,w:0.0};}};
case 1223: return function (act:Int) {switch (act) { case 256: return {t:665,w:4000000.000000}; case 391: return {t:1397,w:0.000000};default: return {t:0,w:0.0};}};
case 1224: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1398,w:0.693147}; case 384: return {t:1399,w:0.693147};default: return {t:0,w:0.0};}};
case 1225: return function (act:Int) {switch (act) { case 256: return {t:1098,w:4000000.000000}; case 434: return {t:1400,w:0.000000};default: return {t:0,w:0.0};}};
case 1226: return function (act:Int) {switch (act) { case 79: return {t:1401,w:0.693147}; case 111: return {t:1401,w:0.693147};default: return {t:0,w:0.0};}};
case 1227: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:934,w:0.693147}; case 375: return {t:1102,w:0.693147};default: return {t:0,w:0.0};}};
case 1228: return function (act:Int) {switch (act) { case 65: return {t:1402,w:0.693147}; case 97: return {t:1402,w:0.693147};default: return {t:0,w:0.0};}};
case 1229: return function (act:Int) {switch (act) { case 84: return {t:1403,w:0.693147}; case 116: return {t:1403,w:0.693147};default: return {t:0,w:0.0};}};
case 1230: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1404,w:0.000000};default: return {t:0,w:0.0};}};
case 1231: return function (act:Int) {switch (act) { case 73: return {t:1405,w:0.693147}; case 105: return {t:1405,w:0.693147};default: return {t:0,w:0.0};}};
case 1232: return function (act:Int) {switch (act) { case 78: return {t:1406,w:0.693147}; case 110: return {t:1406,w:0.693147};default: return {t:0,w:0.0};}};
case 1233: return function (act:Int) {switch (act) { case 65: return {t:1407,w:0.693147}; case 69: return {t:1408,w:1.386294}; case 97: return {t:1407,w:0.693147}; case 101: return {t:1408,w:1.386294};default: return {t:0,w:0.0};}};
case 1234: return function (act:Int) {switch (act) { case 89: return {t:1409,w:0.693147}; case 121: return {t:1409,w:0.693147};default: return {t:0,w:0.0};}};
case 1235: return function (act:Int) {switch (act) { case 299: return {t:1235,w:0.000000};default: return {t:0,w:0.0};}};
case 1236: return function (act:Int) {switch (act) { case 65: return {t:1410,w:0.693147}; case 97: return {t:1410,w:0.693147};default: return {t:0,w:0.0};}};
case 1237: return function (act:Int) {switch (act) { case 69: return {t:1411,w:0.693147}; case 101: return {t:1411,w:0.693147};default: return {t:0,w:0.0};}};
case 1238: return function (act:Int) {switch (act) { case 65: return {t:1412,w:0.693147}; case 97: return {t:1412,w:0.693147};default: return {t:0,w:0.0};}};
case 1239: return function (act:Int) {switch (act) { case 391: return {t:1239,w:0.000000};default: return {t:0,w:0.0};}};
case 1240: return function (act:Int) {switch (act) { case 421: return {t:1240,w:0.000000};default: return {t:0,w:0.0};}};
case 1241: return function (act:Int) {switch (act) { case 258: return {t:1413,w:0.000000};default: return {t:0,w:0.0};}};
case 1242: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:1414,w:0.000000};default: return {t:0,w:0.0};}};
case 1243: return function (act:Int) {switch (act) { case 258: return {t:1415,w:0.000000};default: return {t:0,w:0.0};}};
case 1244: return function (act:Int) {switch (act) { case 258: return {t:1415,w:0.000000};default: return {t:0,w:0.0};}};
case 1245: return function (act:Int) {switch (act) { case 258: return {t:1415,w:0.000000};default: return {t:0,w:0.0};}};
case 1246: return function (act:Int) {switch (act) { case 258: return {t:1415,w:0.000000};default: return {t:0,w:0.0};}};
case 1247: return function (act:Int) {switch (act) { case 258: return {t:1415,w:0.000000};default: return {t:0,w:0.0};}};
case 1248: return function (act:Int) {switch (act) { case 258: return {t:1415,w:0.000000};default: return {t:0,w:0.0};}};
case 1249: return function (act:Int) {switch (act) { case 258: return {t:1415,w:0.000000};default: return {t:0,w:0.0};}};
case 1250: return function (act:Int) {switch (act) { case 256: return {t:1416,w:4000000.000000}; case 474: return {t:1417,w:0.000000};default: return {t:0,w:0.0};}};
case 1251: return function (act:Int) {switch (act) { case 79: return {t:1418,w:0.693147}; case 111: return {t:1418,w:0.693147};default: return {t:0,w:0.0};}};
case 1252: return function (act:Int) {switch (act) { case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 336: return {t:1419,w:0.000000};default: return {t:0,w:0.0};}};
case 1253: return function (act:Int) {switch (act) { case 258: return {t:1420,w:0.000000};default: return {t:0,w:0.0};}};
case 1254: return function (act:Int) {switch (act) { case 400: return {t:1254,w:0.000000};default: return {t:0,w:0.0};}};
case 1255: return function (act:Int) {switch (act) { case 401: return {t:1255,w:0.000000};default: return {t:0,w:0.0};}};
case 1256: return function (act:Int) {switch (act) { case 84: return {t:1421,w:0.693147}; case 116: return {t:1421,w:0.693147};default: return {t:0,w:0.0};}};
case 1257: return function (act:Int) {switch (act) { case 82: return {t:1422,w:0.693147}; case 114: return {t:1422,w:0.693147};default: return {t:0,w:0.0};}};
case 1258: return function (act:Int) {switch (act) { case 73: return {t:1423,w:0.693147}; case 105: return {t:1423,w:0.693147};default: return {t:0,w:0.0};}};
case 1259: return function (act:Int) {switch (act) { case 69: return {t:1424,w:0.693147}; case 101: return {t:1424,w:0.693147};default: return {t:0,w:0.0};}};
case 1260: return function (act:Int) {switch (act) { case 73: return {t:1425,w:0.693147}; case 105: return {t:1425,w:0.693147};default: return {t:0,w:0.0};}};
case 1261: return function (act:Int) {switch (act) { case 48: return {t:1426,w:0.693147}; case 49: return {t:1427,w:0.693147};default: return {t:0,w:0.0};}};
case 1262: return function (act:Int) {switch (act) { case 258: return {t:1428,w:0.000000};default: return {t:0,w:0.0};}};
case 1263: return function (act:Int) {switch (act) { case 73: return {t:1429,w:0.693147}; case 105: return {t:1429,w:0.693147};default: return {t:0,w:0.0};}};
case 1264: return function (act:Int) {switch (act) { case 256: return {t:1430,w:4000000.000000}; case 475: return {t:1431,w:0.000000};default: return {t:0,w:0.0};}};
case 1265: return function (act:Int) {switch (act) { case 72: return {t:1432,w:0.693147}; case 104: return {t:1432,w:0.693147};default: return {t:0,w:0.0};}};
case 1266: return function (act:Int) {switch (act) { case 85: return {t:1433,w:0.693147}; case 117: return {t:1433,w:0.693147};default: return {t:0,w:0.0};}};
case 1267: return function (act:Int) {switch (act) { case 85: return {t:1434,w:0.693147}; case 117: return {t:1434,w:0.693147};default: return {t:0,w:0.0};}};
case 1268: return function (act:Int) {switch (act) { case 256: return {t:1435,w:4000000.000000}; case 476: return {t:1436,w:0.000000};default: return {t:0,w:0.0};}};
case 1269: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1437,w:0.693147}; case 375: return {t:1438,w:0.693147};default: return {t:0,w:0.0};}};
case 1270: return function (act:Int) {switch (act) { case 69: return {t:1439,w:0.693147}; case 101: return {t:1439,w:0.693147};default: return {t:0,w:0.0};}};
case 1271: return function (act:Int) {switch (act) { case 427: return {t:1271,w:0.000000};default: return {t:0,w:0.0};}};
case 1272: return function (act:Int) {switch (act) { case 256: return {t:1440,w:4000000.000000}; case 477: return {t:1441,w:0.000000};default: return {t:0,w:0.0};}};
case 1273: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1154,w:0.693147}; case 375: return {t:1155,w:0.693147};default: return {t:0,w:0.0};}};
case 1274: return function (act:Int) {switch (act) { case 256: return {t:665,w:4000000.750000}; case 258: return {t:1442,w:0.693147}; case 391: return {t:1443,w:0.693147};default: return {t:0,w:0.0};}};
case 1275: return function (act:Int) {switch (act) { case 40: return {t:1444,w:0.000000};default: return {t:0,w:0.0};}};
case 1276: return function (act:Int) {switch (act) { case 256: return {t:1445,w:4000000.750000}; case 400: return {t:1446,w:1.791759}; case 454: return {t:1448,w:1.791759}; case 478: return {t:1447,w:1.791759}; case 479: return {t:1449,w:0.693147};default: return {t:0,w:0.0};}};
case 1277: return function (act:Int) {switch (act) { case 258: return {t:1450,w:0.000000};default: return {t:0,w:0.0};}};
case 1278: return function (act:Int) {switch (act) { case 258: return {t:1450,w:0.000000};default: return {t:0,w:0.0};}};
case 1279: return function (act:Int) {switch (act) { case 318: return {t:1279,w:0.000000};default: return {t:0,w:0.0};}};
case 1280: return function (act:Int) {switch (act) { case 256: return {t:1156,w:4000000.000000}; case 436: return {t:1451,w:0.000000};default: return {t:0,w:0.0};}};
case 1281: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:222,w:0.000000};default: return {t:0,w:0.0};}};
case 1282: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1452,w:0.000000};default: return {t:0,w:0.0};}};
case 1283: return function (act:Int) {switch (act) { case 256: return {t:812,w:4000000.000000}; case 269: return {t:1453,w:0.000000};default: return {t:0,w:0.0};}};
case 1284: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:1454,w:0.000000};default: return {t:0,w:0.0};}};
case 1285: return function (act:Int) {switch (act) { case 258: return {t:1455,w:0.000000};default: return {t:0,w:0.0};}};
case 1286: return function (act:Int) {switch (act) { case 258: return {t:1456,w:0.000000};default: return {t:0,w:0.0};}};
case 1287: return function (act:Int) {switch (act) { case 258: return {t:1456,w:0.000000};default: return {t:0,w:0.0};}};
case 1288: return function (act:Int) {switch (act) { case 33: return {t:39,w:3.091042}; case 37: return {t:40,w:3.091042}; case 39: return {t:41,w:3.091042}; case 42: return {t:42,w:3.091042}; case 43: return {t:43,w:3.091042}; case 45: return {t:1457,w:1.473305}; case 46: return {t:45,w:3.091042}; case 95: return {t:46,w:3.091042}; case 96: return {t:47,w:3.091042}; case 126: return {t:48,w:3.091042}; case 256: return {t:49,w:4000000.750000}; case 258: return {t:1458,w:0.087011}; case 268: return {t:1459,w:0.780158};default: return {t:0,w:0.0};}};
case 1289: return function (act:Int) {switch (act) { case 258: return {t:1460,w:0.000000};default: return {t:0,w:0.0};}};
case 1290: return function (act:Int) {switch (act) { case 258: return {t:1460,w:0.000000};default: return {t:0,w:0.0};}};
case 1291: return function (act:Int) {switch (act) { case 256: return {t:687,w:4000000.000000}; case 381: return {t:688,w:0.000000};default: return {t:0,w:0.0};}};
case 1292: return function (act:Int) {switch (act) { case 258: return {t:1460,w:0.000000};default: return {t:0,w:0.0};}};
case 1293: return function (act:Int) {switch (act) { case 69: return {t:1461,w:0.693147}; case 101: return {t:1461,w:0.693147};default: return {t:0,w:0.0};}};
case 1294: return function (act:Int) {switch (act) { case 84: return {t:1462,w:0.693147}; case 116: return {t:1462,w:0.693147};default: return {t:0,w:0.0};}};
case 1295: return function (act:Int) {switch (act) { case 67: return {t:1463,w:0.693147}; case 99: return {t:1463,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1296: return function (act:Int) {switch (act) { case 67: return {t:1464,w:0.693147}; case 76: return {t:1465,w:0.693147}; case 99: return {t:1464,w:0.693147}; case 108: return {t:1465,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1297: return function (act:Int) {switch (act) { case 68: return {t:1466,w:0.693147}; case 100: return {t:1466,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1298: return function (act:Int) {switch (act) { case 67: return {t:1463,w:0.693147}; case 99: return {t:1463,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1299: return function (act:Int) {switch (act) { case 67: return {t:1464,w:0.693147}; case 76: return {t:1465,w:0.693147}; case 99: return {t:1464,w:0.693147}; case 108: return {t:1465,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1300: return function (act:Int) {switch (act) { case 68: return {t:1466,w:0.693147}; case 100: return {t:1466,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1301: return function (act:Int) {switch (act) { case 258: return {t:1467,w:0.000000};default: return {t:0,w:0.0};}};
case 1302: return function (act:Int) {switch (act) { case 258: return {t:1468,w:0.000000};default: return {t:0,w:0.0};}};
case 1303: return function (act:Int) {switch (act) { case 386: return {t:1303,w:0.000000};default: return {t:0,w:0.0};}};
case 1304: return function (act:Int) {switch (act) { case 58: return {t:1469,w:0.000000};default: return {t:0,w:0.0};}};
case 1305: return function (act:Int) {switch (act) { case 258: return {t:1173,w:0.000000};default: return {t:0,w:0.0};}};
case 1306: return function (act:Int) {switch (act) { case 82: return {t:1470,w:0.693147}; case 114: return {t:1470,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1307: return function (act:Int) {switch (act) { case 65: return {t:1471,w:0.693147}; case 97: return {t:1471,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1308: return function (act:Int) {switch (act) { case 69: return {t:1472,w:0.693147}; case 101: return {t:1472,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1309: return function (act:Int) {switch (act) { case 84: return {t:1473,w:0.693147}; case 116: return {t:1473,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1310: return function (act:Int) {switch (act) { case 82: return {t:1470,w:0.693147}; case 114: return {t:1470,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1311: return function (act:Int) {switch (act) { case 65: return {t:1471,w:0.693147}; case 97: return {t:1471,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1312: return function (act:Int) {switch (act) { case 69: return {t:1472,w:0.693147}; case 101: return {t:1472,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1313: return function (act:Int) {switch (act) { case 84: return {t:1473,w:0.693147}; case 116: return {t:1473,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1314: return function (act:Int) {switch (act) { case 258: return {t:1474,w:0.000000};default: return {t:0,w:0.0};}};
case 1315: return function (act:Int) {switch (act) { case 258: return {t:1475,w:0.000000};default: return {t:0,w:0.0};}};
case 1316: return function (act:Int) {switch (act) { case 258: return {t:1475,w:0.000000};default: return {t:0,w:0.0};}};
case 1317: return function (act:Int) {switch (act) { case 258: return {t:1475,w:0.000000};default: return {t:0,w:0.0};}};
case 1318: return function (act:Int) {switch (act) { case 258: return {t:1475,w:0.000000};default: return {t:0,w:0.0};}};
case 1319: return function (act:Int) {switch (act) { case 258: return {t:1475,w:0.000000};default: return {t:0,w:0.0};}};
case 1320: return function (act:Int) {switch (act) { case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 336: return {t:1476,w:0.000000}; case 480: return {t:1477,w:0.000000};default: return {t:0,w:0.0};}};
case 1321: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1478,w:0.693147}; case 375: return {t:1479,w:0.693147};default: return {t:0,w:0.0};}};
case 1322: return function (act:Int) {switch (act) { case 78: return {t:1480,w:0.693147}; case 110: return {t:1480,w:0.693147};default: return {t:0,w:0.0};}};
case 1323: return function (act:Int) {switch (act) { case 256: return {t:1481,w:4000000.750000}; case 258: return {t:1329,w:0.693147}; case 442: return {t:1482,w:0.693147};default: return {t:0,w:0.0};}};
case 1324: return function (act:Int) {switch (act) { case 441: return {t:1324,w:0.000000};default: return {t:0,w:0.0};}};
case 1325: return function (act:Int) {switch (act) { case 256: return {t:623,w:4000000.750000}; case 258: return {t:1324,w:0.693147}; case 390: return {t:1483,w:0.693147};default: return {t:0,w:0.0};}};
case 1326: return function (act:Int) {switch (act) { case 256: return {t:1484,w:4000000.000000}; case 441: return {t:1485,w:0.000000};default: return {t:0,w:0.0};}};
case 1327: return function (act:Int) {switch (act) { case 442: return {t:1327,w:0.000000};default: return {t:0,w:0.0};}};
case 1328: return function (act:Int) {switch (act) { case 58: return {t:1486,w:0.000000};default: return {t:0,w:0.0};}};
case 1329: return function (act:Int) {switch (act) { case 443: return {t:1329,w:0.000000};default: return {t:0,w:0.0};}};
case 1330: return function (act:Int) {switch (act) { case 256: return {t:1487,w:4000000.000000}; case 413: return {t:1488,w:0.000000};default: return {t:0,w:0.0};}};
case 1331: return function (act:Int) {switch (act) { case 429: return {t:1331,w:0.000000};default: return {t:0,w:0.0};}};
case 1332: return function (act:Int) {switch (act) { case 414: return {t:1332,w:0.000000};default: return {t:0,w:0.0};}};
case 1333: return function (act:Int) {switch (act) { case 444: return {t:1333,w:0.000000};default: return {t:0,w:0.0};}};
case 1334: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1335: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1336: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1337: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1338: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1339: return function (act:Int) {switch (act) { case 445: return {t:1339,w:0.000000};default: return {t:0,w:0.0};}};
case 1340: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1341: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1342: return function (act:Int) {switch (act) { case 256: return {t:1190,w:4000000.750000}; case 410: return {t:1191,w:0.693147}; case 411: return {t:1192,w:0.693147};default: return {t:0,w:0.0};}};
case 1343: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1497,w:0.000000};default: return {t:0,w:0.0};}};
case 1344: return function (act:Int) {switch (act) { case 46: return {t:1343,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:1498,w:0.693147};default: return {t:0,w:0.0};}};
case 1345: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1499,w:0.693147}; case 336: return {t:1500,w:0.693147};default: return {t:0,w:0.0};}};
case 1346: return function (act:Int) {switch (act) { case 258: return {t:1501,w:0.000000};default: return {t:0,w:0.0};}};
case 1347: return function (act:Int) {switch (act) { case 258: return {t:1501,w:0.000000};default: return {t:0,w:0.0};}};
case 1348: return function (act:Int) {switch (act) { case 258: return {t:1501,w:0.000000};default: return {t:0,w:0.0};}};
case 1349: return function (act:Int) {switch (act) { case 258: return {t:1501,w:0.000000};default: return {t:0,w:0.0};}};
case 1350: return function (act:Int) {switch (act) { case 258: return {t:1501,w:0.000000};default: return {t:0,w:0.0};}};
case 1351: return function (act:Int) {switch (act) { case 82: return {t:1502,w:0.693147}; case 114: return {t:1502,w:0.693147}; case 258: return {t:621,w:5.743004};default: return {t:0,w:0.0};}};
case 1352: return function (act:Int) {switch (act) { case 65: return {t:1503,w:0.693147}; case 69: return {t:1504,w:0.693147}; case 97: return {t:1503,w:0.693147}; case 101: return {t:1504,w:0.693147}; case 258: return {t:621,w:5.743004};default: return {t:0,w:0.0};}};
case 1353: return function (act:Int) {switch (act) { case 82: return {t:1505,w:0.693147}; case 84: return {t:1506,w:0.693147}; case 114: return {t:1505,w:0.693147}; case 116: return {t:1506,w:0.693147}; case 258: return {t:621,w:5.743004};default: return {t:0,w:0.0};}};
case 1354: return function (act:Int) {switch (act) { case 83: return {t:1507,w:0.693147}; case 115: return {t:1507,w:0.693147}; case 258: return {t:621,w:5.743004};default: return {t:0,w:0.0};}};
case 1355: return function (act:Int) {switch (act) { case 258: return {t:1501,w:0.000000};default: return {t:0,w:0.0};}};
case 1356: return function (act:Int) {switch (act) { case 258: return {t:1501,w:0.000000};default: return {t:0,w:0.0};}};
case 1357: return function (act:Int) {switch (act) { case 82: return {t:1502,w:0.693147}; case 114: return {t:1502,w:0.693147}; case 258: return {t:621,w:5.743004};default: return {t:0,w:0.0};}};
case 1358: return function (act:Int) {switch (act) { case 65: return {t:1503,w:0.693147}; case 69: return {t:1504,w:0.693147}; case 97: return {t:1503,w:0.693147}; case 101: return {t:1504,w:0.693147}; case 258: return {t:621,w:5.743004};default: return {t:0,w:0.0};}};
case 1359: return function (act:Int) {switch (act) { case 82: return {t:1505,w:0.693147}; case 84: return {t:1506,w:0.693147}; case 114: return {t:1505,w:0.693147}; case 116: return {t:1506,w:0.693147}; case 258: return {t:621,w:5.743004};default: return {t:0,w:0.0};}};
case 1360: return function (act:Int) {switch (act) { case 83: return {t:1507,w:0.693147}; case 115: return {t:1507,w:0.693147}; case 258: return {t:621,w:5.743004};default: return {t:0,w:0.0};}};
case 1361: return function (act:Int) {switch (act) { case 258: return {t:1508,w:0.000000};default: return {t:0,w:0.0};}};
case 1362: return function (act:Int) {switch (act) { case 258: return {t:1508,w:0.000000};default: return {t:0,w:0.0};}};
case 1363: return function (act:Int) {switch (act) { case 258: return {t:1509,w:0.000000};default: return {t:0,w:0.0};}};
case 1364: return function (act:Int) {switch (act) { case 258: return {t:1509,w:0.000000};default: return {t:0,w:0.0};}};
case 1365: return function (act:Int) {switch (act) { case 258: return {t:1509,w:0.000000};default: return {t:0,w:0.0};}};
case 1366: return function (act:Int) {switch (act) { case 258: return {t:1509,w:0.000000};default: return {t:0,w:0.0};}};
case 1367: return function (act:Int) {switch (act) { case 258: return {t:1509,w:0.000000};default: return {t:0,w:0.0};}};
case 1368: return function (act:Int) {switch (act) { case 258: return {t:1509,w:0.000000};default: return {t:0,w:0.0};}};
case 1369: return function (act:Int) {switch (act) { case 258: return {t:1508,w:0.000000};default: return {t:0,w:0.0};}};
case 1370: return function (act:Int) {switch (act) { case 256: return {t:1510,w:4000000.750000}; case 258: return {t:1511,w:0.693147}; case 470: return {t:1512,w:0.693147};default: return {t:0,w:0.0};}};
case 1371: return function (act:Int) {switch (act) { case 61: return {t:1513,w:0.693147}; case 258: return {t:1514,w:0.693147};default: return {t:0,w:0.0};}};
case 1372: return function (act:Int) {switch (act) { case 258: return {t:1509,w:0.000000};default: return {t:0,w:0.0};}};
case 1373: return function (act:Int) {switch (act) { case 256: return {t:1197,w:4000000.000000}; case 447: return {t:1515,w:0.000000};default: return {t:0,w:0.0};}};
case 1374: return function (act:Int) {switch (act) { case 416: return {t:1374,w:0.000000};default: return {t:0,w:0.0};}};
case 1375: return function (act:Int) {switch (act) { case 33: return {t:420,w:3.178054}; case 36: return {t:1516,w:3.044522}; case 37: return {t:422,w:1.098612}; case 39: return {t:424,w:4.564348}; case 40: return {t:424,w:4.564348}; case 41: return {t:424,w:4.564348}; case 42: return {t:424,w:4.564348}; case 43: return {t:1517,w:3.044522}; case 45: return {t:426,w:3.871201}; case 46: return {t:426,w:3.871201}; case 47: return {t:1518,w:3.044522}; case 48: return {t:428,w:5.480639}; case 49: return {t:428,w:5.480639}; case 50: return {t:428,w:5.480639}; case 51: return {t:428,w:5.480639}; case 52: return {t:428,w:5.480639}; case 53: return {t:428,w:5.480639}; case 54: return {t:428,w:5.480639}; case 55: return {t:428,w:5.480639}; case 56: return {t:428,w:5.480639}; case 57: return {t:428,w:5.480639}; case 58: return {t:1519,w:3.044522}; case 63: return {t:1520,w:3.044522}; case 65: return {t:432,w:6.436151}; case 66: return {t:432,w:6.436151}; case 67: return {t:432,w:6.436151}; case 68: return {t:432,w:6.436151}; case 69: return {t:432,w:6.436151}; case 70: return {t:432,w:6.436151}; case 71: return {t:432,w:6.436151}; case 72: return {t:432,w:6.436151}; case 73: return {t:432,w:6.436151}; case 74: return {t:432,w:6.436151}; case 75: return {t:432,w:6.436151}; case 76: return {t:432,w:6.436151}; case 77: return {t:432,w:6.436151}; case 78: return {t:432,w:6.436151}; case 79: return {t:432,w:6.436151}; case 80: return {t:432,w:6.436151}; case 81: return {t:432,w:6.436151}; case 82: return {t:432,w:6.436151}; case 83: return {t:432,w:6.436151}; case 84: return {t:432,w:6.436151}; case 85: return {t:432,w:6.436151}; case 86: return {t:432,w:6.436151}; case 87: return {t:432,w:6.436151}; case 88: return {t:432,w:6.436151}; case 89: return {t:432,w:6.436151}; case 90: return {t:432,w:6.436151}; case 91: return {t:1521,w:3.044522}; case 93: return {t:1522,w:3.044522}; case 95: return {t:433,w:3.178054}; case 97: return {t:434,w:6.436151}; case 98: return {t:434,w:6.436151}; case 99: return {t:434,w:6.436151}; case 100: return {t:434,w:6.436151}; case 101: return {t:434,w:6.436151}; case 102: return {t:434,w:6.436151}; case 103: return {t:434,w:6.436151}; case 104: return {t:434,w:6.436151}; case 105: return {t:434,w:6.436151}; case 106: return {t:434,w:6.436151}; case 107: return {t:434,w:6.436151}; case 108: return {t:434,w:6.436151}; case 109: return {t:434,w:6.436151}; case 110: return {t:434,w:6.436151}; case 111: return {t:434,w:6.436151}; case 112: return {t:434,w:6.436151}; case 113: return {t:434,w:6.436151}; case 114: return {t:434,w:6.436151}; case 115: return {t:434,w:6.436151}; case 116: return {t:434,w:6.436151}; case 117: return {t:434,w:6.436151}; case 118: return {t:434,w:6.436151}; case 119: return {t:434,w:6.436151}; case 120: return {t:434,w:6.436151}; case 121: return {t:434,w:6.436151}; case 122: return {t:434,w:6.436151}; case 126: return {t:435,w:3.178054}; case 363: return {t:1523,w:1.098612}; case 364: return {t:1524,w:1.098612}; case 481: return {t:1525,w:1.098612}; case 482: return {t:1526,w:0.000000};default: return {t:0,w:0.0};}};
case 1376: return function (act:Int) {switch (act) { case 38: return {t:1527,w:0.693147}; case 258: return {t:1528,w:0.693147};default: return {t:0,w:0.0};}};
case 1377: return function (act:Int) {switch (act) { case 448: return {t:1377,w:0.000000};default: return {t:0,w:0.0};}};
case 1378: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1379: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1380: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1381: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1382: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1383: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1384: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1385: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1386: return function (act:Int) {switch (act) { case 33: return {t:420,w:2.079442}; case 37: return {t:422,w:0.000000}; case 39: return {t:424,w:3.465736}; case 40: return {t:424,w:3.465736}; case 41: return {t:424,w:3.465736}; case 42: return {t:424,w:3.465736}; case 45: return {t:426,w:2.772589}; case 46: return {t:426,w:2.772589}; case 48: return {t:428,w:4.382027}; case 49: return {t:428,w:4.382027}; case 50: return {t:428,w:4.382027}; case 51: return {t:428,w:4.382027}; case 52: return {t:428,w:4.382027}; case 53: return {t:428,w:4.382027}; case 54: return {t:428,w:4.382027}; case 55: return {t:428,w:4.382027}; case 56: return {t:428,w:4.382027}; case 57: return {t:428,w:4.382027}; case 65: return {t:432,w:5.337539}; case 66: return {t:432,w:5.337539}; case 67: return {t:432,w:5.337539}; case 68: return {t:432,w:5.337539}; case 69: return {t:432,w:5.337539}; case 70: return {t:432,w:5.337539}; case 71: return {t:432,w:5.337539}; case 72: return {t:432,w:5.337539}; case 73: return {t:432,w:5.337539}; case 74: return {t:432,w:5.337539}; case 75: return {t:432,w:5.337539}; case 76: return {t:432,w:5.337539}; case 77: return {t:432,w:5.337539}; case 78: return {t:432,w:5.337539}; case 79: return {t:432,w:5.337539}; case 80: return {t:432,w:5.337539}; case 81: return {t:432,w:5.337539}; case 82: return {t:432,w:5.337539}; case 83: return {t:432,w:5.337539}; case 84: return {t:432,w:5.337539}; case 85: return {t:432,w:5.337539}; case 86: return {t:432,w:5.337539}; case 87: return {t:432,w:5.337539}; case 88: return {t:432,w:5.337539}; case 89: return {t:432,w:5.337539}; case 90: return {t:432,w:5.337539}; case 95: return {t:433,w:2.079442}; case 97: return {t:434,w:5.337539}; case 98: return {t:434,w:5.337539}; case 99: return {t:434,w:5.337539}; case 100: return {t:434,w:5.337539}; case 101: return {t:434,w:5.337539}; case 102: return {t:434,w:5.337539}; case 103: return {t:434,w:5.337539}; case 104: return {t:434,w:5.337539}; case 105: return {t:434,w:5.337539}; case 106: return {t:434,w:5.337539}; case 107: return {t:434,w:5.337539}; case 108: return {t:434,w:5.337539}; case 109: return {t:434,w:5.337539}; case 110: return {t:434,w:5.337539}; case 111: return {t:434,w:5.337539}; case 112: return {t:434,w:5.337539}; case 113: return {t:434,w:5.337539}; case 114: return {t:434,w:5.337539}; case 115: return {t:434,w:5.337539}; case 116: return {t:434,w:5.337539}; case 117: return {t:434,w:5.337539}; case 118: return {t:434,w:5.337539}; case 119: return {t:434,w:5.337539}; case 120: return {t:434,w:5.337539}; case 121: return {t:434,w:5.337539}; case 122: return {t:434,w:5.337539}; case 126: return {t:435,w:2.079442};default: return {t:0,w:0.0};}};
case 1387: return function (act:Int) {switch (act) { case 432: return {t:1387,w:0.000000};default: return {t:0,w:0.0};}};
case 1388: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1389: return function (act:Int) {switch (act) { case 256: return {t:1202,w:4000000.000000}; case 448: return {t:1529,w:0.000000};default: return {t:0,w:0.0};}};
case 1390: return function (act:Int) {switch (act) { case 258: return {t:1208,w:0.000000};default: return {t:0,w:0.0};}};
case 1391: return function (act:Int) {switch (act) { case 433: return {t:1391,w:0.000000};default: return {t:0,w:0.0};}};
case 1392: return function (act:Int) {switch (act) { case 256: return {t:1086,w:4000000.750000}; case 258: return {t:1391,w:0.693147}; case 418: return {t:1392,w:0.693147};default: return {t:0,w:0.0};}};
case 1393: return function (act:Int) {switch (act) { case 59: return {t:1213,w:0.693147}; case 258: return {t:1087,w:0.693147};default: return {t:0,w:0.0};}};
case 1394: return function (act:Int) {switch (act) { case 79: return {t:1530,w:0.693147}; case 111: return {t:1530,w:0.693147};default: return {t:0,w:0.0};}};
case 1395: return function (act:Int) {switch (act) { case 71: return {t:1531,w:0.693147}; case 103: return {t:1531,w:0.693147};default: return {t:0,w:0.0};}};
case 1396: return function (act:Int) {switch (act) { case 42: return {t:1532,w:0.000000};default: return {t:0,w:0.0};}};
case 1397: return function (act:Int) {switch (act) { case 42: return {t:1533,w:0.000000}; case 256: return {t:817,w:4000000.000000}; case 397: return {t:1534,w:0.000000};default: return {t:0,w:0.0};}};
case 1398: return function (act:Int) {switch (act) { case 434: return {t:1398,w:0.000000};default: return {t:0,w:0.0};}};
case 1399: return function (act:Int) {switch (act) { case 256: return {t:1535,w:4000000.000000}; case 483: return {t:1536,w:0.000000};default: return {t:0,w:0.0};}};
case 1400: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1099,w:0.693147}; case 375: return {t:1225,w:0.693147};default: return {t:0,w:0.0};}};
case 1401: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1537,w:0.000000};default: return {t:0,w:0.0};}};
case 1402: return function (act:Int) {switch (act) { case 84: return {t:1538,w:0.693147}; case 116: return {t:1538,w:0.693147};default: return {t:0,w:0.0};}};
case 1403: return function (act:Int) {switch (act) { case 73: return {t:1539,w:0.693147}; case 105: return {t:1539,w:0.693147};default: return {t:0,w:0.0};}};
case 1404: return function (act:Int) {switch (act) { case 256: return {t:1540,w:4000000.000000}; case 484: return {t:1541,w:0.000000};default: return {t:0,w:0.0};}};
case 1405: return function (act:Int) {switch (act) { case 83: return {t:1542,w:0.693147}; case 115: return {t:1542,w:0.693147};default: return {t:0,w:0.0};}};
case 1406: return function (act:Int) {switch (act) { case 67: return {t:1543,w:0.693147}; case 99: return {t:1543,w:0.693147};default: return {t:0,w:0.0};}};
case 1407: return function (act:Int) {switch (act) { case 78: return {t:1544,w:0.693147}; case 110: return {t:1544,w:0.693147};default: return {t:0,w:0.0};}};
case 1408: return function (act:Int) {switch (act) { case 78: return {t:1545,w:0.693147}; case 110: return {t:1545,w:0.693147};default: return {t:0,w:0.0};}};
case 1409: return function (act:Int) {switch (act) { case 80: return {t:1546,w:0.693147}; case 112: return {t:1546,w:0.693147};default: return {t:0,w:0.0};}};
case 1410: return function (act:Int) {switch (act) { case 84: return {t:1547,w:0.693147}; case 116: return {t:1547,w:0.693147};default: return {t:0,w:0.0};}};
case 1411: return function (act:Int) {switch (act) { case 258: return {t:815,w:0.000000};default: return {t:0,w:0.0};}};
case 1412: return function (act:Int) {switch (act) { case 82: return {t:1548,w:0.693147}; case 114: return {t:1548,w:0.693147};default: return {t:0,w:0.0};}};
case 1413: return function (act:Int) {switch (act) { case 450: return {t:1413,w:0.000000};default: return {t:0,w:0.0};}};
case 1414: return function (act:Int) {switch (act) { case 256: return {t:1549,w:4000000.000000}; case 485: return {t:1550,w:0.000000};default: return {t:0,w:0.0};}};
case 1415: return function (act:Int) {switch (act) { case 422: return {t:1415,w:0.000000};default: return {t:0,w:0.0};}};
case 1416: return function (act:Int) {switch (act) { case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 336: return {t:1551,w:0.000000};default: return {t:0,w:0.0};}};
case 1417: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:1552,w:0.000000};default: return {t:0,w:0.0};}};
case 1418: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1553,w:0.000000};default: return {t:0,w:0.0};}};
case 1419: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1554,w:0.693147}; case 336: return {t:1555,w:0.693147};default: return {t:0,w:0.0};}};
case 1420: return function (act:Int) {switch (act) { case 302: return {t:1420,w:0.000000};default: return {t:0,w:0.0};}};
case 1421: return function (act:Int) {switch (act) { case 79: return {t:1556,w:0.693147}; case 111: return {t:1556,w:0.693147};default: return {t:0,w:0.0};}};
case 1422: return function (act:Int) {switch (act) { case 68: return {t:1557,w:0.693147}; case 100: return {t:1557,w:0.693147};default: return {t:0,w:0.0};}};
case 1423: return function (act:Int) {switch (act) { case 79: return {t:1558,w:0.693147}; case 111: return {t:1558,w:0.693147};default: return {t:0,w:0.0};}};
case 1424: return function (act:Int) {switch (act) { case 83: return {t:1559,w:0.693147}; case 115: return {t:1559,w:0.693147};default: return {t:0,w:0.0};}};
case 1425: return function (act:Int) {switch (act) { case 82: return {t:1560,w:0.693147}; case 114: return {t:1560,w:0.693147};default: return {t:0,w:0.0};}};
case 1426: return function (act:Int) {switch (act) { case 46: return {t:1561,w:0.693147}; case 258: return {t:1562,w:0.693147};default: return {t:0,w:0.0};}};
case 1427: return function (act:Int) {switch (act) { case 46: return {t:1563,w:0.693147}; case 258: return {t:1562,w:0.693147};default: return {t:0,w:0.0};}};
case 1428: return function (act:Int) {switch (act) { case 424: return {t:1428,w:0.000000};default: return {t:0,w:0.0};}};
case 1429: return function (act:Int) {switch (act) { case 79: return {t:1564,w:0.693147}; case 111: return {t:1564,w:0.693147};default: return {t:0,w:0.0};}};
case 1430: return function (act:Int) {switch (act) { case 33: return {t:2,w:4.007333}; case 37: return {t:3,w:4.007333}; case 39: return {t:4,w:4.007333}; case 42: return {t:5,w:4.007333}; case 43: return {t:6,w:4.007333}; case 45: return {t:7,w:4.007333}; case 46: return {t:8,w:4.007333}; case 48: return {t:9,w:7.408530}; case 49: return {t:9,w:7.408530}; case 50: return {t:9,w:7.408530}; case 51: return {t:9,w:7.408530}; case 52: return {t:9,w:7.408530}; case 53: return {t:9,w:7.408530}; case 54: return {t:9,w:7.408530}; case 55: return {t:9,w:7.408530}; case 56: return {t:9,w:7.408530}; case 57: return {t:9,w:7.408530}; case 65: return {t:13,w:8.364042}; case 66: return {t:13,w:8.364042}; case 67: return {t:13,w:8.364042}; case 68: return {t:13,w:8.364042}; case 69: return {t:1565,w:2.302585}; case 70: return {t:13,w:8.364042}; case 71: return {t:13,w:8.364042}; case 72: return {t:13,w:8.364042}; case 73: return {t:13,w:8.364042}; case 74: return {t:13,w:8.364042}; case 75: return {t:13,w:8.364042}; case 76: return {t:13,w:8.364042}; case 77: return {t:13,w:8.364042}; case 78: return {t:1566,w:2.302585}; case 79: return {t:13,w:8.364042}; case 80: return {t:13,w:8.364042}; case 81: return {t:13,w:8.364042}; case 82: return {t:13,w:8.364042}; case 83: return {t:13,w:8.364042}; case 84: return {t:13,w:8.364042}; case 85: return {t:1567,w:2.302585}; case 86: return {t:13,w:8.364042}; case 87: return {t:13,w:8.364042}; case 88: return {t:13,w:8.364042}; case 89: return {t:13,w:8.364042}; case 90: return {t:13,w:8.364042}; case 95: return {t:18,w:4.007333}; case 96: return {t:19,w:4.007333}; case 97: return {t:20,w:8.364042}; case 98: return {t:20,w:8.364042}; case 99: return {t:20,w:8.364042}; case 100: return {t:20,w:8.364042}; case 101: return {t:1568,w:2.302585}; case 102: return {t:20,w:8.364042}; case 103: return {t:20,w:8.364042}; case 104: return {t:20,w:8.364042}; case 105: return {t:20,w:8.364042}; case 106: return {t:20,w:8.364042}; case 107: return {t:20,w:8.364042}; case 108: return {t:20,w:8.364042}; case 109: return {t:20,w:8.364042}; case 110: return {t:1569,w:2.302585}; case 111: return {t:20,w:8.364042}; case 112: return {t:20,w:8.364042}; case 113: return {t:20,w:8.364042}; case 114: return {t:20,w:8.364042}; case 115: return {t:20,w:8.364042}; case 116: return {t:20,w:8.364042}; case 117: return {t:1570,w:2.302585}; case 118: return {t:20,w:8.364042}; case 119: return {t:20,w:8.364042}; case 120: return {t:20,w:8.364042}; case 121: return {t:20,w:8.364042}; case 122: return {t:20,w:8.364042}; case 126: return {t:22,w:4.007333}; case 268: return {t:29,w:4.007333}; case 269: return {t:1571,w:1.609438}; case 486: return {t:1572,w:1.609438};default: return {t:0,w:0.0};}};
case 1431: return function (act:Int) {switch (act) { case 258: return {t:1573,w:0.000000};default: return {t:0,w:0.0};}};
case 1432: return function (act:Int) {switch (act) { case 69: return {t:1574,w:0.693147}; case 79: return {t:1575,w:0.693147}; case 101: return {t:1574,w:0.693147}; case 111: return {t:1575,w:0.693147};default: return {t:0,w:0.0};}};
case 1433: return function (act:Int) {switch (act) { case 73: return {t:1576,w:0.693147}; case 105: return {t:1576,w:0.693147};default: return {t:0,w:0.0};}};
case 1434: return function (act:Int) {switch (act) { case 84: return {t:1577,w:0.693147}; case 116: return {t:1577,w:0.693147};default: return {t:0,w:0.0};}};
case 1435: return function (act:Int) {switch (act) { case 9: return {t:493,w:3.465735}; case 13: return {t:83,w:3.465735}; case 32: return {t:494,w:3.465735}; case 33: return {t:2,w:5.170483}; case 37: return {t:3,w:5.170483}; case 39: return {t:4,w:5.170483}; case 42: return {t:5,w:5.170483}; case 43: return {t:6,w:5.170483}; case 45: return {t:7,w:5.170483}; case 46: return {t:8,w:5.170483}; case 48: return {t:9,w:8.571681}; case 49: return {t:9,w:8.571681}; case 50: return {t:9,w:8.571681}; case 51: return {t:9,w:8.571681}; case 52: return {t:9,w:8.571681}; case 53: return {t:9,w:8.571681}; case 54: return {t:9,w:8.571681}; case 55: return {t:9,w:8.571681}; case 56: return {t:9,w:8.571681}; case 57: return {t:9,w:8.571681}; case 65: return {t:495,w:5.743003}; case 66: return {t:495,w:5.743003}; case 67: return {t:495,w:5.743003}; case 68: return {t:495,w:5.743003}; case 69: return {t:495,w:5.743003}; case 70: return {t:495,w:5.743003}; case 71: return {t:495,w:5.743003}; case 72: return {t:495,w:5.743003}; case 73: return {t:495,w:5.743003}; case 74: return {t:495,w:5.743003}; case 75: return {t:495,w:5.743003}; case 76: return {t:495,w:5.743003}; case 77: return {t:495,w:5.743003}; case 78: return {t:495,w:5.743003}; case 79: return {t:495,w:5.743003}; case 80: return {t:495,w:5.743003}; case 81: return {t:495,w:5.743003}; case 82: return {t:495,w:5.743003}; case 83: return {t:496,w:2.484906}; case 84: return {t:495,w:5.743003}; case 85: return {t:495,w:5.743003}; case 86: return {t:495,w:5.743003}; case 87: return {t:495,w:5.743003}; case 88: return {t:495,w:5.743003}; case 89: return {t:495,w:5.743003}; case 90: return {t:495,w:5.743003}; case 95: return {t:18,w:5.170483}; case 96: return {t:19,w:5.170483}; case 97: return {t:497,w:5.743003}; case 98: return {t:497,w:5.743003}; case 99: return {t:497,w:5.743003}; case 100: return {t:497,w:5.743003}; case 101: return {t:497,w:5.743003}; case 102: return {t:497,w:5.743003}; case 103: return {t:497,w:5.743003}; case 104: return {t:497,w:5.743003}; case 105: return {t:497,w:5.743003}; case 106: return {t:497,w:5.743003}; case 107: return {t:497,w:5.743003}; case 108: return {t:497,w:5.743003}; case 109: return {t:497,w:5.743003}; case 110: return {t:497,w:5.743003}; case 111: return {t:497,w:5.743003}; case 112: return {t:497,w:5.743003}; case 113: return {t:497,w:5.743003}; case 114: return {t:497,w:5.743003}; case 115: return {t:498,w:2.484906}; case 116: return {t:497,w:5.743003}; case 117: return {t:497,w:5.743003}; case 118: return {t:497,w:5.743003}; case 119: return {t:497,w:5.743003}; case 120: return {t:497,w:5.743003}; case 121: return {t:497,w:5.743003}; case 122: return {t:497,w:5.743003}; case 126: return {t:22,w:5.170483}; case 258: return {t:499,w:2.079441}; case 268: return {t:29,w:5.170483}; case 269: return {t:500,w:2.772588}; case 279: return {t:504,w:3.465735}; case 283: return {t:119,w:3.465735}; case 331: return {t:183,w:1.791759}; case 332: return {t:501,w:1.791759}; case 333: return {t:502,w:1.791759}; case 334: return {t:186,w:1.791759}; case 335: return {t:503,w:1.791759}; case 357: return {t:1578,w:0.693147}; case 358: return {t:1579,w:0.693147}; case 368: return {t:507,w:1.386294}; case 376: return {t:505,w:2.772588}; case 377: return {t:506,w:2.079441}; case 378: return {t:508,w:2.079441}; case 379: return {t:509,w:1.386294}; case 380: return {t:510,w:1.386294};default: return {t:0,w:0.0};}};
case 1436: return function (act:Int) {switch (act) { case 258: return {t:1580,w:0.000000};default: return {t:0,w:0.0};}};
case 1437: return function (act:Int) {switch (act) { case 315: return {t:1437,w:0.000000};default: return {t:0,w:0.0};}};
case 1438: return function (act:Int) {switch (act) { case 256: return {t:313,w:4000000.000000}; case 353: return {t:1581,w:0.000000};default: return {t:0,w:0.0};}};
case 1439: return function (act:Int) {switch (act) { case 82: return {t:1582,w:0.693147}; case 114: return {t:1582,w:0.693147};default: return {t:0,w:0.0};}};
case 1440: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:862,w:0.000000}; case 404: return {t:1583,w:0.000000};default: return {t:0,w:0.0};}};
case 1441: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1271,w:0.693147}; case 384: return {t:1272,w:0.693147};default: return {t:0,w:0.0};}};
case 1442: return function (act:Int) {switch (act) { case 455: return {t:1442,w:0.000000};default: return {t:0,w:0.0};}};
case 1443: return function (act:Int) {switch (act) { case 256: return {t:1584,w:4000000.000000}; case 487: return {t:1585,w:0.000000};default: return {t:0,w:0.0};}};
case 1444: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:1586,w:0.000000};default: return {t:0,w:0.0};}};
case 1445: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 33: return {t:1587,w:4.555348}; case 34: return {t:1587,w:4.555348}; case 35: return {t:1587,w:4.555348}; case 36: return {t:1587,w:4.555348}; case 37: return {t:1587,w:4.555348}; case 38: return {t:1587,w:4.555348}; case 39: return {t:1587,w:4.555348}; case 42: return {t:1588,w:6.521461}; case 43: return {t:1588,w:6.521461}; case 44: return {t:1588,w:6.521461}; case 45: return {t:1588,w:6.521461}; case 46: return {t:1588,w:6.521461}; case 47: return {t:1588,w:6.521461}; case 48: return {t:1588,w:6.521461}; case 49: return {t:1588,w:6.521461}; case 50: return {t:1588,w:6.521461}; case 51: return {t:1588,w:6.521461}; case 52: return {t:1588,w:6.521461}; case 53: return {t:1588,w:6.521461}; case 54: return {t:1588,w:6.521461}; case 55: return {t:1588,w:6.521461}; case 56: return {t:1588,w:6.521461}; case 57: return {t:1588,w:6.521461}; case 58: return {t:1588,w:6.521461}; case 59: return {t:1588,w:6.521461}; case 60: return {t:1588,w:6.521461}; case 61: return {t:1588,w:6.521461}; case 62: return {t:1588,w:6.521461}; case 63: return {t:1588,w:6.521461}; case 64: return {t:1588,w:6.521461}; case 65: return {t:1588,w:6.521461}; case 66: return {t:1588,w:6.521461}; case 67: return {t:1588,w:6.521461}; case 68: return {t:1588,w:6.521461}; case 69: return {t:1588,w:6.521461}; case 70: return {t:1588,w:6.521461}; case 71: return {t:1588,w:6.521461}; case 72: return {t:1588,w:6.521461}; case 73: return {t:1588,w:6.521461}; case 74: return {t:1588,w:6.521461}; case 75: return {t:1588,w:6.521461}; case 76: return {t:1588,w:6.521461}; case 77: return {t:1588,w:6.521461}; case 78: return {t:1588,w:6.521461}; case 79: return {t:1588,w:6.521461}; case 80: return {t:1588,w:6.521461}; case 81: return {t:1588,w:6.521461}; case 82: return {t:1588,w:6.521461}; case 83: return {t:1588,w:6.521461}; case 84: return {t:1588,w:6.521461}; case 85: return {t:1588,w:6.521461}; case 86: return {t:1588,w:6.521461}; case 87: return {t:1588,w:6.521461}; case 88: return {t:1588,w:6.521461}; case 89: return {t:1588,w:6.521461}; case 90: return {t:1588,w:6.521461}; case 91: return {t:1588,w:6.521461}; case 92: return {t:975,w:1.000000}; case 93: return {t:1589,w:6.135799}; case 94: return {t:1589,w:6.135799}; case 95: return {t:1589,w:6.135799}; case 96: return {t:1589,w:6.135799}; case 97: return {t:1589,w:6.135799}; case 98: return {t:1589,w:6.135799}; case 99: return {t:1589,w:6.135799}; case 100: return {t:1589,w:6.135799}; case 101: return {t:1589,w:6.135799}; case 102: return {t:1589,w:6.135799}; case 103: return {t:1589,w:6.135799}; case 104: return {t:1589,w:6.135799}; case 105: return {t:1589,w:6.135799}; case 106: return {t:1589,w:6.135799}; case 107: return {t:1589,w:6.135799}; case 108: return {t:1589,w:6.135799}; case 109: return {t:1589,w:6.135799}; case 110: return {t:1589,w:6.135799}; case 111: return {t:1589,w:6.135799}; case 112: return {t:1589,w:6.135799}; case 113: return {t:1589,w:6.135799}; case 114: return {t:1589,w:6.135799}; case 115: return {t:1589,w:6.135799}; case 116: return {t:1589,w:6.135799}; case 117: return {t:1589,w:6.135799}; case 118: return {t:1589,w:6.135799}; case 119: return {t:1589,w:6.135799}; case 120: return {t:1589,w:6.135799}; case 121: return {t:1589,w:6.135799}; case 122: return {t:1589,w:6.135799}; case 123: return {t:1589,w:6.135799}; case 124: return {t:1589,w:6.135799}; case 125: return {t:1589,w:6.135799}; case 126: return {t:1589,w:6.135799}; case 192: return {t:437,w:7.684612}; case 193: return {t:437,w:7.684612}; case 194: return {t:437,w:7.684612}; case 195: return {t:437,w:7.684612}; case 196: return {t:437,w:7.684612}; case 197: return {t:437,w:7.684612}; case 198: return {t:437,w:7.684612}; case 199: return {t:437,w:7.684612}; case 200: return {t:437,w:7.684612}; case 201: return {t:437,w:7.684612}; case 202: return {t:437,w:7.684612}; case 203: return {t:437,w:7.684612}; case 204: return {t:437,w:7.684612}; case 205: return {t:437,w:7.684612}; case 206: return {t:437,w:7.684612}; case 207: return {t:437,w:7.684612}; case 208: return {t:437,w:7.684612}; case 209: return {t:437,w:7.684612}; case 210: return {t:437,w:7.684612}; case 211: return {t:437,w:7.684612}; case 212: return {t:437,w:7.684612}; case 213: return {t:437,w:7.684612}; case 214: return {t:437,w:7.684612}; case 215: return {t:437,w:7.684612}; case 216: return {t:437,w:7.684612}; case 217: return {t:437,w:7.684612}; case 218: return {t:437,w:7.684612}; case 219: return {t:437,w:7.684612}; case 220: return {t:437,w:7.684612}; case 221: return {t:437,w:7.684612}; case 222: return {t:437,w:7.684612}; case 223: return {t:437,w:7.684612}; case 224: return {t:438,w:6.991465}; case 225: return {t:438,w:6.991465}; case 226: return {t:438,w:6.991465}; case 227: return {t:438,w:6.991465}; case 228: return {t:438,w:6.991465}; case 229: return {t:438,w:6.991465}; case 230: return {t:438,w:6.991465}; case 231: return {t:438,w:6.991465}; case 232: return {t:438,w:6.991465}; case 233: return {t:438,w:6.991465}; case 234: return {t:438,w:6.991465}; case 235: return {t:438,w:6.991465}; case 236: return {t:438,w:6.991465}; case 237: return {t:438,w:6.991465}; case 238: return {t:438,w:6.991465}; case 239: return {t:438,w:6.991465}; case 240: return {t:439,w:6.298318}; case 241: return {t:439,w:6.298318}; case 242: return {t:439,w:6.298318}; case 243: return {t:439,w:6.298318}; case 244: return {t:439,w:6.298318}; case 245: return {t:439,w:6.298318}; case 246: return {t:439,w:6.298318}; case 247: return {t:439,w:6.298318}; case 248: return {t:440,w:5.605170}; case 249: return {t:440,w:5.605170}; case 250: return {t:440,w:5.605170}; case 251: return {t:440,w:5.605170}; case 252: return {t:441,w:4.912023}; case 253: return {t:441,w:4.912023}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 367: return {t:1592,w:2.609438}; case 368: return {t:1591,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:1590,w:0.693147}; case 453: return {t:1276,w:1.000000};default: return {t:0,w:0.0};}};
case 1446: return function (act:Int) {switch (act) { case 256: return {t:1445,w:4000000.750000}; case 400: return {t:1446,w:1.791759}; case 454: return {t:1448,w:1.791759}; case 478: return {t:1447,w:1.791759}; case 479: return {t:1449,w:0.693147};default: return {t:0,w:0.0};}};
case 1447: return function (act:Int) {switch (act) { case 256: return {t:1445,w:4000000.750000}; case 400: return {t:1446,w:1.791759}; case 454: return {t:1448,w:1.791759}; case 478: return {t:1447,w:1.791759}; case 479: return {t:1449,w:0.693147};default: return {t:0,w:0.0};}};
case 1448: return function (act:Int) {switch (act) { case 256: return {t:1445,w:4000000.750000}; case 400: return {t:1446,w:1.791759}; case 454: return {t:1448,w:1.791759}; case 478: return {t:1447,w:1.791759}; case 479: return {t:1449,w:0.693147};default: return {t:0,w:0.0};}};
case 1449: return function (act:Int) {switch (act) { case 258: return {t:1593,w:0.000000};default: return {t:0,w:0.0};}};
case 1450: return function (act:Int) {switch (act) { case 436: return {t:1450,w:0.000000};default: return {t:0,w:0.0};}};
case 1451: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.750000}; case 258: return {t:1279,w:0.693147}; case 377: return {t:1280,w:0.693147};default: return {t:0,w:0.0};}};
case 1452: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1594,w:0.000000};default: return {t:0,w:0.0};}};
case 1453: return function (act:Int) {switch (act) { case 258: return {t:1595,w:0.000000};default: return {t:0,w:0.0};}};
case 1454: return function (act:Int) {switch (act) { case 258: return {t:1596,w:0.000000};default: return {t:0,w:0.0};}};
case 1455: return function (act:Int) {switch (act) { case 268: return {t:52,w:2.397895}; case 336: return {t:271,w:0.000000};default: return {t:0,w:0.0};}};
case 1456: return function (act:Int) {switch (act) { case 268: return {t:52,w:0.318454}; case 331: return {t:258,w:0.000000};default: return {t:0,w:0.0};}};
case 1457: return function (act:Int) {switch (act) { case 33: return {t:39,w:4.708779}; case 37: return {t:40,w:4.708779}; case 39: return {t:41,w:4.708779}; case 42: return {t:42,w:4.708779}; case 43: return {t:43,w:4.708779}; case 45: return {t:44,w:4.708779}; case 46: return {t:45,w:4.708779}; case 95: return {t:46,w:4.708779}; case 96: return {t:47,w:4.708779}; case 126: return {t:48,w:4.708779}; case 256: return {t:1597,w:4000000.000000}; case 258: return {t:50,w:2.310884}; case 268: return {t:51,w:4.708779}; case 444: return {t:1186,w:0.000000};default: return {t:0,w:0.0};}};
case 1458: return function (act:Int) {switch (act) { case 269: return {t:50,w:0.606136}; case 410: return {t:1035,w:0.000000};default: return {t:0,w:0.0};}};
case 1459: return function (act:Int) {switch (act) { case 33: return {t:39,w:5.401926}; case 37: return {t:40,w:5.401926}; case 39: return {t:41,w:5.401926}; case 42: return {t:42,w:5.401926}; case 43: return {t:43,w:5.401926}; case 45: return {t:44,w:5.401926}; case 46: return {t:45,w:5.401926}; case 95: return {t:46,w:5.401926}; case 96: return {t:47,w:5.401926}; case 126: return {t:48,w:5.401926}; case 256: return {t:1597,w:4000000.750000}; case 258: return {t:1598,w:0.000000}; case 268: return {t:51,w:5.401926}; case 444: return {t:1186,w:0.693147};default: return {t:0,w:0.0};}};
case 1460: return function (act:Int) {switch (act) { case 437: return {t:1460,w:0.000000};default: return {t:0,w:0.0};}};
case 1461: return function (act:Int) {switch (act) { case 68: return {t:1599,w:0.693147}; case 100: return {t:1599,w:0.693147};default: return {t:0,w:0.0};}};
case 1462: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1600,w:0.000000};default: return {t:0,w:0.0};}};
case 1463: return function (act:Int) {switch (act) { case 84: return {t:1601,w:0.693147}; case 116: return {t:1601,w:0.693147};default: return {t:0,w:0.0};}};
case 1464: return function (act:Int) {switch (act) { case 80: return {t:1602,w:0.693147}; case 112: return {t:1602,w:0.693147};default: return {t:0,w:0.0};}};
case 1465: return function (act:Int) {switch (act) { case 83: return {t:1603,w:0.693147}; case 115: return {t:1603,w:0.693147};default: return {t:0,w:0.0};}};
case 1466: return function (act:Int) {switch (act) { case 80: return {t:1604,w:0.693147}; case 112: return {t:1604,w:0.693147};default: return {t:0,w:0.0};}};
case 1467: return function (act:Int) {switch (act) { case 456: return {t:1467,w:0.000000};default: return {t:0,w:0.0};}};
case 1468: return function (act:Int) {switch (act) { case 438: return {t:1468,w:0.000000};default: return {t:0,w:0.0};}};
case 1469: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:1605,w:0.000000};default: return {t:0,w:0.0};}};
case 1470: return function (act:Int) {switch (act) { case 65: return {t:1606,w:0.693147}; case 97: return {t:1606,w:0.693147};default: return {t:0,w:0.0};}};
case 1471: return function (act:Int) {switch (act) { case 68: return {t:1607,w:0.693147}; case 100: return {t:1607,w:0.693147};default: return {t:0,w:0.0};}};
case 1472: return function (act:Int) {switch (act) { case 67: return {t:1608,w:0.693147}; case 99: return {t:1608,w:0.693147};default: return {t:0,w:0.0};}};
case 1473: return function (act:Int) {switch (act) { case 76: return {t:1609,w:0.693147}; case 108: return {t:1609,w:0.693147};default: return {t:0,w:0.0};}};
case 1474: return function (act:Int) {switch (act) { case 461: return {t:1474,w:0.000000};default: return {t:0,w:0.0};}};
case 1475: return function (act:Int) {switch (act) { case 440: return {t:1475,w:0.000000};default: return {t:0,w:0.0};}};
case 1476: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1610,w:0.000000};default: return {t:0,w:0.0};}};
case 1477: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:1611,w:0.000000};default: return {t:0,w:0.0};}};
case 1478: return function (act:Int) {switch (act) { case 326: return {t:1478,w:0.000000};default: return {t:0,w:0.0};}};
case 1479: return function (act:Int) {switch (act) { case 256: return {t:1320,w:4000000.000000}; case 462: return {t:1612,w:0.000000};default: return {t:0,w:0.0};}};
case 1480: return function (act:Int) {switch (act) { case 84: return {t:1613,w:0.693147}; case 116: return {t:1613,w:0.693147};default: return {t:0,w:0.0};}};
case 1481: return function (act:Int) {switch (act) { case 48: return {t:787,w:3.401197}; case 49: return {t:787,w:3.401197}; case 50: return {t:787,w:3.401197}; case 51: return {t:787,w:3.401197}; case 52: return {t:787,w:3.401197}; case 53: return {t:787,w:3.401197}; case 54: return {t:787,w:3.401197}; case 55: return {t:787,w:3.401197}; case 56: return {t:787,w:3.401197}; case 57: return {t:787,w:3.401197}; case 65: return {t:788,w:2.890371}; case 66: return {t:788,w:2.890371}; case 67: return {t:788,w:2.890371}; case 68: return {t:788,w:2.890371}; case 69: return {t:788,w:2.890371}; case 70: return {t:788,w:2.890371}; case 97: return {t:789,w:2.890371}; case 98: return {t:789,w:2.890371}; case 99: return {t:789,w:2.890371}; case 100: return {t:789,w:2.890371}; case 101: return {t:789,w:2.890371}; case 102: return {t:789,w:2.890371}; case 390: return {t:1180,w:0.000000}; case 441: return {t:1181,w:0.000000};default: return {t:0,w:0.0};}};
case 1482: return function (act:Int) {switch (act) { case 258: return {t:1329,w:0.000000};default: return {t:0,w:0.0};}};
case 1483: return function (act:Int) {switch (act) { case 256: return {t:623,w:4000000.750000}; case 258: return {t:1324,w:0.693147}; case 390: return {t:1614,w:0.693147};default: return {t:0,w:0.0};}};
case 1484: return function (act:Int) {switch (act) { case 48: return {t:787,w:3.401197}; case 49: return {t:787,w:3.401197}; case 50: return {t:787,w:3.401197}; case 51: return {t:787,w:3.401197}; case 52: return {t:787,w:3.401197}; case 53: return {t:787,w:3.401197}; case 54: return {t:787,w:3.401197}; case 55: return {t:787,w:3.401197}; case 56: return {t:787,w:3.401197}; case 57: return {t:787,w:3.401197}; case 65: return {t:788,w:2.890371}; case 66: return {t:788,w:2.890371}; case 67: return {t:788,w:2.890371}; case 68: return {t:788,w:2.890371}; case 69: return {t:788,w:2.890371}; case 70: return {t:788,w:2.890371}; case 97: return {t:789,w:2.890371}; case 98: return {t:789,w:2.890371}; case 99: return {t:789,w:2.890371}; case 100: return {t:789,w:2.890371}; case 101: return {t:789,w:2.890371}; case 102: return {t:789,w:2.890371}; case 390: return {t:1180,w:0.000000};default: return {t:0,w:0.0};}};
case 1485: return function (act:Int) {switch (act) { case 58: return {t:1326,w:0.693147}; case 258: return {t:1327,w:0.693147};default: return {t:0,w:0.0};}};
case 1486: return function (act:Int) {switch (act) { case 256: return {t:1481,w:4000000.750000}; case 258: return {t:1329,w:0.693147}; case 442: return {t:1615,w:0.693147};default: return {t:0,w:0.0};}};
case 1487: return function (act:Int) {switch (act) { case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 336: return {t:895,w:0.000000};default: return {t:0,w:0.0};}};
case 1488: return function (act:Int) {switch (act) { case 258: return {t:1331,w:0.000000};default: return {t:0,w:0.0};}};
case 1489: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1490: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1491: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1492: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1493: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1494: return function (act:Int) {switch (act) { case 445: return {t:1494,w:0.000000};default: return {t:0,w:0.0};}};
case 1495: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1496: return function (act:Int) {switch (act) { case 36: return {t:1489,w:2.639057}; case 38: return {t:1490,w:2.639057}; case 43: return {t:1491,w:2.639057}; case 44: return {t:1492,w:2.639057}; case 61: return {t:1493,w:2.639057}; case 256: return {t:1386,w:4000002.750000}; case 258: return {t:1494,w:0.693147}; case 363: return {t:1495,w:2.639057}; case 364: return {t:1496,w:2.639057};default: return {t:0,w:0.0};}};
case 1497: return function (act:Int) {switch (act) { case 46: return {t:1616,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:1617,w:0.693147};default: return {t:0,w:0.0};}};
case 1498: return function (act:Int) {switch (act) { case 46: return {t:1343,w:0.000000};default: return {t:0,w:0.0};}};
case 1499: return function (act:Int) {switch (act) { case 446: return {t:1499,w:0.000000};default: return {t:0,w:0.0};}};
case 1500: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1499,w:0.693147}; case 336: return {t:1500,w:0.693147};default: return {t:0,w:0.0};}};
case 1501: return function (act:Int) {switch (act) { case 469: return {t:1501,w:0.000000};default: return {t:0,w:0.0};}};
case 1502: return function (act:Int) {switch (act) { case 258: return {t:1618,w:0.000000};default: return {t:0,w:0.0};}};
case 1503: return function (act:Int) {switch (act) { case 68: return {t:1619,w:0.693147}; case 100: return {t:1619,w:0.693147};default: return {t:0,w:0.0};}};
case 1504: return function (act:Int) {switch (act) { case 84: return {t:1620,w:0.693147}; case 116: return {t:1620,w:0.693147};default: return {t:0,w:0.0};}};
case 1505: return function (act:Int) {switch (act) { case 65: return {t:1621,w:0.693147}; case 97: return {t:1621,w:0.693147};default: return {t:0,w:0.0};}};
case 1506: return function (act:Int) {switch (act) { case 76: return {t:1622,w:0.693147}; case 108: return {t:1622,w:0.693147};default: return {t:0,w:0.0};}};
case 1507: return function (act:Int) {switch (act) { case 69: return {t:1623,w:0.693147}; case 101: return {t:1623,w:0.693147};default: return {t:0,w:0.0};}};
case 1508: return function (act:Int) {switch (act) { case 470: return {t:1508,w:0.000000};default: return {t:0,w:0.0};}};
case 1509: return function (act:Int) {switch (act) { case 447: return {t:1509,w:0.000000};default: return {t:0,w:0.0};}};
case 1510: return function (act:Int) {switch (act) { case 33: return {t:420,w:3.178054}; case 36: return {t:1346,w:3.044522}; case 37: return {t:422,w:1.098612}; case 38: return {t:1347,w:3.044522}; case 39: return {t:424,w:4.564348}; case 40: return {t:424,w:4.564348}; case 41: return {t:424,w:4.564348}; case 42: return {t:424,w:4.564348}; case 43: return {t:1348,w:3.044522}; case 45: return {t:426,w:3.871201}; case 46: return {t:426,w:3.871201}; case 47: return {t:1349,w:3.044522}; case 48: return {t:428,w:5.480639}; case 49: return {t:428,w:5.480639}; case 50: return {t:428,w:5.480639}; case 51: return {t:428,w:5.480639}; case 52: return {t:428,w:5.480639}; case 53: return {t:428,w:5.480639}; case 54: return {t:428,w:5.480639}; case 55: return {t:428,w:5.480639}; case 56: return {t:428,w:5.480639}; case 57: return {t:428,w:5.480639}; case 58: return {t:1350,w:3.044522}; case 65: return {t:432,w:6.436151}; case 66: return {t:432,w:6.436151}; case 67: return {t:432,w:6.436151}; case 68: return {t:432,w:6.436151}; case 69: return {t:432,w:6.436151}; case 70: return {t:432,w:6.436151}; case 71: return {t:432,w:6.436151}; case 72: return {t:432,w:6.436151}; case 73: return {t:432,w:6.436151}; case 74: return {t:432,w:6.436151}; case 75: return {t:432,w:6.436151}; case 76: return {t:432,w:6.436151}; case 77: return {t:432,w:6.436151}; case 78: return {t:432,w:6.436151}; case 79: return {t:432,w:6.436151}; case 80: return {t:432,w:6.436151}; case 81: return {t:432,w:6.436151}; case 82: return {t:432,w:6.436151}; case 83: return {t:432,w:6.436151}; case 84: return {t:432,w:6.436151}; case 85: return {t:432,w:6.436151}; case 86: return {t:432,w:6.436151}; case 87: return {t:432,w:6.436151}; case 88: return {t:432,w:6.436151}; case 89: return {t:432,w:6.436151}; case 90: return {t:432,w:6.436151}; case 91: return {t:1355,w:3.044522}; case 93: return {t:1356,w:3.044522}; case 95: return {t:433,w:3.178054}; case 97: return {t:434,w:6.436151}; case 98: return {t:434,w:6.436151}; case 99: return {t:434,w:6.436151}; case 100: return {t:434,w:6.436151}; case 101: return {t:434,w:6.436151}; case 102: return {t:434,w:6.436151}; case 103: return {t:434,w:6.436151}; case 104: return {t:434,w:6.436151}; case 105: return {t:434,w:6.436151}; case 106: return {t:434,w:6.436151}; case 107: return {t:434,w:6.436151}; case 108: return {t:434,w:6.436151}; case 109: return {t:434,w:6.436151}; case 110: return {t:434,w:6.436151}; case 111: return {t:434,w:6.436151}; case 112: return {t:434,w:6.436151}; case 113: return {t:434,w:6.436151}; case 114: return {t:434,w:6.436151}; case 115: return {t:434,w:6.436151}; case 116: return {t:434,w:6.436151}; case 117: return {t:434,w:6.436151}; case 118: return {t:434,w:6.436151}; case 119: return {t:434,w:6.436151}; case 120: return {t:434,w:6.436151}; case 121: return {t:434,w:6.436151}; case 122: return {t:434,w:6.436151}; case 126: return {t:435,w:3.178054}; case 363: return {t:1361,w:1.098612}; case 364: return {t:1362,w:1.098612}; case 469: return {t:1369,w:1.098612};default: return {t:0,w:0.0};}};
case 1511: return function (act:Int) {switch (act) { case 471: return {t:1511,w:0.000000};default: return {t:0,w:0.0};}};
case 1512: return function (act:Int) {switch (act) { case 256: return {t:1510,w:4000000.750000}; case 258: return {t:1511,w:0.693147}; case 470: return {t:1512,w:0.693147};default: return {t:0,w:0.0};}};
case 1513: return function (act:Int) {switch (act) { case 256: return {t:1624,w:4000000.000000}; case 488: return {t:1625,w:0.000000};default: return {t:0,w:0.0};}};
case 1514: return function (act:Int) {switch (act) { case 472: return {t:1514,w:0.000000};default: return {t:0,w:0.0};}};
case 1515: return function (act:Int) {switch (act) { case 59: return {t:1373,w:0.693147}; case 258: return {t:1374,w:0.693147};default: return {t:0,w:0.0};}};
case 1516: return function (act:Int) {switch (act) { case 258: return {t:1626,w:0.000000};default: return {t:0,w:0.0};}};
case 1517: return function (act:Int) {switch (act) { case 258: return {t:1626,w:0.000000};default: return {t:0,w:0.0};}};
case 1518: return function (act:Int) {switch (act) { case 258: return {t:1626,w:0.000000};default: return {t:0,w:0.0};}};
case 1519: return function (act:Int) {switch (act) { case 258: return {t:1626,w:0.000000};default: return {t:0,w:0.0};}};
case 1520: return function (act:Int) {switch (act) { case 258: return {t:1626,w:0.000000};default: return {t:0,w:0.0};}};
case 1521: return function (act:Int) {switch (act) { case 258: return {t:1626,w:0.000000};default: return {t:0,w:0.0};}};
case 1522: return function (act:Int) {switch (act) { case 258: return {t:1626,w:0.000000};default: return {t:0,w:0.0};}};
case 1523: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1628,w:0.693147}; case 363: return {t:1629,w:1.791759}; case 364: return {t:1630,w:1.791759}; case 481: return {t:1631,w:1.791759};default: return {t:0,w:0.0};}};
case 1524: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1628,w:0.693147}; case 363: return {t:1629,w:1.791759}; case 364: return {t:1630,w:1.791759}; case 481: return {t:1631,w:1.791759};default: return {t:0,w:0.0};}};
case 1525: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1628,w:0.693147}; case 363: return {t:1629,w:1.791759}; case 364: return {t:1630,w:1.791759}; case 481: return {t:1631,w:1.791759};default: return {t:0,w:0.0};}};
case 1526: return function (act:Int) {switch (act) { case 61: return {t:1632,w:0.000000};default: return {t:0,w:0.0};}};
case 1527: return function (act:Int) {switch (act) { case 256: return {t:1375,w:4000000.000000}; case 473: return {t:1633,w:0.000000};default: return {t:0,w:0.0};}};
case 1528: return function (act:Int) {switch (act) { case 430: return {t:1528,w:0.000000};default: return {t:0,w:0.0};}};
case 1529: return function (act:Int) {switch (act) { case 36: return {t:1378,w:2.995732}; case 38: return {t:1379,w:2.995732}; case 43: return {t:1380,w:2.995732}; case 44: return {t:1381,w:2.995732}; case 58: return {t:1382,w:2.995732}; case 59: return {t:1383,w:2.995732}; case 61: return {t:1384,w:2.995732}; case 64: return {t:1385,w:2.995732}; case 256: return {t:1386,w:4000003.000000}; case 258: return {t:1387,w:0.693147}; case 363: return {t:1388,w:2.995732}; case 364: return {t:1389,w:2.995732};default: return {t:0,w:0.0};}};
case 1530: return function (act:Int) {switch (act) { case 68: return {t:1634,w:0.693147}; case 100: return {t:1634,w:0.693147};default: return {t:0,w:0.0};}};
case 1531: return function (act:Int) {switch (act) { case 85: return {t:1635,w:0.693147}; case 117: return {t:1635,w:0.693147};default: return {t:0,w:0.0};}};
case 1532: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1636,w:0.693147}; case 384: return {t:1637,w:0.693147};default: return {t:0,w:0.0};}};
case 1533: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1636,w:0.693147}; case 384: return {t:1637,w:0.693147};default: return {t:0,w:0.0};}};
case 1534: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1636,w:0.693147}; case 384: return {t:1637,w:0.693147};default: return {t:0,w:0.0};}};
case 1535: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:1638,w:1.386294}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:1639,w:1.386294}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:862,w:0.693147}; case 404: return {t:1640,w:0.693147};default: return {t:0,w:0.0};}};
case 1536: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1398,w:0.693147}; case 384: return {t:1399,w:0.693147};default: return {t:0,w:0.0};}};
case 1537: return function (act:Int) {switch (act) { case 256: return {t:1641,w:4000000.000000}; case 489: return {t:1642,w:0.000000};default: return {t:0,w:0.0};}};
case 1538: return function (act:Int) {switch (act) { case 73: return {t:1643,w:0.693147}; case 105: return {t:1643,w:0.693147};default: return {t:0,w:0.0};}};
case 1539: return function (act:Int) {switch (act) { case 79: return {t:1644,w:0.693147}; case 111: return {t:1644,w:0.693147};default: return {t:0,w:0.0};}};
case 1540: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:833,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 379: return {t:1645,w:0.000000};default: return {t:0,w:0.0};}};
case 1541: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1646,w:0.693147}; case 375: return {t:1647,w:0.693147};default: return {t:0,w:0.0};}};
case 1542: return function (act:Int) {switch (act) { case 80: return {t:1648,w:0.693147}; case 112: return {t:1648,w:0.693147};default: return {t:0,w:0.0};}};
case 1543: return function (act:Int) {switch (act) { case 79: return {t:1649,w:0.693147}; case 111: return {t:1649,w:0.693147};default: return {t:0,w:0.0};}};
case 1544: return function (act:Int) {switch (act) { case 71: return {t:1650,w:0.693147}; case 103: return {t:1650,w:0.693147};default: return {t:0,w:0.0};}};
case 1545: return function (act:Int) {switch (act) { case 71: return {t:1651,w:0.693147}; case 103: return {t:1651,w:0.693147};default: return {t:0,w:0.0};}};
case 1546: return function (act:Int) {switch (act) { case 69: return {t:1652,w:0.693147}; case 101: return {t:1652,w:0.693147};default: return {t:0,w:0.0};}};
case 1547: return function (act:Int) {switch (act) { case 73: return {t:1653,w:0.693147}; case 105: return {t:1653,w:0.693147};default: return {t:0,w:0.0};}};
case 1548: return function (act:Int) {switch (act) { case 84: return {t:1654,w:0.693147}; case 116: return {t:1654,w:0.693147};default: return {t:0,w:0.0};}};
case 1549: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.772588}; case 13: return {t:83,w:2.772588}; case 32: return {t:494,w:2.772588}; case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 258: return {t:651,w:1.386294}; case 268: return {t:29,w:3.091042}; case 269: return {t:1655,w:0.693147}; case 279: return {t:504,w:2.772588}; case 283: return {t:119,w:2.772588}; case 368: return {t:1291,w:0.693147}; case 376: return {t:505,w:2.079441}; case 377: return {t:506,w:1.386294}; case 378: return {t:1656,w:0.693147};default: return {t:0,w:0.0};}};
case 1550: return function (act:Int) {switch (act) { case 258: return {t:1657,w:0.000000};default: return {t:0,w:0.0};}};
case 1551: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1658,w:0.000000};default: return {t:0,w:0.0};}};
case 1552: return function (act:Int) {switch (act) { case 256: return {t:1659,w:4000000.000000}; case 490: return {t:1660,w:0.000000};default: return {t:0,w:0.0};}};
case 1553: return function (act:Int) {switch (act) { case 256: return {t:1661,w:4000000.000000}; case 491: return {t:1662,w:0.000000};default: return {t:0,w:0.0};}};
case 1554: return function (act:Int) {switch (act) { case 451: return {t:1554,w:0.000000};default: return {t:0,w:0.0};}};
case 1555: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1554,w:0.693147}; case 336: return {t:1555,w:0.693147};default: return {t:0,w:0.0};}};
case 1556: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1663,w:0.000000};default: return {t:0,w:0.0};}};
case 1557: return function (act:Int) {switch (act) { case 83: return {t:1664,w:0.693147}; case 115: return {t:1664,w:0.693147};default: return {t:0,w:0.0};}};
case 1558: return function (act:Int) {switch (act) { case 78: return {t:1665,w:0.693147}; case 110: return {t:1665,w:0.693147};default: return {t:0,w:0.0};}};
case 1559: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1666,w:0.000000};default: return {t:0,w:0.0};}};
case 1560: return function (act:Int) {switch (act) { case 69: return {t:1667,w:0.693147}; case 101: return {t:1667,w:0.693147};default: return {t:0,w:0.0};}};
case 1561: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1562,w:0.693147}; case 336: return {t:1668,w:0.693147};default: return {t:0,w:0.0};}};
case 1562: return function (act:Int) {switch (act) { case 452: return {t:1562,w:0.000000};default: return {t:0,w:0.0};}};
case 1563: return function (act:Int) {switch (act) { case 48: return {t:1669,w:0.693147}; case 258: return {t:1562,w:0.693147};default: return {t:0,w:0.0};}};
case 1564: return function (act:Int) {switch (act) { case 78: return {t:1670,w:0.693147}; case 110: return {t:1670,w:0.693147};default: return {t:0,w:0.0};}};
case 1565: return function (act:Int) {switch (act) { case 77: return {t:1671,w:0.693147}; case 109: return {t:1671,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1566: return function (act:Int) {switch (act) { case 79: return {t:1672,w:0.693147}; case 111: return {t:1672,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1567: return function (act:Int) {switch (act) { case 82: return {t:1673,w:0.693147}; case 114: return {t:1673,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1568: return function (act:Int) {switch (act) { case 77: return {t:1671,w:0.693147}; case 109: return {t:1671,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1569: return function (act:Int) {switch (act) { case 79: return {t:1672,w:0.693147}; case 111: return {t:1672,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1570: return function (act:Int) {switch (act) { case 82: return {t:1673,w:0.693147}; case 114: return {t:1673,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1571: return function (act:Int) {switch (act) { case 258: return {t:1674,w:0.000000};default: return {t:0,w:0.0};}};
case 1572: return function (act:Int) {switch (act) { case 258: return {t:1675,w:0.000000};default: return {t:0,w:0.0};}};
case 1573: return function (act:Int) {switch (act) { case 309: return {t:1573,w:0.000000};default: return {t:0,w:0.0};}};
case 1574: return function (act:Int) {switch (act) { case 78: return {t:1676,w:0.693147}; case 110: return {t:1676,w:0.693147};default: return {t:0,w:0.0};}};
case 1575: return function (act:Int) {switch (act) { case 82: return {t:1677,w:0.693147}; case 114: return {t:1677,w:0.693147};default: return {t:0,w:0.0};}};
case 1576: return function (act:Int) {switch (act) { case 82: return {t:1678,w:0.693147}; case 114: return {t:1678,w:0.693147};default: return {t:0,w:0.0};}};
case 1577: return function (act:Int) {switch (act) { case 69: return {t:1679,w:0.693147}; case 101: return {t:1679,w:0.693147};default: return {t:0,w:0.0};}};
case 1578: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1680,w:0.693147}; case 384: return {t:1681,w:0.693147};default: return {t:0,w:0.0};}};
case 1579: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1680,w:0.693147}; case 384: return {t:1681,w:0.693147};default: return {t:0,w:0.0};}};
case 1580: return function (act:Int) {switch (act) { case 314: return {t:1580,w:0.000000};default: return {t:0,w:0.0};}};
case 1581: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1437,w:0.693147}; case 375: return {t:1438,w:0.693147};default: return {t:0,w:0.0};}};
case 1582: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1682,w:0.000000};default: return {t:0,w:0.0};}};
case 1583: return function (act:Int) {switch (act) { case 258: return {t:1683,w:0.000000};default: return {t:0,w:0.0};}};
case 1584: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:1684,w:0.000000};default: return {t:0,w:0.0};}};
case 1585: return function (act:Int) {switch (act) { case 258: return {t:1442,w:0.000000};default: return {t:0,w:0.0};}};
case 1586: return function (act:Int) {switch (act) { case 258: return {t:1685,w:0.000000};default: return {t:0,w:0.0};}};
case 1587: return function (act:Int) {switch (act) { case 258: return {t:1686,w:0.000000};default: return {t:0,w:0.0};}};
case 1588: return function (act:Int) {switch (act) { case 258: return {t:1686,w:0.000000};default: return {t:0,w:0.0};}};
case 1589: return function (act:Int) {switch (act) { case 258: return {t:1686,w:0.000000};default: return {t:0,w:0.0};}};
case 1590: return function (act:Int) {switch (act) { case 258: return {t:1687,w:0.000000};default: return {t:0,w:0.0};}};
case 1591: return function (act:Int) {switch (act) { case 40: return {t:1444,w:1.000000}; case 41: return {t:1688,w:0.000000};default: return {t:0,w:0.0};}};
case 1592: return function (act:Int) {switch (act) { case 258: return {t:1686,w:0.000000};default: return {t:0,w:0.0};}};
case 1593: return function (act:Int) {switch (act) { case 454: return {t:1593,w:0.000000};default: return {t:0,w:0.0};}};
case 1594: return function (act:Int) {switch (act) { case 46: return {t:1689,w:1.386294}; case 256: return {t:1690,w:4000000.750000}; case 258: return {t:1691,w:2.079441}; case 336: return {t:1692,w:0.693147}; case 377: return {t:1693,w:2.079441};default: return {t:0,w:0.0};}};
case 1595: return function (act:Int) {switch (act) { case 405: return {t:1595,w:0.000000};default: return {t:0,w:0.0};}};
case 1596: return function (act:Int) {switch (act) { case 428: return {t:1596,w:0.000000};default: return {t:0,w:0.0};}};
case 1597: return function (act:Int) {switch (act) { case 48: return {t:9,w:8.151197}; case 49: return {t:9,w:8.151197}; case 50: return {t:9,w:8.151197}; case 51: return {t:9,w:8.151197}; case 52: return {t:9,w:8.151197}; case 53: return {t:9,w:8.151197}; case 54: return {t:9,w:8.151197}; case 55: return {t:9,w:8.151197}; case 56: return {t:9,w:8.151197}; case 57: return {t:9,w:8.151197}; case 65: return {t:13,w:9.106709}; case 66: return {t:13,w:9.106709}; case 67: return {t:13,w:9.106709}; case 68: return {t:13,w:9.106709}; case 69: return {t:13,w:9.106709}; case 70: return {t:13,w:9.106709}; case 71: return {t:13,w:9.106709}; case 72: return {t:13,w:9.106709}; case 73: return {t:13,w:9.106709}; case 74: return {t:13,w:9.106709}; case 75: return {t:13,w:9.106709}; case 76: return {t:13,w:9.106709}; case 77: return {t:13,w:9.106709}; case 78: return {t:13,w:9.106709}; case 79: return {t:13,w:9.106709}; case 80: return {t:13,w:9.106709}; case 81: return {t:13,w:9.106709}; case 82: return {t:13,w:9.106709}; case 83: return {t:13,w:9.106709}; case 84: return {t:13,w:9.106709}; case 85: return {t:13,w:9.106709}; case 86: return {t:13,w:9.106709}; case 87: return {t:13,w:9.106709}; case 88: return {t:13,w:9.106709}; case 89: return {t:13,w:9.106709}; case 90: return {t:13,w:9.106709}; case 97: return {t:20,w:9.106709}; case 98: return {t:20,w:9.106709}; case 99: return {t:20,w:9.106709}; case 100: return {t:20,w:9.106709}; case 101: return {t:20,w:9.106709}; case 102: return {t:20,w:9.106709}; case 103: return {t:20,w:9.106709}; case 104: return {t:20,w:9.106709}; case 105: return {t:20,w:9.106709}; case 106: return {t:20,w:9.106709}; case 107: return {t:20,w:9.106709}; case 108: return {t:20,w:9.106709}; case 109: return {t:20,w:9.106709}; case 110: return {t:20,w:9.106709}; case 111: return {t:20,w:9.106709}; case 112: return {t:20,w:9.106709}; case 113: return {t:20,w:9.106709}; case 114: return {t:20,w:9.106709}; case 115: return {t:20,w:9.106709}; case 116: return {t:20,w:9.106709}; case 117: return {t:20,w:9.106709}; case 118: return {t:20,w:9.106709}; case 119: return {t:20,w:9.106709}; case 120: return {t:20,w:9.106709}; case 121: return {t:20,w:9.106709}; case 122: return {t:20,w:9.106709}; case 258: return {t:1333,w:0.000000};default: return {t:0,w:0.0};}};
case 1598: return function (act:Int) {switch (act) { case 269: return {t:50,w:3.004031}; case 410: return {t:1035,w:0.000000};default: return {t:0,w:0.0};}};
case 1599: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1694,w:0.000000};default: return {t:0,w:0.0};}};
case 1600: return function (act:Int) {switch (act) { case 256: return {t:1156,w:4000000.000000}; case 436: return {t:1695,w:0.000000};default: return {t:0,w:0.0};}};
case 1601: return function (act:Int) {switch (act) { case 80: return {t:1696,w:0.693147}; case 112: return {t:1696,w:0.693147};default: return {t:0,w:0.0};}};
case 1602: return function (act:Int) {switch (act) { case 258: return {t:1468,w:0.000000};default: return {t:0,w:0.0};}};
case 1603: return function (act:Int) {switch (act) { case 258: return {t:1468,w:0.000000};default: return {t:0,w:0.0};}};
case 1604: return function (act:Int) {switch (act) { case 258: return {t:1468,w:0.000000};default: return {t:0,w:0.0};}};
case 1605: return function (act:Int) {switch (act) { case 258: return {t:1697,w:0.000000};default: return {t:0,w:0.0};}};
case 1606: return function (act:Int) {switch (act) { case 78: return {t:1698,w:0.693147}; case 110: return {t:1698,w:0.693147};default: return {t:0,w:0.0};}};
case 1607: return function (act:Int) {switch (act) { case 68: return {t:1699,w:0.693147}; case 100: return {t:1699,w:0.693147};default: return {t:0,w:0.0};}};
case 1608: return function (act:Int) {switch (act) { case 69: return {t:1700,w:0.693147}; case 101: return {t:1700,w:0.693147};default: return {t:0,w:0.0};}};
case 1609: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:1701,w:0.000000};default: return {t:0,w:0.0};}};
case 1610: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1702,w:0.000000};default: return {t:0,w:0.0};}};
case 1611: return function (act:Int) {switch (act) { case 256: return {t:1703,w:4000000.000000}; case 492: return {t:1704,w:0.000000};default: return {t:0,w:0.0};}};
case 1612: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1478,w:0.693147}; case 375: return {t:1479,w:0.693147};default: return {t:0,w:0.0};}};
case 1613: return function (act:Int) {switch (act) { case 73: return {t:1705,w:0.693147}; case 105: return {t:1705,w:0.693147};default: return {t:0,w:0.0};}};
case 1614: return function (act:Int) {switch (act) { case 258: return {t:1324,w:0.000000};default: return {t:0,w:0.0};}};
case 1615: return function (act:Int) {switch (act) { case 258: return {t:1329,w:0.000000};default: return {t:0,w:0.0};}};
case 1616: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1706,w:0.000000};default: return {t:0,w:0.0};}};
case 1617: return function (act:Int) {switch (act) { case 46: return {t:1616,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:1707,w:0.693147};default: return {t:0,w:0.0};}};
case 1618: return function (act:Int) {switch (act) { case 468: return {t:1618,w:0.000000};default: return {t:0,w:0.0};}};
case 1619: return function (act:Int) {switch (act) { case 68: return {t:1708,w:0.693147}; case 100: return {t:1708,w:0.693147};default: return {t:0,w:0.0};}};
case 1620: return function (act:Int) {switch (act) { case 72: return {t:1709,w:0.693147}; case 104: return {t:1709,w:0.693147};default: return {t:0,w:0.0};}};
case 1621: return function (act:Int) {switch (act) { case 78: return {t:1710,w:0.693147}; case 110: return {t:1710,w:0.693147};default: return {t:0,w:0.0};}};
case 1622: return function (act:Int) {switch (act) { case 61: return {t:1711,w:0.000000};default: return {t:0,w:0.0};}};
case 1623: return function (act:Int) {switch (act) { case 82: return {t:1712,w:0.693147}; case 114: return {t:1712,w:0.693147};default: return {t:0,w:0.0};}};
case 1624: return function (act:Int) {switch (act) { case 33: return {t:420,w:3.178054}; case 36: return {t:1346,w:3.044522}; case 37: return {t:422,w:1.098612}; case 38: return {t:1347,w:3.044522}; case 39: return {t:424,w:4.564348}; case 40: return {t:424,w:4.564348}; case 41: return {t:424,w:4.564348}; case 42: return {t:424,w:4.564348}; case 43: return {t:1348,w:3.044522}; case 45: return {t:426,w:3.871201}; case 46: return {t:426,w:3.871201}; case 47: return {t:1349,w:3.044522}; case 48: return {t:428,w:5.480639}; case 49: return {t:428,w:5.480639}; case 50: return {t:428,w:5.480639}; case 51: return {t:428,w:5.480639}; case 52: return {t:428,w:5.480639}; case 53: return {t:428,w:5.480639}; case 54: return {t:428,w:5.480639}; case 55: return {t:428,w:5.480639}; case 56: return {t:428,w:5.480639}; case 57: return {t:428,w:5.480639}; case 58: return {t:1350,w:3.044522}; case 65: return {t:432,w:6.436151}; case 66: return {t:432,w:6.436151}; case 67: return {t:432,w:6.436151}; case 68: return {t:432,w:6.436151}; case 69: return {t:432,w:6.436151}; case 70: return {t:432,w:6.436151}; case 71: return {t:432,w:6.436151}; case 72: return {t:432,w:6.436151}; case 73: return {t:432,w:6.436151}; case 74: return {t:432,w:6.436151}; case 75: return {t:432,w:6.436151}; case 76: return {t:432,w:6.436151}; case 77: return {t:432,w:6.436151}; case 78: return {t:432,w:6.436151}; case 79: return {t:432,w:6.436151}; case 80: return {t:432,w:6.436151}; case 81: return {t:432,w:6.436151}; case 82: return {t:432,w:6.436151}; case 83: return {t:432,w:6.436151}; case 84: return {t:432,w:6.436151}; case 85: return {t:432,w:6.436151}; case 86: return {t:432,w:6.436151}; case 87: return {t:432,w:6.436151}; case 88: return {t:432,w:6.436151}; case 89: return {t:432,w:6.436151}; case 90: return {t:432,w:6.436151}; case 91: return {t:1355,w:3.044522}; case 93: return {t:1356,w:3.044522}; case 95: return {t:433,w:3.178054}; case 97: return {t:434,w:6.436151}; case 98: return {t:434,w:6.436151}; case 99: return {t:434,w:6.436151}; case 100: return {t:434,w:6.436151}; case 101: return {t:434,w:6.436151}; case 102: return {t:434,w:6.436151}; case 103: return {t:434,w:6.436151}; case 104: return {t:434,w:6.436151}; case 105: return {t:434,w:6.436151}; case 106: return {t:434,w:6.436151}; case 107: return {t:434,w:6.436151}; case 108: return {t:434,w:6.436151}; case 109: return {t:434,w:6.436151}; case 110: return {t:434,w:6.436151}; case 111: return {t:434,w:6.436151}; case 112: return {t:434,w:6.436151}; case 113: return {t:434,w:6.436151}; case 114: return {t:434,w:6.436151}; case 115: return {t:434,w:6.436151}; case 116: return {t:434,w:6.436151}; case 117: return {t:434,w:6.436151}; case 118: return {t:434,w:6.436151}; case 119: return {t:434,w:6.436151}; case 120: return {t:434,w:6.436151}; case 121: return {t:434,w:6.436151}; case 122: return {t:434,w:6.436151}; case 126: return {t:435,w:3.178054}; case 363: return {t:1361,w:1.098612}; case 364: return {t:1362,w:1.098612}; case 469: return {t:1369,w:1.098612}; case 470: return {t:1713,w:0.000000};default: return {t:0,w:0.0};}};
case 1625: return function (act:Int) {switch (act) { case 258: return {t:1514,w:0.000000};default: return {t:0,w:0.0};}};
case 1626: return function (act:Int) {switch (act) { case 481: return {t:1626,w:0.000000};default: return {t:0,w:0.0};}};
case 1627: return function (act:Int) {switch (act) { case 33: return {t:420,w:2.079442}; case 36: return {t:1516,w:1.945910}; case 37: return {t:422,w:0.000000}; case 39: return {t:424,w:3.465736}; case 40: return {t:424,w:3.465736}; case 41: return {t:424,w:3.465736}; case 42: return {t:424,w:3.465736}; case 43: return {t:1517,w:1.945910}; case 45: return {t:426,w:2.772589}; case 46: return {t:426,w:2.772589}; case 47: return {t:1518,w:1.945910}; case 48: return {t:428,w:4.382027}; case 49: return {t:428,w:4.382027}; case 50: return {t:428,w:4.382027}; case 51: return {t:428,w:4.382027}; case 52: return {t:428,w:4.382027}; case 53: return {t:428,w:4.382027}; case 54: return {t:428,w:4.382027}; case 55: return {t:428,w:4.382027}; case 56: return {t:428,w:4.382027}; case 57: return {t:428,w:4.382027}; case 58: return {t:1519,w:1.945910}; case 63: return {t:1520,w:1.945910}; case 65: return {t:432,w:5.337539}; case 66: return {t:432,w:5.337539}; case 67: return {t:432,w:5.337539}; case 68: return {t:432,w:5.337539}; case 69: return {t:432,w:5.337539}; case 70: return {t:432,w:5.337539}; case 71: return {t:432,w:5.337539}; case 72: return {t:432,w:5.337539}; case 73: return {t:432,w:5.337539}; case 74: return {t:432,w:5.337539}; case 75: return {t:432,w:5.337539}; case 76: return {t:432,w:5.337539}; case 77: return {t:432,w:5.337539}; case 78: return {t:432,w:5.337539}; case 79: return {t:432,w:5.337539}; case 80: return {t:432,w:5.337539}; case 81: return {t:432,w:5.337539}; case 82: return {t:432,w:5.337539}; case 83: return {t:432,w:5.337539}; case 84: return {t:432,w:5.337539}; case 85: return {t:432,w:5.337539}; case 86: return {t:432,w:5.337539}; case 87: return {t:432,w:5.337539}; case 88: return {t:432,w:5.337539}; case 89: return {t:432,w:5.337539}; case 90: return {t:432,w:5.337539}; case 91: return {t:1521,w:1.945910}; case 93: return {t:1522,w:1.945910}; case 95: return {t:433,w:2.079442}; case 97: return {t:434,w:5.337539}; case 98: return {t:434,w:5.337539}; case 99: return {t:434,w:5.337539}; case 100: return {t:434,w:5.337539}; case 101: return {t:434,w:5.337539}; case 102: return {t:434,w:5.337539}; case 103: return {t:434,w:5.337539}; case 104: return {t:434,w:5.337539}; case 105: return {t:434,w:5.337539}; case 106: return {t:434,w:5.337539}; case 107: return {t:434,w:5.337539}; case 108: return {t:434,w:5.337539}; case 109: return {t:434,w:5.337539}; case 110: return {t:434,w:5.337539}; case 111: return {t:434,w:5.337539}; case 112: return {t:434,w:5.337539}; case 113: return {t:434,w:5.337539}; case 114: return {t:434,w:5.337539}; case 115: return {t:434,w:5.337539}; case 116: return {t:434,w:5.337539}; case 117: return {t:434,w:5.337539}; case 118: return {t:434,w:5.337539}; case 119: return {t:434,w:5.337539}; case 120: return {t:434,w:5.337539}; case 121: return {t:434,w:5.337539}; case 122: return {t:434,w:5.337539}; case 126: return {t:435,w:2.079442};default: return {t:0,w:0.0};}};
case 1628: return function (act:Int) {switch (act) { case 482: return {t:1628,w:0.000000};default: return {t:0,w:0.0};}};
case 1629: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1628,w:0.693147}; case 363: return {t:1629,w:1.791759}; case 364: return {t:1630,w:1.791759}; case 481: return {t:1631,w:1.791759};default: return {t:0,w:0.0};}};
case 1630: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1628,w:0.693147}; case 363: return {t:1629,w:1.791759}; case 364: return {t:1630,w:1.791759}; case 481: return {t:1631,w:1.791759};default: return {t:0,w:0.0};}};
case 1631: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1628,w:0.693147}; case 363: return {t:1629,w:1.791759}; case 364: return {t:1630,w:1.791759}; case 481: return {t:1631,w:1.791759};default: return {t:0,w:0.0};}};
case 1632: return function (act:Int) {switch (act) { case 256: return {t:1714,w:4000000.000000}; case 493: return {t:1715,w:0.000000};default: return {t:0,w:0.0};}};
case 1633: return function (act:Int) {switch (act) { case 38: return {t:1527,w:0.693147}; case 258: return {t:1528,w:0.693147};default: return {t:0,w:0.0};}};
case 1634: return function (act:Int) {switch (act) { case 73: return {t:1716,w:0.693147}; case 105: return {t:1716,w:0.693147};default: return {t:0,w:0.0};}};
case 1635: return function (act:Int) {switch (act) { case 65: return {t:1717,w:0.693147}; case 97: return {t:1717,w:0.693147};default: return {t:0,w:0.0};}};
case 1636: return function (act:Int) {switch (act) { case 449: return {t:1636,w:0.000000};default: return {t:0,w:0.0};}};
case 1637: return function (act:Int) {switch (act) { case 256: return {t:1117,w:4000000.000000}; case 435: return {t:1718,w:0.000000};default: return {t:0,w:0.0};}};
case 1638: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 258: return {t:52,w:6.061458}; case 428: return {t:1719,w:0.000000};default: return {t:0,w:0.0};}};
case 1639: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 258: return {t:52,w:6.061458}; case 428: return {t:1719,w:0.000000};default: return {t:0,w:0.0};}};
case 1640: return function (act:Int) {switch (act) { case 258: return {t:1720,w:0.000000};default: return {t:0,w:0.0};}};
case 1641: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:833,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 379: return {t:1721,w:0.000000};default: return {t:0,w:0.0};}};
case 1642: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1722,w:0.693147}; case 375: return {t:1723,w:0.693147};default: return {t:0,w:0.0};}};
case 1643: return function (act:Int) {switch (act) { case 79: return {t:1724,w:0.693147}; case 111: return {t:1724,w:0.693147};default: return {t:0,w:0.0};}};
case 1644: return function (act:Int) {switch (act) { case 78: return {t:1725,w:0.693147}; case 110: return {t:1725,w:0.693147};default: return {t:0,w:0.0};}};
case 1645: return function (act:Int) {switch (act) { case 256: return {t:1726,w:4000000.000000}; case 335: return {t:1727,w:0.000000};default: return {t:0,w:0.0};}};
case 1646: return function (act:Int) {switch (act) { case 292: return {t:1646,w:0.000000};default: return {t:0,w:0.0};}};
case 1647: return function (act:Int) {switch (act) { case 256: return {t:1540,w:4000000.000000}; case 484: return {t:1728,w:0.000000};default: return {t:0,w:0.0};}};
case 1648: return function (act:Int) {switch (act) { case 79: return {t:1729,w:0.693147}; case 111: return {t:1729,w:0.693147};default: return {t:0,w:0.0};}};
case 1649: return function (act:Int) {switch (act) { case 68: return {t:1730,w:0.693147}; case 100: return {t:1730,w:0.693147};default: return {t:0,w:0.0};}};
case 1650: return function (act:Int) {switch (act) { case 85: return {t:1731,w:0.693147}; case 117: return {t:1731,w:0.693147};default: return {t:0,w:0.0};}};
case 1651: return function (act:Int) {switch (act) { case 84: return {t:1732,w:0.693147}; case 116: return {t:1732,w:0.693147};default: return {t:0,w:0.0};}};
case 1652: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:213,w:0.000000};default: return {t:0,w:0.0};}};
case 1653: return function (act:Int) {switch (act) { case 79: return {t:1733,w:0.693147}; case 111: return {t:1733,w:0.693147};default: return {t:0,w:0.0};}};
case 1654: return function (act:Int) {switch (act) { case 258: return {t:815,w:0.000000};default: return {t:0,w:0.0};}};
case 1655: return function (act:Int) {switch (act) { case 258: return {t:1734,w:0.000000};default: return {t:0,w:0.0};}};
case 1656: return function (act:Int) {switch (act) { case 258: return {t:1734,w:0.000000};default: return {t:0,w:0.0};}};
case 1657: return function (act:Int) {switch (act) { case 435: return {t:1657,w:0.000000};default: return {t:0,w:0.0};}};
case 1658: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:1735,w:0.000000};default: return {t:0,w:0.0};}};
case 1659: return function (act:Int) {switch (act) { case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 336: return {t:1736,w:0.000000};default: return {t:0,w:0.0};}};
case 1660: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:1737,w:0.000000};default: return {t:0,w:0.0};}};
case 1661: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:833,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 379: return {t:1738,w:0.000000};default: return {t:0,w:0.0};}};
case 1662: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1739,w:0.693147}; case 375: return {t:1740,w:0.693147};default: return {t:0,w:0.0};}};
case 1663: return function (act:Int) {switch (act) { case 256: return {t:311,w:4000000.000000}; case 352: return {t:1741,w:0.000000};default: return {t:0,w:0.0};}};
case 1664: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1742,w:0.000000};default: return {t:0,w:0.0};}};
case 1665: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1743,w:0.000000};default: return {t:0,w:0.0};}};
case 1666: return function (act:Int) {switch (act) { case 256: return {t:1252,w:4000000.000000}; case 451: return {t:1744,w:0.000000};default: return {t:0,w:0.0};}};
case 1667: return function (act:Int) {switch (act) { case 83: return {t:1745,w:0.693147}; case 115: return {t:1745,w:0.693147};default: return {t:0,w:0.0};}};
case 1668: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1562,w:0.693147}; case 336: return {t:1746,w:0.693147};default: return {t:0,w:0.0};}};
case 1669: return function (act:Int) {switch (act) { case 48: return {t:1747,w:0.693147}; case 258: return {t:1562,w:0.693147};default: return {t:0,w:0.0};}};
case 1670: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1748,w:0.000000};default: return {t:0,w:0.0};}};
case 1671: return function (act:Int) {switch (act) { case 69: return {t:1749,w:0.693147}; case 101: return {t:1749,w:0.693147};default: return {t:0,w:0.0};}};
case 1672: return function (act:Int) {switch (act) { case 78: return {t:1750,w:0.693147}; case 82: return {t:1751,w:0.693147}; case 110: return {t:1750,w:0.693147}; case 114: return {t:1751,w:0.693147};default: return {t:0,w:0.0};}};
case 1673: return function (act:Int) {switch (act) { case 71: return {t:1752,w:0.693147}; case 103: return {t:1752,w:0.693147};default: return {t:0,w:0.0};}};
case 1674: return function (act:Int) {switch (act) { case 486: return {t:1674,w:0.000000};default: return {t:0,w:0.0};}};
case 1675: return function (act:Int) {switch (act) { case 475: return {t:1675,w:0.000000};default: return {t:0,w:0.0};}};
case 1676: return function (act:Int) {switch (act) { case 84: return {t:1753,w:0.693147}; case 116: return {t:1753,w:0.693147};default: return {t:0,w:0.0};}};
case 1677: return function (act:Int) {switch (act) { case 73: return {t:1754,w:0.693147}; case 105: return {t:1754,w:0.693147};default: return {t:0,w:0.0};}};
case 1678: return function (act:Int) {switch (act) { case 69: return {t:1755,w:0.693147}; case 101: return {t:1755,w:0.693147};default: return {t:0,w:0.0};}};
case 1679: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1756,w:0.000000};default: return {t:0,w:0.0};}};
case 1680: return function (act:Int) {switch (act) { case 476: return {t:1680,w:0.000000};default: return {t:0,w:0.0};}};
case 1681: return function (act:Int) {switch (act) { case 256: return {t:1757,w:4000000.000000}; case 494: return {t:1758,w:0.000000};default: return {t:0,w:0.0};}};
case 1682: return function (act:Int) {switch (act) { case 256: return {t:1252,w:4000000.000000}; case 451: return {t:1759,w:0.000000};default: return {t:0,w:0.0};}};
case 1683: return function (act:Int) {switch (act) { case 477: return {t:1683,w:0.000000};default: return {t:0,w:0.0};}};
case 1684: return function (act:Int) {switch (act) { case 258: return {t:1760,w:0.000000};default: return {t:0,w:0.0};}};
case 1685: return function (act:Int) {switch (act) { case 453: return {t:1685,w:0.000000};default: return {t:0,w:0.0};}};
case 1686: return function (act:Int) {switch (act) { case 478: return {t:1686,w:0.000000};default: return {t:0,w:0.0};}};
case 1687: return function (act:Int) {switch (act) { case 368: return {t:685,w:0.000000}; case 478: return {t:1686,w:1.916291};default: return {t:0,w:0.0};}};
case 1688: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:1761,w:0.000000};default: return {t:0,w:0.0};}};
case 1689: return function (act:Int) {switch (act) { case 256: return {t:1762,w:4000000.750000}; case 258: return {t:1691,w:1.386294}; case 336: return {t:1763,w:0.693147}; case 377: return {t:1693,w:1.386294};default: return {t:0,w:0.0};}};
case 1690: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.886294}; case 13: return {t:83,w:2.886294}; case 32: return {t:494,w:2.886294}; case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 279: return {t:504,w:2.886294}; case 283: return {t:119,w:2.886294}; case 376: return {t:505,w:2.193147};default: return {t:0,w:0.0};}};
case 1691: return function (act:Int) {switch (act) { case 321: return {t:1691,w:0.000000};default: return {t:0,w:0.0};}};
case 1692: return function (act:Int) {switch (act) { case 46: return {t:1689,w:1.386294}; case 256: return {t:1690,w:4000000.750000}; case 258: return {t:1691,w:2.079441}; case 336: return {t:1692,w:0.693147}; case 377: return {t:1693,w:2.079441};default: return {t:0,w:0.0};}};
case 1693: return function (act:Int) {switch (act) { case 256: return {t:1764,w:4000000.000000}; case 495: return {t:1765,w:0.000000};default: return {t:0,w:0.0};}};
case 1694: return function (act:Int) {switch (act) { case 256: return {t:313,w:4000000.000000}; case 353: return {t:1766,w:0.000000};default: return {t:0,w:0.0};}};
case 1695: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.750000}; case 258: return {t:1767,w:0.693147}; case 377: return {t:1768,w:0.693147};default: return {t:0,w:0.0};}};
case 1696: return function (act:Int) {switch (act) { case 258: return {t:1468,w:0.000000};default: return {t:0,w:0.0};}};
case 1697: return function (act:Int) {switch (act) { case 439: return {t:1697,w:0.000000};default: return {t:0,w:0.0};}};
case 1698: return function (act:Int) {switch (act) { case 67: return {t:1769,w:0.693147}; case 99: return {t:1769,w:0.693147};default: return {t:0,w:0.0};}};
case 1699: return function (act:Int) {switch (act) { case 82: return {t:1770,w:0.693147}; case 114: return {t:1770,w:0.693147};default: return {t:0,w:0.0};}};
case 1700: return function (act:Int) {switch (act) { case 73: return {t:1771,w:0.693147}; case 105: return {t:1771,w:0.693147};default: return {t:0,w:0.0};}};
case 1701: return function (act:Int) {switch (act) { case 256: return {t:1772,w:4000000.000000}; case 496: return {t:1773,w:0.000000};default: return {t:0,w:0.0};}};
case 1702: return function (act:Int) {switch (act) { case 258: return {t:1774,w:0.000000};default: return {t:0,w:0.0};}};
case 1703: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:1285,w:4.094344}; case 49: return {t:1285,w:4.094344}; case 50: return {t:1285,w:4.094344}; case 51: return {t:1285,w:4.094344}; case 52: return {t:1285,w:4.094344}; case 53: return {t:1285,w:4.094344}; case 54: return {t:1285,w:4.094344}; case 55: return {t:1285,w:4.094344}; case 56: return {t:1285,w:4.094344}; case 57: return {t:1285,w:4.094344}; case 65: return {t:1286,w:7.129297}; case 66: return {t:1286,w:7.129297}; case 67: return {t:1286,w:7.129297}; case 68: return {t:1286,w:7.129297}; case 69: return {t:1286,w:7.129297}; case 70: return {t:1286,w:7.129297}; case 71: return {t:1286,w:7.129297}; case 72: return {t:1286,w:7.129297}; case 73: return {t:1286,w:7.129297}; case 74: return {t:1286,w:7.129297}; case 75: return {t:1286,w:7.129297}; case 76: return {t:1286,w:7.129297}; case 77: return {t:1286,w:7.129297}; case 78: return {t:1286,w:7.129297}; case 79: return {t:1286,w:7.129297}; case 80: return {t:1286,w:7.129297}; case 81: return {t:1286,w:7.129297}; case 82: return {t:1286,w:7.129297}; case 83: return {t:1286,w:7.129297}; case 84: return {t:1286,w:7.129297}; case 85: return {t:1286,w:7.129297}; case 86: return {t:1286,w:7.129297}; case 87: return {t:1286,w:7.129297}; case 88: return {t:1286,w:7.129297}; case 89: return {t:1286,w:7.129297}; case 90: return {t:1286,w:7.129297}; case 91: return {t:884,w:1.791759}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:1287,w:7.129297}; case 98: return {t:1287,w:7.129297}; case 99: return {t:1287,w:7.129297}; case 100: return {t:1287,w:7.129297}; case 101: return {t:1287,w:7.129297}; case 102: return {t:1287,w:7.129297}; case 103: return {t:1287,w:7.129297}; case 104: return {t:1287,w:7.129297}; case 105: return {t:1287,w:7.129297}; case 106: return {t:1287,w:7.129297}; case 107: return {t:1287,w:7.129297}; case 108: return {t:1287,w:7.129297}; case 109: return {t:1287,w:7.129297}; case 110: return {t:1287,w:7.129297}; case 111: return {t:1287,w:7.129297}; case 112: return {t:1287,w:7.129297}; case 113: return {t:1287,w:7.129297}; case 114: return {t:1287,w:7.129297}; case 115: return {t:1287,w:7.129297}; case 116: return {t:1287,w:7.129297}; case 117: return {t:1287,w:7.129297}; case 118: return {t:1287,w:7.129297}; case 119: return {t:1287,w:7.129297}; case 120: return {t:1287,w:7.129297}; case 121: return {t:1287,w:7.129297}; case 122: return {t:1287,w:7.129297}; case 126: return {t:22,w:3.091042}; case 268: return {t:1288,w:3.091042}; case 269: return {t:1775,w:0.693147}; case 331: return {t:892,w:3.178053}; case 336: return {t:895,w:1.791759}; case 394: return {t:1776,w:0.693147}; case 410: return {t:891,w:2.484906}; case 411: return {t:893,w:2.484906}; case 412: return {t:894,w:1.791759}; case 413: return {t:896,w:1.791759}; case 414: return {t:897,w:1.791759}; case 415: return {t:898,w:0.693147}; case 497: return {t:1777,w:0.693147};default: return {t:0,w:0.0};}};
case 1704: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:1778,w:0.000000};default: return {t:0,w:0.0};}};
case 1705: return function (act:Int) {switch (act) { case 67: return {t:1779,w:0.693147}; case 99: return {t:1779,w:0.693147};default: return {t:0,w:0.0};}};
case 1706: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1780,w:0.693147}; case 336: return {t:1781,w:0.693147};default: return {t:0,w:0.0};}};
case 1707: return function (act:Int) {switch (act) { case 46: return {t:1616,w:0.000000};default: return {t:0,w:0.0};}};
case 1708: return function (act:Int) {switch (act) { case 82: return {t:1782,w:0.693147}; case 114: return {t:1782,w:0.693147};default: return {t:0,w:0.0};}};
case 1709: return function (act:Int) {switch (act) { case 79: return {t:1783,w:0.693147}; case 111: return {t:1783,w:0.693147};default: return {t:0,w:0.0};}};
case 1710: return function (act:Int) {switch (act) { case 83: return {t:1784,w:0.693147}; case 115: return {t:1784,w:0.693147};default: return {t:0,w:0.0};}};
case 1711: return function (act:Int) {switch (act) { case 256: return {t:1772,w:4000000.000000}; case 496: return {t:1785,w:0.000000};default: return {t:0,w:0.0};}};
case 1712: return function (act:Int) {switch (act) { case 61: return {t:1786,w:0.000000};default: return {t:0,w:0.0};}};
case 1713: return function (act:Int) {switch (act) { case 256: return {t:1510,w:4000000.750000}; case 258: return {t:1787,w:0.693147}; case 470: return {t:1788,w:0.693147};default: return {t:0,w:0.0};}};
case 1714: return function (act:Int) {switch (act) { case 33: return {t:420,w:3.871201}; case 36: return {t:1516,w:3.737669}; case 37: return {t:422,w:1.791759}; case 39: return {t:424,w:5.257495}; case 40: return {t:424,w:5.257495}; case 41: return {t:424,w:5.257495}; case 42: return {t:424,w:5.257495}; case 43: return {t:1517,w:3.737669}; case 45: return {t:426,w:4.564348}; case 46: return {t:426,w:4.564348}; case 47: return {t:1518,w:3.737669}; case 48: return {t:428,w:6.173786}; case 49: return {t:428,w:6.173786}; case 50: return {t:428,w:6.173786}; case 51: return {t:428,w:6.173786}; case 52: return {t:428,w:6.173786}; case 53: return {t:428,w:6.173786}; case 54: return {t:428,w:6.173786}; case 55: return {t:428,w:6.173786}; case 56: return {t:428,w:6.173786}; case 57: return {t:428,w:6.173786}; case 58: return {t:1519,w:3.737669}; case 63: return {t:1520,w:3.737669}; case 65: return {t:432,w:7.129298}; case 66: return {t:432,w:7.129298}; case 67: return {t:432,w:7.129298}; case 68: return {t:432,w:7.129298}; case 69: return {t:432,w:7.129298}; case 70: return {t:432,w:7.129298}; case 71: return {t:432,w:7.129298}; case 72: return {t:432,w:7.129298}; case 73: return {t:432,w:7.129298}; case 74: return {t:432,w:7.129298}; case 75: return {t:432,w:7.129298}; case 76: return {t:432,w:7.129298}; case 77: return {t:432,w:7.129298}; case 78: return {t:432,w:7.129298}; case 79: return {t:432,w:7.129298}; case 80: return {t:432,w:7.129298}; case 81: return {t:432,w:7.129298}; case 82: return {t:432,w:7.129298}; case 83: return {t:432,w:7.129298}; case 84: return {t:432,w:7.129298}; case 85: return {t:432,w:7.129298}; case 86: return {t:432,w:7.129298}; case 87: return {t:432,w:7.129298}; case 88: return {t:432,w:7.129298}; case 89: return {t:432,w:7.129298}; case 90: return {t:432,w:7.129298}; case 91: return {t:1521,w:3.737669}; case 93: return {t:1522,w:3.737669}; case 95: return {t:433,w:3.871201}; case 97: return {t:434,w:7.129298}; case 98: return {t:434,w:7.129298}; case 99: return {t:434,w:7.129298}; case 100: return {t:434,w:7.129298}; case 101: return {t:434,w:7.129298}; case 102: return {t:434,w:7.129298}; case 103: return {t:434,w:7.129298}; case 104: return {t:434,w:7.129298}; case 105: return {t:434,w:7.129298}; case 106: return {t:434,w:7.129298}; case 107: return {t:434,w:7.129298}; case 108: return {t:434,w:7.129298}; case 109: return {t:434,w:7.129298}; case 110: return {t:434,w:7.129298}; case 111: return {t:434,w:7.129298}; case 112: return {t:434,w:7.129298}; case 113: return {t:434,w:7.129298}; case 114: return {t:434,w:7.129298}; case 115: return {t:434,w:7.129298}; case 116: return {t:434,w:7.129298}; case 117: return {t:434,w:7.129298}; case 118: return {t:434,w:7.129298}; case 119: return {t:434,w:7.129298}; case 120: return {t:434,w:7.129298}; case 121: return {t:434,w:7.129298}; case 122: return {t:434,w:7.129298}; case 126: return {t:435,w:3.871201}; case 258: return {t:1789,w:0.693147}; case 363: return {t:1790,w:1.791759}; case 364: return {t:1791,w:1.791759}; case 481: return {t:1792,w:1.791759};default: return {t:0,w:0.0};}};
case 1715: return function (act:Int) {switch (act) { case 258: return {t:1793,w:0.000000};default: return {t:0,w:0.0};}};
case 1716: return function (act:Int) {switch (act) { case 78: return {t:1794,w:0.693147}; case 110: return {t:1794,w:0.693147};default: return {t:0,w:0.0};}};
case 1717: return function (act:Int) {switch (act) { case 71: return {t:1795,w:0.693147}; case 103: return {t:1795,w:0.693147};default: return {t:0,w:0.0};}};
case 1718: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1636,w:0.693147}; case 384: return {t:1637,w:0.693147};default: return {t:0,w:0.0};}};
case 1719: return function (act:Int) {switch (act) { case 256: return {t:1261,w:4000000.000000}; case 452: return {t:1796,w:0.000000};default: return {t:0,w:0.0};}};
case 1720: return function (act:Int) {switch (act) { case 483: return {t:1720,w:0.000000};default: return {t:0,w:0.0};}};
case 1721: return function (act:Int) {switch (act) { case 256: return {t:1726,w:4000000.000000}; case 335: return {t:1797,w:0.000000};default: return {t:0,w:0.0};}};
case 1722: return function (act:Int) {switch (act) { case 287: return {t:1722,w:0.000000};default: return {t:0,w:0.0};}};
case 1723: return function (act:Int) {switch (act) { case 256: return {t:1641,w:4000000.000000}; case 489: return {t:1798,w:0.000000};default: return {t:0,w:0.0};}};
case 1724: return function (act:Int) {switch (act) { case 78: return {t:1799,w:0.693147}; case 110: return {t:1799,w:0.693147};default: return {t:0,w:0.0};}};
case 1725: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1800,w:0.000000};default: return {t:0,w:0.0};}};
case 1726: return function (act:Int) {switch (act) { case 65: return {t:179,w:3.951244}; case 66: return {t:179,w:3.951244}; case 67: return {t:179,w:3.951244}; case 68: return {t:179,w:3.951244}; case 69: return {t:179,w:3.951244}; case 70: return {t:179,w:3.951244}; case 71: return {t:179,w:3.951244}; case 72: return {t:179,w:3.951244}; case 73: return {t:179,w:3.951244}; case 74: return {t:179,w:3.951244}; case 75: return {t:179,w:3.951244}; case 76: return {t:179,w:3.951244}; case 77: return {t:179,w:3.951244}; case 78: return {t:179,w:3.951244}; case 79: return {t:179,w:3.951244}; case 80: return {t:179,w:3.951244}; case 81: return {t:179,w:3.951244}; case 82: return {t:179,w:3.951244}; case 83: return {t:179,w:3.951244}; case 84: return {t:179,w:3.951244}; case 85: return {t:179,w:3.951244}; case 86: return {t:179,w:3.951244}; case 87: return {t:179,w:3.951244}; case 88: return {t:179,w:3.951244}; case 89: return {t:179,w:3.951244}; case 90: return {t:179,w:3.951244}; case 97: return {t:181,w:3.951244}; case 98: return {t:181,w:3.951244}; case 99: return {t:181,w:3.951244}; case 100: return {t:181,w:3.951244}; case 101: return {t:181,w:3.951244}; case 102: return {t:181,w:3.951244}; case 103: return {t:181,w:3.951244}; case 104: return {t:181,w:3.951244}; case 105: return {t:181,w:3.951244}; case 106: return {t:181,w:3.951244}; case 107: return {t:181,w:3.951244}; case 108: return {t:181,w:3.951244}; case 109: return {t:181,w:3.951244}; case 110: return {t:181,w:3.951244}; case 111: return {t:181,w:3.951244}; case 112: return {t:181,w:3.951244}; case 113: return {t:181,w:3.951244}; case 114: return {t:181,w:3.951244}; case 115: return {t:181,w:3.951244}; case 116: return {t:181,w:3.951244}; case 117: return {t:181,w:3.951244}; case 118: return {t:181,w:3.951244}; case 119: return {t:181,w:3.951244}; case 120: return {t:181,w:3.951244}; case 121: return {t:181,w:3.951244}; case 122: return {t:181,w:3.951244}; case 331: return {t:183,w:0.000000}; case 334: return {t:186,w:0.000000};default: return {t:0,w:0.0};}};
case 1727: return function (act:Int) {switch (act) { case 256: return {t:831,w:4000000.000000}; case 401: return {t:1801,w:0.000000};default: return {t:0,w:0.0};}};
case 1728: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1646,w:0.693147}; case 375: return {t:1647,w:0.693147};default: return {t:0,w:0.0};}};
case 1729: return function (act:Int) {switch (act) { case 83: return {t:1802,w:0.693147}; case 115: return {t:1802,w:0.693147};default: return {t:0,w:0.0};}};
case 1730: return function (act:Int) {switch (act) { case 73: return {t:1803,w:0.693147}; case 105: return {t:1803,w:0.693147};default: return {t:0,w:0.0};}};
case 1731: return function (act:Int) {switch (act) { case 65: return {t:1804,w:0.693147}; case 97: return {t:1804,w:0.693147};default: return {t:0,w:0.0};}};
case 1732: return function (act:Int) {switch (act) { case 72: return {t:1805,w:0.693147}; case 104: return {t:1805,w:0.693147};default: return {t:0,w:0.0};}};
case 1733: return function (act:Int) {switch (act) { case 78: return {t:1806,w:0.693147}; case 110: return {t:1806,w:0.693147};default: return {t:0,w:0.0};}};
case 1734: return function (act:Int) {switch (act) { case 485: return {t:1734,w:0.000000};default: return {t:0,w:0.0};}};
case 1735: return function (act:Int) {switch (act) { case 256: return {t:1807,w:4000000.000000}; case 498: return {t:1808,w:0.000000};default: return {t:0,w:0.0};}};
case 1736: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1809,w:0.000000};default: return {t:0,w:0.0};}};
case 1737: return function (act:Int) {switch (act) { case 71: return {t:1810,w:0.693147}; case 103: return {t:1810,w:0.693147};default: return {t:0,w:0.0};}};
case 1738: return function (act:Int) {switch (act) { case 256: return {t:1726,w:4000000.000000}; case 335: return {t:1811,w:0.000000};default: return {t:0,w:0.0};}};
case 1739: return function (act:Int) {switch (act) { case 301: return {t:1739,w:0.000000};default: return {t:0,w:0.0};}};
case 1740: return function (act:Int) {switch (act) { case 256: return {t:1661,w:4000000.000000}; case 491: return {t:1812,w:0.000000};default: return {t:0,w:0.0};}};
case 1741: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1813,w:0.693147}; case 375: return {t:1814,w:0.693147};default: return {t:0,w:0.0};}};
case 1742: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1815,w:0.000000};default: return {t:0,w:0.0};}};
case 1743: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1816,w:0.000000};default: return {t:0,w:0.0};}};
case 1744: return function (act:Int) {switch (act) { case 258: return {t:1817,w:0.000000};default: return {t:0,w:0.0};}};
case 1745: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:1818,w:0.000000};default: return {t:0,w:0.0};}};
case 1746: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1562,w:0.693147}; case 336: return {t:1819,w:0.693147};default: return {t:0,w:0.0};}};
case 1747: return function (act:Int) {switch (act) { case 48: return {t:1820,w:0.693147}; case 258: return {t:1562,w:0.693147};default: return {t:0,w:0.0};}};
case 1748: return function (act:Int) {switch (act) { case 256: return {t:334,w:4000000.750000}; case 258: return {t:1821,w:0.693147}; case 356: return {t:1822,w:0.693147};default: return {t:0,w:0.0};}};
case 1749: return function (act:Int) {switch (act) { case 82: return {t:1823,w:0.693147}; case 114: return {t:1823,w:0.693147};default: return {t:0,w:0.0};}};
case 1750: return function (act:Int) {switch (act) { case 45: return {t:1824,w:0.000000};default: return {t:0,w:0.0};}};
case 1751: return function (act:Int) {switch (act) { case 77: return {t:1825,w:0.693147}; case 109: return {t:1825,w:0.693147};default: return {t:0,w:0.0};}};
case 1752: return function (act:Int) {switch (act) { case 69: return {t:1826,w:0.693147}; case 101: return {t:1826,w:0.693147};default: return {t:0,w:0.0};}};
case 1753: return function (act:Int) {switch (act) { case 73: return {t:1827,w:0.693147}; case 105: return {t:1827,w:0.693147};default: return {t:0,w:0.0};}};
case 1754: return function (act:Int) {switch (act) { case 90: return {t:1828,w:0.693147}; case 122: return {t:1828,w:0.693147};default: return {t:0,w:0.0};}};
case 1755: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1829,w:0.000000};default: return {t:0,w:0.0};}};
case 1756: return function (act:Int) {switch (act) { case 256: return {t:1830,w:4000000.000000}; case 499: return {t:1831,w:0.000000};default: return {t:0,w:0.0};}};
case 1757: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:862,w:0.000000}; case 404: return {t:1832,w:0.000000};default: return {t:0,w:0.0};}};
case 1758: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1680,w:0.693147}; case 384: return {t:1681,w:0.693147};default: return {t:0,w:0.0};}};
case 1759: return function (act:Int) {switch (act) { case 256: return {t:1833,w:4000000.750000}; case 258: return {t:1834,w:1.386294}; case 384: return {t:1835,w:1.386294}; case 454: return {t:1836,w:0.693147};default: return {t:0,w:0.0};}};
case 1760: return function (act:Int) {switch (act) { case 487: return {t:1760,w:0.000000};default: return {t:0,w:0.0};}};
case 1761: return function (act:Int) {switch (act) { case 258: return {t:1837,w:0.000000};default: return {t:0,w:0.0};}};
case 1762: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.136294}; case 13: return {t:83,w:2.136294}; case 32: return {t:494,w:2.136294}; case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 279: return {t:504,w:2.136294}; case 283: return {t:119,w:2.136294}; case 376: return {t:505,w:1.443147};default: return {t:0,w:0.0};}};
case 1763: return function (act:Int) {switch (act) { case 256: return {t:1762,w:4000000.750000}; case 258: return {t:1691,w:1.386294}; case 336: return {t:1763,w:0.693147}; case 377: return {t:1693,w:1.386294};default: return {t:0,w:0.0};}};
case 1764: return function (act:Int) {switch (act) { case 46: return {t:1838,w:1.386294}; case 48: return {t:189,w:2.995732}; case 49: return {t:189,w:2.995732}; case 50: return {t:189,w:2.995732}; case 51: return {t:189,w:2.995732}; case 52: return {t:189,w:2.995732}; case 53: return {t:189,w:2.995732}; case 54: return {t:189,w:2.995732}; case 55: return {t:189,w:2.995732}; case 56: return {t:189,w:2.995732}; case 57: return {t:189,w:2.995732}; case 258: return {t:1839,w:1.386294}; case 336: return {t:1840,w:0.693147};default: return {t:0,w:0.0};}};
case 1765: return function (act:Int) {switch (act) { case 258: return {t:1691,w:0.000000};default: return {t:0,w:0.0};}};
case 1766: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1841,w:0.693147}; case 375: return {t:1842,w:0.693147};default: return {t:0,w:0.0};}};
case 1767: return function (act:Int) {switch (act) { case 324: return {t:1767,w:0.000000};default: return {t:0,w:0.0};}};
case 1768: return function (act:Int) {switch (act) { case 256: return {t:1156,w:4000000.000000}; case 436: return {t:1843,w:0.000000};default: return {t:0,w:0.0};}};
case 1769: return function (act:Int) {switch (act) { case 72: return {t:1844,w:0.693147}; case 104: return {t:1844,w:0.693147};default: return {t:0,w:0.0};}};
case 1770: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:1845,w:0.000000};default: return {t:0,w:0.0};}};
case 1771: return function (act:Int) {switch (act) { case 86: return {t:1846,w:0.693147}; case 118: return {t:1846,w:0.693147};default: return {t:0,w:0.0};}};
case 1772: return function (act:Int) {switch (act) { case 48: return {t:189,w:2.302585}; case 49: return {t:189,w:2.302585}; case 50: return {t:189,w:2.302585}; case 51: return {t:189,w:2.302585}; case 52: return {t:189,w:2.302585}; case 53: return {t:189,w:2.302585}; case 54: return {t:189,w:2.302585}; case 55: return {t:189,w:2.302585}; case 56: return {t:189,w:2.302585}; case 57: return {t:189,w:2.302585}; case 336: return {t:1847,w:0.000000};default: return {t:0,w:0.0};}};
case 1773: return function (act:Int) {switch (act) { case 258: return {t:1848,w:0.000000};default: return {t:0,w:0.0};}};
case 1774: return function (act:Int) {switch (act) { case 480: return {t:1774,w:0.000000};default: return {t:0,w:0.0};}};
case 1775: return function (act:Int) {switch (act) { case 258: return {t:1849,w:0.000000};default: return {t:0,w:0.0};}};
case 1776: return function (act:Int) {switch (act) { case 258: return {t:1850,w:0.000000};default: return {t:0,w:0.0};}};
case 1777: return function (act:Int) {switch (act) { case 258: return {t:1850,w:0.000000};default: return {t:0,w:0.0};}};
case 1778: return function (act:Int) {switch (act) { case 256: return {t:1851,w:4000000.000000}; case 500: return {t:1852,w:0.000000};default: return {t:0,w:0.0};}};
case 1779: return function (act:Int) {switch (act) { case 65: return {t:1853,w:0.693147}; case 97: return {t:1853,w:0.693147};default: return {t:0,w:0.0};}};
case 1780: return function (act:Int) {switch (act) { case 413: return {t:1780,w:0.000000};default: return {t:0,w:0.0};}};
case 1781: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1780,w:0.693147}; case 336: return {t:1854,w:0.693147};default: return {t:0,w:0.0};}};
case 1782: return function (act:Int) {switch (act) { case 61: return {t:1855,w:0.000000};default: return {t:0,w:0.0};}};
case 1783: return function (act:Int) {switch (act) { case 68: return {t:1856,w:0.693147}; case 100: return {t:1856,w:0.693147};default: return {t:0,w:0.0};}};
case 1784: return function (act:Int) {switch (act) { case 80: return {t:1857,w:0.693147}; case 112: return {t:1857,w:0.693147};default: return {t:0,w:0.0};}};
case 1785: return function (act:Int) {switch (act) { case 258: return {t:1858,w:0.000000};default: return {t:0,w:0.0};}};
case 1786: return function (act:Int) {switch (act) { case 73: return {t:1859,w:1.791759}; case 80: return {t:1860,w:1.791759}; case 105: return {t:1859,w:1.791759}; case 112: return {t:1860,w:1.791759}; case 256: return {t:1861,w:4000001.000000}; case 501: return {t:1862,w:1.098612};default: return {t:0,w:0.0};}};
case 1787: return function (act:Int) {switch (act) { case 488: return {t:1787,w:0.000000};default: return {t:0,w:0.0};}};
case 1788: return function (act:Int) {switch (act) { case 256: return {t:1510,w:4000000.750000}; case 258: return {t:1787,w:0.693147}; case 470: return {t:1788,w:0.693147};default: return {t:0,w:0.0};}};
case 1789: return function (act:Int) {switch (act) { case 493: return {t:1789,w:0.000000};default: return {t:0,w:0.0};}};
case 1790: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1863,w:0.693147}; case 363: return {t:1864,w:1.791759}; case 364: return {t:1865,w:1.791759}; case 481: return {t:1866,w:1.791759};default: return {t:0,w:0.0};}};
case 1791: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1863,w:0.693147}; case 363: return {t:1864,w:1.791759}; case 364: return {t:1865,w:1.791759}; case 481: return {t:1866,w:1.791759};default: return {t:0,w:0.0};}};
case 1792: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1863,w:0.693147}; case 363: return {t:1864,w:1.791759}; case 364: return {t:1865,w:1.791759}; case 481: return {t:1866,w:1.791759};default: return {t:0,w:0.0};}};
case 1793: return function (act:Int) {switch (act) { case 473: return {t:1793,w:0.000000};default: return {t:0,w:0.0};}};
case 1794: return function (act:Int) {switch (act) { case 71: return {t:1867,w:0.693147}; case 103: return {t:1867,w:0.693147};default: return {t:0,w:0.0};}};
case 1795: return function (act:Int) {switch (act) { case 69: return {t:1868,w:0.693147}; case 101: return {t:1868,w:0.693147};default: return {t:0,w:0.0};}};
case 1796: return function (act:Int) {switch (act) { case 258: return {t:1720,w:0.000000};default: return {t:0,w:0.0};}};
case 1797: return function (act:Int) {switch (act) { case 256: return {t:831,w:4000000.000000}; case 401: return {t:1869,w:0.000000};default: return {t:0,w:0.0};}};
case 1798: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1722,w:0.693147}; case 375: return {t:1723,w:0.693147};default: return {t:0,w:0.0};}};
case 1799: return function (act:Int) {switch (act) { case 45: return {t:1870,w:0.000000};default: return {t:0,w:0.0};}};
case 1800: return function (act:Int) {switch (act) { case 256: return {t:1871,w:4000000.000000}; case 502: return {t:1872,w:0.000000};default: return {t:0,w:0.0};}};
case 1801: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1873,w:0.693147}; case 384: return {t:1874,w:0.693147};default: return {t:0,w:0.0};}};
case 1802: return function (act:Int) {switch (act) { case 73: return {t:1875,w:0.693147}; case 105: return {t:1875,w:0.693147};default: return {t:0,w:0.0};}};
case 1803: return function (act:Int) {switch (act) { case 78: return {t:1876,w:0.693147}; case 110: return {t:1876,w:0.693147};default: return {t:0,w:0.0};}};
case 1804: return function (act:Int) {switch (act) { case 71: return {t:1877,w:0.693147}; case 103: return {t:1877,w:0.693147};default: return {t:0,w:0.0};}};
case 1805: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:223,w:0.000000};default: return {t:0,w:0.0};}};
case 1806: return function (act:Int) {switch (act) { case 258: return {t:814,w:0.000000};default: return {t:0,w:0.0};}};
case 1807: return function (act:Int) {switch (act) { case 65: return {t:1878,w:3.178054}; case 68: return {t:1879,w:3.178054}; case 70: return {t:1880,w:3.178054}; case 74: return {t:1881,w:3.178054}; case 77: return {t:1882,w:3.178054}; case 78: return {t:1883,w:3.178054}; case 79: return {t:1884,w:3.178054}; case 83: return {t:1885,w:3.178054}; case 97: return {t:1878,w:3.178054}; case 100: return {t:1879,w:3.178054}; case 102: return {t:1880,w:3.178054}; case 106: return {t:1881,w:3.178054}; case 109: return {t:1882,w:3.178054}; case 110: return {t:1883,w:3.178054}; case 111: return {t:1884,w:3.178054}; case 115: return {t:1885,w:3.178054};default: return {t:0,w:0.0};}};
case 1808: return function (act:Int) {switch (act) { case 256: return {t:62,w:4000000.000000}; case 278: return {t:1886,w:0.000000};default: return {t:0,w:0.0};}};
case 1809: return function (act:Int) {switch (act) { case 58: return {t:1887,w:0.000000};default: return {t:0,w:0.0};}};
case 1810: return function (act:Int) {switch (act) { case 77: return {t:1888,w:0.693147}; case 109: return {t:1888,w:0.693147};default: return {t:0,w:0.0};}};
case 1811: return function (act:Int) {switch (act) { case 256: return {t:831,w:4000000.000000}; case 401: return {t:1889,w:0.000000};default: return {t:0,w:0.0};}};
case 1812: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1739,w:0.693147}; case 375: return {t:1740,w:0.693147};default: return {t:0,w:0.0};}};
case 1813: return function (act:Int) {switch (act) { case 304: return {t:1813,w:0.000000};default: return {t:0,w:0.0};}};
case 1814: return function (act:Int) {switch (act) { case 256: return {t:311,w:4000000.000000}; case 352: return {t:1890,w:0.000000};default: return {t:0,w:0.0};}};
case 1815: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1891,w:0.693147}; case 336: return {t:1892,w:0.693147};default: return {t:0,w:0.0};}};
case 1816: return function (act:Int) {switch (act) { case 46: return {t:1893,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:1894,w:0.693147};default: return {t:0,w:0.0};}};
case 1817: return function (act:Int) {switch (act) { case 307: return {t:1817,w:0.000000};default: return {t:0,w:0.0};}};
case 1818: return function (act:Int) {switch (act) { case 256: return {t:1252,w:4000000.000000}; case 451: return {t:1895,w:0.000000};default: return {t:0,w:0.0};}};
case 1819: return function (act:Int) {switch (act) { case 258: return {t:1562,w:0.000000};default: return {t:0,w:0.0};}};
case 1820: return function (act:Int) {switch (act) { case 258: return {t:1562,w:0.000000};default: return {t:0,w:0.0};}};
case 1821: return function (act:Int) {switch (act) { case 308: return {t:1821,w:0.000000};default: return {t:0,w:0.0};}};
case 1822: return function (act:Int) {switch (act) { case 258: return {t:1821,w:0.000000};default: return {t:0,w:0.0};}};
case 1823: return function (act:Int) {switch (act) { case 71: return {t:1896,w:0.693147}; case 103: return {t:1896,w:0.693147};default: return {t:0,w:0.0};}};
case 1824: return function (act:Int) {switch (act) { case 85: return {t:1897,w:0.693147}; case 117: return {t:1897,w:0.693147};default: return {t:0,w:0.0};}};
case 1825: return function (act:Int) {switch (act) { case 65: return {t:1898,w:0.693147}; case 97: return {t:1898,w:0.693147};default: return {t:0,w:0.0};}};
case 1826: return function (act:Int) {switch (act) { case 78: return {t:1899,w:0.693147}; case 110: return {t:1899,w:0.693147};default: return {t:0,w:0.0};}};
case 1827: return function (act:Int) {switch (act) { case 67: return {t:1900,w:0.693147}; case 99: return {t:1900,w:0.693147};default: return {t:0,w:0.0};}};
case 1828: return function (act:Int) {switch (act) { case 65: return {t:1901,w:0.693147}; case 97: return {t:1901,w:0.693147};default: return {t:0,w:0.0};}};
case 1829: return function (act:Int) {switch (act) { case 256: return {t:313,w:4000000.000000}; case 353: return {t:1902,w:0.000000};default: return {t:0,w:0.0};}};
case 1830: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.772588}; case 13: return {t:83,w:2.772588}; case 32: return {t:494,w:2.772588}; case 33: return {t:2,w:4.477336}; case 37: return {t:3,w:4.477336}; case 39: return {t:4,w:4.477336}; case 42: return {t:5,w:4.477336}; case 43: return {t:6,w:4.477336}; case 45: return {t:7,w:4.477336}; case 46: return {t:8,w:4.477336}; case 48: return {t:9,w:7.878534}; case 49: return {t:9,w:7.878534}; case 50: return {t:9,w:7.878534}; case 51: return {t:9,w:7.878534}; case 52: return {t:9,w:7.878534}; case 53: return {t:9,w:7.878534}; case 54: return {t:9,w:7.878534}; case 55: return {t:9,w:7.878534}; case 56: return {t:9,w:7.878534}; case 57: return {t:9,w:7.878534}; case 65: return {t:13,w:8.834045}; case 66: return {t:13,w:8.834045}; case 67: return {t:13,w:8.834045}; case 68: return {t:13,w:8.834045}; case 69: return {t:13,w:8.834045}; case 70: return {t:13,w:8.834045}; case 71: return {t:13,w:8.834045}; case 72: return {t:13,w:8.834045}; case 73: return {t:13,w:8.834045}; case 74: return {t:13,w:8.834045}; case 75: return {t:13,w:8.834045}; case 76: return {t:13,w:8.834045}; case 77: return {t:13,w:8.834045}; case 78: return {t:13,w:8.834045}; case 79: return {t:13,w:8.834045}; case 80: return {t:13,w:8.834045}; case 81: return {t:13,w:8.834045}; case 82: return {t:13,w:8.834045}; case 83: return {t:13,w:8.834045}; case 84: return {t:13,w:8.834045}; case 85: return {t:13,w:8.834045}; case 86: return {t:13,w:8.834045}; case 87: return {t:13,w:8.834045}; case 88: return {t:13,w:8.834045}; case 89: return {t:13,w:8.834045}; case 90: return {t:13,w:8.834045}; case 95: return {t:18,w:4.477336}; case 96: return {t:19,w:4.477336}; case 97: return {t:20,w:8.834045}; case 98: return {t:20,w:8.834045}; case 99: return {t:20,w:8.834045}; case 100: return {t:20,w:8.834045}; case 101: return {t:20,w:8.834045}; case 102: return {t:20,w:8.834045}; case 103: return {t:20,w:8.834045}; case 104: return {t:20,w:8.834045}; case 105: return {t:20,w:8.834045}; case 106: return {t:20,w:8.834045}; case 107: return {t:20,w:8.834045}; case 108: return {t:20,w:8.834045}; case 109: return {t:20,w:8.834045}; case 110: return {t:20,w:8.834045}; case 111: return {t:20,w:8.834045}; case 112: return {t:20,w:8.834045}; case 113: return {t:20,w:8.834045}; case 114: return {t:20,w:8.834045}; case 115: return {t:20,w:8.834045}; case 116: return {t:20,w:8.834045}; case 117: return {t:20,w:8.834045}; case 118: return {t:20,w:8.834045}; case 119: return {t:20,w:8.834045}; case 120: return {t:20,w:8.834045}; case 121: return {t:20,w:8.834045}; case 122: return {t:20,w:8.834045}; case 126: return {t:22,w:4.477336}; case 258: return {t:499,w:1.386294}; case 268: return {t:29,w:4.477336}; case 269: return {t:500,w:2.079441}; case 279: return {t:504,w:2.772588}; case 283: return {t:119,w:2.772588}; case 358: return {t:1903,w:0.000000}; case 368: return {t:507,w:0.693147}; case 376: return {t:505,w:2.079441}; case 377: return {t:506,w:1.386294}; case 378: return {t:508,w:1.386294}; case 379: return {t:509,w:0.693147}; case 380: return {t:510,w:0.693147};default: return {t:0,w:0.0};}};
case 1831: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1904,w:0.693147}; case 375: return {t:1905,w:0.693147};default: return {t:0,w:0.0};}};
case 1832: return function (act:Int) {switch (act) { case 258: return {t:1906,w:0.000000};default: return {t:0,w:0.0};}};
case 1833: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1907,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 453: return {t:1276,w:0.000000};default: return {t:0,w:0.0};}};
case 1834: return function (act:Int) {switch (act) { case 316: return {t:1834,w:0.000000};default: return {t:0,w:0.0};}};
case 1835: return function (act:Int) {switch (act) { case 256: return {t:1908,w:4000000.000000}; case 503: return {t:1909,w:0.000000};default: return {t:0,w:0.0};}};
case 1836: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1834,w:0.693147}; case 384: return {t:1835,w:0.693147};default: return {t:0,w:0.0};}};
case 1837: return function (act:Int) {switch (act) { case 479: return {t:1837,w:0.000000};default: return {t:0,w:0.0};}};
case 1838: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1910,w:0.693147}; case 336: return {t:1911,w:0.693147};default: return {t:0,w:0.0};}};
case 1839: return function (act:Int) {switch (act) { case 495: return {t:1839,w:0.000000};default: return {t:0,w:0.0};}};
case 1840: return function (act:Int) {switch (act) { case 46: return {t:1912,w:1.386294}; case 256: return {t:256,w:4000000.750000}; case 258: return {t:1910,w:1.386294}; case 336: return {t:1913,w:0.693147};default: return {t:0,w:0.0};}};
case 1841: return function (act:Int) {switch (act) { case 323: return {t:1841,w:0.000000};default: return {t:0,w:0.0};}};
case 1842: return function (act:Int) {switch (act) { case 256: return {t:313,w:4000000.000000}; case 353: return {t:1914,w:0.000000};default: return {t:0,w:0.0};}};
case 1843: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.750000}; case 258: return {t:1767,w:0.693147}; case 377: return {t:1768,w:0.693147};default: return {t:0,w:0.0};}};
case 1844: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:1915,w:0.000000};default: return {t:0,w:0.0};}};
case 1845: return function (act:Int) {switch (act) { case 256: return {t:1916,w:4000000.000000}; case 415: return {t:1917,w:0.000000};default: return {t:0,w:0.0};}};
case 1846: return function (act:Int) {switch (act) { case 69: return {t:1918,w:0.693147}; case 101: return {t:1918,w:0.693147};default: return {t:0,w:0.0};}};
case 1847: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1919,w:0.693147}; case 336: return {t:1920,w:0.693147};default: return {t:0,w:0.0};}};
case 1848: return function (act:Int) {switch (act) { case 457: return {t:1848,w:0.000000};default: return {t:0,w:0.0};}};
case 1849: return function (act:Int) {switch (act) { case 497: return {t:1849,w:0.000000};default: return {t:0,w:0.0};}};
case 1850: return function (act:Int) {switch (act) { case 492: return {t:1850,w:0.000000};default: return {t:0,w:0.0};}};
case 1851: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1291,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 378: return {t:1921,w:0.000000};default: return {t:0,w:0.0};}};
case 1852: return function (act:Int) {switch (act) { case 258: return {t:1922,w:0.000000};default: return {t:0,w:0.0};}};
case 1853: return function (act:Int) {switch (act) { case 84: return {t:1923,w:0.693147}; case 116: return {t:1923,w:0.693147};default: return {t:0,w:0.0};}};
case 1854: return function (act:Int) {switch (act) { case 258: return {t:1780,w:0.000000};default: return {t:0,w:0.0};}};
case 1855: return function (act:Int) {switch (act) { case 256: return {t:1916,w:4000000.000000}; case 415: return {t:1924,w:0.000000};default: return {t:0,w:0.0};}};
case 1856: return function (act:Int) {switch (act) { case 61: return {t:1925,w:0.000000};default: return {t:0,w:0.0};}};
case 1857: return function (act:Int) {switch (act) { case 79: return {t:1926,w:0.693147}; case 111: return {t:1926,w:0.693147};default: return {t:0,w:0.0};}};
case 1858: return function (act:Int) {switch (act) { case 466: return {t:1858,w:0.000000};default: return {t:0,w:0.0};}};
case 1859: return function (act:Int) {switch (act) { case 80: return {t:1927,w:0.693147}; case 112: return {t:1927,w:0.693147};default: return {t:0,w:0.0};}};
case 1860: return function (act:Int) {switch (act) { case 72: return {t:1928,w:0.693147}; case 104: return {t:1928,w:0.693147};default: return {t:0,w:0.0};}};
case 1861: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:1929,w:0.000000};default: return {t:0,w:0.0};}};
case 1862: return function (act:Int) {switch (act) { case 258: return {t:1930,w:0.000000};default: return {t:0,w:0.0};}};
case 1863: return function (act:Int) {switch (act) { case 493: return {t:1863,w:0.000000};default: return {t:0,w:0.0};}};
case 1864: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1863,w:0.693147}; case 363: return {t:1864,w:1.791759}; case 364: return {t:1865,w:1.791759}; case 481: return {t:1866,w:1.791759};default: return {t:0,w:0.0};}};
case 1865: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1863,w:0.693147}; case 363: return {t:1864,w:1.791759}; case 364: return {t:1865,w:1.791759}; case 481: return {t:1866,w:1.791759};default: return {t:0,w:0.0};}};
case 1866: return function (act:Int) {switch (act) { case 256: return {t:1627,w:4000001.750000}; case 258: return {t:1863,w:0.693147}; case 363: return {t:1864,w:1.791759}; case 364: return {t:1865,w:1.791759}; case 481: return {t:1866,w:1.791759};default: return {t:0,w:0.0};}};
case 1867: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1931,w:0.000000};default: return {t:0,w:0.0};}};
case 1868: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:1932,w:0.000000};default: return {t:0,w:0.0};}};
case 1869: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1933,w:0.693147}; case 384: return {t:1934,w:0.693147};default: return {t:0,w:0.0};}};
case 1870: return function (act:Int) {switch (act) { case 73: return {t:1935,w:0.693147}; case 105: return {t:1935,w:0.693147};default: return {t:0,w:0.0};}};
case 1871: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:1936,w:1.386294}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:1937,w:1.386294}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:1938,w:0.693147}; case 504: return {t:1939,w:0.693147}; case 505: return {t:1940,w:0.693147};default: return {t:0,w:0.0};}};
case 1872: return function (act:Int) {switch (act) { case 258: return {t:1941,w:0.000000};default: return {t:0,w:0.0};}};
case 1873: return function (act:Int) {switch (act) { case 484: return {t:1873,w:0.000000};default: return {t:0,w:0.0};}};
case 1874: return function (act:Int) {switch (act) { case 256: return {t:1942,w:4000000.000000}; case 506: return {t:1943,w:0.000000};default: return {t:0,w:0.0};}};
case 1875: return function (act:Int) {switch (act) { case 84: return {t:1944,w:0.693147}; case 116: return {t:1944,w:0.693147};default: return {t:0,w:0.0};}};
case 1876: return function (act:Int) {switch (act) { case 71: return {t:1945,w:0.693147}; case 103: return {t:1945,w:0.693147};default: return {t:0,w:0.0};}};
case 1877: return function (act:Int) {switch (act) { case 69: return {t:1946,w:0.693147}; case 101: return {t:1946,w:0.693147};default: return {t:0,w:0.0};}};
case 1878: return function (act:Int) {switch (act) { case 80: return {t:1947,w:0.693147}; case 85: return {t:1948,w:0.693147}; case 112: return {t:1947,w:0.693147}; case 117: return {t:1948,w:0.693147};default: return {t:0,w:0.0};}};
case 1879: return function (act:Int) {switch (act) { case 69: return {t:1949,w:0.693147}; case 101: return {t:1949,w:0.693147};default: return {t:0,w:0.0};}};
case 1880: return function (act:Int) {switch (act) { case 69: return {t:1950,w:0.693147}; case 101: return {t:1950,w:0.693147};default: return {t:0,w:0.0};}};
case 1881: return function (act:Int) {switch (act) { case 65: return {t:1951,w:0.693147}; case 85: return {t:1952,w:0.693147}; case 97: return {t:1951,w:0.693147}; case 117: return {t:1952,w:0.693147};default: return {t:0,w:0.0};}};
case 1882: return function (act:Int) {switch (act) { case 65: return {t:1953,w:0.693147}; case 97: return {t:1953,w:0.693147};default: return {t:0,w:0.0};}};
case 1883: return function (act:Int) {switch (act) { case 79: return {t:1954,w:0.693147}; case 111: return {t:1954,w:0.693147};default: return {t:0,w:0.0};}};
case 1884: return function (act:Int) {switch (act) { case 67: return {t:1955,w:0.693147}; case 99: return {t:1955,w:0.693147};default: return {t:0,w:0.0};}};
case 1885: return function (act:Int) {switch (act) { case 69: return {t:1956,w:0.693147}; case 101: return {t:1956,w:0.693147};default: return {t:0,w:0.0};}};
case 1886: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1957,w:0.000000};default: return {t:0,w:0.0};}};
case 1887: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1958,w:0.000000};default: return {t:0,w:0.0};}};
case 1888: return function (act:Int) {switch (act) { case 84: return {t:1959,w:0.693147}; case 116: return {t:1959,w:0.693147};default: return {t:0,w:0.0};}};
case 1889: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1960,w:0.693147}; case 384: return {t:1961,w:0.693147};default: return {t:0,w:0.0};}};
case 1890: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1813,w:0.693147}; case 375: return {t:1814,w:0.693147};default: return {t:0,w:0.0};}};
case 1891: return function (act:Int) {switch (act) { case 305: return {t:1891,w:0.000000};default: return {t:0,w:0.0};}};
case 1892: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1891,w:0.693147}; case 336: return {t:1892,w:0.693147};default: return {t:0,w:0.0};}};
case 1893: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:1962,w:0.000000};default: return {t:0,w:0.0};}};
case 1894: return function (act:Int) {switch (act) { case 46: return {t:1893,w:0.693147}; case 256: return {t:256,w:4000000.750000}; case 336: return {t:1894,w:0.693147};default: return {t:0,w:0.0};}};
case 1895: return function (act:Int) {switch (act) { case 258: return {t:1963,w:0.000000};default: return {t:0,w:0.0};}};
case 1896: return function (act:Int) {switch (act) { case 69: return {t:1964,w:0.693147}; case 101: return {t:1964,w:0.693147};default: return {t:0,w:0.0};}};
case 1897: return function (act:Int) {switch (act) { case 82: return {t:1965,w:0.693147}; case 114: return {t:1965,w:0.693147};default: return {t:0,w:0.0};}};
case 1898: return function (act:Int) {switch (act) { case 76: return {t:1966,w:0.693147}; case 108: return {t:1966,w:0.693147};default: return {t:0,w:0.0};}};
case 1899: return function (act:Int) {switch (act) { case 84: return {t:1967,w:0.693147}; case 116: return {t:1967,w:0.693147};default: return {t:0,w:0.0};}};
case 1900: return function (act:Int) {switch (act) { case 65: return {t:1968,w:0.693147}; case 97: return {t:1968,w:0.693147};default: return {t:0,w:0.0};}};
case 1901: return function (act:Int) {switch (act) { case 84: return {t:1969,w:0.693147}; case 116: return {t:1969,w:0.693147};default: return {t:0,w:0.0};}};
case 1902: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1970,w:0.693147}; case 375: return {t:1971,w:0.693147};default: return {t:0,w:0.0};}};
case 1903: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1972,w:0.693147}; case 384: return {t:1973,w:0.693147};default: return {t:0,w:0.0};}};
case 1904: return function (act:Int) {switch (act) { case 313: return {t:1904,w:0.000000};default: return {t:0,w:0.0};}};
case 1905: return function (act:Int) {switch (act) { case 256: return {t:1830,w:4000000.000000}; case 499: return {t:1974,w:0.000000};default: return {t:0,w:0.0};}};
case 1906: return function (act:Int) {switch (act) { case 494: return {t:1906,w:0.000000};default: return {t:0,w:0.0};}};
case 1907: return function (act:Int) {switch (act) { case 40: return {t:1444,w:0.000000}; case 59: return {t:859,w:0.750000};default: return {t:0,w:0.0};}};
case 1908: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:1975,w:1.386294}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:1976,w:1.386294}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:862,w:0.693147}; case 404: return {t:1977,w:0.693147};default: return {t:0,w:0.0};}};
case 1909: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1834,w:0.693147}; case 384: return {t:1835,w:0.693147};default: return {t:0,w:0.0};}};
case 1910: return function (act:Int) {switch (act) { case 495: return {t:1910,w:0.000000};default: return {t:0,w:0.0};}};
case 1911: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1910,w:0.693147}; case 336: return {t:1911,w:0.693147};default: return {t:0,w:0.0};}};
case 1912: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1910,w:0.693147}; case 336: return {t:1978,w:0.693147};default: return {t:0,w:0.0};}};
case 1913: return function (act:Int) {switch (act) { case 46: return {t:1912,w:1.386294}; case 256: return {t:256,w:4000000.750000}; case 258: return {t:1910,w:1.386294}; case 336: return {t:1913,w:0.693147};default: return {t:0,w:0.0};}};
case 1914: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1841,w:0.693147}; case 375: return {t:1842,w:0.693147};default: return {t:0,w:0.0};}};
case 1915: return function (act:Int) {switch (act) { case 256: return {t:812,w:4000000.000000}; case 269: return {t:1979,w:0.000000};default: return {t:0,w:0.0};}};
case 1916: return function (act:Int) {switch (act) { case 48: return {t:1021,w:3.401197}; case 49: return {t:1021,w:3.401197}; case 50: return {t:1021,w:3.401197}; case 51: return {t:1021,w:3.401197}; case 52: return {t:1021,w:3.401197}; case 53: return {t:1021,w:3.401197}; case 54: return {t:1021,w:3.401197}; case 55: return {t:1021,w:3.401197}; case 56: return {t:1021,w:3.401197}; case 57: return {t:1021,w:3.401197}; case 65: return {t:1022,w:6.436150}; case 66: return {t:1022,w:6.436150}; case 67: return {t:1022,w:6.436150}; case 68: return {t:1022,w:6.436150}; case 69: return {t:1022,w:6.436150}; case 70: return {t:1022,w:6.436150}; case 71: return {t:1022,w:6.436150}; case 72: return {t:1022,w:6.436150}; case 73: return {t:1022,w:6.436150}; case 74: return {t:1022,w:6.436150}; case 75: return {t:1022,w:6.436150}; case 76: return {t:1022,w:6.436150}; case 77: return {t:1022,w:6.436150}; case 78: return {t:1022,w:6.436150}; case 79: return {t:1022,w:6.436150}; case 80: return {t:1022,w:6.436150}; case 81: return {t:1022,w:6.436150}; case 82: return {t:1022,w:6.436150}; case 83: return {t:1022,w:6.436150}; case 84: return {t:1022,w:6.436150}; case 85: return {t:1022,w:6.436150}; case 86: return {t:1022,w:6.436150}; case 87: return {t:1022,w:6.436150}; case 88: return {t:1022,w:6.436150}; case 89: return {t:1022,w:6.436150}; case 90: return {t:1022,w:6.436150}; case 91: return {t:884,w:1.098612}; case 97: return {t:1023,w:6.436150}; case 98: return {t:1023,w:6.436150}; case 99: return {t:1023,w:6.436150}; case 100: return {t:1023,w:6.436150}; case 101: return {t:1023,w:6.436150}; case 102: return {t:1023,w:6.436150}; case 103: return {t:1023,w:6.436150}; case 104: return {t:1023,w:6.436150}; case 105: return {t:1023,w:6.436150}; case 106: return {t:1023,w:6.436150}; case 107: return {t:1023,w:6.436150}; case 108: return {t:1023,w:6.436150}; case 109: return {t:1023,w:6.436150}; case 110: return {t:1023,w:6.436150}; case 111: return {t:1023,w:6.436150}; case 112: return {t:1023,w:6.436150}; case 113: return {t:1023,w:6.436150}; case 114: return {t:1023,w:6.436150}; case 115: return {t:1023,w:6.436150}; case 116: return {t:1023,w:6.436150}; case 117: return {t:1023,w:6.436150}; case 118: return {t:1023,w:6.436150}; case 119: return {t:1023,w:6.436150}; case 120: return {t:1023,w:6.436150}; case 121: return {t:1023,w:6.436150}; case 122: return {t:1023,w:6.436150}; case 268: return {t:886,w:2.484906}; case 331: return {t:892,w:2.484906}; case 336: return {t:895,w:1.098612}; case 410: return {t:891,w:1.791759}; case 411: return {t:893,w:1.791759}; case 412: return {t:894,w:1.098612}; case 413: return {t:896,w:1.098612}; case 414: return {t:897,w:1.098612};default: return {t:0,w:0.0};}};
case 1917: return function (act:Int) {switch (act) { case 258: return {t:1980,w:0.000000};default: return {t:0,w:0.0};}};
case 1918: return function (act:Int) {switch (act) { case 68: return {t:1981,w:0.693147}; case 100: return {t:1981,w:0.693147};default: return {t:0,w:0.0};}};
case 1919: return function (act:Int) {switch (act) { case 496: return {t:1919,w:0.000000};default: return {t:0,w:0.0};}};
case 1920: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1919,w:0.693147}; case 336: return {t:1982,w:0.693147};default: return {t:0,w:0.0};}};
case 1921: return function (act:Int) {switch (act) { case 258: return {t:1983,w:0.000000};default: return {t:0,w:0.0};}};
case 1922: return function (act:Int) {switch (act) { case 462: return {t:1922,w:0.000000};default: return {t:0,w:0.0};}};
case 1923: return function (act:Int) {switch (act) { case 69: return {t:1984,w:0.693147}; case 101: return {t:1984,w:0.693147};default: return {t:0,w:0.0};}};
case 1924: return function (act:Int) {switch (act) { case 258: return {t:1985,w:0.000000};default: return {t:0,w:0.0};}};
case 1925: return function (act:Int) {switch (act) { case 256: return {t:933,w:4000000.000000}; case 271: return {t:1986,w:0.000000};default: return {t:0,w:0.0};}};
case 1926: return function (act:Int) {switch (act) { case 82: return {t:1987,w:0.693147}; case 114: return {t:1987,w:0.693147};default: return {t:0,w:0.0};}};
case 1927: return function (act:Int) {switch (act) { case 258: return {t:1930,w:0.000000};default: return {t:0,w:0.0};}};
case 1928: return function (act:Int) {switch (act) { case 79: return {t:1988,w:0.693147}; case 111: return {t:1988,w:0.693147};default: return {t:0,w:0.0};}};
case 1929: return function (act:Int) {switch (act) { case 258: return {t:1989,w:0.000000};default: return {t:0,w:0.0};}};
case 1930: return function (act:Int) {switch (act) { case 464: return {t:1930,w:0.000000};default: return {t:0,w:0.0};}};
case 1931: return function (act:Int) {switch (act) { case 256: return {t:1990,w:4000000.750000}; case 258: return {t:1991,w:0.693147}; case 507: return {t:1992,w:0.693147};default: return {t:0,w:0.0};}};
case 1932: return function (act:Int) {switch (act) { case 256: return {t:1993,w:4000000.750000}; case 258: return {t:1994,w:0.693147}; case 508: return {t:1995,w:0.693147};default: return {t:0,w:0.0};}};
case 1933: return function (act:Int) {switch (act) { case 489: return {t:1933,w:0.000000};default: return {t:0,w:0.0};}};
case 1934: return function (act:Int) {switch (act) { case 256: return {t:1996,w:4000000.000000}; case 404: return {t:1997,w:0.000000};default: return {t:0,w:0.0};}};
case 1935: return function (act:Int) {switch (act) { case 78: return {t:1998,w:0.693147}; case 110: return {t:1998,w:0.693147};default: return {t:0,w:0.0};}};
case 1936: return function (act:Int) {switch (act) { case 73: return {t:1999,w:0.693147}; case 105: return {t:1999,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1937: return function (act:Int) {switch (act) { case 73: return {t:1999,w:0.693147}; case 105: return {t:1999,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1938: return function (act:Int) {switch (act) { case 258: return {t:2000,w:0.000000};default: return {t:0,w:0.0};}};
case 1939: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.000000}; case 377: return {t:2001,w:0.000000};default: return {t:0,w:0.0};}};
case 1940: return function (act:Int) {switch (act) { case 258: return {t:2002,w:0.000000};default: return {t:0,w:0.0};}};
case 1941: return function (act:Int) {switch (act) { case 290: return {t:1941,w:0.000000};default: return {t:0,w:0.0};}};
case 1942: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:2003,w:1.386294}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:2004,w:1.386294}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:862,w:0.693147}; case 404: return {t:2005,w:0.693147};default: return {t:0,w:0.0};}};
case 1943: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1873,w:0.693147}; case 384: return {t:1874,w:0.693147};default: return {t:0,w:0.0};}};
case 1944: return function (act:Int) {switch (act) { case 73: return {t:2006,w:0.693147}; case 105: return {t:2006,w:0.693147};default: return {t:0,w:0.0};}};
case 1945: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:217,w:0.000000};default: return {t:0,w:0.0};}};
case 1946: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:2007,w:0.000000};default: return {t:0,w:0.0};}};
case 1947: return function (act:Int) {switch (act) { case 82: return {t:2008,w:0.693147}; case 114: return {t:2008,w:0.693147};default: return {t:0,w:0.0};}};
case 1948: return function (act:Int) {switch (act) { case 71: return {t:2009,w:0.693147}; case 103: return {t:2009,w:0.693147};default: return {t:0,w:0.0};}};
case 1949: return function (act:Int) {switch (act) { case 67: return {t:2010,w:0.693147}; case 99: return {t:2010,w:0.693147};default: return {t:0,w:0.0};}};
case 1950: return function (act:Int) {switch (act) { case 66: return {t:2011,w:0.693147}; case 98: return {t:2011,w:0.693147};default: return {t:0,w:0.0};}};
case 1951: return function (act:Int) {switch (act) { case 78: return {t:2012,w:0.693147}; case 110: return {t:2012,w:0.693147};default: return {t:0,w:0.0};}};
case 1952: return function (act:Int) {switch (act) { case 76: return {t:2013,w:0.693147}; case 78: return {t:2014,w:0.693147}; case 108: return {t:2013,w:0.693147}; case 110: return {t:2014,w:0.693147};default: return {t:0,w:0.0};}};
case 1953: return function (act:Int) {switch (act) { case 82: return {t:2015,w:0.693147}; case 89: return {t:2016,w:0.693147}; case 114: return {t:2015,w:0.693147}; case 121: return {t:2016,w:0.693147};default: return {t:0,w:0.0};}};
case 1954: return function (act:Int) {switch (act) { case 86: return {t:2017,w:0.693147}; case 118: return {t:2017,w:0.693147};default: return {t:0,w:0.0};}};
case 1955: return function (act:Int) {switch (act) { case 84: return {t:2018,w:0.693147}; case 116: return {t:2018,w:0.693147};default: return {t:0,w:0.0};}};
case 1956: return function (act:Int) {switch (act) { case 80: return {t:2019,w:0.693147}; case 112: return {t:2019,w:0.693147};default: return {t:0,w:0.0};}};
case 1957: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:2020,w:0.000000};default: return {t:0,w:0.0};}};
case 1958: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:2021,w:0.000000};default: return {t:0,w:0.0};}};
case 1959: return function (act:Int) {switch (act) { case 258: return {t:2022,w:0.000000};default: return {t:0,w:0.0};}};
case 1960: return function (act:Int) {switch (act) { case 491: return {t:1960,w:0.000000};default: return {t:0,w:0.0};}};
case 1961: return function (act:Int) {switch (act) { case 256: return {t:1996,w:4000000.000000}; case 404: return {t:2023,w:0.000000};default: return {t:0,w:0.0};}};
case 1962: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:2024,w:0.693147}; case 336: return {t:2025,w:0.693147};default: return {t:0,w:0.0};}};
case 1963: return function (act:Int) {switch (act) { case 425: return {t:1963,w:0.000000};default: return {t:0,w:0.0};}};
case 1964: return function (act:Int) {switch (act) { case 78: return {t:2026,w:0.693147}; case 110: return {t:2026,w:0.693147};default: return {t:0,w:0.0};}};
case 1965: return function (act:Int) {switch (act) { case 71: return {t:2027,w:0.693147}; case 103: return {t:2027,w:0.693147};default: return {t:0,w:0.0};}};
case 1966: return function (act:Int) {switch (act) { case 258: return {t:1675,w:0.000000};default: return {t:0,w:0.0};}};
case 1967: return function (act:Int) {switch (act) { case 258: return {t:1675,w:0.000000};default: return {t:0,w:0.0};}};
case 1968: return function (act:Int) {switch (act) { case 84: return {t:2028,w:0.693147}; case 116: return {t:2028,w:0.693147};default: return {t:0,w:0.0};}};
case 1969: return function (act:Int) {switch (act) { case 73: return {t:2029,w:0.693147}; case 105: return {t:2029,w:0.693147};default: return {t:0,w:0.0};}};
case 1970: return function (act:Int) {switch (act) { case 312: return {t:1970,w:0.000000};default: return {t:0,w:0.0};}};
case 1971: return function (act:Int) {switch (act) { case 256: return {t:313,w:4000000.000000}; case 353: return {t:2030,w:0.000000};default: return {t:0,w:0.0};}};
case 1972: return function (act:Int) {switch (act) { case 499: return {t:1972,w:0.000000};default: return {t:0,w:0.0};}};
case 1973: return function (act:Int) {switch (act) { case 256: return {t:1440,w:4000000.000000}; case 477: return {t:2031,w:0.000000};default: return {t:0,w:0.0};}};
case 1974: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1904,w:0.693147}; case 375: return {t:1905,w:0.693147};default: return {t:0,w:0.0};}};
case 1975: return function (act:Int) {switch (act) { case 85: return {t:2032,w:0.693147}; case 117: return {t:2032,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1976: return function (act:Int) {switch (act) { case 85: return {t:2032,w:0.693147}; case 117: return {t:2032,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 1977: return function (act:Int) {switch (act) { case 258: return {t:2033,w:0.000000};default: return {t:0,w:0.0};}};
case 1978: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:1910,w:0.693147}; case 336: return {t:1978,w:0.693147};default: return {t:0,w:0.0};}};
case 1979: return function (act:Int) {switch (act) { case 258: return {t:2034,w:0.000000};default: return {t:0,w:0.0};}};
case 1980: return function (act:Int) {switch (act) { case 458: return {t:1980,w:0.000000};default: return {t:0,w:0.0};}};
case 1981: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2035,w:0.000000};default: return {t:0,w:0.0};}};
case 1982: return function (act:Int) {switch (act) { case 258: return {t:1919,w:0.000000};default: return {t:0,w:0.0};}};
case 1983: return function (act:Int) {switch (act) { case 500: return {t:1983,w:0.000000};default: return {t:0,w:0.0};}};
case 1984: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:2036,w:0.000000};default: return {t:0,w:0.0};}};
case 1985: return function (act:Int) {switch (act) { case 467: return {t:1985,w:0.000000};default: return {t:0,w:0.0};}};
case 1986: return function (act:Int) {switch (act) { case 258: return {t:2037,w:0.000000};default: return {t:0,w:0.0};}};
case 1987: return function (act:Int) {switch (act) { case 84: return {t:2038,w:0.693147}; case 116: return {t:2038,w:0.693147};default: return {t:0,w:0.0};}};
case 1988: return function (act:Int) {switch (act) { case 78: return {t:2039,w:0.693147}; case 110: return {t:2039,w:0.693147};default: return {t:0,w:0.0};}};
case 1989: return function (act:Int) {switch (act) { case 501: return {t:1989,w:0.000000};default: return {t:0,w:0.0};}};
case 1990: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:2040,w:0.693147}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:488,w:0.693147}; case 350: return {t:2041,w:0.693147}; case 509: return {t:2042,w:0.000000};default: return {t:0,w:0.0};}};
case 1991: return function (act:Int) {switch (act) { case 285: return {t:1991,w:0.000000};default: return {t:0,w:0.0};}};
case 1992: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1991,w:0.693147}; case 375: return {t:2043,w:0.693147};default: return {t:0,w:0.0};}};
case 1993: return function (act:Int) {switch (act) { case 42: return {t:2044,w:0.693147}; case 65: return {t:179,w:4.644391}; case 66: return {t:179,w:4.644391}; case 67: return {t:179,w:4.644391}; case 68: return {t:179,w:4.644391}; case 69: return {t:179,w:4.644391}; case 70: return {t:179,w:4.644391}; case 71: return {t:179,w:4.644391}; case 72: return {t:179,w:4.644391}; case 73: return {t:179,w:4.644391}; case 74: return {t:179,w:4.644391}; case 75: return {t:179,w:4.644391}; case 76: return {t:179,w:4.644391}; case 77: return {t:179,w:4.644391}; case 78: return {t:179,w:4.644391}; case 79: return {t:179,w:4.644391}; case 80: return {t:179,w:4.644391}; case 81: return {t:179,w:4.644391}; case 82: return {t:179,w:4.644391}; case 83: return {t:179,w:4.644391}; case 84: return {t:179,w:4.644391}; case 85: return {t:179,w:4.644391}; case 86: return {t:179,w:4.644391}; case 87: return {t:179,w:4.644391}; case 88: return {t:179,w:4.644391}; case 89: return {t:179,w:4.644391}; case 90: return {t:179,w:4.644391}; case 97: return {t:181,w:4.644391}; case 98: return {t:181,w:4.644391}; case 99: return {t:181,w:4.644391}; case 100: return {t:181,w:4.644391}; case 101: return {t:181,w:4.644391}; case 102: return {t:181,w:4.644391}; case 103: return {t:181,w:4.644391}; case 104: return {t:181,w:4.644391}; case 105: return {t:181,w:4.644391}; case 106: return {t:181,w:4.644391}; case 107: return {t:181,w:4.644391}; case 108: return {t:181,w:4.644391}; case 109: return {t:181,w:4.644391}; case 110: return {t:181,w:4.644391}; case 111: return {t:181,w:4.644391}; case 112: return {t:181,w:4.644391}; case 113: return {t:181,w:4.644391}; case 114: return {t:181,w:4.644391}; case 115: return {t:181,w:4.644391}; case 116: return {t:181,w:4.644391}; case 117: return {t:181,w:4.644391}; case 118: return {t:181,w:4.644391}; case 119: return {t:181,w:4.644391}; case 120: return {t:181,w:4.644391}; case 121: return {t:181,w:4.644391}; case 122: return {t:181,w:4.644391}; case 331: return {t:2045,w:0.693147}; case 510: return {t:2046,w:0.000000};default: return {t:0,w:0.0};}};
case 1994: return function (act:Int) {switch (act) { case 286: return {t:1994,w:0.000000};default: return {t:0,w:0.0};}};
case 1995: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1994,w:0.693147}; case 375: return {t:2047,w:0.693147};default: return {t:0,w:0.0};}};
case 1996: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:862,w:0.000000};default: return {t:0,w:0.0};}};
case 1997: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1933,w:0.693147}; case 384: return {t:1934,w:0.693147};default: return {t:0,w:0.0};}};
case 1998: return function (act:Int) {switch (act) { case 70: return {t:2048,w:0.693147}; case 102: return {t:2048,w:0.693147};default: return {t:0,w:0.0};}};
case 1999: return function (act:Int) {switch (act) { case 71: return {t:2049,w:0.693147}; case 103: return {t:2049,w:0.693147};default: return {t:0,w:0.0};}};
case 2000: return function (act:Int) {switch (act) { case 504: return {t:2000,w:0.000000};default: return {t:0,w:0.0};}};
case 2001: return function (act:Int) {switch (act) { case 256: return {t:2050,w:4000000.000000}; case 511: return {t:2051,w:0.000000};default: return {t:0,w:0.0};}};
case 2002: return function (act:Int) {switch (act) { case 502: return {t:2002,w:0.000000};default: return {t:0,w:0.0};}};
case 2003: return function (act:Int) {switch (act) { case 85: return {t:2052,w:0.693147}; case 117: return {t:2052,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2004: return function (act:Int) {switch (act) { case 85: return {t:2052,w:0.693147}; case 117: return {t:2052,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2005: return function (act:Int) {switch (act) { case 258: return {t:2053,w:0.000000};default: return {t:0,w:0.0};}};
case 2006: return function (act:Int) {switch (act) { case 79: return {t:2054,w:0.693147}; case 111: return {t:2054,w:0.693147};default: return {t:0,w:0.0};}};
case 2007: return function (act:Int) {switch (act) { case 256: return {t:2055,w:4000000.000000}; case 512: return {t:2056,w:0.000000};default: return {t:0,w:0.0};}};
case 2008: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2009: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2010: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2011: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2012: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2013: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2014: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2015: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2016: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2017: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2018: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2019: return function (act:Int) {switch (act) { case 258: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2020: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:2058,w:0.000000};default: return {t:0,w:0.0};}};
case 2021: return function (act:Int) {switch (act) { case 58: return {t:2059,w:0.000000};default: return {t:0,w:0.0};}};
case 2022: return function (act:Int) {switch (act) { case 423: return {t:2022,w:0.000000};default: return {t:0,w:0.0};}};
case 2023: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1960,w:0.693147}; case 384: return {t:1961,w:0.693147};default: return {t:0,w:0.0};}};
case 2024: return function (act:Int) {switch (act) { case 306: return {t:2024,w:0.000000};default: return {t:0,w:0.0};}};
case 2025: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.750000}; case 258: return {t:2024,w:0.693147}; case 336: return {t:2025,w:0.693147};default: return {t:0,w:0.0};}};
case 2026: return function (act:Int) {switch (act) { case 67: return {t:2060,w:0.693147}; case 99: return {t:2060,w:0.693147};default: return {t:0,w:0.0};}};
case 2027: return function (act:Int) {switch (act) { case 69: return {t:2061,w:0.693147}; case 101: return {t:2061,w:0.693147};default: return {t:0,w:0.0};}};
case 2028: return function (act:Int) {switch (act) { case 69: return {t:2062,w:0.693147}; case 101: return {t:2062,w:0.693147};default: return {t:0,w:0.0};}};
case 2029: return function (act:Int) {switch (act) { case 79: return {t:2063,w:0.693147}; case 111: return {t:2063,w:0.693147};default: return {t:0,w:0.0};}};
case 2030: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1970,w:0.693147}; case 375: return {t:1971,w:0.693147};default: return {t:0,w:0.0};}};
case 2031: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:1972,w:0.693147}; case 384: return {t:1973,w:0.693147};default: return {t:0,w:0.0};}};
case 2032: return function (act:Int) {switch (act) { case 82: return {t:2064,w:0.693147}; case 114: return {t:2064,w:0.693147};default: return {t:0,w:0.0};}};
case 2033: return function (act:Int) {switch (act) { case 503: return {t:2033,w:0.000000};default: return {t:0,w:0.0};}};
case 2034: return function (act:Int) {switch (act) { case 460: return {t:2034,w:0.000000};default: return {t:0,w:0.0};}};
case 2035: return function (act:Int) {switch (act) { case 256: return {t:2065,w:4000000.750000}; case 413: return {t:2066,w:0.693147}; case 429: return {t:2067,w:0.693147};default: return {t:0,w:0.0};}};
case 2036: return function (act:Int) {switch (act) { case 256: return {t:2068,w:4000000.000000}; case 513: return {t:2069,w:0.000000};default: return {t:0,w:0.0};}};
case 2037: return function (act:Int) {switch (act) { case 465: return {t:2037,w:0.000000};default: return {t:0,w:0.0};}};
case 2038: return function (act:Int) {switch (act) { case 61: return {t:2070,w:0.000000};default: return {t:0,w:0.0};}};
case 2039: return function (act:Int) {switch (act) { case 69: return {t:2071,w:0.693147}; case 101: return {t:2071,w:0.693147};default: return {t:0,w:0.0};}};
case 2040: return function (act:Int) {switch (act) { case 33: return {t:39,w:5.488937}; case 37: return {t:40,w:5.488937}; case 39: return {t:41,w:5.488937}; case 42: return {t:42,w:5.488937}; case 43: return {t:43,w:5.488937}; case 45: return {t:44,w:5.488937}; case 46: return {t:45,w:5.488937}; case 95: return {t:46,w:5.488937}; case 96: return {t:47,w:5.488937}; case 126: return {t:48,w:5.488937}; case 256: return {t:49,w:4000005.750000}; case 258: return {t:2072,w:0.000000}; case 268: return {t:51,w:5.488937};default: return {t:0,w:0.0};}};
case 2041: return function (act:Int) {switch (act) { case 258: return {t:2073,w:0.000000};default: return {t:0,w:0.0};}};
case 2042: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:2074,w:0.693147}; case 384: return {t:2075,w:0.693147};default: return {t:0,w:0.0};}};
case 2043: return function (act:Int) {switch (act) { case 256: return {t:1990,w:4000000.000000}; case 507: return {t:2076,w:0.000000};default: return {t:0,w:0.0};}};
case 2044: return function (act:Int) {switch (act) { case 258: return {t:2077,w:0.000000};default: return {t:0,w:0.0};}};
case 2045: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2080,w:0.693147};default: return {t:0,w:0.0};}};
case 2046: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:2081,w:0.693147}; case 384: return {t:2082,w:0.693147};default: return {t:0,w:0.0};}};
case 2047: return function (act:Int) {switch (act) { case 256: return {t:1993,w:4000000.000000}; case 508: return {t:2083,w:0.000000};default: return {t:0,w:0.0};}};
case 2048: return function (act:Int) {switch (act) { case 79: return {t:2084,w:0.693147}; case 111: return {t:2084,w:0.693147};default: return {t:0,w:0.0};}};
case 2049: return function (act:Int) {switch (act) { case 69: return {t:2085,w:0.693147}; case 101: return {t:2085,w:0.693147};default: return {t:0,w:0.0};}};
case 2050: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:2086,w:0.000000}; case 514: return {t:2087,w:0.000000};default: return {t:0,w:0.0};}};
case 2051: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2088,w:0.693147}; case 375: return {t:2089,w:0.693147};default: return {t:0,w:0.0};}};
case 2052: return function (act:Int) {switch (act) { case 82: return {t:2090,w:0.693147}; case 114: return {t:2090,w:0.693147};default: return {t:0,w:0.0};}};
case 2053: return function (act:Int) {switch (act) { case 506: return {t:2053,w:0.000000};default: return {t:0,w:0.0};}};
case 2054: return function (act:Int) {switch (act) { case 78: return {t:2091,w:0.693147}; case 110: return {t:2091,w:0.693147};default: return {t:0,w:0.0};}};
case 2055: return function (act:Int) {switch (act) { case 65: return {t:179,w:3.951244}; case 66: return {t:179,w:3.951244}; case 67: return {t:179,w:3.951244}; case 68: return {t:179,w:3.951244}; case 69: return {t:179,w:3.951244}; case 70: return {t:179,w:3.951244}; case 71: return {t:179,w:3.951244}; case 72: return {t:179,w:3.951244}; case 73: return {t:179,w:3.951244}; case 74: return {t:179,w:3.951244}; case 75: return {t:179,w:3.951244}; case 76: return {t:179,w:3.951244}; case 77: return {t:179,w:3.951244}; case 78: return {t:179,w:3.951244}; case 79: return {t:179,w:3.951244}; case 80: return {t:179,w:3.951244}; case 81: return {t:179,w:3.951244}; case 82: return {t:179,w:3.951244}; case 83: return {t:179,w:3.951244}; case 84: return {t:179,w:3.951244}; case 85: return {t:179,w:3.951244}; case 86: return {t:179,w:3.951244}; case 87: return {t:179,w:3.951244}; case 88: return {t:179,w:3.951244}; case 89: return {t:179,w:3.951244}; case 90: return {t:179,w:3.951244}; case 97: return {t:181,w:3.951244}; case 98: return {t:181,w:3.951244}; case 99: return {t:181,w:3.951244}; case 100: return {t:181,w:3.951244}; case 101: return {t:181,w:3.951244}; case 102: return {t:181,w:3.951244}; case 103: return {t:181,w:3.951244}; case 104: return {t:181,w:3.951244}; case 105: return {t:181,w:3.951244}; case 106: return {t:181,w:3.951244}; case 107: return {t:181,w:3.951244}; case 108: return {t:181,w:3.951244}; case 109: return {t:181,w:3.951244}; case 110: return {t:181,w:3.951244}; case 111: return {t:181,w:3.951244}; case 112: return {t:181,w:3.951244}; case 113: return {t:181,w:3.951244}; case 114: return {t:181,w:3.951244}; case 115: return {t:181,w:3.951244}; case 116: return {t:181,w:3.951244}; case 117: return {t:181,w:3.951244}; case 118: return {t:181,w:3.951244}; case 119: return {t:181,w:3.951244}; case 120: return {t:181,w:3.951244}; case 121: return {t:181,w:3.951244}; case 122: return {t:181,w:3.951244}; case 331: return {t:2092,w:0.000000}; case 515: return {t:2093,w:0.000000};default: return {t:0,w:0.0};}};
case 2056: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2094,w:0.693147}; case 375: return {t:2095,w:0.693147};default: return {t:0,w:0.0};}};
case 2057: return function (act:Int) {switch (act) { case 498: return {t:2057,w:0.000000};default: return {t:0,w:0.0};}};
case 2058: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:2096,w:0.000000};default: return {t:0,w:0.0};}};
case 2059: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:2097,w:0.000000};default: return {t:0,w:0.0};}};
case 2060: return function (act:Int) {switch (act) { case 89: return {t:2098,w:0.693147}; case 121: return {t:2098,w:0.693147};default: return {t:0,w:0.0};}};
case 2061: return function (act:Int) {switch (act) { case 78: return {t:2099,w:0.693147}; case 110: return {t:2099,w:0.693147};default: return {t:0,w:0.0};}};
case 2062: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:2100,w:0.000000};default: return {t:0,w:0.0};}};
case 2063: return function (act:Int) {switch (act) { case 78: return {t:2101,w:0.693147}; case 110: return {t:2101,w:0.693147};default: return {t:0,w:0.0};}};
case 2064: return function (act:Int) {switch (act) { case 65: return {t:2102,w:0.693147}; case 97: return {t:2102,w:0.693147};default: return {t:0,w:0.0};}};
case 2065: return function (act:Int) {switch (act) { case 48: return {t:2103,w:2.302585}; case 49: return {t:2103,w:2.302585}; case 50: return {t:2103,w:2.302585}; case 51: return {t:2103,w:2.302585}; case 52: return {t:2103,w:2.302585}; case 53: return {t:2103,w:2.302585}; case 54: return {t:2103,w:2.302585}; case 55: return {t:2103,w:2.302585}; case 56: return {t:2103,w:2.302585}; case 57: return {t:2103,w:2.302585}; case 58: return {t:1179,w:1.098612}; case 65: return {t:788,w:3.988983}; case 66: return {t:788,w:3.988983}; case 67: return {t:788,w:3.988983}; case 68: return {t:788,w:3.988983}; case 69: return {t:788,w:3.988983}; case 70: return {t:788,w:3.988983}; case 97: return {t:789,w:3.988983}; case 98: return {t:789,w:3.988983}; case 99: return {t:789,w:3.988983}; case 100: return {t:789,w:3.988983}; case 101: return {t:789,w:3.988983}; case 102: return {t:789,w:3.988983}; case 336: return {t:895,w:0.000000}; case 390: return {t:1180,w:1.098612}; case 441: return {t:1181,w:1.098612}; case 442: return {t:1182,w:1.098612}; case 443: return {t:1183,w:0.000000};default: return {t:0,w:0.0};}};
case 2066: return function (act:Int) {switch (act) { case 258: return {t:2104,w:0.000000};default: return {t:0,w:0.0};}};
case 2067: return function (act:Int) {switch (act) { case 258: return {t:2104,w:0.000000};default: return {t:0,w:0.0};}};
case 2068: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:2105,w:1.386294}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:13,w:7.447752}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:2106,w:1.386294}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:20,w:7.447752}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:1938,w:0.693147}; case 504: return {t:2107,w:0.693147}; case 516: return {t:2108,w:0.693147};default: return {t:0,w:0.0};}};
case 2069: return function (act:Int) {switch (act) { case 258: return {t:2109,w:0.000000};default: return {t:0,w:0.0};}};
case 2070: return function (act:Int) {switch (act) { case 83: return {t:2110,w:2.302585}; case 84: return {t:2111,w:2.302585}; case 85: return {t:2112,w:2.302585}; case 115: return {t:2110,w:2.302585}; case 116: return {t:2111,w:2.302585}; case 117: return {t:2112,w:2.302585}; case 256: return {t:2113,w:4000001.500000}; case 456: return {t:2114,w:1.609438};default: return {t:0,w:0.0};}};
case 2071: return function (act:Int) {switch (act) { case 258: return {t:1930,w:0.000000};default: return {t:0,w:0.0};}};
case 2072: return function (act:Int) {switch (act) { case 269: return {t:50,w:3.091042}; case 509: return {t:2073,w:0.000000};default: return {t:0,w:0.0};}};
case 2073: return function (act:Int) {switch (act) { case 509: return {t:2073,w:0.000000};default: return {t:0,w:0.0};}};
case 2074: return function (act:Int) {switch (act) { case 507: return {t:2074,w:0.000000};default: return {t:0,w:0.0};}};
case 2075: return function (act:Int) {switch (act) { case 256: return {t:1535,w:4000000.000000}; case 483: return {t:2115,w:0.000000};default: return {t:0,w:0.0};}};
case 2076: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1991,w:0.693147}; case 375: return {t:2043,w:0.693147};default: return {t:0,w:0.0};}};
case 2077: return function (act:Int) {switch (act) { case 510: return {t:2077,w:0.000000};default: return {t:0,w:0.0};}};
case 2078: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.000000}; case 331: return {t:2116,w:0.000000};default: return {t:0,w:0.0};}};
case 2079: return function (act:Int) {switch (act) { case 65: return {t:179,w:3.951244}; case 66: return {t:179,w:3.951244}; case 67: return {t:179,w:3.951244}; case 68: return {t:179,w:3.951244}; case 69: return {t:179,w:3.951244}; case 70: return {t:179,w:3.951244}; case 71: return {t:179,w:3.951244}; case 72: return {t:179,w:3.951244}; case 73: return {t:179,w:3.951244}; case 74: return {t:179,w:3.951244}; case 75: return {t:179,w:3.951244}; case 76: return {t:179,w:3.951244}; case 77: return {t:179,w:3.951244}; case 78: return {t:179,w:3.951244}; case 79: return {t:179,w:3.951244}; case 80: return {t:179,w:3.951244}; case 81: return {t:179,w:3.951244}; case 82: return {t:179,w:3.951244}; case 83: return {t:179,w:3.951244}; case 84: return {t:179,w:3.951244}; case 85: return {t:179,w:3.951244}; case 86: return {t:179,w:3.951244}; case 87: return {t:179,w:3.951244}; case 88: return {t:179,w:3.951244}; case 89: return {t:179,w:3.951244}; case 90: return {t:179,w:3.951244}; case 97: return {t:181,w:3.951244}; case 98: return {t:181,w:3.951244}; case 99: return {t:181,w:3.951244}; case 100: return {t:181,w:3.951244}; case 101: return {t:181,w:3.951244}; case 102: return {t:181,w:3.951244}; case 103: return {t:181,w:3.951244}; case 104: return {t:181,w:3.951244}; case 105: return {t:181,w:3.951244}; case 106: return {t:181,w:3.951244}; case 107: return {t:181,w:3.951244}; case 108: return {t:181,w:3.951244}; case 109: return {t:181,w:3.951244}; case 110: return {t:181,w:3.951244}; case 111: return {t:181,w:3.951244}; case 112: return {t:181,w:3.951244}; case 113: return {t:181,w:3.951244}; case 114: return {t:181,w:3.951244}; case 115: return {t:181,w:3.951244}; case 116: return {t:181,w:3.951244}; case 117: return {t:181,w:3.951244}; case 118: return {t:181,w:3.951244}; case 119: return {t:181,w:3.951244}; case 120: return {t:181,w:3.951244}; case 121: return {t:181,w:3.951244}; case 122: return {t:181,w:3.951244};default: return {t:0,w:0.0};}};
case 2080: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2117,w:0.693147};default: return {t:0,w:0.0};}};
case 2081: return function (act:Int) {switch (act) { case 508: return {t:2081,w:0.000000};default: return {t:0,w:0.0};}};
case 2082: return function (act:Int) {switch (act) { case 256: return {t:1535,w:4000000.000000}; case 483: return {t:2118,w:0.000000};default: return {t:0,w:0.0};}};
case 2083: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:1994,w:0.693147}; case 375: return {t:2047,w:0.693147};default: return {t:0,w:0.0};}};
case 2084: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:2119,w:0.000000};default: return {t:0,w:0.0};}};
case 2085: return function (act:Int) {switch (act) { case 83: return {t:2120,w:0.693147}; case 115: return {t:2120,w:0.693147};default: return {t:0,w:0.0};}};
case 2086: return function (act:Int) {switch (act) { case 258: return {t:2121,w:0.000000};default: return {t:0,w:0.0};}};
case 2087: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2122,w:0.000000};default: return {t:0,w:0.0};}};
case 2088: return function (act:Int) {switch (act) { case 505: return {t:2088,w:0.000000};default: return {t:0,w:0.0};}};
case 2089: return function (act:Int) {switch (act) { case 256: return {t:2050,w:4000000.000000}; case 511: return {t:2123,w:0.000000};default: return {t:0,w:0.0};}};
case 2090: return function (act:Int) {switch (act) { case 80: return {t:2124,w:0.693147}; case 112: return {t:2124,w:0.693147};default: return {t:0,w:0.0};}};
case 2091: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:2125,w:0.000000};default: return {t:0,w:0.0};}};
case 2092: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2126,w:0.693147}; case 331: return {t:2127,w:0.693147};default: return {t:0,w:0.0};}};
case 2093: return function (act:Int) {switch (act) { case 45: return {t:2128,w:0.693147}; case 258: return {t:2129,w:0.693147};default: return {t:0,w:0.0};}};
case 2094: return function (act:Int) {switch (act) { case 296: return {t:2094,w:0.000000};default: return {t:0,w:0.0};}};
case 2095: return function (act:Int) {switch (act) { case 256: return {t:2055,w:4000000.000000}; case 512: return {t:2130,w:0.000000};default: return {t:0,w:0.0};}};
case 2096: return function (act:Int) {switch (act) { case 258: return {t:2131,w:0.000000};default: return {t:0,w:0.0};}};
case 2097: return function (act:Int) {switch (act) { case 256: return {t:256,w:4000000.000000}; case 336: return {t:2132,w:0.000000};default: return {t:0,w:0.0};}};
case 2098: return function (act:Int) {switch (act) { case 258: return {t:1675,w:0.000000};default: return {t:0,w:0.0};}};
case 2099: return function (act:Int) {switch (act) { case 84: return {t:2133,w:0.693147}; case 116: return {t:2133,w:0.693147};default: return {t:0,w:0.0};}};
case 2100: return function (act:Int) {switch (act) { case 256: return {t:2068,w:4000000.000000}; case 513: return {t:2134,w:0.000000};default: return {t:0,w:0.0};}};
case 2101: return function (act:Int) {switch (act) { case 256: return {t:212,w:4000000.000000}; case 344: return {t:2135,w:0.000000};default: return {t:0,w:0.0};}};
case 2102: return function (act:Int) {switch (act) { case 84: return {t:2136,w:0.693147}; case 116: return {t:2136,w:0.693147};default: return {t:0,w:0.0};}};
case 2103: return function (act:Int) {switch (act) { case 258: return {t:2137,w:0.000000};default: return {t:0,w:0.0};}};
case 2104: return function (act:Int) {switch (act) { case 459: return {t:2104,w:0.000000};default: return {t:0,w:0.0};}};
case 2105: return function (act:Int) {switch (act) { case 73: return {t:2138,w:0.693147}; case 105: return {t:2138,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2106: return function (act:Int) {switch (act) { case 73: return {t:2138,w:0.693147}; case 105: return {t:2138,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2107: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.000000}; case 377: return {t:2139,w:0.000000};default: return {t:0,w:0.0};}};
case 2108: return function (act:Int) {switch (act) { case 258: return {t:2140,w:0.000000};default: return {t:0,w:0.0};}};
case 2109: return function (act:Int) {switch (act) { case 327: return {t:2109,w:0.000000};default: return {t:0,w:0.0};}};
case 2110: return function (act:Int) {switch (act) { case 67: return {t:2141,w:0.693147}; case 99: return {t:2141,w:0.693147};default: return {t:0,w:0.0};}};
case 2111: return function (act:Int) {switch (act) { case 67: return {t:2142,w:0.693147}; case 76: return {t:2143,w:0.693147}; case 99: return {t:2142,w:0.693147}; case 108: return {t:2143,w:0.693147};default: return {t:0,w:0.0};}};
case 2112: return function (act:Int) {switch (act) { case 68: return {t:2144,w:0.693147}; case 100: return {t:2144,w:0.693147};default: return {t:0,w:0.0};}};
case 2113: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:1301,w:0.000000};default: return {t:0,w:0.0};}};
case 2114: return function (act:Int) {switch (act) { case 258: return {t:2145,w:0.000000};default: return {t:0,w:0.0};}};
case 2115: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:2074,w:0.693147}; case 384: return {t:2075,w:0.693147};default: return {t:0,w:0.0};}};
case 2116: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2146,w:0.693147};default: return {t:0,w:0.0};}};
case 2117: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2147,w:0.693147};default: return {t:0,w:0.0};}};
case 2118: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:2081,w:0.693147}; case 384: return {t:2082,w:0.693147};default: return {t:0,w:0.0};}};
case 2119: return function (act:Int) {switch (act) { case 256: return {t:2148,w:4000000.000000}; case 517: return {t:2149,w:0.000000};default: return {t:0,w:0.0};}};
case 2120: return function (act:Int) {switch (act) { case 84: return {t:2150,w:0.693147}; case 116: return {t:2150,w:0.693147};default: return {t:0,w:0.0};}};
case 2121: return function (act:Int) {switch (act) { case 514: return {t:2121,w:0.000000};default: return {t:0,w:0.0};}};
case 2122: return function (act:Int) {switch (act) { case 256: return {t:2151,w:4000000.750000}; case 269: return {t:2152,w:0.693147}; case 378: return {t:2153,w:0.693147};default: return {t:0,w:0.0};}};
case 2123: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2088,w:0.693147}; case 375: return {t:2089,w:0.693147};default: return {t:0,w:0.0};}};
case 2124: return function (act:Int) {switch (act) { case 79: return {t:2154,w:0.693147}; case 111: return {t:2154,w:0.693147};default: return {t:0,w:0.0};}};
case 2125: return function (act:Int) {switch (act) { case 256: return {t:2155,w:4000000.000000}; case 518: return {t:2156,w:0.000000};default: return {t:0,w:0.0};}};
case 2126: return function (act:Int) {switch (act) { case 515: return {t:2126,w:0.000000};default: return {t:0,w:0.0};}};
case 2127: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2126,w:0.693147}; case 331: return {t:2157,w:0.693147};default: return {t:0,w:0.0};}};
case 2128: return function (act:Int) {switch (act) { case 256: return {t:2158,w:4000000.000000}; case 519: return {t:2159,w:0.000000};default: return {t:0,w:0.0};}};
case 2129: return function (act:Int) {switch (act) { case 512: return {t:2129,w:0.000000};default: return {t:0,w:0.0};}};
case 2130: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2094,w:0.693147}; case 375: return {t:2095,w:0.693147};default: return {t:0,w:0.0};}};
case 2131: return function (act:Int) {switch (act) { case 474: return {t:2131,w:0.000000};default: return {t:0,w:0.0};}};
case 2132: return function (act:Int) {switch (act) { case 258: return {t:2160,w:0.000000};default: return {t:0,w:0.0};}};
case 2133: return function (act:Int) {switch (act) { case 258: return {t:1675,w:0.000000};default: return {t:0,w:0.0};}};
case 2134: return function (act:Int) {switch (act) { case 258: return {t:2161,w:0.000000};default: return {t:0,w:0.0};}};
case 2135: return function (act:Int) {switch (act) { case 256: return {t:1871,w:4000000.000000}; case 502: return {t:2162,w:0.000000};default: return {t:0,w:0.0};}};
case 2136: return function (act:Int) {switch (act) { case 73: return {t:2163,w:0.693147}; case 105: return {t:2163,w:0.693147};default: return {t:0,w:0.0};}};
case 2137: return function (act:Int) {switch (act) { case 336: return {t:271,w:0.000000}; case 390: return {t:925,w:2.197224};default: return {t:0,w:0.0};}};
case 2138: return function (act:Int) {switch (act) { case 71: return {t:2164,w:0.693147}; case 103: return {t:2164,w:0.693147};default: return {t:0,w:0.0};}};
case 2139: return function (act:Int) {switch (act) { case 256: return {t:2050,w:4000000.000000}; case 511: return {t:2165,w:0.000000};default: return {t:0,w:0.0};}};
case 2140: return function (act:Int) {switch (act) { case 513: return {t:2140,w:0.000000};default: return {t:0,w:0.0};}};
case 2141: return function (act:Int) {switch (act) { case 84: return {t:2166,w:0.693147}; case 116: return {t:2166,w:0.693147};default: return {t:0,w:0.0};}};
case 2142: return function (act:Int) {switch (act) { case 80: return {t:2167,w:0.693147}; case 112: return {t:2167,w:0.693147};default: return {t:0,w:0.0};}};
case 2143: return function (act:Int) {switch (act) { case 83: return {t:2168,w:0.693147}; case 115: return {t:2168,w:0.693147};default: return {t:0,w:0.0};}};
case 2144: return function (act:Int) {switch (act) { case 80: return {t:2169,w:0.693147}; case 112: return {t:2169,w:0.693147};default: return {t:0,w:0.0};}};
case 2145: return function (act:Int) {switch (act) { case 463: return {t:2145,w:0.000000};default: return {t:0,w:0.0};}};
case 2146: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2170,w:0.693147};default: return {t:0,w:0.0};}};
case 2147: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2171,w:0.693147};default: return {t:0,w:0.0};}};
case 2148: return function (act:Int) {switch (act) { case 67: return {t:2172,w:2.302585}; case 78: return {t:2173,w:2.302585}; case 81: return {t:2174,w:2.302585}; case 82: return {t:2175,w:2.302585}; case 99: return {t:2172,w:2.302585}; case 110: return {t:2173,w:2.302585}; case 113: return {t:2174,w:2.302585}; case 114: return {t:2175,w:2.302585}; case 520: return {t:2176,w:1.609438}; case 521: return {t:2177,w:1.609438}; case 522: return {t:2178,w:1.609438}; case 523: return {t:2179,w:1.609438}; case 524: return {t:2180,w:1.609438};default: return {t:0,w:0.0};}};
case 2149: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2181,w:0.693147}; case 375: return {t:2182,w:0.693147};default: return {t:0,w:0.0};}};
case 2150: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.000000}; case 377: return {t:2183,w:0.000000};default: return {t:0,w:0.0};}};
case 2151: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 258: return {t:651,w:0.693147}; case 268: return {t:29,w:2.397895}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1291,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 2152: return function (act:Int) {switch (act) { case 258: return {t:2184,w:0.000000};default: return {t:0,w:0.0};}};
case 2153: return function (act:Int) {switch (act) { case 258: return {t:2184,w:0.000000};default: return {t:0,w:0.0};}};
case 2154: return function (act:Int) {switch (act) { case 83: return {t:2185,w:0.693147}; case 115: return {t:2185,w:0.693147};default: return {t:0,w:0.0};}};
case 2155: return function (act:Int) {switch (act) { case 33: return {t:2,w:4.007333}; case 37: return {t:3,w:4.007333}; case 39: return {t:4,w:4.007333}; case 42: return {t:5,w:4.007333}; case 43: return {t:6,w:4.007333}; case 45: return {t:7,w:4.007333}; case 46: return {t:8,w:4.007333}; case 48: return {t:9,w:7.408530}; case 49: return {t:9,w:7.408530}; case 50: return {t:9,w:7.408530}; case 51: return {t:9,w:7.408530}; case 52: return {t:9,w:7.408530}; case 53: return {t:9,w:7.408530}; case 54: return {t:9,w:7.408530}; case 55: return {t:9,w:7.408530}; case 56: return {t:9,w:7.408530}; case 57: return {t:9,w:7.408530}; case 65: return {t:2186,w:2.302585}; case 66: return {t:13,w:8.364042}; case 67: return {t:13,w:8.364042}; case 68: return {t:13,w:8.364042}; case 69: return {t:13,w:8.364042}; case 70: return {t:13,w:8.364042}; case 71: return {t:13,w:8.364042}; case 72: return {t:13,w:8.364042}; case 73: return {t:2187,w:2.302585}; case 74: return {t:13,w:8.364042}; case 75: return {t:13,w:8.364042}; case 76: return {t:13,w:8.364042}; case 77: return {t:13,w:8.364042}; case 78: return {t:13,w:8.364042}; case 79: return {t:13,w:8.364042}; case 80: return {t:13,w:8.364042}; case 81: return {t:13,w:8.364042}; case 82: return {t:2188,w:2.302585}; case 83: return {t:2189,w:2.302585}; case 84: return {t:13,w:8.364042}; case 85: return {t:13,w:8.364042}; case 86: return {t:13,w:8.364042}; case 87: return {t:13,w:8.364042}; case 88: return {t:13,w:8.364042}; case 89: return {t:13,w:8.364042}; case 90: return {t:13,w:8.364042}; case 95: return {t:18,w:4.007333}; case 96: return {t:19,w:4.007333}; case 97: return {t:2190,w:2.302585}; case 98: return {t:20,w:8.364042}; case 99: return {t:20,w:8.364042}; case 100: return {t:20,w:8.364042}; case 101: return {t:20,w:8.364042}; case 102: return {t:20,w:8.364042}; case 103: return {t:20,w:8.364042}; case 104: return {t:20,w:8.364042}; case 105: return {t:2191,w:2.302585}; case 106: return {t:20,w:8.364042}; case 107: return {t:20,w:8.364042}; case 108: return {t:20,w:8.364042}; case 109: return {t:20,w:8.364042}; case 110: return {t:20,w:8.364042}; case 111: return {t:20,w:8.364042}; case 112: return {t:20,w:8.364042}; case 113: return {t:20,w:8.364042}; case 114: return {t:2192,w:2.302585}; case 115: return {t:2193,w:2.302585}; case 116: return {t:20,w:8.364042}; case 117: return {t:20,w:8.364042}; case 118: return {t:20,w:8.364042}; case 119: return {t:20,w:8.364042}; case 120: return {t:20,w:8.364042}; case 121: return {t:20,w:8.364042}; case 122: return {t:20,w:8.364042}; case 126: return {t:22,w:4.007333}; case 268: return {t:29,w:4.007333}; case 269: return {t:2194,w:1.609438}; case 525: return {t:2195,w:1.609438};default: return {t:0,w:0.0};}};
case 2156: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:2196,w:0.693147}; case 384: return {t:2197,w:0.693147};default: return {t:0,w:0.0};}};
case 2157: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2126,w:0.693147}; case 331: return {t:2198,w:0.693147};default: return {t:0,w:0.0};}};
case 2158: return function (act:Int) {switch (act) { case 65: return {t:179,w:3.951244}; case 66: return {t:179,w:3.951244}; case 67: return {t:179,w:3.951244}; case 68: return {t:179,w:3.951244}; case 69: return {t:179,w:3.951244}; case 70: return {t:179,w:3.951244}; case 71: return {t:179,w:3.951244}; case 72: return {t:179,w:3.951244}; case 73: return {t:179,w:3.951244}; case 74: return {t:179,w:3.951244}; case 75: return {t:179,w:3.951244}; case 76: return {t:179,w:3.951244}; case 77: return {t:179,w:3.951244}; case 78: return {t:179,w:3.951244}; case 79: return {t:179,w:3.951244}; case 80: return {t:179,w:3.951244}; case 81: return {t:179,w:3.951244}; case 82: return {t:179,w:3.951244}; case 83: return {t:179,w:3.951244}; case 84: return {t:179,w:3.951244}; case 85: return {t:179,w:3.951244}; case 86: return {t:179,w:3.951244}; case 87: return {t:179,w:3.951244}; case 88: return {t:179,w:3.951244}; case 89: return {t:179,w:3.951244}; case 90: return {t:179,w:3.951244}; case 97: return {t:181,w:3.951244}; case 98: return {t:181,w:3.951244}; case 99: return {t:181,w:3.951244}; case 100: return {t:181,w:3.951244}; case 101: return {t:181,w:3.951244}; case 102: return {t:181,w:3.951244}; case 103: return {t:181,w:3.951244}; case 104: return {t:181,w:3.951244}; case 105: return {t:181,w:3.951244}; case 106: return {t:181,w:3.951244}; case 107: return {t:181,w:3.951244}; case 108: return {t:181,w:3.951244}; case 109: return {t:181,w:3.951244}; case 110: return {t:181,w:3.951244}; case 111: return {t:181,w:3.951244}; case 112: return {t:181,w:3.951244}; case 113: return {t:181,w:3.951244}; case 114: return {t:181,w:3.951244}; case 115: return {t:181,w:3.951244}; case 116: return {t:181,w:3.951244}; case 117: return {t:181,w:3.951244}; case 118: return {t:181,w:3.951244}; case 119: return {t:181,w:3.951244}; case 120: return {t:181,w:3.951244}; case 121: return {t:181,w:3.951244}; case 122: return {t:181,w:3.951244}; case 331: return {t:2199,w:0.000000};default: return {t:0,w:0.0};}};
case 2159: return function (act:Int) {switch (act) { case 45: return {t:2128,w:0.693147}; case 258: return {t:2129,w:0.693147};default: return {t:0,w:0.0};}};
case 2160: return function (act:Int) {switch (act) { case 490: return {t:2160,w:0.000000};default: return {t:0,w:0.0};}};
case 2161: return function (act:Int) {switch (act) { case 310: return {t:2161,w:0.000000};default: return {t:0,w:0.0};}};
case 2162: return function (act:Int) {switch (act) { case 258: return {t:2200,w:0.000000};default: return {t:0,w:0.0};}};
case 2163: return function (act:Int) {switch (act) { case 79: return {t:2201,w:0.693147}; case 111: return {t:2201,w:0.693147};default: return {t:0,w:0.0};}};
case 2164: return function (act:Int) {switch (act) { case 69: return {t:2202,w:0.693147}; case 101: return {t:2202,w:0.693147};default: return {t:0,w:0.0};}};
case 2165: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2203,w:0.693147}; case 375: return {t:2204,w:0.693147};default: return {t:0,w:0.0};}};
case 2166: return function (act:Int) {switch (act) { case 80: return {t:2205,w:0.693147}; case 112: return {t:2205,w:0.693147};default: return {t:0,w:0.0};}};
case 2167: return function (act:Int) {switch (act) { case 258: return {t:2145,w:0.000000};default: return {t:0,w:0.0};}};
case 2168: return function (act:Int) {switch (act) { case 258: return {t:2145,w:0.000000};default: return {t:0,w:0.0};}};
case 2169: return function (act:Int) {switch (act) { case 258: return {t:2145,w:0.000000};default: return {t:0,w:0.0};}};
case 2170: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2206,w:0.693147};default: return {t:0,w:0.0};}};
case 2171: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2207,w:0.693147};default: return {t:0,w:0.0};}};
case 2172: return function (act:Int) {switch (act) { case 78: return {t:2208,w:0.693147}; case 110: return {t:2208,w:0.693147};default: return {t:0,w:0.0};}};
case 2173: return function (act:Int) {switch (act) { case 67: return {t:2209,w:0.693147}; case 69: return {t:2210,w:0.693147}; case 99: return {t:2209,w:0.693147}; case 101: return {t:2210,w:0.693147};default: return {t:0,w:0.0};}};
case 2174: return function (act:Int) {switch (act) { case 79: return {t:2211,w:0.693147}; case 111: return {t:2211,w:0.693147};default: return {t:0,w:0.0};}};
case 2175: return function (act:Int) {switch (act) { case 83: return {t:2212,w:0.693147}; case 115: return {t:2212,w:0.693147};default: return {t:0,w:0.0};}};
case 2176: return function (act:Int) {switch (act) { case 258: return {t:2213,w:0.000000};default: return {t:0,w:0.0};}};
case 2177: return function (act:Int) {switch (act) { case 258: return {t:2213,w:0.000000};default: return {t:0,w:0.0};}};
case 2178: return function (act:Int) {switch (act) { case 258: return {t:2213,w:0.000000};default: return {t:0,w:0.0};}};
case 2179: return function (act:Int) {switch (act) { case 258: return {t:2213,w:0.000000};default: return {t:0,w:0.0};}};
case 2180: return function (act:Int) {switch (act) { case 258: return {t:2213,w:0.000000};default: return {t:0,w:0.0};}};
case 2181: return function (act:Int) {switch (act) { case 289: return {t:2181,w:0.000000};default: return {t:0,w:0.0};}};
case 2182: return function (act:Int) {switch (act) { case 256: return {t:2148,w:4000000.000000}; case 517: return {t:2214,w:0.000000};default: return {t:0,w:0.0};}};
case 2183: return function (act:Int) {switch (act) { case 256: return {t:2215,w:4000000.000000}; case 526: return {t:2216,w:0.000000};default: return {t:0,w:0.0};}};
case 2184: return function (act:Int) {switch (act) { case 511: return {t:2184,w:0.000000};default: return {t:0,w:0.0};}};
case 2185: return function (act:Int) {switch (act) { case 69: return {t:2217,w:0.693147}; case 101: return {t:2217,w:0.693147};default: return {t:0,w:0.0};}};
case 2186: return function (act:Int) {switch (act) { case 76: return {t:2218,w:0.693147}; case 108: return {t:2218,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2187: return function (act:Int) {switch (act) { case 67: return {t:2219,w:0.693147}; case 99: return {t:2219,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2188: return function (act:Int) {switch (act) { case 69: return {t:2220,w:0.693147}; case 101: return {t:2220,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2189: return function (act:Int) {switch (act) { case 69: return {t:2221,w:0.693147}; case 101: return {t:2221,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2190: return function (act:Int) {switch (act) { case 76: return {t:2218,w:0.693147}; case 108: return {t:2218,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2191: return function (act:Int) {switch (act) { case 67: return {t:2219,w:0.693147}; case 99: return {t:2219,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2192: return function (act:Int) {switch (act) { case 69: return {t:2220,w:0.693147}; case 101: return {t:2220,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2193: return function (act:Int) {switch (act) { case 69: return {t:2221,w:0.693147}; case 101: return {t:2221,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2194: return function (act:Int) {switch (act) { case 258: return {t:2222,w:0.000000};default: return {t:0,w:0.0};}};
case 2195: return function (act:Int) {switch (act) { case 258: return {t:2223,w:0.000000};default: return {t:0,w:0.0};}};
case 2196: return function (act:Int) {switch (act) { case 294: return {t:2196,w:0.000000};default: return {t:0,w:0.0};}};
case 2197: return function (act:Int) {switch (act) { case 256: return {t:2224,w:4000000.000000}; case 527: return {t:2225,w:0.000000};default: return {t:0,w:0.0};}};
case 2198: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2126,w:0.693147}; case 331: return {t:2226,w:0.693147};default: return {t:0,w:0.0};}};
case 2199: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2227,w:0.693147}; case 331: return {t:2228,w:0.693147};default: return {t:0,w:0.0};}};
case 2200: return function (act:Int) {switch (act) { case 311: return {t:2200,w:0.000000};default: return {t:0,w:0.0};}};
case 2201: return function (act:Int) {switch (act) { case 78: return {t:2229,w:0.693147}; case 110: return {t:2229,w:0.693147};default: return {t:0,w:0.0};}};
case 2202: return function (act:Int) {switch (act) { case 83: return {t:2230,w:0.693147}; case 115: return {t:2230,w:0.693147};default: return {t:0,w:0.0};}};
case 2203: return function (act:Int) {switch (act) { case 516: return {t:2203,w:0.000000};default: return {t:0,w:0.0};}};
case 2204: return function (act:Int) {switch (act) { case 256: return {t:2050,w:4000000.000000}; case 511: return {t:2231,w:0.000000};default: return {t:0,w:0.0};}};
case 2205: return function (act:Int) {switch (act) { case 258: return {t:2145,w:0.000000};default: return {t:0,w:0.0};}};
case 2206: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2232,w:0.693147};default: return {t:0,w:0.0};}};
case 2207: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2233,w:0.693147};default: return {t:0,w:0.0};}};
case 2208: return function (act:Int) {switch (act) { case 79: return {t:2234,w:0.693147}; case 111: return {t:2234,w:0.693147};default: return {t:0,w:0.0};}};
case 2209: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2235,w:0.000000};default: return {t:0,w:0.0};}};
case 2210: return function (act:Int) {switch (act) { case 88: return {t:2236,w:0.693147}; case 120: return {t:2236,w:0.693147};default: return {t:0,w:0.0};}};
case 2211: return function (act:Int) {switch (act) { case 80: return {t:2237,w:0.693147}; case 112: return {t:2237,w:0.693147};default: return {t:0,w:0.0};}};
case 2212: return function (act:Int) {switch (act) { case 80: return {t:2238,w:0.693147}; case 112: return {t:2238,w:0.693147};default: return {t:0,w:0.0};}};
case 2213: return function (act:Int) {switch (act) { case 517: return {t:2213,w:0.000000};default: return {t:0,w:0.0};}};
case 2214: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2181,w:0.693147}; case 375: return {t:2182,w:0.693147};default: return {t:0,w:0.0};}};
case 2215: return function (act:Int) {switch (act) { case 33: return {t:2,w:4.795790}; case 37: return {t:3,w:4.795790}; case 39: return {t:4,w:4.795790}; case 42: return {t:5,w:4.795790}; case 43: return {t:6,w:4.795790}; case 45: return {t:7,w:4.795790}; case 46: return {t:8,w:4.795790}; case 48: return {t:9,w:8.196987}; case 49: return {t:9,w:8.196987}; case 50: return {t:9,w:8.196987}; case 51: return {t:9,w:8.196987}; case 52: return {t:9,w:8.196987}; case 53: return {t:9,w:8.196987}; case 54: return {t:9,w:8.196987}; case 55: return {t:9,w:8.196987}; case 56: return {t:9,w:8.196987}; case 57: return {t:9,w:8.196987}; case 65: return {t:2239,w:3.091042}; case 66: return {t:13,w:9.152499}; case 67: return {t:2240,w:3.091042}; case 68: return {t:13,w:9.152499}; case 69: return {t:13,w:9.152499}; case 70: return {t:13,w:9.152499}; case 71: return {t:13,w:9.152499}; case 72: return {t:13,w:9.152499}; case 73: return {t:13,w:9.152499}; case 74: return {t:13,w:9.152499}; case 75: return {t:13,w:9.152499}; case 76: return {t:13,w:9.152499}; case 77: return {t:13,w:9.152499}; case 78: return {t:2241,w:3.091042}; case 79: return {t:2242,w:3.091042}; case 80: return {t:13,w:9.152499}; case 81: return {t:2243,w:3.091042}; case 82: return {t:2244,w:3.091042}; case 83: return {t:13,w:9.152499}; case 84: return {t:13,w:9.152499}; case 85: return {t:2245,w:3.091042}; case 86: return {t:13,w:9.152499}; case 87: return {t:13,w:9.152499}; case 88: return {t:13,w:9.152499}; case 89: return {t:13,w:9.152499}; case 90: return {t:13,w:9.152499}; case 95: return {t:18,w:4.795790}; case 96: return {t:19,w:4.795790}; case 97: return {t:2246,w:3.091042}; case 98: return {t:20,w:9.152499}; case 99: return {t:2247,w:3.091042}; case 100: return {t:20,w:9.152499}; case 101: return {t:20,w:9.152499}; case 102: return {t:20,w:9.152499}; case 103: return {t:20,w:9.152499}; case 104: return {t:20,w:9.152499}; case 105: return {t:20,w:9.152499}; case 106: return {t:20,w:9.152499}; case 107: return {t:20,w:9.152499}; case 108: return {t:20,w:9.152499}; case 109: return {t:20,w:9.152499}; case 110: return {t:2248,w:3.091042}; case 111: return {t:2249,w:3.091042}; case 112: return {t:20,w:9.152499}; case 113: return {t:2250,w:3.091042}; case 114: return {t:2251,w:3.091042}; case 115: return {t:20,w:9.152499}; case 116: return {t:20,w:9.152499}; case 117: return {t:2252,w:3.091042}; case 118: return {t:20,w:9.152499}; case 119: return {t:20,w:9.152499}; case 120: return {t:20,w:9.152499}; case 121: return {t:20,w:9.152499}; case 122: return {t:20,w:9.152499}; case 126: return {t:22,w:4.795790}; case 268: return {t:29,w:4.795790}; case 269: return {t:2086,w:2.397895}; case 511: return {t:2263,w:2.397895}; case 514: return {t:2087,w:2.397895}; case 521: return {t:2253,w:2.397895}; case 523: return {t:2254,w:2.397895}; case 524: return {t:2255,w:2.397895}; case 528: return {t:2256,w:2.397895}; case 529: return {t:2257,w:2.397895}; case 530: return {t:2258,w:2.397895}; case 531: return {t:2259,w:2.397895}; case 532: return {t:2260,w:2.397895}; case 533: return {t:2261,w:2.397895}; case 534: return {t:2262,w:2.397895}; case 535: return {t:2264,w:0.000000};default: return {t:0,w:0.0};}};
case 2216: return function (act:Int) {switch (act) { case 258: return {t:2002,w:0.000000};default: return {t:0,w:0.0};}};
case 2217: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2265,w:0.000000};default: return {t:0,w:0.0};}};
case 2218: return function (act:Int) {switch (act) { case 69: return {t:2266,w:0.693147}; case 101: return {t:2266,w:0.693147};default: return {t:0,w:0.0};}};
case 2219: return function (act:Int) {switch (act) { case 79: return {t:2267,w:0.693147}; case 111: return {t:2267,w:0.693147};default: return {t:0,w:0.0};}};
case 2220: return function (act:Int) {switch (act) { case 78: return {t:2268,w:0.693147}; case 110: return {t:2268,w:0.693147};default: return {t:0,w:0.0};}};
case 2221: return function (act:Int) {switch (act) { case 83: return {t:2269,w:0.693147}; case 115: return {t:2269,w:0.693147};default: return {t:0,w:0.0};}};
case 2222: return function (act:Int) {switch (act) { case 525: return {t:2222,w:0.000000};default: return {t:0,w:0.0};}};
case 2223: return function (act:Int) {switch (act) { case 518: return {t:2223,w:0.000000};default: return {t:0,w:0.0};}};
case 2224: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.091042}; case 37: return {t:3,w:3.091042}; case 39: return {t:4,w:3.091042}; case 42: return {t:5,w:3.091042}; case 43: return {t:6,w:3.091042}; case 45: return {t:7,w:3.091042}; case 46: return {t:8,w:3.091042}; case 48: return {t:9,w:6.492239}; case 49: return {t:9,w:6.492239}; case 50: return {t:9,w:6.492239}; case 51: return {t:9,w:6.492239}; case 52: return {t:9,w:6.492239}; case 53: return {t:9,w:6.492239}; case 54: return {t:9,w:6.492239}; case 55: return {t:9,w:6.492239}; case 56: return {t:9,w:6.492239}; case 57: return {t:9,w:6.492239}; case 65: return {t:13,w:7.447752}; case 66: return {t:13,w:7.447752}; case 67: return {t:13,w:7.447752}; case 68: return {t:13,w:7.447752}; case 69: return {t:13,w:7.447752}; case 70: return {t:13,w:7.447752}; case 71: return {t:13,w:7.447752}; case 72: return {t:2270,w:1.386294}; case 73: return {t:13,w:7.447752}; case 74: return {t:13,w:7.447752}; case 75: return {t:13,w:7.447752}; case 76: return {t:13,w:7.447752}; case 77: return {t:13,w:7.447752}; case 78: return {t:13,w:7.447752}; case 79: return {t:13,w:7.447752}; case 80: return {t:13,w:7.447752}; case 81: return {t:13,w:7.447752}; case 82: return {t:13,w:7.447752}; case 83: return {t:13,w:7.447752}; case 84: return {t:13,w:7.447752}; case 85: return {t:13,w:7.447752}; case 86: return {t:13,w:7.447752}; case 87: return {t:13,w:7.447752}; case 88: return {t:13,w:7.447752}; case 89: return {t:13,w:7.447752}; case 90: return {t:13,w:7.447752}; case 95: return {t:18,w:3.091042}; case 96: return {t:19,w:3.091042}; case 97: return {t:20,w:7.447752}; case 98: return {t:20,w:7.447752}; case 99: return {t:20,w:7.447752}; case 100: return {t:20,w:7.447752}; case 101: return {t:20,w:7.447752}; case 102: return {t:20,w:7.447752}; case 103: return {t:20,w:7.447752}; case 104: return {t:2271,w:1.386294}; case 105: return {t:20,w:7.447752}; case 106: return {t:20,w:7.447752}; case 107: return {t:20,w:7.447752}; case 108: return {t:20,w:7.447752}; case 109: return {t:20,w:7.447752}; case 110: return {t:20,w:7.447752}; case 111: return {t:20,w:7.447752}; case 112: return {t:20,w:7.447752}; case 113: return {t:20,w:7.447752}; case 114: return {t:20,w:7.447752}; case 115: return {t:20,w:7.447752}; case 116: return {t:20,w:7.447752}; case 117: return {t:20,w:7.447752}; case 118: return {t:20,w:7.447752}; case 119: return {t:20,w:7.447752}; case 120: return {t:20,w:7.447752}; case 121: return {t:20,w:7.447752}; case 122: return {t:20,w:7.447752}; case 126: return {t:22,w:3.091042}; case 268: return {t:29,w:3.091042}; case 269: return {t:862,w:0.693147}; case 404: return {t:2272,w:0.693147}; case 536: return {t:2273,w:0.693147};default: return {t:0,w:0.0};}};
case 2225: return function (act:Int) {switch (act) { case 256: return {t:570,w:4000000.750000}; case 258: return {t:2196,w:0.693147}; case 384: return {t:2197,w:0.693147};default: return {t:0,w:0.0};}};
case 2226: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2126,w:0.693147}; case 331: return {t:2274,w:0.693147};default: return {t:0,w:0.0};}};
case 2227: return function (act:Int) {switch (act) { case 519: return {t:2227,w:0.000000};default: return {t:0,w:0.0};}};
case 2228: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2227,w:0.693147}; case 331: return {t:2275,w:0.693147};default: return {t:0,w:0.0};}};
case 2229: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2276,w:0.000000};default: return {t:0,w:0.0};}};
case 2230: return function (act:Int) {switch (act) { case 84: return {t:2277,w:0.693147}; case 116: return {t:2277,w:0.693147};default: return {t:0,w:0.0};}};
case 2231: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2203,w:0.693147}; case 375: return {t:2204,w:0.693147};default: return {t:0,w:0.0};}};
case 2232: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2278,w:0.693147};default: return {t:0,w:0.0};}};
case 2233: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2279,w:0.693147};default: return {t:0,w:0.0};}};
case 2234: return function (act:Int) {switch (act) { case 78: return {t:2280,w:0.693147}; case 110: return {t:2280,w:0.693147};default: return {t:0,w:0.0};}};
case 2235: return function (act:Int) {switch (act) { case 256: return {t:2281,w:4000000.000000}; case 537: return {t:2282,w:0.000000};default: return {t:0,w:0.0};}};
case 2236: return function (act:Int) {switch (act) { case 84: return {t:2283,w:0.693147}; case 116: return {t:2283,w:0.693147};default: return {t:0,w:0.0};}};
case 2237: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2284,w:0.000000};default: return {t:0,w:0.0};}};
case 2238: return function (act:Int) {switch (act) { case 65: return {t:2285,w:0.693147}; case 97: return {t:2285,w:0.693147};default: return {t:0,w:0.0};}};
case 2239: return function (act:Int) {switch (act) { case 76: return {t:2286,w:0.693147}; case 108: return {t:2286,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2240: return function (act:Int) {switch (act) { case 78: return {t:2208,w:0.693147}; case 110: return {t:2208,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2241: return function (act:Int) {switch (act) { case 67: return {t:2209,w:0.693147}; case 79: return {t:2287,w:0.693147}; case 99: return {t:2209,w:0.693147}; case 111: return {t:2287,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2242: return function (act:Int) {switch (act) { case 80: return {t:2288,w:0.693147}; case 112: return {t:2288,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2243: return function (act:Int) {switch (act) { case 79: return {t:2211,w:0.693147}; case 111: return {t:2211,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2244: return function (act:Int) {switch (act) { case 69: return {t:2289,w:0.693147}; case 101: return {t:2289,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2245: return function (act:Int) {switch (act) { case 82: return {t:2290,w:0.693147}; case 83: return {t:2291,w:0.693147}; case 114: return {t:2290,w:0.693147}; case 115: return {t:2291,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2246: return function (act:Int) {switch (act) { case 76: return {t:2286,w:0.693147}; case 108: return {t:2286,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2247: return function (act:Int) {switch (act) { case 78: return {t:2208,w:0.693147}; case 110: return {t:2208,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2248: return function (act:Int) {switch (act) { case 67: return {t:2209,w:0.693147}; case 79: return {t:2287,w:0.693147}; case 99: return {t:2209,w:0.693147}; case 111: return {t:2287,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2249: return function (act:Int) {switch (act) { case 80: return {t:2288,w:0.693147}; case 112: return {t:2288,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2250: return function (act:Int) {switch (act) { case 79: return {t:2211,w:0.693147}; case 111: return {t:2211,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2251: return function (act:Int) {switch (act) { case 69: return {t:2289,w:0.693147}; case 101: return {t:2289,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2252: return function (act:Int) {switch (act) { case 82: return {t:2290,w:0.693147}; case 83: return {t:2291,w:0.693147}; case 114: return {t:2290,w:0.693147}; case 115: return {t:2291,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2253: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2254: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2255: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2256: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2257: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2258: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2259: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2260: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2261: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2262: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2263: return function (act:Int) {switch (act) { case 258: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2264: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2293,w:0.693147}; case 375: return {t:2294,w:0.693147};default: return {t:0,w:0.0};}};
case 2265: return function (act:Int) {switch (act) { case 67: return {t:2295,w:2.079441}; case 73: return {t:2296,w:2.079441}; case 99: return {t:2295,w:2.079441}; case 105: return {t:2296,w:2.079441}; case 256: return {t:812,w:4000001.500000}; case 269: return {t:2297,w:1.386294};default: return {t:0,w:0.0};}};
case 2266: return function (act:Int) {switch (act) { case 82: return {t:2298,w:0.693147}; case 114: return {t:2298,w:0.693147};default: return {t:0,w:0.0};}};
case 2267: return function (act:Int) {switch (act) { case 78: return {t:2299,w:0.693147}; case 110: return {t:2299,w:0.693147};default: return {t:0,w:0.0};}};
case 2268: return function (act:Int) {switch (act) { case 68: return {t:2300,w:0.693147}; case 100: return {t:2300,w:0.693147};default: return {t:0,w:0.0};}};
case 2269: return function (act:Int) {switch (act) { case 83: return {t:2301,w:0.693147}; case 115: return {t:2301,w:0.693147};default: return {t:0,w:0.0};}};
case 2270: return function (act:Int) {switch (act) { case 65: return {t:2302,w:0.693147}; case 97: return {t:2302,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2271: return function (act:Int) {switch (act) { case 65: return {t:2302,w:0.693147}; case 97: return {t:2302,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2272: return function (act:Int) {switch (act) { case 258: return {t:2303,w:0.000000};default: return {t:0,w:0.0};}};
case 2273: return function (act:Int) {switch (act) { case 258: return {t:2303,w:0.000000};default: return {t:0,w:0.0};}};
case 2274: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2126,w:0.693147}; case 331: return {t:2304,w:0.693147};default: return {t:0,w:0.0};}};
case 2275: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2227,w:0.693147}; case 331: return {t:2305,w:0.693147};default: return {t:0,w:0.0};}};
case 2276: return function (act:Int) {switch (act) { case 256: return {t:1252,w:4000000.000000}; case 451: return {t:2306,w:0.000000};default: return {t:0,w:0.0};}};
case 2277: return function (act:Int) {switch (act) { case 256: return {t:676,w:4000000.000000}; case 377: return {t:2307,w:0.000000};default: return {t:0,w:0.0};}};
case 2278: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2308,w:0.693147};default: return {t:0,w:0.0};}};
case 2279: return function (act:Int) {switch (act) { case 45: return {t:2078,w:0.693147}; case 258: return {t:2077,w:0.693147};default: return {t:0,w:0.0};}};
case 2280: return function (act:Int) {switch (act) { case 67: return {t:2309,w:0.693147}; case 99: return {t:2309,w:0.693147};default: return {t:0,w:0.0};}};
case 2281: return function (act:Int) {switch (act) { case 48: return {t:2310,w:2.995732}; case 49: return {t:2310,w:2.995732}; case 50: return {t:2310,w:2.995732}; case 51: return {t:2310,w:2.995732}; case 52: return {t:2310,w:2.995732}; case 53: return {t:2310,w:2.995732}; case 54: return {t:2310,w:2.995732}; case 55: return {t:2310,w:2.995732}; case 56: return {t:2310,w:2.995732}; case 57: return {t:2310,w:2.995732}; case 97: return {t:2311,w:2.484906}; case 98: return {t:2311,w:2.484906}; case 99: return {t:2311,w:2.484906}; case 100: return {t:2311,w:2.484906}; case 101: return {t:2311,w:2.484906}; case 102: return {t:2311,w:2.484906}; case 538: return {t:2312,w:0.000000};default: return {t:0,w:0.0};}};
case 2282: return function (act:Int) {switch (act) { case 258: return {t:2313,w:0.000000};default: return {t:0,w:0.0};}};
case 2283: return function (act:Int) {switch (act) { case 78: return {t:2314,w:0.693147}; case 110: return {t:2314,w:0.693147};default: return {t:0,w:0.0};}};
case 2284: return function (act:Int) {switch (act) { case 256: return {t:2315,w:4000000.000000}; case 539: return {t:2316,w:0.000000};default: return {t:0,w:0.0};}};
case 2285: return function (act:Int) {switch (act) { case 85: return {t:2317,w:0.693147}; case 117: return {t:2317,w:0.693147};default: return {t:0,w:0.0};}};
case 2286: return function (act:Int) {switch (act) { case 71: return {t:2318,w:0.693147}; case 103: return {t:2318,w:0.693147};default: return {t:0,w:0.0};}};
case 2287: return function (act:Int) {switch (act) { case 78: return {t:2319,w:0.693147}; case 110: return {t:2319,w:0.693147};default: return {t:0,w:0.0};}};
case 2288: return function (act:Int) {switch (act) { case 65: return {t:2320,w:0.693147}; case 97: return {t:2320,w:0.693147};default: return {t:0,w:0.0};}};
case 2289: return function (act:Int) {switch (act) { case 65: return {t:2321,w:0.693147}; case 83: return {t:2322,w:0.693147}; case 97: return {t:2321,w:0.693147}; case 115: return {t:2322,w:0.693147};default: return {t:0,w:0.0};}};
case 2290: return function (act:Int) {switch (act) { case 73: return {t:2323,w:0.693147}; case 105: return {t:2323,w:0.693147};default: return {t:0,w:0.0};}};
case 2291: return function (act:Int) {switch (act) { case 69: return {t:2324,w:0.693147}; case 101: return {t:2324,w:0.693147};default: return {t:0,w:0.0};}};
case 2292: return function (act:Int) {switch (act) { case 535: return {t:2292,w:0.000000};default: return {t:0,w:0.0};}};
case 2293: return function (act:Int) {switch (act) { case 526: return {t:2293,w:0.000000};default: return {t:0,w:0.0};}};
case 2294: return function (act:Int) {switch (act) { case 256: return {t:2325,w:4000000.000000}; case 535: return {t:2326,w:0.000000};default: return {t:0,w:0.0};}};
case 2295: return function (act:Int) {switch (act) { case 65: return {t:2327,w:0.693147}; case 97: return {t:2327,w:0.693147};default: return {t:0,w:0.0};}};
case 2296: return function (act:Int) {switch (act) { case 67: return {t:2328,w:0.693147}; case 78: return {t:2329,w:0.693147}; case 99: return {t:2328,w:0.693147}; case 110: return {t:2329,w:0.693147};default: return {t:0,w:0.0};}};
case 2297: return function (act:Int) {switch (act) { case 258: return {t:2053,w:0.000000};default: return {t:0,w:0.0};}};
case 2298: return function (act:Int) {switch (act) { case 84: return {t:2330,w:0.693147}; case 116: return {t:2330,w:0.693147};default: return {t:0,w:0.0};}};
case 2299: return function (act:Int) {switch (act) { case 258: return {t:2223,w:0.000000};default: return {t:0,w:0.0};}};
case 2300: return function (act:Int) {switch (act) { case 69: return {t:2331,w:0.693147}; case 101: return {t:2331,w:0.693147};default: return {t:0,w:0.0};}};
case 2301: return function (act:Int) {switch (act) { case 73: return {t:2332,w:0.693147}; case 105: return {t:2332,w:0.693147};default: return {t:0,w:0.0};}};
case 2302: return function (act:Int) {switch (act) { case 78: return {t:2333,w:0.693147}; case 110: return {t:2333,w:0.693147};default: return {t:0,w:0.0};}};
case 2303: return function (act:Int) {switch (act) { case 527: return {t:2303,w:0.000000};default: return {t:0,w:0.0};}};
case 2304: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2126,w:0.693147}; case 331: return {t:2334,w:0.693147};default: return {t:0,w:0.0};}};
case 2305: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2227,w:0.693147}; case 331: return {t:2335,w:0.693147};default: return {t:0,w:0.0};}};
case 2306: return function (act:Int) {switch (act) { case 258: return {t:2033,w:0.000000};default: return {t:0,w:0.0};}};
case 2307: return function (act:Int) {switch (act) { case 256: return {t:2336,w:4000000.000000}; case 540: return {t:2337,w:0.000000};default: return {t:0,w:0.0};}};
case 2308: return function (act:Int) {switch (act) { case 45: return {t:2078,w:1.386294}; case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2077,w:1.386294}; case 331: return {t:2338,w:0.693147};default: return {t:0,w:0.0};}};
case 2309: return function (act:Int) {switch (act) { case 69: return {t:2339,w:0.693147}; case 101: return {t:2339,w:0.693147};default: return {t:0,w:0.0};}};
case 2310: return function (act:Int) {switch (act) { case 258: return {t:2340,w:0.000000};default: return {t:0,w:0.0};}};
case 2311: return function (act:Int) {switch (act) { case 258: return {t:2340,w:0.000000};default: return {t:0,w:0.0};}};
case 2312: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2342,w:0.000000};default: return {t:0,w:0.0};}};
case 2313: return function (act:Int) {switch (act) { case 524: return {t:2313,w:0.000000};default: return {t:0,w:0.0};}};
case 2314: return function (act:Int) {switch (act) { case 79: return {t:2343,w:0.693147}; case 111: return {t:2343,w:0.693147};default: return {t:0,w:0.0};}};
case 2315: return function (act:Int) {switch (act) { case 33: return {t:2,w:3.496507}; case 37: return {t:3,w:3.496507}; case 39: return {t:4,w:3.496507}; case 42: return {t:5,w:3.496507}; case 43: return {t:6,w:3.496507}; case 45: return {t:7,w:3.496507}; case 46: return {t:8,w:3.496507}; case 48: return {t:9,w:6.897704}; case 49: return {t:9,w:6.897704}; case 50: return {t:9,w:6.897704}; case 51: return {t:9,w:6.897704}; case 52: return {t:9,w:6.897704}; case 53: return {t:9,w:6.897704}; case 54: return {t:9,w:6.897704}; case 55: return {t:9,w:6.897704}; case 56: return {t:9,w:6.897704}; case 57: return {t:9,w:6.897704}; case 65: return {t:2344,w:1.791759}; case 66: return {t:13,w:7.853216}; case 67: return {t:13,w:7.853216}; case 68: return {t:13,w:7.853216}; case 69: return {t:13,w:7.853216}; case 70: return {t:13,w:7.853216}; case 71: return {t:13,w:7.853216}; case 72: return {t:13,w:7.853216}; case 73: return {t:13,w:7.853216}; case 74: return {t:13,w:7.853216}; case 75: return {t:13,w:7.853216}; case 76: return {t:13,w:7.853216}; case 77: return {t:13,w:7.853216}; case 78: return {t:13,w:7.853216}; case 79: return {t:13,w:7.853216}; case 80: return {t:13,w:7.853216}; case 81: return {t:13,w:7.853216}; case 82: return {t:13,w:7.853216}; case 83: return {t:13,w:7.853216}; case 84: return {t:13,w:7.853216}; case 85: return {t:13,w:7.853216}; case 86: return {t:13,w:7.853216}; case 87: return {t:13,w:7.853216}; case 88: return {t:13,w:7.853216}; case 89: return {t:13,w:7.853216}; case 90: return {t:13,w:7.853216}; case 95: return {t:18,w:3.496507}; case 96: return {t:19,w:3.496507}; case 97: return {t:2345,w:1.791759}; case 98: return {t:20,w:7.853216}; case 99: return {t:20,w:7.853216}; case 100: return {t:20,w:7.853216}; case 101: return {t:20,w:7.853216}; case 102: return {t:20,w:7.853216}; case 103: return {t:20,w:7.853216}; case 104: return {t:20,w:7.853216}; case 105: return {t:20,w:7.853216}; case 106: return {t:20,w:7.853216}; case 107: return {t:20,w:7.853216}; case 108: return {t:20,w:7.853216}; case 109: return {t:20,w:7.853216}; case 110: return {t:20,w:7.853216}; case 111: return {t:20,w:7.853216}; case 112: return {t:20,w:7.853216}; case 113: return {t:20,w:7.853216}; case 114: return {t:20,w:7.853216}; case 115: return {t:20,w:7.853216}; case 116: return {t:20,w:7.853216}; case 117: return {t:20,w:7.853216}; case 118: return {t:20,w:7.853216}; case 119: return {t:20,w:7.853216}; case 120: return {t:20,w:7.853216}; case 121: return {t:20,w:7.853216}; case 122: return {t:20,w:7.853216}; case 126: return {t:22,w:3.496507}; case 268: return {t:29,w:3.496507}; case 269: return {t:2346,w:1.098612};default: return {t:0,w:0.0};}};
case 2316: return function (act:Int) {switch (act) { case 258: return {t:2347,w:0.000000};default: return {t:0,w:0.0};}};
case 2317: return function (act:Int) {switch (act) { case 84: return {t:2348,w:0.693147}; case 116: return {t:2348,w:0.693147};default: return {t:0,w:0.0};}};
case 2318: return function (act:Int) {switch (act) { case 79: return {t:2349,w:0.693147}; case 111: return {t:2349,w:0.693147};default: return {t:0,w:0.0};}};
case 2319: return function (act:Int) {switch (act) { case 67: return {t:2350,w:0.693147}; case 99: return {t:2350,w:0.693147};default: return {t:0,w:0.0};}};
case 2320: return function (act:Int) {switch (act) { case 81: return {t:2351,w:0.693147}; case 113: return {t:2351,w:0.693147};default: return {t:0,w:0.0};}};
case 2321: return function (act:Int) {switch (act) { case 76: return {t:2352,w:0.693147}; case 108: return {t:2352,w:0.693147};default: return {t:0,w:0.0};}};
case 2322: return function (act:Int) {switch (act) { case 80: return {t:2353,w:0.693147}; case 112: return {t:2353,w:0.693147};default: return {t:0,w:0.0};}};
case 2323: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2354,w:0.000000};default: return {t:0,w:0.0};}};
case 2324: return function (act:Int) {switch (act) { case 82: return {t:2355,w:0.693147}; case 114: return {t:2355,w:0.693147};default: return {t:0,w:0.0};}};
case 2325: return function (act:Int) {switch (act) { case 33: return {t:2,w:4.795790}; case 37: return {t:3,w:4.795790}; case 39: return {t:4,w:4.795790}; case 42: return {t:5,w:4.795790}; case 43: return {t:6,w:4.795790}; case 45: return {t:7,w:4.795790}; case 46: return {t:8,w:4.795790}; case 48: return {t:9,w:8.196987}; case 49: return {t:9,w:8.196987}; case 50: return {t:9,w:8.196987}; case 51: return {t:9,w:8.196987}; case 52: return {t:9,w:8.196987}; case 53: return {t:9,w:8.196987}; case 54: return {t:9,w:8.196987}; case 55: return {t:9,w:8.196987}; case 56: return {t:9,w:8.196987}; case 57: return {t:9,w:8.196987}; case 65: return {t:2239,w:3.091042}; case 66: return {t:13,w:9.152499}; case 67: return {t:2240,w:3.091042}; case 68: return {t:13,w:9.152499}; case 69: return {t:13,w:9.152499}; case 70: return {t:13,w:9.152499}; case 71: return {t:13,w:9.152499}; case 72: return {t:13,w:9.152499}; case 73: return {t:13,w:9.152499}; case 74: return {t:13,w:9.152499}; case 75: return {t:13,w:9.152499}; case 76: return {t:13,w:9.152499}; case 77: return {t:13,w:9.152499}; case 78: return {t:2241,w:3.091042}; case 79: return {t:2242,w:3.091042}; case 80: return {t:13,w:9.152499}; case 81: return {t:2243,w:3.091042}; case 82: return {t:2244,w:3.091042}; case 83: return {t:13,w:9.152499}; case 84: return {t:13,w:9.152499}; case 85: return {t:2245,w:3.091042}; case 86: return {t:13,w:9.152499}; case 87: return {t:13,w:9.152499}; case 88: return {t:13,w:9.152499}; case 89: return {t:13,w:9.152499}; case 90: return {t:13,w:9.152499}; case 95: return {t:18,w:4.795790}; case 96: return {t:19,w:4.795790}; case 97: return {t:2246,w:3.091042}; case 98: return {t:20,w:9.152499}; case 99: return {t:2247,w:3.091042}; case 100: return {t:20,w:9.152499}; case 101: return {t:20,w:9.152499}; case 102: return {t:20,w:9.152499}; case 103: return {t:20,w:9.152499}; case 104: return {t:20,w:9.152499}; case 105: return {t:20,w:9.152499}; case 106: return {t:20,w:9.152499}; case 107: return {t:20,w:9.152499}; case 108: return {t:20,w:9.152499}; case 109: return {t:20,w:9.152499}; case 110: return {t:2248,w:3.091042}; case 111: return {t:2249,w:3.091042}; case 112: return {t:20,w:9.152499}; case 113: return {t:2250,w:3.091042}; case 114: return {t:2251,w:3.091042}; case 115: return {t:20,w:9.152499}; case 116: return {t:20,w:9.152499}; case 117: return {t:2252,w:3.091042}; case 118: return {t:20,w:9.152499}; case 119: return {t:20,w:9.152499}; case 120: return {t:20,w:9.152499}; case 121: return {t:20,w:9.152499}; case 122: return {t:20,w:9.152499}; case 126: return {t:22,w:4.795790}; case 268: return {t:29,w:4.795790}; case 269: return {t:2086,w:2.397895}; case 511: return {t:2263,w:2.397895}; case 514: return {t:2087,w:2.397895}; case 521: return {t:2253,w:2.397895}; case 523: return {t:2254,w:2.397895}; case 524: return {t:2255,w:2.397895}; case 528: return {t:2256,w:2.397895}; case 529: return {t:2257,w:2.397895}; case 530: return {t:2258,w:2.397895}; case 531: return {t:2259,w:2.397895}; case 532: return {t:2260,w:2.397895}; case 533: return {t:2261,w:2.397895}; case 534: return {t:2262,w:2.397895};default: return {t:0,w:0.0};}};
case 2326: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2293,w:0.693147}; case 375: return {t:2294,w:0.693147};default: return {t:0,w:0.0};}};
case 2327: return function (act:Int) {switch (act) { case 82: return {t:2356,w:0.693147}; case 114: return {t:2356,w:0.693147};default: return {t:0,w:0.0};}};
case 2328: return function (act:Int) {switch (act) { case 79: return {t:2357,w:0.693147}; case 111: return {t:2357,w:0.693147};default: return {t:0,w:0.0};}};
case 2329: return function (act:Int) {switch (act) { case 70: return {t:2358,w:0.693147}; case 102: return {t:2358,w:0.693147};default: return {t:0,w:0.0};}};
case 2330: return function (act:Int) {switch (act) { case 258: return {t:2223,w:0.000000};default: return {t:0,w:0.0};}};
case 2331: return function (act:Int) {switch (act) { case 82: return {t:2359,w:0.693147}; case 114: return {t:2359,w:0.693147};default: return {t:0,w:0.0};}};
case 2332: return function (act:Int) {switch (act) { case 79: return {t:2360,w:0.693147}; case 111: return {t:2360,w:0.693147};default: return {t:0,w:0.0};}};
case 2333: return function (act:Int) {switch (act) { case 68: return {t:2361,w:0.693147}; case 100: return {t:2361,w:0.693147};default: return {t:0,w:0.0};}};
case 2334: return function (act:Int) {switch (act) { case 258: return {t:2126,w:0.000000};default: return {t:0,w:0.0};}};
case 2335: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2227,w:0.693147}; case 331: return {t:2362,w:0.693147};default: return {t:0,w:0.0};}};
case 2336: return function (act:Int) {switch (act) { case 33: return {t:2,w:4.477337}; case 37: return {t:3,w:4.477337}; case 39: return {t:4,w:4.477337}; case 42: return {t:5,w:4.477337}; case 43: return {t:6,w:4.477337}; case 45: return {t:7,w:4.477337}; case 46: return {t:8,w:4.477337}; case 48: return {t:9,w:7.878534}; case 49: return {t:9,w:7.878534}; case 50: return {t:9,w:7.878534}; case 51: return {t:9,w:7.878534}; case 52: return {t:9,w:7.878534}; case 53: return {t:9,w:7.878534}; case 54: return {t:9,w:7.878534}; case 55: return {t:9,w:7.878534}; case 56: return {t:9,w:7.878534}; case 57: return {t:9,w:7.878534}; case 65: return {t:2239,w:2.772589}; case 66: return {t:13,w:8.834046}; case 67: return {t:13,w:8.834046}; case 68: return {t:2363,w:2.772589}; case 69: return {t:13,w:8.834046}; case 70: return {t:13,w:8.834046}; case 71: return {t:13,w:8.834046}; case 72: return {t:13,w:8.834046}; case 73: return {t:13,w:8.834046}; case 74: return {t:13,w:8.834046}; case 75: return {t:13,w:8.834046}; case 76: return {t:13,w:8.834046}; case 77: return {t:13,w:8.834046}; case 78: return {t:2364,w:2.772589}; case 79: return {t:2242,w:2.772589}; case 80: return {t:13,w:8.834046}; case 81: return {t:2365,w:2.772589}; case 82: return {t:2366,w:2.772589}; case 83: return {t:2367,w:2.772589}; case 84: return {t:13,w:8.834046}; case 85: return {t:13,w:8.834046}; case 86: return {t:13,w:8.834046}; case 87: return {t:13,w:8.834046}; case 88: return {t:13,w:8.834046}; case 89: return {t:13,w:8.834046}; case 90: return {t:13,w:8.834046}; case 95: return {t:18,w:4.477337}; case 96: return {t:19,w:4.477337}; case 97: return {t:2246,w:2.772589}; case 98: return {t:20,w:8.834046}; case 99: return {t:20,w:8.834046}; case 100: return {t:2368,w:2.772589}; case 101: return {t:20,w:8.834046}; case 102: return {t:20,w:8.834046}; case 103: return {t:20,w:8.834046}; case 104: return {t:20,w:8.834046}; case 105: return {t:20,w:8.834046}; case 106: return {t:20,w:8.834046}; case 107: return {t:20,w:8.834046}; case 108: return {t:20,w:8.834046}; case 109: return {t:20,w:8.834046}; case 110: return {t:2369,w:2.772589}; case 111: return {t:2249,w:2.772589}; case 112: return {t:20,w:8.834046}; case 113: return {t:2370,w:2.772589}; case 114: return {t:2371,w:2.772589}; case 115: return {t:2372,w:2.772589}; case 116: return {t:20,w:8.834046}; case 117: return {t:20,w:8.834046}; case 118: return {t:20,w:8.834046}; case 119: return {t:20,w:8.834046}; case 120: return {t:20,w:8.834046}; case 121: return {t:20,w:8.834046}; case 122: return {t:20,w:8.834046}; case 126: return {t:22,w:4.477337}; case 268: return {t:29,w:4.477337}; case 269: return {t:2086,w:2.079442}; case 511: return {t:2377,w:2.079442}; case 514: return {t:2087,w:2.079442}; case 529: return {t:2373,w:2.079442}; case 530: return {t:2374,w:2.079442}; case 533: return {t:2375,w:2.079442}; case 534: return {t:2376,w:2.079442}; case 541: return {t:2378,w:2.079442}; case 542: return {t:2379,w:2.079442}; case 543: return {t:2380,w:2.079442};default: return {t:0,w:0.0};}};
case 2337: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2140,w:0.693147}; case 375: return {t:2381,w:0.693147};default: return {t:0,w:0.0};}};
case 2338: return function (act:Int) {switch (act) { case 45: return {t:2078,w:0.693147}; case 258: return {t:2077,w:0.693147};default: return {t:0,w:0.0};}};
case 2339: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2382,w:0.000000};default: return {t:0,w:0.0};}};
case 2340: return function (act:Int) {switch (act) { case 538: return {t:2340,w:0.000000};default: return {t:0,w:0.0};}};
case 2341: return function (act:Int) {switch (act) { case 48: return {t:2310,w:2.995732}; case 49: return {t:2310,w:2.995732}; case 50: return {t:2310,w:2.995732}; case 51: return {t:2310,w:2.995732}; case 52: return {t:2310,w:2.995732}; case 53: return {t:2310,w:2.995732}; case 54: return {t:2310,w:2.995732}; case 55: return {t:2310,w:2.995732}; case 56: return {t:2310,w:2.995732}; case 57: return {t:2310,w:2.995732}; case 97: return {t:2311,w:2.484906}; case 98: return {t:2311,w:2.484906}; case 99: return {t:2311,w:2.484906}; case 100: return {t:2311,w:2.484906}; case 101: return {t:2311,w:2.484906}; case 102: return {t:2311,w:2.484906};default: return {t:0,w:0.0};}};
case 2342: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2383,w:0.000000};default: return {t:0,w:0.0};}};
case 2343: return function (act:Int) {switch (act) { case 78: return {t:2384,w:0.693147}; case 110: return {t:2384,w:0.693147};default: return {t:0,w:0.0};}};
case 2344: return function (act:Int) {switch (act) { case 85: return {t:2385,w:0.693147}; case 117: return {t:2385,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2345: return function (act:Int) {switch (act) { case 85: return {t:2385,w:0.693147}; case 117: return {t:2385,w:0.693147}; case 258: return {t:52,w:6.061457};default: return {t:0,w:0.0};}};
case 2346: return function (act:Int) {switch (act) { case 258: return {t:2386,w:0.000000};default: return {t:0,w:0.0};}};
case 2347: return function (act:Int) {switch (act) { case 521: return {t:2347,w:0.000000};default: return {t:0,w:0.0};}};
case 2348: return function (act:Int) {switch (act) { case 72: return {t:2387,w:0.693147}; case 104: return {t:2387,w:0.693147};default: return {t:0,w:0.0};}};
case 2349: return function (act:Int) {switch (act) { case 82: return {t:2388,w:0.693147}; case 114: return {t:2388,w:0.693147};default: return {t:0,w:0.0};}};
case 2350: return function (act:Int) {switch (act) { case 69: return {t:2389,w:0.693147}; case 101: return {t:2389,w:0.693147};default: return {t:0,w:0.0};}};
case 2351: return function (act:Int) {switch (act) { case 85: return {t:2390,w:0.693147}; case 117: return {t:2390,w:0.693147};default: return {t:0,w:0.0};}};
case 2352: return function (act:Int) {switch (act) { case 77: return {t:2391,w:0.693147}; case 109: return {t:2391,w:0.693147};default: return {t:0,w:0.0};}};
case 2353: return function (act:Int) {switch (act) { case 79: return {t:2392,w:0.693147}; case 111: return {t:2392,w:0.693147};default: return {t:0,w:0.0};}};
case 2354: return function (act:Int) {switch (act) { case 256: return {t:2393,w:4000000.000000}; case 544: return {t:2394,w:0.000000};default: return {t:0,w:0.0};}};
case 2355: return function (act:Int) {switch (act) { case 78: return {t:2395,w:0.693147}; case 110: return {t:2395,w:0.693147};default: return {t:0,w:0.0};}};
case 2356: return function (act:Int) {switch (act) { case 68: return {t:2396,w:0.693147}; case 100: return {t:2396,w:0.693147};default: return {t:0,w:0.0};}};
case 2357: return function (act:Int) {switch (act) { case 78: return {t:2397,w:0.693147}; case 110: return {t:2397,w:0.693147};default: return {t:0,w:0.0};}};
case 2358: return function (act:Int) {switch (act) { case 79: return {t:2398,w:0.693147}; case 111: return {t:2398,w:0.693147};default: return {t:0,w:0.0};}};
case 2359: return function (act:Int) {switch (act) { case 258: return {t:2223,w:0.000000};default: return {t:0,w:0.0};}};
case 2360: return function (act:Int) {switch (act) { case 78: return {t:2399,w:0.693147}; case 110: return {t:2399,w:0.693147};default: return {t:0,w:0.0};}};
case 2361: return function (act:Int) {switch (act) { case 76: return {t:2400,w:0.693147}; case 108: return {t:2400,w:0.693147};default: return {t:0,w:0.0};}};
case 2362: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2227,w:0.693147}; case 331: return {t:2401,w:0.693147};default: return {t:0,w:0.0};}};
case 2363: return function (act:Int) {switch (act) { case 79: return {t:2402,w:0.693147}; case 111: return {t:2402,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2364: return function (act:Int) {switch (act) { case 79: return {t:2287,w:0.693147}; case 111: return {t:2287,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2365: return function (act:Int) {switch (act) { case 79: return {t:2403,w:0.693147}; case 111: return {t:2403,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2366: return function (act:Int) {switch (act) { case 69: return {t:2404,w:0.693147}; case 101: return {t:2404,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2367: return function (act:Int) {switch (act) { case 84: return {t:2405,w:0.693147}; case 116: return {t:2405,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2368: return function (act:Int) {switch (act) { case 79: return {t:2402,w:0.693147}; case 111: return {t:2402,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2369: return function (act:Int) {switch (act) { case 79: return {t:2287,w:0.693147}; case 111: return {t:2287,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2370: return function (act:Int) {switch (act) { case 79: return {t:2403,w:0.693147}; case 111: return {t:2403,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2371: return function (act:Int) {switch (act) { case 69: return {t:2404,w:0.693147}; case 101: return {t:2404,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2372: return function (act:Int) {switch (act) { case 84: return {t:2405,w:0.693147}; case 116: return {t:2405,w:0.693147}; case 258: return {t:52,w:6.061458};default: return {t:0,w:0.0};}};
case 2373: return function (act:Int) {switch (act) { case 258: return {t:2406,w:0.000000};default: return {t:0,w:0.0};}};
case 2374: return function (act:Int) {switch (act) { case 258: return {t:2406,w:0.000000};default: return {t:0,w:0.0};}};
case 2375: return function (act:Int) {switch (act) { case 258: return {t:2406,w:0.000000};default: return {t:0,w:0.0};}};
case 2376: return function (act:Int) {switch (act) { case 258: return {t:2406,w:0.000000};default: return {t:0,w:0.0};}};
case 2377: return function (act:Int) {switch (act) { case 258: return {t:2406,w:0.000000};default: return {t:0,w:0.0};}};
case 2378: return function (act:Int) {switch (act) { case 258: return {t:2406,w:0.000000};default: return {t:0,w:0.0};}};
case 2379: return function (act:Int) {switch (act) { case 258: return {t:2406,w:0.000000};default: return {t:0,w:0.0};}};
case 2380: return function (act:Int) {switch (act) { case 258: return {t:2406,w:0.000000};default: return {t:0,w:0.0};}};
case 2381: return function (act:Int) {switch (act) { case 256: return {t:2336,w:4000000.000000}; case 540: return {t:2407,w:0.000000};default: return {t:0,w:0.0};}};
case 2382: return function (act:Int) {switch (act) { case 256: return {t:2408,w:4000000.000000}; case 545: return {t:2409,w:0.000000};default: return {t:0,w:0.0};}};
case 2383: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2410,w:0.000000};default: return {t:0,w:0.0};}};
case 2384: return function (act:Int) {switch (act) { case 67: return {t:2411,w:0.693147}; case 99: return {t:2411,w:0.693147};default: return {t:0,w:0.0};}};
case 2385: return function (act:Int) {switch (act) { case 84: return {t:2412,w:0.693147}; case 116: return {t:2412,w:0.693147};default: return {t:0,w:0.0};}};
case 2386: return function (act:Int) {switch (act) { case 539: return {t:2386,w:0.000000};default: return {t:0,w:0.0};}};
case 2387: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2413,w:0.000000};default: return {t:0,w:0.0};}};
case 2388: return function (act:Int) {switch (act) { case 73: return {t:2414,w:0.693147}; case 105: return {t:2414,w:0.693147};default: return {t:0,w:0.0};}};
case 2389: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2415,w:0.000000};default: return {t:0,w:0.0};}};
case 2390: return function (act:Int) {switch (act) { case 69: return {t:2416,w:0.693147}; case 101: return {t:2416,w:0.693147};default: return {t:0,w:0.0};}};
case 2391: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2417,w:0.000000};default: return {t:0,w:0.0};}};
case 2392: return function (act:Int) {switch (act) { case 78: return {t:2418,w:0.693147}; case 110: return {t:2418,w:0.693147};default: return {t:0,w:0.0};}};
case 2393: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:2419,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 2394: return function (act:Int) {switch (act) { case 256: return {t:2420,w:4000000.000000}; case 546: return {t:2421,w:0.000000};default: return {t:0,w:0.0};}};
case 2395: return function (act:Int) {switch (act) { case 65: return {t:2422,w:0.693147}; case 97: return {t:2422,w:0.693147};default: return {t:0,w:0.0};}};
case 2396: return function (act:Int) {switch (act) { case 258: return {t:2053,w:0.000000};default: return {t:0,w:0.0};}};
case 2397: return function (act:Int) {switch (act) { case 258: return {t:2053,w:0.000000};default: return {t:0,w:0.0};}};
case 2398: return function (act:Int) {switch (act) { case 258: return {t:2053,w:0.000000};default: return {t:0,w:0.0};}};
case 2399: return function (act:Int) {switch (act) { case 258: return {t:2223,w:0.000000};default: return {t:0,w:0.0};}};
case 2400: return function (act:Int) {switch (act) { case 73: return {t:2423,w:0.693147}; case 105: return {t:2423,w:0.693147};default: return {t:0,w:0.0};}};
case 2401: return function (act:Int) {switch (act) { case 256: return {t:2079,w:4000000.750000}; case 258: return {t:2227,w:0.693147}; case 331: return {t:2424,w:0.693147};default: return {t:0,w:0.0};}};
case 2402: return function (act:Int) {switch (act) { case 77: return {t:2425,w:0.693147}; case 109: return {t:2425,w:0.693147};default: return {t:0,w:0.0};}};
case 2403: return function (act:Int) {switch (act) { case 80: return {t:2426,w:0.693147}; case 112: return {t:2426,w:0.693147};default: return {t:0,w:0.0};}};
case 2404: return function (act:Int) {switch (act) { case 65: return {t:2321,w:0.693147}; case 97: return {t:2321,w:0.693147};default: return {t:0,w:0.0};}};
case 2405: return function (act:Int) {switch (act) { case 65: return {t:2427,w:0.693147}; case 97: return {t:2427,w:0.693147};default: return {t:0,w:0.0};}};
case 2406: return function (act:Int) {switch (act) { case 540: return {t:2406,w:0.000000};default: return {t:0,w:0.0};}};
case 2407: return function (act:Int) {switch (act) { case 256: return {t:489,w:4000000.750000}; case 258: return {t:2140,w:0.693147}; case 375: return {t:2381,w:0.693147};default: return {t:0,w:0.0};}};
case 2408: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1291,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 378: return {t:2428,w:0.000000}; case 547: return {t:2429,w:0.000000};default: return {t:0,w:0.0};}};
case 2409: return function (act:Int) {switch (act) { case 258: return {t:2430,w:0.000000};default: return {t:0,w:0.0};}};
case 2410: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2431,w:0.000000};default: return {t:0,w:0.0};}};
case 2411: return function (act:Int) {switch (act) { case 69: return {t:2432,w:0.693147}; case 101: return {t:2432,w:0.693147};default: return {t:0,w:0.0};}};
case 2412: return function (act:Int) {switch (act) { case 72: return {t:2433,w:0.693147}; case 104: return {t:2433,w:0.693147};default: return {t:0,w:0.0};}};
case 2413: return function (act:Int) {switch (act) { case 256: return {t:2434,w:4000000.000000}; case 548: return {t:2435,w:0.000000};default: return {t:0,w:0.0};}};
case 2414: return function (act:Int) {switch (act) { case 84: return {t:2436,w:0.693147}; case 116: return {t:2436,w:0.693147};default: return {t:0,w:0.0};}};
case 2415: return function (act:Int) {switch (act) { case 256: return {t:2437,w:4000000.000000}; case 547: return {t:2438,w:0.000000};default: return {t:0,w:0.0};}};
case 2416: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2439,w:0.000000};default: return {t:0,w:0.0};}};
case 2417: return function (act:Int) {switch (act) { case 256: return {t:2440,w:4000000.000000}; case 549: return {t:2441,w:0.000000};default: return {t:0,w:0.0};}};
case 2418: return function (act:Int) {switch (act) { case 83: return {t:2442,w:0.693147}; case 115: return {t:2442,w:0.693147};default: return {t:0,w:0.0};}};
case 2419: return function (act:Int) {switch (act) { case 256: return {t:687,w:4000000.000000}; case 381: return {t:2443,w:0.000000};default: return {t:0,w:0.0};}};
case 2420: return function (act:Int) {switch (act) { case 65: return {t:179,w:5.049856}; case 66: return {t:179,w:5.049856}; case 67: return {t:179,w:5.049856}; case 68: return {t:179,w:5.049856}; case 69: return {t:179,w:5.049856}; case 70: return {t:179,w:5.049856}; case 71: return {t:179,w:5.049856}; case 72: return {t:179,w:5.049856}; case 73: return {t:179,w:5.049856}; case 74: return {t:179,w:5.049856}; case 75: return {t:179,w:5.049856}; case 76: return {t:179,w:5.049856}; case 77: return {t:179,w:5.049856}; case 78: return {t:179,w:5.049856}; case 79: return {t:179,w:5.049856}; case 80: return {t:179,w:5.049856}; case 81: return {t:179,w:5.049856}; case 82: return {t:179,w:5.049856}; case 83: return {t:180,w:1.791759}; case 84: return {t:179,w:5.049856}; case 85: return {t:179,w:5.049856}; case 86: return {t:179,w:5.049856}; case 87: return {t:179,w:5.049856}; case 88: return {t:179,w:5.049856}; case 89: return {t:179,w:5.049856}; case 90: return {t:179,w:5.049856}; case 97: return {t:181,w:5.049856}; case 98: return {t:181,w:5.049856}; case 99: return {t:181,w:5.049856}; case 100: return {t:181,w:5.049856}; case 101: return {t:181,w:5.049856}; case 102: return {t:181,w:5.049856}; case 103: return {t:181,w:5.049856}; case 104: return {t:181,w:5.049856}; case 105: return {t:181,w:5.049856}; case 106: return {t:181,w:5.049856}; case 107: return {t:181,w:5.049856}; case 108: return {t:181,w:5.049856}; case 109: return {t:181,w:5.049856}; case 110: return {t:181,w:5.049856}; case 111: return {t:181,w:5.049856}; case 112: return {t:181,w:5.049856}; case 113: return {t:181,w:5.049856}; case 114: return {t:181,w:5.049856}; case 115: return {t:182,w:1.791759}; case 116: return {t:181,w:5.049856}; case 117: return {t:181,w:5.049856}; case 118: return {t:181,w:5.049856}; case 119: return {t:181,w:5.049856}; case 120: return {t:181,w:5.049856}; case 121: return {t:181,w:5.049856}; case 122: return {t:181,w:5.049856}; case 281: return {t:2444,w:0.000000}; case 331: return {t:183,w:1.098612}; case 332: return {t:184,w:1.098612}; case 333: return {t:185,w:1.098612}; case 334: return {t:186,w:1.098612}; case 335: return {t:187,w:1.098612};default: return {t:0,w:0.0};}};
case 2421: return function (act:Int) {switch (act) { case 256: return {t:2445,w:4000000.000000}; case 550: return {t:2446,w:0.000000};default: return {t:0,w:0.0};}};
case 2422: return function (act:Int) {switch (act) { case 77: return {t:2447,w:0.693147}; case 109: return {t:2447,w:0.693147};default: return {t:0,w:0.0};}};
case 2423: return function (act:Int) {switch (act) { case 78: return {t:2448,w:0.693147}; case 110: return {t:2448,w:0.693147};default: return {t:0,w:0.0};}};
case 2424: return function (act:Int) {switch (act) { case 258: return {t:2227,w:0.000000};default: return {t:0,w:0.0};}};
case 2425: return function (act:Int) {switch (act) { case 65: return {t:2449,w:0.693147}; case 97: return {t:2449,w:0.693147};default: return {t:0,w:0.0};}};
case 2426: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2450,w:0.000000};default: return {t:0,w:0.0};}};
case 2427: return function (act:Int) {switch (act) { case 76: return {t:2451,w:0.693147}; case 108: return {t:2451,w:0.693147};default: return {t:0,w:0.0};}};
case 2428: return function (act:Int) {switch (act) { case 258: return {t:2452,w:0.000000};default: return {t:0,w:0.0};}};
case 2429: return function (act:Int) {switch (act) { case 258: return {t:2453,w:0.000000};default: return {t:0,w:0.0};}};
case 2430: return function (act:Int) {switch (act) { case 523: return {t:2430,w:0.000000};default: return {t:0,w:0.0};}};
case 2431: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2454,w:0.000000};default: return {t:0,w:0.0};}};
case 2432: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2455,w:0.000000};default: return {t:0,w:0.0};}};
case 2433: return function (act:Int) {switch (act) { case 45: return {t:2456,w:0.000000}; case 258: return {t:2386,w:0.000000};default: return {t:0,w:0.0};}};
case 2434: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:2419,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 544: return {t:2457,w:0.000000};default: return {t:0,w:0.0};}};
case 2435: return function (act:Int) {switch (act) { case 258: return {t:2458,w:0.000000};default: return {t:0,w:0.0};}};
case 2436: return function (act:Int) {switch (act) { case 72: return {t:2459,w:0.693147}; case 104: return {t:2459,w:0.693147};default: return {t:0,w:0.0};}};
case 2437: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1291,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 378: return {t:2428,w:0.000000};default: return {t:0,w:0.0};}};
case 2438: return function (act:Int) {switch (act) { case 258: return {t:2460,w:0.000000};default: return {t:0,w:0.0};}};
case 2439: return function (act:Int) {switch (act) { case 256: return {t:2461,w:4000000.000000}; case 378: return {t:2462,w:0.000000};default: return {t:0,w:0.0};}};
case 2440: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1291,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 378: return {t:2463,w:0.000000};default: return {t:0,w:0.0};}};
case 2441: return function (act:Int) {switch (act) { case 258: return {t:2464,w:0.000000};default: return {t:0,w:0.0};}};
case 2442: return function (act:Int) {switch (act) { case 69: return {t:2465,w:0.693147}; case 101: return {t:2465,w:0.693147};default: return {t:0,w:0.0};}};
case 2443: return function (act:Int) {switch (act) { case 258: return {t:2466,w:0.000000};default: return {t:0,w:0.0};}};
case 2444: return function (act:Int) {switch (act) { case 258: return {t:2467,w:0.000000};default: return {t:0,w:0.0};}};
case 2445: return function (act:Int) {switch (act) { case 34: return {t:516,w:0.000000}; case 381: return {t:2468,w:0.000000};default: return {t:0,w:0.0};}};
case 2446: return function (act:Int) {switch (act) { case 258: return {t:2469,w:0.000000};default: return {t:0,w:0.0};}};
case 2447: return function (act:Int) {switch (act) { case 69: return {t:2470,w:0.693147}; case 101: return {t:2470,w:0.693147};default: return {t:0,w:0.0};}};
case 2448: return function (act:Int) {switch (act) { case 71: return {t:2471,w:0.693147}; case 103: return {t:2471,w:0.693147};default: return {t:0,w:0.0};}};
case 2449: return function (act:Int) {switch (act) { case 73: return {t:2472,w:0.693147}; case 105: return {t:2472,w:0.693147};default: return {t:0,w:0.0};}};
case 2450: return function (act:Int) {switch (act) { case 256: return {t:2393,w:4000000.000000}; case 544: return {t:2473,w:0.000000};default: return {t:0,w:0.0};}};
case 2451: return function (act:Int) {switch (act) { case 69: return {t:2474,w:0.693147}; case 101: return {t:2474,w:0.693147};default: return {t:0,w:0.0};}};
case 2452: return function (act:Int) {switch (act) { case 547: return {t:2452,w:0.000000};default: return {t:0,w:0.0};}};
case 2453: return function (act:Int) {switch (act) { case 545: return {t:2453,w:0.000000};default: return {t:0,w:0.0};}};
case 2454: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2475,w:0.000000};default: return {t:0,w:0.0};}};
case 2455: return function (act:Int) {switch (act) { case 256: return {t:2437,w:4000000.000000}; case 547: return {t:2476,w:0.000000};default: return {t:0,w:0.0};}};
case 2456: return function (act:Int) {switch (act) { case 73: return {t:2477,w:0.693147}; case 105: return {t:2477,w:0.693147};default: return {t:0,w:0.0};}};
case 2457: return function (act:Int) {switch (act) { case 256: return {t:2478,w:4000000.750000}; case 538: return {t:2479,w:0.693147}; case 550: return {t:2480,w:0.693147};default: return {t:0,w:0.0};}};
case 2458: return function (act:Int) {switch (act) { case 522: return {t:2458,w:0.000000};default: return {t:0,w:0.0};}};
case 2459: return function (act:Int) {switch (act) { case 77: return {t:2481,w:0.693147}; case 109: return {t:2481,w:0.693147};default: return {t:0,w:0.0};}};
case 2460: return function (act:Int) {switch (act) { case 530: return {t:2460,w:0.000000};default: return {t:0,w:0.0};}};
case 2461: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1291,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147};default: return {t:0,w:0.0};}};
case 2462: return function (act:Int) {switch (act) { case 258: return {t:2482,w:0.000000};default: return {t:0,w:0.0};}};
case 2463: return function (act:Int) {switch (act) { case 258: return {t:2483,w:0.000000};default: return {t:0,w:0.0};}};
case 2464: return function (act:Int) {switch (act) { case 529: return {t:2464,w:0.000000};default: return {t:0,w:0.0};}};
case 2465: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2484,w:0.000000};default: return {t:0,w:0.0};}};
case 2466: return function (act:Int) {switch (act) { case 544: return {t:2466,w:0.000000};default: return {t:0,w:0.0};}};
case 2467: return function (act:Int) {switch (act) { case 546: return {t:2467,w:0.000000};default: return {t:0,w:0.0};}};
case 2468: return function (act:Int) {switch (act) { case 256: return {t:459,w:4000000.000000}; case 368: return {t:2485,w:0.000000};default: return {t:0,w:0.0};}};
case 2469: return function (act:Int) {switch (act) { case 531: return {t:2469,w:0.000000};default: return {t:0,w:0.0};}};
case 2470: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2486,w:0.000000};default: return {t:0,w:0.0};}};
case 2471: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2487,w:0.000000};default: return {t:0,w:0.0};}};
case 2472: return function (act:Int) {switch (act) { case 78: return {t:2488,w:0.693147}; case 110: return {t:2488,w:0.693147};default: return {t:0,w:0.0};}};
case 2473: return function (act:Int) {switch (act) { case 256: return {t:2315,w:4000000.000000}; case 539: return {t:2489,w:0.000000};default: return {t:0,w:0.0};}};
case 2474: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2490,w:0.000000};default: return {t:0,w:0.0};}};
case 2475: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2491,w:0.000000};default: return {t:0,w:0.0};}};
case 2476: return function (act:Int) {switch (act) { case 258: return {t:2492,w:0.000000};default: return {t:0,w:0.0};}};
case 2477: return function (act:Int) {switch (act) { case 78: return {t:2493,w:0.693147}; case 110: return {t:2493,w:0.693147};default: return {t:0,w:0.0};}};
case 2478: return function (act:Int) {switch (act) { case 34: return {t:516,w:0.000000}; case 48: return {t:2310,w:2.995732}; case 49: return {t:2310,w:2.995732}; case 50: return {t:2310,w:2.995732}; case 51: return {t:2310,w:2.995732}; case 52: return {t:2310,w:2.995732}; case 53: return {t:2310,w:2.995732}; case 54: return {t:2310,w:2.995732}; case 55: return {t:2310,w:2.995732}; case 56: return {t:2310,w:2.995732}; case 57: return {t:2310,w:2.995732}; case 97: return {t:2311,w:2.484906}; case 98: return {t:2311,w:2.484906}; case 99: return {t:2311,w:2.484906}; case 100: return {t:2311,w:2.484906}; case 101: return {t:2311,w:2.484906}; case 102: return {t:2311,w:2.484906}; case 381: return {t:2468,w:0.000000};default: return {t:0,w:0.0};}};
case 2479: return function (act:Int) {switch (act) { case 256: return {t:2478,w:4000000.750000}; case 538: return {t:2479,w:0.693147}; case 550: return {t:2480,w:0.693147};default: return {t:0,w:0.0};}};
case 2480: return function (act:Int) {switch (act) { case 258: return {t:2494,w:0.000000};default: return {t:0,w:0.0};}};
case 2481: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2495,w:0.000000};default: return {t:0,w:0.0};}};
case 2482: return function (act:Int) {switch (act) { case 534: return {t:2482,w:0.000000};default: return {t:0,w:0.0};}};
case 2483: return function (act:Int) {switch (act) { case 549: return {t:2483,w:0.000000};default: return {t:0,w:0.0};}};
case 2484: return function (act:Int) {switch (act) { case 256: return {t:2496,w:4000000.000000}; case 551: return {t:2497,w:0.000000};default: return {t:0,w:0.0};}};
case 2485: return function (act:Int) {switch (act) { case 258: return {t:2498,w:0.000000};default: return {t:0,w:0.0};}};
case 2486: return function (act:Int) {switch (act) { case 256: return {t:2499,w:4000000.000000}; case 552: return {t:2500,w:0.000000};default: return {t:0,w:0.0};}};
case 2487: return function (act:Int) {switch (act) { case 79: return {t:2501,w:1.791759}; case 82: return {t:2502,w:1.791759}; case 111: return {t:2501,w:1.791759}; case 114: return {t:2502,w:1.791759}; case 256: return {t:2503,w:4000001.000000}; case 553: return {t:2504,w:1.098612};default: return {t:0,w:0.0};}};
case 2488: return function (act:Int) {switch (act) { case 256: return {t:1013,w:4000000.000000}; case 428: return {t:2505,w:0.000000};default: return {t:0,w:0.0};}};
case 2489: return function (act:Int) {switch (act) { case 44: return {t:2506,w:0.693147}; case 256: return {t:2445,w:4000000.750000}; case 550: return {t:2507,w:0.693147};default: return {t:0,w:0.0};}};
case 2490: return function (act:Int) {switch (act) { case 70: return {t:2508,w:1.386294}; case 84: return {t:2509,w:1.386294}; case 102: return {t:2508,w:1.386294}; case 116: return {t:2509,w:1.386294};default: return {t:0,w:0.0};}};
case 2491: return function (act:Int) {switch (act) { case 258: return {t:2510,w:0.000000};default: return {t:0,w:0.0};}};
case 2492: return function (act:Int) {switch (act) { case 520: return {t:2492,w:0.000000};default: return {t:0,w:0.0};}};
case 2493: return function (act:Int) {switch (act) { case 84: return {t:2511,w:0.693147}; case 116: return {t:2511,w:0.693147};default: return {t:0,w:0.0};}};
case 2494: return function (act:Int) {switch (act) { case 548: return {t:2494,w:0.000000};default: return {t:0,w:0.0};}};
case 2495: return function (act:Int) {switch (act) { case 77: return {t:2512,w:1.791759}; case 109: return {t:2512,w:1.791759}; case 256: return {t:812,w:4000001.000000}; case 269: return {t:2513,w:1.098612};default: return {t:0,w:0.0};}};
case 2496: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:2419,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 544: return {t:2514,w:0.000000};default: return {t:0,w:0.0};}};
case 2497: return function (act:Int) {switch (act) { case 258: return {t:2515,w:0.000000};default: return {t:0,w:0.0};}};
case 2498: return function (act:Int) {switch (act) { case 550: return {t:2498,w:0.000000};default: return {t:0,w:0.0};}};
case 2499: return function (act:Int) {switch (act) { case 9: return {t:493,w:2.079441}; case 13: return {t:83,w:2.079441}; case 32: return {t:494,w:2.079441}; case 258: return {t:651,w:0.693147}; case 279: return {t:504,w:2.079441}; case 283: return {t:119,w:2.079441}; case 368: return {t:1291,w:0.000000}; case 376: return {t:505,w:1.386294}; case 377: return {t:506,w:0.693147}; case 378: return {t:2516,w:0.000000};default: return {t:0,w:0.0};}};
case 2500: return function (act:Int) {switch (act) { case 258: return {t:2517,w:0.000000};default: return {t:0,w:0.0};}};
case 2501: return function (act:Int) {switch (act) { case 80: return {t:2518,w:0.693147}; case 112: return {t:2518,w:0.693147};default: return {t:0,w:0.0};}};
case 2502: return function (act:Int) {switch (act) { case 69: return {t:2519,w:0.693147}; case 101: return {t:2519,w:0.693147};default: return {t:0,w:0.0};}};
case 2503: return function (act:Int) {switch (act) { case 33: return {t:2,w:2.397895}; case 37: return {t:3,w:2.397895}; case 39: return {t:4,w:2.397895}; case 42: return {t:5,w:2.397895}; case 43: return {t:6,w:2.397895}; case 45: return {t:7,w:2.397895}; case 46: return {t:8,w:2.397895}; case 48: return {t:9,w:5.799092}; case 49: return {t:9,w:5.799092}; case 50: return {t:9,w:5.799092}; case 51: return {t:9,w:5.799092}; case 52: return {t:9,w:5.799092}; case 53: return {t:9,w:5.799092}; case 54: return {t:9,w:5.799092}; case 55: return {t:9,w:5.799092}; case 56: return {t:9,w:5.799092}; case 57: return {t:9,w:5.799092}; case 65: return {t:13,w:6.754604}; case 66: return {t:13,w:6.754604}; case 67: return {t:13,w:6.754604}; case 68: return {t:13,w:6.754604}; case 69: return {t:13,w:6.754604}; case 70: return {t:13,w:6.754604}; case 71: return {t:13,w:6.754604}; case 72: return {t:13,w:6.754604}; case 73: return {t:13,w:6.754604}; case 74: return {t:13,w:6.754604}; case 75: return {t:13,w:6.754604}; case 76: return {t:13,w:6.754604}; case 77: return {t:13,w:6.754604}; case 78: return {t:13,w:6.754604}; case 79: return {t:13,w:6.754604}; case 80: return {t:13,w:6.754604}; case 81: return {t:13,w:6.754604}; case 82: return {t:13,w:6.754604}; case 83: return {t:13,w:6.754604}; case 84: return {t:13,w:6.754604}; case 85: return {t:13,w:6.754604}; case 86: return {t:13,w:6.754604}; case 87: return {t:13,w:6.754604}; case 88: return {t:13,w:6.754604}; case 89: return {t:13,w:6.754604}; case 90: return {t:13,w:6.754604}; case 95: return {t:18,w:2.397895}; case 96: return {t:19,w:2.397895}; case 97: return {t:20,w:6.754604}; case 98: return {t:20,w:6.754604}; case 99: return {t:20,w:6.754604}; case 100: return {t:20,w:6.754604}; case 101: return {t:20,w:6.754604}; case 102: return {t:20,w:6.754604}; case 103: return {t:20,w:6.754604}; case 104: return {t:20,w:6.754604}; case 105: return {t:20,w:6.754604}; case 106: return {t:20,w:6.754604}; case 107: return {t:20,w:6.754604}; case 108: return {t:20,w:6.754604}; case 109: return {t:20,w:6.754604}; case 110: return {t:20,w:6.754604}; case 111: return {t:20,w:6.754604}; case 112: return {t:20,w:6.754604}; case 113: return {t:20,w:6.754604}; case 114: return {t:20,w:6.754604}; case 115: return {t:20,w:6.754604}; case 116: return {t:20,w:6.754604}; case 117: return {t:20,w:6.754604}; case 118: return {t:20,w:6.754604}; case 119: return {t:20,w:6.754604}; case 120: return {t:20,w:6.754604}; case 121: return {t:20,w:6.754604}; case 122: return {t:20,w:6.754604}; case 126: return {t:22,w:2.397895}; case 268: return {t:29,w:2.397895}; case 269: return {t:2520,w:0.000000};default: return {t:0,w:0.0};}};
case 2504: return function (act:Int) {switch (act) { case 258: return {t:2521,w:0.000000};default: return {t:0,w:0.0};}};
case 2505: return function (act:Int) {switch (act) { case 256: return {t:2393,w:4000000.000000}; case 544: return {t:2522,w:0.000000};default: return {t:0,w:0.0};}};
case 2506: return function (act:Int) {switch (act) { case 256: return {t:2315,w:4000000.000000}; case 539: return {t:2523,w:0.000000};default: return {t:0,w:0.0};}};
case 2507: return function (act:Int) {switch (act) { case 258: return {t:2524,w:0.000000};default: return {t:0,w:0.0};}};
case 2508: return function (act:Int) {switch (act) { case 65: return {t:2525,w:0.693147}; case 97: return {t:2525,w:0.693147};default: return {t:0,w:0.0};}};
case 2509: return function (act:Int) {switch (act) { case 82: return {t:2526,w:0.693147}; case 114: return {t:2526,w:0.693147};default: return {t:0,w:0.0};}};
case 2510: return function (act:Int) {switch (act) { case 537: return {t:2510,w:0.000000};default: return {t:0,w:0.0};}};
case 2511: return function (act:Int) {switch (act) { case 258: return {t:2386,w:0.000000};default: return {t:0,w:0.0};}};
case 2512: return function (act:Int) {switch (act) { case 68: return {t:2527,w:0.693147}; case 100: return {t:2527,w:0.693147};default: return {t:0,w:0.0};}};
case 2513: return function (act:Int) {switch (act) { case 258: return {t:2528,w:0.000000};default: return {t:0,w:0.0};}};
case 2514: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2529,w:0.000000};default: return {t:0,w:0.0};}};
case 2515: return function (act:Int) {switch (act) { case 532: return {t:2515,w:0.000000};default: return {t:0,w:0.0};}};
case 2516: return function (act:Int) {switch (act) { case 258: return {t:2530,w:0.000000};default: return {t:0,w:0.0};}};
case 2517: return function (act:Int) {switch (act) { case 528: return {t:2517,w:0.000000};default: return {t:0,w:0.0};}};
case 2518: return function (act:Int) {switch (act) { case 84: return {t:2531,w:0.693147}; case 116: return {t:2531,w:0.693147};default: return {t:0,w:0.0};}};
case 2519: return function (act:Int) {switch (act) { case 81: return {t:2532,w:0.693147}; case 113: return {t:2532,w:0.693147};default: return {t:0,w:0.0};}};
case 2520: return function (act:Int) {switch (act) { case 258: return {t:2533,w:0.000000};default: return {t:0,w:0.0};}};
case 2521: return function (act:Int) {switch (act) { case 536: return {t:2521,w:0.000000};default: return {t:0,w:0.0};}};
case 2522: return function (act:Int) {switch (act) { case 256: return {t:2534,w:4000000.000000}; case 554: return {t:2535,w:0.000000};default: return {t:0,w:0.0};}};
case 2523: return function (act:Int) {switch (act) { case 44: return {t:2506,w:0.693147}; case 256: return {t:2445,w:4000000.750000}; case 550: return {t:2507,w:0.693147};default: return {t:0,w:0.0};}};
case 2524: return function (act:Int) {switch (act) { case 543: return {t:2524,w:0.000000};default: return {t:0,w:0.0};}};
case 2525: return function (act:Int) {switch (act) { case 76: return {t:2536,w:0.693147}; case 108: return {t:2536,w:0.693147};default: return {t:0,w:0.0};}};
case 2526: return function (act:Int) {switch (act) { case 85: return {t:2537,w:0.693147}; case 117: return {t:2537,w:0.693147};default: return {t:0,w:0.0};}};
case 2527: return function (act:Int) {switch (act) { case 53: return {t:2538,w:0.000000};default: return {t:0,w:0.0};}};
case 2528: return function (act:Int) {switch (act) { case 533: return {t:2528,w:0.000000};default: return {t:0,w:0.0};}};
case 2529: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2539,w:0.000000};default: return {t:0,w:0.0};}};
case 2530: return function (act:Int) {switch (act) { case 552: return {t:2530,w:0.000000};default: return {t:0,w:0.0};}};
case 2531: return function (act:Int) {switch (act) { case 73: return {t:2540,w:0.693147}; case 105: return {t:2540,w:0.693147};default: return {t:0,w:0.0};}};
case 2532: return function (act:Int) {switch (act) { case 85: return {t:2541,w:0.693147}; case 117: return {t:2541,w:0.693147};default: return {t:0,w:0.0};}};
case 2533: return function (act:Int) {switch (act) { case 553: return {t:2533,w:0.000000};default: return {t:0,w:0.0};}};
case 2534: return function (act:Int) {switch (act) { case 47: return {t:1210,w:0.693147}; case 65: return {t:179,w:4.644391}; case 66: return {t:179,w:4.644391}; case 67: return {t:179,w:4.644391}; case 68: return {t:179,w:4.644391}; case 69: return {t:179,w:4.644391}; case 70: return {t:179,w:4.644391}; case 71: return {t:179,w:4.644391}; case 72: return {t:179,w:4.644391}; case 73: return {t:179,w:4.644391}; case 74: return {t:179,w:4.644391}; case 75: return {t:179,w:4.644391}; case 76: return {t:179,w:4.644391}; case 77: return {t:179,w:4.644391}; case 78: return {t:179,w:4.644391}; case 79: return {t:179,w:4.644391}; case 80: return {t:179,w:4.644391}; case 81: return {t:179,w:4.644391}; case 82: return {t:179,w:4.644391}; case 83: return {t:179,w:4.644391}; case 84: return {t:179,w:4.644391}; case 85: return {t:179,w:4.644391}; case 86: return {t:179,w:4.644391}; case 87: return {t:179,w:4.644391}; case 88: return {t:179,w:4.644391}; case 89: return {t:179,w:4.644391}; case 90: return {t:179,w:4.644391}; case 97: return {t:181,w:4.644391}; case 98: return {t:181,w:4.644391}; case 99: return {t:181,w:4.644391}; case 100: return {t:181,w:4.644391}; case 101: return {t:181,w:4.644391}; case 102: return {t:181,w:4.644391}; case 103: return {t:181,w:4.644391}; case 104: return {t:181,w:4.644391}; case 105: return {t:181,w:4.644391}; case 106: return {t:181,w:4.644391}; case 107: return {t:181,w:4.644391}; case 108: return {t:181,w:4.644391}; case 109: return {t:181,w:4.644391}; case 110: return {t:181,w:4.644391}; case 111: return {t:181,w:4.644391}; case 112: return {t:181,w:4.644391}; case 113: return {t:181,w:4.644391}; case 114: return {t:181,w:4.644391}; case 115: return {t:181,w:4.644391}; case 116: return {t:181,w:4.644391}; case 117: return {t:181,w:4.644391}; case 118: return {t:181,w:4.644391}; case 119: return {t:181,w:4.644391}; case 120: return {t:181,w:4.644391}; case 121: return {t:181,w:4.644391}; case 122: return {t:181,w:4.644391}; case 331: return {t:183,w:0.693147}; case 334: return {t:186,w:0.693147}; case 335: return {t:2543,w:0.693147}; case 387: return {t:2542,w:0.693147};default: return {t:0,w:0.0};}};
case 2535: return function (act:Int) {switch (act) { case 256: return {t:2544,w:4000000.750000}; case 278: return {t:2545,w:0.693147}; case 550: return {t:2546,w:0.693147};default: return {t:0,w:0.0};}};
case 2536: return function (act:Int) {switch (act) { case 83: return {t:2547,w:0.693147}; case 115: return {t:2547,w:0.693147};default: return {t:0,w:0.0};}};
case 2537: return function (act:Int) {switch (act) { case 69: return {t:2548,w:0.693147}; case 101: return {t:2548,w:0.693147};default: return {t:0,w:0.0};}};
case 2538: return function (act:Int) {switch (act) { case 45: return {t:2549,w:0.000000}; case 258: return {t:2528,w:0.000000};default: return {t:0,w:0.0};}};
case 2539: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2550,w:0.000000};default: return {t:0,w:0.0};}};
case 2540: return function (act:Int) {switch (act) { case 79: return {t:2551,w:0.693147}; case 111: return {t:2551,w:0.693147};default: return {t:0,w:0.0};}};
case 2541: return function (act:Int) {switch (act) { case 73: return {t:2552,w:0.693147}; case 105: return {t:2552,w:0.693147};default: return {t:0,w:0.0};}};
case 2542: return function (act:Int) {switch (act) { case 258: return {t:2553,w:0.000000};default: return {t:0,w:0.0};}};
case 2543: return function (act:Int) {switch (act) { case 258: return {t:2553,w:0.000000};default: return {t:0,w:0.0};}};
case 2544: return function (act:Int) {switch (act) { case 32: return {t:78,w:0.000000}; case 34: return {t:516,w:0.000000}; case 381: return {t:2468,w:0.000000};default: return {t:0,w:0.0};}};
case 2545: return function (act:Int) {switch (act) { case 256: return {t:2554,w:4000000.750000}; case 278: return {t:2555,w:0.693147}; case 554: return {t:2556,w:0.693147};default: return {t:0,w:0.0};}};
case 2546: return function (act:Int) {switch (act) { case 258: return {t:2557,w:0.000000};default: return {t:0,w:0.0};}};
case 2547: return function (act:Int) {switch (act) { case 69: return {t:2558,w:0.693147}; case 101: return {t:2558,w:0.693147};default: return {t:0,w:0.0};}};
case 2548: return function (act:Int) {switch (act) { case 258: return {t:2559,w:0.000000};default: return {t:0,w:0.0};}};
case 2549: return function (act:Int) {switch (act) { case 83: return {t:2560,w:0.693147}; case 115: return {t:2560,w:0.693147};default: return {t:0,w:0.0};}};
case 2550: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2561,w:0.000000};default: return {t:0,w:0.0};}};
case 2551: return function (act:Int) {switch (act) { case 78: return {t:2562,w:0.693147}; case 110: return {t:2562,w:0.693147};default: return {t:0,w:0.0};}};
case 2552: return function (act:Int) {switch (act) { case 82: return {t:2563,w:0.693147}; case 114: return {t:2563,w:0.693147};default: return {t:0,w:0.0};}};
case 2553: return function (act:Int) {switch (act) { case 554: return {t:2553,w:0.000000};default: return {t:0,w:0.0};}};
case 2554: return function (act:Int) {switch (act) { case 32: return {t:78,w:0.000000}; case 47: return {t:1210,w:0.693147}; case 65: return {t:179,w:4.644391}; case 66: return {t:179,w:4.644391}; case 67: return {t:179,w:4.644391}; case 68: return {t:179,w:4.644391}; case 69: return {t:179,w:4.644391}; case 70: return {t:179,w:4.644391}; case 71: return {t:179,w:4.644391}; case 72: return {t:179,w:4.644391}; case 73: return {t:179,w:4.644391}; case 74: return {t:179,w:4.644391}; case 75: return {t:179,w:4.644391}; case 76: return {t:179,w:4.644391}; case 77: return {t:179,w:4.644391}; case 78: return {t:179,w:4.644391}; case 79: return {t:179,w:4.644391}; case 80: return {t:179,w:4.644391}; case 81: return {t:179,w:4.644391}; case 82: return {t:179,w:4.644391}; case 83: return {t:179,w:4.644391}; case 84: return {t:179,w:4.644391}; case 85: return {t:179,w:4.644391}; case 86: return {t:179,w:4.644391}; case 87: return {t:179,w:4.644391}; case 88: return {t:179,w:4.644391}; case 89: return {t:179,w:4.644391}; case 90: return {t:179,w:4.644391}; case 97: return {t:181,w:4.644391}; case 98: return {t:181,w:4.644391}; case 99: return {t:181,w:4.644391}; case 100: return {t:181,w:4.644391}; case 101: return {t:181,w:4.644391}; case 102: return {t:181,w:4.644391}; case 103: return {t:181,w:4.644391}; case 104: return {t:181,w:4.644391}; case 105: return {t:181,w:4.644391}; case 106: return {t:181,w:4.644391}; case 107: return {t:181,w:4.644391}; case 108: return {t:181,w:4.644391}; case 109: return {t:181,w:4.644391}; case 110: return {t:181,w:4.644391}; case 111: return {t:181,w:4.644391}; case 112: return {t:181,w:4.644391}; case 113: return {t:181,w:4.644391}; case 114: return {t:181,w:4.644391}; case 115: return {t:181,w:4.644391}; case 116: return {t:181,w:4.644391}; case 117: return {t:181,w:4.644391}; case 118: return {t:181,w:4.644391}; case 119: return {t:181,w:4.644391}; case 120: return {t:181,w:4.644391}; case 121: return {t:181,w:4.644391}; case 122: return {t:181,w:4.644391}; case 331: return {t:183,w:0.693147}; case 334: return {t:186,w:0.693147}; case 335: return {t:2543,w:0.693147}; case 387: return {t:2542,w:0.693147};default: return {t:0,w:0.0};}};
case 2555: return function (act:Int) {switch (act) { case 256: return {t:2554,w:4000000.750000}; case 278: return {t:2555,w:0.693147}; case 554: return {t:2556,w:0.693147};default: return {t:0,w:0.0};}};
case 2556: return function (act:Int) {switch (act) { case 256: return {t:2544,w:4000000.750000}; case 278: return {t:2545,w:0.693147}; case 550: return {t:2546,w:0.693147};default: return {t:0,w:0.0};}};
case 2557: return function (act:Int) {switch (act) { case 541: return {t:2557,w:0.000000};default: return {t:0,w:0.0};}};
case 2558: return function (act:Int) {switch (act) { case 258: return {t:2559,w:0.000000};default: return {t:0,w:0.0};}};
case 2559: return function (act:Int) {switch (act) { case 542: return {t:2559,w:0.000000};default: return {t:0,w:0.0};}};
case 2560: return function (act:Int) {switch (act) { case 69: return {t:2564,w:0.693147}; case 101: return {t:2564,w:0.693147};default: return {t:0,w:0.0};}};
case 2561: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2565,w:0.000000};default: return {t:0,w:0.0};}};
case 2562: return function (act:Int) {switch (act) { case 65: return {t:2566,w:0.693147}; case 97: return {t:2566,w:0.693147};default: return {t:0,w:0.0};}};
case 2563: return function (act:Int) {switch (act) { case 69: return {t:2567,w:0.693147}; case 101: return {t:2567,w:0.693147};default: return {t:0,w:0.0};}};
case 2564: return function (act:Int) {switch (act) { case 83: return {t:2568,w:0.693147}; case 115: return {t:2568,w:0.693147};default: return {t:0,w:0.0};}};
case 2565: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2569,w:0.000000};default: return {t:0,w:0.0};}};
case 2566: return function (act:Int) {switch (act) { case 76: return {t:2570,w:0.693147}; case 108: return {t:2570,w:0.693147};default: return {t:0,w:0.0};}};
case 2567: return function (act:Int) {switch (act) { case 68: return {t:2571,w:0.693147}; case 100: return {t:2571,w:0.693147};default: return {t:0,w:0.0};}};
case 2568: return function (act:Int) {switch (act) { case 83: return {t:2572,w:0.693147}; case 115: return {t:2572,w:0.693147};default: return {t:0,w:0.0};}};
case 2569: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2573,w:0.000000};default: return {t:0,w:0.0};}};
case 2570: return function (act:Int) {switch (act) { case 258: return {t:2521,w:0.000000};default: return {t:0,w:0.0};}};
case 2571: return function (act:Int) {switch (act) { case 258: return {t:2521,w:0.000000};default: return {t:0,w:0.0};}};
case 2572: return function (act:Int) {switch (act) { case 258: return {t:2528,w:0.000000};default: return {t:0,w:0.0};}};
case 2573: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2574,w:0.000000};default: return {t:0,w:0.0};}};
case 2574: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2575,w:0.000000};default: return {t:0,w:0.0};}};
case 2575: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2576,w:0.000000};default: return {t:0,w:0.0};}};
case 2576: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2577,w:0.000000};default: return {t:0,w:0.0};}};
case 2577: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2578,w:0.000000};default: return {t:0,w:0.0};}};
case 2578: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2579,w:0.000000};default: return {t:0,w:0.0};}};
case 2579: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2580,w:0.000000};default: return {t:0,w:0.0};}};
case 2580: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2581,w:0.000000};default: return {t:0,w:0.0};}};
case 2581: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2582,w:0.000000};default: return {t:0,w:0.0};}};
case 2582: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2583,w:0.000000};default: return {t:0,w:0.0};}};
case 2583: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2584,w:0.000000};default: return {t:0,w:0.0};}};
case 2584: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2585,w:0.000000};default: return {t:0,w:0.0};}};
case 2585: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2586,w:0.000000};default: return {t:0,w:0.0};}};
case 2586: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2587,w:0.000000};default: return {t:0,w:0.0};}};
case 2587: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2588,w:0.000000};default: return {t:0,w:0.0};}};
case 2588: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2589,w:0.000000};default: return {t:0,w:0.0};}};
case 2589: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2590,w:0.000000};default: return {t:0,w:0.0};}};
case 2590: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2591,w:0.000000};default: return {t:0,w:0.0};}};
case 2591: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2592,w:0.000000};default: return {t:0,w:0.0};}};
case 2592: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2593,w:0.000000};default: return {t:0,w:0.0};}};
case 2593: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2594,w:0.000000};default: return {t:0,w:0.0};}};
case 2594: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2595,w:0.000000};default: return {t:0,w:0.0};}};
case 2595: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2596,w:0.000000};default: return {t:0,w:0.0};}};
case 2596: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2597,w:0.000000};default: return {t:0,w:0.0};}};
case 2597: return function (act:Int) {switch (act) { case 256: return {t:2341,w:4000000.000000}; case 538: return {t:2598,w:0.000000};default: return {t:0,w:0.0};}};
case 2598: return function (act:Int) {switch (act) { case 256: return {t:2445,w:4000000.000000}; case 550: return {t:2599,w:0.000000};default: return {t:0,w:0.0};}};
case 2599: return function (act:Int) {switch (act) { case 258: return {t:2600,w:0.000000};default: return {t:0,w:0.0};}};
case 2600: return function (act:Int) {switch (act) { case 551: return {t:2600,w:0.000000};default: return {t:0,w:0.0};}};
default: return null;
}
}
}
