/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.apache.cassandra.utils.memory.MemtablePool;

public abstract class MemtableAllocator {
    private final SubAllocator onHeap;
    private final SubAllocator offHeap;
    volatile LifeCycle state = LifeCycle.LIVE;
    public static final DataReclaimer NO_OP = new DataReclaimer(){

        @Override
        public DataReclaimer reclaim(Cell cell) {
            return this;
        }

        @Override
        public DataReclaimer reclaimImmediately(Cell cell) {
            return this;
        }

        @Override
        public DataReclaimer reclaimImmediately(DecoratedKey key) {
            return this;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void commit() {
        }
    };

    MemtableAllocator(SubAllocator onHeap, SubAllocator offHeap) {
        this.onHeap = onHeap;
        this.offHeap = offHeap;
    }

    public abstract Cell clone(Cell var1, CFMetaData var2, OpOrder.Group var3);

    public abstract CounterCell clone(CounterCell var1, CFMetaData var2, OpOrder.Group var3);

    public abstract DeletedCell clone(DeletedCell var1, CFMetaData var2, OpOrder.Group var3);

    public abstract ExpiringCell clone(ExpiringCell var1, CFMetaData var2, OpOrder.Group var3);

    public abstract DecoratedKey clone(DecoratedKey var1, OpOrder.Group var2);

    public abstract DataReclaimer reclaimer();

    public SubAllocator onHeap() {
        return this.onHeap;
    }

    public SubAllocator offHeap() {
        return this.offHeap;
    }

    public void setDiscarding() {
        this.state = this.state.transition(LifeCycle.DISCARDING);
        this.onHeap.markAllReclaiming();
        this.offHeap.markAllReclaiming();
    }

    public void setDiscarded() {
        this.state = this.state.transition(LifeCycle.DISCARDED);
        this.onHeap.releaseAll();
        this.offHeap.releaseAll();
    }

    public boolean isLive() {
        return this.state == LifeCycle.LIVE;
    }

    public static final class SubAllocator {
        private final MemtablePool.SubPool parent;
        private volatile long owns;
        private volatile long reclaiming;
        private static final AtomicLongFieldUpdater<SubAllocator> ownsUpdater = AtomicLongFieldUpdater.newUpdater(SubAllocator.class, "owns");
        private static final AtomicLongFieldUpdater<SubAllocator> reclaimingUpdater = AtomicLongFieldUpdater.newUpdater(SubAllocator.class, "reclaiming");

        SubAllocator(MemtablePool.SubPool parent) {
            this.parent = parent;
        }

        void releaseAll() {
            this.parent.released(ownsUpdater.getAndSet(this, 0L));
            this.parent.reclaimed(reclaimingUpdater.getAndSet(this, 0L));
        }

        public void adjust(long size, OpOrder.Group opGroup) {
            if (size <= 0L) {
                this.released(-size);
            } else {
                this.allocate(size, opGroup);
            }
        }

        public void allocate(long size, OpOrder.Group opGroup) {
            assert (size >= 0L);
            while (true) {
                if (this.parent.tryAllocate(size)) {
                    this.acquired(size);
                    return;
                }
                WaitQueue.Signal signal = opGroup.isBlockingSignal(this.parent.hasRoom().register());
                boolean allocated = this.parent.tryAllocate(size);
                if (allocated || opGroup.isBlocking()) {
                    signal.cancel();
                    if (allocated) {
                        this.acquired(size);
                    } else {
                        this.allocated(size);
                    }
                    return;
                }
                signal.awaitUninterruptibly();
            }
        }

        private void allocated(long size) {
            this.parent.allocated(size);
            ownsUpdater.addAndGet(this, size);
        }

        private void acquired(long size) {
            this.parent.acquired(size);
            ownsUpdater.addAndGet(this, size);
        }

        void released(long size) {
            this.parent.released(size);
            ownsUpdater.addAndGet(this, -size);
        }

        void markAllReclaiming() {
            long cur;
            long prev;
            while (!reclaimingUpdater.compareAndSet(this, prev = this.reclaiming, cur = this.owns)) {
            }
            this.parent.reclaiming(cur - prev);
        }

        public long owns() {
            return this.owns;
        }

        public float ownershipRatio() {
            float r = (float)this.owns / (float)this.parent.limit;
            if (Float.isNaN(r)) {
                return 0.0f;
            }
            return r;
        }
    }

    public static interface DataReclaimer {
        public DataReclaimer reclaim(Cell var1);

        public DataReclaimer reclaimImmediately(Cell var1);

        public DataReclaimer reclaimImmediately(DecoratedKey var1);

        public void cancel();

        public void commit();
    }

    static final class LifeCycle
    extends Enum<LifeCycle> {
        public static final /* enum */ LifeCycle LIVE = new LifeCycle();
        public static final /* enum */ LifeCycle DISCARDING = new LifeCycle();
        public static final /* enum */ LifeCycle DISCARDED = new LifeCycle();
        private static final /* synthetic */ LifeCycle[] $VALUES;

        public static LifeCycle[] values() {
            return (LifeCycle[])$VALUES.clone();
        }

        public static LifeCycle valueOf(String name) {
            return Enum.valueOf(LifeCycle.class, name);
        }

        LifeCycle transition(LifeCycle targetState) {
            switch (targetState) {
                case DISCARDING: {
                    assert (this == LIVE);
                    return DISCARDING;
                }
                case DISCARDED: {
                    assert (this == DISCARDING);
                    return DISCARDED;
                }
            }
            throw new IllegalStateException();
        }

        static {
            $VALUES = new LifeCycle[]{LIVE, DISCARDING, DISCARDED};
        }
    }
}

